Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["xTensor",
 FontColor->RGBColor[
  1, 0, 0]]], "Title",ExpressionUUID->"921dfa05-74da-47c6-8a0d-8965082897a4"],

Cell[TextData[StyleBox["Fast abstract tensor computer algebra",
 FontColor->RGBColor[
  0, 0, 1]]], \
"Subtitle",ExpressionUUID->"7dc94c3d-3e3a-48df-a54e-f9e60200022a"],

Cell[TextData[{
 StyleBox["Jos\[EAcute] M. Mart\[IAcute]n-Garc\[IAcute]a\n",
  FontSize->18],
 "(c) 2002-2026, under GPL\n\njose@xact.es\nhttp://www.xact.es/\n\
http://groups.google.com/group/xAct"
}], "Subsubtitle",ExpressionUUID->"90a71547-d8da-40f6-92a1-f9e583a9b5f8"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["0. Info and copyright",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->24,ExpressionUUID->"77ed63e9-78eb-42a9-b7c9-4f9cb7ed6c99"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "(*", "*********************************************************************)"}\
], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}], "*", 
    " ", "0.", " ", "Info", " ", "and", " ", 
    RowBox[{"copyright", " ", "**", "**", "**"}]}], "*****************)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
  "(*", "*********************************************************************)"}\
]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[1]:=",ExpressionUUID->"c66171e4-7741-4bf6-89c9-b4ab43df6452"],

Cell[CellGroupData[{

Cell[BoxData["Today"], "Input",
 CellLabel->"In[2]:=",ExpressionUUID->"8671452c-ab51-43a5-a8e0-81760e4ebcd7"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"\"Sun 28 Dec 2025\""}], 
   RowBox[{"DateObject", "[", 
     RowBox[{
       RowBox[{"{", 
         RowBox[{"2025", ",", "12", ",", "28"}], "}"}], ",", "\"Day\""}], 
     "]"}]},
  "DateObject",
  Editable->False]], "Output",
 CellLabel->"Out[2]=",ExpressionUUID->"7779e8a8-f701-4c6c-8f51-87e0b9614962"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"xAct`xTensor`$Version", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<1.3.0\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"xAct`xTensor`$xPermVersionExpected", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<1.2.4\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}], "}"}]}], 
  ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[3]:=",ExpressionUUID->"13ed265b-a76f-4903-9628-41f1a2da6150"],

Cell[CellGroupData[{

Cell[BoxData["$SessionID"], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"da5ba3ba-f507-445b-a13d-f30f4b87a8da"],

Cell[BoxData["23259875072984391309"], "Output",
 CellLabel->"Out[5]=",ExpressionUUID->"c6f72c37-4e43-4f2a-abbe-667dec790580"]
}, Open  ]],

Cell[CellGroupData[{

Cell["0.0. TODO LIST", \
"Subsection",ExpressionUUID->"b80e4aea-8ea6-4afe-92f1-43201f4afa88"],

Cell[CellGroupData[{

Cell["Soon", \
"Subsubsection",ExpressionUUID->"b3ebb22a-fe27-4ddd-8f10-d474c8309cc5"],

Cell["\<\
- What should we do with SeparateMetric on delta[a,-b] ?
- Index-modifiers and Dagger.
- None of the functions is able to tell that v[a] + v[{a,B}] is wrong.
- Guillaume's suggestions for improved symmetrization. Need computation of \
transversals.
- Suggest the use of Implode / Explode to handle derivatives. Problems with \
derivative-related symmetries and with induced derivatives.
- There are still problems with dim=1. In particular MakeRule[ contracted \
Riemann, Ricci, MetricOn->All ] kills the kernel when defining a covariant \
derivative!
- Perhaps we need another sign variable controlling where we contract the \
orthogonal vector with the n-dim eta/epsilon tensors to get the n-1-dim \
versions.
- Allow multiindex derivative operators. Partially done with CovD[expr, \
CD[-a], PD[-b], ...]. Section on connections not updated.
- Rethink DependenciesOf. How is it possible that DependenciesOfTensor[delta] \
is simpler than DependenciesOfTensor[Basis] if they are the same object in \
principle?
- What about MakeRule and Dagger?
- ChangeCovD[expr, cd1, cd2] does not work if cd1 and cd2 are \"direct-sum \
derivatives\" and cd1 appears in expr with an index of a subvbundle. It is \
just a matter of changing some Q or pmQ functions by IndexOnQ because the \
latter sees subvbundles, but not the former. There is actually much \
redundancy between those functions.
- The simplification algorithms do not see Basis[{-1},a] and Basis[{-1},b] as \
two instances of the same vector.
- Tensors now depend on parameters, but covariant derivatives do not yet. \
This is related to the question of whether parametric derivatives commute \
with covariant derivatives (even ordinary covariant derivatives).
- Analyze why and when do we need pattern indices and which functions must \
act on them.
- Block abstract indices with a Block[Evaluate[Flatten@$AbstractIndices], \
expr] in $Pre. Be careful with C,D,K,N,O.
- Sort indices a11, a2, a$11, a$2, etc correctly. Most importantly, with \
priority \"positional\"/\"antipositional\".
- Patterns in MakeRule should be given both through PatternIndices or as \
actual pattern indices.
- Check consistency of dimensionality with the products of epsilons.
- Rethink the SortCovDs rules to see if they are valid for non-abstract \
indices.
- Do we need to define QFunctionQ[...]? The `Q functions are not recognized \
by Validate.
- Introduce epsilon tensors for the induced metrics.
- Perhaps MathinputExpand is too slow, because it uses FixedPoint.
- Add a definition of FirstDerQ for derivatives with multiple indices in \
Spinors, as suggested by Thomas.
- Bitensors can be imitated by declaring a tensor to depend on two different \
manifolds, assumed to be copies of each other. Every geometrical structured \
must be then duplicated. How can we automatize that idea, without having to \
duplicate everything by hand? In particular, Adam has pointed out that in \
xCoba this becomes odd, because Christoffels are generated complaining that \
they cannot communicate derivatives acting on different manifolds.\
\>", "Text",ExpressionUUID->"d965a5bb-89dd-4275-9cc2-6244ad567c5e"]
}, Closed]],

Cell[CellGroupData[{

Cell["Not soon", \
"Subsubsection",ExpressionUUID->"27d8bcc8-7759-4c99-bc3c-92f5974f312b"],

Cell["\<\
- Introduce the idea of mapping between manifolds, including inmersions. We \
need the concept of vector on a trajectory (e.g. the fourvelocity of a \
particle, or equivalently the tangent to a line). This is related to the \
1-dim manifold problem.
- Algorithm for trace decomposition of a tensor.
- Full compatibilization of Sort priorities and canonicalization
- Encode UserTypeDef
- Unify the different Contract* commands in a single structure. See notebook \
Contractions.nb for tests.
- Possibility of saving a session.
- Encode forms.
- Encode Grassmann variables.
- Inverses.
- We could generalize the concept of inert-head.\
\>", "Text",ExpressionUUID->"4dc49dba-90c8-45c9-995b-213b9aae4449"]
}, Closed]],

Cell[CellGroupData[{

Cell["Questions", \
"Subsubsection",ExpressionUUID->"66de2a99-5606-4633-b90a-1c3c47f26d9d"],

Cell["\<\
- Can we have a Christoffel between a derivative on a manifold M and a \
derivative on a submanifold of M?
- Is it possible to implement antilinear operators with abstract indices? It \
doesn't seem so.
- Is it possible to define constant tensors on the inner vbundle? Is it \
possible to define constant tensors (wrt to all derivatives) at all?\
\>", "Text",ExpressionUUID->"1135f123-7c4c-460b-89c3-dbeafb52e324"]
}, Closed]],

Cell[CellGroupData[{

Cell["Comments", \
"Subsubsection",ExpressionUUID->"cc880019-100b-428f-8e67-5957eac45b0e"],

Cell["\<\
- Parameters are assumed to be real.
- Dagger[x y] is defined to be Dagger[x] Dagger[y]. In general Dagger[f[x,y]] \
is defined Dagger[f][Dagger[x],Dagger[y]].
- The antisymmetric product Wedge is half-developed.
- The idea of modified indices (IModQ) is half-developed.\
\>", "Text",ExpressionUUID->"fa9a3322-407e-4d92-8617-cd46b7a711b6"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["0.1. GPL", \
"Subsection",ExpressionUUID->"e2c82d5d-60dc-4cc2-a4d2-56ff88eacfdc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"xTensor", ",", " ", 
    RowBox[{
    "fast", " ", "abstract", " ", "tensor", " ", "computer", " ", 
     "algebra"}]}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Copyright", " ", 
     RowBox[{"(", "C", ")"}], " ", "2002"}], "-", 
    RowBox[{"2026", " ", "Jose", " ", 
     RowBox[{"M", ".", " ", "Martin"}]}], "-", "Garcia"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "program", " ", "is", " ", "free", " ", "software"}], ";", 
     " ", 
     RowBox[{"you", " ", "can", " ", "redistribute", " ", "it", " ", 
      RowBox[{"and", "/", "or"}], " ", "modify", "\[IndentingNewLine]", " ", 
      "it", " ", "under", " ", "the", " ", "terms", " ", "of", " ", "the", " ",
       "GNU", " ", "General", " ", "Public", " ", "License", " ", "as", " ", 
      "published", "\[IndentingNewLine]", " ", "by", " ", "the", " ", "Free", 
      " ", "Software", " ", "Foundation"}], ";", " ", 
     RowBox[{
     "either", " ", "version", " ", "2", " ", "of", " ", "the", " ", 
      "License"}]}], ",", "\[IndentingNewLine]", "  ", 
    RowBox[{"or", " ", 
     RowBox[{"(", 
      RowBox[{"at", " ", "your", " ", "option"}], ")"}], " ", "any", " ", 
     "later", " ", 
     RowBox[{
     "version", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "This"}], " ",
      "program", " ", "is", " ", "distributed", " ", "in", " ", "the", " ", 
     "hope", " ", "that", " ", "it", " ", "will", " ", "be", " ", "useful"}], 
    ",", "\[IndentingNewLine]", "  ", 
    RowBox[{
     RowBox[{"but", " ", "WITHOUT", " ", "ANY", " ", "WARRANTY"}], ";", " ", 
     RowBox[{
     "without", " ", "even", " ", "the", " ", "implied", " ", "warranty", " ",
       "of", "\[IndentingNewLine]", " ", "MERCHANTABILITY", " ", "or", " ", 
      "FITNESS", " ", "FOR", " ", "A", " ", "PARTICULAR", " ", 
      RowBox[{"PURPOSE", ".", " ", "See"}], " ", "the", " ", "GNU", "\[IndentingNewLine]",
       " ", "General", " ", "Public", " ", "License", " ", "for", " ", "more",
       " ", 
      RowBox[{
      "details", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "You"}], " ",
       "should", " ", "have", " ", "received", " ", "a", " ", "copy", " ", 
      "of", " ", "the", " ", "GNU", " ", "General", " ", "Public", " ", 
      "License", "\[IndentingNewLine]", " ", "along", " ", "with", " ", 
      "this", " ", "program"}], ";", " ", 
     RowBox[{"if", " ", "not"}]}], ",", " ", 
    RowBox[{
    "write", " ", "to", " ", "the", " ", "Free", " ", "Software", "\[IndentingNewLine]",
      " ", "Foundation"}], ",", " ", 
    RowBox[{"Inc", "."}], ",", " ", 
    RowBox[{
     RowBox[{"59", " ", "Temple", " ", "Place"}], "-", 
     RowBox[{"Suite", " ", "330"}]}], ",", " ", "Boston", ",", " ", 
    RowBox[{
     RowBox[{"MA", " ", "02111"}], "-", "1307"}], ",", "\[IndentingNewLine]", 
    "  ", 
    RowBox[{"USA", "."}]}], " ", "\[IndentingNewLine]", "*)"}]}]], "Input",
 InitializationCell->True,
 CellLabel->"In[6]:=",ExpressionUUID->"82bddea8-582c-4022-8587-ba832ada4067"]
}, Closed]],

Cell[CellGroupData[{

Cell["0.2. Info package", \
"Subsection",ExpressionUUID->"dd37ad63-9974-4e2b-9942-c545908e6ba7"],

Cell["\<\
(* :Title: xTensor *)

(* :Author: Jose M. Martin-Garcia *)

(* :Summary: Efficient abstract tensor computer algebra *)

(* :Brief Discussion:
   - Perform generic abstract tensor calculations.
   - Define manifolds, vector bundles, tensors, covariant derivatives and \
metrics.
   - Define symmetries as groups of permutations. Package xPerm.
   - Define Lie derivatives, Lie brackets and variational derivatives.
   - Define constant-symbols, parameters and parametric derivatives.
   - Simplifications: use Portugal's algorithms. Package xPerm.
   - Define bases and charts. Compute components. Package xCoba.
   - Define the concept of tensor equation and tensor rule.
*)
  
(* :Context: xAct`xTensor` *)

(* :Package Version: 1.3.0 *)

(* :Copyright: Jose M. Martin-Garcia (2002-2026) *)

(* :History: see xTensor.History file *)

(* :Keywords: *)

(* :Source: xTensor.nb *)

(* :Warning: *)

(* :Mathematica Version: 6.0 and later *)

(* :Limitations: Many. xTensor knows what its author knows! *)\
\>", "Input",
 PageWidth:>PaperWidth,
 CellMargins->{{60, -272}, {Inherited, Inherited}},
 InitializationCell->True,
 CellLabel->"In[7]:=",ExpressionUUID->"b8d77a9a-4586-4c39-ba8b-fc454f230514"],

Cell[TextData[{
 StyleBox["Four leading rules:", "Subsubsection"],
 "\n\t1. Mathematical structure\n\t2. Compliance with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s way of working\n\t3. Efficiency\n\t4. Simplicity of notations"
}], "Text",ExpressionUUID->"0bf8fed7-37d7-417b-a911-92ae5e7103b3"],

Cell[TextData[{
 StyleBox["Main design decisions:", "Subsubsection"],
 "\n\t1. Mathematical tensor notation: Abstract indices formalism (see \
Penrose&Rindler, Wald, Ashtekar).\n\t2. Input/Output based on ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbols, not on strings. Strings give you more flexibility for notations, \
but you need to develop a syntactic parser, which obstructs the interaction \
of the user and the internals.\n\t3. Organization of the information: we \
shall define expressions denoting objects and functions. The definitions will \
be associated to the heads of the expressions, either as upvalues, ownvalues \
or downvalues. We do not include the properties of the objects as arguments \
in their expressions. Again, it is not possible to associate definitions to \
strings. This rule is relaxed in version 1.0, allowing non-atomic objects in \
some cases.\n\t4. Indexed objects will have the form name[indices]. We do not \
tag objects, due to several reasons:\n\t\ta) Expressions like Tensor[T, \
{A,-B}] are harder to input than T[-A,B]\n\t\tb) The limitation in depth for \
upvalues is greater for tagged objects.\n\t\tc) Even though it is possible to \
have Tensor[T, ...] and Spinor[T, ...], we cannot associated definitions \
consistently to symbol T.\n\t\td) The internals should be simple enough so \
that the users can define new rules without having to use MakeRule and the \
like.\n\t5. Indices are represented in the simplest form I can think of (a \
for an up-index, -a for a down-index). Because there is no tagging for \
indices, we need to define what is an index: it is anything that can be found \
at positions in expressions reserved just for indices (index-slots). \
Currently they are\n\t\ta) tensor[indices]\n\t\tb) covd[index][ expr ] or the \
newer CovD[expr, ___, covd[index], ___]\n\t\tc) inerthead[ expr, ___, \
IndexList[ indices ], ___ ]\n\t\td) product[ expr1, expr2, ... ]\nThis means \
that tensor indices cannot be mixed with other types of arguments in the same \
sequence. This is a strong rule. Note that we cannot combine all of them into \
a single structure. We have at least nonindexedhead[indices] and \
possiblyindexedhead[ indexedexpressions ]. We could try a mixture of\n\t\tA) \
possiblyindexedhead[ indices ] representing the elementary tensors\n\t\tB) \
possiblyindexedhead[ indexedexpressions ] representing the operators on all \
kinds of tensors\nBut the additional arguments of the inert-heads do not fit \
well here. They should have been in the head. Same thing happens with label \
indices.\n\t6. Control of evaluation: most functions in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " evaluate their arguments on input. This is what the user expects. However, \
there are exceptions with those functions that can be used to analyze or \
change the input: for instance FindIndices and ReplaceIndex."
}], "Text",ExpressionUUID->"921b3657-a3e1-4d9f-a6d8-b2c31691381a"]
}, Closed]],

Cell[CellGroupData[{

Cell["0.3. BeginPackage", \
"Subsection",ExpressionUUID->"470428eb-522d-432e-ae18-782ecbc28fdb"],

Cell["Protect against multiple loading of the package:", \
"Text",ExpressionUUID->"564c1fa4-f65b-4e5d-a677-0d9ea97b21be"],

Cell[BoxData[
 RowBox[{
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"xAct`xTensor`Private`xTensorSymbols", "=", 
      RowBox[{"DeleteCases", "[", 
       RowBox[{
        RowBox[{"Join", "[", 
         RowBox[{
          RowBox[{"Names", "[", "\"\<xAct`xTensor`*\>\"", "]"}], ",", 
          RowBox[{"Names", "[", "\"\<xAct`xTensor`Private`*\>\"", "]"}]}], 
         "]"}], ",", 
        RowBox[{"\"\<$Version\>\"", "|", "\"\<xAct`xTensor`$Version\>\"", 
         "|", "\"\<$xPermVersionExpected\>\"", 
         "|", "\"\<xAct`xTensor`$xPermVersionExpected\>\"", 
         "|", "\"\<xAct`xTensor`$ReadingVerbose\>\""}]}], "]"}]}], "}"}], ",",
     "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Unprotect", "/@", "xAct`xTensor`Private`xTensorSymbols"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Clear", "/@", "xAct`xTensor`Private`xTensorSymbols"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[32]:=",ExpressionUUID->"1f10ba4e-5992-44dd-819e-30a32e21a3cd"],

Cell["Last package read in a session:", \
"Text",ExpressionUUID->"85ffe464-2e9b-44f4-9be7-dade8e774462"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Unevaluated", "[", "xAct`xCore`Private`$LastPackage", "]"}], "===",
      "xAct`xCore`Private`$LastPackage"}], ",", 
    RowBox[{
    "xAct`xCore`Private`$LastPackage", "=", "\"\<xAct`xTensor`\>\""}]}], 
   "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[33]:=",ExpressionUUID->"7b1b09fb-b136-4158-b744-884344737087"],

Cell[CellGroupData[{

Cell[BoxData["xAct`xCore`Private`$LastPackage"], "Input",
 CellLabel->"In[34]:=",ExpressionUUID->"84911d8c-84a5-470e-ad2e-b3d4e630d278"],

Cell[BoxData["\<\"xAct`xTensor`\"\>"], "Output",
 CellLabel->
  "Out[34]=",ExpressionUUID->"911c5048-caf9-4602-9f6f-98df3fe5f0e8"]
}, Open  ]],

Cell[TextData[{
 "Fix for the conflict with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 9:"
}], "Text",ExpressionUUID->"06b2b77c-917d-4222-8202-1420482bc214"],

Cell[BoxData[{
 RowBox[{"xAct`xTensor`Symmetrize", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"System`Symmetrize", "::", "shdw"}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[35]:=",ExpressionUUID->"bdc84d6e-c3f5-4dfd-baf1-21fa2d45cfc1"],

Cell[TextData[{
 "Fix for the conflicts with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 14.3:"
}], "Text",ExpressionUUID->"49f8397a-73e8-401e-8fdd-b52b9a0cfcc9"],

Cell[BoxData[{
 RowBox[{"xAct`xTensor`Commutator", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"System`Commutator", "::", "shdw"}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[37]:=",ExpressionUUID->"475964b4-338d-41cd-85ba-54eaec0eacc5"],

Cell[BoxData[{
 RowBox[{"xAct`xTensor`Anticommutator", ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"System`Anticommutator", "::", "shdw"}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[39]:=",ExpressionUUID->"0e3bdd1d-fff6-47eb-8729-b23ff39af18f"],

Cell[TextData[{
 "Explicit (not hidden) import of ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 ",  ",
 StyleBox["xPerm",
  FontSlant->"Italic"],
 " and ",
 StyleBox["ExpressionManipulation",
  FontSlant->"Italic"],
 " (the latter is not automatically read from version 0.6.2 of ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 "):"
}], "Text",ExpressionUUID->"c41cf39e-33c1-4e47-bc46-f50b1098d60c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BeginPackage", "[", 
  RowBox[{"\"\<xAct`xTensor`\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<xAct`xCore`\>\"", ",", "\"\<xAct`xPerm`\>\""}], "}"}]}], 
  "]"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[41]:=",ExpressionUUID->"ea5a0555-74e7-47c8-8c7e-db6a41c44d1d"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"26f0e5a0-3dc6-4917-967a-527c8e9389ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.4\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.4", ", ", {2025, 12, 29}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"3008527f-6020-4b2a-a9f2-b6bf7da5cb21"],

Cell[BoxData["\<\"CopyRight (C) 2003-2026, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"638a4e89-6783-41b7-ada7-50913338ce5c"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"0a9ec3c7-4e98-4cbf-afcb-2b94b735f4d5"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[41]:=",ExpressionUUID->"3225c75a-f3a2-4a03-b315-b18f1095bb3b"]
}, Open  ]],

Cell[BoxData["\<\"xAct`xTensor`\"\>"], "Output",
 CellLabel->
  "Out[41]=",ExpressionUUID->"4ca6456c-36c3-4448-978d-8976871b6160"]
}, Open  ]],

Cell["Information on the link to xperm.c:", \
"Text",ExpressionUUID->"807456e4-7231-43da-abaf-01869870b1f6"],

Cell[CellGroupData[{

Cell[BoxData["$xpermExecutable"], "Input",
 CellLabel->"In[42]:=",ExpressionUUID->"8ca40f8c-19e6-4629-8002-8fdf87c53420"],

Cell[BoxData["\<\"/Users/jose/Library/Wolfram/Applications/xAct//xPerm/\
mathlink/xperm.mac\"\>"], "Output",
 CellLabel->
  "Out[42]=",ExpressionUUID->"b02730cb-6472-4dfb-9fbb-07e399391c53"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$xpermLink"], "Input",
 CellLabel->"In[43]:=",ExpressionUUID->"f5083ea0-39e9-4a38-a4d2-d33ec284da53"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["LinkObject",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False, Typeset`embedState$$ = "Ready"}, 
    
    TemplateBox[{
      PaneSelectorBox[{False -> GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxOpener"], 
               ImageSizeCache -> {10.6984921875, {0., 10.6984921875}}], 
              Appearance -> None, BaseStyle -> {}, 
              ButtonFunction :> (Typeset`open$$ = True), Evaluator -> 
              Automatic, Method -> "Preemptive"], 
             Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[{
              Thickness[0.038461538461538464`], {
               FaceForm[{
                 GrayLevel[0.93], 
                 Opacity[1.]}], 
               
               FilledCurveBox[{{{1, 4, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
                1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}}}, {{{
                25.499999999999996`, 2.5}, {25.499999999999996`, 
                1.3953100000000003`}, {24.604699999999998`, 
                0.49999999999999994`}, {23.5, 0.49999999999999994`}, {2.5, 
                0.49999999999999994`}, {1.3953100000000003`, 
                0.49999999999999994`}, {0.49999999999999994`, 
                1.3953100000000003`}, {0.49999999999999994`, 2.5}, {
                0.49999999999999994`, 23.5}, {0.49999999999999994`, 
                24.604699999999998`}, {1.3953100000000003`, 
                25.499999999999996`}, {2.5, 25.499999999999996`}, {23.5, 
                25.499999999999996`}, {24.604699999999998`, 
                25.499999999999996`}, {25.499999999999996`, 
                24.604699999999998`}, {25.499999999999996`, 23.5}, {
                25.499999999999996`, 2.5}}}]}, {
               FaceForm[{
                 RGBColor[0.5, 0.5, 0.5], 
                 Opacity[1.]}], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{20.5426, 
                19.116799999999998`}, {16.3832, 21.876199999999997`}, {
                16.3832, 20.021499999999996`}, {6.930469999999999, 
                20.021499999999996`}, {6.930469999999999, 
                18.212100000000003`}, {16.3832, 18.212100000000003`}, {
                16.3832, 16.357399999999995`}, {20.5426, 
                19.116799999999998`}}}], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{5.30508, 13.8391}, {
                9.46445, 11.079700000000003`}, {9.46445, 
                12.933999999999997`}, {18.917199999999998`, 
                12.933999999999997`}, {18.917199999999998`, 14.7438}, {
                9.46445, 14.7438}, {9.46445, 16.598}, {5.30508, 13.8391}}}], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{5.30508, 13.8391}, {
                9.46445, 11.079700000000003`}, {9.46445, 
                12.933999999999997`}, {18.917199999999998`, 
                12.933999999999997`}, {18.917199999999998`, 14.7438}, {
                9.46445, 14.7438}, {9.46445, 16.598}, {5.30508, 13.8391}}}], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
                0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0,
                 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIRIGYC4sIjUTVcAooO8+XdOPpnKDg8YkwNXuen7JA2
W/qycJSgw5sbHEde31CB82PFhGf3n1V1aFVgVz0zR8oBrF9czWFHsFXE/9Wy
Dje0Dj4qiFWDy7cVLYptDVKH65/g6Xbu0HMNOB9sn4I23H6w+SWacD5De8DS
tDQNB7ldC/alskg4aD2+nx6joeFgnPFi/oMZog5B9vlaQa/UHao9k7f0KUhA
+D/UUPVbqML5jCB+oIpDzJHypGv8Eg4eGad3ikiqwM2T57H5LndPGW6eya7m
GzMvKcH1o4cXABG3d/Y=
                "]], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}}}, {{{14.163129999999999`, 
                4.337966249999999}, {16.96813, 4.337966249999999}, {16.96813, 
                5.047809999999999}, {14.98813, 5.047809999999999}, {14.98813, 
                8.29796625}, {14.163129999999999`, 8.29796625}, {
                14.163129999999999`, 4.337966249999999}}}]}}, AspectRatio -> 
             1, Axes -> False, Background -> GrayLevel[0.93], Frame -> True, 
             FrameStyle -> Directive[
               Thickness[Tiny], 
               GrayLevel[0.7]], FrameTicks -> None, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  StyleBox[
                   PaneBox[
                   "\"'/Users/jose/Library/Wolfram/Applications/xAct//xPerm/\
mathlink/xperm.mac'\"", BaselinePosition -> Baseline, ContentPadding -> False,
                     FrameMargins -> 0, ImageSize -> {{1, 300}, Automatic}, 
                    ScrollPosition -> {0., 0.}, StripOnInput -> True], 
                   LineBreakWithin -> False], "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Link mode: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["Listen", "SummaryItem"]}]}}, AutoDelete -> False, 
             BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{2}}, "Rows" -> {{Automatic}}}]}}, AutoDelete -> 
          False, BaselinePosition -> {1, 1}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], True -> 
        GridBox[{{
            PaneBox[
             ButtonBox[
              DynamicBox[
               FEPrivate`FrontEndResource["FEBitmaps", "SummaryBoxCloser"]], 
              Appearance -> None, BaseStyle -> {}, 
              ButtonFunction :> (Typeset`open$$ = False), Evaluator -> 
              Automatic, Method -> "Preemptive"], 
             Alignment -> {Center, Center}, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GraphicsBox[{
              Thickness[0.038461538461538464`], {
               FaceForm[{
                 GrayLevel[0.93], 
                 Opacity[1.]}], 
               
               FilledCurveBox[{{{1, 4, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}, {
                1, 3, 3}, {0, 1, 0}, {1, 3, 3}, {0, 1, 0}}}, {{{
                25.499999999999996`, 2.5}, {25.499999999999996`, 
                1.3953100000000003`}, {24.604699999999998`, 
                0.49999999999999994`}, {23.5, 0.49999999999999994`}, {2.5, 
                0.49999999999999994`}, {1.3953100000000003`, 
                0.49999999999999994`}, {0.49999999999999994`, 
                1.3953100000000003`}, {0.49999999999999994`, 2.5}, {
                0.49999999999999994`, 23.5}, {0.49999999999999994`, 
                24.604699999999998`}, {1.3953100000000003`, 
                25.499999999999996`}, {2.5, 25.499999999999996`}, {23.5, 
                25.499999999999996`}, {24.604699999999998`, 
                25.499999999999996`}, {25.499999999999996`, 
                24.604699999999998`}, {25.499999999999996`, 23.5}, {
                25.499999999999996`, 2.5}}}]}, {
               FaceForm[{
                 RGBColor[0.5, 0.5, 0.5], 
                 Opacity[1.]}], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{20.5426, 
                19.116799999999998`}, {16.3832, 21.876199999999997`}, {
                16.3832, 20.021499999999996`}, {6.930469999999999, 
                20.021499999999996`}, {6.930469999999999, 
                18.212100000000003`}, {16.3832, 18.212100000000003`}, {
                16.3832, 16.357399999999995`}, {20.5426, 
                19.116799999999998`}}}], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{5.30508, 13.8391}, {
                9.46445, 11.079700000000003`}, {9.46445, 
                12.933999999999997`}, {18.917199999999998`, 
                12.933999999999997`}, {18.917199999999998`, 14.7438}, {
                9.46445, 14.7438}, {9.46445, 16.598}, {5.30508, 13.8391}}}], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{5.30508, 13.8391}, {
                9.46445, 11.079700000000003`}, {9.46445, 
                12.933999999999997`}, {18.917199999999998`, 
                12.933999999999997`}, {18.917199999999998`, 14.7438}, {
                9.46445, 14.7438}, {9.46445, 16.598}, {5.30508, 13.8391}}}], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
                0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0,
                 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}}}, CompressedData["
1:eJxTTMoPSmVmYGBgBGIRIGYC4sIjUTVcAooO8+XdOPpnKDg8YkwNXuen7JA2
W/qycJSgw5sbHEde31CB82PFhGf3n1V1aFVgVz0zR8oBrF9czWFHsFXE/9Wy
Dje0Dj4qiFWDy7cVLYptDVKH65/g6Xbu0HMNOB9sn4I23H6w+SWacD5De8DS
tDQNB7ldC/alskg4aD2+nx6joeFgnPFi/oMZog5B9vlaQa/UHao9k7f0KUhA
+D/UUPVbqML5jCB+oIpDzJHypGv8Eg4eGad3ikiqwM2T57H5LndPGW6eya7m
GzMvKcH1o4cXABG3d/Y=
                "]], 
               
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                0, 1, 0}, {0, 1, 0}}}, {{{14.163129999999999`, 
                4.337966249999999}, {16.96813, 4.337966249999999}, {16.96813, 
                5.047809999999999}, {14.98813, 5.047809999999999}, {14.98813, 
                8.29796625}, {14.163129999999999`, 8.29796625}, {
                14.163129999999999`, 4.337966249999999}}}]}}, AspectRatio -> 
             1, Axes -> False, Background -> GrayLevel[0.93], Frame -> True, 
             FrameStyle -> Directive[
               Thickness[Tiny], 
               GrayLevel[0.7]], FrameTicks -> None, ImageSize -> 
             Dynamic[{
               Automatic, 
                3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], 
            GridBox[{{
               RowBox[{
                 TagBox["\"Name: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox[
                  PaneBox[
                  "\"'/Users/jose/Library/Wolfram/Applications/xAct//xPerm/\
mathlink/xperm.mac'\"", BaselinePosition -> Baseline, ContentPadding -> False,
                    FrameMargins -> 0, ImageSize -> {{1, 500}, Automatic}, 
                   StripOnInput -> True], "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Link mode: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["Listen", "SummaryItem"]}]}, {
               RowBox[{
                 TagBox["\"Link protocol: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"SharedMemory\"", "SummaryItem"]}]}}, AutoDelete -> 
             False, BaseStyle -> {
              ShowStringCharacters -> False, NumberMarks -> False, 
               PrintPrecision -> 3, ShowSyntaxStyles -> False}, 
             GridBoxAlignment -> {
              "Columns" -> {{Left}}, "Rows" -> {{Automatic}}}, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {
              "Columns" -> {{2}}, "Rows" -> {{Automatic}}}]}}, AutoDelete -> 
          False, BaselinePosition -> {1, 1}, 
          GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
          GridBoxItemSize -> {
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]}, 
       Dynamic[Typeset`open$$], ImageSize -> Automatic]},
     "SummaryPanel"],
    DynamicModuleValues:>{}], "]"}],
  LinkObject[
  "'/Users/jose/Library/Wolfram/Applications/xAct//xPerm/mathlink/xperm.mac'",
    453, 15],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 CellLabel->
  "Out[43]=",ExpressionUUID->"41fe0548-26aa-4bde-a47b-7b4f1a5c4222"]
}, Open  ]],

Cell[TextData[{
 "Check version of ",
 StyleBox["xPerm",
  FontSlant->"Italic"],
 ". We simply compare dates:"
}], "Text",ExpressionUUID->"f5ab3c96-5e95-465c-95d9-764657bc176a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"Not", "@", 
     RowBox[{"OrderedQ", "@", 
      RowBox[{"Map", "[", 
       RowBox[{"Last", ",", 
        RowBox[{"{", 
         RowBox[{"$xPermVersionExpected", ",", "xAct`xPerm`$Version"}], 
         "}"}]}], "]"}]}]}], ",", 
    RowBox[{"Throw", "@", 
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"General", "::", "versions"}], ",", "\"\<xPerm\>\"", ",", 
       "xAct`xPerm`$Version", ",", "$xPermVersionExpected"}], "]"}]}]}], 
   "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[44]:=",ExpressionUUID->"95f94d38-66a9-45c9-87d7-790c8dbc2ea9"],

Cell["Message:", \
"Text",ExpressionUUID->"6800b98e-e924-44f3-888d-3229a49783b0"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Package xAct`xTensor` version \>\"", ",", 
    RowBox[{"xAct`xTensor`$Version", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<, \>\"", ",", 
    RowBox[{"xAct`xTensor`$Version", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
  "Print", "[", "\"\<CopyRight (C) 2002-2026, Jose M. Martin-Garcia, under \
the General Public License.\>\"", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"efdcaf97-33a0-47ba-b1d4-f25baae04d46"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[52]:=",ExpressionUUID->"3912e7f8-771d-499a-af53-f8fe750f8fb7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.3.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.3.0", ", ", {2025, 12, 29}],
  Editable->False]], "Print",
 CellLabel->
  "During evaluation of \
In[52]:=",ExpressionUUID->"e0a4b0e8-52a8-4e69-94a3-f328136c407a"],

Cell[BoxData["\<\"CopyRight (C) 2002-2026, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[52]:=",ExpressionUUID->"2bff98c1-228b-451f-9119-0eb507125a47"]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 "We specify the context xAct`xTensor` to avoid overriding the Disclaimer of ",
 StyleBox["xPerm",
  FontSlant->"Italic"],
 " and ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 ".",
 " However we need to turn off the message General:shdw temporarily:"
}], "Text",ExpressionUUID->"66f63bbc-ca9b-48f7-99f3-c8283f902593"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Off", "[", 
   RowBox[{"General", "::", "shdw"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xAct`xTensor`Disclaimer", "[", "]"}], ":=", 
   RowBox[{
   "Print", "[", "\"\<These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\>\"", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"On", "[", 
   RowBox[{"General", "::", "shdw"}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellLabel->"In[48]:=",ExpressionUUID->"fb9600a4-5c04-4587-9baa-365f62227c45"],

Cell[TextData[{
 "If ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " is the last package begin read, print the GPL message:"
}], "Text",ExpressionUUID->"ba5906b1-ceb6-402a-b712-2f6bc39859e5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
    "xAct`xCore`Private`$LastPackage", "===", "\"\<xAct`xTensor`\>\""}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Unset", "[", "xAct`xCore`Private`$LastPackage", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
     "Print", "[", "\"\<These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\>\"", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 InitializationCell->True,
 CellLabel->"In[51]:=",ExpressionUUID->"8fc118c3-e677-49d5-b400-f8d11374ad91"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[51]:=",ExpressionUUID->"e1b790e9-1ea2-4d11-b889-b10249061aba"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[51]:=",ExpressionUUID->"be91781e-aeed-4665-8542-2ba3ab70bb9d"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",
 CellLabel->
  "During evaluation of \
In[51]:=",ExpressionUUID->"2a40c6d8-0081-4ab6-b21c-335c7b831521"]
}, Open  ]]
}, Open  ]],

Cell["We already have these symbols in the xTensor` context:", \
"Text",ExpressionUUID->"33736c60-d026-4bb7-92d3-1454c064326a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "xAct`xTensor`*"}]], "Input",
 CellLabel->"In[55]:=",ExpressionUUID->"5aefff87-b8d3-4115-8a8a-1bd52fb0e730"],

Cell[BoxData[
 StyleBox[
  FrameBox[GridBox[{
     {
      DynamicModuleBox[{Typeset`open$$ = True}, 
       PaneSelectorBox[{False->
        ButtonBox[
         RowBox[{
          
          DynamicBox[FEPrivate`FrontEndResource[
           "FEBitmaps", "RightPointerOpener"]], " ", 
          StyleBox["xAct`xTensor`", "InformationGridGroupHeader"]}],
         Appearance->None,
         BaseStyle->"InformationGridLink",
         ButtonFunction:>FEPrivate`Set[Typeset`open$$, True],
         Evaluator->Automatic,
         Method->"Preemptive"], True->
        PaneBox[GridBox[{
           {
            ButtonBox[
             RowBox[{
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {2.134033203125, 7.865966796875}}], " ", 
              
              StyleBox["xAct`xTensor`", "InformationGridGroupHeader"]}],
             Appearance->None,
             BaseStyle->"InformationGridLink",
             ButtonFunction:>FEPrivate`Set[Typeset`open$$, False],
             Evaluator->Automatic,
             Method->"Preemptive"]},
           {
            PaneBox[GridBox[{
               {
                ButtonBox[
                 StyleBox["Anticommutator", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-2eb5b067-7e79-4543-98b8-9b0ecc45f2b0", {
                   "Anticommutator", "xAct`xTensor`"}, False},
                 ButtonNote->"xAct`xTensor`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["Disclaimer", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-2eb5b067-7e79-4543-98b8-9b0ecc45f2b0", {
                   "Disclaimer", "xAct`xTensor`"}, False},
                 ButtonNote->"xAct`xTensor`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$Version", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-2eb5b067-7e79-4543-98b8-9b0ecc45f2b0", {
                   "$Version", "xAct`xTensor`"}, False},
                 ButtonNote->"xAct`xTensor`",
                 Evaluator->Automatic]},
               {
                ButtonBox[
                 StyleBox["Commutator", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-2eb5b067-7e79-4543-98b8-9b0ecc45f2b0", {
                   "Commutator", "xAct`xTensor`"}, False},
                 ButtonNote->"xAct`xTensor`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["Symmetrize", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-2eb5b067-7e79-4543-98b8-9b0ecc45f2b0", {
                   "Symmetrize", "xAct`xTensor`"}, False},
                 ButtonNote->"xAct`xTensor`",
                 Evaluator->Automatic], 
                ButtonBox[
                 StyleBox["$xPermVersionExpected", "InformationGridButton"],
                 Appearance->None,
                 BaseStyle->"InformationGridLink",
                 
                 ButtonData:>{
                  "Info-2eb5b067-7e79-4543-98b8-9b0ecc45f2b0", {
                   "$xPermVersionExpected", "xAct`xTensor`"}, False},
                 ButtonNote->"xAct`xTensor`",
                 Evaluator->Automatic]}
              },
              DefaultBaseStyle->"Text",
              
              GridBoxAlignment->{
               "Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
              GridBoxItemSize->{"Columns" -> {{
                   Scaled[0.31666666666666665`]}}}],
             ImageMargins->{{10, 0}, {0, 2}}]}
          },
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}}],
         FrameMargins->{{0, 0}, {8, 0}}]}, Dynamic[Typeset`open$$],
        ImageSize->Automatic]]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxDividers->{"ColumnsIndexed" -> {{False}}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.8]}, 
        Offset[0.2]}}],
   BaseStyle->"InformationTitleFrame"], "InformationGridPlain"]], "Output",
 CellLabel->
  "Out[55]=",ExpressionUUID->"edd55c5e-70c6-4a33-860e-e4276e06574c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "0.4. Bases and charts. Relation with ",
 StyleBox["xCoba",
  FontSlant->"Italic"]
}], "Subsection",ExpressionUUID->"7103db06-bacf-468f-8389-b10550cb3068"],

Cell[TextData[{
 "Almost everything related to bases and charts should go into ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 ". However there are a few things that I want to treat here in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ", and this section is a description of them."
}], "Text",ExpressionUUID->"ca77feb0-8d34-4649-9911-172cd97c9588"],

Cell[TextData[{
 "The single most important thing is the manipulation of basis-indices and \
component-indices (bc-indices in the following). These types of indices are \
considered in most sections of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ", but of course section 5 on notations and section 8 on formatting are the \
most important cases. I want to keep all those additional definitions for \
bc-indices in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 "; otherwise half of the definitions on identifications and formatting would \
go into ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " and the other half into ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 ", with a large risk of developing inconsistencies. Those parts of the code \
working with bc-indices in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " have been marked with the word BASIS. Currently there are two alternative \
notations for basis indices, denoted with BASIS1 and BASIS2 (mostly \
controlled through IMOD definitions). A second important issue is that of \
densities: most of it is included in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ": functions WeightOf, WeightOfTensor and metric determinants. However, the \
general concept of determinant and the eta tensors are in ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 ".\n\nFunctions in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " having influence on bases and charts:\n\t- BasisQ and ChartQ are the \
symbol-type identification functions. Associated global variables: $Bases and \
$Charts\n\t- BIndexQ, CIndexQ and BCIndexQ\n\t- CIndexForm, $CIndexForm\n\
Functions in ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 " which are used in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ", but already with xAct`xCoba` context:\n\t- xAct`xCoba`VBundleOfBasis is \
used to find out the vbundle of c-indices\n\t- xAct`xCoba`CNumbersOf[basis] \
is used in CIndexQ\n\t- xAct`xCoba`BasisColor is used in the formatting \
routines\n\t- xAct`xCoba`DefBasis and xAct`xCoba`DefChart\n\t- \
xAct`xCoba`UndefBasis and xAct`xCoba`UndefChart are called by Undef\n\t- \
xAct`xCoba`DaggerCIndex\n\t- xAct`xCoba`Private`DaggerBIndex\n\t- \
xAct`xCoba`DependenciesOfBasis\n\t- xAct`xCoba`PDOfBasis\n\t- \
xAct`xCoba`BasisOfCovD\n\t- xAct`xCoba`Coordinate is used by CIndexForm"
}], "Text",ExpressionUUID->"d614eff1-6ef7-4c9d-b08c-7d456e7f7c4c"],

Cell["We declare the symbols here:", \
"Text",ExpressionUUID->"dc67ae1d-5e2f-4e64-b83f-0a6a29090830"],

Cell[BoxData[{
 RowBox[{"xAct`xCoba`DefBasis", ";"}], "\[IndentingNewLine]", 
 RowBox[{"xAct`xCoba`UndefBasis", ";"}], "\[IndentingNewLine]", 
 RowBox[{"xAct`xCoba`DefChart", ";"}], "\[IndentingNewLine]", 
 RowBox[{"xAct`xCoba`UndefChart", ";"}], "\[IndentingNewLine]", 
 RowBox[{"xAct`xCoba`DependenciesOfBasis", ";"}], "\[IndentingNewLine]", 
 RowBox[{"xAct`xCoba`DaggerCIndex", ";"}], "\[IndentingNewLine]", 
 RowBox[{"xAct`xCoba`Private`DaggerBIndex", ";"}], "\[IndentingNewLine]", 
 RowBox[{"xAct`xCoba`VBundleOfBasis", ";"}], "\[IndentingNewLine]", 
 RowBox[{"xAct`xCoba`CNumbersOf", ";"}], "\[IndentingNewLine]", 
 RowBox[{"xAct`xCoba`Coordinate", ";"}], "\[IndentingNewLine]", 
 RowBox[{"xAct`xCoba`BasisColor", ";"}], "\[IndentingNewLine]", 
 RowBox[{"xAct`xCoba`PDOfBasis", 
  ";"}]}], "Input",ExpressionUUID->"dbafd5d7-a8df-42e4-bf02-98c099213725"]
}, Closed]],

Cell[CellGroupData[{

Cell["0.5. Bad decisions in xTensor. Too late to change them", \
"Subsection",ExpressionUUID->"b259fe80-f714-41c9-bcd0-d3d2211d5034"],

Cell[TextData[{
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ", and actually most of ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 ", has grown organically, as my own needs first and then the needs of other \
authors required. Some decisions were originally made without taking into \
account future extensions, and have been later found to be inconvenient. But \
now they are too deeply ingrained in the system, and would be too much work \
for me (and too much hassle for the users) to change them, at least in many \
cases. Here there is a list of the main things, in order of importance:\n\n\t\
1) The CD[-a][ expr ] notation for covariant derivatives is inconvenient in \
output. This has been partially alleviated by TensorDerivative, but the \
former remains as the standard.\n\t\n\t2) The asymmetry between the syntax of \
upper and lower indices.\n\t\n\t3) We are too restrictive asking for objects \
being symbols. This is being progressively relaxed, and it is not true \
anymore for the two main types: Tensor and CovD.\n\t\n\t4) Label indices are \
absurd. Their information should have been in the tensor head.\n\t\n\t5) \
There is no indexed zero tensor, and so rank information is lost during some \
computations. We have recently added Zero, but we only use it in internal \
computations.\n\t\n\t6) We assign to vbundles properties that are really of \
their fibers (vspaces), like dimension."
}], "Text",ExpressionUUID->"6c714df6-09cc-405f-b96e-93cc646a93a5"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["1. Usage messages",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->24,ExpressionUUID->"2fdf6f8f-7527-4436-9db3-559a887a5ae8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "(*", "*********************************************************************)"}\
], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "**", "**", "**", "**", "**", "**", "**", "**", "**", " ", "1."}], " ", 
     "Symbols"}], ",", " ", 
    RowBox[{"names", " ", "and", " ", "messages"}]}], " ", 
   "*******************)"}], "\[IndentingNewLine]", 
  RowBox[{
  "(*", "*********************************************************************)"}\
]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fcfd6d04-ed7e-48e7-93f7-e3509d27646d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TimeUsed", "[", "]"}], ",", 
   RowBox[{"SessionTime", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"TimeUsed", "[", "]"}], "/", 
    RowBox[{"SessionTime", "[", "]"}]}]}], 
  "}"}]], "Input",ExpressionUUID->"15f36169-62d2-4232-87b6-ed453326aeda"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.510812`", ",", "196.190825`8.744223686932143", ",", 
   "0.02808919478150994`"}], 
  "}"}]], "Output",ExpressionUUID->"5851521f-3419-448c-bcf2-0a3c5e339c2e"]
}, Open  ]],

Cell[CellGroupData[{

Cell["1.0. Comments", \
"Subsection",ExpressionUUID->"0b652672-d0a7-4205-99d3-4d323b279486"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"$ReadingVerbose", ",", 
   RowBox[{"Print", "[", "\"\<Reading section 1: Usage messages.\>\"", "]"}], 
   ",", "Null", ",", "Null"}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"5f63f07b-b64c-41b5-b7e6-e6696db487f4"],

Cell["\<\
This section simply decides which functions are public and which are not. The \
usage messages of private functions are not included in the package.\
\>", "Text",ExpressionUUID->"2708cb91-8057-475d-ba32-1e257e094694"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1. Usage of functions. Public", \
"Subsection",ExpressionUUID->"b4298243-4cd3-43e1-9bec-d6f22ecb8f44"],

Cell[CellGroupData[{

Cell["1.1.0. Info and copyright", \
"Subsubsection",ExpressionUUID->"77d9d484-4950-434d-88dc-57beeec041d9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Versions", " ", "and", " ", "GPL", " ", "disclaimer"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"xAct`xTensor`$Version", "::", "usage"}], 
     "=", "\"\<$Version is a global variable giving the version of the \
package xTensor in use.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "xAct`xTensor`$xPermVersionExpected", 
     "=", "\"\<$xPermVersionExpected is a global variable giving the oldest \
possible version of the package xPerm which is required by the version of the \
package xTensor in use.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xAct`xTensor`Disclaimer", "::", "usage"}], 
     "=", "\"\<Disclaimer[] gives the General Public License (GPL) disclaimer \
message.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"74631bce-6b1d-4294-949a-b2c1a5e23caa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Verbose", " ", "while", " ", "reading", " ", "the", " ", 
    RowBox[{"package", "?"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"xAct`xTensor`$ReadingVerbose", "::", "usage"}], 
    "=", "\"\<$ReadingVerbose is a Boolean global variable that turns on \
log-messages while the xTensor package is being read. By default it is not \
set.\>\""}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f5068105-90ab-420b-ace7-c34284d3bdcc"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1.2. Types. Conventions and signs", \
"Subsubsection",ExpressionUUID->"0cbac22f-415f-4e17-979e-4cfd22bae02a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Generic", " ", "options", " ", "in", " ", "Def", " ", "commands"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"$ProtectNewSymbols", "::", "usage"}], 
     "=", "\"\<$ProtectNewSymbols is a Boolean global variable specifying the \
default value for the option ProtectNewSymbol of all DefType commands. The \
default initial value is False.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ProtectNewSymbol", "::", "usage"}], 
     "=", "\"\<ProtectNewSymbol is a Boolean option for all DefType commands \
that specifies whether the defined symbol will be protected or not. The \
default value is given by the global variable $ProtectNewSymbols.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DefInfo", "::", "usage"}], 
     "=", "\"\<DefInfo is an option for all DefType commands specifying an \
additional message to output at definition time. DefInfo[x] returns the \
DefInfo image associated with x at definition time.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$DefInfoQ", "::", "usage"}], 
     "=", "\"\<$DefInfoQ is a boolean global variable controlling whether the \
info definition messages are printed. By default it is True, but setting it \
to False deactivates all Def messages.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$UndefInfoQ", "::", "usage"}], 
     "=", "\"\<$UndefInfoQ is a boolean global variable controlling whether \
the info undefinition messages are printed. By default it is True, but \
setting it to False deactivates all Undef messages.\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"df81e146-9e85-4fbf-915d-a022cd40cb3f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Formatting", " ", "of", " ", "objects"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"xTensorFormStart", "::", "usage"}], 
     "=", "\"\<xTensorFormStart[class] starts formatting for a class of \
objects. Valid classes are: ConstantSymbol, Parameter, InertHead, Tensor, \
CovD, LieD. xTensorFormStart[] starts formatting for all those \
classes.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xTensorFormStop", "::", "usage"}], 
     "=", "\"\<xTensorFormStop[class] stops formatting for a class of \
objects. Valid classes are: ConstantSymbol, Parameter, InertHead, Tensor, \
CovD, LieD. xTensorFormStop[] stops formatting for all those classes.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PrintAs", "::", "usage"}], 
     "=", "\"\<PrintAs[symbol] gives the output string or boxes for symbol in \
StandardForm.\\n\\nPrintAs is also an option for the DefType commands that \
specifies the output form of a defined symbol. It can be PrintAs -> string or \
PrintAs -> boxes. If boxes are to be constructed in a delayed way then use \
PrintAs -> Hold[delayedboxes]. Finally it can also be PrintAs -> function, \
such that the output will be ToString[function[symbol]].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PrintAsCharacter", "::", "usage"}], 
     "=", "\"\<PrintAsCharacter[symbol] returns a character to be used in the \
typesetting of fundamental objects in xTensor. For example \\\"R\\\" for \
Riemann, \\\"G\\\" for Einstein, etc.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f8873389-2fa5-4606-a708-d02d4a320867"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Relations", " ", "among", " ", "symbols"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VisitorsOf", "::", "usage"}], 
     "=", "\"\<VisitorsOf[symbol] gives the list of all symbols which require \
symbol to exist before they can be defined. symbol can only be removed if \
this list is empty.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"HostsOf", "::", "usage"}], 
     "=", "\"\<HostsOf[symbol] gives the list of symbols which are required \
to exist previously, before symbol was defined, and which cannot be undefined \
as long as symbol exists.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MasterOf", "::", "usage"}], 
     "=", "\"\<MasterOf[servant] gives the master symbol of the symbol \
servant. The latter is defined and removed when, and only when, the former is \
defined and removed, respectively.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ServantsOf", "::", "usage"}], 
     "=", "\"\<ServantsOf[symbol] gives the list of symbols which have been \
simultaneously defined with symbol. They will be removed when, and only when, \
symbol is removed.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Master", "::", "usage"}], 
     "=", "\"\<Master is an option for DefType commands specifying the master \
symbol of the defined symbol. By default, no master is associated.\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7613c61c-2d3f-4229-b1e9-5a7708761094"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Reserved", " ", "words", " ", "for", " ", "types"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"AbstractIndex", "::", "usage"}], 
     "=", "\"\<AbstractIndex represents the type for symbols denoting \
abstract indices of a vector bundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Manifold", "::", "usage"}], 
     "=", "\"\<Manifold represents the type for smooth, differentiable \
manifolds.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Mapping", "::", "usage"}], 
     "=", "\"\<Mapping represents the type for smooth mappings between \
manifolds.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"VBundle", "::", "usage"}], 
     "=", "\"\<VBundle represents the type for smooth, differentiable vector \
bundles.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tensor", "::", "usage"}], 
     "=", "\"\<Tensor represents the type for smooth tensor fields in the \
product of several vector bundles.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Metric", "::", "usage"}], 
     "=", "\"\<Metric represents the type for smooth metric tensor fields on \
a vector bundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CovD", "::", "usage"}], 
     "=", "\"\<CovD represents the type for smooth connections living on some \
manifold.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"InertHead", "::", "usage"}], 
     "=", "\"\<InertHead represents the type for tensor wrappers of \
tensors.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarFunction", "::", "usage"}], 
     "=", "\"\<ScalarFunction represents the type for scalar \
functions.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ConstantSymbol", "::", "usage"}], 
     "=", "\"\<ConstantSymbol represents the type for constant \
symbols.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Parameter", "::", "usage"}], 
     "=", "\"\<Parameter represents the type for parameter symbols.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Basis", "::", "usage"}], 
     "=", "\"\<Basis represents both the type and the tensor head for a basis \
vector/covector field.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Chart", "::", "usage"}], 
     "=", "\"\<Chart represents the type for smooth coordinate charts on \
manifolds.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"87a79e4f-7dcf-4423-bfa4-9a6cf2c4f0b5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Data", "-", "bases"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"$AbstractIndices", "::", "usage"}], 
     "=", "\"\<$AbstractIndices is a global variables storing the list of all \
currently defined abstract indices, including those internally \
generated.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$ConstantSymbols", "::", "usage"}], 
     "=", "\"\<$ConstantSymbols is a global variable storing the list of all \
currently defined constant symbols.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$Tensors", "::", "usage"}], 
     "=", "\"\<$Tensors is a global variable storing the list of all \
currently defined tensors.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$CovDs", "::", "usage"}], 
     "=", "\"\<$CovDs is a global variable storing the list of all currently \
defined covariant derivatives, including the fiducial partial derivative \
PD.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$Manifolds", "::", "usage"}], 
     "=", "\"\<$Manifolds is a global variable storing the list of all \
currently defined manifolds.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$Mappings", "::", "usage"}], 
     "=", "\"\<$Mappings is a global variable storing the list of all \
currently defined mappings.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$VBundles", "::", "usage"}], 
     "=", "\"\<$VBundles is a global variable storing the list of all \
currently defined vector bundles.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$ProductManifolds", "::", "usage"}], 
     "=", "\"\<$ProductManifolds is a global variable storing the list of all \
currently defined product manifolds. It is a subset of $Manifolds.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$SumVBundles", "::", "usage"}], 
     "=", "\"\<$SumVBundles is a global variable storing the list of all \
currently defined direct-sum vector bundles. It is a subset of \
$VBundles.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$Metrics", "::", "usage"}], 
     "=", "\"\<$Metrics is a global variable storing the list of all \
currently defined metrics. It is a subset of $Tensors.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$ProductMetrics", "::", "usage"}], 
     "=", "\"\<$ProductMetrics is a global variable storing the list of all \
currently defined product metrics. It is a subset of $Metrics.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$InertHeads", "::", "usage"}], 
     "=", "\"\<$InertHeads is a global variable storing the list of all \
currently defined inert heads of indexed expressions.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$ScalarFunctions", "::", "usage"}], 
     "=", "\"\<$ScalarFunctions is a global variable storing the list of all \
currently defined functions acting on scalars.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$Rules", "::", "usage"}], 
     "=", "\"\<$Rules is a global variable storing the list of all rules \
registered as global rules.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$Bases", "::", "usage"}], 
     "=", "\"\<$Bases is a global variable containing the list of all symbols \
registered as bases (not necessarily coordinate bases) on the bundles in \
$VBundles.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$Charts", "::", "usage"}], 
     "=", "\"\<$Charts is a global variable containing the list of all \
symbols registered as charts on the manifolds in $Manifolds. It is a subset \
of $Bases.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$Parameters", "::", "usage"}], 
     "=", "\"\<$Parameters is a global variable storing the list of all \
currently defined parameters.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$Products", "::", "usage"}], 
     "=", "\"\<$Products is a global variable storing the list of all \
currently defined products.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fb190aff-13b9-4a0f-af03-5751a3f1b20c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Collecting", " ", "function"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"FindAllOfType", "::", "usage"}], 
    "=", "\"\<FindAllOfType[expr, type] gives the list of all occurrences of \
elements of the given type in expr, including their indices for types like \
Tensor, CovD, etc.\>\""}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"65cca8ba-7033-466f-89ab-9bffacb3cb53"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Undefinition", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Undef", "::", "usage"}], 
    "=", "\"\<Undef[symbol] undefines the symbol, whatever its type may be. \
The only exception are abstract indices.\>\""}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"34f0905f-51a1-415f-ad9e-58f435ba6ba1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Name", " ", "validation", " ", "in", " ", "session"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ValidateSymbolInSession", "::", "usage"}], 
    "=", "\"\<ValidateSymbolInSession[symbol] throws an error if symbol is \
already used in this session as a constant-symbol, parameter, manifold, \
vector bundle, abstract index, tensor (or metric), form, covariant \
derivative, basis (or chart), inert head or scalar function. Otherwise it \
gives Null.\>\""}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"21667eeb-64f7-49ff-9a59-d671a09bf328"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Q", "-", 
    RowBox[{"functions", " ", "on", " ", "symbols"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"AbstractIndexQ", "::", "usage"}], 
     "=", "\"\<AbstractIndexQ[symbol] gives True if symbol has been \
registered as an abstract index. Note that it gives False on \
down-indices.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ConstantSymbolQ", "::", "usage"}], 
     "=", "\"\<ConstantSymbolQ[symbol] gives True if symbol has been \
registered as a constant symbol, and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ManifoldQ", "::", "usage"}], 
     "=", "\"\<ManifoldQ[expr] gives True if expr has been registered as a \
manifold, and False otherwise.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"MappingQ", "::", "usage"}], 
     "=", "\"\<MappingQ[symbol] gives True if symbol has been registered as a \
mapping, and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"VBundleQ", "::", "usage"}], 
     "=", "\"\<VBundleQ[symbol] gives True if symbol has been registered as a \
vector bundle, and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ParameterQ", "::", "usage"}], 
     "=", "\"\<ParameterQ[symbol] gives True if symbol has been registered as \
a parameter and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xTensorQ", "::", "usage"}], 
     "=", "\"\<xTensorQ[expr] gives True if expr has been registered as a \
tensor, and False otherwise. Do not confuse with Mathematica's \
TensorQ.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CovDQ", "::", "usage"}], 
     "=", "\"\<CovDQ[expr] gives True if expr has been registered as a \
covariant derivative operator, and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MetricQ", "::", "usage"}], 
     "=", "\"\<MetricQ[expr] gives True if expr has been registered as a \
metric, and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BasisQ", "::", "usage"}], 
     "=", "\"\<BasisQ[symbol] gives True if symbol has been registered as a \
basis or chart, and False otherwise. BasisQ[basis, vbundle] gives True if \
basis is one of the bases of the vector bundle vbundle, and False \
otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChartQ", "::", "usage"}], 
     "=", "\"\<ChartQ[symbol] gives True if symbol has been registered as a \
chart, and False otherwise. ChartQ[chart, manifold] gives True if chart is \
one of the charts of manifold, and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"InertHeadQ", "::", "usage"}], 
     "=", "\"\<InertHeadQ[head] gives True if head[object] must be treated as \
object form the point of view of symmetries and canonicalization in xTensor, \
and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarFunctionQ", "::", "usage"}], 
     "=", "\"\<ScalarFunctionQ[f] gives True if f has been defined as a \
mathematical function acting on scalars, or a derivative of one of those, and \
False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ProductQ", "::", "usage"}], 
     "=", "\"\<ProductQ[symbol] gives True if symbol has been registered as a \
product on indexed objects.\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Q", "-", 
     RowBox[{"functions", " ", "on", " ", "other", " ", "expressions"}]}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FirstDerQ", "::", "usage"}], 
     "=", "\"\<FirstDerQ[expr] gives True if expr is of the form covd[i], \
LieD[v], ParamD[par] or OverDot, or False otherwise. In particular it gives \
False on multiple (nested) derivatives like ParamD[par1, par2].\>\""}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UpVectorQ", "::", "usage"}], 
     "=", "\"\<UpVectorQ[expr] gives True if expr has only one free up-index, \
and False otherwise. UpVectorQ[expr, vbundle] gives True if also the free \
index of expr belongs to the vector bundle vbundle.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"DownVectorQ", "::", "usage"}], 
     "=", "\"\<DownVectorQ[expr] gives True if expr has only one free \
down-index, and False otherwise. DownVectorQ[expr, vbundle] gives True if \
also the free index of expr belongs to the vector bundle vbundle.\>\""}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"ConstantQ", "::", "usage"}], 
     "=", "\"\<ConstantQ[x] gives True if x is a number or a numeric symbol \
or a constant symbol. Otherwise it gives False.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"8dac558e-24d2-47a1-893c-e1fcda91014e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Inert", " ", "heads"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DefInertHead", "::", "usage"}], 
     "=", "\"\<DefInertHead[head] defines an inert head such that head[expr] \
is treated as expr from the tensorial point of view. DefInertHead[head, n] \
declares an inert head such that head[expr1, ..., exprn] is treated as a \
tensorial point of view, with indices those of the sequence of expressions \
expri.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefInertHead", "::", "usage"}], 
     "=", "\"\<UndefInertHead[head] undefines the inert head.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"LinearQ", "::", "usage"}], 
     "=", "\"\<LinearQ is a Boolean option for DefInertHead and DefProduct \
stating that the symbol defined is linear with respect to constants in its \
tensorial argument(s). The default value is False.\\n\\nLinearQ[head] gives \
True if head has been defined as a linear inert-head or product, and False \
otherwise. For inert-heads with n tensorial arguments, LinearQ can also be a \
list of respective Booleans.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ContractThrough", "::", "usage"}], 
     "=", "\"\<ContractThrough is an option for DefInertHead specifying a \
list of metrics and/or the delta tensor which can be contracted through the \
defined inert-head.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ContractThroughQ", "::", "usage"}], 
     "=", "\"\<ContractThroughQ[head, metric] says whether the given metric \
can be contracted through the inert head. The default value is False.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ERROR", "::", "usage"}], 
     "=", "\"\<ERROR[expr] is an expression where an error has been detected. \
ERROR is an inert head with a single argument.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Keep", "::", "usage"}], 
     "=", "\"\<Keep[expr] represents the tensorial expression expr, but \
prevents its expansion under the action of other functions.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DependenciesOfInertHead", "::", "usage"}], 
     "=", "\"\<DependenciesOfInertHead[ih] returns the implicit dependencies \
(manifols and/or parameters) of the inert head ih.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"InertHeadArgumentCount", "::", "usage"}], 
     "=", "\"\<InertHeadArgumentCount[ih] returns the number of tensorial \
arguments expected by the inert head ih. The default value is 1.\>\""}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Complex", " ", "conjugation"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "::", "usage"}], 
     "=", "\"\<Dagger[expr] returns the complex conjugate of an expression. \
Dagger is an inert head. Use DaggerIndex on indices.\\n\\nDagger is also an \
option for several DefType commands, specifying how they behave under complex \
conjugation: possible values are Real, Imaginary, Complex, Hermitian and \
Antihermitian, the latter two only applying to tensors.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DaggerIndex", "::", "usage"}], 
     "=", "\"\<DaggerIndex[ind] returns the conjugated index to ind. \
DaggerIndex[IndexList[i1, ..., in]] returns the list (also with head \
IndexList) of respective conjugated indices. Label indices are considered \
real by default.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DaggerQ", "::", "usage"}], 
     "=", "\"\<DaggerQ[expr] gives True if expr is complex (Dagger[expr] \
different from expr) and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TransposeDagger", "::", "usage"}], 
     "=", "\"\<TransposeDagger[tensor[inds]] exchange the positions of the \
complex conjugated indices following this rule: the n-th index of the complex \
vbundle C is exchanged with the n-th index of the vbundle Dagger[C]. If the \
number of indices in tensor belonging to C and Dagger[C] is not the same, an \
error is thrown. There is no conjugation in this process, simply swapping of \
indices. TransposeDagger[tensor[inds], vbs] only transposes indices of vbs (a \
vbundle or a list of them).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Pair", "::", "usage"}], 
     "=", "\"\<Pair[A, B\[Dagger]] represents a conjugated pair of indices on \
conjugated vbundles.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Imaginary", "::", "usage"}], 
     "=", "\"\<Imaginary is a possible value for the option Dagger.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Hermitian", "::", "usage"}], 
     "=", "\"\<Hermitian is a possible value for the option Dagger of \
DefTensor.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Antihermitian", "::", "usage"}], 
     "=", "\"\<Antihermitian is a possible value for the option Dagger of \
DefTensor.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"HermitianQ", "::", "usage"}], 
     "=", "\"\<HermitianQ[tensor] gives True if tensor is a complex Hermitian \
tensor, and False otherwise. In particular, this function returns False on \
real tensors.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AntihermitianQ", "::", "usage"}], 
     "=", "\"\<AntihermitianQ[tensor] gives True if tensor is a complex \
antihermitian tensor, and False otherwise.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d9da8e47-d132-402c-92b9-82b3f2b0f348"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Scalar", " ", "functions"}], " ", "*)"}], " ", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DefScalarFunction", "::", "usage"}], 
     "=", "\"\<DefScalarFunction[f] defines f to be a scalar function of one \
or several scalar arguments.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefScalarFunction", "::", "usage"}], 
     "=", "\"\<UndefScalarFunction[f] undefines the scalar function f.\>\""}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Parameters", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DefParameter", "::", "usage"}], 
     "=", "\"\<DefParameter[t] defines t to be a real parameter on which \
indexed objects can depend.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefParameter", "::", "usage"}], 
     "=", "\"\<UndefParameter[t] undefines the parameter t.\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Scalars", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarQ", "::", "usage"}], 
     "=", "\"\<ScalarQ[expr] gives true if expr is a scalar, that is, it has \
no free index.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Scalar", "::", "usage"}], 
     "=", "\"\<Scalar[expr] denotes that expr is a scalar (no free indices) \
expression. The expression is simplified as much as possible extracting \
scalars and constants.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$SeparateScalarsFromScalar", "::", "usage"}], 
     "=", "\"\<$SeparateScalarsFromScalar is a global variable specifying \
whether Scalar[x] should be converted into x for a non-indexed scalar \
x.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$ScalarColor", "::", "usage"}], 
     "=", "\"\<$ScalarColor is a global variable specifying the color of the \
parentheses surrounding the formatting of a Scalar expression.\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Products", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DefProduct", "::", "usage"}], 
     "=", "\"\<DefProduct[prod, pbs, pos] defines prod to be an algebra \
product of indexed objects, in which pos is the product of scalars and pbs is \
the product of scalars by elements of the algebra. The second and third \
arguments may be omitted, both having default value Times.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefProduct", "::", "usage"}], 
     "=", "\"\<UndefProduct[prod] undefines the product prod.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AssociativeProductQ", "::", "usage"}], 
     "=", "\"\<AssociativeProductQ[prod] gives whether the product prod is \
associative or not.\\n\\nAssociativeProductQ is also a boolean option of \
DefProduct, specifying whether the product being defined is associative. Its \
default value is True.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"GradedProductQ", "::", "usage"}], 
     "=", "\"\<GradedProductQ[prod] says whether the algebra associated to \
the product prod is graded or not. If it is, grades are computed using \
Grade[expr, prod].\\n\\nGradedProductQ is also a boolean option of \
DefProduct, specifying whether the product being defined is graded or not. \
Its default value is False.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CommutativityOfProduct", "::", "usage"}], 
     "=", "\"\<CommutativityOfProduct[prod] describes the symmetry of the \
product prod. It can be \\\"Commutative\\\", \\\"Anticommutative\\\", \
\\\"SuperCommutative\\\", \\\"SuperAnticommutative\\\" or None. It can also \
be a function f of two arguments returning the sign under exchange of any two \
consecutive factors.\\n\\nCommutativityOfProduct is also an option of \
DefProduct, specifying the symmetry of the product being defined. Its default \
value is None.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IdentityElementOfProduct", "::", "usage"}], 
     "=", "\"\<IdentityElementOfProduct[prod] returns the neutral element of \
the product prod.\\n\\nIdentityElementOfProduct is also an option of \
DefProduct, specifying the neutral element of the product being defined. Its \
default value is None.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ScalarsOfProduct", "::", "usage"}], 
     "=", "\"\<ScalarsOfProduct[prod] returns a function that gives True on \
the scalars of the product algebra prod, and gives False \
otherwise.\\n\\nScalarsOfProduct is also an option of DefProduct, specifying \
that function at definition time. Its default value is NumericQ.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ProductByScalar", "::", "usage"}], 
     "=", "\"\<ProductByScalar[prod] returns the product used to multiply \
elements of the algebra by scalars of the algebra defined by the product \
prod. The result may be the product pbs or {Left, pbs} or {Right, pbs} \
depending on whether pbs is orderless or must be used as pbs[scalar, x] or \
pbs[x, scalar], respectively.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ProductOfScalars", "::", "usage"}], 
     "=", "\"\<ProductOfScalars[prod] returns the product used to multiply \
scalars of the the product algebra defined by the product prod.\>\""}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DefineCommutator", "::", "usage"}], 
     "=", "\"\<DefineCommutator is a boolean option of DefProduct, specifying \
whether the the associated product Commutator[prod] must be defined together \
with the product prod being defined. Its default value is False.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Commutator", "::", "usage"}], 
     "=", "\"\<Commutator[prod][a, b] represents the commutator associated to \
the product prod, that is prod[a, b] - prod[b, a]. Commutator[prod] is an \
Anticommutative product. If prod is associative then Commutator[prod] obeys \
the Jacobi identity and defines a Lie algebra.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Anticommutator", "::", "usage"}], 
     "=", "\"\<Anticommutator[prod][a, b] represents the anticommutator \
associated to the product prod, that is prod[a, b] + prod[b, a]. \
Commutator[prod] is a Commutative product.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Supercommutator", "::", "usage"}], 
     "=", "\"\<Supercommutator[prod][a, b] represents the supercommutator \
associated to the product prod, that is prod[a, b] - \
(-1)^(|a|\[CenterDot]|b|) prod[b, a], where |a| is the grade of a. \
Supercommutator[prod] is a SuperAnticommutative product. If prod is \
associative then Supercommutator[prod] obeys a graded Jacobi identity and \
defines a graded Lie algebra.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ExpandCommutator", "::", "usage"}], 
     "=", "\"\<ExpandCommutator[expr] expands all commutators, \
anticommutators, and supercommutators to their underlying base \
products.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Grade", "::", "usage"}], 
     "=", "\"\<Grade[expr, prod] returns the grade of the expression expr \
with respect to the product prod.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"GradeOfTensor", "::", "usage"}], 
     "=", "\"\<GradeOfTensor[T, prod] gives the grade of the tensor T in the \
product prod.\\n\\nGradeOfTensor is also an option of DefTensor specifying \
the grade of the tensor being defined in various products, as in \
GradeOfTensor->{wedge->1, clifford->2}.\>\""}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"GradeOfCovD", "::", "usage"}], 
     "=", "\"\<GradeOfCovD[cd, prod] gives the grade of the covariant \
derivative cd in the product prod.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"GradeOfProduct", "::", "usage"}], 
     "=", "\"\<GradeOfProduct[prod, prod2] returns the grade with respect to \
product prod2 added by the presence of a product prod of \
expressions.\\n\\nGradeOfProduct is also an option of DefProduct, specifying \
that the value of GradeOfProduct[prod, prod] when the product prod is \
defined.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xSortOrder", "::", "usage"}], 
     "=", "\"\<xSortOrder is an option of DefProduct specifying an Order-like \
function used to sort the factors of the product being defined. Its default \
value is Automatic, which represents the standard ordering used by the Times \
product in xTensor.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7e1a4a1f-e809-4ebc-83cd-7b0e09862e0b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Conventions", " ", "and", " ", "signs"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"$epsilonSign", "::", "usage"}], 
     "=", "\"\<$epsilonSign is a global sign giving the default value for the \
function epsilonOrientation. This variable is kept for backward \
compatibility.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$RiemannSign", "::", "usage"}], 
     "=", "\"\<$RiemannSign defines the global sign of the Riemann tensor \
from derivatives of a connection: Riemann[-a,-b,-c,d] = $RiemannSign * ( \
PD[-b][Christoffel[d,-a,-c] + ...)\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$RicciSign", "::", "usage"}], 
     "=", "\"\<$RicciSign defines the global sign of the Ricci tensor from \
contraction of the Riemann tensor: Ricci[-a,-b] = $RicciSign * \
Riemann[-a,-c,-b,c]\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$TorsionSign", "::", "usage"}], 
     "=", "\"\<$TorsionSign defines the global sign of the torsion tensor of \
a covariant derivative: cd[-a]@cd[-b]@f[] - cd[-b]@cd[-a]@f[] = - \
$TorsionSign Torsioncd[c,-a,-b] cd[-c]@f[].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$ExtrinsicKSign", "::", "usage"}], 
     "=", "\"\<$ExtrinsicKSign defines the global sign of the extrisic \
curvature tensor in terms of the derivative of a vector field: \
ExtrinsicK[-a,-b] = $ExtrinsicKSign Projector[ cd[-a][ n[-b] ] ].\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$AccelerationSign", "::", "usage"}], 
     "=", "\"\<$AccelerationSign defines the global sign of the acceleration \
vector in terms of the derivative of a vector field: Acceleration[-a] = \
$AccelerationSign n[b] cd[-b][ n[-a] ] / norm.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"736cf359-9df7-46a8-a5d1-f820132674b5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Creating", " ", "names"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"GiveSymbol", "::", "usage"}], 
     "=", "\"\<GiveSymbol[object, case] constructs a symbol for the required \
object in the special given case. Both must be symbols or strings.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"GiveOutputString", "::", "usage"}], 
     "=", "\"\<GiveOutputString[object, case] gives the string to be used as \
output in StandardForm. Both object and case must be symbols or \
strings.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b5c6001c-94a2-4b13-bcbd-715ec662228f"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1.3. G-Indices", \
"Subsubsection",ExpressionUUID->"525e0d68-1f97-4b77-9136-5f73c694207e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Types", " ", "of", " ", "g"}], "-", 
    RowBox[{
     RowBox[{"indices", ".", " ", "BASIS1", ".", " ", "BASIS2"}], " ", "is", " ",
      "not", " ", "yet", " ", "documented"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DefAbstractIndex", "::", "usage"}], 
     "=", "\"\<DefAbstractIndex[symbol] defines symbol to be an abstract \
index without associating it to a vector bundle yet.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefAbstractIndex", "::", "usage"}], 
     "=", "\"\<UndefAbstractIndex[index] undefines index, making it unusable.\
\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"GIndexQ", "::", "usage"}], 
     "=", "\"\<GIndexQ[x] gives True if x is a valid generalized index (an \
abstract index, a label index, a valid basis index, or a valid direction). \
Patterns are not accepted. Otherwise it gives False. GIndexQ[x, vbundle] \
gives True if x is a valid generalized index belonging to the vector bundle \
vbundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AIndexQ", "::", "usage"}], 
     "=", "\"\<AIndexQ[x] gives True if x is recognized as a valid abstract \
index, and False otherwise. AIndexQ[x, vbundle] gives True if x is a valid \
abstract index belonging to the vector bundle vbundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BIndexQ", "::", "usage"}], 
     "=", "\"\<BIndexQ[x] gives True if x is a valid basis index: {i, basis}, \
where i is an abstract index. BIndexQ[x, basis] gives True if x is a valid \
basis index belonging to basis. BIndexQ[x, vbundle] gives True if x is a \
valid basis index belonging to the vector bundle vbundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CIndexQ", "::", "usage"}], 
     "=", "\"\<CIndexQ[x] gives True if x is a valid component index: {i, \
basis}, where i is an integer cnumber compatible with basis. CIndexQ[x, \
basis] gives True if x is a valid component index belonging to basis. \
CIndexQ[x, vbundle] gives True if x is a valid component index belonging to \
some basis of the vector bundle vbundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DIndexQ", "::", "usage"}], 
     "=", "\"\<DIndexQ[x] gives True if x is a valid directional index of the \
form Dir[v], where v is a covariant or contravariant vector. DIndexQ[x, \
vbundle] gives True if x is a valid directional index belonging to the vector \
bundle vbundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"LIndexQ", "::", "usage"}], 
     "=", "\"\<LIndexQ[x] gives True if x is a label (an expression with head \
LI, perhaps multiplied by -1), and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PIndexQ", "::", "usage"}], 
     "=", "\"\<PIndexQ[ind] gives True if ind is a valid pattern for an \
index: _, _h, a_h, a_h?Q where a must be a valid abstract index and h must be \
one of Symbol, Dir, LI, List, Blank, Pattern, PatternTest. Other kinds of \
pattern, in particular Condition, are not accepted.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ABIndexQ", "::", "usage"}], 
     "=", "\"\<ABIndexQ[x] gives True if x is an ABIndex (abstract index or \
basis index) and False otherwise. ABIndexQ[x, basis] gives True if x is an \
ABIndex belonging to basis and False otherwise. ABIndexQ[x, vbundle] gives \
True if x is an ABIndex belonging to the vector bundle vbundle and False \
otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BCIndexQ", "::", "usage"}], 
     "=", "\"\<BCIndexQ[x] gives True if x is a BCIndex (basis index or \
component index), and False otherwise. BCIndexQ[x, basis] gives True if x is \
a BCIndex belonging to basis and False otherwise. BCIndexQ[x, vbundle] gives \
True if x is an BCIndex belonging to the vector bundle vbundle and False \
otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CDIndexQ", "::", "usage"}], 
     "=", "\"\<CDIndexQ[x] gives True if x is a CDIndex (component index or \
directional index), and False otherwise. CDIndexQ[x, basis] gives True if x \
is a CDIndex belonging to basis and False otherwise. CDIndexQ[x, vbundle] \
gives True if x is an CDIndex belonging to the vector bundle vbundle and \
False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dir", "::", "usage"}], 
     "=", "\"\<Dir[v] is a directional index in any tensorial slot. Its \
single argument v is assumed to be a vector or a covector.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"LI", "::", "usage"}], 
     "=", "\"\<LI is the head for label indices.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Labels", "::", "usage"}], 
     "=", "\"\<Labels is the \\\"vector bundle\\\" to which all labels \
belong.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UpIndex", "::", "usage"}], 
     "=", "\"\<UpIndex[ind] converts ind into an up-index: On expressions of \
the form -expr it returns expr. On basis- and component-indices UpIndex[{1, \
basis}] and UpIndex[{1, -basis}] return {1, basis}. On directions Dir[...] \
the function UpIndex returns a covector. On other cases it returns the input \
expr.\>\""}], ";", 
    RowBox[{
     RowBox[{"DownIndex", "::", "usage"}], 
     "=", "\"\<DownIndex[ind] converts ind into a down-index, returning \
opposite results to UpIndex.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"ChangeIndex", "::", "usage"}], 
     "=", "\"\<ChangeIndex[ind] converts up-indices to down-indices and \
viceversa.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UpIndexQ", "::", "usage"}], 
     "=", "\"\<UpIndexQ[a] gives True if a is an upper index and False \
otherwise. It gives False on patterns.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DownIndexQ", "::", "usage"}], 
     "=", "\"\<DownIndexQ[a] gives True if a is a lower index and False \
otherwise. It gives False on patterns.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"EIndexQ", "::", "usage"}], 
     "=", "\"\<EIndexQ[ind] identifies indices which can obey the Einstein \
convention, returning opposite results to BlockedQ. We call them Einstein, \
contractible or traceable indices.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BlockedQ", "::", "usage"}], 
     "=", "\"\<BlockedQ[ind] returns True on blocked indices: types C, D and \
L. On other cases (traceable indices) it returns False, including indices of \
types A, B and patterns.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PairQ", "::", "usage"}], 
     "=", "\"\<PairQ[a, b] returns True if indices a, b form an Einstein pair \
of contracted indices. Currently this is only possible for a pair a, -a of \
abstract indices or a pair {a, B}, {-a,-B} of basis indices of the same basis \
B.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IndexList", "::", "usage"}], 
     "=", "\"\<IndexList[i1, i2, ...] is a list of g-indices.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$IndexListColor", "::", "usage"}], 
     "=", "\"\<$IndexListColor is a global variable specifying the color to \
format the braces of IndexList expressions in StandardForm. The default color \
is blue, RGBColor[0,0,1].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PatternIndex", "::", "usage"}], 
     "=", "\"\<PatternIndex[name, type] constructs a pattern index for the \
given type (AIndex, DIndex or LIndex), with the given name. \
PatternIndex[name, type, character] also specifies the given character (Up or \
Down). PatternIndex[name, type, character, vbundle] restricts the pattern to \
the vector bundle vbundle (use character Null when accepting both Up and \
Down).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AIndex", "::", "usage"}], 
     "=", "\"\<AIndex represents the logic type for abstract indices. It also \
represents the abstract basis corresponding to abstract indices.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BIndex", "::", "usage"}], 
     "=", "\"\<BIndex represents the logic type for basis indices.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CIndex", "::", "usage"}], 
     "=", "\"\<CIndex represents the logic type for component indices.\>\""}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DIndex", "::", "usage"}], 
     "=", "\"\<DIndex represents the logic type for directional \
indices.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"LIndex", "::", "usage"}], 
     "=", "\"\<LIndex represents the logic type for label indices.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PIndex", "::", "usage"}], 
     "=", "\"\<PIndex represents the logic type for pattern indices.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Off", "[", 
     RowBox[{"General", "::", "shdw"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xAct`xTensor`Up", "::", "usage"}], 
     "=", "\"\<Up represents the logic type for up-indices.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xAct`xTensor`Down", "::", "usage"}], 
     "=", "\"\<Down represents the logic type for down-indices.\>\""}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"On", "[", 
     RowBox[{"General", "::", "shdw"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Free", "::", "usage"}], 
     "=", "\"\<Free represents the logic type for free indices.\>\""}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dummy", "::", "usage"}], 
     "=", "\"\<Dummy represents the logic type for dummy indices.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Blocked", "::", "usage"}], 
     "=", "\"\<Blocked represents the logic type for blocked indices \
(components, directions and labels).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IModQ", "::", "usage"}], 
     "=", "\"\<IModQ[expr] returns True if expr is a valid index-modifier, \
and False otherwise.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"96a54a88-aa86-4f58-8c48-bee4397fa1ae"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Sorting", " ", "g"}], "-", "indices"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"IndexSort", "::", "usage"}], 
     "=", "\"\<IndexSort[list] sorts the elements of list (assumed to be \
g-indices) according to three priorities set up by SetIndexSortPriorities. \
Currently: \>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IndexOrderedQ", "::", "usage"}], 
     "=", "\"\<IndexOrderedQ[{i1, i2, ...}] gives True if the list of \
g-indices is sorted according to IndexSort and False otherwise.\>\""}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DisorderedPairQ", "::", "usage"}], 
     "=", "\"\<DisorderedPairQ[i1, i2] gives True if the list of indices {i1, \
i2} is not in canonical order according to IndexSort, and False \
otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SetIndexSortPriorities", "::", "usage"}], 
     "=", "\"\<SetIndexSortPriorities[p1, p2, p3] sets the three priorities \
for g-index sorting. The pi are strings among these: priorities p1 and p2 are \
chosen from two of the pairs `up\.b4/`down\.b4 and `free\.b4/`dummy\.b4. \
Priority 3 can be chosen from one of the pairs \
`lexicographic\.b4/`antilexicographic\.b4 and `positional\.b4/`antipositional\
\.b4.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f4fdac8a-c7d1-49f8-9fef-c449899790e9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Finding", " ", "indices"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"FindIndices", "::", "usage"}], 
     "=", "\"\<FindIndices[expr] returns an IndexList with the (order kept) \
union of all-gindices of expr. Indices in directional arguments, Scalar \
expressions or scalar-functions are not found. FindIndices has attribute \
HoldFirst, and hence requires very often the use of Evaluate.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AnyIndices", "::", "usage"}], 
     "=", "\"\<AnyIndices is an internal symbol of xTensor returned by the \
expression FindIndices[0]. AnyIndices[vbundle] also represents an arbitrary \
sequence of abstract indices in the given vbundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$FindIndicesAcceptedHeads", "::", "usage"}], 
     "=", "\"\<$FindIndicesAcceptedHeas is a global variable giving the list \
of heads for which FindIndices does not complain and continues looking for \
indexed objects inside. It is initialized to {Hold}.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FindFreeIndices", "::", "usage"}], 
     "=", "\"\<FindFreeIndices[expr] gives an IndexList with the (order not \
kept) free indices of expr, throwing an error if they are not homogeneous in \
all terms of expr. FindFreeIndices[expr, selector] uses SelectIndices on \
FindFreeIndices[expr] with the given selector. FindFreeIndices has attribute \
HoldFirst, and hence requires very often the use of Evaluate.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FindDummyIndices", "::", "usage"}], 
     "=", "\"\<FindDummyIndices[expr] gives an IndexList with the (up-) \
indices wich are contracted in expr. FindDummyIndices[expr, selector] uses \
SelectIndices on FindDummyIndices[expr] with the given selector. \
FindDummyIndices has attribute HoldFirst, and hence requires very often the \
use of Evaluate.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FindBlockedIndices", "::", "usage"}], 
     "=", "\"\<FindBlockedIndices[expr] gives an IndexList with the (order \
not kept) blocked indices of expr. FindBlockedIndices[expr, selector] uses \
SelectIndices on FindBlockedIndices[expr] with the given selector. \
FindBlockedIndices has attribute HoldFirst, and hence requires very often the \
use of Evaluate.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IsIndexOf", "::", "usage"}], 
     "=", "\"\<IsIndexOf[object, index] gives True if (Verbatim) index is one \
of the indices of object, and False otherwise. IsIndexOf[object, index, \
tensor] gives IndexOf[object, index] unless object is an inert head \
expression with head IH; in that case there is the further check \
ContractThroughQ[IH, tensor].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IndicesOf", "::", "usage"}], 
     "=", "\"\<IndicesOf[selectors][expr] returns a list (head IndexList) of \
the indices in expression selected by the given selectors. Different \
selectors are applied succesively from left to right. Possible selectors are \
Free, Dummy, Blocked, Up, Down, AIndex, BIndex, CIndex, DIndex, LIndex, or a \
manifold, a vbundle, a basis, a tensor (including Basis), or a covd.\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"4685481f-9f86-4de6-9dc1-af723a3cf537"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Replacing", " ", "indices"}], " ", "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ReplaceIndex", "::", "usage"}], 
     "=", "\"\<ReplaceIndex[expr, rule] replaces indices of objects in expr \
as given by rule (a single rule or a list of rules of the form i1->i2). Note \
that the rules a->b and -a->-b are independent and both must be given if this \
is what we want. ReplaceIndex[expr, {{rule1, ...}, {rule2, ...}, ...}] is \
automatically threaded, giving a list of expressions.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ReplaceDummies", "::", "usage"}], 
     "=", "\"\<ReplaceDummies[expr] replaces dummy indices in expr by new \
(dollar-) dummy indices. ReplaceDummies[expr, inds] chooses new indices from \
inds before starting generation of new indices.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SameDummies", "::", "usage"}], 
     "=", "\"\<SameDummies[expr] returns expr minimizing the number of \
different dummies used among the summands of the expr. No new dummy is \
introduced.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$ComputeNewDummies", "::", "usage"}], 
     "=", "\"\<$ComputeNewDummies is a global Boolean variable which \
specifies whether new (dollar-) indices must be generated during the action \
of ReplaceDummies.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SplitIndex", "::", "usage"}], 
     "=", "\"\<SplitIndex[expr, splitrules] returns an array whose elements \
are expr with certain indices replaced as given by the splitrules. A \
split-rule must be of the form index -> Indexlist[i1, i2, ...], meaning that \
index is to be replaced by i1, i2, ... respectively in each of the terms of \
the array. It is possible to give a list of splitrules or a compacted form \
IndexList[index1, index2, ...] -> IndexList[i1 ,i2, ...], where each of the \
indices indexi is to be splitted as IndexList[i1, i2, ...].\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"TraceDummy", "::", "usage"}], 
     "=", "\"\<TraceDummy[expr, trules] traces dummy indices in expr as given \
by the trace-rules trules. These are rules of the form index -> IndexList[i1, \
i2, ...], where index can be a pattern.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"$TraceDummyVerbose", "::", "usage"}], 
     "=", "\"\<$TraceDummyVerbose is a global Boolean variable turning on and \
off log messages from the command TraceDummy.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f6bfca73-618c-4480-814a-a3766d4a3e21"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Formatting", " ", "indices"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"IndexForm", "::", "usage"}], 
     "=", "\"\<IndexForm[index] returns the string which will be used to \
format the generalized index (assumed not to have a minus sign in front). By \
default, abstract indices are simply converted into a string, basis and \
component indices are colored according to the basis they belong to, \
directional indices are converted into the name of the vector or into \\\"#\\\
\" when they are composite expressions, and patterns are underlined. \
(Component indices are dealt with through the associated function \
CIndexForm.) If changed, IndexForm must be manipulated with great \
care.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$CIndexForm", "::", "usage"}], 
     "=", "\"\<$CIndexForm is a Boolean global variable. If True the \
coordinate indices are represented in tensor slots as the name of the \
associated coordinate. If False (the default) no such replacemente is \
performed.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CIndexForm", "::", "usage"}], 
     "=", "\"\<CIndexForm[cnumber, chart] returns the string to be used to \
represent the coordinate index {cnumber, chart} in a tensor slot.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PrimeDagger", "::", "usage"}], 
     "=", "\"\<PrimeDagger[ind] for a daggered index ind returns the \
formatting of the index replacing the dagger by a prime.\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c5e8faea-d1c9-45f8-a5a4-9b37e3b6a297"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1.4. Manifolds, mappings and vector bundles", \
"Subsubsection",ExpressionUUID->"307f164a-8ba0-41fb-94b7-2e40e70f22a5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Manifolds", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"IndexRange", "::", "usage"}], 
     "=", "\"\<IndexRange[a, p] and IndexRange[{a, p}] return the list of \
symbols between symbols a and p (using CharacterRange internally). \
IndexRange[{a1, p1}, {a2, p2}, ...] returns the union (using Union, and hence \
sorted) of the ranges defined by the given pairs of indices.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DefManifold", "::", "usage"}], 
     "=", "\"\<DefManifold[M, dim, {a, b, c,...}] defines M to be an \
n-dimensional differentiable manifold with dimension dim (a positive integer \
or a constant symbol) and tensor abstract indices a, b, c, ... .  \
DefManifold[M, {M1, ..., Mm}, {a, b, c,...}] defines M to be the product \
manifold of previously defined manifolds M1 ... Mm. For backward \
compatibility dim can be a list of positive integers, whose length is \
interpreted as the dimension of the defined manifold.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefManifold", "::", "usage"}], 
     "=", "\"\<UndefManifold[manifold] undefines manifold.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DimOfManifold", "::", "usage"}], 
     "=", "\"\<DimOfManifold[M] yields the dimension of manifold M.\>\""}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Cartesian", " ", "products"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CartesianProduct", "::", "usage"}], 
     "=", "\"\<CartesianProduct[O1, O2, ...] represents the Cartesian product \
of the objects Oi.\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Manifold", " ", "splitting"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SplitManifold", "::", "usage"}], 
     "=", "\"\<SplitManifold[M, {m1, ..., mn}] identifies the manifold M as \
the (external) Cartesian product of the manifolds mi. Both the M manifold and \
the mi manifolds are assumed to exist already. The dimension of M must \
coincide with the sum of the dimensions of the mi manifolds.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"SplittingsOfManifold", "::", "usage"}], 
     "=", "\"\<SplittingsOfManifold[M] returns a list of known \
CartesianProduct splittings of the manifold M.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SubmanifoldsOfManifold", "::", "usage"}], 
     "=", "\"\<SubmanifoldsOfManifold has been removed from xTensor in \
version 1.1.0. Please use SplittingsOfManifold for similar \
functionality.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SubmanifoldQ", "::", "usage"}], 
     "=", "\"\<SubmanifoldQ[large, small] gives True if manifold small is \
contained in or equal to manifold large, and False otherwise.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"DisjointManifoldsQ", "::", "usage"}], 
     "=", "\"\<DisjointManifoldsQ[manifolds1, manifolds2] gives True if none \
of the manifolds of the list manifolds1 is a submanifold or a supermanifold \
of the manifolds of the list manifolds2, and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DisjointVBundlesQ", "::", "usage"}], 
     "=", "\"\<DisjointVBundlesQ[vbundles1, vbundles2] gives True if none of \
the vbundles of the list vbundles1 is a subvbundle or a supervbundle of the \
vbundles of the list vbundles2, and False otherwise.\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"4150307b-343d-4ed1-8b4c-8369779b55c8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Dependencies", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DependenciesOf", "::", "usage"}], 
     "=", "\"\<DependenciesOf[expr] gives the list of manifolds and \
parameters upon which expr depends.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ManifoldsOf", "::", "usage"}], 
     "=", "\"\<ManifoldsOf[expr] gives the list of manifolds on which expr \
lives.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ParametersOf", "::", "usage"}], 
     "=", "\"\<ParametersOf[expr] gives the list of parameters on which expr \
depends.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AnyDependencies", "::", "usage"}], 
     "=", "\"\<AnyDependencies is an internal symbol of xTensor returned by \
DependenciesOf acting on an unknown expression (unregistered symbols, \
patterns, etc.).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"OtherDependencies", "::", "usage"}], 
     "=", "\"\<OtherDependencies is an option for DefCovD and DefMetric \
specifying that all derivatives and tensors defined have the given list of \
additional dependencies (manifolds and parameters) and not only the manifold \
on which the derivative or metric are defined.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"813ad112-2a66-4361-b3ef-21c2e7440c48"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Boundaries", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ManifoldBoundary", "::", "usage"}], 
     "=", "\"\<ManifoldBoundary[M] represents the manifold (without boundary) \
of the manifold (with boundary) M.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"EmptyManifold", "::", "usage"}], 
     "=", "\"\<EmptyManifold is a manifold with no points. \
ManifoldBoundary[M] of a manifold M without boundary returns EmptyManifold.\>\
\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"cb336b9d-deaa-4746-95af-cbc0a0e676e5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Mappings", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DefMapping", "::", "usage"}], 
     "=", "\"\<DefMapping[phi, M1->M2] defines phi to be a mapping having \
manifold M1 as domain and manifold M2 as image.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefMapping", "::", "usage"}], 
     "=", "\"\<UndefMapping[phi] undefines the mapping phi.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MappingDomain", "::", "usage"}], 
     "=", "\"\<MappingDomain[phi] returns the domain manifold of the mapping \
phi.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MappingImage", "::", "usage"}], 
     "=", "\"\<MappingImage[phi] returns the image manifold of the mapping \
phi, in general a supermanifold of phi[domain].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ImmersionQ", "::", "usage"}], 
     "=", "\"\<ImmersionQ is a Boolean option of DefMapping. ImmersionQ[phi] \
returns True if the mapping phi is an immersion on its image, and False \
otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SubmersionQ", "::", "usage"}], 
     "=", "\"\<SubmersionsQ is a Booleann option of DefMapping. \
SubmersionQ[phi] returns True if the mapping phi is a submersion on its \
image, and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DiffeomorphismQ", "::", "usage"}], 
     "=", "\"\<DiffeomorphismQ[phi] returns True if the mapping phi is a \
local diffeomorphism between its domain and image, and False \
otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"InverseMapping", "::", "usage"}], 
     "=", "\"\<InverseMapping[phi] returns the inverse of the mapping phi, if \
phi is invertible (at least left or right invertible), and throws an error \
otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IdentityMapping", "::", "usage"}], 
     "=", "\"\<IdentityMapping[M] represents the identity mapping from the \
manifold M to itself.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"48b6a704-9ccd-4add-aa7d-5e378ea7a292"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Vector", " ", "bundles"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DefVBundle", "::", "usage"}], 
     "=", "\"\<DefVBundle[vbundle, M, dim, {a, b, c,...}] defines vbundle to \
be a vector bundle with base manifold M and fiber vector space with dimension \
given by dim (a positive integer) and represented by the abstract indices {a, \
b, c, ...}.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefVBundle", "::", "usage"}], 
     "=", "\"\<UndefVBundle[vbundle] undefines the vector bundle \
vbundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AnyVBundles", "::", "usage"}], 
     "=", "\"\<AnyVBundles is an internal symbol of xTensor returned by \
SlotsOfTensor acting on the Zero tensor.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BaseOfVBundle", "::", "usage"}], 
     "=", "\"\<BaseOfVBundle[vbundle] gives the base manifold of the vector \
bundle vbundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Tangent", "::", "usage"}], 
     "=", "\"\<Tangent[M] returns the tangent bundle of the manifold M. For a \
symbolic M the name of the bundle is constructed by default prepending the \
name of the manifold with Tangent.\\n\\nTangent is also an option for \
DefManifold, giving the name of the tangent bundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TangentBundleOfManifold", "::", "usage"}], 
     "=", "\"\<TangentBundleOfManifold = Tangent. Kept for backward \
compatibility.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IndicesOfVBundle", "::", "usage"}], 
     "=", "\"\<IndicesOfVBundle[vbundle] returns the abstract indices \
associated to vector bundle vbundle. There are two lists: that of the \
registered indices and that of the internally generated indices.\>\""}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"LastIndex", "::", "usage"}], 
     "=", "\"\<LastIndex[vbundle] gives a pair {i, n} such that \
dollar-indices will be formed using the symbol i (see function DummyIn) and \
computer-generated indices will be formed using the symbol i and the integer \
n (see function NewIndexIn). LastIndex[vbundle, map] given the corresponding \
pair for the pullback vbundle PullBackVBundle[vbundle, map].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DimOfVBundle", "::", "usage"}], 
     "=", "\"\<DimOfVBundle[vbundle] yields the dimension of vector bundle \
vbundle.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"TangentBundleQ", "::", "usage"}], 
     "=", "\"\<TangentBundleQ[vbundle] gives True if vbundle is the tangent \
vector bundle of some manifold, and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MetricEndowedQ", "::", "usage"}], 
     "=", "\"\<MetricEndowedQ[vbundle] gives True if the vector bundle \
vbundle has at least one registered metric (which will be contained in \
MetricsOfVBundle[vbundle]) or False otherwise.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"MetricsOfVBundle", "::", "usage"}], 
     "=", "\"\<MetricsOfVBundle[vbundle] gives the list of metrics that have \
been defined on the vector bundle vbundle. Only the first one will be used to \
raise and lower indices.\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Direct", " ", "sums", "  ", "and", " ", "tensor", " ", "products"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CirclePlus", "::", "usage"}], 
     "=", "\"\<CirclePlus[vb1, vb2, ...] represents the direct sum of the \
vector bundles vb1, vb2, ...\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CircleTimes", "::", "usage"}], 
     "=", "\"\<CircleTimes[O1, O2, ...] represents the tensor product of the \
objects O1, O2, ...\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"VBundle", " ", "splitting"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SplitVBundle", "::", "usage"}], 
     "=", "\"\<SplitVBundle[V, {v1, ..., vn}] identifies the vbundle V as the \
direct sum of the vbundles vi. Both the V vbundle and the vi vbundles are \
assumed to exist already. The dimension of V must coincide with the sum of \
the dimensions of the vi vbundles.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SplittingsOfVBundle", "::", "usage"}], 
     "=", "\"\<SplittingsOfVBundle[vb] returns a list of known direct sum \
splittings of the vbundle vb.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SubvbundlesOfVBundle", "::", "usage"}], 
     "=", "\"\<SubvbundlesOfVBundle has been removed from xTensor in version \
1.1.0. Please use SplittingsOfVBundle for similar functionality.\>\""}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"SubvbundleQ", "::", "usage"}], 
     "=", "\"\<SubvbundleQ[large, small] gives True if vector bundle small is \
contained in or equal to vector bundle large, and False otherwise.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SubdummiesIn", "::", "usage"}], 
     "=", "\"\<SubdummiesIn[vbundle] gives a list of unique (dollar) indices \
on the respective subvbundles of vbundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SetSplitTensors", "::", "usage"}], 
     "=", "\"\<SetSplitTensors[vbundle, Tlist] declares the tensors in the \
list Tlist to be projectors and their duals for the given vbundle, that must \
have been declared previously as a sum vbundle (using either DefVBundle or \
DefManifold). Currently xTensor can only decompose into two subvbundle, and \
hence Tlist must contain four tensors with character {down, up}, in any \
order. \>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SplitTensor", "::", "usage"}], 
     "=", "\"\<SplitTensor[T] decomposes the tensor T as a sum of projected \
parts using the projectors declared with SetSplitTensors.\>\""}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"Project", "::", "usage"}], 
     "=", "\"\<Project[expr, P, inds] project the indices inds with the \
projector P, by explicit multiplication of expr by copies of P. The inds \
argument admits a single index, and IndexList or an IndicesOf \
expression.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Projected", "::", "usage"}], 
     "=", "\"\<Projected[T, {P, Q, ...}][a, b, ...] represents the tensor T \
projected with projector P in index a, Q in index b, ... Non-projected slots \
are denoted by the formal projector delta. Each projector can be replaced by \
a sum of projectors. The whole list of projectors can be replaced by a single \
projector or sum of projectors acting on all indices of the \
expression.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ProjectorQ", "::", "usage"}], 
     "=", "\"\<ProjectorQ[P] returns True if tensor P has been declared as a \
projector with MakeProjectors, and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MakeProjectors", "::", "usage"}], 
     "=", "\"\<MakeProjectors[{P1[-a, b], ..., Pn[-a, b]}, {dim1, ..., dimn}] \
defines tensors P1, ..., Pn, assumed to existe already, to be complementary \
projectors on the vbundle of the indices -a, b. Projector Pi projects onto a \
subspace of dimension dimi. The option OrthogonalWithMetric specifies a \
metric with respect to which the projectors are orthogonal.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"OrthogonalWithMetric", "::", "usage"}], 
     "=", "\"\<OrthogonalWithMetric is an option of MakeProjectors \
specifiying the metric with respect to which a given set of complementary \
projectors are also a set of orthogonal projectors. The default value Null \
represents no metric.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$ProjectedFormat", "::", "usage"}], 
     "=", "\"\<$ProjectedFormat is a Boolean global variable selecting the \
type of formatting of indices of Projected tensors. With False the projectors \
are staggered with the indices, in gray font. With True the projectors are \
placed on top of upper indices or underneath lower indices. This should not \
be a Boolean variable...\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ContractProjector", "::", "usage"}], 
     "=", "\"\<ContractProjector[expr, P] transforms products of projector P \
with other tensors in expr into Projected notation. ContractProjector[expr] \
contracts all projectors.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FromProjected", "::", "usage"}], 
     "=", "\"\<FromProjected[expr] converts Projected expressions into \
explicit products of tensors and projectors.\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Indices", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"VBundleOfIndex", "::", "usage"}], 
     "=", "\"\<VBundleOfIndex[i] gives the vector bundle to which the g-index \
i belongs. Otherwise it throws an error message.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RegisterIndices", "::", "usage"}], 
     "=", "\"\<RegisterIndices[vb, inds] associates the given list inds of \
abstract indices to the vbundle vb.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DummyIn", "::", "usage"}], 
     "=", "\"\<DummyIn[vbundle] gives a unique abstract dollar-index on the \
vector bundle vbundle, using the last of the user-defined indices.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DummyAs", "::", "usage"}], 
     "=", "\"\<DummyAs[ind] gives a dummy abstract index in the vector bundle \
of ind, having the same up/down character.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AddIndices", "::", "usage"}], 
     "=", "\"\<AddIndices[vbundle, indlist] adds the abstract indices in \
indlist to the user-defined part of the indices associated to the the vector \
bundle vbundle.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"RemoveIndices", "::", "usage"}], 
     "=", "\"\<RemoveIndices[vbundle, indlist] removes the abstract indices \
in indlist from the user-defined part of the indices associated to the vector \
bundle vbundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"NewIndexIn", "::", "usage"}], 
     "=", "\"\<NewIndexIn[vbundle] gives and registers a new computer-defined \
abstract index associated to the vector bundle vbundle. The index is \
constructed using the last index of the user-defined part and a sequential \
number starting at 1. This is an internal function, and users are expected to \
use GetIndicesOfVBundle instead.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"GetIndicesOfVBundle", "::", "usage"}], 
     "=", "\"\<GetIndicesOfVBundle[vbundle, n, list] gives a list of n \
abstract indices on the vector bundle vbundle, checking that they are not in \
list. If there are not enough indices in IndicesOfVBundle[vbundle] then new \
indices are generated using NewIndexIn.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"75b07f54-17bf-49e2-8f0c-14ef2a999695"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Tracing", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"TraceProductDummy", "::", "usage"}], 
    "=", "\"\<TraceProductDummy[expr, index] expands the dummy index of a \
sum-vbundle in expr to dummy indices of its subvbundles. \
TraceProductDummy[expr] expands all dummies. TraceProductDummy[expr, {i1, i2, \
...}] expands the dummies i1, i2,... TraceProductDummy[expr, {VBundle[VB1], \
i1, ...}] expands the indices i1,... and all dummies of the sum-vbundle VB1, \
...\>\""}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"59c69c64-9d9d-4327-9943-c6783390c379"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1.5. ConstantSymbols", \
"Subsubsection",ExpressionUUID->"cb12c092-99ef-40f3-9a91-0db307e4c96f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DefConstantSymbol", "::", "usage"}], 
   "=", "\"\<DefConstantSymbol[symbol] defines symbol to be a constant with \
respect to all derivatives (covariant derivatives, Lie derivatives, \
variational derivatives and parameter derivatives).\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"UndefConstantSymbol", "::", "usage"}], 
   "=", "\"\<UndefConstantSymbol[symbol] undefines the constant \
symbol.\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"9b4dd69e-ad6b-47a0-b9ba-cfec07fc386c"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1.6. Tensors", \
"Subsubsection",ExpressionUUID->"04077b00-dd40-4abe-877a-b07238bcf7dc"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"$TensorBoxes", "::", "usage"}], 
   "=", "\"\<$TensorBoxes is a global variable specifying the internal \
notation to be used for indexed tensors. From version 1.0 of xTensor the \
default is \\\"GridBox\\\" but before it was \\\"ScriptBox\\\".\>\""}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"057a4756-f0ce-47df-8a1e-cff9215a344d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Tensors", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DefTensor", "::", "usage"}], 
     "=", "\"\<DefTensor[T[-a, b, c, ...], {M1, ...}] defines T to be a \
tensor field on manifolds and parameters M1,... and the base manifolds \
associated to the vector bundles of its indices. DefTensor[T[-a, b, c, ...], \
{M1, ...}, symmetry] defines a tensor with symmetry given by a generating set \
or strong generating set of the associated permutation group.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefTensor", "::", "usage"}], 
     "=", "\"\<UndefTensor[tensor] undefines tensor.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"VanishingQ", "::", "usage"}], 
     "=", "\"\<VanishingQ is a Boolean option for DefTensor stating that the \
defined tensor must be given a zero value.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ForceSymmetries", "::", "usage"}], 
     "=", "\"\<ForceSymmetries is a Boolean option for DefTensor. If True \
symmetries are registered even if involved indices do not have the same \
up/down character.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FrobeniusQ", "::", "usage"}], 
     "=", "\"\<FrobeniusQ is a Boolean option for DefTensor stating that the \
defined vector obeys the Frobenius condition with every torsionless covariant \
derivative.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SetOrthogonal", "::", "usage"}], 
     "=", "\"\<SetOrthogonal[tensor[inds], vector[ind]] defines automatic \
rules for tensor such that tensor[inds]*vector[ind] is zero. \
SetOrthogonal[tensor[inds], vector] defines those rules for all abstract \
indices of tensor[inds].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"OrthogonalTo", "::", "usage"}], 
     "=", "\"\<OrthogonalTo is an option for several DefType functions. For \
DefTensor it gives a list of vectors which are orthogonal to the tensor \
defined, one for each index. For DefCovD it gives a vector which is \
orthogonal to the whole derivative.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SetProjected", "::", "usage"}], 
     "=", "\"\<SetProjected[tensor[inds], proj[i1, i2]] defines automatic \
rules for tensor such that tensor[inds]*proj[i1, i2] returns tensor again, \
but with new indices. SetProjected[tensor[inds], proj] defines those rules \
for all abstract indices of tensor[inds].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ProjectedWith", "::", "usage"}], 
     "=", "\"\<ProjectedWith is an option for several Def functions. For \
DefTensor it gives a list of 2-tensors which project the tensor defined into \
itself. For DefCovD it gives a projector for the whole derivative.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"OrthogonalToVectorQ", "::", "usage"}], 
     "=", "\"\<OrthogonalToVectorQ[v][T] for a vector v and a tensor T \
returns True if T is orthogonal in all its slots to v, and False otherwise. \
The value is remembered as un upvalue of T.\\n\\nOrthogonalToVectorQ[v][expr] \
for a vector v and an indexed expression expr returns True if the expression \
is orthogonal in all its slots to v, and False otherwise. The value is not \
remembered.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SymmetryGroupOfTensor", "::", "usage"}], 
     "=", "\"\<SymmetryGroupOfTensor[tensor] gives the generating set or \
strong generating set of the symmetries of tensor, using Cycles notation on \
the numeric slots of the tensor.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SymmetryTableauxOfTensor", "::", "usage"}], 
     "=", "\"\<SymmetryTableauxOfTensor[tensor] gives the list of symmetry \
tableaux of tensor, using numeric slots.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SlotsOfTensor", "::", "usage"}], 
     "=", "\"\<SlotsOfTensor[tensor] gives the list of vector bundles with \
up/down marks corresponding to the slots of tensor as it was defined. Slots \
related by the symmetries of tensor must belong to the same vector bundle and \
must have the same up/down character, unless the option ForceSymmetries is \
used.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TensorID", "::", "usage"}], 
     "=", "\"\<TensorID[tensor] returns a list with information on how to \
compute the components of the tensor.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"WeightOfTensor", "::", "usage"}], 
     "=", "\"\<WeightOfTensor[tensor] gives the weight of tensor as a \
tensorial density. It is always a linear combination of names of bases. It is \
0 if tensor is not a density. Upvalues for tensor are stored only if tensor \
is a density. WeightOfTensor is also an option for DefTensor giving the \
weight of the defined tensor.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"WeightOf", "::", "usage"}], 
     "=", "\"\<WeightOf[expr] returns the density weight of the expression. \
The weight of the basis-determinant of the metric is defined to be 2*basis.\>\
\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DependenciesOfTensor", "::", "usage"}], 
     "=", "\"\<DependenciesOfTensor[tensor] gives the list of manifolds and \
parameters on which the tensor depends.\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Other", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Zero", "::", "usage"}], 
     "=", "\"\<Zero[e1, ..., en] is 0 no matter what the arguments \
are.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"HeadOfTensor", "::", "usage"}], 
     "=", "\"\<HeadOfTensor[T[a, b, ...], {a, b, ...}] returns T. \
HeadOfTensor[k T[a, b, ...], {a, b, ...}] returns MultipliyHead[k, T].\>\""}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MultiplyHead", "::", "usage"}], 
     "=", "\"\<MultiplyHead[k, T][a, b, ...] returns k T[a, b, ...].\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"delta", "::", "usage"}], 
     "=", "\"\<delta[-a, b] represents the identity tensor on any vector \
bundle. In the presence of a metric the object delta[b, -a] is also allowed, \
being related to the former as given by that metric.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"Gdelta", "::", "usage"}], 
     "=", "\"\<Gdelta[-a1, ..., -an, b1, ..., bn] represents the generalized \
delta tensor on any vector bundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ExpandGdelta", "::", "usage"}], 
     "=", "\"\<ExpandGdelta[expr] expands Gdelta as a linear combination of \
products of delta.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sdelta", "::", "usage"}], 
     "=", "\"\<Sdelta[sym][inds] represents a tensor with symmetry sym in the \
first half of its slots and symmetry sym in the second half of its \
slots.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ExpandSdelta", "::", "usage"}], 
     "=", "\"\<ExpandSdelta[expr] expands Sdelta[sym] as a linear combination \
of products of delta.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SeparateDir", "::", "usage"}], 
     "=", "\"\<SeparateDir[expr] converts all directional indices \
(expressions Dir[v]) in expr into products of the direction v and the \
corresponding tensor.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ContractDir", "::", "usage"}], 
     "=", "\"\<ContractDir[expr, v] converts contracted vectors v into \
Dir[v[.]] expressions in expr.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"dab2f6a1-c4b4-4b17-bfb1-4f069665cdf1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"PushForward", " ", "and", " ", "PullBack"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"PullBack", "::", "usage"}], 
     "=", "\"\<PullBack[expr, phi, firules] computes the pull back of the \
tensor expression expr along the mapping phi, changing free indices of expr \
into free indices of the domain tangent vbundle as given by the list of rules \
firules.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PullBackVBundle", "::", "usage"}], 
     "=", "\"\<PullBackVBundle[vb, phi] represents the pull back of the \
vector bundle bun under the mapping phi. It is also treated as a (nonatomic) \
vbundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Precompose", "::", "usage"}], 
     "=", "\"\<Precompose[T, phi] represents the precomposition of the tensor \
field T with the mapping phi, a section of a pullback vbundle. The result has \
dependencies given by the domain of the mapping phi.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PullBackTensor", "::", "usage"}], 
     "=", "\"\<PullBackTensor[T, phi] represents the pull back of the tensor \
T under the mapping phi. It is also treated as a (nonatomic) tensor.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PullBackCovD", "::", "usage"}], 
     "=", "\"\<PullBackCovD[CD, phi] represents the pull back of the \
covariant derivative CD under the mapping phi. It is also treated as a \
(nonatomic) covariant derivative.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ExpandPullBack", "::", "usage"}], 
     "=", "\"\<ExpandPullBack[expr] expands the PullBackTensor[T, phi] \
expressions into a contraction of Precompose[T, phi] with explicit dphi or \
Inv[dphi] factors.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TangentTensor", "::", "usage"}], 
     "=", "\"\<TangentTensor[phi] returns the tangent (or differential) of \
the mapping phi. This is a 2-tensor along the mapping phi, with its first \
slot being the cotangent vbundle of the domain of phi and the second slot \
being the pullback of the tangent bundle of the image of phi.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PushForward", "::", "usage"}], 
     "=", "\"\<PushForward[expr, phi, firules] computes the push forward of \
the tensor expression expr along the mapping phi, changing free indices of \
expr into free indices of the image tangent vbundle as given by the list of \
rules firules.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"LinearPush", "::", "usage"}], 
     "=", "\"\<LinearPush[T, dphi] represents a tensor along the mapping phi, \
whose differential is dphi. It is equivalent to a contraction of the \
contravariant slots of T with dphi, and of the covariant slots of T with the \
inverse of dphi.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"InvertibleQ", "::", "usage"}], 
     "=", "\"\<InvertibleQ[dphi] returns True if dphi is an invertible \
2-tensor, and False otherwise. InvertibleQ[dphi, Left] returns True if dphi \
is left-invertible, and False otherwise. InvertibleQ[dphi, Right] returns \
True if dphi is right-invertible, and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PushForwardTensor", "::", "usage"}], 
     "=", "\"\<PushForwardTensor[T, phi] represents the push forward of the \
tensor T under the mapping phi. It is also treated as a (nonatomic) tensor.\>\
\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ExpandPushForward", "::", "usage"}], 
     "=", "\"\<ExpandPushForward[expr] expands the PushForwardTensor[T, phi] \
expressions into a contraction of Precompose[T, iphi] with explicit diphi or \
Inv[diphi] factors, where iphi is the inverse mapping of phi.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"At", "::", "usage"}], 
     "=", "\"\<At[texpr, sub] represents the restriction of the tensorial \
expression texpr to the submanifold sub, which may be a point.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TensorAt", "::", "usage"}], 
     "=", "\"\<TensorAt[T, sub] represents the restriction of the tensor T to \
the submanifold sub, which may be a point.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"8961af3c-7d1b-4576-bf5a-a90596a1ea59"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ATensor", "::", "usage"}], 
   "=", "\"\<ATensor[name, slots, deps, sym] represents an abstract tensor \
with the given properties.\>\""}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"585db315-9f7c-44e0-bbb6-a5fd0b82b65e"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1.7. Rules", \
"Subsubsection",ExpressionUUID->"e184df4b-c221-4dd3-8a79-cc82b1e7ffdc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Rules", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"PermuteIndices", "::", "usage"}], 
     "=", "\"\<PermuteIndices[expr, indices, perm] permutes the indices of \
expr given by the list indices (head IndexList) with the permutation perm, in \
general a linear combination of permutations.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MakeRule", "::", "usage"}], 
     "=", "\"\<MakeRule[{LHS, RHS}] gives a list of delayed rules with left \
and right hand sides as given by LHS and RHS respectively, but moving indices \
to consider all possible equivalent rules. See notes for its options \
PatternIndices, MetricOn, UseSymmetries and TestIndices. MakeRule[{LHS, RHS, \
conditions}] adds conditions to the rules.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"ToRule", "::", "ToRule"}], 
     "=", "\"\<ToRule[lhs==rhs] evaluates the given equation and returns a \
rule lhs:>Module[{..}, rhs] constructed with MakeRule. ToRule also accepts \
rules and lists in input, and takes all options of MakeRule.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AutomaticRules", "::", "usage"}], 
     "=", "\"\<AutomaticRules[symbol, {rule1, rule2, ...}] declares the rules \
as upvalues or downvalues for symbol, or append them to $Rules if symbol is \
too deep in the rules.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IndexRule", "::", "usage"}], 
     "=", "\"\<IndexRule[lhs, rhs] construct a DelayedRule expression between \
indexed expressions lhs and rhs, evaluating rhs in advance.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IndexRuleDelayed", "::", "usage"}], 
     "=", "\"\<IndexRuleDelayed[lhs, rhs] construct a DelayedRule expression \
between indexed expressions lhs and rhs, without evaluating rhs.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IndexSet", "::", "usage"}], 
     "=", "\"\<IndexSet[lhs, rhs] defines a relation between indexed \
expressions lhs and rhs, evaluating rhs in advance.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IndexSetDelayed", "::", "usage"}], 
     "=", "\"\<IndexSet[lhs, rhs] defines a relation between indexed \
expressions lhs and rhs, withoug evaluating rhs.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DoubleRightTee", "::", "usage"}], 
     "=", "\"\<Infix form for IndexRule. Note that it has a very high \
precedence (much higher than that of = ).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RightTeeArrow", "::", "usage"}], 
     "=", "\"\<Infix form for IndexRule. Note that it has a very high \
precedence (much higher than that of -> ).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PatternIndices", "::", "usage"}], 
     "=", "\"\<PatternIndices is an option for MakeRule expressing the \
indices that will be converted into patterns in the final expression of the \
rule. Possible values are None (default), All or a list of indices.\>\""}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"MetricOn", "::", "usage"}], 
     "=", "\"\<MetricOn is an option for MakeRule. MetricOn->None (default) \
means that no index can be raised or lowered. MetricOn->All means that all \
indices can be raised or lowered. MetricOn->{i1, i2, ...} explicitly gives \
the list of indices that can be raised or lowered with the metric. This \
option is not relevant if there is no metric.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"TestIndices", "::", "usage"}], 
     "=", "\"\<TestIndices is a Boolean option for MakeRule. \
TestIndices->True (default) means that patterntests are added to the indices \
of the rules to check that they belong to the right vector bundle.\>\""}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"UseSymmetries", "::", "usage"}], 
     "=", "\"\<UseSymmetries is a Boolean option for MakeRule. \
UseSymmetries->True (default) means that symmetries of the tensors are \
considered to construct the rules.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ContractMetrics", "::", "usage"}], 
     "=", "\"\<ContractMetrics is a Boolean option for MakeRule that \
specifies that all metric objects must be contracted (if possible) in the RHS \
of the rules. Its default value is False.\>\""}], ";", 
    RowBox[{
     RowBox[{"Verbose", "::", "usage"}], 
     "=", "\"\<Verbose is a Boolean option for MakeRule, AutomaticRules and \
ToCanonical. Verbose->True gives lots of log-info about the internals of the \
calculation. Its default value is False.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"a83eecda-f809-44db-9676-c690163a6e28"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1.8. Covariant derivatives", \
"Subsubsection",ExpressionUUID->"a3ee8798-4f74-4ad3-bbd7-3f47c12e4dab"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Leibnitz", "::", "usage"}], 
   "=", "\"\<Leibnitz[expr][-a, b] gives a sum of copies of expr*delta in \
which each free upper index has been replaced by b and each lower index has \
been replaced by -a.\>\""}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"18130788-e88f-4095-83de-01ff9f3208d5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Covariant", " ", "derivatives"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"$CovDFormat", "::", "usage"}], 
     "=", "\"\<$CovDFormat is a global variable containing a string with the \
formatting form of covariant derivatives. Possible values are currently: \
\\\"Prefix\\\" (default) for nabla-like notation, and \\\"Postfix\\\" for \
comma-like notation.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$ParamDFormat", "::", "usage"}], 
     "=", "\"\<$ParamDFormat is a global variable containing a string with \
the formatting form of parametric derivatives. Possible values are currently: \
\\\"Prefix\\\" (default) or \\\"SinglePrefix\\\" for partial-like notation, \
and \\\"Postfix\\\" for comma-like notation.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DefCovD", "::", "usage"}], 
     "=", "\"\<DefCovD[covd[-a], {post, pre}] defines covd to be a connection \
on the tangent bundle of index a. DefCovD[covd[-a], vbundle, {post, pre}] \
defines covd to be a connection on the tangent bundle of index a and the \
inner vbundle (which must have the same base manifold). The connection will \
be represented in StandardForm using the character pre in \\\"Prefix\\\" \
notation and the character post in \\\"Postfix\\\" notation.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefCovD", "::", "usage"}], 
     "=", "\"\<UndefCovD[covd] undefines covd.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PD", "::", "usage"}], 
     "=", "\"\<PD denotes the fiducial connection without curvature nor \
torsion (called ordinary derivative by Wald).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Curvature", "::", "usage"}], 
     "=", "\"\<Curvature is an option for DefCovD giving whether a newly \
defined covariant derivative has curvature or not. There are several possible \
values: Riemann (the connection has curvature only on the tangent bundle), \
FRiemann (only on the inner bundle, and its conjugate), True (on both \
vbundles), False (no curvature), a vbundle on which we want to have \
curvature, or a list of such vbundles. The default value is \
True.\\n\\nCurvature is also a Boolean option for DefMetric, saying whether a \
metric defined on a tangent bundle has a Levi-Civita connection with \
curvature or not.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CurvatureRelations", "::", "usage"}], 
     "=", "\"\<CurvatureRelations is a Boolean option for DefCovD giving \
whether automatic rules relating the curvature tensors of a newly define \
covariant derivative should be defined or not. Its default value is \
True.\\n\\n CurvatureRelations[covd, Riemann] gives a list of the relations \
between the contracted Riemann of cov and the Ricci tensor. \
CurvatureRelations[covd, Ricci] give the corresponding list of relations \
between the contracted Ricci and the RicciScalar if there is a metric. \
CurvatureRelations[covd] gives the union of those two lists.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FromMetric", "::", "usage"}], 
     "=", "\"\<FromMetric is an option for DefCovD giving the metric \
associated to the covariant derivative. Use FromMetric -> metric or \
FromMetric -> Null.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ExtendedFrom", "::", "usage"}], 
     "=", "\"\<ExtendedFrom is an option for DefCovD (generally used when \
defining a covd on an inner vbundle), specifying that the Riemann, Ricci, \
Christoffel and Torsion tensors must be shared with another, already \
existing, covd.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"WeightedWithBasis", "::", "usage"}], 
     "=", "\"\<WeightedWithBasis is an option for DefCovD (though typically \
used through DefMetric) to extend a Levi-Civita connection on densities in a \
given basis (which can be AIndex as special case). Its default value is Null.\
\\n\\nWeightedBasis[covd] returns the basis along which the Levi-Civita \
connection covd has been extended, or Null otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SymmetryGroupOfCovD", "::", "usage"}], 
     "=", "\"\<SymmetryGroupOfCovD[covd] gives the symmetry group of the \
covariant derivative covd when it acts as a multiple index derivative.\>\""}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DependenciesOfCovD", "::", "usage"}], 
     "=", "\"\<DependenciesOfCovD[covd] gives the list of dependencies \
(manifolds and parameters) on which the covariant derivative covd \
depends.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"0d3655c3-41b8-480b-84c0-39f9285bb8b9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Associated", " ", "tensors"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Christoffel", "::", "usage"}], 
     "=", "\"\<Christoffel[covd1, covd2][a, -b, -c] returns the Christoffel \
tensor relating the connections covd1 and covd2, and defines it if it does \
not exist yet. Christoffel[covd][a, -b, -c] is equivalent to \
Christoffel[covd, PD][a, -b, -c].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AChristoffel", "::", "usage"}], 
     "=", "\"\<AChristoffel[covd1, covd2][A, -b, -C] returns the Christoffel \
tensor relating the connections covd1 and covd2 on an inner vbundle, and \
defines it if it does not exist yet. This proceeds by immediate conversion of \
AChristoffel into Christoffel. AChristoffel[covd][A, -b, -C} is equivalent to \
AChristoffel[covd, PD][A, -b, -C].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Torsion", "::", "usage"}], 
     "=", "\"\<Torsion[covd] returns the torsion tensor associated to a \
connection covd.\\n\\nTorsion is also a Boolean option for DefCovD that \
specifies whether the defined covariant derivative has torsion or not. Its \
default value is False.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Riemann", "::", "usage"}], 
     "=", "\"\<Riemann[covd] returns the Riemann curvature tensor associated \
to a connection covd acting on a tangent bundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FRiemann", "::", "usage"}], 
     "=", "\"\<FRiemann[covd] returns the Riemann curvature tensor associated \
to a connection covd acting on an inner (not tangent) vector bundle.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannDown", "::", "usage"}], 
     "=", "\"\<RiemannDown[covd] returns the Riemann curvature tensor \
associated to the connection covd of a frozen metric, with its four indices \
being lower indices, so that it has full Riemann symmetry.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Ricci", "::", "usage"}], 
     "=", "\"\<Ricci[covd] returns the Ricci curvature tensor associated to a \
connection acting on a tangent bundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TFRicci", "::", "usage"}], 
     "=", "\"\<TFRicci[covd] returns the Traceless Ricci curvature tensor \
associated to a connection covd acting on a tangent bundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RicciScalar", "::", "usage"}], 
     "=", "\"\<RicciScalar[covd] returns the Ricci curvature scalar \
associated to a metric-compatible connection covd acting on a tangent bundle.\
\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Einstein", "::", "usage"}], 
     "=", "\"\<Einstein[covd] returns the Einstein curvature tensor \
associated to a metric-compatible connection covd acting on a tangent bundle.\
\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Weyl", "::", "usage"}], 
     "=", "\"\<Weyl[covd[ returns the Weyl curvature tensor associated to a \
metric-compatible connection covd acting on a tangent bundle.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Kretschmann", "::", "usage"}], 
     "=", "\"\<Kretschmann[covd] returns the Kretschmann curvature scalar \
associated to a metric-compatible connection covd acting on a tangent bundle.\
\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"LC", "::", "usage"}], 
     "=", "\"\<LC[g] returns the Levi-Civita covariant derivative associated \
to the metric g.\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"Implode", "::", "usage"}], 
     "=", "\"\<Implode[expr, covd] converts covd derivatives of tensors into \
new tensors formed from the names of the tensor and the covd.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "$ImplodeInfoQ", 
     "=", "\"\<$ImplodeInfoQ is a boolean global variable which specifies \
whether definition of imploded tensors is to be reported or not.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Explode", "::", "usage"}], 
     "=", "\"\<Explode[expr, covd] converts imploded tensors into their \
corresponding form with explicit covd operators. Metric factors may appear in \
this process.\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"epsilon", "::", "usage"}], 
     "=", "\"\<epsilon[g] returns the totally antisymmetric tensor associate \
to the metric g.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ExtrinsicK", "::", "usage"}], 
     "=", "\"\<ExtrinsicK[h] returns the extrinsic curvature tensor \
associated a the induced metric h.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Acceleration", "::", "usage"}], 
     "=", "\"\<Acceleration[n] returns the acceleration vector associated to \
the vector n, registered as the vector orthogonal to some induced \
metric.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Projector", "::", "usage"}], 
     "=", "\"\<Projector[h] returns the projector tensor on the tangent \
subvbundle defined by the induced metric h.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3b98db65-07b2-4d99-8738-494f95ecb66c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Info", " ", "on", " ", "covds"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"CurvatureQ", "::", "usage"}], 
     "=", "\"\<CurvatureQ[covd] gives True if covd has been defined as a \
covariant derivative with curvature and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TorsionQ", "::", "usage"}], 
     "=", "\"\<TorsionQ[covd] gives True if covd has been defined as a \
covariant derivative with torsion and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SymbolOfCovD", "::", "usage"}], 
     "=", "\"\<SymbolOfCovD[covd] gives the pair of strings that represent \
the covariant derivative covd in StandardForm in formats \\\"Postfix\\\" and \
\\\"Prefix\\\" respectively.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ManifoldOfCovD", "::", "usage"}], 
     "=", "\"\<ManifoldOfCovD[covd] gives the manifold where the covariant \
derivative covd lives. It is always a dependency of covd.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"VBundlesOfCovD", "::", "usage"}], 
     "=", "\"\<VBundlesOfCovD[covd] gives a list of vector bundles on which \
the derivative acts. The list can contain: one element (a tangent vector \
bundle), two elements (a tangent vector bundle and an inner real vector \
bundle) or three elements (a tangent bundle and an inner complex bundle with \
its conjugate).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MetricOfCovD", "::", "usage"}], 
     "=", "\"\<MetricOfCovD[covd] gives the metric from which covd derives, \
if covd is a metric covariant derivative. Otherwise it gives Null.\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"230486c9-af65-4809-a163-2a154cd487ba"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Manipulation", " ", "of", " ", "covds"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ContractCurvature", "::", "usage"}], 
     "=", "\"\<ContractCurvature[expr] replaces all contracted Riemann \
tensors by Ricci and all contracted Ricci tensors by RicciScalar. \
ContractCurvature[expr, covd] does it only for the given covariant \
derivative. ContractCurvature[expr, covd, Riemann] only replaces Riemann by \
Ricci. ContractCurvature[expr, covd, Ricci] only replaces Ricci by \
RicciScalar.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CheckZeroDerivative", "::", "usage"}], 
     "=", "\"\<CheckZeroDerivative[expr] performs some checks on expr to see \
if there are derivatives of some manifolds acting on fields on other \
manifolds, which hence can be removed.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$CheckZeroDerivativeVerbose", "::", "usage"}], 
     "=", "\"\<$CheckZeroDerivativeVerbose is a Boolean global variable which \
says whether the action of CheckZeroDerivative must be reported or not. By \
default it is set to False.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CheckZeroDerivativeStart", "::", "usage"}], 
     "=", "\"\<CheckZeroDerivativeStart[covd] starts automatic zero checking \
of derivative covd.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CheckZeroDerivativeStop", "::", "usage"}], 
     "=", "\"\<CheckZeroDerivativeStop[covd] stops automatic zero checking of \
derivative covd.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BreakChristoffel", "::", "usage"}], 
     "=", "\"\<BreakChristoffel[expr, chr, covd] transforms all instances of \
chr[inds] (from covd1 to covd2) in expr into Christoffel[covd1, \
covd][inds]-Christoffel[covd2, covd][inds]. BreakChristoffel[expr, chr] is \
converted into BreakChristoffel[expr, chr, PD]. BreakChristoffel[expr, covd] \
breaks all Christoffel tensors using covd as intermediate connection. \
BreakChristoffel[expr] is converted into BreakChristoffel[expr, PD].\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChangeTorsion", "::", "usage"}], 
     "=", "\"\<ChangeTorsion[expr, covd1, covd2] changes the torsion tensor \
of covd1 by the torsion tensor of covd2 using the antisymmetric part of the \
Christoffel relating covd1 and covd2. The second argument is listable. \
ChangeTorsion[expr, covd1] is converted into ChangeTorsion[expr, covd1, PD]. \
ChangeTorsion[expr] is converted into ChangeTorsion[expr, $CovDs].\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TorsionToChristoffel", "::", "usage"}], 
     "=", "\"\<TorsionToChristoffel = ChangeTorsion. Kept for backwards \
compatibility.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChangeCovD", "::", "usage"}], 
     "=", "\"\<ChangeCovD[expr, covd1, covd2] changes any instance of the \
covariant derivative covd1 in expr into a covariant derivative covd2 and \
Christoffel tensors relating both connections. The second argument is \
listable. ChangeCovD[expr, covd1] is converted into ChangeCovD[expr, covd1, \
PD]. ChangeCovD[expr] is converted into ChangeCovD[expr, $CovDs].\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CovDToChristoffel", "::", "usage"}], 
     "=", "\"\<CovDToChristoffel = ChangeCovD. Kept for backwards \
compatibility.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChangeCurvature", "::", "usage"}], 
     "=", "\"\<ChangeCurvature[expr, covd1, covd2] changes the curvature \
tensors (Riemann, Ricci, RicciScalar and FRiemann) of covd1 into the \
curvature tensors of covd2 using the Christoffels relating covd1 and covd2. \
The second argument is listable. ChangeCurvature[expr, covd1] is converted \
into ChangeCurvature[expr, covd1, PD]. ChangeCurvature[expr] is converted \
into ChangeCurvature[expr, $CovDs].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannToChristoffel", "::", "usage"}], 
     "=", "\"\<RiemannToChristoffel = ChangeCurvature. Kept for backwards \
compatibility.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannToWeyl", "::", "usage"}], 
     "=", "\"\<RiemannToWeyl[expr, covd] expands expr expressing all Riemann \
tensors of covd in terms of the Weyl and other tensors of covd. If the second \
argument is a list of covariant derivatives the command is applied \
sequentially on expr. RiemannToWeyl[expr] expands all Riemann tensors.\>\""}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"WeylToRiemann", "::", "usage"}], 
     "=", "\"\<WeylToRiemann[expr, covd] expands expr expressing all Weyl \
tensors of covd in terms of the Riemann and other tensors of covd. If the \
second argument is a list of covariant derivatives the command is applied \
sequentially on expr. WeylToRiemann[expr] expands all Weyl tensors.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RicciToTFRicci", "::", "usage"}], 
     "=", "\"\<RicciToTFRicci[expr, covd] expands expr expressing all Ricci \
tensors of covd in terms of the TFRicci and other tensors of covd. If the \
second argument is a list of covariant derivatives the command is applied \
sequentially on expr. RicciToTFRicci[expr] expands all Ricci tensors.\>\""}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"TFRicciToRicci", "::", "usage"}], 
     "=", "\"\<TFRicciToRicci[expr, covd] expands expr expressing all TFRicci \
tensors of covd in terms of the Ricci and other tensors of covd. If the \
second argument is a list of covariant derivatives the command is applied \
sequentially on expr. TFRicciToRicci[expr] expands all TFRicci \
tensors.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RicciToEinstein", "::", "usage"}], 
     "=", "\"\<RicciToEinstein[expr, covd] expands expr expressing all Ricci \
tensors of covd in terms of the Einstein and RicciScalar tensors of covd. If \
the second argument is a list of covariant derivatives the command is applied \
sequentially on expr. RicciToEinstein[expr] expands all Ricci tensors.\>\""}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"EinsteinToRicci", "::", "usage"}], 
     "=", "\"\<EinsteinToRicci[expr, covd] expands expr expressing all \
Einstein tensors of covd in terms of the Ricci and RicciScalar tensors of \
covd. If the second argument is a list of covariant derivatives the command \
is applied sequentially on expr. EinsteinToRicci[expr] expands all Einstein \
tensors.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannToRiemannDown", "::", "usage"}], 
     "=", "\"\<RiemannToRiemannDown[expr, covd] expands expr expressing all \
Riemann tensors of covd (the Levi-Civita derivative of a frozen metric) in \
terms of the RiemannDown tensor of covd. If the second argument is a list of \
covariant derivatives the command is applied sequentially on expr. \
RiemannToRiemannDown[expr] expands all Riemann tensors of frozen \
metrics.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannDownToRiemann", "::", "usage"}], 
     "=", "\"\<RiemannDownToRiemann[expr, covd] expands expr expressing all \
RiemannDown tensors of covd (the Levi-Civita derivative of a frozen metric) \
in terms of the Riemann tensor of covd. If the second argument is a list of \
covariant derivatives the command is applied sequentially on expr. \
RiemannDownToRiemann[expr] expands all RiemannDown tensors of frozen metrics.\
\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"aa414deb-884f-4fe5-a780-efdb5d03e203"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Parametric", " ", "derivatives"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"OverDot", "::", "usage"}], 
     "=", "\"\<OverDot[expr] represents a simple ordinary derivative of expr \
with respect to some internal parameter (say time) which is independent of \
the coordinates of the manifolds where expr live. It commutes with partial \
derivatives, but not with other covariant derivatives or with Lie derivatives \
because in general the vector field of the Lie derivative could depend upon \
the parameter as well.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ParamD", "::", "usage"}], 
     "=", "\"\<ParamD[params][expr] represents the multiple ordinary \
derivative of expr with respect to the sequence params of parameters, \
automatically sorted into canonical order.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"aececeb5-6740-41a1-a300-cbb4bbd6ee62"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Sorting", " ", "derivatives"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"SortCovDs", "::", "usage"}], 
     "=", "\"\<SortCovDs[expr, covd] exchange repeatedly two instances of the \
covariant derivative covd, introducing Riemann tensors if needed, until the \
indices of the derivatives are sorted in canonical order. \>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CommuteCovDs", "::", "usage"}], 
     "=", "\"\<CommuteCovDs[expr, covd, {a, b}] converts subexpressions \
covd[b]@covd[a]@expr1 of expr into covd[a]@covd[b]@expr1 plus Riemann terms \
linear in expr1.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CommuteCovDLieD", "::", "usage"}], 
     "=", "\"\<CommuteCovDLieD[expr, LieD[v], covd] converts subexpressions \
covd[a]@LieD[v]@expr1 of expr into LieD[v]@covd[a]@expr1 plus terms linear in \
LieDvcovd. CommuteCovDLieD[expr, covd, LieD[v]] converts subexpressions \
LieD[v]@covd[a]@expr1 of expr into covd[a]@LieD[v]@expr1 plus terms linear in \
LieDvcovd.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SortCovDsStart", "::", "usage"}], 
     "=", "\"\<SortCovDsStart[covd] automatizes the commutation of covariant \
derivative covd.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SortCovDsStop", "::", "usage"}], 
     "=", "\"\<SortCovDsStop[covd] removes automatic commutation of covariant \
derivative covd.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"8d3f5a34-b3fb-4b02-b8d7-0def464786e2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TensorD", "::", "usage"}], 
   "=", "\"\<TensorD[expr, der1, der2, ...] computes the given derivatives of \
expr, returning the result using TensorDerivative notation. The deri can be \
either covariant derivatives or Lie derivatives or parametric \
derivatives.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorDerivative", "::", "usage"}], 
   "=", "\"\<TensorDerivative[T, der] represents the name of the tensor \
obtained by differentitation of the tensor T. The derivative der can be \
either a covariant derivative or a Lie derivative or a parametric derivative. \
TensorDerivative[T, der1, der2, ...] represents a high-order \
derivative.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToTensorDerivative", "::", "usage"}], 
   "=", "\"\<ToTensorDerivative[expr] converts derivatives in expr from \
standard covd[-a][T[b,c]] notation to TensorDerivative[T,covd][b,c,-a] \
notation. Note that the derivative index is placed last in the latter \
notation.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FromTensorDerivative", "::", "usage"}], 
   "=", "\"\<FromTensorDerivative[expr] converts derivatives in expr from \
TensorDerivative[T,covd][b,c,-a] notation to standard covd[-a][T[b,c]] \
notation. Note the the derivative index is the last in the former notation.\>\
\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"98262911-7136-4500-9bf9-788e99f734c3"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1.9. Lie derivatives", \
"Subsubsection",ExpressionUUID->"d88eebce-ef5a-4ea4-88e3-10f63bf0b28a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Lie", " ", "derivatives"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"LieD", "::", "usage"}], 
     "=", "\"\<LieD[v][expr] represents the Lie derivative of expr along the \
contravariant vector field v. LieD[v, covd][expr] computes the Lie derivative \
of expr using the covariant derivative covd.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Bracket", "::", "usage"}], 
     "=", "\"\<Bracket[v1, v2][i] represents the Lie Bracket of vector fields \
v1 and v2, giving a vector field with index i.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"LieDToCovD", "::", "usage"}], 
     "=", "\"\<LieDToCovD[expr, covd] transforms LieD[v][expr1] into LieD[v, \
covd][expr1] so that the Lie derivative of expr1 along v is computed in terms \
of the covariant derivative covd.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DirCovDToLieD", "::", "usage"}], 
     "=", "\"\<DirCovDToLieD[expr, v] changes all directional derivatives \
along the vector v to Lie derivatives along the same vector field. The vector \
v is the name of the vector, without an index.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BracketToCovD", "::", "usage"}], 
     "=", "\"\<BracketToCovD[expr, covd] changes all Lie brackets in expr by \
their expressions in terms of the derivative covd (with optional value PD).\>\
\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"88819adb-c1ef-4bde-bbc5-1d3a308d72c0"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1.10. Variational derivatives", \
"Subsubsection",ExpressionUUID->"2c2ec31d-cf5d-4fc2-ae03-722aea58ffba"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Variational", " ", "derivatives"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"VarD", "::", "usage"}], 
     "=", "\"\<VarD[T, covd][expr, rest] computes the variational derivative \
of expr*rest with respect to the tensor field T. Integrations by parts will \
be performed with the covariant derivative covd.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ImplicitTensorDepQ", "::", "usage"}], 
     "=", "\"\<ImplicitTensorDepQ[T1, T2] returns False if tensor T1 does not \
depend implicitly on tensor T2, an hence the variational derivative of T1 \
with respect to T2 is zero. This is the default behaviour for any two \
different tensors. The trivial subcase ImplicitTensorDepQ[T, T] returns True. \
Nontrivial tensor dependencies must be set by hand, if possible as upvalues \
for T1. \>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b7089e54-bbdc-4e59-a2a7-b06b20ac7fac"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1.11. Canonicalization", \
"Subsubsection",ExpressionUUID->"9474cbc8-7886-496c-a61f-6cff24dd66dc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Stripping", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ToStripped", "::", "usage"}], 
     "=", "\"\<ToStripped[expr] returns the stripped form of the expression \
expr.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FromStripped", "::", "usage"}], 
     "=", "\"\<FromStripped[sexpr] converts back the stripped expression \
sexpr into a standard expression.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Stripped", "::", "usage"}], 
     "=", "\"\<Stripped[T, t][inds] represents the stripped form of the \
object t, of type T, with indices inds\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"a51dcb92-0c22-4c35-b737-55adb0665756"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Monomials", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"BreakInMonomials", "::", "usage"}], 
     "=", "\"\<BreakInMonomials[expr] returns expr with terms separated into \
products of monomials (head Monomial) and scalars.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Monomial", "::", "usage"}], 
     "=", "\"\<Monomial[expr] represents a monomial (a product of objects \
sharing contracted indices).\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"bde5172b-13b7-41fe-9518-734a1dffe815"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Canonicalization", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Symmetry", "::", "usage"}], 
     "=", "\"\<Symmetry is the head of symmetry expressions.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xSort", "::", "usage"}], 
     "=", "\"\<xSort[expr] returns a unique sorted form of the expression \
expr, using the internal Object notation.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UxSort", "::", "usage"}], 
     "=", "\"\<UxSort[object] converts back the object, given in internal \
Object notation, into a standard tensorial expression.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xSortPrecedence", "::", "usage"}], 
     "=", "\"\<xSortPrecedence[t] returns an integer value that determines \
the precedence of tensor t in xSort. Precedence values are sorted with Sort \
and hence smaller values correspond to earlier places in the sorted \
list.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "$MixedDers", 
     "=", "\"\<$MixedDers is a global variable stating whether the \
canonicalization process must take into account the fact that there are \
connections different from that of the metric. The initial default value is \
True.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ToCanonical", "::", "usage"}], 
     "=", "\"\<ToCanonical[expr] gives a canonical reorganization of the \
tensors and their indices in expr, according to the symmetries of tensors and \
positions of dummies and repeated indices.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UseMetricOnVBundle", "::", "usage"}], 
     "=", "\"\<UseMetricOnVBundle is an option for ToCanonical giving the \
vector bundles where the (first) metric (if any) should be used in the \
process of canonicalization. Possible values for this option are All, None or \
a list of vector bundles.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ImposeSymmetry", "::", "usage"}], 
     "=", "\"\<ImposeSymmetry[expr, inds, GS] imposes the symmetry given by \
the generating set (or strong generating set) GS on the indices inds of expr.\
\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xAct`xTensor`Symmetrize", "::", "usage"}], 
     "=", "\"\<Symmetrize[expr, {i1, ..., in}] symmetrizes the expr with \
respect to the n abstract indices i1, ..., in. By convention, the result has \
a factor 1/n! multiplying. Symmetrize[expr] symmetrizes all free \
indices.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Antisymmetrize", "::", "usage"}], 
     "=", "\"\<Antisymmetrize[expr, {i1, ..., in}] antisymmetrizes the expr \
with respect to the n abstract indices i1, ..., in. By convention, the result \
has a factor 1/n! multiplying. Antisymmetrize[expr] antisymmetrizes all free \
indices.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PairSymmetrize", "::", "usage"}], 
     "=", "\"\<PairSymmetrize[expr, {{i1,j1}, ..., {in,jn}}] symmetrizes expr \
with respect to exchange of both indices among any two pairs, i.e., under \
simultaneous change of i3<->i7 and of j3<->j7.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PairAntisymmetrize", "::", "usage"}], 
     "=", "\"\<PairAntisymmetrize[expr, {{i1,j1}, ..., {in,jn}}] \
antisymmetrizes expr with respect to exchange of both indices among any two \
pairs, i.e., under simultaneous change of i3<->i7 and of j3<->j7.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Cyclize", "::", "usage"}], 
     "=", "\"\<Cyclize[expr, {i1, ..., in}] returns expr cyclizing the given \
indices. Note that the result depends on the order of the indices in the \
list.\>\""}], ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SymmetryOf", "::", "usage"}], 
     "=", "\"\<SymmetryOf[expr] gives a description (a result with head \
Symmetry) of the symmetry of the expression expr. This includes a generating \
set for that symmetry using Cycles notation on the indices of expr.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CommutePDs", "::", "usage"}], 
     "=", "\"\<CommutePDs is a Boolean option for SymmetryOf specifying \
whether it is possible or not to commute PD derivatives.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ConstantMetric", "::", "usage"}], 
     "=", "\"\<ConstantMetric is a Boolean option for SymmetryOf specifying \
whether all derivatives should be considered to be metric compatible when \
determining the symmetry of an expression.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$CommuteCovDsOnScalars", "::", "usage"}], 
     "=", "\"\<$CommuteCovDsOnScalars is a Boolean global variable stating \
whether two non-torsion equal covds must be considered as commuting by \
SymmetryOf. The default initial variable is True.\>\""}], ";"}]}]}]], "Input",
 
 InitializationCell->
  True,ExpressionUUID->"78992b5e-0804-4d49-8ce8-c72726c833f1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Manipulation", " ", "of", " ", "Scalar"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"NoScalar", "::", "usage"}], 
     "=", "\"\<NoScalar[expr] removes Scalar from expr, introducing new dummy \
indices.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"BreakScalars", "::", "usage"}], 
     "=", "\"\<BreakScalars[expr] separates scalars inside a single Scalar \
head.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PutScalar", "::", "usage"}], 
     "=", "\"\<PutScalar[expr] surrounds scalars with the head Scalar.\>\""}],
     ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f9419af4-a925-4c2a-a8ad-577ae3c1b00c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"STFPart", "::", "usage"}], 
   "=", "\"\<STFPart[expr, metric] returns the symmetric, trace-free part of \
expr with respect to all its free abstract indices. STFPart[expr, metric, \
indices] allows to specify a list of indices to symmetrize.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Sym", "::", "usage"}], 
   "=", "\"\<Sym[expr, inds, sym] represents the symmetrization of the \
expression expr in the indices inds as given by the symmetry group sym. It \
plays a similar role to ImposeSymmetry, but without expanding the expression.\
\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"3b192183-e2e6-4d01-a457-45e11d3e3049"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1.12. Metrics", \
"Subsubsection",ExpressionUUID->"bd1a511e-aab1-4baa-be87-68d2fc1e6fa1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Metrics", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DefMetric", "::", "usage"}], 
     "=", "\"\<DefMetric[signdet, metric[-a,-b], covd, covdsymbol] defines \
metric[-a, -b] with signdet 1 or -1 and associates the covariant derivative \
covd[-a] to it.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DefProductMetric", "::", "usage"}], 
     "=", "\"\<DefProductMetric[metric[-a,-b], {{M1, scalar1[]}, ...}, covd, \
covdsymbol] defines the metric scalar1[]^2 metric1[-a,-b] + scalar2[]^2 \
metric2[-A,-B] + ... and its associated curvature tensors.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefMetric", "::", "usage"}], 
     "=", "\"\<UndefMetric[metric] undefines metric and all its associated \
servants.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FlatMetric", "::", "usage"}], 
     "=", "\"\<FlatMetric is a Boolean option for DefMetric specifying \
whether the defined metric is flat or not.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Inv", "::", "usage"}], 
     "=", "\"\<Inv is a prefix symbol used to define the inverse of a \
(frozen) metric or any linear operator (2-tensor).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"InducedFrom", "::", "usage"}], 
     "=", "\"\<InducedFrom is an option for DefMetric with form {G, v}, \
stating that the defined metric is actually the induced metric G on a \
codimension-1 hypersurface orthogonal to the non-null vector v (with respect \
to metric G). For a non-induced metric the option has the value Null, which \
is the default.\\n\\nInducedFrom[hmetric] returns the pair {G, v} from which \
the projected metric hmetric has been induced, or Null if hmetric is not an \
induced metric.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ConformalFactor", "::", "usage"}], 
     "=", "\"\<ConformalFactor[metric1, metric2] returns an scalar expression \
X such that the metrics are related by the conformal transformation \
metric1[-a,-b] = X metric2[-a,-b].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ConformalRules", "::", "usage"}], 
     "=", "\"\<ConformalRules[tensor1, tensor2] returns a list of rules \
relating the given two tensors by a (general) conformal transformation. These \
rules are automatically stored by DefMetric when using the option \
ConformalTo. For other tensors the rules must be specified manually as a \
tagset for one of the tensors. ConformalRules[list1, list2] joins the lists \
of transformations for respective tensors in the lists, which hence must have \
the same length.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ConformalTo", "::", "usage"}], 
     "=", "\"\<ConformalTo is an option for DefMetric with form {metexpr, \
confactor} specifying that the defined metric is conformal to the product of \
metexpr and confactor, the former a metric expression and the latter a scalar \
expression to be used as conformal factor.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SetConformalTo", "::", "usage"}], 
     "=", "\"\<SetConformalTo[metric[-a, -b], {g[-a, -b], confactor}] \
declares metric[-a, -b] to be equal to confactor * g[-a, -b], that is they \
are metrics related by a conformal transformation. The conformal factor is \
stored as an upvalue for the head ConformalFactor, the conformal \
transformation is stored as an upvalue for ConformalRules, and the \
Christoffel relating their respective Levi-Civita connections is also stored.\
\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"epsilonOrientationInBasis", "::", "usage"}], 
     "=", "\"\<epsilonOrientationInBasis is an option for DefMetric \
specifying a pair {basis, o} where o is the factor between the epsilon tensor \
of the metric being defined and the eta tensors of the given basis. By \
default this pair is {AIndex, $epsilonSign}.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"epsilonOrientation", "::", "usage"}], 
     "=", "\"\<epsilonOrientation[metric, basis] gives the factor between the \
epsilon tensor of metric and the eta tensors of basis. Its default value is \
$epsilonSign, for backward compatibility.\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FlatMetricQ", "::", "usage"}], 
     "=", "\"\<FlatMetricQ[metric] gives True if metric has been defined as a \
flat metric, or False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SignDetOfMetric", "::", "usage"}], 
     "=", "\"\<SignDetOfMetric[metric] gives the sign of the determinant of \
metric in real bases.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SignatureOfMetric", "::", "usage"}], 
     "=", "\"\<SignatureOfMetric[metric] gives the signature of the metric, \
in the form of a list of three elements: {p1s, m1s, zeros} giving the numbers \
of +1's, -1's and zeros, respectively, always in this order.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Determinant", "::", "usage"}], 
     "=", "\"\<Determinant[metric, basis][] returns the scalar density tensor \
(with weight +2 in basis) representing the determinant of metric with both \
indices expanded in the given basis. The tensor is defined if it does not \
exist yet. The default value for basis is AIndex.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CovDOfMetric", "::", "usage"}], 
     "=", "\"\<CovDOfMetric[metric] gives the covariant derivative operator \
associated to metric at definition time. CovDOfMetric[metric, torsion] gives \
the covariant derivative operator associated to metric and having the given \
torsion tensor. Specifying Zero torsion returns the Levi-Civita connection of \
the metric.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"VBundleOfMetric", "::", "usage"}], 
     "=", "\"\<VBundleOfMetric[metric] gives the vector bundle where metric \
lives, or an error if metric is not known.\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ContractMetric", "::", "usage"}], 
     "=", "\"\<ContractMetric[expr, metric] contracts all instances of metric \
in expr. If the second argument is a list of metrics the command is applied \
sequentially on expr. ContractMetric[expr] contracts all metrics.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"OverDerivatives", "::", "usage"}], 
     "=", "\"\<OverDerivatives is a Boolean option for ContractMetric.\>\""}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SeparateMetric", "::", "usage"}], 
     "=", "\"\<SeparateMetric[g, b][expr, i] separates the index i in the \
expression expr using the metric g and a dummy index in basis b. The default \
for b is AIndex, introducing an abstract index. The default for g is the \
first metric of the vbundle of the index i. The default for i is the list of \
indices in expr which do not have their natural character (that specified at \
definition time for tensors, or covariant for all derivatives).\>\""}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AllowUpperDerivatives", "::", "usage"}], 
     "=", "\"\<AllowUpperDerivatives is a Boolean option for ContractMetric. \
If True, an inverse metric can be contracted with a covariant derivative \
giving a derivative with a contravariant index. If False, that cannot be \
done.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChristoffelToMetric", "::", "usage"}], 
     "=", "\"\<ChristoffelToMetric = ChristoffelToGradMetric. Kept for \
backwards compatibility.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChristoffelToGradMetric", "::", "usage"}], 
     "=", "\"\<ChristoffelToGradMetric[expr, metric] expands expr expressing \
all Christoffels of metric in terms of the metric. If the second argument is \
a list of metrics the command is applied sequentially on expr. \
ChristoffelToGradMetric[expr] expands all Christoffel symbols.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"GradMetricToChristoffel", "::", "usage"}], 
     "=", "\"\<GradMetricToChristoffel[expr, metric, covd] expands expr \
expressing all covd-derivatives of metric as Christoffel tensors from the \
Levi-Civita connection of the metric to covd. If the second and/or third \
arguments are lists the command is applied sequentially on expr in all \
possible cases. GradMetricToChristoffel[expr, metric] expands to all defined \
covariant derivatives. GradMetricToChristoffel expands to all defined metrics \
and covariant derivatives.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChristoffelToGradConformal", "::", "usage"}], 
     "=", "\"\<ChristoffelToGradConformal[expr, metric1, metric2] expands \
expr expressing all Christoffel[covd1, covd2], where covdi is the Levi-Civita \
connection of metrici, in terms of derivatives (using covd2) of the conformal \
factor relating those metrics. The covariant derivatives covdi can be used in \
input instead of the metrici.\>\""}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MetricToProjector", "::", "usage"}], 
     "=", "\"\<MetricToProjector[expr, metric] expands expr expressing the \
metric tensor in terms of a projector and its orthogonal vector field. If the \
second argument is a list of metrics the command is applied sequentially on \
expr. MetricToProjector[expr] expands all metric tensors.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"ProjectorToMetric", "::", "usage"}], 
     "=", "\"\<ProjectorToMetric[expr, proj] expands expr expressing the \
projector proj in terms of the corresponding metric and orthogonal vector \
field. If the second argument is a list of projectors the command is applied \
sequentially on expr. ProjectorToMetric[expr] expands all projectors.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ProjectWith", "::", "usage"}], 
     "=", "\"\<ProjectWith[projector][expr] projects all free indices of \
expression using the given projector. Note the double pair of brackets, which \
simplifies the replacement of the projecting inert head with the actual \
projecting function using a rule like ih -> ProjectWith[proj].\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"GradNormalToExtrinsicK", "::", "usage"}], 
     "=", "\"\<GradNormalToExtrinsicK[expr, imetric] transforms the \
derivatives of the normal vector to the induced metric imetric into extrinsic \
curvature tensors. If the second argument is a list then the function is \
applied sequentially on all elements. GradNormalToExtrinsicK[expr] expands \
all induced metrics.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ExtrinsicKToGradNormal", "::", "usage"}], 
     "=", "\"\<ExtrinsicKToGradNormal[expr, imetric] transforms the extrinsic \
curvature tensors associated to the induced metric imetric into derivatives \
of its normal vector. If the second argument is a list then the function is \
folded sequentially on all elements. ExtrinsicKToGradNormal[expr] expands all \
induced metrics.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ProjectDerivative", "::", "usage"}], 
     "=", "\"\<ProjectDerivative[expr, cd] converts the induced derivative cd \
into the original derivative but projected. If the second argument is a list \
then the function is folded sequentially on all elements. \
ProjectDerivative[expr] converts all induced derivatives.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"InducedDecomposition", "::", "usage"}], 
     "=", "\"\<InducedDecomposition[expr, {imetric, vector}] decomposes the \
tensors in expr in their longitudinal and transversal parts with respect to \
the induced metric imetric and its orthogonal vector.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ToInducedDerivative", "::", "usage"}], 
     "=", "\"\<\!\(\*StyleBox[\"ToInducedDerivative\",FontFamily->\"Courier\"]\
\)[expr, supercd, cd] converts the supercd-derivatives into the sum of an \
induced cd-derivative, a Lie derivative along the orthogonal vector of the \
projection and additional extrinsic curvature terms.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"VectorOfInducedMetric", "::", "usage"}], 
     "=", "\"\<VectorOfInducedMetric[metric] returns the vector to which the \
induced metric is orthogonal.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"GaussCodazzi", "::", "usage"}], 
     "=", "\"\<GaussCodazzi[expr, imetric] projects curvature tensors of the \
Levi-Civita connection of the metric from which imetric is induced into their \
projected components.\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Product", " ", "metrics"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MetricScalar", "::", "usage"}], 
     "=", "\"\<MetricScalar[metric, subvbundle] gives the scalar that relates \
metric (of a product manifold) with the metric of the subvbundle.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ExpandProductMetric", "::", "usage"}], 
     "=", "\"\<ExpandProductMetric[expr, metric] expands expr decomposing all \
instances of the product metric and its derived curvature tensors in terms of \
the objects of the subvbundle that form the vbundle of metric. If the second \
argument is a list of product metrics the command is applied sequentially on \
expr.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d8de0315-27f1-44e8-afa8-0576c9216e42"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Tetra", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Tetra", "::", "usage"}], 
     "=", "\"\<Tetra[metric] returns the name of the tetra-metric associated \
to metric.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TetraRule", "::", "usage"}], 
     "=", "\"\<TetraRule[metric] gives the list of rules translating the \
tetra-metric of metric into products of metric and an imaginary term with the \
volume form of metric.\>\""}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"248cc3fe-ae5e-4ff3-9a91-34ff298d4d24"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1.13. Calculations", \
"Subsubsection",ExpressionUUID->"5ddc1620-dd11-46a7-aa54-4cc2603d915f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Calculations", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ScreenDollarIndices", "::", "usage"}], 
     "=", "\"\<ScreenDollarIndices[expr] replaces internal dummies \
(dollar-indices) by new non-dollar dummies for output.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Simplification", "::", "usage"}], 
     "=", "\"\<Simplification[expr] simplifies expr by calling Simplify[ \
ToCanonical[expr] ].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Validate", "::", "usage"}], 
     "=", "\"\<Validate[expr] checks that the tensorial expression expr 1) \
does not have unknown heads, 2) does not have objects with invalid index \
structure, 3) does have homogeneous free indices and 4) does not have \
repeated indices. There is a wrapping Catch.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"UncatchedValidate", "::", "usage"}], 
      "=", "\"\<UncatchedValidate[expr] is equivalente to Validate[expr] but \
without the wrapping Catch.\>\""}], ";"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IndexSolve", "::", "usage"}], 
     "=", "\"\<IndexSolve[eqn, tensor] solves a linear equation eqn for \
tensor, returning a rule (see MakeRule). Currently that tensor cannot have \
contracted indices. Options to IndexSolve are understood as options to \
MakeRule.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IndexCoefficient", "::", "usage"}], 
     "=", "\"\<IndexCoefficient[expr, form] gives the coefficient of form \
(any indexed object with no division present) in expr.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChangeFreeIndices", "::", "usage"}], 
     "=", "\"\<ChangeFreeIndices[expr, newfrees] changes the free indices in \
expr (after sorting them with IndexSort) by indices in the list newfrees, \
changing the dummies of expr which could interfere with any of those new \
indices.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"EqualExpressionsQ", "::", "usage"}], 
     "=", "\"\<EqualExpressionsQ[expr1, expr2] returns True if there is a \
permutation of the free indices of expr1 such that its canonical form equals \
that of expr2, and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IndexCollect", "::", "usage"}], 
     "=", "\"\<IndexCollect[expr, form, function] imitates the action of \
Collect, but allowing indexed expressions in form. This is still a very \
limited function, almost experimental.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SetCharacters", "::", "usage"}], 
     "=", "\"\<SetCharacters[expr, tensor, chars] returns expr with all \
instances of tensor[inds] corrected to match the characters chars, a list of \
elements Up or Down. The command introduces deltas, which automatically \
transform into metrics or Basis objects if required.\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d558edca-40c5-4b1d-9f67-ef1d3d05a4dd"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1.14. Color terms", \
"Subsubsection",ExpressionUUID->"e7f06f35-2484-4bb2-b7bf-8bd7aea13d2f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ColorTerms", "::", "usage"}], 
   "=", "\"\<ColorTerms[expr] uses the function ColorPositions (from the \
package ExpressionManipulation) to color the elements of the first level of \
expr, tagging them with their respective positions.\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ColorPositionsOfPattern", "::", "usage"}], 
   "=", "\"\<ColoPositionsOfPattern[pattern][expr] uses the function \
ColorPositions (from the package ExpressionManipulation) to color the \
occurrences of pattern in expr, tagging them with their respective positions. \
Options can be passed to ColorPositions within the first pair of \
brackets.\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"9b12c593-728f-46a8-9bb9-91c715e6d50a"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2. Begin Private", \
"Subsection",ExpressionUUID->"2f6fcf10-6acd-4368-80ee-dce444ee7a86"],

Cell[CellGroupData[{

Cell[TextData[{
 "1.2.1. A ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5 bug with contexts. Fixed in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6. Now deactivated"
}], "Subsubsection",ExpressionUUID->"5df3c2dd-a7fe-4ccd-9105-f4cc0d61d6c1"],

Cell["Nothing here goes into the package.", \
"Text",ExpressionUUID->"cca46c39-53f7-4ae8-b47e-dcdaa5bf0abf"],

Cell["\<\
Currently there are four contexts in the $ContextPath. Note that none of them \
is Global`.\
\>", "Text",ExpressionUUID->"7f20aedb-bbe0-46a1-9478-01178904958c"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 Evaluatable->False,ExpressionUUID->"89e92be6-6159-4b2a-960b-792e36b38b4c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`xTensor`\"\>", ",", "\<\"xAct`xCore`\"\>", 
   ",", "\<\"xAct`xPerm`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"fe4b4895-2864-4875-8254-a2c66f0c2c2e"]
}, Open  ]],

Cell["\<\
and the current context is (because we are constructing the package)\
\>", "Text",ExpressionUUID->"31719b88-e9c1-4777-b776-8b764d8caf99"],

Cell[CellGroupData[{

Cell[BoxData["$Context"], "Input",
 Evaluatable->False,ExpressionUUID->"2e7b557c-445d-40c4-9143-24a10edb5fc1"],

Cell[BoxData["\<\"xAct`xTensor`\"\>"], \
"Output",ExpressionUUID->"fb4bc73c-e3d1-4b64-a761-471b40c21953"]
}, Open  ]],

Cell[TextData[{
 "There is a bug in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5 (solved in 6). It creates symbols in $Context even if they already \
exists in one of the contexts of $ContextPath:"
}], "Text",ExpressionUUID->"d0e8a9a5-2a63-4bf3-8d57-5c6a78e02b95"],

Cell["Note the contexts of the five capitals:", \
"Text",ExpressionUUID->"0046e5fa-8c53-4030-835f-1939d4a22d72"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "/@", 
  RowBox[{"{", 
   RowBox[{"C", ",", "D", ",", "K", ",", "N", ",", "O"}], "}"}]}]], "Input",
 Evaluatable->False,ExpressionUUID->"46a9195f-db0f-4309-b58d-c8c8c9aa3996"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"5ea7865a-f5c6-4d28-a2dc-72f77ec35953"]
}, Open  ]],

Cell["\<\
For reference, let us introduce capitals A and B. Capital A is defined in the \
package context:\
\>", "Text",ExpressionUUID->"bfc7903c-3639-4047-bfbf-32338a23d4f9"],

Cell[CellGroupData[{

Cell[BoxData["A"], "Input",
 Evaluatable->False,ExpressionUUID->"7a1d32aa-5a12-4f86-a0de-c91983ec2e7c"],

Cell[BoxData["A"], \
"Output",ExpressionUUID->"e5af9785-bfb2-4e24-a06e-4976cfdb5ada"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "A", "]"}]], "Input",
 Evaluatable->False,ExpressionUUID->"e8d79b9f-3c3c-4e99-a851-c10c56a400b2"],

Cell[BoxData["\<\"xAct`xTensor`\"\>"], \
"Output",ExpressionUUID->"56998aa1-507f-452f-9c05-ea1a28678b10"]
}, Open  ]],

Cell["Now we start the Private` context:", \
"Text",ExpressionUUID->"f55ac99e-2875-4495-a9dc-b2c0335637f9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}]], "Input",
 Evaluatable->False,ExpressionUUID->"857c8ab2-3832-436c-bcf2-83df4231476e"],

Cell[BoxData["\<\"xAct`xTensor`Private`\"\>"], \
"Output",ExpressionUUID->"a801f4f6-5752-4008-b682-f6cde08fa528"]
}, Open  ]],

Cell["That changes the current $Context:", \
"Text",ExpressionUUID->"26bac830-a939-4324-82fd-05f05eab1a82"],

Cell[CellGroupData[{

Cell[BoxData["$Context"], "Input",
 Evaluatable->False,ExpressionUUID->"dcda3b21-d1b2-4df2-a978-15c157b00406"],

Cell[BoxData["\<\"xAct`xTensor`Private`\"\>"], \
"Output",ExpressionUUID->"3c3adc0f-5598-451f-a7b8-5b1f504d906d"]
}, Open  ]],

Cell["but not the $ContextPath:", \
"Text",ExpressionUUID->"7783a0ec-d2d6-49ab-b077-78f2f8779954"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 Evaluatable->False,ExpressionUUID->"826dabe9-73d7-4c82-b591-2611b983d54a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`xTensor`\"\>", ",", "\<\"xAct`xCore`\"\>", 
   ",", "\<\"xAct`xPerm`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"77ef610e-fb2b-4ffa-bc0e-78fc16afe240"]
}, Open  ]],

Cell["Capital B is now defined in the Private context:", \
"Text",ExpressionUUID->"f6bec1c3-8907-46ff-baf3-da069d78beb5"],

Cell[CellGroupData[{

Cell[BoxData["B"], "Input",
 Evaluatable->False,ExpressionUUID->"d2a552c6-9e83-4978-9a14-a2f06382b309"],

Cell[BoxData["B"], \
"Output",ExpressionUUID->"733c44d3-92b0-4e49-a905-83b4ee274755"]
}, Open  ]],

Cell["Therefore these three are all different:", \
"Text",ExpressionUUID->"2d853900-9858-4617-b71f-d0820f63f088"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "/@", 
  RowBox[{"{", 
   RowBox[{"A", ",", "B", ",", "C"}], "}"}]}]], "Input",
 Evaluatable->False,ExpressionUUID->"9ca03be1-b015-46ef-9f58-79bd8d257139"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`xTensor`\"\>", ",", "\<\"xAct`xTensor`Private`\"\>", 
   ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"9f88c72b-cd4b-4e15-9305-87c8aba2513c"]
}, Open  ]],

Cell["The problem is that if we do", \
"Text",ExpressionUUID->"2f83e430-2484-43c0-b040-4261f1492fb8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "A$", ",", "B$", ",", "C$", ",", "D$", ",", "K$", ",", "N$", ",", "O$"}], 
    "}"}], ",", 
   RowBox[{"Print", "[", 
    RowBox[{"{", 
     RowBox[{
     "A$", ",", "B$", ",", "C$", ",", "D$", ",", "K$", ",", "N$", ",", "O$"}],
      "}"}], "]"}]}], "]"}]], "Input",
 Evaluatable->False,ExpressionUUID->"bda149be-a028-47ec-acc3-8987c756d8d8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "A$476", ",", "B$476", ",", "C$476", ",", "D$476", ",", "K$476", ",", 
   "N$476", ",", "O$476"}], 
  "}"}]], "Print",ExpressionUUID->"603e5239-4184-46a8-a363-c312885bd314"]
}, Open  ]],

Cell[TextData[{
 "This was the result with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 5:"
}], "Text",ExpressionUUID->"251e1611-a798-4026-86d8-0a2696644c0a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "/@", 
  RowBox[{"{", 
   RowBox[{"A", ",", "B", ",", "C", ",", "D", ",", "K", ",", "N", ",", "O"}], 
   "}"}]}]], "Input",
 Evaluatable->False,ExpressionUUID->"dbd4dfb7-8f22-4455-959b-d1ef2d08c8d9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`xTensor`Private`\"\>", 
   ",", "\<\"xAct`xTensor`Private`\"\>", ",", "\<\"xAct`xTensor`Private`\"\>",
    ",", "\<\"xAct`xTensor`Private`\"\>", 
   ",", "\<\"xAct`xTensor`Private`\"\>", ",", "\<\"xAct`xTensor`Private`\"\>",
    ",", "\<\"xAct`xTensor`Private`\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"afaccd5d-ac8d-4406-88b5-23327d78cb3e"]
}, Open  ]],

Cell["Now it is", \
"Text",ExpressionUUID->"0ef30433-8b75-4ac3-952b-9fd591dd743f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "/@", 
  RowBox[{"{", 
   RowBox[{"A", ",", "B", ",", "C", ",", "D", ",", "K", ",", "N", ",", "O"}], 
   "}"}]}]], "Input",
 Evaluatable->False,ExpressionUUID->"e7b32e1a-26af-4bee-9cc6-729edab4e14a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`xTensor`\"\>", ",", "\<\"xAct`xTensor`Private`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"05f95cb6-265d-4689-bda0-72fba39dbdbc"]
}, Open  ]],

Cell[TextData[{
 "We see that symbols without dollar have been created in the \
xAct`xTensor`Private` context (the current $Context). It seems that the \
dollars in the variables in the Module list have been removed because the \
ouput variables contain just a single $ and not two, as I would have \
expected. I think this is a bug because it didn't happen in the previous 4.* \
versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". Developers from Wolfram Research Inc. tell me that you are not supposed \
to use something like C$ in the Module list, but I really want to do it. This \
problem is present in all 5.* versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and has been solved in 6.0."
}], "Text",ExpressionUUID->"a3dc3cde-f6fc-43d9-94db-8b189fa4d7c2"],

Cell["\<\
The most important consequence of this is that now the System` variables are \
shadowed by the xAct`xTensor`Private` symbols. If we now try to take a \
derivative nothing happens because D here is xAct`xTensor`Private`D and not \
System`D:\
\>", "Text",ExpressionUUID->"af36da0c-1f8b-4a27-b202-a9a93956d6e8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 Evaluatable->False,ExpressionUUID->"ec486950-f05c-4f9c-85cc-9f3d83645ccf"],

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], 
  "]"}]], "Output",ExpressionUUID->"c30f93f1-b43f-41fe-859a-5d8d8488b543"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 Evaluatable->False,ExpressionUUID->"8cdf9c33-a35d-469b-ab81-f2815a3ebbb1"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["f", "\[Prime]",
   MultilineFunction->None], "[", "x", 
  "]"}]], "Output",ExpressionUUID->"3282b397-f675-4aad-8d75-00f4b951ec8e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"System`D", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 Evaluatable->False,ExpressionUUID->"f0e66425-a59e-4deb-9fe0-555ed7d11f88"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["f", "\[Prime]",
   MultilineFunction->None], "[", "x", 
  "]"}]], "Output",ExpressionUUID->"5fb43d33-013c-45b8-958e-2bffaacea23c"]
}, Open  ]],

Cell["Clean up:", \
"Text",ExpressionUUID->"5cac0b31-4dfb-4342-88d3-face46143e02"],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"A", ",", "B", ",", "C", ",", "D", ",", "K", ",", "N", ",", "O"}], 
  "]"}]], "Input",
 Evaluatable->False,ExpressionUUID->"39893b17-5018-433c-9729-f6210236aa1d"],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"xAct`xTensor`A", ",", "xAct`xTensor`Private`B"}], "]"}]], "Input",
 Evaluatable->False,ExpressionUUID->"32aa3a0a-252c-4030-a0de-6297cfef071e"],

Cell["Now we get again", \
"Text",ExpressionUUID->"9d8a71e0-8e22-48ef-a38c-97533ad76cdb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "/@", 
  RowBox[{"{", 
   RowBox[{"C", ",", "D", ",", "K", ",", "N", ",", "O"}], "}"}]}]], "Input",
 Evaluatable->False,ExpressionUUID->"1ba4023f-ea39-4312-b92f-4122fcb25562"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"System`\"\>", ",", "\<\"System`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"46360a44-b7e6-45eb-8b37-f49a8a3c4f44"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"End", "[", "]"}]], "Input",
 Evaluatable->False,ExpressionUUID->"d461b865-f3ba-45cd-970e-58a683dba9eb"],

Cell[BoxData["\<\"xAct`xTensor`Private`\"\>"], \
"Output",ExpressionUUID->"bc2004d9-7738-4a1c-ad77-f08a44e42a8b"]
}, Open  ]],

Cell[TextData[{
 "This problem is closely related to the problem of the most appropriate \
context for the capitals C, D, K, N, O. The fact that ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " might generate new symbols in the $Context means that probably this is the \
best place to put those symbols when they are indices. During a normal \
session that context will be Global`. Therefore my recommendation is to \
define indices Global`D, etc, and then use System`D when a derivative is \
required. However, ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " will be prepared below to overload the system capitals, and that will be \
the default option if the user doesn't worry about this problem."
}], "Text",ExpressionUUID->"2ff7f469-c63d-44a9-bf5e-0bfdd64d7d95"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2.2. Begin Private", \
"Subsubsection",ExpressionUUID->"5b4e3b60-0d98-41c4-a151-6240503fd2b5"],

Cell["Now we do start the private context:", \
"Text",ExpressionUUID->"4ced89d9-e7ef-4743-abe3-f9ad77ead3d6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"eb9464c6-cc59-407c-96ac-b6a46bc918e9"],

Cell[BoxData["\<\"xAct`xTensor`Private`\"\>"], \
"Output",ExpressionUUID->"bfdd50c6-b207-4007-86d4-62c50c7d37de"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2.3. Context for the examples", \
"Subsubsection",ExpressionUUID->"cbe5e463-4e02-40f4-aed6-64e00f1bf1ec"],

Cell["\<\
In this notebook we shall follow this convention: examples are carried out in \
the Global` context, before ending the package, and therefore it is not \
possible to access xAct`xTensor`Private`  unless we append it to the \
$ContextPath:\
\>", "Text",ExpressionUUID->"db69a5d8-4b59-4c6e-9e48-ef6a55dbd46c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"BeginExamples", "[", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Set", "[", 
     RowBox[{"$Context", ",", "\"\<Global`\>\""}], "]"}], ";", 
    RowBox[{"Global`symbols", "=", 
     RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}]}], ";", "Null"}], 
   ")"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Global`EndExamples", "[", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"#", "=!=", 
         RowBox[{"{", "}"}]}], ",", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<There are new symbols in Global`:\>\"", ",", "#"}], 
         "]"}]}], "]"}], ";", 
      RowBox[{"Set", "[", 
       RowBox[{"$Context", ",", "\"\<xAct`xTensor`Private`\>\""}], "]"}], ";",
       "Null"}], ")"}], "&"}], "@", 
   RowBox[{"Complement", "[", 
    RowBox[{
     RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}], ",", "Global`symbols"}],
     "]"}]}]}]}], \
"Input",ExpressionUUID->"475ba399-6f88-446e-9f69-3d31fcf0e0b0"],

Cell["\<\
The only problem is that writing xAct`xTensor`Private is rather long. We \
define (ONLY IN THIS NOTEBOOK):\
\>", "Text",ExpressionUUID->"68268c91-77eb-4885-a108-030f8753dcde"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$PreRead", "=", 
  RowBox[{
   RowBox[{"ReplaceAll", "[", 
    RowBox[{"#", ",", 
     RowBox[{"expr_String", "\[RuleDelayed]", 
      RowBox[{"StringReplace", "[", 
       RowBox[{"expr", ",", 
        RowBox[{"\"\<xATP\>\"", "\[Rule]", "\"\<xAct`xTensor`Private\>\""}]}],
        "]"}]}]}], "]"}], 
   "&"}]}]], "Input",ExpressionUUID->"e2d189e3-c393-4d81-94d5-c482e8118223"],

Cell[BoxData[
 RowBox[{
  RowBox[{"#1", "/.", "\[VeryThinSpace]", 
   RowBox[{"expr_String", "\[RuleDelayed]", 
    RowBox[{"StringReplace", "[", 
     RowBox[{"expr", ",", 
      RowBox[{"\<\"xATP\"\>", "\[Rule]", "\<\"xAct`xTensor`Private\"\>"}]}], 
     "]"}]}]}], 
  "&"}]], "Output",ExpressionUUID->"e71bbf96-02fb-4cb2-9905-158e231967a2"]
}, Open  ]],

Cell[TextData[{
 "The global variable $PreRead is not used by any of the ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " packages. I find it too dangerous."
}], "Text",ExpressionUUID->"cf09f6d4-47f1-4683-abd9-4dac6a589675"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3. Usage of functions. Private", \
"Subsection",ExpressionUUID->"7f4d5ad6-8d43-4823-a270-1c06947067dc"],

Cell["All these usage messages do not go into the package.", \
"Text",ExpressionUUID->"18f59468-65e4-4a5a-830c-9e1a64e51c15"],

Cell[CellGroupData[{

Cell["1.3.1. Counting public symbols", \
"Subsubsection",ExpressionUUID->"e553feb1-a6a7-4f22-bcad-c5128e9ad71d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$xTensorNames", "=", 
   RowBox[{"Names", "[", "\"\<xAct`xTensor`*\>\"", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"05c36e7c-c745-40e1-9f30-5b774432d2f5"],

Cell[CellGroupData[{

Cell[BoxData["$xTensorNames"], \
"Input",ExpressionUUID->"a1d986be-6c64-4abe-97e1-a8d05d3069aa"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ABIndexQ\"\>", ",", "\<\"AbstractIndex\"\>", 
   ",", "\<\"AbstractIndexQ\"\>", ",", "\<\"Acceleration\"\>", 
   ",", "\<\"AChristoffel\"\>", ",", "\<\"AddIndices\"\>", 
   ",", "\<\"AIndex\"\>", ",", "\<\"AIndexQ\"\>", 
   ",", "\<\"AllowUpperDerivatives\"\>", ",", "\<\"Anticommutator\"\>", 
   ",", "\<\"Antihermitian\"\>", ",", "\<\"AntihermitianQ\"\>", 
   ",", "\<\"Antisymmetrize\"\>", ",", "\<\"AnyDependencies\"\>", 
   ",", "\<\"AnyIndices\"\>", ",", "\<\"AnyVBundles\"\>", 
   ",", "\<\"AssociativeProductQ\"\>", ",", "\<\"At\"\>", 
   ",", "\<\"AutomaticRules\"\>", ",", "\<\"BaseOfVBundle\"\>", 
   ",", "\<\"Basis\"\>", ",", "\<\"BasisQ\"\>", ",", "\<\"BCIndexQ\"\>", 
   ",", "\<\"BIndex\"\>", ",", "\<\"BIndexQ\"\>", ",", "\<\"Blocked\"\>", 
   ",", "\<\"BlockedQ\"\>", ",", "\<\"Bracket\"\>", 
   ",", "\<\"BracketToCovD\"\>", ",", "\<\"BreakChristoffel\"\>", 
   ",", "\<\"BreakInMonomials\"\>", ",", "\<\"BreakScalars\"\>", 
   ",", "\<\"CartesianProduct\"\>", ",", "\<\"CDIndexQ\"\>", 
   ",", "\<\"ChangeCovD\"\>", ",", "\<\"ChangeCurvature\"\>", 
   ",", "\<\"ChangeFreeIndices\"\>", ",", "\<\"ChangeIndex\"\>", 
   ",", "\<\"ChangeTorsion\"\>", ",", "\<\"Chart\"\>", ",", "\<\"ChartQ\"\>", 
   ",", "\<\"CheckZeroDerivative\"\>", 
   ",", "\<\"CheckZeroDerivativeStart\"\>", 
   ",", "\<\"CheckZeroDerivativeStop\"\>", ",", "\<\"Christoffel\"\>", 
   ",", "\<\"ChristoffelToGradConformal\"\>", 
   ",", "\<\"ChristoffelToGradMetric\"\>", ",", "\<\"ChristoffelToMetric\"\>",
    ",", "\<\"CIndex\"\>", ",", "\<\"CIndexForm\"\>", ",", "\<\"CIndexQ\"\>", 
   ",", "\<\"ColorPositionsOfPattern\"\>", ",", "\<\"ColorTerms\"\>", 
   ",", "\<\"CommutativityOfProduct\"\>", ",", "\<\"Commutator\"\>", 
   ",", "\<\"CommuteCovDs\"\>", ",", "\<\"CommutePDs\"\>", 
   ",", "\<\"ConformalFactor\"\>", ",", "\<\"ConformalRules\"\>", 
   ",", "\<\"ConformalTo\"\>", ",", "\<\"ConstantMetric\"\>", 
   ",", "\<\"ConstantQ\"\>", ",", "\<\"ConstantSymbol\"\>", 
   ",", "\<\"ConstantSymbolQ\"\>", ",", "\<\"ContractCurvature\"\>", 
   ",", "\<\"ContractDir\"\>", ",", "\<\"ContractMetric\"\>", 
   ",", "\<\"ContractMetrics\"\>", ",", "\<\"ContractProjector\"\>", 
   ",", "\<\"ContractThrough\"\>", ",", "\<\"ContractThroughQ\"\>", 
   ",", "\<\"CovD\"\>", ",", "\<\"CovDOfMetric\"\>", ",", "\<\"CovDQ\"\>", 
   ",", "\<\"CovDToChristoffel\"\>", ",", "\<\"Curvature\"\>", 
   ",", "\<\"CurvatureQ\"\>", ",", "\<\"CurvatureRelations\"\>", 
   ",", "\<\"Cyclize\"\>", ",", "\<\"Dagger\"\>", ",", "\<\"DaggerIndex\"\>", 
   ",", "\<\"DaggerQ\"\>", ",", "\<\"DefAbstractIndex\"\>", 
   ",", "\<\"DefConstantSymbol\"\>", ",", "\<\"DefCovD\"\>", 
   ",", "\<\"DefineCommutator\"\>", ",", "\<\"DefInertHead\"\>", 
   ",", "\<\"DefInfo\"\>", ",", "\<\"DefManifold\"\>", 
   ",", "\<\"DefMapping\"\>", ",", "\<\"DefMetric\"\>", 
   ",", "\<\"DefParameter\"\>", ",", "\<\"DefProduct\"\>", 
   ",", "\<\"DefProductMetric\"\>", ",", "\<\"DefScalarFunction\"\>", 
   ",", "\<\"DefTensor\"\>", ",", "\<\"DefVBundle\"\>", ",", "\<\"delta\"\>", 
   ",", "\<\"DependenciesOf\"\>", ",", "\<\"DependenciesOfCovD\"\>", 
   ",", "\<\"DependenciesOfInertHead\"\>", 
   ",", "\<\"DependenciesOfTensor\"\>", ",", "\<\"Determinant\"\>", 
   ",", "\<\"DiffeomorphismQ\"\>", ",", "\<\"DimOfManifold\"\>", 
   ",", "\<\"DimOfVBundle\"\>", ",", "\<\"DIndex\"\>", ",", "\<\"DIndexQ\"\>",
    ",", "\<\"Dir\"\>", ",", "\<\"DirCovDToLieD\"\>", 
   ",", "\<\"Disclaimer\"\>", ",", "\<\"DisjointManifoldsQ\"\>", 
   ",", "\<\"DisjointVBundlesQ\"\>", ",", "\<\"DisorderedPairQ\"\>", 
   ",", "\<\"Down\"\>", ",", "\<\"DownIndex\"\>", ",", "\<\"DownIndexQ\"\>", 
   ",", "\<\"DownVectorQ\"\>", ",", "\<\"Dummy\"\>", ",", "\<\"DummyAs\"\>", 
   ",", "\<\"DummyIn\"\>", ",", "\<\"EIndexQ\"\>", ",", "\<\"Einstein\"\>", 
   ",", "\<\"EinsteinToRicci\"\>", ",", "\<\"EmptyManifold\"\>", 
   ",", "\<\"epsilon\"\>", ",", "\<\"epsilonOrientation\"\>", 
   ",", "\<\"epsilonOrientationInBasis\"\>", ",", "\<\"EqualExpressionsQ\"\>",
    ",", "\<\"ERROR\"\>", ",", "\<\"ExpandCommutator\"\>", 
   ",", "\<\"ExpandGdelta\"\>", ",", "\<\"ExpandProductMetric\"\>", 
   ",", "\<\"ExpandPullBack\"\>", ",", "\<\"ExpandPushForward\"\>", 
   ",", "\<\"ExpandSdelta\"\>", ",", "\<\"Explode\"\>", 
   ",", "\<\"ExtendedFrom\"\>", ",", "\<\"ExtrinsicK\"\>", 
   ",", "\<\"ExtrinsicKToGradNormal\"\>", ",", "\<\"FindAllOfType\"\>", 
   ",", "\<\"FindBlockedIndices\"\>", ",", "\<\"FindDummyIndices\"\>", 
   ",", "\<\"FindFreeIndices\"\>", ",", "\<\"FindIndices\"\>", 
   ",", "\<\"FirstDerQ\"\>", ",", "\<\"FlatMetric\"\>", 
   ",", "\<\"FlatMetricQ\"\>", ",", "\<\"ForceSymmetries\"\>", 
   ",", "\<\"Free\"\>", ",", "\<\"FRiemann\"\>", ",", "\<\"FrobeniusQ\"\>", 
   ",", "\<\"FromMetric\"\>", ",", "\<\"FromProjected\"\>", 
   ",", "\<\"FromStripped\"\>", ",", "\<\"FromTensorDerivative\"\>", 
   ",", "\<\"GaussCodazzi\"\>", ",", "\<\"Gdelta\"\>", 
   ",", "\<\"GetIndicesOfVBundle\"\>", ",", "\<\"GIndexQ\"\>", 
   ",", "\<\"GiveOutputString\"\>", ",", "\<\"GiveSymbol\"\>", 
   ",", "\<\"Grade\"\>", ",", "\<\"GradedProductQ\"\>", 
   ",", "\<\"GradeOfCovD\"\>", ",", "\<\"GradeOfProduct\"\>", 
   ",", "\<\"GradeOfTensor\"\>", ",", "\<\"GradMetricToChristoffel\"\>", 
   ",", "\<\"GradNormalToExtrinsicK\"\>", ",", "\<\"HeadOfTensor\"\>", 
   ",", "\<\"Hermitian\"\>", ",", "\<\"HermitianQ\"\>", 
   ",", "\<\"HostsOf\"\>", ",", "\<\"IdentityElementOfProduct\"\>", 
   ",", "\<\"IdentityMapping\"\>", ",", "\<\"Imaginary\"\>", 
   ",", "\<\"ImmersionQ\"\>", ",", "\<\"IModQ\"\>", 
   ",", "\<\"ImplicitTensorDepQ\"\>", ",", "\<\"Implode\"\>", 
   ",", "\<\"ImposeSymmetry\"\>", ",", "\<\"IndexCoefficient\"\>", 
   ",", "\<\"IndexCollect\"\>", ",", "\<\"IndexForm\"\>", 
   ",", "\<\"IndexList\"\>", ",", "\<\"IndexOrderedQ\"\>", 
   ",", "\<\"IndexRange\"\>", ",", "\<\"IndexRule\"\>", 
   ",", "\<\"IndexRuleDelayed\"\>", ",", "\<\"IndexSet\"\>", 
   ",", "\<\"IndexSetDelayed\"\>", ",", "\<\"IndexSolve\"\>", 
   ",", "\<\"IndexSort\"\>", ",", "\<\"IndicesOf\"\>", 
   ",", "\<\"IndicesOfVBundle\"\>", ",", "\<\"InducedDecomposition\"\>", 
   ",", "\<\"InducedFrom\"\>", ",", "\<\"InertHead\"\>", 
   ",", "\<\"InertHeadQ\"\>", ",", "\<\"Inv\"\>", 
   ",", "\<\"InverseMapping\"\>", ",", "\<\"InvertibleQ\"\>", 
   ",", "\<\"IsIndexOf\"\>", ",", "\<\"Keep\"\>", ",", "\<\"Kretschmann\"\>", 
   ",", "\<\"Labels\"\>", ",", "\<\"LastIndex\"\>", ",", "\<\"LC\"\>", 
   ",", "\<\"Leibnitz\"\>", ",", "\<\"LI\"\>", ",", "\<\"LieD\"\>", 
   ",", "\<\"LieDToCovD\"\>", ",", "\<\"LIndex\"\>", ",", "\<\"LIndexQ\"\>", 
   ",", "\<\"LinearPush\"\>", ",", "\<\"LinearQ\"\>", 
   ",", "\<\"MakeProjectors\"\>", ",", "\<\"MakeRule\"\>", 
   ",", "\<\"Manifold\"\>", ",", "\<\"ManifoldBoundary\"\>", 
   ",", "\<\"ManifoldOfCovD\"\>", ",", "\<\"ManifoldQ\"\>", 
   ",", "\<\"ManifoldsOf\"\>", ",", "\<\"Mapping\"\>", 
   ",", "\<\"MappingDomain\"\>", ",", "\<\"MappingImage\"\>", 
   ",", "\<\"MappingQ\"\>", ",", "\<\"Master\"\>", ",", "\<\"MasterOf\"\>", 
   ",", "\<\"Metric\"\>", ",", "\<\"MetricEndowedQ\"\>", 
   ",", "\<\"MetricOfCovD\"\>", ",", "\<\"MetricOn\"\>", 
   ",", "\<\"MetricQ\"\>", ",", "\<\"MetricScalar\"\>", 
   ",", "\<\"MetricsOfVBundle\"\>", ",", "\<\"MetricToProjector\"\>", 
   ",", "\<\"Monomial\"\>", ",", "\<\"MultiplyHead\"\>", 
   ",", "\<\"NewIndexIn\"\>", ",", "\<\"NoScalar\"\>", 
   ",", "\<\"OrthogonalTo\"\>", ",", "\<\"OrthogonalToVectorQ\"\>", 
   ",", "\<\"OrthogonalWithMetric\"\>", ",", "\<\"OtherDependencies\"\>", 
   ",", "\<\"OverDerivatives\"\>", ",", "\<\"Pair\"\>", 
   ",", "\<\"PairAntisymmetrize\"\>", ",", "\<\"PairQ\"\>", 
   ",", "\<\"PairSymmetrize\"\>", ",", "\<\"ParamD\"\>", 
   ",", "\<\"ParameterQ\"\>", ",", "\<\"ParametersOf\"\>", 
   ",", "\<\"PatternIndex\"\>", ",", "\<\"PatternIndices\"\>", 
   ",", "\<\"PD\"\>", ",", "\<\"PermuteIndices\"\>", ",", "\<\"PIndex\"\>", 
   ",", "\<\"PIndexQ\"\>", ",", "\<\"Precompose\"\>", 
   ",", "\<\"PrimeDagger\"\>", ",", "\<\"PrintAs\"\>", 
   ",", "\<\"PrintAsCharacter\"\>", ",", "\<\"ProductByScalar\"\>", 
   ",", "\<\"ProductOfScalars\"\>", ",", "\<\"ProductQ\"\>", 
   ",", "\<\"Project\"\>", ",", "\<\"ProjectDerivative\"\>", 
   ",", "\<\"Projected\"\>", ",", "\<\"ProjectedWith\"\>", 
   ",", "\<\"Projector\"\>", ",", "\<\"ProjectorQ\"\>", 
   ",", "\<\"ProjectorToMetric\"\>", ",", "\<\"ProjectWith\"\>", 
   ",", "\<\"ProtectNewSymbol\"\>", ",", "\<\"PullBack\"\>", 
   ",", "\<\"PullBackCovD\"\>", ",", "\<\"PullBackTensor\"\>", 
   ",", "\<\"PullBackVBundle\"\>", ",", "\<\"PushForward\"\>", 
   ",", "\<\"PushForwardTensor\"\>", ",", "\<\"PutScalar\"\>", 
   ",", "\<\"RegisterIndices\"\>", ",", "\<\"RemoveIndices\"\>", 
   ",", "\<\"ReplaceDummies\"\>", ",", "\<\"ReplaceIndex\"\>", 
   ",", "\<\"Ricci\"\>", ",", "\<\"RicciScalar\"\>", 
   ",", "\<\"RicciToEinstein\"\>", ",", "\<\"RicciToTFRicci\"\>", 
   ",", "\<\"Riemann\"\>", ",", "\<\"RiemannDown\"\>", 
   ",", "\<\"RiemannDownToRiemann\"\>", ",", "\<\"RiemannToChristoffel\"\>", 
   ",", "\<\"RiemannToRiemannDown\"\>", ",", "\<\"RiemannToWeyl\"\>", 
   ",", "\<\"SameDummies\"\>", ",", "\<\"Scalar\"\>", 
   ",", "\<\"ScalarFunction\"\>", ",", "\<\"ScalarFunctionQ\"\>", 
   ",", "\<\"ScalarQ\"\>", ",", "\<\"ScalarsOfProduct\"\>", 
   ",", "\<\"ScreenDollarIndices\"\>", ",", "\<\"Sdelta\"\>", 
   ",", "\<\"SeparateDir\"\>", ",", "\<\"SeparateMetric\"\>", 
   ",", "\<\"ServantsOf\"\>", ",", "\<\"SetCharacters\"\>", 
   ",", "\<\"SetConformalTo\"\>", ",", "\<\"SetIndexSortPriorities\"\>", 
   ",", "\<\"SetOrthogonal\"\>", ",", "\<\"SetProjected\"\>", 
   ",", "\<\"SetSplitTensors\"\>", ",", "\<\"SignatureOfMetric\"\>", 
   ",", "\<\"SignDetOfMetric\"\>", ",", "\<\"Simplification\"\>", 
   ",", "\<\"SlotsOfTensor\"\>", ",", "\<\"SortCovDs\"\>", 
   ",", "\<\"SortCovDsStart\"\>", ",", "\<\"SortCovDsStop\"\>", 
   ",", "\<\"SplitIndex\"\>", ",", "\<\"SplitManifold\"\>", 
   ",", "\<\"SplitTensor\"\>", ",", "\<\"SplittingsOfManifold\"\>", 
   ",", "\<\"SplittingsOfVBundle\"\>", ",", "\<\"SplitVBundle\"\>", 
   ",", "\<\"STFPart\"\>", ",", "\<\"Stripped\"\>", 
   ",", "\<\"SubdummiesIn\"\>", ",", "\<\"SubmanifoldQ\"\>", 
   ",", "\<\"SubmanifoldsOfManifold\"\>", ",", "\<\"SubmersionQ\"\>", 
   ",", "\<\"SubvbundleQ\"\>", ",", "\<\"SubvbundlesOfVBundle\"\>", 
   ",", "\<\"Supercommutator\"\>", ",", "\<\"Sym\"\>", 
   ",", "\<\"SymbolOfCovD\"\>", ",", "\<\"Symmetrize\"\>", 
   ",", "\<\"Symmetry\"\>", ",", "\<\"SymmetryGroupOfCovD\"\>", 
   ",", "\<\"SymmetryGroupOfTensor\"\>", ",", "\<\"SymmetryOf\"\>", 
   ",", "\<\"SymmetryTableauxOfTensor\"\>", ",", "\<\"Tangent\"\>", 
   ",", "\<\"TangentBundleOfManifold\"\>", ",", "\<\"TangentTensor\"\>", 
   ",", "\<\"Tensor\"\>", ",", "\<\"TensorD\"\>", 
   ",", "\<\"TensorDerivative\"\>", ",", "\<\"TensorID\"\>", 
   ",", "\<\"TestIndices\"\>", ",", "\<\"Tetra\"\>", ",", "\<\"TetraRule\"\>",
    ",", "\<\"TFRicci\"\>", ",", "\<\"TFRicciToRicci\"\>", 
   ",", "\<\"ToCanonical\"\>", ",", "\<\"ToInducedDerivative\"\>", 
   ",", "\<\"Torsion\"\>", ",", "\<\"TorsionQ\"\>", 
   ",", "\<\"TorsionToChristoffel\"\>", ",", "\<\"ToRule\"\>", 
   ",", "\<\"ToStripped\"\>", ",", "\<\"ToTensorDerivative\"\>", 
   ",", "\<\"TraceDummy\"\>", ",", "\<\"TraceProductDummy\"\>", 
   ",", "\<\"TransposeDagger\"\>", ",", "\<\"Undef\"\>", 
   ",", "\<\"UndefAbstractIndex\"\>", ",", "\<\"UndefConstantSymbol\"\>", 
   ",", "\<\"UndefCovD\"\>", ",", "\<\"UndefInertHead\"\>", 
   ",", "\<\"UndefManifold\"\>", ",", "\<\"UndefMapping\"\>", 
   ",", "\<\"UndefMetric\"\>", ",", "\<\"UndefParameter\"\>", 
   ",", "\<\"UndefProduct\"\>", ",", "\<\"UndefScalarFunction\"\>", 
   ",", "\<\"UndefTensor\"\>", ",", "\<\"UndefVBundle\"\>", ",", "\<\"Up\"\>",
    ",", "\<\"UpIndex\"\>", ",", "\<\"UpIndexQ\"\>", ",", "\<\"UpVectorQ\"\>",
    ",", "\<\"UseMetricOnVBundle\"\>", ",", "\<\"UseSymmetries\"\>", 
   ",", "\<\"UxSort\"\>", ",", "\<\"Validate\"\>", 
   ",", "\<\"ValidateSymbolInSession\"\>", ",", "\<\"VanishingQ\"\>", 
   ",", "\<\"VarD\"\>", ",", "\<\"VBundle\"\>", ",", "\<\"VBundleOfIndex\"\>",
    ",", "\<\"VBundleOfMetric\"\>", ",", "\<\"VBundleQ\"\>", 
   ",", "\<\"VBundlesOfCovD\"\>", ",", "\<\"VectorOfInducedMetric\"\>", 
   ",", "\<\"VisitorsOf\"\>", ",", "\<\"WeightedWithBasis\"\>", 
   ",", "\<\"WeightOf\"\>", ",", "\<\"WeightOfTensor\"\>", 
   ",", "\<\"Weyl\"\>", ",", "\<\"WeylToRiemann\"\>", ",", "\<\"xSort\"\>", 
   ",", "\<\"xSortOrder\"\>", ",", "\<\"xSortPrecedence\"\>", 
   ",", "\<\"xTensorFormStart\"\>", ",", "\<\"xTensorFormStop\"\>", 
   ",", "\<\"xTensorQ\"\>", ",", "\<\"Zero\"\>", 
   ",", "\<\"$AbstractIndices\"\>", ",", "\<\"$AccelerationSign\"\>", 
   ",", "\<\"$Bases\"\>", ",", "\<\"$Charts\"\>", 
   ",", "\<\"$CheckZeroDerivativeVerbose\"\>", ",", "\<\"$CIndexForm\"\>", 
   ",", "\<\"$CommuteCovDsOnScalars\"\>", ",", "\<\"$ComputeNewDummies\"\>", 
   ",", "\<\"$ConstantSymbols\"\>", ",", "\<\"$CovDFormat\"\>", 
   ",", "\<\"$CovDs\"\>", ",", "\<\"$DefInfoQ\"\>", 
   ",", "\<\"$epsilonSign\"\>", ",", "\<\"$ExtrinsicKSign\"\>", 
   ",", "\<\"$FindIndicesAcceptedHeads\"\>", ",", "\<\"$ImplodeInfoQ\"\>", 
   ",", "\<\"$IndexListColor\"\>", ",", "\<\"$InertHeads\"\>", 
   ",", "\<\"$Manifolds\"\>", ",", "\<\"$Mappings\"\>", 
   ",", "\<\"$Metrics\"\>", ",", "\<\"$MixedDers\"\>", 
   ",", "\<\"$ParamDFormat\"\>", ",", "\<\"$Parameters\"\>", 
   ",", "\<\"$ProductManifolds\"\>", ",", "\<\"$ProductMetrics\"\>", 
   ",", "\<\"$Products\"\>", ",", "\<\"$ProjectedFormat\"\>", 
   ",", "\<\"$ProtectNewSymbols\"\>", ",", "\<\"$ReadingVerbose\"\>", 
   ",", "\<\"$RicciSign\"\>", ",", "\<\"$RiemannSign\"\>", 
   ",", "\<\"$Rules\"\>", ",", "\<\"$ScalarColor\"\>", 
   ",", "\<\"$ScalarFunctions\"\>", ",", "\<\"$SeparateScalarsFromScalar\"\>",
    ",", "\<\"$SumVBundles\"\>", ",", "\<\"$TensorBoxes\"\>", 
   ",", "\<\"$Tensors\"\>", ",", "\<\"$TorsionSign\"\>", 
   ",", "\<\"$TraceDummyVerbose\"\>", ",", "\<\"$UndefInfoQ\"\>", 
   ",", "\<\"$VBundles\"\>", ",", "\<\"$Version\"\>", 
   ",", "\<\"$xPermVersionExpected\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"25e15193-f8ab-4802-b55c-f80e2ae62a2b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$xTensorDollarNames", "=", 
  RowBox[{"Select", "[", 
   RowBox[{"$xTensorNames", ",", 
    RowBox[{
     RowBox[{"StringMatchQ", "[", 
      RowBox[{"#", ",", "\"\<$*\>\""}], "]"}], "&"}]}], 
   "]"}]}]], "Input",ExpressionUUID->"519dbb31-b257-4f95-a67e-b155f358b135"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"$AbstractIndices\"\>", ",", "\<\"$AccelerationSign\"\>", 
   ",", "\<\"$Bases\"\>", ",", "\<\"$Charts\"\>", 
   ",", "\<\"$CheckZeroDerivativeVerbose\"\>", ",", "\<\"$CIndexForm\"\>", 
   ",", "\<\"$CommuteCovDsOnScalars\"\>", ",", "\<\"$ComputeNewDummies\"\>", 
   ",", "\<\"$ConstantSymbols\"\>", ",", "\<\"$CovDFormat\"\>", 
   ",", "\<\"$CovDs\"\>", ",", "\<\"$DefInfoQ\"\>", 
   ",", "\<\"$epsilonSign\"\>", ",", "\<\"$ExtrinsicKSign\"\>", 
   ",", "\<\"$FindIndicesAcceptedHeads\"\>", ",", "\<\"$ImplodeInfoQ\"\>", 
   ",", "\<\"$IndexListColor\"\>", ",", "\<\"$InertHeads\"\>", 
   ",", "\<\"$Manifolds\"\>", ",", "\<\"$Mappings\"\>", 
   ",", "\<\"$Metrics\"\>", ",", "\<\"$MixedDers\"\>", 
   ",", "\<\"$ParamDFormat\"\>", ",", "\<\"$Parameters\"\>", 
   ",", "\<\"$ProductManifolds\"\>", ",", "\<\"$ProductMetrics\"\>", 
   ",", "\<\"$Products\"\>", ",", "\<\"$ProjectedFormat\"\>", 
   ",", "\<\"$ProtectNewSymbols\"\>", ",", "\<\"$ReadingVerbose\"\>", 
   ",", "\<\"$RicciSign\"\>", ",", "\<\"$RiemannSign\"\>", 
   ",", "\<\"$Rules\"\>", ",", "\<\"$ScalarColor\"\>", 
   ",", "\<\"$ScalarFunctions\"\>", ",", "\<\"$SeparateScalarsFromScalar\"\>",
    ",", "\<\"$SumVBundles\"\>", ",", "\<\"$TensorBoxes\"\>", 
   ",", "\<\"$Tensors\"\>", ",", "\<\"$TorsionSign\"\>", 
   ",", "\<\"$TraceDummyVerbose\"\>", ",", "\<\"$UndefInfoQ\"\>", 
   ",", "\<\"$VBundles\"\>", ",", "\<\"$Version\"\>", 
   ",", "\<\"$xPermVersionExpected\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"24b0f0b0-1fc9-4b8d-bb85-624d8d40dffd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$xTensorNonDollarNames", "=", 
  RowBox[{"Complement", "[", 
   RowBox[{"$xTensorNames", ",", "$xTensorDollarNames"}], 
   "]"}]}]], "Input",ExpressionUUID->"c10303f1-d48a-471a-9603-6794c7dfecf2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ABIndexQ\"\>", ",", "\<\"AbstractIndex\"\>", 
   ",", "\<\"AbstractIndexQ\"\>", ",", "\<\"Acceleration\"\>", 
   ",", "\<\"AChristoffel\"\>", ",", "\<\"AddIndices\"\>", 
   ",", "\<\"AIndex\"\>", ",", "\<\"AIndexQ\"\>", 
   ",", "\<\"AllowUpperDerivatives\"\>", ",", "\<\"Anticommutator\"\>", 
   ",", "\<\"Antihermitian\"\>", ",", "\<\"AntihermitianQ\"\>", 
   ",", "\<\"Antisymmetrize\"\>", ",", "\<\"AnyDependencies\"\>", 
   ",", "\<\"AnyIndices\"\>", ",", "\<\"AnyVBundles\"\>", 
   ",", "\<\"AssociativeProductQ\"\>", ",", "\<\"At\"\>", 
   ",", "\<\"AutomaticRules\"\>", ",", "\<\"BaseOfVBundle\"\>", 
   ",", "\<\"Basis\"\>", ",", "\<\"BasisQ\"\>", ",", "\<\"BCIndexQ\"\>", 
   ",", "\<\"BIndex\"\>", ",", "\<\"BIndexQ\"\>", ",", "\<\"Blocked\"\>", 
   ",", "\<\"BlockedQ\"\>", ",", "\<\"Bracket\"\>", 
   ",", "\<\"BracketToCovD\"\>", ",", "\<\"BreakChristoffel\"\>", 
   ",", "\<\"BreakInMonomials\"\>", ",", "\<\"BreakScalars\"\>", 
   ",", "\<\"CartesianProduct\"\>", ",", "\<\"CDIndexQ\"\>", 
   ",", "\<\"ChangeCovD\"\>", ",", "\<\"ChangeCurvature\"\>", 
   ",", "\<\"ChangeFreeIndices\"\>", ",", "\<\"ChangeIndex\"\>", 
   ",", "\<\"ChangeTorsion\"\>", ",", "\<\"Chart\"\>", ",", "\<\"ChartQ\"\>", 
   ",", "\<\"CheckZeroDerivative\"\>", 
   ",", "\<\"CheckZeroDerivativeStart\"\>", 
   ",", "\<\"CheckZeroDerivativeStop\"\>", ",", "\<\"Christoffel\"\>", 
   ",", "\<\"ChristoffelToGradConformal\"\>", 
   ",", "\<\"ChristoffelToGradMetric\"\>", ",", "\<\"ChristoffelToMetric\"\>",
    ",", "\<\"CIndex\"\>", ",", "\<\"CIndexForm\"\>", ",", "\<\"CIndexQ\"\>", 
   ",", "\<\"ColorPositionsOfPattern\"\>", ",", "\<\"ColorTerms\"\>", 
   ",", "\<\"CommutativityOfProduct\"\>", ",", "\<\"Commutator\"\>", 
   ",", "\<\"CommuteCovDs\"\>", ",", "\<\"CommutePDs\"\>", 
   ",", "\<\"ConformalFactor\"\>", ",", "\<\"ConformalRules\"\>", 
   ",", "\<\"ConformalTo\"\>", ",", "\<\"ConstantMetric\"\>", 
   ",", "\<\"ConstantQ\"\>", ",", "\<\"ConstantSymbol\"\>", 
   ",", "\<\"ConstantSymbolQ\"\>", ",", "\<\"ContractCurvature\"\>", 
   ",", "\<\"ContractDir\"\>", ",", "\<\"ContractMetric\"\>", 
   ",", "\<\"ContractMetrics\"\>", ",", "\<\"ContractProjector\"\>", 
   ",", "\<\"ContractThrough\"\>", ",", "\<\"ContractThroughQ\"\>", 
   ",", "\<\"CovD\"\>", ",", "\<\"CovDOfMetric\"\>", ",", "\<\"CovDQ\"\>", 
   ",", "\<\"CovDToChristoffel\"\>", ",", "\<\"Curvature\"\>", 
   ",", "\<\"CurvatureQ\"\>", ",", "\<\"CurvatureRelations\"\>", 
   ",", "\<\"Cyclize\"\>", ",", "\<\"Dagger\"\>", ",", "\<\"DaggerIndex\"\>", 
   ",", "\<\"DaggerQ\"\>", ",", "\<\"DefAbstractIndex\"\>", 
   ",", "\<\"DefConstantSymbol\"\>", ",", "\<\"DefCovD\"\>", 
   ",", "\<\"DefineCommutator\"\>", ",", "\<\"DefInertHead\"\>", 
   ",", "\<\"DefInfo\"\>", ",", "\<\"DefManifold\"\>", 
   ",", "\<\"DefMapping\"\>", ",", "\<\"DefMetric\"\>", 
   ",", "\<\"DefParameter\"\>", ",", "\<\"DefProduct\"\>", 
   ",", "\<\"DefProductMetric\"\>", ",", "\<\"DefScalarFunction\"\>", 
   ",", "\<\"DefTensor\"\>", ",", "\<\"DefVBundle\"\>", ",", "\<\"delta\"\>", 
   ",", "\<\"DependenciesOf\"\>", ",", "\<\"DependenciesOfCovD\"\>", 
   ",", "\<\"DependenciesOfInertHead\"\>", 
   ",", "\<\"DependenciesOfTensor\"\>", ",", "\<\"Determinant\"\>", 
   ",", "\<\"DiffeomorphismQ\"\>", ",", "\<\"DimOfManifold\"\>", 
   ",", "\<\"DimOfVBundle\"\>", ",", "\<\"DIndex\"\>", ",", "\<\"DIndexQ\"\>",
    ",", "\<\"Dir\"\>", ",", "\<\"DirCovDToLieD\"\>", 
   ",", "\<\"Disclaimer\"\>", ",", "\<\"DisjointManifoldsQ\"\>", 
   ",", "\<\"DisjointVBundlesQ\"\>", ",", "\<\"DisorderedPairQ\"\>", 
   ",", "\<\"Down\"\>", ",", "\<\"DownIndex\"\>", ",", "\<\"DownIndexQ\"\>", 
   ",", "\<\"DownVectorQ\"\>", ",", "\<\"Dummy\"\>", ",", "\<\"DummyAs\"\>", 
   ",", "\<\"DummyIn\"\>", ",", "\<\"EIndexQ\"\>", ",", "\<\"Einstein\"\>", 
   ",", "\<\"EinsteinToRicci\"\>", ",", "\<\"EmptyManifold\"\>", 
   ",", "\<\"epsilon\"\>", ",", "\<\"epsilonOrientation\"\>", 
   ",", "\<\"epsilonOrientationInBasis\"\>", ",", "\<\"EqualExpressionsQ\"\>",
    ",", "\<\"ERROR\"\>", ",", "\<\"ExpandCommutator\"\>", 
   ",", "\<\"ExpandGdelta\"\>", ",", "\<\"ExpandProductMetric\"\>", 
   ",", "\<\"ExpandPullBack\"\>", ",", "\<\"ExpandPushForward\"\>", 
   ",", "\<\"ExpandSdelta\"\>", ",", "\<\"Explode\"\>", 
   ",", "\<\"ExtendedFrom\"\>", ",", "\<\"ExtrinsicK\"\>", 
   ",", "\<\"ExtrinsicKToGradNormal\"\>", ",", "\<\"FindAllOfType\"\>", 
   ",", "\<\"FindBlockedIndices\"\>", ",", "\<\"FindDummyIndices\"\>", 
   ",", "\<\"FindFreeIndices\"\>", ",", "\<\"FindIndices\"\>", 
   ",", "\<\"FirstDerQ\"\>", ",", "\<\"FlatMetric\"\>", 
   ",", "\<\"FlatMetricQ\"\>", ",", "\<\"ForceSymmetries\"\>", 
   ",", "\<\"Free\"\>", ",", "\<\"FRiemann\"\>", ",", "\<\"FrobeniusQ\"\>", 
   ",", "\<\"FromMetric\"\>", ",", "\<\"FromProjected\"\>", 
   ",", "\<\"FromStripped\"\>", ",", "\<\"FromTensorDerivative\"\>", 
   ",", "\<\"GaussCodazzi\"\>", ",", "\<\"Gdelta\"\>", 
   ",", "\<\"GetIndicesOfVBundle\"\>", ",", "\<\"GIndexQ\"\>", 
   ",", "\<\"GiveOutputString\"\>", ",", "\<\"GiveSymbol\"\>", 
   ",", "\<\"Grade\"\>", ",", "\<\"GradedProductQ\"\>", 
   ",", "\<\"GradeOfCovD\"\>", ",", "\<\"GradeOfProduct\"\>", 
   ",", "\<\"GradeOfTensor\"\>", ",", "\<\"GradMetricToChristoffel\"\>", 
   ",", "\<\"GradNormalToExtrinsicK\"\>", ",", "\<\"HeadOfTensor\"\>", 
   ",", "\<\"Hermitian\"\>", ",", "\<\"HermitianQ\"\>", 
   ",", "\<\"HostsOf\"\>", ",", "\<\"IdentityElementOfProduct\"\>", 
   ",", "\<\"IdentityMapping\"\>", ",", "\<\"Imaginary\"\>", 
   ",", "\<\"ImmersionQ\"\>", ",", "\<\"IModQ\"\>", 
   ",", "\<\"ImplicitTensorDepQ\"\>", ",", "\<\"Implode\"\>", 
   ",", "\<\"ImposeSymmetry\"\>", ",", "\<\"IndexCoefficient\"\>", 
   ",", "\<\"IndexCollect\"\>", ",", "\<\"IndexForm\"\>", 
   ",", "\<\"IndexList\"\>", ",", "\<\"IndexOrderedQ\"\>", 
   ",", "\<\"IndexRange\"\>", ",", "\<\"IndexRule\"\>", 
   ",", "\<\"IndexRuleDelayed\"\>", ",", "\<\"IndexSet\"\>", 
   ",", "\<\"IndexSetDelayed\"\>", ",", "\<\"IndexSolve\"\>", 
   ",", "\<\"IndexSort\"\>", ",", "\<\"IndicesOf\"\>", 
   ",", "\<\"IndicesOfVBundle\"\>", ",", "\<\"InducedDecomposition\"\>", 
   ",", "\<\"InducedFrom\"\>", ",", "\<\"InertHead\"\>", 
   ",", "\<\"InertHeadQ\"\>", ",", "\<\"Inv\"\>", 
   ",", "\<\"InverseMapping\"\>", ",", "\<\"InvertibleQ\"\>", 
   ",", "\<\"IsIndexOf\"\>", ",", "\<\"Keep\"\>", ",", "\<\"Kretschmann\"\>", 
   ",", "\<\"Labels\"\>", ",", "\<\"LastIndex\"\>", ",", "\<\"LC\"\>", 
   ",", "\<\"Leibnitz\"\>", ",", "\<\"LI\"\>", ",", "\<\"LieD\"\>", 
   ",", "\<\"LieDToCovD\"\>", ",", "\<\"LIndex\"\>", ",", "\<\"LIndexQ\"\>", 
   ",", "\<\"LinearPush\"\>", ",", "\<\"LinearQ\"\>", 
   ",", "\<\"MakeProjectors\"\>", ",", "\<\"MakeRule\"\>", 
   ",", "\<\"Manifold\"\>", ",", "\<\"ManifoldBoundary\"\>", 
   ",", "\<\"ManifoldOfCovD\"\>", ",", "\<\"ManifoldQ\"\>", 
   ",", "\<\"ManifoldsOf\"\>", ",", "\<\"Mapping\"\>", 
   ",", "\<\"MappingDomain\"\>", ",", "\<\"MappingImage\"\>", 
   ",", "\<\"MappingQ\"\>", ",", "\<\"Master\"\>", ",", "\<\"MasterOf\"\>", 
   ",", "\<\"Metric\"\>", ",", "\<\"MetricEndowedQ\"\>", 
   ",", "\<\"MetricOfCovD\"\>", ",", "\<\"MetricOn\"\>", 
   ",", "\<\"MetricQ\"\>", ",", "\<\"MetricScalar\"\>", 
   ",", "\<\"MetricsOfVBundle\"\>", ",", "\<\"MetricToProjector\"\>", 
   ",", "\<\"Monomial\"\>", ",", "\<\"MultiplyHead\"\>", 
   ",", "\<\"NewIndexIn\"\>", ",", "\<\"NoScalar\"\>", 
   ",", "\<\"OrthogonalTo\"\>", ",", "\<\"OrthogonalToVectorQ\"\>", 
   ",", "\<\"OrthogonalWithMetric\"\>", ",", "\<\"OtherDependencies\"\>", 
   ",", "\<\"OverDerivatives\"\>", ",", "\<\"Pair\"\>", 
   ",", "\<\"PairAntisymmetrize\"\>", ",", "\<\"PairQ\"\>", 
   ",", "\<\"PairSymmetrize\"\>", ",", "\<\"ParamD\"\>", 
   ",", "\<\"ParameterQ\"\>", ",", "\<\"ParametersOf\"\>", 
   ",", "\<\"PatternIndex\"\>", ",", "\<\"PatternIndices\"\>", 
   ",", "\<\"PD\"\>", ",", "\<\"PermuteIndices\"\>", ",", "\<\"PIndex\"\>", 
   ",", "\<\"PIndexQ\"\>", ",", "\<\"Precompose\"\>", 
   ",", "\<\"PrimeDagger\"\>", ",", "\<\"PrintAs\"\>", 
   ",", "\<\"PrintAsCharacter\"\>", ",", "\<\"ProductByScalar\"\>", 
   ",", "\<\"ProductOfScalars\"\>", ",", "\<\"ProductQ\"\>", 
   ",", "\<\"Project\"\>", ",", "\<\"ProjectDerivative\"\>", 
   ",", "\<\"Projected\"\>", ",", "\<\"ProjectedWith\"\>", 
   ",", "\<\"Projector\"\>", ",", "\<\"ProjectorQ\"\>", 
   ",", "\<\"ProjectorToMetric\"\>", ",", "\<\"ProjectWith\"\>", 
   ",", "\<\"ProtectNewSymbol\"\>", ",", "\<\"PullBack\"\>", 
   ",", "\<\"PullBackCovD\"\>", ",", "\<\"PullBackTensor\"\>", 
   ",", "\<\"PullBackVBundle\"\>", ",", "\<\"PushForward\"\>", 
   ",", "\<\"PushForwardTensor\"\>", ",", "\<\"PutScalar\"\>", 
   ",", "\<\"RegisterIndices\"\>", ",", "\<\"RemoveIndices\"\>", 
   ",", "\<\"ReplaceDummies\"\>", ",", "\<\"ReplaceIndex\"\>", 
   ",", "\<\"Ricci\"\>", ",", "\<\"RicciScalar\"\>", 
   ",", "\<\"RicciToEinstein\"\>", ",", "\<\"RicciToTFRicci\"\>", 
   ",", "\<\"Riemann\"\>", ",", "\<\"RiemannDown\"\>", 
   ",", "\<\"RiemannDownToRiemann\"\>", ",", "\<\"RiemannToChristoffel\"\>", 
   ",", "\<\"RiemannToRiemannDown\"\>", ",", "\<\"RiemannToWeyl\"\>", 
   ",", "\<\"SameDummies\"\>", ",", "\<\"Scalar\"\>", 
   ",", "\<\"ScalarFunction\"\>", ",", "\<\"ScalarFunctionQ\"\>", 
   ",", "\<\"ScalarQ\"\>", ",", "\<\"ScalarsOfProduct\"\>", 
   ",", "\<\"ScreenDollarIndices\"\>", ",", "\<\"Sdelta\"\>", 
   ",", "\<\"SeparateDir\"\>", ",", "\<\"SeparateMetric\"\>", 
   ",", "\<\"ServantsOf\"\>", ",", "\<\"SetCharacters\"\>", 
   ",", "\<\"SetConformalTo\"\>", ",", "\<\"SetIndexSortPriorities\"\>", 
   ",", "\<\"SetOrthogonal\"\>", ",", "\<\"SetProjected\"\>", 
   ",", "\<\"SetSplitTensors\"\>", ",", "\<\"SignatureOfMetric\"\>", 
   ",", "\<\"SignDetOfMetric\"\>", ",", "\<\"Simplification\"\>", 
   ",", "\<\"SlotsOfTensor\"\>", ",", "\<\"SortCovDs\"\>", 
   ",", "\<\"SortCovDsStart\"\>", ",", "\<\"SortCovDsStop\"\>", 
   ",", "\<\"SplitIndex\"\>", ",", "\<\"SplitManifold\"\>", 
   ",", "\<\"SplitTensor\"\>", ",", "\<\"SplittingsOfManifold\"\>", 
   ",", "\<\"SplittingsOfVBundle\"\>", ",", "\<\"SplitVBundle\"\>", 
   ",", "\<\"STFPart\"\>", ",", "\<\"Stripped\"\>", 
   ",", "\<\"SubdummiesIn\"\>", ",", "\<\"SubmanifoldQ\"\>", 
   ",", "\<\"SubmanifoldsOfManifold\"\>", ",", "\<\"SubmersionQ\"\>", 
   ",", "\<\"SubvbundleQ\"\>", ",", "\<\"SubvbundlesOfVBundle\"\>", 
   ",", "\<\"Supercommutator\"\>", ",", "\<\"Sym\"\>", 
   ",", "\<\"SymbolOfCovD\"\>", ",", "\<\"Symmetrize\"\>", 
   ",", "\<\"Symmetry\"\>", ",", "\<\"SymmetryGroupOfCovD\"\>", 
   ",", "\<\"SymmetryGroupOfTensor\"\>", ",", "\<\"SymmetryOf\"\>", 
   ",", "\<\"SymmetryTableauxOfTensor\"\>", ",", "\<\"Tangent\"\>", 
   ",", "\<\"TangentBundleOfManifold\"\>", ",", "\<\"TangentTensor\"\>", 
   ",", "\<\"Tensor\"\>", ",", "\<\"TensorD\"\>", 
   ",", "\<\"TensorDerivative\"\>", ",", "\<\"TensorID\"\>", 
   ",", "\<\"TestIndices\"\>", ",", "\<\"Tetra\"\>", ",", "\<\"TetraRule\"\>",
    ",", "\<\"TFRicci\"\>", ",", "\<\"TFRicciToRicci\"\>", 
   ",", "\<\"ToCanonical\"\>", ",", "\<\"ToInducedDerivative\"\>", 
   ",", "\<\"Torsion\"\>", ",", "\<\"TorsionQ\"\>", 
   ",", "\<\"TorsionToChristoffel\"\>", ",", "\<\"ToRule\"\>", 
   ",", "\<\"ToStripped\"\>", ",", "\<\"ToTensorDerivative\"\>", 
   ",", "\<\"TraceDummy\"\>", ",", "\<\"TraceProductDummy\"\>", 
   ",", "\<\"TransposeDagger\"\>", ",", "\<\"Undef\"\>", 
   ",", "\<\"UndefAbstractIndex\"\>", ",", "\<\"UndefConstantSymbol\"\>", 
   ",", "\<\"UndefCovD\"\>", ",", "\<\"UndefInertHead\"\>", 
   ",", "\<\"UndefManifold\"\>", ",", "\<\"UndefMapping\"\>", 
   ",", "\<\"UndefMetric\"\>", ",", "\<\"UndefParameter\"\>", 
   ",", "\<\"UndefProduct\"\>", ",", "\<\"UndefScalarFunction\"\>", 
   ",", "\<\"UndefTensor\"\>", ",", "\<\"UndefVBundle\"\>", ",", "\<\"Up\"\>",
    ",", "\<\"UpIndex\"\>", ",", "\<\"UpIndexQ\"\>", ",", "\<\"UpVectorQ\"\>",
    ",", "\<\"UseMetricOnVBundle\"\>", ",", "\<\"UseSymmetries\"\>", 
   ",", "\<\"UxSort\"\>", ",", "\<\"Validate\"\>", 
   ",", "\<\"ValidateSymbolInSession\"\>", ",", "\<\"VanishingQ\"\>", 
   ",", "\<\"VarD\"\>", ",", "\<\"VBundle\"\>", ",", "\<\"VBundleOfIndex\"\>",
    ",", "\<\"VBundleOfMetric\"\>", ",", "\<\"VBundleQ\"\>", 
   ",", "\<\"VBundlesOfCovD\"\>", ",", "\<\"VectorOfInducedMetric\"\>", 
   ",", "\<\"VisitorsOf\"\>", ",", "\<\"WeightedWithBasis\"\>", 
   ",", "\<\"WeightOf\"\>", ",", "\<\"WeightOfTensor\"\>", 
   ",", "\<\"Weyl\"\>", ",", "\<\"WeylToRiemann\"\>", ",", "\<\"xSort\"\>", 
   ",", "\<\"xSortOrder\"\>", ",", "\<\"xSortPrecedence\"\>", 
   ",", "\<\"xTensorFormStart\"\>", ",", "\<\"xTensorFormStop\"\>", 
   ",", "\<\"xTensorQ\"\>", ",", "\<\"Zero\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"9005f9e3-6c25-45f3-954b-d7ad5a2d9731"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", 
  RowBox[{"{", 
   RowBox[{
   "$xTensorNonDollarNames", ",", "$xTensorDollarNames", ",", 
    "$xTensorNames"}], 
   "}"}]}]], "Input",ExpressionUUID->"0d35fa2a-56fd-44cb-b26c-7425007a5d17"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"409", ",", "45", ",", "454"}], 
  "}"}]], "Output",ExpressionUUID->"b88007f9-9581-4bb5-a36f-f787095eb45a"]
}, Open  ]],

Cell["Compare with the documentation files:", \
"Text",ExpressionUUID->"3f814537-f621-47f5-a3c0-0a944707be89"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"filename", "[", "string_String", "]"}], ":=", 
   RowBox[{"StringReplacePart", "[", 
    RowBox[{
     RowBox[{"StringReplacePart", "[", 
      RowBox[{"string", ",", "\"\<\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{
          RowBox[{"StringLength", "[", "$xActDocDirectory", "]"}], "+", 
          "9"}]}], "}"}]}], "]"}], ",", "\"\<\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"docfiles", "=", 
   RowBox[{"filename", "/@", 
    RowBox[{"FileNames", "[", 
     RowBox[{"$xActDocDirectory", "<>", "\"\</xTensor/*.nb\>\""}], "]"}]}]}], 
  ";"}]}], "Input",ExpressionUUID->"a43189ce-6dd2-4f72-a9cd-8661f8466673"],

Cell[TextData[{
 "These are the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " builtins which have been overloaded:"
}], "Text",ExpressionUUID->"9ccf3417-5fcf-492a-af3d-d3681f06b5f0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{"docfiles", ",", "$xTensorNames"}], 
  "]"}]], "Input",ExpressionUUID->"d35fae05-7148-4a3c-bece-6b81d58397aa"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"CircleDot\"\>", ",", "\<\"Complex\"\>", 
   ",", "\<\"DoubleRightTee\"\>", ",", "\<\"OverDot\"\>", 
   ",", "\<\"Parameter\"\>", ",", "\<\"Real\"\>", 
   ",", "\<\"RightTeeArrow\"\>", ",", "\<\"Verbose\"\>", 
   ",", "\<\"$CommuteFreeIndices\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"2eeeccc8-e042-4f63-b1dc-335f17d8643b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Complex"}]], \
"Input",ExpressionUUID->"b4833fa9-632d-465c-b03c-7494b8ae79fa"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox[
           PaneBox[
            TooltipBox[
             ButtonBox[
              PaneSelectorBox[{False->
               
               DynamicBox[FEPrivate`FrontEndResource[
                "FEBitmaps", "InformationHelpIcon"]], True->
               
               DynamicBox[FEPrivate`FrontEndResource[
                "FEBitmaps", "InformationHelpIconHot"]]}, Dynamic[
                CurrentValue["MouseOver"]]],
              Appearance->None,
              BaseStyle->"Link",
              ButtonData->"paclet:ref/Complex",
              ButtonNote->"paclet:ref/Complex"],
             "\"paclet:ref/Complex\""],
            FrameMargins->{{0, 4}, {0, 2}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Complex is the head used for complex numbers. \"\>",
              "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Documentation\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Documentation\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Documentation", "Tooltip"]& ], 
                   TemplateBox[{
                    
                    TemplateBox[{
                    "\"Local \[RightGuillemet]\"", "paclet:ref/Complex", 
                    "paclet:ref/Complex", "Link", {
                    RGBColor[0.9686274509803922, 0.4666666666666667, 0.]}, 
                    BaseStyle -> {
                    RGBColor[0.0784313725490196, 0.1568627450980392, 0.6]}}, 
                    "HyperlinkTemplate"], "\"  \"", 
                    StyleBox[
                    "\"|\"", "InformationRowLabel", StripOnInput -> False], 
                    "\"  \"", 
                    TemplateBox[{"\"Web \[RightGuillemet]\"", {
                    URL[
                    "http://reference.wolfram.com/language/ref/Complex.html"],
                     None}, 
                    "http://reference.wolfram.com/language/ref/Complex.html", 
                    "Hyperlink", {
                    RGBColor[0.9686274509803922, 0.4666666666666667, 0.]}, 
                    BaseStyle -> {
                    RGBColor[0.0784313725490196, 0.1568627450980392, 0.6]}}, 
                    "HyperlinkTemplate"]},
                    "RowDefault"]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"System`Complex\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox[
           PaneBox[
            TooltipBox[
             ButtonBox[
              PaneSelectorBox[{False->
               
               DynamicBox[FEPrivate`FrontEndResource[
                "FEBitmaps", "InformationHelpIcon"],
                ImageSizeCache->{13., {3.634033203125, 9.365966796875}}], 
               True->
               
               DynamicBox[FEPrivate`FrontEndResource[
                "FEBitmaps", "InformationHelpIconHot"],
                ImageSizeCache->{13., {3.634033203125, 9.365966796875}}]}, 
               Dynamic[
                CurrentValue["MouseOver"]]],
              Appearance->None,
              BaseStyle->"Link",
              ButtonData->"paclet:ref/Complex",
              ButtonNote->"paclet:ref/Complex"],
             "\"paclet:ref/Complex\""],
            FrameMargins->{{0, 4}, {0, 2}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Complex is the head used for complex numbers. \"\>",
              "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "Complex is the head used for complex numbers. ", 
    "Documentation" -> <|
     "Local" -> "paclet:ref/Complex", "Web" -> 
      "http://reference.wolfram.com/language/ref/Complex.html"|>, "OwnValues" -> 
    None, "UpValues" -> None, "DownValues" -> None, "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {Protected}, "FullName" -> 
    "System`Complex"|>, 
   False]]], "Output",ExpressionUUID->"89dc2ceb-321d-4470-bf57-52b424274d37"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Real"}]], "Input",ExpressionUUID->"abe31ff7-73fe-4af5-8423-ec930281985c"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox[
           PaneBox[
            TooltipBox[
             ButtonBox[
              PaneSelectorBox[{False->
               
               DynamicBox[FEPrivate`FrontEndResource[
                "FEBitmaps", "InformationHelpIcon"]], True->
               
               DynamicBox[FEPrivate`FrontEndResource[
                "FEBitmaps", "InformationHelpIconHot"]]}, Dynamic[
                CurrentValue["MouseOver"]]],
              Appearance->None,
              BaseStyle->"Link",
              ButtonData->"paclet:ref/Real",
              ButtonNote->"paclet:ref/Real"],
             "\"paclet:ref/Real\""],
            FrameMargins->{{0, 4}, {0, 2}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Real is the head used for real \
(floating\[Hyphen]point) numbers. \"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Documentation\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Documentation\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Documentation", "Tooltip"]& ], 
                   TemplateBox[{
                    
                    TemplateBox[{
                    "\"Local \[RightGuillemet]\"", "paclet:ref/Real", 
                    "paclet:ref/Real", "Link", {
                    RGBColor[0.9686274509803922, 0.4666666666666667, 0.]}, 
                    BaseStyle -> {
                    RGBColor[0.0784313725490196, 0.1568627450980392, 0.6]}}, 
                    "HyperlinkTemplate"], "\"  \"", 
                    StyleBox[
                    "\"|\"", "InformationRowLabel", StripOnInput -> False], 
                    "\"  \"", 
                    TemplateBox[{"\"Web \[RightGuillemet]\"", {
                    URL[
                    "http://reference.wolfram.com/language/ref/Real.html"], 
                    None}, "http://reference.wolfram.com/language/ref/Real.\
html", "Hyperlink", {
                    RGBColor[0.9686274509803922, 0.4666666666666667, 0.]}, 
                    BaseStyle -> {
                    RGBColor[0.0784313725490196, 0.1568627450980392, 0.6]}}, 
                    "HyperlinkTemplate"]},
                    "RowDefault"]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"System`Real\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox[
           PaneBox[
            TooltipBox[
             ButtonBox[
              PaneSelectorBox[{False->
               
               DynamicBox[FEPrivate`FrontEndResource[
                "FEBitmaps", "InformationHelpIcon"],
                ImageSizeCache->{13., {3.634033203125, 9.365966796875}}], 
               True->
               
               DynamicBox[FEPrivate`FrontEndResource[
                "FEBitmaps", "InformationHelpIconHot"],
                ImageSizeCache->{13., {3.634033203125, 9.365966796875}}]}, 
               Dynamic[
                CurrentValue["MouseOver"]]],
              Appearance->None,
              BaseStyle->"Link",
              ButtonData->"paclet:ref/Real",
              ButtonNote->"paclet:ref/Real"],
             "\"paclet:ref/Real\""],
            FrameMargins->{{0, 4}, {0, 2}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Real is the head used for real \
(floating\[Hyphen]point) numbers. \"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "Real is the head used for real (floating\[Hyphen]point) numbers. ", 
    "Documentation" -> <|
     "Local" -> "paclet:ref/Real", "Web" -> 
      "http://reference.wolfram.com/language/ref/Real.html"|>, "OwnValues" -> 
    None, "UpValues" -> None, "DownValues" -> None, "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {Protected}, "FullName" -> 
    "System`Real"|>, 
   False]]], "Output",ExpressionUUID->"49e0c387-cc27-408d-9648-f40558ddb345"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Verbose"}]], \
"Input",ExpressionUUID->"88b32b73-2b81-4f33-b541-ba161c27bd44"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Verbose is a Boolean option for MakeRule, \
AutomaticRules and ToCanonical. Verbose->True gives lots of log-info about \
the internals of the calculation. Its default value is False.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"System`Verbose\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Verbose is a Boolean option for MakeRule, \
AutomaticRules and ToCanonical. Verbose->True gives lots of log-info about \
the internals of the calculation. Its default value is False.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "Verbose is a Boolean option for MakeRule, AutomaticRules and \
ToCanonical. Verbose->True gives lots of log-info about the internals of the \
calculation. Its default value is False.", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {Protected}, 
    "FullName" -> "System`Verbose"|>, 
   False]]], "Output",ExpressionUUID->"e5095704-ebfb-4c66-a772-c238140b4281"]
}, Open  ]],

Cell["These are the missing symbols to document:", \
"Text",ExpressionUUID->"6363d603-5caf-4f2c-854d-5670759ea1cc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"toclassify1", "=", 
  RowBox[{"Complement", "[", 
   RowBox[{"$xTensorNames", ",", "docfiles"}], 
   "]"}]}]], "Input",ExpressionUUID->"8478b926-5fbc-4115-9f25-b07e429a5616"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Anticommutator\"\>", ",", "\<\"AntihermitianQ\"\>", 
   ",", "\<\"AnyVBundles\"\>", ",", "\<\"AssociativeProductQ\"\>", 
   ",", "\<\"At\"\>", ",", "\<\"CartesianProduct\"\>", 
   ",", "\<\"ChristoffelToGradConformal\"\>", 
   ",", "\<\"CommutativityOfProduct\"\>", ",", "\<\"Commutator\"\>", 
   ",", "\<\"ConformalFactor\"\>", ",", "\<\"ConformalRules\"\>", 
   ",", "\<\"ConformalTo\"\>", ",", "\<\"ContractProjector\"\>", 
   ",", "\<\"Cyclize\"\>", ",", "\<\"DefineCommutator\"\>", 
   ",", "\<\"DefMapping\"\>", ",", "\<\"DefProduct\"\>", 
   ",", "\<\"DependenciesOfCovD\"\>", ",", "\<\"DependenciesOfInertHead\"\>", 
   ",", "\<\"DiffeomorphismQ\"\>", ",", "\<\"DirCovDToLieD\"\>", 
   ",", "\<\"DisjointVBundlesQ\"\>", ",", "\<\"DummyAs\"\>", 
   ",", "\<\"EmptyManifold\"\>", ",", "\<\"epsilonOrientation\"\>", 
   ",", "\<\"epsilonOrientationInBasis\"\>", ",", "\<\"ExpandCommutator\"\>", 
   ",", "\<\"ExpandPullBack\"\>", ",", "\<\"ExpandPushForward\"\>", 
   ",", "\<\"ExpandSdelta\"\>", ",", "\<\"Explode\"\>", 
   ",", "\<\"FromProjected\"\>", ",", "\<\"FromStripped\"\>", 
   ",", "\<\"FromTensorDerivative\"\>", ",", "\<\"GaussCodazzi\"\>", 
   ",", "\<\"Grade\"\>", ",", "\<\"GradedProductQ\"\>", 
   ",", "\<\"GradeOfCovD\"\>", ",", "\<\"GradeOfProduct\"\>", 
   ",", "\<\"GradeOfTensor\"\>", ",", "\<\"HeadOfTensor\"\>", 
   ",", "\<\"HermitianQ\"\>", ",", "\<\"IdentityElementOfProduct\"\>", 
   ",", "\<\"IdentityMapping\"\>", ",", "\<\"ImmersionQ\"\>", 
   ",", "\<\"IModQ\"\>", ",", "\<\"ImplicitTensorDepQ\"\>", 
   ",", "\<\"Implode\"\>", ",", "\<\"InverseMapping\"\>", 
   ",", "\<\"InvertibleQ\"\>", ",", "\<\"Keep\"\>", 
   ",", "\<\"Kretschmann\"\>", ",", "\<\"LastIndex\"\>", ",", "\<\"LC\"\>", 
   ",", "\<\"Leibnitz\"\>", ",", "\<\"LinearPush\"\>", 
   ",", "\<\"MakeProjectors\"\>", ",", "\<\"ManifoldBoundary\"\>", 
   ",", "\<\"Mapping\"\>", ",", "\<\"MappingDomain\"\>", 
   ",", "\<\"MappingImage\"\>", ",", "\<\"MappingQ\"\>", 
   ",", "\<\"MultiplyHead\"\>", ",", "\<\"OrthogonalToVectorQ\"\>", 
   ",", "\<\"OrthogonalWithMetric\"\>", ",", "\<\"OtherDependencies\"\>", 
   ",", "\<\"Pair\"\>", ",", "\<\"Precompose\"\>", ",", "\<\"PrimeDagger\"\>",
    ",", "\<\"PrintAsCharacter\"\>", ",", "\<\"ProductByScalar\"\>", 
   ",", "\<\"ProductOfScalars\"\>", ",", "\<\"ProductQ\"\>", 
   ",", "\<\"Project\"\>", ",", "\<\"Projected\"\>", 
   ",", "\<\"ProjectorQ\"\>", ",", "\<\"PullBack\"\>", 
   ",", "\<\"PullBackCovD\"\>", ",", "\<\"PullBackTensor\"\>", 
   ",", "\<\"PullBackVBundle\"\>", ",", "\<\"PushForward\"\>", 
   ",", "\<\"PushForwardTensor\"\>", ",", "\<\"RegisterIndices\"\>", 
   ",", "\<\"RiemannDown\"\>", ",", "\<\"RiemannDownToRiemann\"\>", 
   ",", "\<\"RiemannToRiemannDown\"\>", ",", "\<\"ScalarsOfProduct\"\>", 
   ",", "\<\"Sdelta\"\>", ",", "\<\"SetConformalTo\"\>", 
   ",", "\<\"SetSplitTensors\"\>", ",", "\<\"SplitManifold\"\>", 
   ",", "\<\"SplitTensor\"\>", ",", "\<\"SplittingsOfManifold\"\>", 
   ",", "\<\"SplittingsOfVBundle\"\>", ",", "\<\"SplitVBundle\"\>", 
   ",", "\<\"Stripped\"\>", ",", "\<\"SubmersionQ\"\>", 
   ",", "\<\"Supercommutator\"\>", ",", "\<\"Sym\"\>", 
   ",", "\<\"SymmetryGroupOfCovD\"\>", ",", "\<\"TangentTensor\"\>", 
   ",", "\<\"TensorD\"\>", ",", "\<\"TensorDerivative\"\>", 
   ",", "\<\"Tetra\"\>", ",", "\<\"TetraRule\"\>", ",", "\<\"ToRule\"\>", 
   ",", "\<\"ToStripped\"\>", ",", "\<\"ToTensorDerivative\"\>", 
   ",", "\<\"UndefMapping\"\>", ",", "\<\"UndefProduct\"\>", 
   ",", "\<\"UxSort\"\>", ",", "\<\"xSortOrder\"\>", 
   ",", "\<\"xSortPrecedence\"\>", ",", "\<\"$DefInfoQ\"\>", 
   ",", "\<\"$ImplodeInfoQ\"\>", ",", "\<\"$IndexListColor\"\>", 
   ",", "\<\"$Mappings\"\>", ",", "\<\"$ParamDFormat\"\>", 
   ",", "\<\"$Products\"\>", ",", "\<\"$ProjectedFormat\"\>", 
   ",", "\<\"$ScalarColor\"\>", ",", "\<\"$SeparateScalarsFromScalar\"\>", 
   ",", "\<\"$TensorBoxes\"\>", ",", "\<\"$UndefInfoQ\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"f20ce355-7fb4-4543-a925-ccb5f70400b7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"2cf50901-760c-4d44-95ee-7670047f3bda"],

Cell[BoxData["124"], \
"Output",ExpressionUUID->"b3d09e9f-af1d-4a89-81e9-fc9d16ae5a05"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"toclassify2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<Conformal\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<ConformalFactor\>\"", ",", "\"\<ConformalRules\>\"", 
        ",", "\"\<ConformalTo\>\"", ",", "\"\<SetConformalTo\>\"", 
        ",", "\"\<ChristoffelToGradConformal\>\""}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"\"\<Mapping\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<At\>\"", ",", "\"\<CartesianProduct\>\"", 
        ",", "\"\<DefMapping\>\"", ",", "\"\<DiffeomorphismQ\>\"", 
        ",", "\"\<ExpandPullBack\>\"", ",", "\"\<ExpandPushForward\>\"", 
        ",", "\"\<IdentityMapping\>\"", ",", "\"\<ImmersionQ\>\"", 
        ",", "\"\<InverseMapping\>\"", ",", "\"\<InvertibleQ\>\"", 
        ",", "\"\<LinearPush\>\"", ",", "\"\<Mapping\>\"", 
        ",", "\"\<MappingDomain\>\"", ",", "\"\<MappingImage\>\"", 
        ",", "\"\<MappingQ\>\"", ",", "\"\<Precompose\>\"", 
        ",", "\"\<PullBack\>\"", ",", "\"\<PullBackCovD\>\"", 
        ",", "\"\<PullBackTensor\>\"", ",", "\"\<PullBackVBundle\>\"", 
        ",", "\"\<PushForward\>\"", ",", "\"\<PushForwardTensor\>\"", 
        ",", "\"\<SubmersionQ\>\"", ",", "\"\<TangentTensor\>\"", 
        ",", "\"\<UndefMapping\>\"", ",", "\"\<$Mappings\>\""}], "}"}]}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"\"\<Projectors\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<ContractProjector\>\"", ",", "\"\<DisjointVBundlesQ\>\"", 
        ",", "\"\<ProjectorQ\>\"", ",", "\"\<SetSplitTensors\>\"", 
        ",", "\"\<SplitManifold\>\"", ",", "\"\<SplitTensor\>\"", 
        ",", "\"\<SplitVBundle\>\"", ",", "\"\<FromProjected\>\"", 
        ",", "\"\<Project\>\"", ",", "\"\<Projected\>\"", 
        ",", "\"\<$ProjectedFormat\>\"", ",", "\"\<MakeProjectors\>\"", 
        ",", "\"\<OrthogonalWithMetric\>\"", 
        ",", "\"\<OrthogonalToVectorQ\>\""}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"\"\<Symmetries\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Cyclize\>\"", ",", "\"\<ExpandSdelta\>\"", 
        ",", "\"\<Sdelta\>\"", ",", "\"\<Sym\>\""}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"\"\<Derivatives\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<LC\>\"", ",", "\"\<DependenciesOfCovD\>\"", 
        ",", "\"\<DirCovDToLieD\>\"", ",", "\"\<FromTensorDerivative\>\"", 
        ",", "\"\<Explode\>\"", ",", "\"\<Implode\>\"", 
        ",", "\"\<ImplicitTensorDepQ\>\"", ",", "\"\<Kretschmann\>\"", 
        ",", "\"\<OtherDependencies\>\"", ",", "\"\<RiemannDown\>\"", 
        ",", "\"\<RiemannDownToRiemann\>\"", 
        ",", "\"\<RiemannToRiemannDown\>\"", ",", "\"\<ToTensorDerivative\>\"",
         ",", "\"\<$ImplodeInfoQ\>\"", ",", "\"\<TensorD\>\"", 
        ",", "\"\<TensorDerivative\>\"", ",", "\"\<$ParamDFormat\>\"", 
        ",", "\"\<Tetra\>\"", ",", "\"\<TetraRule\>\"", 
        ",", "\"\<SymmetryGroupOfCovD\>\"", ",", "\"\<Leibnitz\>\"", 
        ",", "\"\<GaussCodazzi\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<Other\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<AnyVBundles\>\"", ",", "\"\<DummyAs\>\"", 
        ",", "\"\<FromStripped\>\"", ",", "\"\<Keep\>\"", 
        ",", "\"\<LastIndex\>\"", ",", "\"\<PrintAsCharacter\>\"", 
        ",", "\"\<RegisterIndices\>\"", ",", "\"\<SplittingsOfManifold\>\"", 
        ",", "\"\<SplittingsOfVBundle\>\"", ",", "\"\<Stripped\>\"", 
        ",", "\"\<ToStripped\>\"", ",", "\"\<IModQ\>\"", 
        ",", "\"\<$DefInfoQ\>\"", ",", "\"\<$IndexListColor\>\"", 
        ",", "\"\<$ScalarColor\>\"", ",", "\"\<$TensorBoxes\>\"", 
        ",", "\"\<$UndefInfoQ\>\"", ",", "\"\<HeadOfTensor\>\"", 
        ",", "\"\<MultiplyHead\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<Complex\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<AntihermitianQ\>\"", ",", "\"\<HermitianQ\>\"", 
        ",", "\"\<Pair\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"\"\<epsilon\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<epsilonOrientation\>\"", 
        ",", "\"\<epsilonOrientationInBasis\>\""}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"\"\<Products\>\"", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<AssociativeProductQ\>\"", ",", "\"\<Commutator\>\"", 
        ",", "\"\<DefineCommutator\>\"", ",", "\"\<DefProduct\>\"", 
        ",", "\"\<Grade\>\"", ",", "\"\<GradedProductQ\>\"", 
        ",", "\"\<GradeOfCovD\>\"", ",", "\"\<GradeOfProduct\>\"", 
        ",", "\"\<GradeOfTensor\>\"", ",", "\"\<IdentityElementOfProduct\>\"",
         ",", "\"\<ProductByScalar\>\"", ",", "\"\<ProductQ\>\"", 
        ",", "\"\<ScalarsOfProduct\>\"", ",", "\"\<CommutativityOfProduct\>\"",
         ",", "\"\<UndefProduct\>\"", ",", "\"\<$Products\>\""}], "}"}]}]}], 
    "\[IndentingNewLine]", "}"}]}], 
  ";"}]], "Input",ExpressionUUID->"3aa2839a-4378-4e89-8808-0d1ff8fd94b9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{"toclassify1", ",", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Last", "/@", "toclassify2"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"1d7b53fd-8b51-4b51-92f7-294dcbbddd85"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Anticommutator\"\>", ",", "\<\"DependenciesOfInertHead\"\>", 
   ",", "\<\"EmptyManifold\"\>", ",", "\<\"ExpandCommutator\"\>", 
   ",", "\<\"ManifoldBoundary\"\>", ",", "\<\"PrimeDagger\"\>", 
   ",", "\<\"ProductOfScalars\"\>", ",", "\<\"Supercommutator\"\>", 
   ",", "\<\"ToRule\"\>", ",", "\<\"UxSort\"\>", ",", "\<\"xSortOrder\"\>", ",", \
"\<\"xSortPrecedence\"\>", ",", "\<\"$SeparateScalarsFromScalar\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"36cfbbdf-6629-4060-9aae-7720d0eb2cbc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Complement", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{"Last", "/@", "toclassify2"}], "]"}], ",", "toclassify1"}], 
  "]"}]], "Input",ExpressionUUID->"90bbaa5d-d2df-4424-901e-37c83e6fb779"],

Cell[BoxData[
 RowBox[{"{", 
  "}"}]], "Output",ExpressionUUID->"24414689-34a4-40d2-a1fd-b38777abec42"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Remove", "[", 
   RowBox[{
   "filename", ",", "docfiles", ",", "toclassify1", ",", "toclassify2"}], 
   "]"}], ";"}]], \
"Input",ExpressionUUID->"39d8090e-c842-4a6d-8dd6-3525afbf0426"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3.2. Types", \
"Subsubsection",ExpressionUUID->"a6d888f9-7d29-4fa6-8912-794e4f977d12"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Removing", " ", "symbols"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"CheckRemoveSymbol", "::", "usage"}], 
     "=", "\"\<xTensor`Private`CheckRemoveSymbol[symbol] throws an error if \
symbol has visitors or its master has other servants. Otherwise it gives \
Null.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RemoveSymbol", "::", "usage"}], 
     "=", "\"\<xTensor`Private`RemoveSymbol[symbol] unprotects (if protected) \
and removes symbol.\>\""}], 
    ";"}]}]}]], \
"Input",ExpressionUUID->"16b39a67-a977-4961-8fce-9100b0c3057c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Symbols", " ", "relations"}], " ", "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{
    RowBox[{"SymbolRelations", "::", "usage"}], 
    "=", "\"\<xTensor`Private`SymbolRelations[symbol, master, hosts] defines \
the pair master-servant, and register symbol as a visitor of the given list \
of hosts. This function is listable in its first argument.\>\""}], 
   ";"}]}]], "Input",ExpressionUUID->"842dbcfc-f19b-4731-80ca-0c4c8b5abc75"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Types", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"$Types", "::", "usage"}], 
     "=", "\"\<xTensor`Private`$Types is a global variable containing the \
list of types currently defined in xTensor.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$QFunctions", "::", "usage"}], 
     "=", "\"\<xTensor`Private`$QFunctions is a global variable containing \
the list of Q-functions associated to the types in $Types.\>\""}], 
    ";"}]}]}]], \
"Input",ExpressionUUID->"48e73b1b-3888-4e35-829f-c2334bd9c846"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Box", "-", 
    RowBox[{"formatting", " ", "of", " ", "expressions"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"SetPrintAs", "::", "usage"}], 
     "=", "\"\<xTensor`Private`SetPrintAs[symbol, string] defines the PrintAs \
upvalue associated to the symbol to be the given string. It uses xUpSet or \
xUpSetDelayed to protect/unprotect symbol if required.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AddDaggerCharacter", "::", "usage"}], 
     "=", "\"\<xTensor`Private`AddDaggerCharacter[string, Conjugate] appends \
the $DaggerCharacter to string if it not present already. \
AddDaggerCharacter[string, dag] returns string for any other value of \
dag.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PrintAsString", "::", "usage"}], 
     "=", "\"\<xTensor`Private`PrintAsString[symbol, pa] returns pa if pa has \
head String. Otherwise it assumes pa is a function to be applied on symbol \
and returns ToString[pa[symbol]].\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"interpretbox", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"interpretboxcolor", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"boxof", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MakeSequenceBox", "::", "usage"}], "=", "\"\<\>\""}], 
    ";"}]}]}]], \
"Input",ExpressionUUID->"dce2bfb7-4ba1-4796-be40-3f42d5d14695"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Def", "/", "Undef"}], " ", "messages"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"makespace", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MakeDefInfo", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MakeUndefInfo", "::", "usage"}], "=", "\"\<\>\""}], 
    ";"}]}]}]], "Input",ExpressionUUID->"2b3bd74d-dd92-4b92-8cbe-17611de497cf"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3.3. Four simple types", \
"Subsubsection",ExpressionUUID->"f01b656a-5c08-4169-9804-b4dcd34a252c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"$sfunctions", "::", "usage"}], 
   "=", "\"\<xTensor`Private`$sfunctions is a global variable containing the \
list of functions which are initially defined as scalar-functions.\>\""}], 
  ";"}]], "Input",ExpressionUUID->"14084b26-b50b-4982-861c-098bf312aa4b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SetDaggerPair", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}]], "Input",ExpressionUUID->"23f9e531-3fac-4854-a26b-9ef737e82ce8"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3.4. The mathematical input", \
"Subsubsection",ExpressionUUID->"a2d47976-15f8-40fd-bd94-9874666231c5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ListOfTerms", "::", "usage"}], 
   "=", "\"\<xTensor`Private`ListOfTerms[expr] gives the list of elements of \
expr if its head is Plus and {expr} otherwise. The expression expr is \
evaluated and expanded (using Expand) before checking its head.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ListOfFactors", "::", "usage"}], 
   "=", "\"\<xTensor`Private`ListOfFactors[expr] gives the list of elements \
of expr if its head is Times and {expr} otherwise. The expression expr is \
evaluated and factored (usign Factor) before checking its head.\>\""}], 
  ";"}]}], "Input",ExpressionUUID->"6e2c9935-82ca-4687-81b7-28e39a9c025f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"MathInputExpand", "::", "usage"}], 
   "=", "\"\<xTensor`Private`MathInputExpand[expr] applies Expand to expr \
using FixedPoint.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"NonIndexedScalarQ", "::", "usage"}], 
   "=", "\"\<xTensor`Private`NonIndexedScalarQ[expr] returns True if expr is \
an explicit scalar: Scalar[x], tensor[], constant, parameter, \
scalar-function[x].\>\""}], 
  ";"}]}], "Input",ExpressionUUID->"742ad1ac-dd57-4b5f-b787-bf5600b1ae0f"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3.5. Indices", \
"Subsubsection",ExpressionUUID->"3b7d66fa-4762-4a14-a650-3d102f34f331"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Index", " ", "validation"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ValidateIndex", "::", "usage"}], 
     "=", "\"\<xTensor`Private`ValidateIndex[i] checks that i is a valid \
symbol, that it does not have an associated type, and gives a warning message \
if it is one of the capitals that Mathematica uses. \
xTensor`Private`ValidateIndex[i, False] does not give that warning message.\>\
\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ValidateGIndex", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"ValidateIndexList", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ModuleNumberOfIndex", "::", "usage"}], 
     "=", "\"\<ModuleNumberOfIndex[i] returns the value of $ModuleNumber at \
the time of definition of the abstract index i. This is used to remove the \
dollar indices associated to i in UndefAbstractIndex.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RemoveDollarIndices", "::", "usage"}], "=", "\"\<\>\""}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IndexOnQ", "::", "usage"}], 
     "=", "\"\<xTensor`Private`IndexOnQ[i, vbundle] gives True if index i \
belongs to the bundle vbundle (or to a subvbundle of vbundle) and False \
otherwise. xTensor`Private`IndexQ[i, {vb1, vb2, ...}] gives True if index i \
belongs to one of the bundles (or their subvbundles) in the list {vb1, vb2, \
...}.\>\""}], 
    ";"}]}]}]], \
"Input",ExpressionUUID->"6a650724-a2e4-44fa-a16c-7b95959c5aff"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Index", " ", "notations"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"upQ", "::", "usage"}], 
     "=", "\"\<xTensor`Private`upQ[ind] gives True if ind is an up-index and \
False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"downQ", "::", "usage"}], 
     "=", "\"\<xTensor`Private`downQ[ind] gives True if ind is a down-index \
and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"NoDollar", "::", "usage"}], 
     "=", "\"\<xTensor`Private`NoDollar[ind] returns the symbol ind (possibly \
including a sign) removing all characters starting from the first $. Values \
are stored as upvalues of the index ind.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DollarQ", "::", "usage"}], 
     "=", "\"\<xTensor`Private`DollarQ[ind] and DollarQ[-ind] give True if \
ind contains the character $ and False otherwise.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DaggerIndexQ", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PatternToIndex", "::", "usage"}], 
     "=", "\"\<xTensor`Private`PatternToIndex[expr] changes every pattern, \
patterntest or condition in expr to the name of the pattern, patterntest or \
condition.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IndexPosition", "::", "usage"}], 
     "=", "\"\<xTensor`Private`IndexPosition[list, ind] gives the positions \
of index ind in list. The index ind can be an up/down-index and the list can \
have any head.\>\""}], 
    ";"}]}]}]], \
"Input",ExpressionUUID->"c1b451ab-7a7f-4443-87d5-c760f91580ad"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Defining", " ", "free", " ", "and", " ", "paired", " ", "indices"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"TakeOrderedEPairs", "::", "usage"}], 
     "=", "\"\<xTensor`Private`TakeOrderedEPairs[indlist] gives the list of \
g-indices in list indlist which are paired, keeping the original \
order.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TakeFrees", "::", "usage"}], 
     "=", "\"\<xTensor`Private`TakeFrees[indlist] gives the list of g-indices \
in list indlist which are not paired. The original order is not kept.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TakeEIndices", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TakeEPairs", "::", "usage"}], "=", "\"\<\>\""}], 
    ";"}]}]}]], \
"Input",ExpressionUUID->"dbd1c983-20ff-4f92-8e09-ebb500eeda01"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Sorting", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sort0", "::", "usage"}], 
     "=", "\"\<xTensor`Private`Sort0 is an internal function sorting the \
types of indices: 1) labels, 2) patterns, 3) directions, 4) integer bases, 5) \
symbol bases, 6) abstract-indices.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sort1", "::", "usage"}], 
     "=", "\"\<xTensor`Private`Sort1 is an internal function specifying the \
first priority for sorting indices.\>\""}], ";", 
    RowBox[{
     RowBox[{"Sort2", "::", "usage"}], 
     "=", "\"\<xTensor`Private`Sort2 is an internal function specifying the \
second priority for sorting indices.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sort3", "::", "usage"}], 
     "=", "\"\<xTensor`Private`Sort3 is an internal function specifying the \
third priority for sorting indices.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SortPriority", "::", "usage"}], 
     "=", "\"\<xTensor`Private`SortPriority[string] returns the function to \
be used for index sorting associated to the given string priority: one of \
\\\"up\\\"/\\\"down\\\", \\\"free\\\"/\\\"dummy\\\", \\\"lexicographic\\\"/\\\
\"antilexicographic\\\"/\\\"positional\\\"/\\\"antipositional\\\".\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"validpriority", "::", "usage"}], "=", "\"\<\>\""}], 
    ";"}]}]}]], \
"Input",ExpressionUUID->"9e024b60-0fe8-4e03-a142-06f270e763cb"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Finding", " ", "indices"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"IndexName", "::", "usage"}], 
     "=", "\"\<xTensor`Private`IndexName[i] returns the so-called name of the \
g-index i. For abstract indices, the name equals the index. For basis \
indices, it returns the corresponding abstract index or 0 for a component \
index. For directional indices, labels and Blanks the name is also defined as \
0.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IndexType", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CheckHomogeneity", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"check", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CheckRepeated", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CheckIndexType", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"check2", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FindIndices1", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FindFreeAndDummyIndices", "::", "usage"}], 
     "=", "\"\<xTensor`Private`FindFreeAndDummyIndices[expr] gives a list \
containing FindFreeIndices[expr] and FindDummyIndices[expr] respectively. See \
notes for those functions.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TakeRepeated", "::", "usage"}], 
     "=", "\"\<xTensor`Private`TakeRepeated[list] returns the list of indices \
which are repeated in the list (both input and output lists with head \
IndexList).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TakeUp", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UltraindexOf", "::", "usage"}], 
     "=", "\"\<xTensor`Private`UltraindexOf[expr] checks that expr is a \
covariant or a contravariant vector and returns its free index. On Pattern \
expressions it gives None.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"checkultraindex", "::", "usage"}], "=", "\"\<\>\""}], 
    ";"}]}]}]], \
"Input",ExpressionUUID->"3ea3cc74-5d2e-4eb8-b2b0-b0d80a1ca6b5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Replacing", " ", "indices"}], " ", "*)"}], "\[IndentingNewLine]", 
  
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ReplaceOneIndex", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"replacepattern", "::", "usage"}], 
     "=", "\"\<xTensor`Private`replacepattern[patindex, rules, sign] replaces \
the pattern index patindex according to the rules. If the index is actually \
changed then a message is sent reporting about it and asking to contact \
JMM.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ReplaceBasisIndex", "::", "usage"}], 
     "=", "\"\<xTensor`Private`ReplaceBasisIndex[biold, binew, rules] \
replaces the basis index biold. It first tries to use the rules on the \
abstract index of biold, keeping the basis. If that does not produce a change \
then binew is returned.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ReplaceIndexList", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"HoldReplaceIndex", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ReplaceDummies2", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FastReplaceDummies", "::", "usage"}], "=", "\"\<\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SameVBundleRules", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"md", "::", "usage"}], "=", "\"\<\>\""}], 
    ";"}]}]}]], "Input",ExpressionUUID->"b0576941-a454-4389-8b4e-160e950ce813"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3.6. Manifolds and vector bundles", \
"Subsubsection",ExpressionUUID->"8297f5b7-7eda-4001-b0bb-c56143aa4960"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Manifolds", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"checkDefManifold", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RegisterIndexInVBundle", "::", "usage"}], 
     "=", "\"\<xTensor`Private`RegisterIndexInVBundle[ind, vb] registers the \
abstract index ind (a symbol) in the vbundle vb.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"checkDefVBundle", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RegisterVBundle", "::", "usage"}], "=", "\"\<\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Dependencies", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DependenciesOfIndices", "::", "usage"}], 
     "=", "\"\<xTensor`Private`DependenciesOfIndices\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DependenciesOfIndex", "::", "usage"}], 
     "=", "\"\<xTensor`Private`DependenciesOfIndex\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SortDependencies", "::", "usage"}], 
     "=", "\"\<xTensor`Private`SortDependencies\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "VBundles", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FirstMetricOfVBundle", "::", "usage"}], 
     "=", "\"\<xAct`xTensor`Private`FirstMetricOfVBundle[vbundle] gives the \
first metric of the list MetricsOfVBundle[vbundle]. There is an optional \
Boolean second argument which decides if an error message is thrown in case \
that list is empty. The default is True.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FirstMetricQ", "::", "usage"}], 
     "=", "\"\<xAct`xTensor`Private`FirstMetricQ[metric] returns True if \
metric is the first-metric of some vbundle, and False otherwise. \
xAct`xTensor`Private`FirstMetricQ[metric, vbundle] returns True if metric is \
the first-metric of vbundle, False if it is not, and throws an error if \
vbundle has no metrics.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$FirstMetrics", "::", "usage"}], 
     "=", "\"\<xAct`xTensor`Private`$FirstMetrics is a global variable \
containing the list of all metrics which are first-metric of some \
vbundle.\>\""}], 
    ";"}]}]}]], "Input",ExpressionUUID->"22eb2295-2034-4d69-a7d5-07e3cc77db1f"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3.7. Formatting", \
"Subsubsection",ExpressionUUID->"b9807281-448c-49fb-82ab-aa38eb8f491b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"AddIndex", "::", "usage"}], 
   "=", "\"\<AddIndex[{downstring, upstring}, index] adds index to downstring \
or upstring depending on whether index is covariant or contravariant, \
respectively, and a space to the other. It returns the new pair of \
strings.\\n\n    AddIndex[{downstring, upstring}, index, covd] adds the \
symbol of derivative covd and index to downstring or upstring depending on \
whether index is covariant or contravariant, respectively, and two spaces to \
the other. It returns the new pair of strings.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"AddLastQuote", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DropLastQuote", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"horizonal", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"addIndex", "::", "usage"}], "=", "\"\<\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"screenrules", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"screenindices", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"screenreplace", "::", "usage"}], "=", "\"\<\>\""}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"getindex", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"IndexPair", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"UpIndexPair", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}]}], "Input",ExpressionUUID->"7c628094-706b-4251-ad87-cdb12e503923"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3.8. Tensors", \
"Subsubsection",ExpressionUUID->"01b7523b-cf62-4d30-9fd1-c5dca5085ce3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"checkSetOrthogonal", "::", "usage"}], 
   "=", "\"\<xTensor`Private`checkSetOrthogonal[inds, ind] checks \
compatibility between the list of indices inds and the index ind.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"checkSetProjected", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ValidateTensor", "::", "usage"}], 
   "=", "\"\<xAct`xTensor`Private`ValidateTensor[tensor[inds]] validates the \
name, indices and index-structure of the given tensor.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ValidateDir", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ParametersOfTensor", "::", "usage"}], 
   "=", "\"\<xTensor`Private`ParametersOfTensor\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ManifoldsOfTensor", "::", "usage"}], 
   "=", "\"\<xTensor`Private`ManifoldsOfTensor\>\""}], 
  ";"}]}], "Input",ExpressionUUID->"641e11a8-937e-4811-a9a7-060bc2f4b55a"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3.0. Rules", \
"Subsubsection",ExpressionUUID->"3542fac1-d7ae-44d4-ab0b-fd34c408196b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Rules", " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"MakeRule1", "::", "usage"}], 
     "=", "\"\<xAct`xTensor`Private`MakeRule1[{LHS, RHS}] gives a delayed \
rule with left and right hand sides as given by LHS and RHS respectively. See \
notes for its options MetricOn and TestIndices. MakeRule1[{LHS, RHS, \
conditions}] adds conditions to the rules.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"SymmetryEquivalentsOfTensor", "::", "usage"}], 
     "=", "\"\<xAct`xTensor`Private`SymmetryEquivalentsOfTensor[tensor[\
indices], freeinds] gives a list of tensors which are equivalent to the given \
tensor (with free indices freeinds) from the symmetry point of view, but are \
not equal from the pattern point of view.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SymmetryEquivalentsOf", "::", "usage"}], "=", "\"\<\>\""}], 
    ";"}]}]}]], "Input",ExpressionUUID->"7b6e021b-ba49-4937-8d1e-d6a31600eb16"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3.10. Covariant derivatives", \
"Subsubsection",ExpressionUUID->"5e4db639-a260-4834-99a7-3ce8935dd0fb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"RiemannToWeylRules", "::", "usage"}], 
   "=", "\"\<RiemannToWeylRules[covd] gives the list of rules that are \
applied by RiemannToWeyl.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"WeylToRiemannRules", "::", "usage"}], 
   "=", "\"\<WeylToRiemannRules[covd] gives the list of rules that are \
applied by WeylToRiemann.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RicciToEinsteinRules", "::", "usage"}], 
   "=", "\"\<RicciToEinsteinRules[covd] gives the list of rules that are \
applied by RicciToEinstein.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"EinsteinToRicciRules", "::", "usage"}], 
   "=", "\"\<EinsteinToRicciRules[covd] gives the list of rules that are \
applied by EinsteinToRicci.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MetricToProjectorRules", "::", "usage"}], 
   "=", "\"\<MetricToProjectorRules[metric] gives the list of rules that are \
applied by MetricToProjector.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ProjectorToMetricRules", "::", "usage"}], 
   "=", "\"\<ProjectorToMetricRules[metric] gives the list of rules that are \
applied by ProjectorToMetric.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
   "ValidateCovD", "::", 
    "usage"}], "\"\<ValidateCovD[covd[ind][expr]] validates the name, index \
and compatibility of the given covariant derivative. It uses Validate on \
expr.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ZeroDerivativeQ", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeOrthogonalDerivative", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeProjectedDerivative", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InducedCovDQ", "::", "usage"}], "=", "\"\<\>\""}], 
  ";"}]}], "Input",ExpressionUUID->"8530bcc3-9060-4e55-bd87-fe43899d4e32"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3.11. Lie derivatives", \
"Subsubsection",ExpressionUUID->"b4d843fd-a92e-43a0-8e10-71bb4f72b2b0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ValidateLieD", "::", "usage"}], 
   "=", "\"\<ValidateLieD[LieD[v][expr]] validates that that v is a \
contravariant vector and uses Validate on expr.\>\""}], 
  ";"}]], "Input",ExpressionUUID->"84dc90c8-c81a-42dc-a3fe-16d8f38d548c"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3.12. Canonicalization", \
"Subsubsection",ExpressionUUID->"00ffdb66-2a1c-469a-8623-0882c6e31ea6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Canonicalization", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ToCanonicalOne", "::", "usage"}], "=", "\"\<\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Sorting", " ", "tensors"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ObjectsWithIndices", "::", "usage"}], 
     "=", "\"\<ObjectsWithIndices[term, index] yields the objects in term (a \
Times product) that have the given index. ObjectsWithIndices[term, indlist] \
yields a list of objects in term having one or several of the indices in \
indlist.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FindMonomial", "::", "usage"}], 
     "=", "\"\<FindMonomial[term, index, frees] gives the monomial \
(contracted product of tensors) in term (a Times product containing tensors) \
that has the given index. The list frees is the list of free indices of term, \
supplied to avoid repetition of its computation.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ObjectOrder", "::", "usage"}], "=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CommutingObjects", "::", "usage"}], "=", "\"\<\>\""}], 
    ";"}]}]}]], "Input",ExpressionUUID->"7bb9b950-65d7-4d61-b5bc-51e959c0f077"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3.13. Metrics", \
"Subsubsection",ExpressionUUID->"7cb53dbe-f977-47b8-a599-2fda8da0f074"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Metrics", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ContractMetric1", "::", "usage"}], 
     "=", "\"\<ContractMetric1[expr, metric] contracts all instances of \
metric in expr.\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"ProductMetricRules", "::", "usage"}], 
     "=", "\"\<ProductMetricRules[metric] gives the list of rules that are \
applied by ExpandProductMetric.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FrozenMetricQ", "::", "usage"}], "=", "\"\<\>\""}], 
    ";"}]}]}]], "Input",ExpressionUUID->"b3c1d2eb-76c3-4f88-a833-ed60deec02fb"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3.14. Collect symbols", \
"Subsubsection",ExpressionUUID->"d47d8114-c411-41d3-8fae-fc9d4fd8c8c9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$xTensorPrivateNames", "=", 
  RowBox[{
  "Names", "[", "\"\<xAct`xTensor`Private`*\>\"", 
   "]"}]}]], "Input",ExpressionUUID->"f7ee4b68-0a50-4e88-9902-0c7c2d7fb5a5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AddDaggerCharacter\"\>", ",", "\<\"addIndex\"\>", 
   ",", "\<\"AddIndex\"\>", ",", "\<\"AddLastQuote\"\>", 
   ",", "\<\"BeginExamples\"\>", ",", "\<\"boxof\"\>", ",", "\<\"check\"\>", 
   ",", "\<\"check2\"\>", ",", "\<\"checkDefManifold\"\>", 
   ",", "\<\"checkDefVBundle\"\>", ",", "\<\"CheckHomogeneity\"\>", 
   ",", "\<\"CheckIndexType\"\>", ",", "\<\"CheckRemoveSymbol\"\>", 
   ",", "\<\"CheckRepeated\"\>", ",", "\<\"checkSetOrthogonal\"\>", 
   ",", "\<\"checkSetProjected\"\>", ",", "\<\"checkultraindex\"\>", 
   ",", "\<\"CommutingObjects\"\>", ",", "\<\"ContractMetric1\"\>", 
   ",", "\<\"DaggerIndexQ\"\>", ",", "\<\"DependenciesOfIndex\"\>", 
   ",", "\<\"DependenciesOfIndices\"\>", ",", "\<\"DollarQ\"\>", 
   ",", "\<\"downQ\"\>", ",", "\<\"DropLastQuote\"\>", 
   ",", "\<\"EinsteinToRicciRules\"\>", ",", "\<\"expr\"\>", 
   ",", "\<\"FastReplaceDummies\"\>", ",", "\<\"FindFreeAndDummyIndices\"\>", 
   ",", "\<\"FindIndices1\"\>", ",", "\<\"FindMonomial\"\>", 
   ",", "\<\"FirstMetricOfVBundle\"\>", ",", "\<\"FirstMetricQ\"\>", 
   ",", "\<\"FrozenMetricQ\"\>", ",", "\<\"getindex\"\>", 
   ",", "\<\"HoldReplaceIndex\"\>", ",", "\<\"horizonal\"\>", 
   ",", "\<\"IndexName\"\>", ",", "\<\"IndexOnQ\"\>", 
   ",", "\<\"IndexPair\"\>", ",", "\<\"IndexPosition\"\>", 
   ",", "\<\"IndexType\"\>", ",", "\<\"InducedCovDQ\"\>", 
   ",", "\<\"interpretbox\"\>", ",", "\<\"interpretboxcolor\"\>", 
   ",", "\<\"ListOfFactors\"\>", ",", "\<\"ListOfTerms\"\>", 
   ",", "\<\"MakeDefInfo\"\>", ",", "\<\"MakeOrthogonalDerivative\"\>", 
   ",", "\<\"MakeProjectedDerivative\"\>", ",", "\<\"MakeRule1\"\>", 
   ",", "\<\"MakeSequenceBox\"\>", ",", "\<\"makespace\"\>", 
   ",", "\<\"MakeUndefInfo\"\>", ",", "\<\"ManifoldsOfTensor\"\>", 
   ",", "\<\"MathInputExpand\"\>", ",", "\<\"md\"\>", 
   ",", "\<\"MetricToProjectorRules\"\>", ",", "\<\"ModuleNumberOfIndex\"\>", 
   ",", "\<\"NoDollar\"\>", ",", "\<\"NonIndexedScalarQ\"\>", 
   ",", "\<\"ObjectOrder\"\>", ",", "\<\"ObjectsWithIndices\"\>", 
   ",", "\<\"ParametersOfTensor\"\>", ",", "\<\"PatternToIndex\"\>", 
   ",", "\<\"PrintAsString\"\>", ",", "\<\"ProductMetricRules\"\>", 
   ",", "\<\"ProjectorToMetricRules\"\>", 
   ",", "\<\"RegisterIndexInVBundle\"\>", ",", "\<\"RegisterVBundle\"\>", 
   ",", "\<\"RemoveDollarIndices\"\>", ",", "\<\"RemoveSymbol\"\>", 
   ",", "\<\"ReplaceBasisIndex\"\>", ",", "\<\"ReplaceDummies2\"\>", 
   ",", "\<\"ReplaceIndexList\"\>", ",", "\<\"ReplaceOneIndex\"\>", 
   ",", "\<\"replacepattern\"\>", ",", "\<\"RicciToEinsteinRules\"\>", 
   ",", "\<\"RiemannToWeylRules\"\>", ",", "\<\"SameVBundleRules\"\>", 
   ",", "\<\"screenindices\"\>", ",", "\<\"screenreplace\"\>", 
   ",", "\<\"screenrules\"\>", ",", "\<\"SetDaggerPair\"\>", 
   ",", "\<\"SetPrintAs\"\>", ",", "\<\"Sort0\"\>", ",", "\<\"Sort1\"\>", 
   ",", "\<\"Sort2\"\>", ",", "\<\"Sort3\"\>", 
   ",", "\<\"SortDependencies\"\>", ",", "\<\"SortPriority\"\>", 
   ",", "\<\"string\"\>", ",", "\<\"SymbolRelations\"\>", 
   ",", "\<\"SymmetryEquivalentsOf\"\>", 
   ",", "\<\"SymmetryEquivalentsOfTensor\"\>", ",", "\<\"TakeEIndices\"\>", 
   ",", "\<\"TakeEPairs\"\>", ",", "\<\"TakeFrees\"\>", 
   ",", "\<\"TakeOrderedEPairs\"\>", ",", "\<\"TakeRepeated\"\>", 
   ",", "\<\"TakeUp\"\>", ",", "\<\"ToCanonicalOne\"\>", 
   ",", "\<\"UltraindexOf\"\>", ",", "\<\"UpIndexPair\"\>", 
   ",", "\<\"upQ\"\>", ",", "\<\"ValidateCovD\"\>", 
   ",", "\<\"ValidateDir\"\>", ",", "\<\"ValidateGIndex\"\>", 
   ",", "\<\"ValidateIndex\"\>", ",", "\<\"ValidateIndexList\"\>", 
   ",", "\<\"ValidateLieD\"\>", ",", "\<\"ValidateTensor\"\>", 
   ",", "\<\"validpriority\"\>", ",", "\<\"WeylToRiemannRules\"\>", 
   ",", "\<\"xTensorSymbols\"\>", ",", "\<\"ZeroDerivativeQ\"\>", 
   ",", "\<\"$FirstMetrics\"\>", ",", "\<\"$QFunctions\"\>", 
   ",", "\<\"$sfunctions\"\>", ",", "\<\"$Types\"\>", 
   ",", "\<\"$xTensorDollarNames\"\>", ",", "\<\"$xTensorNonDollarNames\"\>", 
   ",", "\<\"$xTensorPrivateNames\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"b5cc7021-c9cc-4b41-9c9e-d5a478fab34c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"19742f0c-314b-4ab5-bf95-d907f6a253b5"],

Cell[BoxData["123"], \
"Output",ExpressionUUID->"91dfe864-48f2-4eee-8397-4b203da61a76"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["2. Types",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->24,ExpressionUUID->"c726b000-5623-48d4-9ce1-652522522aa2"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**"}], 
    "**", "**", "**", " ", "2."}], "Types"}], " ", 
  "******************************)"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7e45b16a-d6d4-4a2b-9b05-1ca6bddcf014"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TimeUsed", "[", "]"}], ",", 
   RowBox[{"SessionTime", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"TimeUsed", "[", "]"}], "/", 
    RowBox[{"SessionTime", "[", "]"}]}]}], 
  "}"}]], "Input",ExpressionUUID->"f8ac9967-6aae-44ce-86ce-d60183701bd1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "6.805566`", ",", "286.372818`8.908476786626052", ",", 
   "0.023764799064045317`"}], 
  "}"}]], "Output",ExpressionUUID->"2c1efe68-c039-4e71-aa0f-94db818d5bf8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.0. Comments", \
"Subsection",ExpressionUUID->"e72ca677-ee65-43ab-b838-b6cad68aad69"],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "  is an untyped system, but I think it is convenient to use a \
type-definition system to do tensor calculus. Here we construct our own type \
system."
}], "Text",ExpressionUUID->"02a54039-dc0a-46e6-9a61-153216d4c5cb"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"$ReadingVerbose", ",", 
   RowBox[{"Print", "[", "\"\<Reading section 2: Types.\>\"", "]"}], ",", 
   "Null", ",", "Null"}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"a8641868-ccd4-461c-998b-bd63d925653a"],

Cell[CellGroupData[{

Cell["2.0.1. Symbols versus strings", \
"Subsubsection",ExpressionUUID->"e76d73e2-71e6-4a0f-83f0-ff889e9bdcf8"],

Cell["\<\
Note the difference between symbols and names: names are always strings; \
symbols have names. From strings to symbols use Symbol:\
\>", "Text",ExpressionUUID->"de00aba8-8302-449a-b8b4-9a90185371e1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Symbol", "[", "\"\<hello\>\"", 
  "]"}]], "Input",ExpressionUUID->"494a8541-705a-4bbf-a6cb-52f9a7449a1f"],

Cell[BoxData["hello"], \
"Output",ExpressionUUID->"d0200351-68e2-421f-8912-170e2a0daea3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"a1d8b74b-9e79-49c2-8b58-50d0ec2d3df4"],

Cell[BoxData["Symbol"], \
"Output",ExpressionUUID->"143e4440-c08e-4a25-8306-426e809c0612"]
}, Open  ]],

Cell["\<\
or the more general ToExpression. From symbols to strings use SymbolName:\
\>", "Text",ExpressionUUID->"f29f9989-28f7-4ac6-9c62-dc1b7101bda3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymbolName", "[", "%%", 
  "]"}]], "Input",ExpressionUUID->"51ebd49e-f8e8-4e6e-a715-6d50b9c06fa4"],

Cell[BoxData["\<\"hello\"\>"], \
"Output",ExpressionUUID->"fa2f0aea-8399-49e7-95a2-4ef1bd29596d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"173513af-f482-4b88-ace0-00b9afa4110e"],

Cell[BoxData["String"], \
"Output",ExpressionUUID->"68aa663a-24eb-4c25-bbcc-8398220353f2"]
}, Open  ]],

Cell["or the more general ToString.", \
"Text",ExpressionUUID->"6d003617-f69c-4f25-82fa-8204bd51aaea"],

Cell[TextData[{
 "A first major decision in the design of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " is the following: all objects will be identified with symbols (not \
strings) in order to associate them the corresponding definitions (it is not \
possible to associate definitions to strings). This follows both the rule of \
simplicity and the rule of compliance with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "'s way. This decision has, however, several drawbacks:\n\t1) Many symbols \
are already used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", or by ",
 StyleBox["xTensor, xPerm, xCoba, xCore.",
  FontSlant->"Italic"],
 " Those symbols will not be allowed to represent  ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " objects. We shall define a set of functions that store the known symbols \
and analyze whether a candidate name for a new object is allowed or not. We \
will see that there are a few special cases.\n\t2) Defined symbols will have \
a \"type\". A symbol cannot have two types to avoid conflicting information. \
We could introduce contexts Tensor`, Spinor`, Form`, etc, but it is not clear \
what it would really improve. I think it is more flexible to let the user \
decide two different names to distinguish the objects.\n\t3) A symbol can \
have ownvalues. For example if T is a tensor we can also say T=1, which will \
generate all kinds of errors. This is normal ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ": if you have a function f[x] you can say f=1. A way of avoiding this could \
be protecting the symbol of any defined object, but this requires \
unprotecting symbols when you want to associate new definitions to them. We \
introduce the global variable $ProtectNewSymbols and the option \
ProtectNewSymbol to control this point, together with some ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 " functions xUpSet and similar which are able to unprotect/reprotect symbols."
}], "Text",ExpressionUUID->"938060d9-3870-4dc5-b551-f64838a9e3bc"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
  "x", "^", 
   "2"}]}]], "Input",ExpressionUUID->"4669f067-6c2a-4240-9d94-9db4eadea4d9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "3", 
  "]"}]], "Input",ExpressionUUID->"4c2850b1-17f0-4a56-8b99-bfc1e05a9e6c"],

Cell[BoxData["9"], \
"Output",ExpressionUUID->"d3bca5da-1dca-45d0-ac0c-32eea98a2581"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  "1"}]], "Input",ExpressionUUID->"1e807120-b794-48ea-81fe-819f2a8169cf"],

Cell[BoxData["1"], \
"Output",ExpressionUUID->"3b6c077b-3498-47da-9b85-a62809c0c9d0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "f"}]], "Input",ExpressionUUID->"483fe4a4-20d8-47c4-a2f9-712352bf9ee7"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"xAct`xTensor`Private`f\"\>", "InformationUsageText",
             
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Assignment\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"OwnValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "OwnValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{"f", "=", "1"}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" DownValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"DownValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "DownValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"f", "[", "x_", "]"}], ":=", 
                    SuperscriptBox["x", "2"]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`Private`f\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"xAct`xTensor`Private`f\"\>", "InformationUsageText",
             
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "xAct`xTensor`Private`f", 
    "Documentation" -> None, "OwnValues" -> 
    Information`InformationValueForm[
     OwnValues, xAct`xTensor`Private`f, {xAct`xTensor`Private`f -> 1}], 
    "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, xAct`xTensor`Private`f, {xAct`xTensor`Private`f[
         Pattern[xAct`xTensor`Private`x, 
          Blank[]]] :> xAct`xTensor`Private`x^2}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`Private`f"|>, 
   False]]], "Output",ExpressionUUID->"cda6442f-786e-4770-b862-a7f04a7916bc"]
}, Open  ]],

Cell["The ownvalue for f is used before its downvalue:", \
"Text",ExpressionUUID->"92f03fc8-960e-48be-a16a-ded93570e13c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "3", 
  "]"}]], "Input",ExpressionUUID->"8d021855-f4c5-49de-82b4-c526002b50ca"],

Cell[BoxData[
 RowBox[{"1", "[", "3", 
  "]"}]], "Output",ExpressionUUID->"82abae58-4c5f-4681-9bae-89f3821df40c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"f", ",", "x", ",", "hello"}], 
  "]"}]], "Input",ExpressionUUID->"dfc34f19-78fa-4b9f-ae70-b36b1d5ab0f7"],

Cell[TextData[{
 "The basic use of symbols rather than strings can be compared to ",
 StyleBox["GRTensor",
  FontSlant->"Italic"],
 "'s input, based on strings. The strings give you more flexibility in the \
notations, but heavily rely on the parser. In other words, because the user \
cannot modify the parser, it is difficult for the user to use tricks of the \
system without changing the code of the package. Working with symbols has the \
problems referred to above and does not allow beautiful notations such as \
using parenthesis for symmetrization of indices. However it is much closer to \
",
 StyleBox["Mathematica'",
  FontSlant->"Italic"],
 "s spirit and allows the user to interact closely with the internals of the \
package because there is no parser acting as interface. There is an important \
comment here: if I had to write a system for other users I would write a \
parser; but because I am the the main user of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ", I don't want to have a parser."
}], "Text",ExpressionUUID->"1fcd7d10-ff05-437b-a56a-aac47d561a5b"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.0.2. Tagging versus no-tagging", \
"Subsubsection",ExpressionUUID->"c47e3746-6913-43ad-bd84-7d26984b0721"],

Cell[TextData[{
 "Good programming suggests to tag values of a given type with the name of \
the type, as in Tensor[T, ...] (or Tensor[T][...], as recommended by Maeder), \
rather than using the simpler form T[...]. Advantages of tagging:\n\t- \
Clarity\n\t- Efficient pattern matching\n\t- Safety\nDisadvantages:\n\t- \
Harder to type in and read\n\t- The depth-1 restriction of upvalues in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " becomes a depth-0 restriction.\n\n",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " only defines up-values for symbols at levels 0 and 1 of the full \
expression. For example the definition T[a]T[-a]:=1 can be associated to the \
symbol T, but the definition Tensor[T,{a},{}] Tensor[T,{},{a}]:=1 can only be \
associated to the symbol Tensor, because the symbol T is too deep (level 2):"
}], "Text",ExpressionUUID->"2e2adde1-3bf4-42e3-87d1-4112922df61f"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"63082a99-60a1-4ab8-97da-e0fd9cea9a95"],

Cell["This is not valid:", \
"Text",ExpressionUUID->"1fa88f48-72cb-4b0f-b7db-c202efa7bc31"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T", "/:", 
  RowBox[{
   RowBox[{"Tensor", "[", 
    RowBox[{"T", ",", 
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"{", "}"}]}], "]"}], 
   RowBox[{"Tensor", "[", 
    RowBox[{"T", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "a", "}"}]}], "]"}]}], ":=", 
  "1"}]], "Input",ExpressionUUID->"e75a33fa-3e27-49cd-b534-afd59ef0d3a7"],

Cell[BoxData[
 TemplateBox[{
  "TagSetDelayed", "tagpos", 
   "\"Tag \\!\\(\\*RowBox[{\\\"T\\\"}]\\) in \
\\!\\(\\*RowBox[{RowBox[{\\\"Tensor\\\", \\\"[\\\", RowBox[{\\\"T\\\", \
\\\",\\\", RowBox[{\\\"{\\\", \\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", \
\\\"a\\\", \\\"}\\\"}]}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Tensor\\\", \
\\\"[\\\", RowBox[{\\\"T\\\", \\\",\\\", RowBox[{\\\"{\\\", \\\"a\\\", \
\\\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", \\\"}\\\"}]}], \\\"]\\\"}]}]\\) is \
too deep for an assigned rule to be found.\"", 2, 680, 1, 
   19659342612246381582, "Local"},
  "MessageTemplate"]], "Message", \
"MSG",ExpressionUUID->"78ca0afc-8e8b-4a53-9c4f-77401fb1db8f"],

Cell[BoxData["$Failed"], \
"Output",ExpressionUUID->"c8bbe78b-52d8-4f47-af11-258b2ddf9fa9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "T"}]], "Input",ExpressionUUID->"5468ae92-8559-4c5f-a307-65dcc896e2ea"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`T\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`T\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`T\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "Global`T", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "Global`T"|>, 
   False]]], "Output",ExpressionUUID->"aafa33f3-9257-4a3a-a79a-93e3a735f26e"]
}, Open  ]],

Cell["This is correct:", \
"Text",ExpressionUUID->"38a9f23d-d0d4-4aaa-afa8-90e57e9ff9ff"],

Cell[BoxData[
 RowBox[{"T", "/:", 
  RowBox[{
   RowBox[{"T", "[", "a", "]"}], 
   RowBox[{"T", "[", 
    RowBox[{"-", "a"}], "]"}]}], ":=", 
  "1"}]], "Input",ExpressionUUID->"2d023a05-9f4f-40f4-b406-066b6d6e9676"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "T"}]], "Input",ExpressionUUID->"41909f26-aaab-40e0-abb7-bea6a23320d2"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`T\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" UpValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"UpValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "UpValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{
                    RowBox[{"T", "[", 
                    RowBox[{"-", "a"}], "]"}], " ", 
                    RowBox[{"T", "[", "a", "]"}]}], "^:=", "1"}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`T\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`T\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "Global`T", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> 
    Information`InformationValueForm[
     UpValues, $CellContext`T, {$CellContext`T[-$CellContext`a] \
$CellContext`T[$CellContext`a] :> 1}], "DownValues" -> None, "SubValues" -> 
    None, "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> "Global`T"|>, 
   False]]], "Output",ExpressionUUID->"c84be433-12a2-4524-8dac-8976009757fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"T", "[", "a", "]"}], 
  RowBox[{"T", "[", 
   RowBox[{"-", "a"}], 
   "]"}]}]], "Input",ExpressionUUID->"bfab0264-f5a4-45e8-aba8-10af76fe7b04"],

Cell[BoxData["1"], \
"Output",ExpressionUUID->"0e69930a-e98e-48e5-aec6-4a09a5cf2c1b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Clear", "[", "T", 
  "]"}]], "Input",ExpressionUUID->"b0e0f054-d250-4690-960a-eabfb0170b4b"],

Cell["\<\
An alternative (certainly ugly), based on the idea that the symbolic-head of \
an expression is always found no matter how many pairs of brackets there are, \
could be:\
\>", "Text",ExpressionUUID->"3546de24-1ef7-4c11-9754-b9860fb881b8"],

Cell[BoxData[
 RowBox[{"T", "/:", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", "Tensor", "]"}], "[", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"{", "}"}]}], "]"}], 
   RowBox[{
    RowBox[{"T", "[", "Tensor", "]"}], "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", "a", "}"}]}], "]"}]}], ":=", 
  "1"}]], "Input",ExpressionUUID->"969564fd-aabf-4aa5-b1ff-f4c893c0e580"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "T"}]], "Input",ExpressionUUID->"aac53a96-fc36-4ffd-ba5b-f4b9c4bc09ef"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`T\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" UpValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"UpValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "UpValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"T", "[", "Tensor", "]"}], "[", 
                    RowBox[{
                    RowBox[{"{", "}"}], ",", 
                    RowBox[{"{", "a", "}"}]}], "]"}], " ", 
                    RowBox[{
                    RowBox[{"T", "[", "Tensor", "]"}], "[", 
                    RowBox[{
                    RowBox[{"{", "a", "}"}], ",", 
                    RowBox[{"{", "}"}]}], "]"}]}], "^:=", "1"}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`T\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`T\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "Global`T", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> 
    Information`InformationValueForm[
     UpValues, $CellContext`T, {$CellContext`T[
         xAct`xTensor`Tensor][{}, {$CellContext`a}] $CellContext`T[
         xAct`xTensor`Tensor][{$CellContext`a}, {}] :> 1}], "DownValues" -> 
    None, "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "Global`T"|>, 
   False]]], "Output",ExpressionUUID->"6324c1c9-ad25-4b25-9070-c5e5d1b05e6f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"T", ",", "a"}], 
  "]"}]], "Input",ExpressionUUID->"a6b976b0-717e-44f2-9488-4e9f31c96e53"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"3f2f25a9-2d27-4dd1-b1c9-21d891543fd1"],

Cell[TextData[{
 "Currently we do not use tagging. (This is probably the most important \
design decision in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ", and it is unlikely to change in future versions.) We introduce a  number \
of checking functions xTensorQ, etc. such that objects of the corresponding \
type are given True upvalues for the function, which is itself defined as \
False on any other input. The main point is the difference in efficiency. I \
estimate that the Q functions are slower by a factor between 3 and 6, but \
they take very little anyway with respect to the global computation time.\n\n\
I must say that when I have asked the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " developers about this issue they have also recommended me this option, \
though they also mention the loss of efficiency..."
}], "Text",ExpressionUUID->"5baf428f-6e64-4fc8-aa2a-e2f6f8e1ce56"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.0.3. Types of symbols", \
"Subsubsection",ExpressionUUID->"1e93d876-5e52-42b4-9e7b-7f493747ef10"],

Cell[TextData[{
 "Currently there are 14 types of definable symbols:\n\tAbstractIndex: \
abstract indices\n\tTensor: tensors of the form T[ inds ] (with Metric as a \
special case)\n\tCovD: operators of the form CD[ ind ][   ] or perhaps CD[ \
inds ][   ]\n\tScalarFunction: function mapping (possibly several) scalars to \
scalars\n\tInertHead: a head that does not change the type and properties of \
an object. Assume its first argument is tensorial, but not the rest\n\t\
Product: a product of tensorial objects, generalizing our use of Times\n\t\
Manifold\n\tMapping\n\tVBundle\n\tParameter\n\tConstantSymbol\n\tBasis (in ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 ")\n\tChart (in ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 ")\n\tMetric: particular type of tensor"
}], "Text",ExpressionUUID->"6bb8759a-f4b8-4f4d-9c85-bbdfe70c68ad"],

Cell["\<\
Functions that must use types of objects because they expect a generic \
mathinput expr:
\t- FindAllOfType
\t- FindIndices
\t- ReplaceIndex
\t- IsIndexOf
\t- SymmetryOf
\t- ContractMetric
\t- Scalar
\t- DependenciesOf
\t- WeightOf
Then we have other functions using types, though not through mathinput:
\t- ValidateSymbolInSession
\t- IndexForm\
\>", "Text",ExpressionUUID->"265132c5-0050-4664-bde4-a6728ec910ce"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.1. Protection of symbols", \
"Subsection",ExpressionUUID->"e6b12379-eba9-4c5d-88e4-6f6cbefc31d1"],

Cell["\<\
An additional decision: defined objects are not protected by default .\
\>", "Text",ExpressionUUID->"edcd7095-77e8-4e52-a182-cf25a223bf82"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "$ProtectNewSymbols"}]], \
"Input",ExpressionUUID->"9d47a23c-1a86-4a8b-b81c-85b5e8bbc10f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"$ProtectNewSymbols is a Boolean global variable \
specifying the default value for the option ProtectNewSymbol of all DefType \
commands. The default initial value is False.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`$ProtectNewSymbols\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"$ProtectNewSymbols is a Boolean global variable \
specifying the default value for the option ProtectNewSymbol of all DefType \
commands. The default initial value is False.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "$ProtectNewSymbols is a Boolean global variable specifying the default \
value for the option ProtectNewSymbol of all DefType commands. The default \
initial value is False.", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> None, "DownValues" -> None, "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`$ProtectNewSymbols"|>, 
   False]]], "Output",ExpressionUUID->"01b15e82-2d1a-44c9-9c3d-c74c226885fe"]
}, Open  ]],

Cell["Its default value is False:", \
"Text",ExpressionUUID->"948e803a-9af2-4c55-befd-753caeefe596"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$ProtectNewSymbols", "=", "False"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7dec35d1-c70a-496f-a4d2-b66f6e29c107"],

Cell["But here we want to check it:", \
"Text",ExpressionUUID->"9f0ad63e-a589-4b60-8a91-78514ce94071"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$ProtectNewSymbols", "=", "True"}], 
  ";"}]], "Input",ExpressionUUID->"da759be4-7fc3-4249-8bed-155f5c11c198"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2. Symbol relations", \
"Subsection",ExpressionUUID->"2ebdee7d-4769-4fba-a693-2f8e52ebb705"],

Cell["\<\
There are symbols which require others to exist previously (like a tensor \
field needs a manifold) and there are symbols which force simultaneuous \
existence of others (like a connection requires existence of its Riemann \
tensor). These two types of relations are important when defining and \
undefining symbols. We shall introduce the following silly terminology:
\t- A symbol (like that tensor) is a \"visitor\" of a previously defined \
\"host\" symbol (like that manifold). Any symbol has a list of visitors and a \
list of hosts.
\t- A symbol (like the connection) is a \"master\" for the symbols which it \
requires to be defined, to be called \"servants\". Any symbol has a master \
(default Null) and a list of servants.
\t
There is the question of whether a symbol can have several masters. I \
currently think this is impossible because we would have to define and \
undefine all together, and if that is the case we can well define one of them \
as master and the rest as servants of that one.
\t
Those lists will be upvalues of the symbols when they are not empty. They \
will have empty default definitions in general.\
\>", "Text",ExpressionUUID->"cfe4a9a4-774f-4418-94bd-8e7d5c24cb9e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "HostsOf"}]], \
"Input",ExpressionUUID->"f14064fc-8b6b-43a7-95e5-7f969f0c2601"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"HostsOf[symbol] gives the list of symbols which are \
required to exist previously, before symbol was defined, and which cannot be \
undefined as long as symbol exists.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`HostsOf\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"HostsOf[symbol] gives the list of symbols which are \
required to exist previously, before symbol was defined, and which cannot be \
undefined as long as symbol exists.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "HostsOf[symbol] gives the list of symbols which are required to exist \
previously, before symbol was defined, and which cannot be undefined as long \
as symbol exists.", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> 
    None, "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "xAct`xTensor`HostsOf"|>, 
   False]]], "Output",ExpressionUUID->"70acf0e7-af9b-4143-9fa2-c84394c665b4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "VisitorsOf"}]], \
"Input",ExpressionUUID->"48d36adb-6a25-4697-b032-3da2285ad9be"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"VisitorsOf[symbol] gives the list of all symbols \
which require symbol to exist before they can be defined. symbol can only be \
removed if this list is empty.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`VisitorsOf\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"VisitorsOf[symbol] gives the list of all symbols \
which require symbol to exist before they can be defined. symbol can only be \
removed if this list is empty.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "VisitorsOf[symbol] gives the list of all symbols which require symbol to \
exist before they can be defined. symbol can only be removed if this list is \
empty.", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "xAct`xTensor`VisitorsOf"|>, 
   False]]], "Output",ExpressionUUID->"f9cdabaa-a6a9-48ae-b9f9-81acb4b961d6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "ServantsOf"}]], \
"Input",ExpressionUUID->"c7c7c9f0-4c25-4c80-9366-c9360ac26b7b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ServantsOf[symbol] gives the list of symbols which \
have been simultaneously defined with symbol. They will be removed when, and \
only when, symbol is removed.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`ServantsOf\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ServantsOf[symbol] gives the list of symbols which \
have been simultaneously defined with symbol. They will be removed when, and \
only when, symbol is removed.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ServantsOf[symbol] gives the list of symbols which have been \
simultaneously defined with symbol. They will be removed when, and only when, \
symbol is removed.", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> 
    None, "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "xAct`xTensor`ServantsOf"|>, 
   False]]], "Output",ExpressionUUID->"ff073466-b06b-4371-90fd-897d68f98c83"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "MasterOf"}]], \
"Input",ExpressionUUID->"44c7b140-e524-43d3-bae2-280d241d6774"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"MasterOf[servant] gives the master symbol of the \
symbol servant. The latter is defined and removed when, and only when, the \
former is defined and removed, respectively.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`MasterOf\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"MasterOf[servant] gives the master symbol of the \
symbol servant. The latter is defined and removed when, and only when, the \
former is defined and removed, respectively.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "MasterOf[servant] gives the master symbol of the symbol servant. The \
latter is defined and removed when, and only when, the former is defined and \
removed, respectively.", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> None, "DownValues" -> None, "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`MasterOf"|>, 
   False]]], "Output",ExpressionUUID->"2bdefd68-4b39-4def-a199-12454fbfd4f7"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ServantsOf", "[", "Symbol", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"delta", ",", "Gdelta", ",", "Sdelta", ",", "Basis", ",", "PD"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HostsOf", "[", "_", "]"}], ":=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"VisitorsOf", "[", "_", "]"}], ":=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MasterOf", "[", "_", "]"}], ":=", "Null"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ServantsOf", "[", "_", "]"}], ":=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"#", ",", "1"}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{
    "HostsOf", ",", "VisitorsOf", ",", "MasterOf", ",", "ServantsOf"}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"HostsOf", ",", "VisitorsOf", ",", "MasterOf", ",", "ServantsOf"}],
    "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"cee78c48-f04b-4db5-9c99-b107c6501a6d"],

Cell["\<\
A symbol which cannot be removed can be made servant of a non-removable \
symbol. I choose the symbol Symbol, and certain objects (now delta, Gdelta, \
Sdelta, Basis and PD) will have Symbol as master.\
\>", "Text",ExpressionUUID->"9424d98d-cfde-4067-9a15-361711a4be42"],

Cell["\<\
Trivial coding. Note that we drop the master (and its master, and so on) from \
the list of hosts; that is, a symbol cannot be simultaneously servant and \
visitor: if we ask for both it will be a servant. This function assumes that \
symbol is unprotected because it is called during the declaration of the \
symbol:\
\>", "Text",ExpressionUUID->"6744a6e3-721f-46ff-a205-0075f00f167f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SymbolRelations", "[", 
    RowBox[{"list_List", ",", "master_Symbol", ",", "hosts_List"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"SymbolRelations", "[", 
      RowBox[{"#", ",", "master", ",", "hosts"}], "]"}], "&"}], "/@", 
    "list"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymbolRelations", "[", 
    RowBox[{"symbol_Symbol", ",", "master_Symbol", ",", "hosts_List"}], "]"}],
    ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"hosts2", "=", 
       RowBox[{"Complement", "[", 
        RowBox[{"hosts", ",", 
         RowBox[{"FixedPointList", "[", 
          RowBox[{"MasterOf", ",", "master"}], "]"}]}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"master", "=!=", "Null"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"MasterOf", "[", "symbol", "]"}], "^=", "master"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"xUpAppendTo", "[", 
          RowBox[{
           RowBox[{"ServantsOf", "[", "master", "]"}], ",", "symbol"}], 
          "]"}]}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"hosts2", "=!=", 
         RowBox[{"{", "}"}]}], ",", 
        RowBox[{"xUpSet", "[", 
         RowBox[{
          RowBox[{"HostsOf", "[", "symbol", "]"}], ",", 
          RowBox[{"Join", "[", 
           RowBox[{
            RowBox[{"HostsOf", "[", "symbol", "]"}], ",", "hosts2"}], "]"}]}],
          "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"!", 
            RowBox[{"MemberQ", "[", 
             RowBox[{
              RowBox[{"VisitorsOf", "[", "#", "]"}], ",", "symbol"}], "]"}]}],
            ",", 
           RowBox[{"xUpAppendTo", "[", 
            RowBox[{
             RowBox[{"VisitorsOf", "[", "#", "]"}], ",", "symbol"}], "]"}]}], 
          "]"}], "&"}], ",", "hosts2"}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"12cedcae-1416-42af-b78d-f929b693f643"],

Cell["\<\
The master of a declared symbol can be specified at declaration time, using \
the option Master:\
\>", "Text",ExpressionUUID->"ce7b5a77-5a6a-4d07-96c0-be73797ae6ad"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", "Master", "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"6eb837ac-0bb3-427d-ad74-4cc507d852b0"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.3. Removing symbols", \
"Subsection",ExpressionUUID->"b4b6ef84-4cb1-43c9-97f3-d57d8b30abb3"],

Cell["\<\
This function removes a symbol, unprotecting it first if needed. Note that we \
do not have the head Symbol in the pattern because sometimes we use it with a \
symbol-name (a string); this is when the symbol has an ownvalue and hence we \
need to avoid its evaluation. QUESTION: Why do we do that? Wouldn't it be \
better to use a holding attribute?\
\>", "Text",ExpressionUUID->"0cde8cfd-9e7e-4f01-80fd-418cabee77bb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "RemoveSymbol"}]], \
"Input",ExpressionUUID->"34858117-6744-46b0-be8b-2b5e65db510a"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"xTensor`Private`RemoveSymbol[symbol] unprotects (if \
protected) and removes symbol.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`Private`RemoveSymbol\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"xTensor`Private`RemoveSymbol[symbol] unprotects (if \
protected) and removes symbol.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "xTensor`Private`RemoveSymbol[symbol] unprotects (if protected) and \
removes symbol.", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> 
    None, "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "xAct`xTensor`Private`RemoveSymbol"|>, 
   False]]], "Output",ExpressionUUID->"47a6fe38-ed4c-4620-91fc-d42d4e0dcbbf"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RemoveSymbol", "[", "symbol_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Unprotect", "[", "symbol", "]"}], ";", 
     RowBox[{"Remove", "[", "symbol", "]"}], ";"}], ")"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"57b99683-6222-4ff0-9a23-10619096bbcd"],

Cell["\<\
Before removing a symbol we check that the symbol can be actually removed:\
\>", "Text",ExpressionUUID->"fbc4f20e-7d4c-4e52-95ac-de35a009141e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "CheckRemoveSymbol"}]], \
"Input",ExpressionUUID->"12285af4-ec96-4006-8a14-73682a3f5b1e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"xTensor`Private`CheckRemoveSymbol[symbol] throws an \
error if symbol has visitors or its master has other servants. Otherwise it \
gives Null.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], \
"\<\"xAct`xTensor`Private`CheckRemoveSymbol\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"xTensor`Private`CheckRemoveSymbol[symbol] throws an \
error if symbol has visitors or its master has other servants. Otherwise it \
gives Null.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "xTensor`Private`CheckRemoveSymbol[symbol] throws an error if symbol has \
visitors or its master has other servants. Otherwise it gives Null.", 
    "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`Private`CheckRemoveSymbol"|>, 
   False]]], "Output",ExpressionUUID->"c1abe8d4-323e-41d2-9f19-402551a2f525"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CheckRemoveSymbol", "[", "symbol_Symbol", "]"}], ":=", 
   RowBox[{"Which", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"VisitorsOf", "[", "symbol", "]"}], "=!=", 
      RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"General", "::", "noundef"}], ",", "\"\<Symbol\>\"", ",", 
        "symbol", ",", "\"\<it has visitors\>\""}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ServantsOf", "[", 
       RowBox[{"MasterOf", "[", "symbol", "]"}], "]"}], "=!=", 
      RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"General", "::", "noundef"}], ",", "\"\<Symbol\>\"", ",", 
        "symbol", ",", "\"\<its master is still alive\>\""}], "]"}]}], ",", 
     "\[IndentingNewLine]", "True", ",", "\[IndentingNewLine]", "Null"}], 
    "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f3ebd497-6b15-4fe5-8db5-f5c31f60d3f5"],

Cell["\<\
After checking that a symbol can be removed, we have to drop it from the \
lists of visitors of its hosts:\
\>", "Text",ExpressionUUID->"4913ae10-0c6d-4541-a7ea-078d2b359d22"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DropFromHosts", "[", "symbol_Symbol", "]"}], ":=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"xUpDeleteCasesTo", "[", 
       RowBox[{
        RowBox[{"VisitorsOf", "[", "#", "]"}], ",", "symbol"}], "]"}], "&"}], 
     ",", 
     RowBox[{"HostsOf", "[", "symbol", "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"743954f7-df15-4b5f-8e52-55a7fef5cb5c"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4. Initialize type treatment", \
"Subsection",ExpressionUUID->"e1c26ded-2646-40ae-bc96-eec15f6272b6"],

Cell[CellGroupData[{

Cell["2.4.1. Basic functions and variables", \
"Subsubsection",ExpressionUUID->"df77a496-f99e-4f05-893a-a41f3d1ed54e"],

Cell["\<\
These 14 names define the types of symbols and will be used for several \
purposes in the package. Users should not use them for their own purposes:\
\>", "Text",ExpressionUUID->"c9c69d8e-d00d-4788-9294-16feb61b6a74"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "$Types"}]], "Input",ExpressionUUID->"a020e711-c6ad-46b1-8644-db99656e868d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"xTensor`Private`$Types is a global variable \
containing the list of types currently defined in xTensor.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`Private`$Types\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"xTensor`Private`$Types is a global variable \
containing the list of types currently defined in xTensor.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "xTensor`Private`$Types is a global variable containing the list of types \
currently defined in xTensor.", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> None, "DownValues" -> None, "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`Private`$Types"|>, 
   False]]], "Output",ExpressionUUID->"14939b78-7b86-4ac1-b62b-cf51ea29439b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$Types", "=", 
   RowBox[{"{", 
    RowBox[{
    "AbstractIndex", ",", "Manifold", ",", "Mapping", ",", "VBundle", ",", 
     "Tensor", ",", "Metric", ",", "CovD", ",", "InertHead", ",", 
     "ScalarFunction", ",", "ConstantSymbol", ",", "Parameter", ",", 
     "Product", ",", "Chart", ",", "Basis"}], "}"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"6d7dcb79-af5a-4610-8a31-a731a70d36c8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "/@", "$Types"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"8500c20f-5be2-4345-b9bf-620dbf512b60"],

Cell[TextData[{
 "The word Constant is already used and protected by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". It will be never used in ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ". Product is also already protected."
}], "Text",ExpressionUUID->"283bfdd5-4452-4b9f-852a-44eb0ced1e7d"],

Cell["\<\
Lists of objects (apart from $Types, already defined). These global variables \
are all public:\
\>", "Text",ExpressionUUID->"282813cc-f8c4-4e42-accc-973bc4c4c38b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Main", " ", "14", " ", "data", " ", "bases"}], " ", "*)"}], "\n", 
  
  RowBox[{
   RowBox[{
    RowBox[{"$Manifolds", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$Mappings", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$VBundles", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$AbstractIndices", ":=", 
     RowBox[{"Flatten", "[", 
      RowBox[{"IndicesOfVBundle", "/@", "$VBundles"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$ConstantSymbols", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$Tensors", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$CovDs", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$Metrics", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$InertHeads", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$ScalarFunctions", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$Parameters", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$Products", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$Bases", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$Charts", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Additional", " ", "4", " ", "data", " ", "bases"}], ",", " ", 
     RowBox[{
     "apart", " ", "from", " ", "the", " ", "private", " ", 
      "$FirstMetrics"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$ProductManifolds", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$SumVBundles", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$ProductMetrics", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"$Rules", "=", 
     RowBox[{"{", "}"}]}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"bb6a3876-af44-467b-b805-14739c9c4a4a"],

Cell[TextData[{
 "Inquiring functions (predicates) for types  (ProductManifoldQ is considered \
to be included in ManifoldQ; ProductMetricQ is considered to be included in \
MetricQ; we write xTensorQ rather than TensorQ because ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " has a built-in TensorQ from version 5.):"
}], "Text",ExpressionUUID->"c943e588-fdf0-4916-ace0-0ee64adce8d6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "TensorQ"}]], \
"Input",ExpressionUUID->"bb9f4674-82f8-4b64-817b-5f22444bfb92"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"System`TensorQ\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"System`TensorQ\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"System`TensorQ\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "System`TensorQ", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {Protected}, 
    "FullName" -> "System`TensorQ"|>, 
   True]]], "Output",ExpressionUUID->"e825bcc8-1250-481b-8e7d-2453255bb838"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "xTensorQ"}]], \
"Input",ExpressionUUID->"03471721-132f-4e6c-9811-a30204863728"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"xTensorQ[expr] gives True if expr has been \
registered as a tensor, and False otherwise. Do not confuse with \
Mathematica's TensorQ.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`xTensorQ\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"xTensorQ[expr] gives True if expr has been \
registered as a tensor, and False otherwise. Do not confuse with \
Mathematica's TensorQ.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "xTensorQ[expr] gives True if expr has been registered as a tensor, and \
False otherwise. Do not confuse with Mathematica's TensorQ.", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`xTensorQ"|>, 
   False]]], "Output",ExpressionUUID->"f8784cd9-16e4-4149-97ec-1c634b79be0e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$QFunctions", "=", 
   RowBox[{"{", 
    RowBox[{
    "AbstractIndexQ", ",", "ConstantSymbolQ", ",", "xTensorQ", ",", "CovDQ", ",",
      "MetricQ", ",", "ManifoldQ", ",", "MappingQ", ",", "VBundleQ", ",", 
     "InertHeadQ", ",", "ScalarFunctionQ", ",", "BasisQ", ",", "ChartQ", ",", 
     "ParameterQ", ",", "ProductQ"}], "}"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"39dbea1b-533d-4879-a124-077225da0b1a"],

Cell[TextData[{
 "All typeQ functions must be handled using upvalues. With unknown symbols \
they all give False, without errors (because these functions will be used on \
all kinds of input, including ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions):"
}], "Text",ExpressionUUID->"ea87404f-fc28-4333-a3e1-08fb7ac16df2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SetDelayed", "[", 
     RowBox[{
      RowBox[{"#", "[", "_", "]"}], ",", "False"}], "]"}], "&"}], "/@", 
   "$QFunctions"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d473076d-3f93-4959-ba71-b50e5dd32034"],

Cell["They only accept one argument.", \
"Text",ExpressionUUID->"dae874d4-13c9-4e5b-8830-4aa575027a0b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"#", ",", "1"}], "]"}], "&"}], "/@", "$QFunctions"}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"db322793-3ec9-4b69-bcda-dfb3188886d8"],

Cell["\<\
Protect them because they will be used only in the assignments of upvalues \
for symbols.\
\>", "Text",ExpressionUUID->"08c69c30-9a7c-443c-a1f7-a69bc9cc6800"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"Evaluate", "[", "$QFunctions", "]"}], "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"1f799aed-396c-4133-ae0d-0e0881b67369"],

Cell["Example:", \
"Text",ExpressionUUID->"73764527-9a6a-4bc8-aa51-e827fe7fc4ca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "AbstractIndexQ"}]], \
"Input",ExpressionUUID->"e325565b-15d7-4ecf-ada8-ad0c12ee0a92"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"AbstractIndexQ[symbol] gives True if symbol has \
been registered as an abstract index. Note that it gives False on \
down-indices.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"AbstractIndexQ", "[", "]"}], ":=", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"AbstractIndexQ", "::", "argx"}], "MessageName"], 
                    ",", "AbstractIndexQ", ",", "0"}], "]"}]}]},
                    {
                    RowBox[{
                    RowBox[{"AbstractIndexQ", "[", "_", "]"}], ":=", 
                    "False"}]},
                    {
                    RowBox[{
                    RowBox[{"AbstractIndexQ", "[", 
                    RowBox[{"_", ",", "xAct`xCore`Private`x$__"}], "]"}], ":=", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"AbstractIndexQ", "::", "argx"}], "MessageName"], 
                    ",", "AbstractIndexQ", ",", 
                    RowBox[{"1", "+", 
                    RowBox[{"Length", "[", 
                    RowBox[{"{", "xAct`xCore`Private`x$", "}"}], "]"}]}]}], 
                    "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`AbstractIndexQ\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"AbstractIndexQ[symbol] gives True if symbol has \
been registered as an abstract index. Note that it gives False on \
down-indices.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "AbstractIndexQ[symbol] gives True if symbol has been registered as an \
abstract index. Note that it gives False on down-indices.", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, xAct`xTensor`AbstractIndexQ, {
      xAct`xTensor`AbstractIndexQ[] :> Message[
         MessageName[xAct`xTensor`AbstractIndexQ, "argx"], 
         xAct`xTensor`AbstractIndexQ, 0], xAct`xTensor`AbstractIndexQ[
         Blank[]] :> False, xAct`xTensor`AbstractIndexQ[
         Blank[], 
         Pattern[xAct`xCore`Private`x$, 
          BlankSequence[]]] :> Message[
         MessageName[xAct`xTensor`AbstractIndexQ, "argx"], 
         xAct`xTensor`AbstractIndexQ, 1 + Length[{xAct`xCore`Private`x$}]]}], 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {Protected}, 
    "FullName" -> "xAct`xTensor`AbstractIndexQ"|>, 
   True]]], "Output",ExpressionUUID->"06c130e8-e95d-4f69-8492-dcfd6fc4d25f"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4.2. FindAllOfType", \
"Subsubsection",ExpressionUUID->"818519c4-26ba-4585-b56a-c18a2988f309"],

Cell[TextData[{
 "We use Heads->True, so that we find the objects in heads (for example in \
the vector field of a Lie Derivative or in InChart). This function evaluates \
its argument. Right now it is used in MakeRule to look for tensors, and in \
ToValues in ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 " to detect which tensors we need values for."
}], "Text",ExpressionUUID->"9a4669af-719c-4e57-9bec-6cc284c4b542"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "FindAllOfType"}]], \
"Input",ExpressionUUID->"f2960a99-5fd1-4748-b35f-fbbdddbac6e6"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"FindAllOfType[expr, type] gives the list of all \
occurrences of elements of the given type in expr, including their indices \
for types like Tensor, CovD, etc.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`FindAllOfType\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"FindAllOfType[expr, type] gives the list of all \
occurrences of elements of the given type in expr, including their indices \
for types like Tensor, CovD, etc.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "FindAllOfType[expr, type] gives the list of all occurrences of elements \
of the given type in expr, including their indices for types like Tensor, \
CovD, etc.", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None,
     "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "xAct`xTensor`FindAllOfType"|>, 
   False]]], "Output",ExpressionUUID->"f2e0019f-db94-4eed-ab42-e84c698ca9af"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FindAllOfType", "[", 
    RowBox[{"expr_", ",", "AbstractIndex"}], "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"_Symbol", "?", "AbstractIndexQ"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       InterpretationBox["\[Infinity]",
        DirectedInfinity[1]]}], "}"}], ",", 
     RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindAllOfType", "[", 
    RowBox[{"expr_", ",", "ConstantSymbol"}], "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"_Symbol", "?", "ConstantSymbolQ"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       InterpretationBox["\[Infinity]",
        DirectedInfinity[1]]}], "}"}], ",", 
     RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindAllOfType", "[", 
    RowBox[{"expr_", ",", "Parameter"}], "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"_Symbol", "?", "ParameterQ"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       InterpretationBox["\[Infinity]",
        DirectedInfinity[1]]}], "}"}], ",", 
     RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindAllOfType", "[", 
    RowBox[{"expr_", ",", "Manifold"}], "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"_", "?", "ManifoldQ"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       InterpretationBox["\[Infinity]",
        DirectedInfinity[1]]}], "}"}], ",", 
     RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindAllOfType", "[", 
    RowBox[{"expr_", ",", "Mapping"}], "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"_", "?", "MappingQ"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       InterpretationBox["\[Infinity]",
        DirectedInfinity[1]]}], "}"}], ",", 
     RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindAllOfType", "[", 
    RowBox[{"expr_", ",", "VBundle"}], "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"_", "?", "VBundleQ"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       InterpretationBox["\[Infinity]",
        DirectedInfinity[1]]}], "}"}], ",", 
     RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindAllOfType", "[", 
    RowBox[{"expr_", ",", "Tensor"}], "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", 
     RowBox[{
      RowBox[{"_", "?", "xTensorQ"}], "[", "___", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       InterpretationBox["\[Infinity]",
        DirectedInfinity[1]]}], "}"}], ",", 
     RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindAllOfType", "[", 
    RowBox[{"expr_", ",", "Metric"}], "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", 
     RowBox[{
      RowBox[{"_Symbol", "?", "MetricQ"}], "[", 
      RowBox[{"_", ",", "_"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       InterpretationBox["\[Infinity]",
        DirectedInfinity[1]]}], "}"}], ",", 
     RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindAllOfType", "[", 
    RowBox[{"expr_", ",", "CovD"}], "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"_", "?", "CovDQ"}], "[", "__", "]"}], "[", "_", "]"}], "|", 
      RowBox[{"CovD", "[", 
       RowBox[{"_", ",", "__"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       InterpretationBox["\[Infinity]",
        DirectedInfinity[1]]}], "}"}], ",", 
     RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindAllOfType", "[", 
    RowBox[{"expr_", ",", "InertHead"}], "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", 
     RowBox[{
      RowBox[{"_", "?", "InertHeadQ"}], "[", "__", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       InterpretationBox["\[Infinity]",
        DirectedInfinity[1]]}], "}"}], ",", 
     RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindAllOfType", "[", 
    RowBox[{"expr_", ",", "ScalarFunction"}], "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", 
     RowBox[{
      RowBox[{"_", "?", "ScalarFunctionQ"}], "[", "___", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       InterpretationBox["\[Infinity]",
        DirectedInfinity[1]]}], "}"}], ",", 
     RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindAllOfType", "[", 
    RowBox[{"expr_", ",", "Product"}], "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"_Symbol", "?", "ProductQ"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       InterpretationBox["\[Infinity]",
        DirectedInfinity[1]]}], "}"}], ",", 
     RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindAllOfType", "[", 
    RowBox[{"expr_", ",", "Chart"}], "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"_Symbol", "?", "ChartQ"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       InterpretationBox["\[Infinity]",
        DirectedInfinity[1]]}], "}"}], ",", 
     RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindAllOfType", "[", 
    RowBox[{"expr_", ",", "Basis"}], "]"}], ":=", 
   RowBox[{"Cases", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"Basis", "[", 
      RowBox[{"_", ",", "_"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       InterpretationBox["\[Infinity]",
        DirectedInfinity[1]]}], "}"}], ",", 
     RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"FindAllOfType", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "FindAllOfType", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"a9f4cb3c-36bb-4381-881f-b3fc2fad4d9b"],

Cell[TextData[{
 "Note that there is no Symbol head for ScalarFunction. This is to work with \
InChart in ",
 StyleBox["xCoba",
  FontSlant->"Italic"],
 ". From version 1.0 we have also relaxed the restriction in the tensor's \
heads, and in mappings, to include mapping composition."
}], "Text",ExpressionUUID->"31f0aa96-c37f-483c-a50a-2d5577b22753"],

Cell["\<\
Note that Basis is treated differently: we are not looking for all basis \
symbols, but for all Basis tensors, which is a very different thing. I don't \
remember why is that.\
\>", "Text",ExpressionUUID->"292c9e39-713a-4e5f-b690-8be95f41b3ec"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4.3. Undef", \
"Subsubsection",ExpressionUUID->"dc41bade-bb8c-40da-bbf0-a2b18bc041f9"],

Cell["This function is a generic driver for undefinition:", \
"Text",ExpressionUUID->"f86c6d3a-0c86-49dc-b192-ab5dfc8f3c6f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Undef"}]], "Input",ExpressionUUID->"a906c00d-2fa7-4157-b064-13f6a2af6c23"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Undef[symbol] undefines the symbol, whatever its \
type may be. The only exception are abstract indices.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`Undef\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Undef[symbol] undefines the symbol, whatever its \
type may be. The only exception are abstract indices.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "Undef[symbol] undefines the symbol, whatever its type may be. The only \
exception are abstract indices.", "Documentation" -> None, "OwnValues" -> 
    None, "UpValues" -> None, "DownValues" -> None, "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`Undef"|>, 
   False]]], "Output",ExpressionUUID->"0f7e94ce-3374-49ff-9829-90dc73b092da"]
}, Open  ]],

Cell["\<\
We give definitions for 12 types. The definition for metrics is not needed \
because we have the definition for tensors. I don't want to allow \
undefinition of indices through Undef and hence that generates an error. Note \
that here it does not make sense to remove the _Symbol specification in the \
patterns.\
\>", "Text",ExpressionUUID->"3d77dce4-1919-45c4-9bc1-9e1f3c41cd7d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Undef", "[", 
    RowBox[{"symbol_Symbol", "?", "ManifoldQ"}], "]"}], ":=", 
   RowBox[{"UndefManifold", "[", "symbol", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Undef", "[", 
    RowBox[{"symbol_Symbol", "?", "MappingQ"}], "]"}], ":=", 
   RowBox[{"UndefMapping", "[", "symbol", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Undef", "[", 
    RowBox[{"symbol_Symbol", "?", "VBundleQ"}], "]"}], ":=", 
   RowBox[{"UndefVBundle", "[", "symbol", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Undef", "[", 
    RowBox[{"symbol_Symbol", "?", "ParameterQ"}], "]"}], ":=", 
   RowBox[{"UndefParameter", "[", "symbol", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Undef", "[", 
    RowBox[{"symbol_Symbol", "?", "xTensorQ"}], "]"}], ":=", 
   RowBox[{"UndefTensor", "[", "symbol", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Undef", "[", 
    RowBox[{"symbol_Symbol", "?", "CovDQ"}], "]"}], ":=", 
   RowBox[{"UndefCovD", "[", "symbol", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Undef", "[", 
    RowBox[{"symbol_Symbol", "?", "ConstantSymbolQ"}], "]"}], ":=", 
   RowBox[{"UndefConstantSymbol", "[", "symbol", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Undef", "[", 
    RowBox[{"symbol_Symbol", "?", "ScalarFunctionQ"}], "]"}], ":=", 
   RowBox[{"UndefScalarFunction", "[", "symbol", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Undef", "[", 
    RowBox[{"symbol_Symbol", "?", "InertHeadQ"}], "]"}], ":=", 
   RowBox[{"UndefInertHead", "[", "symbol", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Undef", "[", 
    RowBox[{"symbol_Symbol", "?", "ProductQ"}], "]"}], ":=", 
   RowBox[{"UndefProduct", "[", "symbol", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Undef", "[", 
    RowBox[{"symbol_Symbol", "?", "ChartQ"}], "]"}], ":=", 
   RowBox[{"xAct`xCoba`UndefChart", "[", "symbol", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Undef", "[", 
    RowBox[{"symbol_Symbol", "?", "BasisQ"}], "]"}], ":=", 
   RowBox[{"xAct`xCoba`UndefBasis", "[", "symbol", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Undef", "[", 
    RowBox[{"symbol_Symbol", "?", "AbstractIndexQ"}], "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"Undef", "::", "nouse"}], ",", "\"\<Undef\>\"", 
      ",", "\"\<an abstract index\>\""}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Undef", "[", "symbol_", "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"Undef", "::", "unknown"}], ",", "\"\<symbol type of\>\"", ",", 
      "symbol"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"Undef", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "Undef", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"fbb6a6e7-9ed4-46e0-9cfb-fd3cf2e6e8a6"],

Cell["\<\
TODO: It has been suggested that Undef[All], and perhaps even Undef[],  \
undefines everything in the current session. I think this may be useful to \
avoid quitting the kernel to restart afresh.\
\>", "Text",ExpressionUUID->"5c89549f-cde0-409e-8f66-91d31db93560"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.5. Validate new symbols in a session", \
"Subsection",ExpressionUUID->"4961ea1f-e080-4a31-bcd7-86b4e3bc27c8"],

Cell[TextData[{
 "We check that symbol is not a metric before checking that it is not a \
tensor. This function could be moved to ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 ", but right now all types belong to ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ", and so that does not make much sense."
}], "Text",ExpressionUUID->"a14aac6e-0541-43e5-8814-2ac5a3b4791c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ValidateSymbolInSession", "[", "symbol_", "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"name", "=", 
       RowBox[{"ToString", "[", "symbol", "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Which", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"AbstractIndexQ", "[", "symbol", "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", 
          ",", "\"\<as an abstract index\>\""}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ConstantSymbolQ", "[", "symbol", "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", 
          ",", "\"\<as a constant-symbol\>\""}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ParameterQ", "[", "symbol", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", 
          ",", "\"\<as a parameter\>\""}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ManifoldQ", "[", "symbol", "]"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", 
          ",", "\"\<as a manifold\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"MappingQ", "[", "symbol", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", 
          ",", "\"\<as a mapping\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"VBundleQ", "[", "symbol", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", 
          ",", "\"\<as a vector bundle\>\""}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"MetricQ", "[", "symbol", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", 
          ",", "\"\<as a metric\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"xTensorQ", "[", "symbol", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", 
          ",", "\"\<as a tensor\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"CovDQ", "[", "symbol", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", 
          ",", "\"\<as a covariant derivative\>\""}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ScalarFunctionQ", "[", "symbol", "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", 
          ",", "\"\<as a scalar function\>\""}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"InertHeadQ", "[", "symbol", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", 
          ",", "\"\<as an inert head\>\""}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ProductQ", "[", "symbol", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", 
          ",", "\"\<as a product\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"ChartQ", "[", "symbol", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", 
          ",", "\"\<as a chart\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"BasisQ", "[", "symbol", "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"ValidateSymbol", "::", "used"}], ",", "name", 
          ",", "\"\<as a basis\>\""}], "]"}]}]}], "\[IndentingNewLine]", 
      "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"ValidateSymbolInSession", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "ValidateSymbolInSession", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"3a485aed-e2db-46b0-a93b-44b87193cf5d"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.6. Formatting", \
"Subsection",ExpressionUUID->"d0b2e988-8dcb-47a9-86ec-5eaaa020e740"],

Cell[TextData[{
 "All this could be done much better with newer capabilities of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "..."
}], "Text",ExpressionUUID->"ff479a3e-55c3-49b2-902d-ecc686dccdbd"],

Cell[CellGroupData[{

Cell["2.6.1. Interpretation of boxes", \
"Subsubsection",ExpressionUUID->"fe54606c-5828-4b69-9449-e18ad0bb6b6c"],

Cell[TextData[{
 "We shall use InterpretationBox to allow cut-and-paste of box-formatted \
expressions. A problem is that InterpretationBox has attribute \
HoldAllComplete and hence we need to pass the box after full evaluation. We \
do it simply with the intermediate function interpretbox, which only holds \
its first argument (the expression). Note that the order interpretbox[ expr, \
box ] is reversed with respect to InterpretationBox[ box, expr ] because we \
want to hold expr, but not box. We also introduce AutoSpacing->False to give \
indices their proper sizes, and ShowAutoStyles->False to avoid the blue \
coloring of unknown symbols in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6+. Thanks to Alessandro Stecchina for spotting the latter problem.\n\n\
TODO: The fact that the second argument of interpretbox is evaluated is \
probably an evaluation leak. Can we avoid it?"
}], "Text",ExpressionUUID->"d58d4308-5b41-4c9c-8927-f1cd6cc92b67"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"interpretbox", ",", "HoldFirst"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"interpretbox", "[", 
    RowBox[{"expr_", ",", "box_"}], "]"}], ":=", 
   RowBox[{"InterpretationBox", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"StyleBox", "[", 
      RowBox[{"box", ",", 
       RowBox[{"AutoSpacing", "\[Rule]", "False"}], ",", 
       RowBox[{"ShowAutoStyles", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", "expr", ",", "\[IndentingNewLine]", 
     RowBox[{"Editable", "\[Rule]", "False"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"3672d39a-9dc8-4dc8-a960-d7d09368ab61"],

Cell["\<\
Colored background (right now not being used, not even by Scalar, as \
originally planned. Nobody likes it!):\
\>", "Text",ExpressionUUID->"67335124-37df-406c-a8ce-3de96a989090"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"interpretboxcolor", ",", "HoldFirst"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"interpretboxcolor", "[", 
    RowBox[{"expr_", ",", "box_", ",", "color_"}], "]"}], ":=", 
   RowBox[{"interpretbox", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"StyleBox", "[", 
      RowBox[{"box", ",", 
       RowBox[{"Background", "\[Rule]", "color"}]}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"164ab7df-5787-4d5d-ba0b-9ad3e98537ea"],

Cell["\<\
Now that we have wrapped the boxes with InterpretationBox and StyleBox, we \
need a function to undo that:\
\>", "Text",ExpressionUUID->"b6f6f536-5454-4aa8-b7af-c212028e8a1d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"boxof", "[", 
    RowBox[{"InterpretationBox", "[", 
     RowBox[{"box_", ",", "__"}], "]"}], "]"}], ":=", 
   RowBox[{"boxof", "[", "box", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"boxof", "[", 
    RowBox[{"StyleBox", "[", 
     RowBox[{"box_", ",", "__"}], "]"}], "]"}], ":=", 
   RowBox[{"boxof", "[", "box", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"boxof", "[", "box_", "]"}], ":=", "box"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"dad832d4-b901-469f-bb46-87781d06cfae"],

Cell["Action on a list of arguments:", \
"Text",ExpressionUUID->"d949d650-cc0e-4110-ac1f-7d8933b80584"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"MakeSequenceBox", ",", "HoldFirst"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeSequenceBox", "[", 
    RowBox[{"list_List", ",", "char_", ",", "format_"}], "]"}], ":=", 
   RowBox[{"RowBox", "@", 
    RowBox[{"Riffle", "[", 
     RowBox[{
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{"Function", "[", 
         RowBox[{"Null", ",", 
          RowBox[{"MakeBoxes", "[", 
           RowBox[{"#", ",", "format"}], "]"}], ",", "HoldFirst"}], "]"}], ",", 
        RowBox[{"Unevaluated", "[", "list", "]"}]}], "]"}], ",", "char"}], 
     "]"}]}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"8720657c-b1db-45a8-9a04-ae2790481381"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeSequenceBox", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<a\>\"", ",", "\"\<b\>\"", ",", "\"\<c\>\""}], "}"}], 
   ",", "\"\<,\>\"", ",", "StandardForm"}], 
  "]"}]], "Input",ExpressionUUID->"0f824f72-8955-4a6f-a729-d6a92653bf81"],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{"\<\"\\\"a\\\"\"\>", ",", "\<\",\"\>", ",", "\<\"\\\"b\\\"\"\>", 
    ",", "\<\",\"\>", ",", "\<\"\\\"c\\\"\"\>"}], "}"}], 
  "]"}]], "Output",ExpressionUUID->"f12554c1-b2b1-462e-ad1d-4ff51e4c0556"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RawBoxes", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"69fffb46-ae04-4a07-a3a6-a256aa7dbc67"],

Cell[BoxData[
 RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", 
  ",", "\<\"c\"\>"}]], \
"Output",ExpressionUUID->"38b9e9ec-c5e7-413f-b963-15592f36ce78"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeSequenceBox", "[", 
  RowBox[{
   RowBox[{"{", "\"\<a\>\"", "}"}], ",", "\"\<,\>\"", ",", "StandardForm"}], 
  "]"}]], "Input",ExpressionUUID->"8fb69acb-9a03-450a-8cda-7acf790f0c93"],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", "\<\"\\\"a\\\"\"\>", "}"}], 
  "]"}]], "Output",ExpressionUUID->"3d18c013-69c8-4e2e-b28b-de998a27699d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RawBoxes", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"af89d254-7047-44f9-84bd-3cee8d227ccd"],

Cell[BoxData["\<\"a\"\>"], \
"Output",ExpressionUUID->"46398f52-9899-4225-9d68-d271cd621d6b"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.6.2. xTensorFormStart/Stop", \
"Subsubsection",ExpressionUUID->"23bb1675-af06-47fa-a187-ff4efd0a3f7d"],

Cell["\<\
These two functions start and stop formatting of different things. With an \
argument they only start/stop formatting for that class of objects. Products \
are not included among the classes because each product has its own MakeBoxes \
definition.\
\>", "Text",ExpressionUUID->"7a620464-895b-4e8c-bb8c-a12021281786"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "xTensorFormStart"}]], \
"Input",ExpressionUUID->"51f0e3cc-df40-4b7a-97df-6c348e450872"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"xTensorFormStart[class] starts formatting for a \
class of objects. Valid classes are: ConstantSymbol, Parameter, InertHead, \
Tensor, CovD, LieD. xTensorFormStart[] starts formatting for all those \
classes.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`xTensorFormStart\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"xTensorFormStart[class] starts formatting for a \
class of objects. Valid classes are: ConstantSymbol, Parameter, InertHead, \
Tensor, CovD, LieD. xTensorFormStart[] starts formatting for all those \
classes.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "xTensorFormStart[class] starts formatting for a class of objects. Valid \
classes are: ConstantSymbol, Parameter, InertHead, Tensor, CovD, LieD. \
xTensorFormStart[] starts formatting for all those classes.", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`xTensorFormStart"|>, 
   False]]], "Output",ExpressionUUID->"315b6a78-e942-472d-b4d0-d6ff481028d6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "xTensorFormStop"}]], \
"Input",ExpressionUUID->"6f3c0f61-0cfc-4132-95f4-41f2c8553c68"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"xTensorFormStop[class] stops formatting for a class \
of objects. Valid classes are: ConstantSymbol, Parameter, InertHead, Tensor, \
CovD, LieD. xTensorFormStop[] stops formatting for all those classes.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`xTensorFormStop\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"xTensorFormStop[class] stops formatting for a class \
of objects. Valid classes are: ConstantSymbol, Parameter, InertHead, Tensor, \
CovD, LieD. xTensorFormStop[] stops formatting for all those classes.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "xTensorFormStop[class] stops formatting for a class of objects. Valid \
classes are: ConstantSymbol, Parameter, InertHead, Tensor, CovD, LieD. \
xTensorFormStop[] stops formatting for all those classes.", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`xTensorFormStop"|>, 
   False]]], "Output",ExpressionUUID->"edcf06fe-8270-4ce0-a1c0-6623ffd094c8"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorFormStart", "[", "]"}], ":=", 
   RowBox[{"xTensorFormStart", "/@", 
    RowBox[{"{", 
     RowBox[{
     "InertHead", ",", "ConstantSymbol", ",", "Parameter", ",", "Tensor", ",",
       "CovD", ",", "LieD", ",", "ParamD"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xTensorFormStop", "[", "]"}], ":=", 
   RowBox[{"xTensorFormStop", "/@", 
    RowBox[{"{", 
     RowBox[{
     "InertHead", ",", "ConstantSymbol", ",", "Parameter", ",", "Tensor", ",",
       "CovD", ",", "LieD", ",", "ParamD"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xTensorFormStart", "[", "x_", "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"xTensorFormStart", "::", "unknown"}], 
      ",", "\"\<class to format\>\"", ",", 
      RowBox[{"ToString", "[", "x", "]"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xTensorFormStop", "[", "x_", "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"xTensorFormStop", "::", "unknown"}], 
      ",", "\"\<class to format\>\"", ",", 
      RowBox[{"ToString", "[", "x", "]"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"xTensorFormStart", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"xTensorFormStop", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"a2fdf2ab-b211-4120-80e9-d9c389ddff1f"],

Cell["\<\
We do not protect them because they will be given particular definitions \
below.\
\>", "Text",ExpressionUUID->"84689087-70d9-43c7-83a0-15f51dd4bee2"],

Cell["\<\
TODO: There should be a xTensorForm command. I need to study the *Form \
commands.\
\>", "Text",ExpressionUUID->"ff1b1e71-c0e7-4876-a77a-ef2f674e4c05"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.6.3. PrintAs", \
"Subsubsection",ExpressionUUID->"e76e8306-515d-43d0-ac3d-1172066f248a"],

Cell["\<\
These are functions to format symbols of objects. We need a discussion on why \
we use them instead of directly using Format. Currently the only reason is to \
have full control on the process. Format is one of those functions that does \
many things in an obscure way. Any defined symbol has its own PrintAs \
definition, including the abstract indices. In any other case PrintAs is \
simply ToString.

Addition in 1.1.4: We now accept box specifications in PrintAs. There is no \
System` function to detect what a box expression is, but there is \
System`Convert`TeXFormDump`BoxQ which contains all (or at least most) \
possibilities:\
\>", "Text",ExpressionUUID->"2dfc3550-89d8-46ce-9bb5-c8e6ab41b70b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "System`Convert`TeXFormDump`BoxQ"}]], \
"Input",ExpressionUUID->"973aaf21-c1cb-4768-accd-cd6470a16b31"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"System`Convert`TeXFormDump`BoxQ\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{
                    "System`Convert`TeXFormDump`BoxQ", "[", 
                    "System`Convert`CommonDump`box_", "]"}], ":=", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    RowBox[{
                    "Unevaluated", "[", "System`Convert`CommonDump`box", 
                    "]"}], ",", 
                    RowBox[{
                    "_String", "|", "_RowBox", "|", "_GridBox", "|", 
                    "_SuperscriptBox", "|", "_SubscriptBox", "|", 
                    "_SubsuperscriptBox", "|", "_OverscriptBox", "|", 
                    "_UnderscriptBox", "|", "_UnderoverscriptBox", "|", 
                    "_FractionBox", "|", "_SqrtBox", "|", "_RadicalBox", "|", 
                    "_StyleBox", "|", "_FrameBox", "|", "_PaneBox", "|", 
                    "_PanelBox", "|", "_AdjustmentBox", "|", "_ButtonBox", "|",
                     "_FormBox", "|", "_InterpretationBox", "|", "_TagBox", "|",
                     "_ErrorBox", "|", "_CounterBox", "|", "_ValueBox", "|", 
                    "_OptionValueBox", "|", "_Cell", "|", "_BoxData", "|", 
                    "_TextData", "|", "_Notebook", "|", "_Graphics", "|", 
                    "_Graphics3D", "|", "_GraphicsArray", "|", 
                    "_GraphicsGrid", "|", "_SurfaceGraphics", "|", 
                    "_ContourGraphics", "|", "_DensityGraphics", "|", 
                    "_AnimatorBox", "|", "_CheckboxBox", "|", "_DynamicBox", "|",
                     "_InputFieldBox", "|", 
                    "_System`Convert`TeXFormDump`MultiviewBox", "|", 
                    "_OpenerBox", "|", "_PopupMenuBox", "|", 
                    "_RadioButtonBox", "|", "_SliderBox", "|", 
                    "_System`Convert`TeXFormDump`TabbedMultiviewBox", "|", 
                    "_TooltipBox", "|", 
                    "_System`Convert`TeXFormDump`AreaSliderBox", "|", 
                    "_PaneSelectorBox", "|", "_TemplateBox", "|", 
                    "_TabViewBox"}]}], "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"System`Convert`TeXFormDump`BoxQ\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"System`Convert`TeXFormDump`BoxQ\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "System`Convert`TeXFormDump`BoxQ", 
    "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> 
    Information`InformationValueForm[
     DownValues, System`Convert`TeXFormDump`BoxQ, {
      System`Convert`TeXFormDump`BoxQ[
         Pattern[System`Convert`CommonDump`box, 
          Blank[]]] :> MatchQ[
         Unevaluated[System`Convert`CommonDump`box], 
         Alternatives[
          Blank[String], 
          Blank[RowBox], 
          Blank[GridBox], 
          Blank[SuperscriptBox], 
          Blank[SubscriptBox], 
          Blank[SubsuperscriptBox], 
          Blank[OverscriptBox], 
          Blank[UnderscriptBox], 
          Blank[UnderoverscriptBox], 
          Blank[FractionBox], 
          Blank[SqrtBox], 
          Blank[RadicalBox], 
          Blank[StyleBox], 
          Blank[FrameBox], 
          Blank[PaneBox], 
          Blank[PanelBox], 
          Blank[AdjustmentBox], 
          Blank[ButtonBox], 
          Blank[FormBox], 
          Blank[InterpretationBox], 
          Blank[TagBox], 
          Blank[ErrorBox], 
          Blank[CounterBox], 
          Blank[ValueBox], 
          Blank[OptionValueBox], 
          Blank[Cell], 
          Blank[BoxData], 
          Blank[TextData], 
          Blank[Notebook], 
          Blank[Graphics], 
          Blank[Graphics3D], 
          Blank[GraphicsArray], 
          Blank[GraphicsGrid], 
          Blank[SurfaceGraphics], 
          Blank[ContourGraphics], 
          Blank[DensityGraphics], 
          Blank[AnimatorBox], 
          Blank[CheckboxBox], 
          Blank[DynamicBox], 
          Blank[InputFieldBox], 
          Blank[System`Convert`TeXFormDump`MultiviewBox], 
          Blank[OpenerBox], 
          Blank[PopupMenuBox], 
          Blank[RadioButtonBox], 
          Blank[SliderBox], 
          Blank[System`Convert`TeXFormDump`TabbedMultiviewBox], 
          Blank[TooltipBox], 
          Blank[System`Convert`TeXFormDump`AreaSliderBox], 
          Blank[PaneSelectorBox], 
          Blank[TemplateBox], 
          Blank[TabViewBox]]]}], "SubValues" -> None, "DefaultValues" -> None,
     "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "System`Convert`TeXFormDump`BoxQ"|>, 
   True]]], "Output",ExpressionUUID->"94ecb755-e8de-4d42-9e93-6aaf554bb920"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"A", " ", "string", " ", "is", " ", "a", " ", 
    RowBox[{"string", ".", " ", "Null"}], " ", "means", " ", 
    RowBox[{"\"\<do not set typesetting\>\"", ".", " ", "Anything"}], " ", 
    "else", " ", "is", " ", "interpreted", " ", "as", " ", "a", " ", 
    "function"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"StripContext", "[", "string_String", "]"}], ":=", 
     RowBox[{"Last", "@", 
      RowBox[{"StringSplit", "[", 
       RowBox[{"string", ",", "\"\<`\>\""}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PrintAsString", "[", 
      RowBox[{"symbol_", ",", "Null"}], "]"}], ":=", "Null"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PrintAsString", "[", 
      RowBox[{"symbol_", ",", "pa_String"}], "]"}], ":=", "pa"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PrintAsString", "[", 
      RowBox[{"symbol_", ",", "pa_Hold"}], "]"}], ":=", "pa"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PrintAsString", "[", 
      RowBox[{"symbol_", ",", 
       RowBox[{"pa_", "?", "System`Convert`TeXFormDump`BoxQ"}]}], "]"}], ":=",
      "pa"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PrintAsString", "[", 
      RowBox[{"symbol_", ",", "pa_"}], "]"}], ":=", 
     RowBox[{"StripContext", "[", "\[IndentingNewLine]", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"res", "=", 
          RowBox[{"pa", "[", "symbol", "]"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"StringQ", "[", "res", "]"}], ",", "res", ",", 
          RowBox[{"ToString", "[", "res", "]"}]}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Handling", " ", "of", " ", "conjugate", " ", 
     RowBox[{"symbols", ":", " ", 
      RowBox[{
      "add", " ", "a", " ", "dagger", " ", "if", " ", "not", " ", "already", " ",
        "present"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AddDaggerCharacter", "[", 
      RowBox[{"boxes_Hold", ",", "_"}], "]"}], ":=", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Don't know how to conjugate \>\"", ",", "boxes"}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AddDaggerCharacter", "[", 
      RowBox[{"string_String", ",", "Conjugate"}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"HasDaggerCharacterQ", "[", "string", "]"}], ",", "string", ",", 
       RowBox[{"StringJoin", "[", 
        RowBox[{"string", ",", "$DaggerCharacter"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AddDaggerCharacter", "[", 
      RowBox[{"boxes_", ",", "Conjugate"}], "]"}], ":=", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{"boxes", ",", "$DaggerCharacter"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AddDaggerCharacter", "[", 
      RowBox[{"boxes_", ",", "dag_"}], "]"}], ":=", "boxes"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Main", ".", " ", "The"}], " ", "previous", " ", "two", " ", 
      "functions", " ", "will", " ", "be", " ", "used", " ", "in", " ", "its",
       " ", "second", " ", "argument"}], ",", " ", 
     RowBox[{"if", " ", "needed"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SetPrintAs", "[", 
      RowBox[{"symbol_", ",", "Null"}], "]"}], ":=", "Null"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SetPrintAs", "[", 
      RowBox[{"symbol_", ",", 
       RowBox[{"Hold", "[", "boxes_", "]"}]}], "]"}], ":=", 
     RowBox[{"xUpSetDelayed", "[", 
      RowBox[{
       RowBox[{"PrintAs", "[", "symbol", "]"}], ",", "boxes"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SetPrintAs", "[", 
      RowBox[{"symbol_", ",", "string_"}], "]"}], ":=", 
     RowBox[{"xUpSet", "[", 
      RowBox[{
       RowBox[{"PrintAs", "[", "symbol", "]"}], ",", "string"}], "]"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3defeeb4-499d-47fa-bd99-c5f5f351b722"],

Cell["\<\
The PrintAs framework is very evaluation-leaky. This should be avoided, also \
generalizing the use of strings to general box expressions. TODO.\
\>", "Text",ExpressionUUID->"2a34b1d9-666f-4fa5-bcdd-be898d63d33e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "PrintAs"}]], \
"Input",ExpressionUUID->"81737b02-3415-4277-9f7d-1fb1429d7b7e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"PrintAs[symbol] gives the output string or boxes \
for symbol in StandardForm.\\n\\nPrintAs is also an option for the DefType \
commands that specifies the output form of a defined symbol. It can be \
PrintAs -> string or PrintAs -> boxes. If boxes are to be constructed in a \
delayed way then use PrintAs -> Hold[delayedboxes]. Finally it can also be \
PrintAs -> function, such that the output will be ToString[function[symbol]].\
\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`PrintAs\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"PrintAs[symbol] gives the output string or boxes \
for symbol in StandardForm.\\n\\nPrintAs is also an option for the DefType \
commands that specifies the output form of a defined symbol. It can be \
PrintAs -> string or PrintAs -> boxes. If boxes are to be constructed in a \
delayed way then use PrintAs -> Hold[delayedboxes]. Finally it can also be \
PrintAs -> function, such that the output will be ToString[function[symbol]].\
\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "PrintAs[symbol] gives the output string or boxes for symbol in \
StandardForm.\n\nPrintAs is also an option for the DefType commands that \
specifies the output form of a defined symbol. It can be PrintAs -> string or \
PrintAs -> boxes. If boxes are to be constructed in a delayed way then use \
PrintAs -> Hold[delayedboxes]. Finally it can also be PrintAs -> function, \
such that the output will be ToString[function[symbol]].", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`PrintAs"|>, 
   False]]], "Output",ExpressionUUID->"cc4b0a72-cf8e-440f-bf87-1a203aff8050"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"PrintAs", ",", "HoldFirst"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "head_", "]"}], ":=", 
   RowBox[{"ToString", "[", 
    RowBox[{"Unevaluated", "[", "head", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"PrintAs", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "PrintAs", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"ebf14ca5-b7f7-4c0f-9cae-35eb616beb54"],

Cell["\<\
Finally, a simple way to print with a very small font, currently only used \
with projectors.\
\>", "Text",ExpressionUUID->"140032b7-ca7a-4328-ae6b-a346ec207be7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "STRINGPRINTAS", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"PrintAsSmaller", "[", "proj_", "]"}], ":=", 
    RowBox[{"\"\<\\*StyleBox[\\\"\>\"", "<>", 
     RowBox[{"PrintAs", "[", "proj", "]"}], 
     "<>", "\"\<\\\",FontSize->Tiny]\>\""}]}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"0c58a60c-1d0e-4706-a8b0-823bfceb64fd"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.6.4. GiveSymbol, GiveOutputString, PrintAsCharacter", \
"Subsubsection",ExpressionUUID->"80de2df8-c7d7-4004-abd1-ad12ec6ede71"],

Cell["\<\
These functions give names to all tensors that are associated in real time to \
other previously defined **symbols**. GiveSymbol defines the internal (true) \
name of the tensors. GiveOutputString defines the PrintAs name for those \
tensors. Special definitions for special types of tensors will be defined \
below. Note that GiveSymbol returns a symbol but GiveOutputString returns a \
string.\
\>", "Text",ExpressionUUID->"1208cad2-442a-410e-8ab5-e8369e81db37"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "GiveSymbol"}]], \
"Input",ExpressionUUID->"ddac6cf0-329d-4f3a-a363-0576624a49b8"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"GiveSymbol[object, case] constructs a symbol for \
the required object in the special given case. Both must be symbols or \
strings.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`GiveSymbol\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"GiveSymbol[object, case] constructs a symbol for \
the required object in the special given case. Both must be symbols or \
strings.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "GiveSymbol[object, case] constructs a symbol for the required object in \
the special given case. Both must be symbols or strings.", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`GiveSymbol"|>, 
   False]]], "Output",ExpressionUUID->"ab0fd2cb-30df-4283-ac26-0e9276165da6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "GiveOutputString"}]], \
"Input",ExpressionUUID->"6af09ef7-70bb-427b-8aec-b741bfb07a05"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"GiveOutputString[object, case] gives the string to \
be used as output in StandardForm. Both object and case must be symbols or \
strings.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`GiveOutputString\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"GiveOutputString[object, case] gives the string to \
be used as output in StandardForm. Both object and case must be symbols or \
strings.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "GiveOutputString[object, case] gives the string to be used as output in \
StandardForm. Both object and case must be symbols or strings.", 
    "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "xAct`xTensor`GiveOutputString"|>, 
   False]]], "Output",ExpressionUUID->"ba508b6d-8c57-4734-a16f-e9f0c3af76ba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "PrintAsCharacter"}]], \
"Input",ExpressionUUID->"d000f998-4f29-42ba-bae0-0052bb2c2d00"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"PrintAsCharacter[symbol] returns a character to be \
used in the typesetting of fundamental objects in xTensor. For example \
\\\"R\\\" for Riemann, \\\"G\\\" for Einstein, etc.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`PrintAsCharacter\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"PrintAsCharacter[symbol] returns a character to be \
used in the typesetting of fundamental objects in xTensor. For example \
\\\"R\\\" for Riemann, \\\"G\\\" for Einstein, etc.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "PrintAsCharacter[symbol] returns a character to be used in the \
typesetting of fundamental objects in xTensor. For example \"R\" for Riemann, \
\"G\" for Einstein, etc.", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> None, "DownValues" -> None, "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`PrintAsCharacter"|>, 
   False]]], "Output",ExpressionUUID->"4e912b26-92f0-48c2-933e-115ff8e7b68a"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Default", " ", "definition", " ", "for", " ", "the", " ", "names", " ", 
     "of", " ", "automatically"}], "-", 
    RowBox[{"defined", " ", 
     RowBox[{"tensors", ".", " ", "They"}], " ", "must", " ", "be", " ", 
     "symbols"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"GiveSymbol", "[", 
      RowBox[{"symbol_Symbol", ",", "post___"}], "]"}], ":=", 
     RowBox[{"SymbolJoin", "[", 
      RowBox[{"symbol", ",", "post"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{"(*", " ", 
    RowBox[{
    "Do", " ", "not", " ", "put", " ", "any", " ", "restrictions", " ", 
     "here", " ", "to", " ", "make", " ", "this", " ", "definition", " ", 
     "be", " ", "always", " ", "the", " ", "last", " ", 
     RowBox[{"downvalue", ".", " ", "STRINGPRINTAS"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"GiveOutputString", "[", 
      RowBox[{"symbol_Symbol", ",", "post___"}], "]"}], ":=", 
     RowBox[{"StringJoin", "[", 
      RowBox[{
       RowBox[{"PrintAsCharacter", "[", "symbol", "]"}], ",", 
       RowBox[{"PrintAs", "/@", 
        RowBox[{"{", "post", "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetAttributes", "[", 
     RowBox[{"PrintAsCharacter", ",", "HoldFirst"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PrintAsCharacter", "[", "symbol_Symbol", "]"}], ":=", 
     RowBox[{"First", "@", 
      RowBox[{"Characters", "@", 
       RowBox[{"ToString", "[", 
        RowBox[{"Unevaluated", "[", "symbol", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"GiveSymbol", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"GiveOutputString", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetNumberOfArguments", "[", 
     RowBox[{"PrintAsCharacter", ",", "1"}], "]"}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"98eb494f-2571-4dfd-9264-d555760bff2a"],

Cell["\<\
These functions cannot be protected because we will give particular \
definitions for them below.\
\>", "Text",ExpressionUUID->"12901494-5d73-4a2b-8292-12c49d261c41"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "2.6.5. ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"T", 
    AdjustmentBox["E",
     BoxBaselineShift->0.5,
     BoxMargins->{{-0.075, -0.085}, {0, 0}}], "X"}]]],ExpressionUUID->
  "d8502830-efac-4c1d-a5ab-8d7a041db975"]
}], "Subsubsection",ExpressionUUID->"2d48be67-cc40-4eb1-b43a-328fe5a126ea"],

Cell[TextData[{
 "We have a fully dedicated package now: ",
 StyleBox["TexAct",
  FontSlant->"Italic"],
 "."
}], "Text",ExpressionUUID->"9565f2d9-7fba-4a6c-a5e4-f5f1a0164046"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.6.6. Formatting pullbacks, pushforwards, etc", \
"Subsubsection",ExpressionUUID->"be9a3951-8a64-4f7c-b3fc-786ec45a1469"],

Cell["Utilities for formatting.", \
"Text",ExpressionUUID->"f233d529-6658-454b-879c-35acb4cf24e7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$StarCharacter", "=", "\"\<*\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$PrecomposeCharacter", "=", "\"\<\[SmallCircle]\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$LinearPushCharacter", "=", "\"\<\[CenterDot]\>\""}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"959d78be-19e0-408d-b80f-148aeb97fd44"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PullBackString", "[", 
    RowBox[{"string_String", ",", "phi_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<(\\!\\(\>\"", ",", 
     RowBox[{"PrintAs", "[", "phi", "]"}], ",", "\"\<\\^\>\"", ",", 
     "$StarCharacter", ",", "string", ",", "\"\<\\))\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrecomposeString", "[", 
    RowBox[{"string_String", ",", "phi_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<(\>\"", ",", "string", ",", "$PrecomposeCharacter", ",", 
     RowBox[{"PrintAs", "[", "phi", "]"}], ",", "\"\<)\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PullBackBox", "[", 
    RowBox[{"box_", ",", "phi_"}], "]"}], ":=", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SuperscriptBox", "[", 
       RowBox[{
        RowBox[{"PrintAs", "[", "phi", "]"}], ",", "$StarCharacter"}], "]"}], 
      ",", "box"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrecomposeBox", "[", 
    RowBox[{"box_", ",", "phi_"}], "]"}], ":=", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"box", ",", "$PrecomposeCharacter", ",", 
      RowBox[{"PrintAs", "[", "phi", "]"}]}], "}"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"e9ab53bc-2778-419c-8233-6297425ae6a6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PushForwardString", "[", 
    RowBox[{"string_String", ",", "phi_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<(\\!\\(\>\"", ",", 
     RowBox[{"PrintAs", "[", "phi", "]"}], ",", "\"\<\\_\>\"", ",", 
     "$StarCharacter", ",", "string", ",", "\"\<\\))\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LinearPushString", "[", 
    RowBox[{"string_String", ",", "dphi_"}], "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"\"\<(\>\"", ",", 
     RowBox[{"PrintAs", "[", "dphi", "]"}], ",", "$LinearPushCharacter", ",", 
     "string", ",", "\"\<)\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PushForwardBox", "[", 
    RowBox[{"box_", ",", "phi_"}], "]"}], ":=", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SubscriptBox", "[", 
       RowBox[{
        RowBox[{"PrintAs", "[", "phi", "]"}], ",", "$StarCharacter"}], "]"}], 
      ",", "box"}], "}"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"4d344fe4-40b4-4780-8ad6-dffbf614a967"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.7. The Info messages: MakeDefInfo, MakeUndefInfo", \
"Subsection",ExpressionUUID->"d654d2db-4e29-49e6-a8f8-b9bad2cd7191"],

Cell["\<\
These functions and variables control the info messages printed at definition \
and undefinition times. Those messages can be deactivated globally with \
$DefInfoQ=False and/or $UndefInfoQ=False, or locally with the option \
DefInfo->False. There is not yet an UndefInfo option.\
\>", "Text",ExpressionUUID->"fe7da32f-c82e-4157-aba5-04146a25840a"],

Cell["Add a blank after any non-empty string:", \
"Text",ExpressionUUID->"27e6eb30-bc96-4899-aecd-b96422cad39a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"makespace", "[", "\"\<\>\"", "]"}], ":=", "\"\<\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"makespace", "[", "other_", "]"}], ":=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"other", ",", "\"\< \>\""}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"e1e15d88-5381-4aff-b5a0-ef5d1e3ce9d1"],

Cell["\<\
The default value of DefInfo is controlled globally with the following global \
variable:\
\>", "Text",ExpressionUUID->"fefb464d-aabe-4ce4-9a19-666353736ba7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "$DefInfoQ"}]], \
"Input",ExpressionUUID->"32d16567-a70d-4272-a952-8a38e5844a77"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"$DefInfoQ is a boolean global variable controlling \
whether the info definition messages are printed. By default it is True, but \
setting it to False deactivates all Def messages.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`$DefInfoQ\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"$DefInfoQ is a boolean global variable controlling \
whether the info definition messages are printed. By default it is True, but \
setting it to False deactivates all Def messages.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "$DefInfoQ is a boolean global variable controlling whether the info \
definition messages are printed. By default it is True, but setting it to \
False deactivates all Def messages.", "Documentation" -> None, "OwnValues" -> 
    None, "UpValues" -> None, "DownValues" -> None, "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`$DefInfoQ"|>, 
   False]]], "Output",ExpressionUUID->"ac6fe185-d94e-4ced-a022-d02f6102f5f4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "True"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"aa198a08-c339-4f92-a1b6-ea71ba5310bc"],

Cell["\<\
This function constructs all \"defininig\" messages (always three arguments, \
to avoid worrying about whether we have set up or not DefInfo already):\
\>", "Text",ExpressionUUID->"2448ab52-6e5c-44dc-80f9-fce96b4f8f88"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"MakeDefInfo", "[", 
    RowBox[{"_", ",", "_", ",", "False", ",", 
     RowBox[{"vanishQ_", ":", "False"}]}], "]"}], ":=", "Null"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeDefInfo", "[", 
    RowBox[{"command_Symbol", ",", "object_", ",", 
     RowBox[{"{", 
      RowBox[{"secondarytype_String", ",", "info_String", ",", "___"}], "}"}],
      ",", 
     RowBox[{"vanishQ_", ":", "False"}]}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{"$DefInfoQ", ",", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<** \>\"", ",", "command", ",", "\"\<: Defining \>\"", ",", 
       
       RowBox[{"makespace", "@", 
        RowBox[{"If", "[", 
         RowBox[{"vanishQ", ",", 
          RowBox[{"\"\<vanishing \>\"", "<>", "secondarytype"}], ",", 
          "secondarytype"}], "]"}]}], ",", " ", "object", ",", "\"\<. \>\"", ",",
        "info"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"22e7731c-2498-4603-9ec4-f1eb0a50b959"],

Cell["\<\
Only objects registered through a DefType function have a value for DefInfo:\
\>", "Text",ExpressionUUID->"44b52715-6b21-4642-a724-4d3aab5e5ab7"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefInfo", "[", "x_", "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"DefInfo", "::", "error1"}], 
      ",", "\"\<Object `1` has not been registered using a DefType \
function.\>\"", ",", "x"}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c58c0549-76a1-4dad-956d-d2eccd217d5e"],

Cell["\<\
Corresponding function for undefinition (False as third argument is currently \
not being used, because the UndefType functions do not have options):\
\>", "Text",ExpressionUUID->"4b9a7e49-bef3-44aa-a2d3-4b14d962cc6d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "$UndefInfoQ"}]], \
"Input",ExpressionUUID->"98017df3-59e2-468a-b7a1-edea674a79cc"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"$UndefInfoQ is a boolean global variable \
controlling whether the info undefinition messages are printed. By default it \
is True, but setting it to False deactivates all Undef messages.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`$UndefInfoQ\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"$UndefInfoQ is a boolean global variable \
controlling whether the info undefinition messages are printed. By default it \
is True, but setting it to False deactivates all Undef messages.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "$UndefInfoQ is a boolean global variable controlling whether the info \
undefinition messages are printed. By default it is True, but setting it to \
False deactivates all Undef messages.", "Documentation" -> None, "OwnValues" -> 
    None, "UpValues" -> None, "DownValues" -> None, "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`$UndefInfoQ"|>, 
   False]]], "Output",ExpressionUUID->"e86fd276-8feb-48af-a075-2dca93a52b8f"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"$UndefInfoQ", "=", "True"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c7c6cfad-ecf0-4751-aa62-336f586ad4b4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"MakeUndefInfo", "[", 
    RowBox[{"command_Symbol", ",", "object_"}], "]"}], ":=", 
   RowBox[{"MakeUndefInfo", "[", 
    RowBox[{"command", ",", "object", ",", 
     RowBox[{"DefInfo", "[", "object", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeUndefInfo", "[", 
    RowBox[{"command_Symbol", ",", "object_", ",", "False"}], "]"}], ":=", 
   "Null"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MakeUndefInfo", "[", 
    RowBox[{"command_Symbol", ",", "object_", ",", 
     RowBox[{"{", 
      RowBox[{"info_", ",", "_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{"$UndefInfoQ", ",", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<** \>\"", ",", "command", ",", "\"\<: Undefined \>\"", ",",
        "info", ",", "\"\< \>\"", ",", "object"}], "]"}]}], "]"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"cb3b5eeb-b496-40e2-b450-79de0cf2a868"],

Cell["Example:", \
"Text",ExpressionUUID->"c43e6003-7fd5-4a66-85ee-dbe0eec3e7d6"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"2bfa071f-c18c-4dc9-bf8e-41dc87fc0873"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xATP`MakeDefInfo", "[", 
  RowBox[{"DefTensor", ",", 
   RowBox[{"T", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\"\<some tensor\>\"", ",", "\"\<\>\""}], "}"}]}], 
  "]"}]], "Input",ExpressionUUID->"1e96ea72-3d46-4f39-a234-8da6f6e3de55"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"some tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"T", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "some tensor ", 
   $CellContext`T[$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"28192585-cf65-4451-a29d-9ab12c9487b3"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"a", ",", "b", ",", "T"}], 
  "]"}]], "Input",ExpressionUUID->"221fe6a0-3e08-49ad-a5c3-c1ba5964af43"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"6c83cb3d-ad77-4d5c-b5e6-ff06a97c81d0"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["3. Four simple types",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->24,ExpressionUUID->"3d30da11-0891-4872-98dc-d28b0385eabd"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     " ", "3."}], " ", "Four", " ", "simple", " ", "types"}], " ", 
  "***************************)"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"5e1aa4a4-b8b1-4a11-8d86-1953d0c24063"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TimeUsed", "[", "]"}], ",", 
   RowBox[{"SessionTime", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"TimeUsed", "[", "]"}], "/", 
    RowBox[{"SessionTime", "[", "]"}]}]}], 
  "}"}]], "Input",ExpressionUUID->"5d942096-14f5-40a5-8562-ff37c05a88f4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "10.325855`", ",", "303.092136`8.933119661846073", ",", 
   "0.03406845968588716`"}], 
  "}"}]], "Output",ExpressionUUID->"8f731098-201b-4eb3-b964-780c7614e01f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3.0. Comments", \
"Subsection",ExpressionUUID->"7bcbd4f1-dfc0-4c36-a999-6c11dae921bd"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"$ReadingVerbose", ",", 
   RowBox[{"Print", "[", "\"\<Reading section 3: Simple types.\>\"", "]"}], ",",
    "Null", ",", "Null"}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"a05491c0-e569-49e0-982a-20a793a6845e"],

Cell["\<\
Just a comment: there is no need of efficiency in the Def-functions.\
\>", "Text",ExpressionUUID->"e2e46824-3a09-42d5-86a5-04327bfd14b6"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.1. InertHeads. ERROR, Dagger and Keep", \
"Subsection",ExpressionUUID->"2dccfbb1-63a5-432d-a38e-dea7523ff162"],

Cell[CellGroupData[{

Cell["3.1.0. Comments", \
"Subsubsection",ExpressionUUID->"ded638d4-863a-4fef-8317-91ab9cbc0331"],

Cell[TextData[{
 "The concept of inert-head was designed initially in a very simple way, just \
as a slight modifier of a tensor expression, with the only property of \
representing a tensor expression whose indices and symmetries are exactly \
those of the wrapped expression. Now, mostly due to suggestions by Guillaume \
Faye, it has become clear that this concept must be expanded and clarified, \
making it far more powerful and useful.\n\nThe first issue is whether an \
inert-head must be linear or not necessarily. I think that the tensorial \
character of the expression is intimately connected with linearity. However, \
what happens if we want the inert-head to be antilinear? As pointed out by \
Guillaume, perhaps it could be even truly nonlinear. Another possibility is \
that of an inert-head that acts as a differential operator, and hence behaves \
differently on constants and scalar fields. Because it is very simple to do \
it, there is an option LinearQ->True/False at definition time to control \
that. The default will be False. Linearity is with respect to constants, and \
not with respect to scalar fields.\n\nThe second issue is whether the metric \
or the delta tensor can be contracted through the inert-head. In general this \
is not true, and another option ContractThrough controls that point. Think of \
the inert-head TracelessPart as an example.\n\nA third point, raised by David \
Trestini, is the possibility of having several tensorial arguments. \
DefInertHead will take a second argument, specifying that there are n such \
arguments, with the default being the traditional 1 .\n\nA fourth point is \
what kind of additional arguments an inert-head can have. In principle we \
could have many more arguments, with the only restriction that the \"wrapped \
expression\" is in the first argument, or first n arguments more recently. \
Other arguments can contain indexed tensors, but these tensors will not be \
seen by ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 ". (I cannot think of a single example where such a thing could be needed.) \
Then we can have arguments containing indices, and there are clear examples \
of that. Those indices could be a subset of the indices of the tensor \
expression or could be additional indices (some kind of \"extension\" of the \
expression). Those indices are simply marked with the head IndexList. We \
assume that the indices of the whole expression are the unsorted union of the \
indices of the expression(s) and the additional indices. All commands must \
ensure synchronicity of both sets of indices, in case such a thing is \
expected; that is, if indices are repeated  in the inert-head and we do some \
index replacement then those indices must be repeated at the end too."
}], "Text",ExpressionUUID->"7b025705-b318-42b4-a8ab-9fa26c63a89d"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.1.1. Definition", \
"Subsubsection",ExpressionUUID->"2fcc93f8-7c7c-4fb7-957c-977dbcb9cea6"],

Cell["\<\
A prototypical example of an inert-head is TracelessPart. We can have \
expressions like TracelessPart[ T[a,b] ] with obvious meaning. Considered as \
a tensor, TracelessPart[ T[a,b] ] inherits all symmetry properties from \
T[a,b] and has more.\
\>", "Text",ExpressionUUID->"57114ce1-3824-459d-94d7-67b982d3d078"],

Cell["\<\
Following Leo, xAct 1.1.0 accepts nonatomic inert heads, and actually \
DefInertHead does that too, which is something new in xAct. I mean, \
DefInertHead is the first command that defines something different from a \
symbol. Still, definitions are attached to the subhead (as computed by \
SubHead) of the defined object, which is always a symbol. This change \
requires deciding when to play with the whole inert head and when with its \
subhead, and I\[CloseCurlyQuote]m still not sure we got all decisions right \
yet...\
\>", "Text",ExpressionUUID->"b27d73c3-0a57-4d42-8887-c9092a1622d4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "DefInertHead"}]], \
"Input",ExpressionUUID->"a25105e5-fd5e-44a5-aeb9-d7c6f7594fd1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DefInertHead[head] defines an inert head such that \
head[expr] is treated as expr from the tensorial point of view.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`DefInertHead\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DefInertHead[head] defines an inert head such that \
head[expr] is treated as expr from the tensorial point of view.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "DefInertHead[head] defines an inert head such that head[expr] is treated \
as expr from the tensorial point of view.", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`DefInertHead"|>, 
   False]]], "Output",ExpressionUUID->"7bc4f38a-5db6-4892-a1d4-912c019d3737"]
}, Open  ]],

Cell["\<\
We do not associate dependencies, hosts or visitors to the inert head; any \
holding attribute must be introduced by hand by the user. QUESTION: Perhaps \
we should define anti-linear inert-heads. There is no predefined concept of \
complex conjugation here.\
\>", "Text",ExpressionUUID->"28d1c817-f2ad-4a63-8862-e0dce7118752"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DefInertHead", "::", "pos"}], 
   "=", "\"\<Number `1` of tensor expressions must be positive.\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInertHead", "::", "lin"}], 
   "=", "\"\<Value `1` of option LinearQ must a boolean or a list of \
booleans.\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInertHead", "::", "nlin"}], 
   "=", "\"\<A list value `1` for option LinearQ must provide `2` booleans.\>\
\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"97ad7091-68d3-41e7-b235-4d4bc1ff75fd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "DefInertHead", "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"LinearQ", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ContractThrough", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Master", "\[Rule]", "Null"}], ",", "\[IndentingNewLine]", 
     RowBox[{"PrintAs", "\[Rule]", "Identity"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ProtectNewSymbol", "\[RuleDelayed]", "$ProtectNewSymbols"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"DefInfo", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<inert head\>\"", ",", "\"\<\>\""}], "}"}]}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInertHead", "[", 
    RowBox[{"list_List", ",", "rest___"}], "]"}], ":=", 
   RowBox[{"Scan", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"DefInertHead", "[", 
       RowBox[{"#", ",", "rest"}], "]"}], "&"}], ",", "list"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInertHead", "[", 
    RowBox[{"ih_", ",", "n_Integer", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"Catch", "@", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"head", "=", 
        RowBox[{"SubHead", "[", "ih", "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "lin", ",", "cthrough", ",", "master", ",", "pa", ",", "pns", ",", 
          "info", ",", "x", ",", "y"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "lin", ",", "cthrough", ",", "master", ",", "pa", ",", "pns", ",", 
            "info"}], "}"}], "=", 
          RowBox[{"OptionValue", "[", 
           RowBox[{"{", 
            RowBox[{
            "LinearQ", ",", "ContractThrough", ",", "Master", ",", "PrintAs", 
             ",", "ProtectNewSymbol", ",", "DefInfo"}], "}"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", "Validate", " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"ValidateSymbol", "[", "head", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"ValidateSymbolInSession", "[", "head", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"n", "<", "1"}], ",", 
           RowBox[{"Throw", "@", 
            RowBox[{"Message", "[", 
             RowBox[{
              RowBox[{"DefInerHead", "::", "pos"}], ",", "n"}], "]"}]}]}], 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"!", 
             RowBox[{"BooleanQ", "[", "lin", "]"}]}], "&&", 
            RowBox[{"!", 
             RowBox[{"VectorQ", "[", 
              RowBox[{"lin", ",", "BooleanQ"}], "]"}]}]}], ",", 
           RowBox[{"Throw", "@", 
            RowBox[{"Message", "[", 
             RowBox[{
              RowBox[{"DefInertHead", "::", "lin"}], ",", "lin"}], "]"}]}]}], 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", "Register", " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"MakeDefInfo", "[", 
          RowBox[{"DefInertHead", ",", "ih", ",", "info"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"MakexTensions", "[", 
          RowBox[{
          "DefInertHead", ",", "\"\<Beginning\>\"", ",", "ih", ",", 
           "options"}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"AppendToUnevaluated", "[", 
          RowBox[{"$InertHeads", ",", "head"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"head", "/:", 
          RowBox[{"InertHeadQ", "[", "ih", "]"}], "=", "True"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"head", "/:", 
          RowBox[{"DefInfo", "[", "ih", "]"}], "=", "info"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"head", "/:", 
          RowBox[{"InertHeadArgumentCount", "[", "ih", "]"}], "=", "n"}], ";",
          "\[IndentingNewLine]", 
         RowBox[{"SetPrintAs", "[", 
          RowBox[{"ih", ",", 
           RowBox[{"PrintAsString", "[", 
            RowBox[{"ih", ",", "pa"}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"SymbolRelations", "[", 
          RowBox[{"head", ",", "master", ",", 
           RowBox[{"{", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"Metric", " ", "/", " ", "projector"}], " ", "/", " ", 
            "delta"}], " ", "contraction"}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"xTagSet", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"head", ",", 
               RowBox[{"ContractThroughQ", "[", 
                RowBox[{"ih", ",", "#"}], "]"}]}], "}"}], ",", "True"}], 
            "]"}], "&"}], "/@", 
          RowBox[{"Flatten", "[", 
           RowBox[{"{", "cthrough", "}"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"Linearity", ".", " ", "Only"}], " ", "with", " ", 
            "respect", " ", "to", " ", "constants"}], ",", " ", 
           RowBox[{"not", " ", "general", " ", "scalar", " ", "fields"}]}], 
          " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"ListQ", "[", "lin", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Length", "[", "lin", "]"}], "<", "n"}], ",", 
              RowBox[{"Throw", "@", 
               RowBox[{"Message", "[", 
                RowBox[{
                 RowBox[{"DefInertHead", "::", "nlin"}], ",", "lin", ",", 
                 "n"}], "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Length", "[", "lin", "]"}], ">", "n"}], ",", 
              RowBox[{"lin", "=", 
               RowBox[{"Take", "[", 
                RowBox[{"lin", ",", "n"}], "]"}]}]}], "]"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"n", "===", "1"}], ",", 
              RowBox[{"lin", "=", 
               RowBox[{"First", "[", "lin", "]"}]}]}], "]"}]}]}], 
          "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"n", ">", "1"}], "&&", 
            RowBox[{"BooleanQ", "[", "lin", "]"}]}], ",", 
           RowBox[{"lin", "=", 
            RowBox[{"ConstantArray", "[", 
             RowBox[{"lin", ",", "n"}], "]"}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"BooleanQ", "[", "lin", "]"}], ",", "\[IndentingNewLine]", 
           
           RowBox[{"If", "[", 
            RowBox[{"lin", ",", 
             RowBox[{"MakeLinear", "[", 
              RowBox[{"ih", ",", 
               RowBox[{"NoPattern", "[", "ih", "]"}], ",", "1", ",", "1"}], 
              "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{"List", " ", "case"}], " ", "*)"}], "\[IndentingNewLine]", 
           RowBox[{"MapIndexed", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"If", "[", 
               RowBox[{"#", ",", 
                RowBox[{"MakeLinear", "[", 
                 RowBox[{"ih", ",", 
                  RowBox[{"NoPattern", "[", "ih", "]"}], ",", 
                  RowBox[{"First", "[", "#2", "]"}], ",", "n"}], "]"}]}], 
               "]"}], "&"}], ",", "lin"}], "]"}]}], "\[IndentingNewLine]", 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"head", "/:", 
          RowBox[{"LinearQ", "[", "ih", "]"}], "=", "lin"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"n", "===", "2"}], ",", "\[IndentingNewLine]", 
           RowBox[{"head", "/:", 
            RowBox[{"InertHead2Q", "[", "head", "]"}], "=", "True"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"head", "/:", 
            RowBox[{"InertHead2Q", "[", "head", "]"}], "=", "False"}]}], 
          "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"MakexTensions", "[", 
          RowBox[{
          "DefInertHead", ",", "\"\<End\>\"", ",", "ih", ",", "options"}], 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", "Protect", " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{"pns", ",", 
           RowBox[{"Protect", "[", "head", "]"}]}], "]"}], ";"}]}], 
       "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInertHead", "[", 
    RowBox[{"ih_", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"DefInertHead", "[", 
    RowBox[{"ih", ",", "1", ",", "options"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"DefInertHead", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "DefInertHead", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"bf67d8ca-26da-44a4-82a4-c272c78e1e42"],

Cell["\<\
To avoid variable renaming on the LHS we need to send both ihL and ihR to \
MakeLinear. MakeLinear[ihL, ihR, i, n] makes linear argument i of n:\
\>", "Text",ExpressionUUID->"fbb7dd75-e1a1-4365-816d-a16f93302d8a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Fundamental", " ", "case"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"MakeLinear", "[", 
      RowBox[{"ihL_", ",", "ihR_", ",", "1", ",", "1"}], "]"}], ":=", 
     RowBox[{"(", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"ihL", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Verbatim", "[", "Times", "]"}], "[", 
           RowBox[{"l___", ",", 
            RowBox[{"x_", "?", "ConstantQ"}], ",", "r___"}], "]"}], ",", 
          "z___"}], "]"}], ":=", 
        RowBox[{"x", " ", 
         RowBox[{"ihR", "[", 
          RowBox[{
           RowBox[{"Times", "[", 
            RowBox[{"l", ",", "r"}], "]"}], ",", "z"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ihL", "[", 
         RowBox[{"sum_Plus", ",", "z___"}], "]"}], ":=", 
        RowBox[{
         RowBox[{
          RowBox[{"ihR", "[", 
           RowBox[{"#", ",", "z"}], "]"}], "&"}], "/@", "sum"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ihL", "[", 
         RowBox[{"expr_SeriesData", ",", "z___"}], "]"}], ":=", 
        RowBox[{"SeriesDataMap", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"ihR", "[", 
            RowBox[{"#", ",", "z"}], "]"}], "&"}], ",", "expr"}], "]"}]}], ";",
        "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ihL", "[", 
         RowBox[{"0", ",", "z___"}], "]"}], ":=", "0"}], ";"}], 
      "\[IndentingNewLine]", ")"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Frequent", " ", "case", " ", "of", " ", "two", " ", "arguments", " ", 
     "gets", " ", "explicit", " ", "code"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MakeLinear", "[", 
      RowBox[{"ihL_", ",", "ihR_", ",", "1", ",", "2"}], "]"}], ":=", 
     RowBox[{"(", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"ihL", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Verbatim", "[", "Times", "]"}], "[", 
           RowBox[{"l___", ",", 
            RowBox[{"x_", "?", "ConstantQ"}], ",", "r___"}], "]"}], ",", 
          "e2_", ",", "z___"}], "]"}], ":=", 
        RowBox[{"x", " ", 
         RowBox[{"ihR", "[", 
          RowBox[{
           RowBox[{"Times", "[", 
            RowBox[{"l", ",", "r"}], "]"}], ",", "e2", ",", "z"}], "]"}]}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ihL", "[", 
         RowBox[{"sum_Plus", ",", "e2_", ",", "z___"}], "]"}], ":=", 
        RowBox[{
         RowBox[{
          RowBox[{"ihR", "[", 
           RowBox[{"#", ",", "e2", ",", "z"}], "]"}], "&"}], "/@", "sum"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ihL", "[", 
         RowBox[{"expr_SeriesData", ",", "e2_", ",", "z___"}], "]"}], ":=", 
        RowBox[{"SeriesDataMap", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"ihR", "[", 
            RowBox[{"#", ",", "e2", ",", "z"}], "]"}], "&"}], ",", "expr"}], 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ihL", "[", 
         RowBox[{"0", ",", "e2_", ",", "z___"}], "]"}], ":=", "0"}], ";"}], 
      "\[IndentingNewLine]", ")"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MakeLinear", "[", 
      RowBox[{"ihL_", ",", "ihR_", ",", "2", ",", "2"}], "]"}], ":=", 
     RowBox[{"(", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"ihL", "[", 
         RowBox[{"e1_", ",", 
          RowBox[{
           RowBox[{"Verbatim", "[", "Times", "]"}], "[", 
           RowBox[{"l___", ",", 
            RowBox[{"x_", "?", "ConstantQ"}], ",", "r___"}], "]"}], ",", 
          "z___"}], "]"}], ":=", 
        RowBox[{"x", " ", 
         RowBox[{"ihR", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"Times", "[", 
            RowBox[{"l", ",", "r"}], "]"}], ",", "z"}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ihL", "[", 
         RowBox[{"e1_", ",", "sum_Plus", ",", "z___"}], "]"}], ":=", 
        RowBox[{
         RowBox[{
          RowBox[{"ihR", "[", 
           RowBox[{"e1", ",", "#", ",", "z"}], "]"}], "&"}], "/@", "sum"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ihL", "[", 
         RowBox[{"e1_", ",", "expr_SeriesData", ",", "z___"}], "]"}], ":=", 
        RowBox[{"SeriesDataMap", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"ihR", "[", 
            RowBox[{"e1", ",", "#", ",", "z"}], "]"}], "&"}], ",", "expr"}], 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ihL", "[", 
         RowBox[{"e1_", ",", "0", ",", "z___"}], "]"}], ":=", "0"}], ";"}], 
      "\[IndentingNewLine]", ")"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"General", " ", "case"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MakeLinear", "[", 
      RowBox[{"ih_", ",", "ihR_", ",", "i_", ",", "n_"}], "]"}], ":=", 
     RowBox[{"(", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"ihL", "[", 
         RowBox[{"eL___", ",", 
          RowBox[{
           RowBox[{"Verbatim", "[", "Times", "]"}], "[", 
           RowBox[{"l___", ",", 
            RowBox[{"x_", "?", "ConstantQ"}], ",", "r___"}], "]"}], ",", 
          "eR___", ",", "z___"}], "]"}], ":=", 
        RowBox[{
         RowBox[{"x", " ", 
          RowBox[{"ihR", "[", 
           RowBox[{"eL", ",", 
            RowBox[{"Times", "[", 
             RowBox[{"l", ",", "r"}], "]"}], ",", "eR", ",", "z"}], "]"}]}], "/;", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"{", "eL", "}"}], "]"}], "===", 
           RowBox[{"i", "-", "1"}]}], "&&", 
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"{", "eR", "}"}], "]"}], "===", 
           RowBox[{"n", "-", "i"}]}]}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ihL", "[", 
         RowBox[{"eL___", ",", "sum_Plus", ",", "eR___", ",", "z___"}], "]"}],
         ":=", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"ihR", "[", 
            RowBox[{"eL", ",", "#", ",", "eR", ",", "z"}], "]"}], "&"}], "/@",
           "sum"}], "/;", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"{", "eL", "}"}], "]"}], "===", 
           RowBox[{"i", "-", "1"}]}], "&&", 
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"{", "eR", "}"}], "]"}], "===", 
           RowBox[{"n", "-", "i"}]}]}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ihL", "[", 
         RowBox[{"eL___", ",", "expr_SeriesData", ",", "eR___", ",", "z___"}],
          "]"}], ":=", 
        RowBox[{
         RowBox[{"SeriesDataMap", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"ihR", "[", 
             RowBox[{"eL", ",", "#", ",", "eR", ",", "z"}], "]"}], "&"}], ",",
            "expr"}], "]"}], "/;", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"{", "eL", "}"}], "]"}], "===", 
           RowBox[{"i", "-", "1"}]}], "&&", 
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"{", "eR", "}"}], "]"}], "===", 
           RowBox[{"n", "-", "i"}]}]}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ihL", "[", 
         RowBox[{"eL___", ",", "0", ",", "eR___", ",", "z___"}], "]"}], ":=", 
        
        RowBox[{"0", "/;", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"{", "eL", "}"}], "]"}], "===", 
           RowBox[{"i", "-", "1"}]}], "&&", 
          RowBox[{
           RowBox[{"Length", "[", 
            RowBox[{"{", "eR", "}"}], "]"}], "===", 
           RowBox[{"n", "-", "i"}]}]}]}]}], ";"}], "\[IndentingNewLine]", 
      ")"}]}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2663f74e-1ac3-47d0-8f98-d3d15369ad9d"],

Cell["\<\
Now that we accept nonatomic inert-heads containing tensorial objects, we \
need this function, as pointed out by Leo. It must be configured locally by \
the user; this is just the default:\
\>", "Text",ExpressionUUID->"ed229dc7-5527-4138-bdf9-83f63210ed0e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfInertHead", "[", "ih_", "]"}], ":=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"DependenciesOfInertHead", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "DependenciesOfInertHead", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"32be1d1a-3f07-4b2b-ac61-f2165fcd4bef"],

Cell["Set defaults of this new function:", \
"Text",ExpressionUUID->"7155c662-d36d-489e-b168-fdb98043541b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InertHeadArgumentCount", "[", "ih_", "]"}], ":=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"InertHeadArgumentCount", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "InertHeadArgumentCount", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"deb5881a-bb85-493f-9e28-feae4ac0746c"],

Cell["\<\
Note once more that linearity is only with respect to constants, and not with \
respect to scalars in general.\
\>", "Text",ExpressionUUID->"fbb66d20-e40a-409c-8f16-4479b38025e0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "LinearQ"}]], \
"Input",ExpressionUUID->"24b07115-863c-4695-9257-e5a5608f2c6d"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"LinearQ is a Boolean option for DefInertHead and \
DefProduct stating that the symbol defined is linear with respect to \
constants in its tensorial argument(s). The default value is \
False.\\n\\nLinearQ[head] gives True if head has been defined as a linear \
inert-head or product, and False otherwise.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`LinearQ\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"LinearQ is a Boolean option for DefInertHead and \
DefProduct stating that the symbol defined is linear with respect to \
constants in its tensorial argument(s). The default value is \
False.\\n\\nLinearQ[head] gives True if head has been defined as a linear \
inert-head or product, and False otherwise.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "LinearQ is a Boolean option for DefInertHead and DefProduct stating that \
the symbol defined is linear with respect to constants in its tensorial \
argument(s). The default value is False.\n\nLinearQ[head] gives True if head \
has been defined as a linear inert-head or product, and False otherwise.", 
    "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "xAct`xTensor`LinearQ"|>, 
   False]]], "Output",ExpressionUUID->"3e3e4582-c11b-4ced-a7ee-b420150c2090"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"LinearQ", "[", "x_", "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"LinearQ", "::", "unknown"}], ",", "\"\<inert-head\>\"", ",", 
      "x"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"LinearQ", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "LinearQ", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"3d9ff630-a55c-4034-baa9-ed151b380464"],

Cell["\<\
This function states whether it is possible to contract a metric through the \
inert-head:\
\>", "Text",ExpressionUUID->"91ecdfad-7749-4bc2-82a0-de7d9602529b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "ContractThrough"}]], \
"Input",ExpressionUUID->"a07a617e-e32a-4274-bc90-d4808bbd9e7b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ContractThrough is an option for DefInertHead \
specifying a list of metrics and/or the delta tensor which can be contracted \
through the defined inert-head.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`ContractThrough\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ContractThrough is an option for DefInertHead \
specifying a list of metrics and/or the delta tensor which can be contracted \
through the defined inert-head.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ContractThrough is an option for DefInertHead specifying a list of \
metrics and/or the delta tensor which can be contracted through the defined \
inert-head.", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> 
    None, "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "xAct`xTensor`ContractThrough"|>, 
   False]]], "Output",ExpressionUUID->"35c466b6-56f3-42da-b3b7-2f2fb850227d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", "ContractThrough", "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"842701fd-b34a-4215-ba4b-56f6004cc2c1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "ContractThroughQ"}]], \
"Input",ExpressionUUID->"8d494eff-cce6-44c0-84e0-d0e5b4008505"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ContractThroughQ[head, metric] says whether the \
given metric can be contracted through the inert head. The default value is \
False.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`ContractThroughQ\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ContractThroughQ[head, metric] says whether the \
given metric can be contracted through the inert head. The default value is \
False.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ContractThroughQ[head, metric] says whether the given metric can be \
contracted through the inert head. The default value is False.", 
    "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "xAct`xTensor`ContractThroughQ"|>, 
   False]]], "Output",ExpressionUUID->"5e64df33-8741-4f7f-9cd8-ddb162abe780"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ContractThroughQ", "[", 
    RowBox[{"ih_", ",", "metric_"}], "]"}], ":=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"ContractThroughQ", ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "ContractThroughQ", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"8610faa7-e65c-4aba-89d8-a9a89e19e689"],

Cell["Undefinition:", \
"Text",ExpressionUUID->"87f9541f-7670-483b-a807-6f7fc177692a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "UndefInertHead"}]], \
"Input",ExpressionUUID->"adebd7ac-0e7a-449c-8ef2-56237f6949c1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"UndefInertHead[head] undefines the inert head.\"\>",
              "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`UndefInertHead\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"UndefInertHead[head] undefines the inert head.\"\>",
              "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "UndefInertHead[head] undefines the inert head.", "Documentation" -> None,
     "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`UndefInertHead"|>, 
   False]]], "Output",ExpressionUUID->"38f1fac0-9256-4718-a296-5d32017ff226"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"UndefInertHead", "[", 
    RowBox[{"list", ":", 
     RowBox[{"{", 
      RowBox[{"___", "?", "InertHeadQ"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Scan", "[", 
    RowBox[{"UndefInertHead", ",", "list"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UndefInertHead", "[", "ih_", "]"}], ":=", 
   RowBox[{"Catch", "@", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"head", "=", 
        RowBox[{"SubHead", "[", "ih", "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"servants", "=", 
          RowBox[{"ServantsOf", "[", "head", "]"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"!", 
            RowBox[{"InertHeadQ", "[", "ih", "]"}]}], ",", 
           RowBox[{"Throw", "@", 
            RowBox[{"Message", "[", 
             RowBox[{
              RowBox[{"UndefInertHead", "::", "unknown"}], 
              ",", "\"\<inert head\>\"", ",", "ih"}], "]"}]}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"CheckRemoveSymbol", "[", "head", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"MakexTensions", "[", 
          RowBox[{"UndefInertHead", ",", "\"\<Beginning\>\"", ",", "ih"}], 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"xUpSet", "[", 
          RowBox[{
           RowBox[{"ServantsOf", "[", "head", "]"}], ",", 
           RowBox[{"{", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"DropFromHosts", "[", "head", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Undef", "/@", 
          RowBox[{"Reverse", "[", "servants", "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"$InertHeads", "=", 
          RowBox[{"DeleteCases", "[", 
           RowBox[{"$InertHeads", ",", "head"}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"MakexTensions", "[", 
          RowBox[{"UndefInertHead", ",", "\"\<End\>\"", ",", "ih"}], "]"}], ";",
          "\[IndentingNewLine]", 
         RowBox[{"MakeUndefInfo", "[", 
          RowBox[{"UndefInertHead", ",", "ih"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"RemoveSymbol", "[", "head", "]"}], ";"}]}], 
       "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"UndefInertHead", ",", "1"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "UndefInertHead", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"7ec829ff-f256-4431-add7-fe0b52c3d58f"],

Cell["Examples:", \
"Text",ExpressionUUID->"7308921f-e857-416d-8157-622fe07f9011"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"fb5341e0-439c-473c-9e91-a21b43191ee7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefInertHead", "[", 
  RowBox[{"TTPart", ",", 
   RowBox[{"LinearQ", "\[Rule]", "True"}]}], 
  "]"}]], "Input",ExpressionUUID->"bd4f8993-922e-45f4-89c0-783538f630eb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefInertHead", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inert head \"\>", "\[InvisibleSpace]", "TTPart", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefInertHead, ": Defining ", 
   "inert head ", $CellContext`TTPart, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"e4b5ede6-eb65-4390-9b8a-38bdcd88614f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "TTPart"}]], "Input",ExpressionUUID->"43fa2dbb-8faf-4b1d-87a4-a89f5687a7ce"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`TTPart\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" UpValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"UpValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "UpValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"InertHeadQ", "[", "TTPart", "]"}], "^=", 
                    "True"}]},
                    {
                    RowBox[{
                    RowBox[{"DefInfo", "[", "TTPart", "]"}], "^=", 
                    RowBox[{"{", 
                    RowBox[{"\<\"inert head\"\>", ",", "\<\"\"\>"}], 
                    "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"PrintAs", "[", "TTPart", "]"}], 
                    "^=", "\<\"TTPart\"\>"}]},
                    {
                    RowBox[{
                    RowBox[{"LinearQ", "[", "TTPart", "]"}], "^=", "True"}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" DownValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"DownValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "DownValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"TTPart", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Verbatim", "[", "Times", "]"}], "[", 
                    RowBox[{"xAct`xTensor`Private`l$___", ",", 
                    RowBox[{"xAct`xTensor`Private`x$_", "?", "ConstantQ"}], ",",
                     "xAct`xTensor`Private`r$___"}], "]"}], ",", 
                    "xAct`xTensor`Private`z$___"}], "]"}], ":=", 
                    RowBox[{"xAct`xTensor`Private`x$", " ", 
                    RowBox[{"TTPart", "[", 
                    RowBox[{
                    RowBox[{
                    "xAct`xTensor`Private`l$", " ", 
                    "xAct`xTensor`Private`r$"}], ",", 
                    "xAct`xTensor`Private`z$"}], "]"}]}]}]},
                    {
                    RowBox[{
                    RowBox[{"TTPart", "[", 
                    RowBox[{
                    "xAct`xTensor`Private`sum$_Plus", ",", 
                    "xAct`xTensor`Private`z$___"}], "]"}], ":=", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"TTPart", "[", 
                    RowBox[{"#1", ",", "xAct`xTensor`Private`z$"}], "]"}], 
                    "&"}], ")"}], "/@", "xAct`xTensor`Private`sum$"}]}]},
                    {
                    RowBox[{
                    RowBox[{"TTPart", "[", 
                    RowBox[{
                    "xAct`xTensor`Private`expr$_SeriesData", ",", 
                    "xAct`xTensor`Private`z$___"}], "]"}], ":=", 
                    RowBox[{"xAct`xTensor`Private`SeriesDataMap", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TTPart", "[", 
                    RowBox[{"#1", ",", "xAct`xTensor`Private`z$"}], "]"}], 
                    "&"}], ",", "xAct`xTensor`Private`expr$"}], "]"}]}]},
                    {
                    RowBox[{
                    RowBox[{"TTPart", "[", 
                    RowBox[{"0", ",", "xAct`xTensor`Private`z___"}], "]"}], ":=",
                     "0"}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`TTPart\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`TTPart\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "Global`TTPart", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> 
    Information`InformationValueForm[
     UpValues, $CellContext`TTPart, {
      xAct`xTensor`InertHeadQ[$CellContext`TTPart] -> True, 
       xAct`xTensor`DefInfo[$CellContext`TTPart] -> {"inert head", ""}, 
       xAct`xTensor`PrintAs[$CellContext`TTPart] -> "TTPart", 
       xAct`xTensor`LinearQ[$CellContext`TTPart] -> True}], "DownValues" -> 
    Information`InformationValueForm[
     DownValues, $CellContext`TTPart, {$CellContext`TTPart[
         Verbatim[Times][
          Pattern[xAct`xTensor`Private`l$, 
           BlankNullSequence[]], 
          PatternTest[
           Pattern[xAct`xTensor`Private`x$, 
            Blank[]], xAct`xTensor`ConstantQ], 
          Pattern[xAct`xTensor`Private`r$, 
           BlankNullSequence[]]], 
         Pattern[xAct`xTensor`Private`z$, 
          BlankNullSequence[]]] :> 
       xAct`xTensor`Private`x$ $CellContext`TTPart[
         xAct`xTensor`Private`l$ xAct`xTensor`Private`r$, 
          xAct`xTensor`Private`z$], $CellContext`TTPart[
         Pattern[xAct`xTensor`Private`sum$, 
          Blank[Plus]], 
         Pattern[xAct`xTensor`Private`z$, 
          BlankNullSequence[]]] :> 
       Map[$CellContext`TTPart[#, xAct`xTensor`Private`z$]& , 
         xAct`xTensor`Private`sum$], $CellContext`TTPart[
         Pattern[xAct`xTensor`Private`expr$, 
          Blank[SeriesData]], 
         Pattern[xAct`xTensor`Private`z$, 
          BlankNullSequence[]]] :> 
       xAct`xTensor`Private`SeriesDataMap[$CellContext`TTPart[#, 
          xAct`xTensor`Private`z$]& , 
         xAct`xTensor`Private`expr$], $CellContext`TTPart[0, 
         Pattern[xAct`xTensor`Private`z, 
          BlankNullSequence[]]] :> 0}], "SubValues" -> None, "DefaultValues" -> 
    None, "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {Protected}, "FullName" -> "Global`TTPart"|>, 
   False]]], "Output",ExpressionUUID->"82fb7bd6-9fbf-4843-9fc9-a7468a52ccbd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$InertHeads"], \
"Input",ExpressionUUID->"cd8865c7-e867-43ac-a5bf-b4556ded26ea"],

Cell[BoxData[
 RowBox[{"{", "TTPart", 
  "}"}]], "Output",ExpressionUUID->"c7564ec6-2fb7-404c-8135-c7bb06080fed"]
}, Open  ]],

Cell["\<\
We have not defined yet ConstantQ, and so the integers are not taken out:\
\>", "Text",ExpressionUUID->"398cbca4-f593-45a7-8064-447f2ca78263"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TTPart", "[", 
  RowBox[{
   RowBox[{"2", "a"}], "-", 
   RowBox[{"3", "b"}]}], 
  "]"}]], "Input",ExpressionUUID->"64646040-9bc2-4211-a772-346b499f1bbe"],

Cell[BoxData[
 RowBox[{
  RowBox[{"TTPart", "[", 
   RowBox[{"2", " ", "a"}], "]"}], "+", 
  RowBox[{"TTPart", "[", 
   RowBox[{
    RowBox[{"-", "3"}], " ", "b"}], 
   "]"}]}]], "Output",ExpressionUUID->"59c81cbf-1288-4096-adb6-ad3b186ece98"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefInertHead", "[", "TTPart", 
  "]"}]], "Input",ExpressionUUID->"9b940ad5-c2b9-4ea5-8cfc-bef79e31c4dc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefInertHead", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"inert head\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TTPart"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefInertHead, ": Undefined ", "inert head", 
   " ", $CellContext`TTPart],
  Editable->
   False]], "Print",ExpressionUUID->"83bf25a3-dc1f-40e8-9b1d-3f973555b7aa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "TTPart"}]], "Input",ExpressionUUID->"e2861613-d003-4b1c-853e-1a381bcc29d6"],

Cell[BoxData[
 RowBox[{"Missing", "[", 
  RowBox[{"\<\"UnknownSymbol\"\>", ",", "\<\"TTPart\"\>"}], 
  "]"}]], "Output",ExpressionUUID->"de3ea9e6-6a5d-4306-bb75-89907f7baa5d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$InertHeads"], \
"Input",ExpressionUUID->"fa6e9844-4088-4329-a1cd-131604fe2c9a"],

Cell[BoxData[
 RowBox[{"{", 
  "}"}]], "Output",ExpressionUUID->"0f23ef2c-f7f0-4d6a-92e1-a15396f5f635"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"a", ",", "b"}], 
  "]"}]], "Input",ExpressionUUID->"318681de-ec73-4220-a815-b034fa3dd21c"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"8bb924f3-a2eb-4cab-8ea6-a0c3c27097c6"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.1.2. ERROR", \
"Subsubsection",ExpressionUUID->"a9228881-dbba-4f48-9858-ec00f65981c2"],

Cell["\<\
We define the inert-head ERROR, that will be used in the validation routines. \
Note that we do not use DefInertHead to declare it:\
\>", "Text",ExpressionUUID->"17495933-b278-497a-b242-e8693a6725d9"],

Cell[BoxData[{
 RowBox[{"SetAttributes", "[", 
  RowBox[{"ERROR", ",", "HoldFirst"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"InertHeadQ", "[", "ERROR", "]"}], "^=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LinearQ", "[", "ERROR", "]"}], "^=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInfo", "[", "ERROR", "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{"\"\<inert head\>\"", 
     ",", "\"\<Generic head to wrap expressions with errors.\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "ERROR", "]"}], "^=", 
   RowBox[{"ColorString", "[", 
    RowBox[{"\"\<ERROR\>\"", ",", 
     RowBox[{"Hue", "[", "0", "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AppendToUnevaluated", "[", 
   RowBox[{"$InertHeads", ",", "ERROR"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "ERROR", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"b8ac0571-14b2-41fe-9b9c-1d5456a100fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "ERROR"}]], "Input",ExpressionUUID->"8eb82b0a-e7e3-4202-b474-e6c7a4815d24"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ERROR[expr] is an expression where an error has \
been detected. ERROR is an inert head with a single argument.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" UpValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"UpValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "UpValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"InertHeadQ", "[", "ERROR", "]"}], "^=", "True"}]},
                    {
                    RowBox[{
                    RowBox[{"LinearQ", "[", "ERROR", "]"}], "^=", "False"}]},
                    {
                    RowBox[{
                    RowBox[{"DefInfo", "[", "ERROR", "]"}], "^=", 
                    RowBox[{"{", 
                    
                    RowBox[{"\<\"inert head\"\>", 
                    ",", "\<\"Generic head to wrap expressions with errors.\"\
\>"}], "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"PrintAs", "[", "ERROR", "]"}], 
                    "^=", "\<\"\\!\\(\\*StyleBox[\\\"ERROR\\\",FontColor->Hue[\
0.]]\\)\"\>"}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", 
                    RowBox[{"HoldFirst", ",", "Protected"}], "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`ERROR\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ERROR[expr] is an expression where an error has \
been detected. ERROR is an inert head with a single argument.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ERROR[expr] is an expression where an error has been detected. ERROR is \
an inert head with a single argument.", "Documentation" -> None, "OwnValues" -> 
    None, "UpValues" -> 
    Information`InformationValueForm[
     UpValues, xAct`xTensor`ERROR, {
      xAct`xTensor`InertHeadQ[xAct`xTensor`ERROR] -> True, 
       xAct`xTensor`LinearQ[xAct`xTensor`ERROR] -> False, 
       xAct`xTensor`DefInfo[xAct`xTensor`ERROR] -> {
        "inert head", "Generic head to wrap expressions with errors."}, 
       xAct`xTensor`PrintAs[xAct`xTensor`ERROR] -> 
       "\!\(\*StyleBox[\"ERROR\",FontColor->Hue[0.]]\)"}], "DownValues" -> 
    None, "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {HoldFirst, Protected}, "FullName" -> 
    "xAct`xTensor`ERROR"|>, 
   True]]], "Output",ExpressionUUID->"3eee59ea-961f-41d4-9e54-0352d0f46e5c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.1.3. Keep", \
"Subsubsection",ExpressionUUID->"01ce7417-d077-4ba4-b727-c6b37ad66ed7"],

Cell["\<\
Keep is just a wrapper to keep expressions protected from greedy actions, \
like derivatives that try to apply the Leibnitz rule or products that try to \
distribute over Plus.\
\>", "Text",ExpressionUUID->"d3b70ec8-6f40-49e7-af89-7a66adf0a761"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InerthHeadQ", "[", "Keep", "]"}], "^=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LinearQ", "[", "Keep", "]"}], "^=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInfo", "[", "Keep", "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{"\"\<inert head\>\"", 
     ",", "\"\<Generic head to avoid expression expansion.\>\""}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AppendToUnevaluated", "[", 
   RowBox[{"$InertHeads", ",", "Keep"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "Keep", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"5dd5280e-3159-40fd-9035-040911973b44"],

Cell["It has its own formatting, with parentheses:", \
"Text",ExpressionUUID->"285ce8cb-3f23-4a78-9f37-87ab97cdace4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MakeBoxes", "[", 
    RowBox[{
     RowBox[{"Keep", "[", 
      RowBox[{"expr_", ",", "z___"}], "]"}], ",", "StandardForm"}], "]"}], ":=", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<(\>\"", ",", 
      RowBox[{"MakeBoxes", "[", 
       RowBox[{"expr", ",", "StandardForm"}], "]"}], ",", "\"\<)\>\""}], 
     "}"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"919da261-7b47-42fa-8615-cfb4115b605e"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.1.4. Formatting", \
"Subsubsection",ExpressionUUID->"49400ccb-3667-4f9b-9440-450e75c70a94"],

Cell["\<\
Held version of InertHeadQ to avoid evaluation leaks during typesetting:\
\>", "Text",ExpressionUUID->"6fa302a5-c2d9-4b04-bbc8-e1a88fa27f73"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"HeldInertHeadQ", ",", "HoldAllComplete"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HeldInertHeadQ", "[", "expr_", "]"}], ":=", 
   RowBox[{"InertHeadQ", "[", 
    RowBox[{"Unevaluated", "[", "expr", "]"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"f473e1d4-2d55-476d-bff9-fccbfe57d8c6"],

Cell["\<\
Currently we forget about other but the first n tensorial arguments.\
\>", "Text",ExpressionUUID->"1e352831-1afe-4cf5-82c4-cc1c74857203"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$InertHeadComma", "=", "\"\<,\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xTensorFormStart", "[", "InertHead", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"MakeBoxes", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ih_", "?", "HeldInertHeadQ"}], "[", "ez__", "]"}], ",", 
       "StandardForm"}], "]"}], ":=", "\[IndentingNewLine]", 
     RowBox[{"interpretbox", "[", 
      RowBox[{
       RowBox[{"ih", "[", "ez", "]"}], ",", 
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PrintAs", "[", 
           RowBox[{"Unevaluated", "[", "ih", "]"}], "]"}], ",", "\"\<[\>\"", ",", 
          RowBox[{"RowBox", "[", 
           RowBox[{"Riffle", "[", 
            RowBox[{
             RowBox[{"Take", "[", 
              RowBox[{
               RowBox[{"Map", "[", 
                RowBox[{
                 RowBox[{"Function", "[", 
                  RowBox[{"e", ",", 
                   RowBox[{"MakeBoxes", "[", 
                    RowBox[{"e", ",", "StandardForm"}], "]"}], ",", 
                   "HoldAll"}], "]"}], ",", 
                 RowBox[{"Unevaluated", "[", 
                  RowBox[{"{", "ez", "}"}], "]"}]}], "]"}], ",", 
               RowBox[{"InertHeadArgumentCount", "[", 
                RowBox[{"Unevaluated", "[", "ih", "]"}], "]"}]}], "]"}], ",", 
             "$InertHeadComma"}], "]"}], "]"}], ",", "\"\<]\>\""}], "}"}], 
        "]"}]}], "]"}]}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xTensorFormStop", "[", "InertHead", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"MakeBoxes", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ih_", "?", "HeldInertHeadQ"}], "[", "ez__", "]"}], ",", 
       "StandardForm"}], "]"}], "=."}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"xTensorFormStart", "[", "InertHead", "]"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"c3837629-017c-4c3f-a644-5ef9a5cd8360"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"f9c8e9b9-65af-4a14-aadb-cd3ea02d20af"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ERROR", "[", "hello", 
  "]"}]], "Input",ExpressionUUID->"04836b74-9aac-4edc-b7f8-6d9aae755625"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["ERROR",
     FontColor->Hue[0.]], "[", "hello", "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`ERROR[$CellContext`hello],
  Editable->
   False]], "Output",ExpressionUUID->"2bbfbd7e-f270-40f1-b7b1-cd67d690650b"]
}, Open  ]],

Cell["Cut and paste:", \
"Text",ExpressionUUID->"5903bd5e-d992-485d-9fa4-8851b628ceef"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["ERROR",
    FontColor->RGBColor[1, 0, 0]], "[", "hello", "]"}],
  ERROR[hello],
  Editable->
   False]], "Input",ExpressionUUID->"38912494-a0a3-4758-8552-4db8a26e484b"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["ERROR",
     FontColor->Hue[0.]], "[", "hello", "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`ERROR[$CellContext`hello],
  Editable->
   False]], "Output",ExpressionUUID->"387dd3b1-3c71-4c1a-b70b-2b56fd090ddc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"9c2e6d24-624b-4774-893b-5e018e7bbd96"],

Cell["ERROR[hello]", \
"Output",ExpressionUUID->"bb3aa9e9-82a2-4a47-b7c7-3a24fbb4de56"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"xTensorFormStop", "[", "InertHead", 
  "]"}]], "Input",ExpressionUUID->"03e4f7ca-661f-49a2-bf54-6085db09b3f2"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   StyleBox["ERROR",
    FontColor->RGBColor[1, 0, 0]], "[", "hello", "]"}],
  ERROR[hello],
  Editable->
   False]], "Input",ExpressionUUID->"5c6564b5-1c53-48c4-bf73-5dd97d8c11a0"],

Cell[BoxData[
 RowBox[{"ERROR", "[", "hello", 
  "]"}]], "Output",ExpressionUUID->"20ac63f7-6f24-4e06-aee0-5ba3e643c48d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"xTensorFormStart", "[", "InertHead", 
  "]"}]], "Input",ExpressionUUID->"4c427984-fba8-47f0-b6c8-440126ce8a07"],

Cell[CellGroupData[{

Cell[BoxData["%%"], \
"Input",ExpressionUUID->"5acdb230-c9a3-42f6-afca-cee7e84ac3e1"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["ERROR",
     FontColor->Hue[0.]], "[", "hello", "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`ERROR[$CellContext`hello],
  Editable->
   False]], "Output",ExpressionUUID->"01dc58da-2b1e-45a3-a394-10cf05662d9d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", "hello", 
  "]"}]], "Input",ExpressionUUID->"170d5c99-5698-4ab1-bd2a-098a57085715"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"52a22088-8b8c-41fa-8186-47577bdab6dd"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.1.5. Dagger and DaggerQ", \
"Subsubsection",ExpressionUUID->"2fe7ea5c-bf12-49eb-becc-e4534980eb2b"],

Cell["\<\
I don't want to overload the Conjugate command, so I introduce a new \
conjugation command, called Dagger. Formally, it is an (antilinear) \
inert-head:\
\>", "Text",ExpressionUUID->"168a7deb-9ae6-4643-b81e-33c1be9d7b9b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Dagger"}]], "Input",ExpressionUUID->"c9a4b1e9-17ef-455c-a1c8-79478b16e4fe"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Dagger[expr] returns the complex conjugate of an \
expression. Dagger is an inert head. Use DaggerIndex on indices.\\n\\nDagger \
is also an option for several DefType commands, specifying how they behave \
under complex conjugation: possible values are Real, Imaginary, Complex, \
Hermitian and Antihermitian, the latter two only applying to tensors.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`Dagger\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"Dagger[expr] returns the complex conjugate of an \
expression. Dagger is an inert head. Use DaggerIndex on indices.\\n\\nDagger \
is also an option for several DefType commands, specifying how they behave \
under complex conjugation: possible values are Real, Imaginary, Complex, \
Hermitian and Antihermitian, the latter two only applying to tensors.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "Dagger[expr] returns the complex conjugate of an expression. Dagger is \
an inert head. Use DaggerIndex on indices.\n\nDagger is also an option for \
several DefType commands, specifying how they behave under complex \
conjugation: possible values are Real, Imaginary, Complex, Hermitian and \
Antihermitian, the latter two only applying to tensors.", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`Dagger"|>, 
   False]]], "Output",ExpressionUUID->"169fba61-285e-41d6-bd83-8d406bf2b207"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InertHeadQ", "[", "Dagger", "]"}], "^=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LinearQ", "[", "Dagger", "]"}], "^=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "Dagger", "]"}], "^=", "\"\<Dagger\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{"AppendToUnevaluated", "[", 
   RowBox[{"$InertHeads", ",", "Dagger"}], "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"e47ff315-3f4f-48e2-8463-b5fc198bf2cd"],

Cell["\<\
The definition on products means that we do not worry about \
angle-determinations:\
\>", "Text",ExpressionUUID->"95bccbc7-fbc5-4792-b675-87f63602fb44"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Listability", ",", " ", 
    RowBox[{"linearity", " ", "and", " ", "product", " ", "expansion"}]}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", "expr_List", "]"}], ":=", 
     RowBox[{"Dagger", "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", "expr_Equal", "]"}], ":=", 
     RowBox[{"Dagger", "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", "expr_Plus", "]"}], ":=", 
     RowBox[{"Dagger", "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", 
      RowBox[{"HoldPattern", "[", 
       RowBox[{"SeriesData", "[", 
        RowBox[{"var_", ",", "orig_", ",", "coeffs_", ",", "rest__"}], "]"}], 
       "]"}], "]"}], ":=", 
     RowBox[{"SeriesData", "[", 
      RowBox[{
       RowBox[{"Dagger", "[", "var", "]"}], ",", 
       RowBox[{"Dagger", "[", "orig", "]"}], ",", 
       RowBox[{"Dagger", "/@", "coeffs"}], ",", "rest"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", "expr_Times", "]"}], ":=", 
     RowBox[{"Dagger", "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", 
      RowBox[{"HoldPattern", "@", 
       RowBox[{"SeriesData", "[", 
        RowBox[{"par_", ",", "origin_", ",", "coeffs_", ",", "args__"}], 
        "]"}]}], "]"}], ":=", 
     RowBox[{"SeriesData", "[", 
      RowBox[{
       RowBox[{"Dagger", "[", "par", "]"}], ",", 
       RowBox[{"Dagger", "[", "origin", "]"}], ",", 
       RowBox[{"Dagger", "[", "coeffs", "]"}], ",", "args"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Constant", "-", 
     RowBox[{
     "symbols", " ", "have", " ", "an", " ", "upvalue", " ", "for", " ", 
      "Dagger"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", 
      RowBox[{"x_", "?", "NumericQ"}], "]"}], ":=", 
     RowBox[{"Conjugate", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"All", " ", "parameters", " ", "assumed", " ", "real"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", 
      RowBox[{"param_Symbol", "?", "ParameterQ"}], "]"}], ":=", "param"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Integer", " ", "powers"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", 
      RowBox[{"Power", "[", 
       RowBox[{"expr_", ",", "n_Integer"}], "]"}], "]"}], ":=", 
     RowBox[{"Power", "[", 
      RowBox[{
       RowBox[{"Dagger", "[", "expr", "]"}], ",", "n"}], "]"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c904fac2-5ed1-4b76-b34a-2808e8a24ace"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Involutivity", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Dagger", "[", 
     RowBox[{"Dagger", "[", "expr_", "]"}], "]"}], ":=", "expr"}], 
   ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"271d2a3e-3891-461e-87b5-b3f618a02245"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Action", " ", "on", " ", "composite", " ", "types"}], " ", "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", 
      RowBox[{"Scalar", "[", "expr_", "]"}], "]"}], ":=", 
     RowBox[{"Scalar", "[", 
      RowBox[{"Dagger", "[", "expr", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", 
      RowBox[{
       RowBox[{"ParamD", "[", "ps__", "]"}], "[", "expr_", "]"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Map", "[", 
       RowBox[{"Dagger", ",", 
        RowBox[{"ParamD", "[", "ps", "]"}]}], "]"}], "[", 
      RowBox[{"Dagger", "[", "expr", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", 
      RowBox[{
       RowBox[{"LieD", "[", "v_", "]"}], "[", "expr_", "]"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"LieD", "[", 
       RowBox[{"Dagger", "[", "v", "]"}], "]"}], "[", 
      RowBox[{"Dagger", "[", "expr", "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Covariant", " ", 
     RowBox[{"derivatives", ".", " ", "So"}], " ", "far", " ", "we", " ", 
     "do", " ", "not", " ", "touch", " ", "the", " ", "covd", " ", "head"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"covd_", "?", "CovDQ"}], "[", "inds__", "]"}], "[", "expr_", 
       "]"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"DaggerCovD", "[", 
       RowBox[{"covd", "[", "inds", "]"}], "]"}], "[", 
      RowBox[{"Dagger", "[", "expr", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DaggerCovD", "[", 
      RowBox[{"covd_", "[", "inds__", "]"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{"DaggerIndex", ",", 
       RowBox[{"covd", "[", "inds", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", 
      RowBox[{"CovD", "[", 
       RowBox[{"expr_", ",", "covdinds__"}], "]"}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"CovD", "[", 
        RowBox[{
         RowBox[{"Dagger", "[", "expr", "]"}], ",", "##"}], "]"}], "&"}], "@@", 
      RowBox[{"Map", "[", 
       RowBox[{"DaggerCovD", ",", 
        RowBox[{"{", "covdinds", "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Action", " ", "on", " ", 
      RowBox[{"tensors", ".", " ", "Note"}], " ", "that", " ", "this", " ", 
      "includes", " ", "Basis"}], ",", " ", 
     RowBox[{"Bracket", " ", "and", " ", "TensorDerivative"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", 
      RowBox[{
       RowBox[{"tensor_", "?", "xTensorQ"}], "[", "inds___", "]"}], "]"}], ":=", 
     RowBox[{"Apply", "[", 
      RowBox[{
       RowBox[{"Dagger", "[", "tensor", "]"}], ",", 
       RowBox[{"DaggerIndex", "@", 
        RowBox[{"IndexList", "[", "inds", "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"QUESTION", ":", " ", 
     RowBox[{
     "Is", " ", "there", " ", "any", " ", "\"\<analyticity\>\"", " ", 
      "assumption", " ", 
      RowBox[{"here", "?", " ", "Why"}], " ", "do", " ", "we", " ", "dagger", 
      " ", "sf", " ", 
      RowBox[{"itself", "?"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", 
      RowBox[{
       RowBox[{"sf_", "?", "ScalarFunctionQ"}], "[", "args___", "]"}], "]"}], 
     ":=", 
     RowBox[{"Apply", "[", 
      RowBox[{
       RowBox[{"Dagger", "[", "sf", "]"}], ",", 
       RowBox[{"Dagger", "/@", 
        RowBox[{"{", "args", "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Scalar", " ", "functions", " ", "are", " ", "assumed", " ", "real", " ", 
     "by", " ", "default"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", 
      RowBox[{"sf_", "?", "ScalarFunctionQ"}], "]"}], ":=", "sf"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Mappings", " ", "are", " ", "taken", " ", "as", " ", "real", " ", 
     "because", " ", "they", " ", "are", " ", "between", " ", "real", " ", 
     "manifolds"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Dagger", "[", 
      RowBox[{"phi_", "?", "MappingQ"}], "]"}], ":=", "phi"}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d5569e51-90e0-41c1-8d19-cc91e946691d"],

Cell["\<\
We have introduced the private function DaggerCovD to deal with the \
\"Hermitian\" spincovds with two indices.\
\>", "Text",ExpressionUUID->"36744d44-0814-48ef-868d-0e3420181f23"],

Cell["\<\
We always want to get back something meaningful for symbols and indices. For \
indices we separate the command DaggerIndex, which will throw an error in \
case something is wrong. For symbols we add this special case:\
\>", "Text",ExpressionUUID->"bc16aff5-dbb1-43ed-846b-33b17927c46e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Generic", " ", "action", " ", "on", " ", "symbols"}], " ", "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Dagger", "[", "x_Symbol", "]"}], ":=", 
    RowBox[{"Throw", "@", 
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"Dagger", "::", "unknown"}], ",", "\"\<conjugate of symbol\>\"",
        ",", "x"}], "]"}]}]}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"524541e2-94dd-4fa1-b5f7-0f78fb8fcca3"],

Cell["\<\
There is no general definition for Dagger (except for symbols). Therefore \
Dagger may stay unevaluated during the evaluation process, being always \
treated as any other inert-head.\
\>", "Text",ExpressionUUID->"63295163-9a60-4b4e-b274-e40841cc0434"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"Dagger", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "Dagger", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"b1ae3774-952c-4699-bfc1-d60b185dffbe"],

Cell["\<\
The function DaggerQ says whether an expression is complex or not:\
\>", "Text",ExpressionUUID->"33218092-e778-468c-a05b-27727b32f5a9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "DaggerQ"}]], \
"Input",ExpressionUUID->"9e023405-7cda-4925-bfd9-b75115cfa623"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DaggerQ[expr] gives True if expr is complex \
(Dagger[expr] different from expr) and False otherwise.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`DaggerQ\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DaggerQ[expr] gives True if expr is complex \
(Dagger[expr] different from expr) and False otherwise.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "DaggerQ[expr] gives True if expr is complex (Dagger[expr] different from \
expr) and False otherwise.", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> None, "DownValues" -> None, "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`DaggerQ"|>, 
   False]]], "Output",ExpressionUUID->"452bfa07-2d04-44c2-801e-7e8c158c3833"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"DaggerQ", "[", "expr_", "]"}], ":=", 
   RowBox[{"UnsameQ", "[", 
    RowBox[{"expr", ",", 
     RowBox[{"Dagger", "[", "expr", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"DaggerQ", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "DaggerQ", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"e83f6e55-1957-4ec5-80cd-22fcc53bbae1"],

Cell["\<\
Private function to arrange the dagger pairs. It is almost symmetric. The \
only difference is that the function returns symbol2.\
\>", "Text",ExpressionUUID->"17a3627f-1ffa-492e-ad02-b0f5d61e0acc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDaggerPair", "[", 
    RowBox[{"symbol1_Symbol", ",", "symbol2_Symbol"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"xUpSet", "[", 
      RowBox[{
       RowBox[{"Dagger", "[", "symbol2", "]"}], ",", "symbol1"}], "]"}], ";", 
     
     RowBox[{"xUpSet", "[", 
      RowBox[{
       RowBox[{"Dagger", "[", "symbol1", "]"}], ",", "symbol2"}], "]"}]}], 
    ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetDaggerPair", "[", 
    RowBox[{"x_", ",", "_Symbol"}], "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"Validate", "::", "nouse"}], ",", "\"\<SetDaggerPair\>\"", ",", 
      "x"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetDaggerPair", "[", 
    RowBox[{"_Symbol", ",", "x_"}], "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"Validate", "::", "nouse"}], ",", "\"\<SetDaggerPair\>\"", ",", 
      "x"}], "]"}]}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"d1d06776-79f6-4136-a333-9d5d8e5aedfb"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2. ScalarFunctions", \
"Subsection",ExpressionUUID->"9659dacf-a9e9-4606-b0d3-892b62062edf"],

Cell[CellGroupData[{

Cell["3.2.0. Comments", \
"Subsubsection",ExpressionUUID->"1fc22752-e408-46b0-b6c2-9ed226195072"],

Cell[TextData[{
 "A scalar-function is a general mapping from ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "n"], TraditionalForm]],
  ExpressionUUID->"f781f8fb-7c6a-41a4-9f9c-075580361d46"],
 " to \[DoubleStruckCapitalR], or perhaps from ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalC]", "n"], TraditionalForm]],
  ExpressionUUID->"e6e6b11d-ea3d-4359-91c0-2a85215f597f"],
 " to \[DoubleStruckCapitalC]. There is no concept yet of function from ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "n"], TraditionalForm]],
  ExpressionUUID->"f861469e-383e-40ec-80c4-fce723e2f3e1"],
 " to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[DoubleStruckCapitalR]", "m"], TraditionalForm]],
  ExpressionUUID->"8f5c8b0e-41a0-4250-b460-0f9fdd7b60dc"],
 ", and that's something which could be really useful. QUESTION: How can we \
do that? The obvious answer is using a list of scalar-functions, but it is \
not clear that we can assume that every list of objects can be treated as a \
mapping."
}], "Text",ExpressionUUID->"04e81858-8f95-4035-8689-1ee496908ff5"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2.1. Definition", \
"Subsubsection",ExpressionUUID->"47c54ed3-332b-4c68-ac1d-4ec3a755c3b7"],

Cell["\<\
We do not allow mathematical functions with arguments which are not scalars. \
Only functions on scalars can be unambiguosly differentiated, for example. \
There is no need to declare how many arguments a scalar-function has.\
\>", "Text",ExpressionUUID->"8e3bfdc7-8b87-4555-b2b9-1ebacaf36496"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "DefScalarFunction"}]], \
"Input",ExpressionUUID->"29c86d51-d494-4701-af1a-737120496312"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DefScalarFunction[f] defines f to be a scalar \
function of one or several scalar arguments.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`DefScalarFunction\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DefScalarFunction[f] defines f to be a scalar \
function of one or several scalar arguments.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "DefScalarFunction[f] defines f to be a scalar function of one or several \
scalar arguments.", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> 
    None, "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "xAct`xTensor`DefScalarFunction"|>, 
   False]]], "Output",ExpressionUUID->"37563f09-44a1-4236-b55e-6389ee215ec1"]
}, Open  ]],

Cell["\<\
We do not associate dependencies to the scalar-function. QUESTION: Why have \
we introduced the Validate option?

QUESTION: The whole issue of daggering a scalar-function is confusing. Why is \
it not enough to dagger its arguments? Why do we allow imaginary scalar \
functions for instance?\
\>", "Text",ExpressionUUID->"08418cb2-7230-4544-a949-fc737b9ebbe0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "DefScalarFunction", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Dagger", "\[Rule]", "Real"}], ",", 
     RowBox[{"Master", "\[Rule]", "Null"}], ",", 
     RowBox[{"PrintAs", "\[Rule]", "Identity"}], ",", 
     RowBox[{"ProtectNewSymbol", "\[RuleDelayed]", "$ProtectNewSymbols"}], ",", 
     RowBox[{"DefInfo", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<scalar function\>\"", ",", "\"\<\>\""}], "}"}]}], ",", 
     RowBox[{"Validate", "\[Rule]", "True"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefScalarFunction", "[", 
    RowBox[{"list_List", ",", "rest___"}], "]"}], ":=", 
   RowBox[{"Scan", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"DefScalarFunction", "[", 
       RowBox[{"#", ",", "rest"}], "]"}], "&"}], ",", "list"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefScalarFunction", "[", 
    RowBox[{"sf_", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"Catch", "@", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "dag", ",", "master", ",", "pa", ",", "pns", ",", "info", ",", "val"}],
        "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "dag", ",", "master", ",", "pa", ",", "pns", ",", "info", ",", 
          "val"}], "}"}], "=", 
        RowBox[{"OptionValue", "[", 
         RowBox[{"{", 
          RowBox[{
          "Dagger", ",", "Master", ",", "PrintAs", ",", "ProtectNewSymbol", ",",
            "DefInfo", ",", "Validate"}], "}"}], "]"}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "Checks", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"val", ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"ValidateSymbol", "[", "sf", "]"}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"ValidateSymbolInSession", "[", "sf", "]"}]}]}], "]"}], ";",
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", "Register", " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"MakeDefInfo", "[", 
        RowBox[{"DefScalarFunction", ",", "sf", ",", "info"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"MakexTensions", "[", 
        RowBox[{
        "DefScalarFunction", ",", "\"\<Beginning\>\"", ",", "sf", ",", 
         "options"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Switch", "[", 
        RowBox[{"dag", ",", "\[IndentingNewLine]", "Complex", ",", 
         RowBox[{
          RowBox[{"SetDaggerPair", "[", 
           RowBox[{"sf", ",", 
            RowBox[{"MakeDaggerSymbol", "[", "sf", "]"}]}], "]"}], ";", 
          RowBox[{"DefScalarFunction", "[", 
           RowBox[{
            RowBox[{"Dagger", "[", "sf", "]"}], ",", 
            RowBox[{"Dagger", "\[Rule]", "Conjugate"}], ",", 
            RowBox[{"Master", "\[Rule]", "sf"}], ",", "options"}], "]"}]}], ",",
          "\[IndentingNewLine]", "Conjugate", ",", "Null", ",", 
         "\[IndentingNewLine]", "Imaginary", ",", 
         RowBox[{
          RowBox[{"Dagger", "[", "sf", "]"}], "^=", 
          RowBox[{"MultiplyHead", "[", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "sf"}], "]"}]}], ",", 
         "\[IndentingNewLine]", "Real", ",", 
         RowBox[{
          RowBox[{"Dagger", "[", "sf", "]"}], "^=", "sf"}], ",", 
         "\[IndentingNewLine]", "_", ",", 
         RowBox[{"Throw", "@", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"DefScalarFunction", "::", "unknown"}], 
            ",", "\"\<Dagger value\>\"", ",", "dag"}], "]"}]}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"AppendToUnevaluated", "[", 
        RowBox[{"$ScalarFunctions", ",", "sf"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ScalarFunctionQ", "[", "sf", "]"}], "^=", "True"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"DefInfo", "[", "sf", "]"}], "^=", "info"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"SetPrintAs", "[", 
        RowBox[{"sf", ",", 
         RowBox[{"AddDaggerCharacter", "[", 
          RowBox[{
           RowBox[{"PrintAsString", "[", 
            RowBox[{"sf", ",", "pa"}], "]"}], ",", "dag"}], "]"}]}], "]"}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"SymbolRelations", "[", 
        RowBox[{"sf", ",", "master", ",", 
         RowBox[{"{", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"MakexTensions", "[", 
        RowBox[{
        "DefScalarFunction", ",", "\"\<End\>\"", ",", "sf", ",", "options"}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"pns", ",", 
         RowBox[{"Protect", "[", "sf", "]"}]}], "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"DefScalarFunction", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "DefScalarFunction", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"ba1132da-80a2-4344-b80a-37954b49ab7f"],

Cell["\<\
All functions with attribute NumericFunction are scalar-functions by default, \
except for Times and Plus, which are always treated through special linear \
rules, because they admit tensors with free indices :\
\>", "Text",ExpressionUUID->"a12729b1-9ae1-4fc2-a56d-eebe677ee723"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "ScalarFunctionQ", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarFunctionQ", "[", 
    RowBox[{"Times", "|", "Plus"}], "]"}], "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarFunctionQ", "[", 
    RowBox[{
     RowBox[{"Derivative", "[", "__Integer", "]"}], "[", "f_", "]"}], "]"}], ":=", 
   RowBox[{"ScalarFunctionQ", "[", "f", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarFunctionQ", "[", "head_Symbol", "]"}], ":=", 
   RowBox[{"MemberQ", "[", 
    RowBox[{
     RowBox[{"Attributes", "[", "head", "]"}], ",", "NumericFunction"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ScalarFunctionQ", "[", "_", "]"}], ":=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "ScalarFunctionQ", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"442ad7b3-ceb9-4c6d-9263-d5b300fc4bf8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "UndefScalarFunction"}]], \
"Input",ExpressionUUID->"c7971986-cbaa-47cd-b437-154a403e3137"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"UndefScalarFunction[f] undefines the scalar \
function f.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], \
"\<\"xAct`xTensor`UndefScalarFunction\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"UndefScalarFunction[f] undefines the scalar \
function f.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "UndefScalarFunction[f] undefines the scalar function f.", 
    "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None, 
    "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {}, "FullName" -> "xAct`xTensor`UndefScalarFunction"|>, 
   False]]], "Output",ExpressionUUID->"3550b3b8-03c6-49ba-b397-b24854423151"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"UndefScalarFunction", "[", 
    RowBox[{"list", ":", 
     RowBox[{"{", 
      RowBox[{"___", "?", "ScalarFunctionQ"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Scan", "[", 
    RowBox[{"UndefScalarFunction", ",", "list"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UndefScalarFunction", "[", "sf_", "]"}], ":=", 
   RowBox[{"Catch", "@", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"servants", "=", 
        RowBox[{"ServantsOf", "[", "sf", "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"!", 
          RowBox[{"ScalarFunctionQ", "[", "sf", "]"}]}], ",", 
         RowBox[{"Throw", "[", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"UndefScalarFunction", "::", "unknown"}], 
            ",", "\"\<scalar function\>\"", ",", "sf"}], "]"}], "]"}]}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"CheckRemoveSymbol", "[", "sf", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"MakexTensions", "[", 
        RowBox[{"UndefScalarFunction", ",", "\"\<Beginning\>\"", ",", "sf"}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"xUpSet", "[", 
        RowBox[{
         RowBox[{"ServantsOf", "[", "sf", "]"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"DropFromHosts", "[", "sf", "]"}], ";", "\[IndentingNewLine]", 
       
       RowBox[{"Undef", "/@", 
        RowBox[{"Reverse", "[", "servants", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"$ScalarFunctions", "=", 
        RowBox[{"DeleteCases", "[", 
         RowBox[{"$ScalarFunctions", ",", "sf"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"MakexTensions", "[", 
        RowBox[{"UndefScalarFunction", ",", "\"\<End\>\"", ",", "sf"}], "]"}],
        ";", "\[IndentingNewLine]", 
       RowBox[{"MakeUndefInfo", "[", 
        RowBox[{"UndefScalarFunction", ",", "sf"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"RemoveSymbol", "[", "sf", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"UndefScalarFunction", ",", "1"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "UndefScalarFunction", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"86dec043-83f8-4703-a69b-fc10ec92334c"],

Cell["\<\
It is not necessary to give head Scalar to the argument of a scalar function, \
but it does not hurt either.\
\>", "Text",ExpressionUUID->"f1912b1d-a143-491a-be16-b2855063a7d1"],

Cell["\<\
We need an additional definition to detect derivatives of scalar functions:\
\>", "Text",ExpressionUUID->"225a6fe7-b7cc-416a-bbb2-3da4d449e3b8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "ScalarFunctionQ"}]], \
"Input",ExpressionUUID->"70ea2272-e78d-4cd2-8728-385975d922ff"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ScalarFunctionQ[f] gives True if f has been defined \
as a mathematical function acting on scalars, or a derivative of one of \
those, and False otherwise.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Definitions\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Definitions", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"ScalarFunctionQ", "[", "]"}], ":=", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"ScalarFunctionQ", "::", "argx"}], "MessageName"],
                     ",", "ScalarFunctionQ", ",", "0"}], "]"}]}]},
                    {
                    RowBox[{
                    RowBox[{"ScalarFunctionQ", "[", 
                    RowBox[{"Times", "|", "Plus"}], "]"}], "=", "False"}]},
                    {
                    RowBox[{
                    RowBox[{"ScalarFunctionQ", "[", 
                    SuperscriptBox["f_", 
                    TagBox[
                    RowBox[{"(", "__Integer", ")"}],
                    Derivative],
                    MultilineFunction->None], "]"}], ":=", 
                    RowBox[{"ScalarFunctionQ", "[", "f", "]"}]}]},
                    {
                    RowBox[{
                    RowBox[{"ScalarFunctionQ", "[", "head_Symbol", "]"}], ":=", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"Attributes", "[", "head", "]"}], ",", 
                    "NumericFunction"}], "]"}]}]},
                    {
                    RowBox[{
                    RowBox[{"ScalarFunctionQ", "[", "_", "]"}], ":=", 
                    "False"}]},
                    {
                    RowBox[{
                    RowBox[{"ScalarFunctionQ", "[", 
                    RowBox[{"_", ",", "xAct`xCore`Private`x$__"}], "]"}], ":=", 
                    RowBox[{"Message", "[", 
                    RowBox[{
                    StyleBox[
                    RowBox[{"ScalarFunctionQ", "::", "argx"}], "MessageName"],
                     ",", "ScalarFunctionQ", ",", 
                    RowBox[{"1", "+", 
                    RowBox[{"Length", "[", 
                    RowBox[{"{", "xAct`xCore`Private`x$", "}"}], "]"}]}]}], 
                    "]"}]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`ScalarFunctionQ\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ScalarFunctionQ[f] gives True if f has been defined \
as a mathematical function acting on scalars, or a derivative of one of \
those, and False otherwise.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ScalarFunctionQ[f] gives True if f has been defined as a mathematical \
function acting on scalars, or a derivative of one of those, and False \
otherwise.", "Documentation" -> None, "OwnValues" -> None, "UpValues" -> None,
     "DownValues" -> 
    Information`InformationValueForm[
     DownValues, xAct`xTensor`ScalarFunctionQ, {
      xAct`xTensor`ScalarFunctionQ[] :> Message[
         MessageName[xAct`xTensor`ScalarFunctionQ, "argx"], 
         xAct`xTensor`ScalarFunctionQ, 0], xAct`xTensor`ScalarFunctionQ[
         Alternatives[Times, Plus]] -> False, xAct`xTensor`ScalarFunctionQ[
         Derivative[
          BlankSequence[Integer]][
          Pattern[xAct`xTensor`Private`f, 
           Blank[]]]] :> xAct`xTensor`ScalarFunctionQ[xAct`xTensor`Private`f],
        xAct`xTensor`ScalarFunctionQ[
         Pattern[xAct`xTensor`Private`head, 
          Blank[Symbol]]] :> MemberQ[
         Attributes[xAct`xTensor`Private`head], NumericFunction], 
       xAct`xTensor`ScalarFunctionQ[
         Blank[]] :> False, xAct`xTensor`ScalarFunctionQ[
         Blank[], 
         Pattern[xAct`xCore`Private`x$, 
          BlankSequence[]]] :> Message[
         MessageName[xAct`xTensor`ScalarFunctionQ, "argx"], 
         xAct`xTensor`ScalarFunctionQ, 1 + Length[{xAct`xCore`Private`x$}]]}],
     "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {Protected}, 
    "FullName" -> "xAct`xTensor`ScalarFunctionQ"|>, 
   False]]], "Output",ExpressionUUID->"36deaf9e-aeec-4a88-bc2f-c593fe546513"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2.2. Formatting", \
"Subsubsection",ExpressionUUID->"f09d09d9-44bc-408b-b9b5-0d9192388416"],

Cell["\<\
Held version of ScalarFunctionQ to avoid evaluation leaks during typesetting:\
\
\>", "Text",ExpressionUUID->"4ba04a0a-a7c9-4179-9a78-b23e35e5d5fc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"HeldScalarFunctionQ", ",", "HoldAllComplete"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HeldScalarFunctionQ", "[", "expr_", "]"}], ":=", 
   RowBox[{"ScalarFunctionQ", "[", 
    RowBox[{"Unevaluated", "[", "expr", "]"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"794b77d6-c93a-4987-86f9-29340b8f9b5a"],

Cell["\<\
StandardForm. We only format the symbol itself, and not its arguments. \
QUESTION: Why do we need RowBox with one argument?\
\>", "Text",ExpressionUUID->"6636295e-3474-4418-a81f-ddcd8ed45da1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorFormStart", "[", "ScalarFunction", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"MakeBoxes", "[", 
      RowBox[{
       RowBox[{"sf_Symbol", "?", "HeldScalarFunctionQ"}], ",", 
       "StandardForm"}], "]"}], ":=", 
     RowBox[{"interpretbox", "[", 
      RowBox[{"sf", ",", 
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{"PrintAs", "[", 
          RowBox[{"Unevaluated", "[", "sf", "]"}], "]"}], "}"}], "]"}]}], 
      "]"}]}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xTensorFormStop", "[", "ScalarFunction", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"MakeBoxes", "[", 
      RowBox[{
       RowBox[{"sf_Symbol", "?", "HeldScalarFunctionQ"}], ",", 
       "StandardForm"}], "]"}], "=."}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xTensorFormStart", "[", "ScalarFunction", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"262485ad-3e6f-4465-9887-623514ce1d71"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2.3. Examples", \
"Subsubsection",ExpressionUUID->"0a4065bb-1b72-4437-bcdd-3d67d5efdcca"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"9f86c02f-3f11-4fee-936b-3ce127503b20"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefScalarFunction", "[", "ff", 
  "]"}]], "Input",ExpressionUUID->"2d6ddaf7-08bd-4d5f-86e7-ba5733b991c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefScalarFunction", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"scalar function \"\>", "\[InvisibleSpace]", "ff",
    "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefScalarFunction, ": Defining ", 
   "scalar function ", $CellContext`ff, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"ac193341-6d41-4e6b-b6e1-2ec05e5e7393"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "ff"}]], "Input",ExpressionUUID->"7ca0afea-b46a-4a37-9504-368e2f883b91"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`ff\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" UpValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"UpValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "UpValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Dagger", "[", 
                    InterpretationBox[
                    StyleBox["ff",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`ff,
                    Editable->False], "]"}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    xAct`xTensor`Dagger[$CellContext`ff],
                    Editable->False], "^=", 
                    InterpretationBox[
                    StyleBox["ff",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`ff,
                    Editable->False]}]},
                    {
                    RowBox[{
                    RowBox[{"ScalarFunctionQ", "[", 
                    InterpretationBox[
                    StyleBox["ff",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`ff,
                    Editable->False], "]"}], "^=", "True"}]},
                    {
                    RowBox[{
                    RowBox[{"DefInfo", "[", 
                    InterpretationBox[
                    StyleBox["ff",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`ff,
                    Editable->False], "]"}], "^=", 
                    RowBox[{"{", 
                    RowBox[{"\<\"scalar function\"\>", ",", "\<\"\"\>"}], 
                    "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"PrintAs", "[", 
                    InterpretationBox[
                    StyleBox["ff",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`ff,
                    Editable->False], "]"}], "^=", "\<\"ff\"\>"}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`ff\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`ff\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "Global`ff", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> 
    Information`InformationValueForm[
     UpValues, $CellContext`ff, {
      xAct`xTensor`Dagger[$CellContext`ff] -> $CellContext`ff, 
       xAct`xTensor`ScalarFunctionQ[$CellContext`ff] -> True, 
       xAct`xTensor`DefInfo[$CellContext`ff] -> {"scalar function", ""}, 
       xAct`xTensor`PrintAs[$CellContext`ff] -> "ff"}], "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {Protected}, 
    "FullName" -> "Global`ff"|>, 
   False]]], "Output",ExpressionUUID->"12978b76-cda2-42d3-b59e-23726eac9c3b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScalarFunctionQ", "[", "ff", 
  "]"}]], "Input",ExpressionUUID->"012f3544-5991-4e66-b7ef-c3788871db02"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"cfc074df-4bac-4446-823f-71afe4226750"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScalarFunctionQ", "[", 
  RowBox[{"ff", "'"}], 
  "]"}]], "Input",ExpressionUUID->"070d7ab3-b26e-4c37-8afb-7f939b34f898"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"b70fc4d9-41fa-47cc-a8a4-98aa49e71c1b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefScalarFunction", "[", "ff", 
  "]"}]], "Input",ExpressionUUID->"6d770341-62bb-4897-9d87-3f375ed17cbb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefScalarFunction", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"scalar function\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["ff",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ff,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefScalarFunction, ": Undefined ", "scalar function", 
   " ", $CellContext`ff],
  Editable->
   False]], "Print",ExpressionUUID->"5f614ebc-82b3-4fe7-b107-7c4c08784e3f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "ff"}]], "Input",ExpressionUUID->"c4751934-85e9-433b-b824-df4081d96882"],

Cell[BoxData[
 RowBox[{"Missing", "[", 
  RowBox[{"\<\"UnknownSymbol\"\>", ",", "\<\"ff\"\>"}], 
  "]"}]], "Output",ExpressionUUID->"520c3d30-1b11-4a73-b9a7-0dfbf668981e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefScalarFunction", "[", 
  RowBox[{"ff", ",", 
   RowBox[{"PrintAs", "->", "\"\<F\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"5b47b7f1-8a4b-4c42-b912-b1a04d152acd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefScalarFunction", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"scalar function \"\>", "\[InvisibleSpace]", "ff",
    "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefScalarFunction, ": Defining ", 
   "scalar function ", $CellContext`ff, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"41f9f05e-dcff-4d98-b3a0-efe541280e54"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "ff"}]], "Input",ExpressionUUID->"4abb90ea-65e1-4cc2-b9c7-51d881a450b6"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`ff\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" UpValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"UpValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "UpValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Dagger", "[", 
                    InterpretationBox[
                    StyleBox["F",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`ff,
                    Editable->False], "]"}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    xAct`xTensor`Dagger[$CellContext`ff],
                    Editable->False], "^=", 
                    InterpretationBox[
                    StyleBox["F",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`ff,
                    Editable->False]}]},
                    {
                    RowBox[{
                    RowBox[{"ScalarFunctionQ", "[", 
                    InterpretationBox[
                    StyleBox["F",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`ff,
                    Editable->False], "]"}], "^=", "True"}]},
                    {
                    RowBox[{
                    RowBox[{"DefInfo", "[", 
                    InterpretationBox[
                    StyleBox["F",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`ff,
                    Editable->False], "]"}], "^=", 
                    RowBox[{"{", 
                    RowBox[{"\<\"scalar function\"\>", ",", "\<\"\"\>"}], 
                    "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"PrintAs", "[", 
                    InterpretationBox[
                    StyleBox["F",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`ff,
                    Editable->False], "]"}], "^=", "\<\"F\"\>"}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`ff\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`ff\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "Global`ff", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> 
    Information`InformationValueForm[
     UpValues, $CellContext`ff, {
      xAct`xTensor`Dagger[$CellContext`ff] -> $CellContext`ff, 
       xAct`xTensor`ScalarFunctionQ[$CellContext`ff] -> True, 
       xAct`xTensor`DefInfo[$CellContext`ff] -> {"scalar function", ""}, 
       xAct`xTensor`PrintAs[$CellContext`ff] -> "F"}], "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {Protected}, 
    "FullName" -> "Global`ff"|>, 
   False]]], "Output",ExpressionUUID->"6220eb20-c01d-406e-bd38-df9f911af31e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScalarFunctionQ", "[", 
  RowBox[{
   RowBox[{"Derivative", "[", 
    RowBox[{"0", ",", "0", ",", "1"}], "]"}], "[", "ff", "]"}], 
  "]"}]], "Input",ExpressionUUID->"69714550-2a05-4ed3-aa13-4708e72f4506"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"f86e443b-f815-46a3-a4ac-a16b897a0adf"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ff", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], 
  "]"}]], "Input",ExpressionUUID->"99f7e311-3c44-4661-bf67-1d6057c23f15"],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox["F",
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`ff,
   Editable->False], "[", 
  RowBox[{"a", ",", "b", ",", "c"}], 
  "]"}]], "Output",ExpressionUUID->"5ed44dc0-201b-47ba-aa75-1209caf8ce49"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefScalarFunction", "[", "ff", 
  "]"}]], "Input",ExpressionUUID->"49d08908-f0f5-4c87-b56d-c30eab288232"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefScalarFunction", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"scalar function\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["F",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ff,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefScalarFunction, ": Undefined ", "scalar function", 
   " ", $CellContext`ff],
  Editable->
   False]], "Print",ExpressionUUID->"261858b5-a39d-4f0b-9ae1-912bcb22f180"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Remove", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], 
  "]"}]], "Input",ExpressionUUID->"822d41b7-5ffc-4c1c-bb46-c3ea95d11b7d"],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"475dd363-4946-4736-ba3a-9f6f67def5aa"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.3. ConstantSymbols", \
"Subsection",ExpressionUUID->"0babaa63-2df8-49b2-b7de-5549f12344b4"],

Cell[CellGroupData[{

Cell["3.3.1. Definition", \
"Subsubsection",ExpressionUUID->"b178c7af-ae76-438f-a5e1-dc8c134dd2d4"],

Cell[TextData[{
 "The attribute Constant pinpoints constant symbols with respect to \
Derivative. We need something similar for the ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " derivatives. We introduce the type ConstantSymbol. Note that constants are \
real by default, but can also be complex or imaginary."
}], "Text",ExpressionUUID->"c597e5cb-c295-4f5a-9e02-05f0a98627a7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "DefConstantSymbol", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Dagger", "\[Rule]", "Real"}], ",", 
     RowBox[{"Master", "\[Rule]", "Null"}], ",", 
     RowBox[{"PrintAs", "\[Rule]", "Identity"}], ",", 
     RowBox[{"ProtectNewSymbol", "\[RuleDelayed]", "$ProtectNewSymbols"}], ",", 
     RowBox[{"DefInfo", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<constant symbol\>\"", ",", "\"\<\>\""}], "}"}]}], ",", 
     RowBox[{"Validate", "\[Rule]", "True"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"DefConstantSymbol", "[", 
    RowBox[{"list_List", ",", "rest___"}], "]"}], ":=", 
   RowBox[{"Scan", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"DefConstantSymbol", "[", 
       RowBox[{"#", ",", "rest"}], "]"}], "&"}], ",", "list"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"DefConstantSymbol", "[", 
   RowBox[{"symbol_", ",", 
    RowBox[{"options", ":", 
     RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
  RowBox[{"Catch", "@", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "dag", ",", "master", ",", "pa", ",", "pns", ",", "info", ",", "val"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "dag", ",", "master", ",", "pa", ",", "pns", ",", "info", ",", 
         "val"}], "}"}], "=", 
       RowBox[{"OptionValue", "[", 
        RowBox[{"{", 
         RowBox[{
         "Dagger", ",", "Master", ",", "PrintAs", ",", "ProtectNewSymbol", ",",
           "DefInfo", ",", "Validate"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "Checks", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"val", ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"ValidateSymbol", "[", "symbol", "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"ValidateSymbolInSession", "[", "symbol", "]"}]}]}], "]"}], ";",
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "Register", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"MakeDefInfo", "[", 
       RowBox[{"DefConstantSymbol", ",", "symbol", ",", "info"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"MakexTensions", "[", 
       RowBox[{
       "DefConstantSymbol", ",", "\"\<Beginning\>\"", ",", "symbol", ",", 
        "options"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Switch", "[", 
       RowBox[{"dag", ",", "\[IndentingNewLine]", "Complex", ",", 
        RowBox[{
         RowBox[{"SetDaggerPair", "[", 
          RowBox[{"symbol", ",", 
           RowBox[{"MakeDaggerSymbol", "[", "symbol", "]"}]}], "]"}], ";", 
         RowBox[{"DefConstantSymbol", "[", 
          RowBox[{
           RowBox[{"Dagger", "[", "symbol", "]"}], ",", 
           RowBox[{"Dagger", "\[Rule]", "Conjugate"}], ",", 
           RowBox[{"Master", "\[Rule]", "symbol"}], ",", "options"}], "]"}]}],
         ",", "\[IndentingNewLine]", "Conjugate", ",", "Null", ",", 
        "\[IndentingNewLine]", "Imaginary", ",", 
        RowBox[{
         RowBox[{"Dagger", "[", "symbol", "]"}], "^=", 
         RowBox[{"-", "symbol"}]}], ",", "\[IndentingNewLine]", "Real", ",", 
        RowBox[{
         RowBox[{"Dagger", "[", "symbol", "]"}], "^=", "symbol"}], ",", 
        "\[IndentingNewLine]", "_", ",", 
        RowBox[{"Throw", "@", 
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"DefConstantSymbol", "::", "unknown"}], 
           ",", "\"\<Dagger value\>\"", ",", "dag"}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"AppendToUnevaluated", "[", 
       RowBox[{"$ConstantSymbols", ",", "symbol"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ConstantSymbolQ", "[", "symbol", "]"}], "^=", "True"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetAttributes", "[", 
       RowBox[{"symbol", ",", "Constant"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"DefInfo", "[", "symbol", "]"}], "^=", "info"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SetPrintAs", "[", 
       RowBox[{"symbol", ",", 
        RowBox[{"AddDaggerCharacter", "[", 
         RowBox[{
          RowBox[{"PrintAsString", "[", 
           RowBox[{"symbol", ",", "pa"}], "]"}], ",", "dag"}], "]"}]}], "]"}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"SymbolRelations", "[", 
       RowBox[{"symbol", ",", "master", ",", 
        RowBox[{"{", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"MakexTensions", "[", 
       RowBox[{
       "DefConstantSymbol", ",", "\"\<End\>\"", ",", "symbol", ",", 
        "options"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{"pns", ",", 
        RowBox[{"Protect", "[", "symbol", "]"}]}], "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}]}], "\n", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"DefConstantSymbol", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "DefConstantSymbol", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"b53c0ad9-bbcd-4f77-8287-7118dfef64ae"],

Cell["Undefinition:", \
"Text",ExpressionUUID->"43444c77-8aac-4e36-8b67-e3df73500801"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"UndefConstantSymbol", "[", 
    RowBox[{"list", ":", 
     RowBox[{"{", 
      RowBox[{"___", "?", "ConstantSymbolQ"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Scan", "[", 
    RowBox[{"UndefConstantSymbol", ",", "list"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"UndefConstantSymbol", "[", "symbol_", "]"}], ":=", 
  RowBox[{"Catch", "@", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"servants", "=", 
       RowBox[{"ServantsOf", "[", "symbol", "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"ConstantSymbolQ", "[", "symbol", "]"}]}], ",", 
        RowBox[{"Throw", "@", 
         RowBox[{"Message", "[", 
          RowBox[{
           RowBox[{"UndefConstantSymbol", "::", "unknown"}], 
           ",", "\"\<constant-symbol\>\"", ",", "symbol"}], "]"}]}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"CheckRemoveSymbol", "[", "symbol", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"MakexTensions", "[", 
       RowBox[{
       "UndefConstantSymbol", ",", "\"\<Beginning\>\"", ",", "symbol"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"xUpSet", "[", 
       RowBox[{
        RowBox[{"ServantsOf", "[", "symbol", "]"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"DropFromHosts", "[", "symbol", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Undef", "/@", 
       RowBox[{"Reverse", "[", "servants", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"$ConstantSymbols", "=", 
       RowBox[{"DeleteCases", "[", 
        RowBox[{"$ConstantSymbols", ",", "symbol"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"MakexTensions", "[", 
       RowBox[{"UndefConstantSymbol", ",", "\"\<End\>\"", ",", "symbol"}], 
       "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"MakeUndefInfo", "[", 
       RowBox[{"UndefConstantSymbol", ",", "symbol"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"RemoveSymbol", "[", "symbol", "]"}], ";"}]}], 
    "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"UndefConstantSymbol", ",", "1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "UndefConstantSymbol", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"7898d48d-1fe8-4b95-89ae-c65ca6beeebb"],

Cell["Symbols with Constant attribute are constant-symbols.", \
"Text",ExpressionUUID->"6fac6c08-99b5-4efa-b759-79350849afba"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "[", "ConstantSymbolQ", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ConstantSymbolQ", "[", "x_Symbol", "]"}], ":=", 
   RowBox[{"MemberQ", "[", 
    RowBox[{
     RowBox[{"Attributes", "[", "x", "]"}], ",", "Constant"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "ConstantSymbolQ", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"4bc9e45f-095d-4765-99d2-1e3a2ae6fdc3"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.3.2. Formatting", \
"Subsubsection",ExpressionUUID->"f939773c-0561-494b-aab9-e1defa1a8521"],

Cell["\<\
Held version of ConstantSymbolQ to avoid evaluation leaks during typesetting:\
\
\>", "Text",ExpressionUUID->"79ae6543-a304-4149-8097-601ce636ca99"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"HeldConstantSymbolQ", ",", "HoldAllComplete"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HeldConstantSymbolQ", "[", "expr_", "]"}], ":=", 
   RowBox[{"ConstantSymbolQ", "[", 
    RowBox[{"Unevaluated", "[", "expr", "]"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"4ee0039d-5fef-4b3c-b2b1-8553ac1f0098"],

Cell["StandardForm:", \
"Text",ExpressionUUID->"2785c93f-7528-4cf0-bd1e-9a9f33ba3ceb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorFormStart", "[", "ConstantSymbol", "]"}], ":=", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"MakeBoxes", "[", 
      RowBox[{
       RowBox[{"x_Symbol", "?", "HeldConstantSymbolQ"}], ",", 
       "StandardForm"}], "]"}], ":=", 
     RowBox[{"interpretbox", "[", 
      RowBox[{"x", ",", 
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{"PrintAs", "[", 
          RowBox[{"Unevaluated", "[", "x", "]"}], "]"}], "}"}], "]"}]}], 
      "]"}]}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xTensorFormStop", "[", "ConstantSymbol", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"MakeBoxes", "[", 
      RowBox[{
       RowBox[{"x_Symbol", "?", "HeldConstantSymbolQ"}], ",", 
       "StandardForm"}], "]"}], "=."}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xTensorFormStart", "[", "ConstantSymbol", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"dde06a4e-0789-4bd7-b1c9-b2cdf0024638"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.3.3. Examples", \
"Subsubsection",ExpressionUUID->"ef94e43a-e71f-4a4a-ae67-12294e062883"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"be37dee9-370c-4391-9be0-8a5d4a777883"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefConstantSymbol", "[", 
  RowBox[{"Mass", ",", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<M\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"0dc70302-ccbe-47eb-a3f3-d479a9326887"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol \"\>", "\[InvisibleSpace]", 
   "Mass", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefConstantSymbol, ": Defining ", 
   "constant symbol ", $CellContext`Mass, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"628dde6e-63b7-41e1-a6f7-24cc15f55ae3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Mass"}]], "Input",ExpressionUUID->"12279bd4-1730-42bf-9a62-c0aaf3db8c72"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`Mass\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" UpValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"UpValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "UpValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Dagger", "[", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False], "]"}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    xAct`xTensor`Dagger[$CellContext`Mass],
                    Editable->False], "^=", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False]}]},
                    {
                    RowBox[{
                    RowBox[{"ConstantSymbolQ", "[", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False], "]"}], "^=", "True"}]},
                    {
                    RowBox[{
                    RowBox[{"DefInfo", "[", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False], "]"}], "^=", 
                    RowBox[{"{", 
                    RowBox[{"\<\"constant symbol\"\>", ",", "\<\"\"\>"}], 
                    "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"PrintAs", "[", 
                    InterpretationBox[
                    StyleBox["M",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Mass,
                    Editable->False], "]"}], "^=", "\<\"M\"\>"}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", 
                    RowBox[{"Constant", ",", "Protected"}], "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`Mass\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`Mass\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "Global`Mass", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> 
    Information`InformationValueForm[
     UpValues, $CellContext`Mass, {
      xAct`xTensor`Dagger[$CellContext`Mass] -> $CellContext`Mass, 
       xAct`xTensor`ConstantSymbolQ[$CellContext`Mass] -> True, 
       xAct`xTensor`DefInfo[$CellContext`Mass] -> {"constant symbol", ""}, 
       xAct`xTensor`PrintAs[$CellContext`Mass] -> "M"}], "DownValues" -> None,
     "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {Constant, Protected}, "FullName" -> "Global`Mass"|>, 
   False]]], "Output",ExpressionUUID->"c542815c-6aa8-4ba2-9b1e-7764d19af82b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["Mass"], \
"Input",ExpressionUUID->"aec18f53-5271-46c0-ac1b-b02307f46c3a"],

Cell[BoxData[
 InterpretationBox[
  StyleBox["M",
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Mass,
  Editable->
   False]], "Output",ExpressionUUID->"8987a779-f51b-44d2-a14a-792a9869ed67"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"f1534a12-339b-4de4-908c-7d62753d36de"],

Cell[BoxData[
 RowBox[{"InterpretationBox", "[", 
  RowBox[{
   RowBox[{"StyleBox", "[", 
    RowBox[{
     RowBox[{"RowBox", "[", 
      RowBox[{"{", "\<\"M\"\>", "}"}], "]"}], ",", 
     RowBox[{"AutoSpacing", "\[Rule]", "False"}], ",", 
     RowBox[{"ShowAutoStyles", "\[Rule]", "False"}]}], "]"}], ",", 
   InterpretationBox[
    StyleBox["M",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Mass,
    Editable->False], ",", 
   RowBox[{"Editable", "\[Rule]", "False"}]}], 
  "]"}]], "Output",ExpressionUUID->"24c7db3a-0918-4ef5-85ee-a5da3af086ea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%%", 
  "]"}]], "Input",ExpressionUUID->"3aeebf91-dbb7-40f0-ad8a-27ae96be9ae7"],

Cell["Mass", "Output",ExpressionUUID->"5b8c74d4-a69d-404b-831a-04b97cf655eb"]
}, Open  ]],

Cell["Cut and paste:", \
"Text",ExpressionUUID->"334e0433-ab94-4a5b-b38d-b3bd4a4bb230"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["M",
  Mass,
  Editable->
   False]], "Input",ExpressionUUID->"e78aab84-bac1-4480-b9a2-7c5a160df236"],

Cell[BoxData[
 InterpretationBox[
  StyleBox["M",
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Mass,
  Editable->
   False]], "Output",ExpressionUUID->"a8b862af-7d0e-4311-b55c-705141a1bced"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"0bcf77ad-95d2-4479-b527-3312ea2e3710"],

Cell["Mass", "Output",ExpressionUUID->"62065368-8eea-4b81-8d81-8eb02bd50e3b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"xTensorFormStop", "[", "ConstantSymbol", 
  "]"}]], "Input",ExpressionUUID->"77a7c984-e572-447c-8f50-7d81fca2d560"],

Cell[CellGroupData[{

Cell[BoxData["Mass"], \
"Input",ExpressionUUID->"1d874518-2a02-4e68-92e8-27ea6c1cb6db"],

Cell[BoxData["Mass"], \
"Output",ExpressionUUID->"cdd79cf0-82cb-44ee-b31d-3b68e4b6e624"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"xTensorFormStart", "[", "ConstantSymbol", 
  "]"}]], "Input",ExpressionUUID->"505ddcc9-e86d-4fa3-bee7-5f2a777f2a4c"],

Cell[CellGroupData[{

Cell[BoxData["Mass"], \
"Input",ExpressionUUID->"6d2277cd-30ea-4b95-837a-0c84f5afb7a4"],

Cell[BoxData[
 InterpretationBox[
  StyleBox["M",
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Mass,
  Editable->
   False]], "Output",ExpressionUUID->"95559173-a7a4-4f43-b0e3-7dc424645720"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefConstantSymbol", "[", "Mass", 
  "]"}]], "Input",ExpressionUUID->"d6e22b48-d789-4375-bdae-705ba2559ee3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["M",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Mass,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefConstantSymbol, ": Undefined ", "constant symbol", 
   " ", $CellContext`Mass],
  Editable->
   False]], "Print",ExpressionUUID->"b7a1780e-281a-4582-82af-f7acae97c6dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", 
  "Mass"}]], "Input",ExpressionUUID->"77165dd6-ad03-4be3-9230-c0254381b9fc"],

Cell[BoxData[
 RowBox[{"Missing", "[", 
  RowBox[{"\<\"UnknownSymbol\"\>", ",", "\<\"Mass\"\>"}], 
  "]"}]], "Output",ExpressionUUID->"cccd54c3-46f9-4eec-a07a-5bc053b1e36c"]
}, Open  ]],

Cell["A complex constant:", \
"Text",ExpressionUUID->"86f25f84-a5ed-4904-b388-6b725e439bdd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefConstantSymbol", "[", 
  RowBox[{"Omega", ",", 
   RowBox[{"Dagger", "\[Rule]", "Complex"}], ",", 
   RowBox[{"PrintAs", "->", "\"\<\[CapitalOmega]\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"0dec9cd2-b95e-44fd-aecf-f141642839d1"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol \"\>", "\[InvisibleSpace]", 
   "Omega", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefConstantSymbol, ": Defining ", 
   "constant symbol ", $CellContext`Omega, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"49b04f09-f051-457d-8a94-fdd00c519823"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol \"\>", "\[InvisibleSpace]", 
   "Omega\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefConstantSymbol, ": Defining ", 
   "constant symbol ", $CellContext`Omega\[Dagger], ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"4bc18649-2f8a-4f36-8307-55c8304261ad"]
}, Open  ]]
}, Open  ]],

Cell["\<\
Note that Omega and Omega\[Dagger] are related through a master-servant \
relation:\
\>", "Text",ExpressionUUID->"66064426-2673-4fef-8cb1-5bfc83b93ff7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Omega"}]], "Input",ExpressionUUID->"c6f6b126-53b0-465e-a99f-def50e2abff4"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`Omega\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" UpValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"UpValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "UpValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Dagger", "[", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega,
                    Editable->False], "]"}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    xAct`xTensor`Dagger[$CellContext`Omega],
                    Editable->False], "^=", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega\[Dagger],
                    Editable->False]}]},
                    {
                    RowBox[{
                    RowBox[{"ServantsOf", "[", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega,
                    Editable->False], "]"}], "^=", 
                    RowBox[{"{", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega\[Dagger],
                    Editable->False], "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"ConstantSymbolQ", "[", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega,
                    Editable->False], "]"}], "^=", "True"}]},
                    {
                    RowBox[{
                    RowBox[{"DefInfo", "[", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega,
                    Editable->False], "]"}], "^=", 
                    RowBox[{"{", 
                    RowBox[{"\<\"constant symbol\"\>", ",", "\<\"\"\>"}], 
                    "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"PrintAs", "[", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega,
                    Editable->False], "]"}], "^=", "\<\"\[CapitalOmega]\"\>"}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", 
                    RowBox[{"Constant", ",", "Protected"}], "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`Omega\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`Omega\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "Global`Omega", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> 
    Information`InformationValueForm[
     UpValues, $CellContext`Omega, {
      xAct`xTensor`Dagger[$CellContext`Omega] -> $CellContext`Omega\[Dagger], 
       xAct`xTensor`ServantsOf[$CellContext`Omega] -> {$CellContext`Omega\
\[Dagger]}, xAct`xTensor`ConstantSymbolQ[$CellContext`Omega] -> True, 
       xAct`xTensor`DefInfo[$CellContext`Omega] -> {"constant symbol", ""}, 
       xAct`xTensor`PrintAs[$CellContext`Omega] -> "\[CapitalOmega]"}], 
    "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {Constant, Protected}, "FullName" -> "Global`Omega"|>, 
   False]]], "Output",ExpressionUUID->"7bb50dbc-7402-4e44-b2d4-af4d982709a1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Omega\[Dagger]"}]], \
"Input",ExpressionUUID->"4f80fa97-6eeb-4c21-9d1f-00ef08714f3f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`Omega\[Dagger]\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" UpValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"UpValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "UpValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Dagger", "[", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega\[Dagger],
                    Editable->False], "]"}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    xAct`xTensor`Dagger[$CellContext`Omega\[Dagger]],
                    Editable->False], "^=", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega,
                    Editable->False]}]},
                    {
                    RowBox[{
                    RowBox[{"ConstantSymbolQ", "[", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega\[Dagger],
                    Editable->False], "]"}], "^=", "True"}]},
                    {
                    RowBox[{
                    RowBox[{"DefInfo", "[", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega\[Dagger],
                    Editable->False], "]"}], "^=", 
                    RowBox[{"{", 
                    RowBox[{"\<\"constant symbol\"\>", ",", "\<\"\"\>"}], 
                    "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"PrintAs", "[", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega\[Dagger],
                    Editable->False], "]"}], 
                    "^=", "\<\"\[CapitalOmega]\[Dagger]\"\>"}]},
                    {
                    RowBox[{
                    RowBox[{"MasterOf", "[", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]\[Dagger]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega\[Dagger],
                    Editable->False], "]"}], "^=", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega,
                    Editable->False]}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", 
                    RowBox[{"Constant", ",", "Protected"}], "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`Omega\[Dagger]\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`Omega\[Dagger]\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "Global`Omega\[Dagger]", 
    "Documentation" -> None, "OwnValues" -> None, "UpValues" -> 
    Information`InformationValueForm[
     UpValues, $CellContext`Omega\[Dagger], {
      xAct`xTensor`Dagger[$CellContext`Omega\[Dagger]] -> $CellContext`Omega, 
       xAct`xTensor`ConstantSymbolQ[$CellContext`Omega\[Dagger]] -> True, 
       xAct`xTensor`DefInfo[$CellContext`Omega\[Dagger]] -> {
        "constant symbol", ""}, 
       xAct`xTensor`PrintAs[$CellContext`Omega\[Dagger]] -> 
       "\[CapitalOmega]\[Dagger]", 
       xAct`xTensor`MasterOf[$CellContext`Omega\[Dagger]] -> \
$CellContext`Omega}], "DownValues" -> None, "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {Constant, Protected}, "FullName" -> 
    "Global`Omega\[Dagger]"|>, 
   False]]], "Output",ExpressionUUID->"1d1e118d-878c-4569-a469-9e2aacec9168"]
}, Open  ]],

Cell["Omega has a servant but not master:", \
"Text",ExpressionUUID->"b9415034-c0c3-45ce-947e-535e033e0bef"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ServantsOf", "[", "Omega", 
  "]"}]], "Input",ExpressionUUID->"eaa79b9e-c7aa-4756-9aa4-5f8a965091bb"],

Cell[BoxData[
 RowBox[{"{", 
  InterpretationBox[
   StyleBox["\[CapitalOmega]\[Dagger]",
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Omega\[Dagger],
   Editable->False], 
  "}"}]], "Output",ExpressionUUID->"3c902b2d-7a21-44e7-ab92-f2bbcf29415d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"MasterOf", "[", "Omega", 
  "]"}]], "Input",ExpressionUUID->"07d81a9c-4250-49d0-a363-5eead36cdca3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ServantsOf", "[", "Omega\[Dagger]", 
  "]"}]], "Input",ExpressionUUID->"d6f9da2a-4b2e-407d-96b2-a698d3583be2"],

Cell[BoxData[
 RowBox[{"{", 
  "}"}]], "Output",ExpressionUUID->"8b682da6-8023-4724-8f47-f8b2217acd80"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MasterOf", "[", "Omega\[Dagger]", 
  "]"}]], "Input",ExpressionUUID->"4b27611a-9ee6-4255-9db1-fb77cabd8fe2"],

Cell[BoxData[
 InterpretationBox[
  StyleBox["\[CapitalOmega]",
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Omega,
  Editable->
   False]], "Output",ExpressionUUID->"ed865faf-1b93-44c8-bc37-2fd6e39c1a2c"]
}, Open  ]],

Cell["We cannot undefine Omega\[Dagger] alone:", \
"Text",ExpressionUUID->"9d56376a-375e-49bb-bb90-075f48a7c504"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "@", 
  RowBox[{
  "UndefConstantSymbol", "[", "Omega\[Dagger]", 
   "]"}]}]], "Input",ExpressionUUID->"517d9f52-7716-4923-b72f-c475e2ee2b8c"],

Cell[BoxData[
 TemplateBox[{
  "General", "noundef", 
   "\"\\!\\(\\*RowBox[{\\\"\\\\\\\"Symbol\\\\\\\"\\\"}]\\) \
\\!\\(\\*InterpretationBox[StyleBox[RowBox[{\\\"\[CapitalOmega]\[Dagger]\\\"}]\
, Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], Omega\\\\[Dagger], \
Rule[Editable, False]]\\) cannot be undefined because \\!\\(\\*RowBox[{\\\"\\\
\\\\\"its master is still alive\\\\\\\"\\\"}]\\).\"", 2, 1031, 2, 
   19659342612246381582, "Local"},
  "MessageTemplate"]], "Message", \
"MSG",ExpressionUUID->"68b99121-f108-42ef-8403-deb6896033be"]
}, Open  ]],

Cell["Undefining Omega also undefines Omega\[Dagger] :", \
"Text",ExpressionUUID->"c7ee947a-b1b4-4d85-a95c-90238dc1606d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefConstantSymbol", "[", "Omega", 
  "]"}]], "Input",ExpressionUUID->"5f7c9e86-df61-4aba-ae3b-6851c432d25d"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]\[Dagger]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Omega\[Dagger],
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefConstantSymbol, ": Undefined ", "constant symbol", 
   " ", $CellContext`Omega\[Dagger]],
  Editable->
   False]], "Print",ExpressionUUID->"1566e87d-c053-4124-8e67-2d4afd52b530"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Omega,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefConstantSymbol, ": Undefined ", "constant symbol", 
   " ", $CellContext`Omega],
  Editable->
   False]], "Print",ExpressionUUID->"86c67eb5-b209-4acd-aa14-b62248a199a6"]
}, Open  ]]
}, Open  ]],

Cell["An imaginary constant (note that Omega\[Dagger] is never defined):", \
"Text",ExpressionUUID->"af12f185-d016-4dbe-91a5-91829ac16e87"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefConstantSymbol", "[", 
  RowBox[{"Omega", ",", 
   RowBox[{"Dagger", "\[Rule]", "Imaginary"}], ",", 
   RowBox[{"PrintAs", "->", "\"\<\[CapitalOmega]\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"91cea377-b061-4eec-9e2e-4b384fa7b443"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol \"\>", "\[InvisibleSpace]", 
   "Omega", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefConstantSymbol, ": Defining ", 
   "constant symbol ", $CellContext`Omega, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"38292d3c-93e8-4a32-9fd8-a01eb89a51dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Omega"}]], "Input",ExpressionUUID->"1fe5d5a1-9062-473f-b255-b38a104aa241"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`Omega\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" UpValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"UpValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "UpValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    InterpretationBox[
                    StyleBox[
                    RowBox[{"Dagger", "[", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega,
                    Editable->False], "]"}],
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    xAct`xTensor`Dagger[$CellContext`Omega],
                    Editable->False], "^=", 
                    RowBox[{"-", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega,
                    Editable->False]}]}]},
                    {
                    RowBox[{
                    RowBox[{"ConstantSymbolQ", "[", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega,
                    Editable->False], "]"}], "^=", "True"}]},
                    {
                    RowBox[{
                    RowBox[{"DefInfo", "[", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega,
                    Editable->False], "]"}], "^=", 
                    RowBox[{"{", 
                    RowBox[{"\<\"constant symbol\"\>", ",", "\<\"\"\>"}], 
                    "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"PrintAs", "[", 
                    InterpretationBox[
                    StyleBox["\[CapitalOmega]",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`Omega,
                    Editable->False], "]"}], "^=", "\<\"\[CapitalOmega]\"\>"}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", 
                    RowBox[{"Constant", ",", "Protected"}], "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`Omega\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`Omega\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "Global`Omega", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> 
    Information`InformationValueForm[
     UpValues, $CellContext`Omega, {
      xAct`xTensor`Dagger[$CellContext`Omega] -> -$CellContext`Omega, 
       xAct`xTensor`ConstantSymbolQ[$CellContext`Omega] -> True, 
       xAct`xTensor`DefInfo[$CellContext`Omega] -> {"constant symbol", ""}, 
       xAct`xTensor`PrintAs[$CellContext`Omega] -> "\[CapitalOmega]"}], 
    "DownValues" -> None, "SubValues" -> None, "DefaultValues" -> None, 
    "NValues" -> None, "FormatValues" -> None, "Options" -> None, 
    "Attributes" -> {Constant, Protected}, "FullName" -> "Global`Omega"|>, 
   False]]], "Output",ExpressionUUID->"c5cfba62-b076-4c57-854f-2a6a6b688f9e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "Omega", 
  "]"}]], "Input",ExpressionUUID->"6b13ee30-9534-4d9d-ab30-f3d26e2915f4"],

Cell[BoxData[
 RowBox[{"-", 
  InterpretationBox[
   StyleBox["\[CapitalOmega]",
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Omega,
   Editable->
    False]}]], "Output",ExpressionUUID->"20833245-347d-4ad7-97e0-2ca72d6adb7c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefConstantSymbol", "[", "Omega", 
  "]"}]], "Input",ExpressionUUID->"b39acf3c-42ae-4dd2-a611-d3189b412a21"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["\[CapitalOmega]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Omega,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefConstantSymbol, ": Undefined ", "constant symbol", 
   " ", $CellContext`Omega],
  Editable->
   False]], "Print",ExpressionUUID->"4d637240-89a8-45d6-ba48-882565c36640"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"47d20388-6605-4ad0-bbf7-b590cc5bdf07"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["3.4. Parameters", \
"Subsection",ExpressionUUID->"5b73f78e-1548-4a65-a8f7-d8037dce7b7b"],

Cell[CellGroupData[{

Cell["3.4.1. Definition", \
"Subsubsection",ExpressionUUID->"84a45cf6-f04a-4547-9212-b94f44d8e053"],

Cell["\<\
Typical examples of parameters are time after a 3+1 decomposition, or proper \
time of a particle. Parameters are always real, though this could be easily \
generalized:\
\>", "Text",ExpressionUUID->"9b30ed92-f621-4dea-89ab-d4cbc365e14c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "DefParameter"}]], \
"Input",ExpressionUUID->"47b058d5-9cda-4432-996b-3d0989afd675"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DefParameter[t] defines t to be a real parameter on \
which indexed objects can depend.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`DefParameter\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"DefParameter[t] defines t to be a real parameter on \
which indexed objects can depend.\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "DefParameter[t] defines t to be a real parameter on which indexed \
objects can depend.", "Documentation" -> None, "OwnValues" -> None, 
    "UpValues" -> None, "DownValues" -> None, "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`DefParameter"|>, 
   False]]], "Output",ExpressionUUID->"cf8f6e9a-19f2-47ba-b8fc-212bc4817096"]
}, Open  ]],

Cell["\<\
Note that we initialize VisitorsOf because once we have defined a parameter, \
it is expected that other objects will be defined that depend on the \
parameter (See ParametersOfTensor.) We do not expect a parameter to have \
servants.\
\>", "Text",ExpressionUUID->"b1f63ba1-e0b3-410b-b28a-2330d793134b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "DefParameter", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Master", "\[Rule]", "Null"}], ",", 
     RowBox[{"PrintAs", "\[Rule]", "Identity"}], ",", 
     RowBox[{"ProtectNewSymbol", "\[RuleDelayed]", "$ProtectNewSymbols"}], ",", 
     RowBox[{"DefInfo", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<parameter\>\"", ",", "\"\<\>\""}], "}"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefParameter", "[", 
    RowBox[{"list_List", ",", "rest___"}], "]"}], ":=", 
   RowBox[{"Scan", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"DefParameter", "[", 
       RowBox[{"#", ",", "rest"}], "]"}], "&"}], ",", "list"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefParameter", "[", 
    RowBox[{"param_", ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"Catch", "@", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"master", ",", "pa", ",", "pns", ",", "info"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"master", ",", "pa", ",", "pns", ",", "info"}], "}"}], "=", 
        RowBox[{"OptionValue", "[", 
         RowBox[{"{", 
          RowBox[{
          "Master", ",", "PrintAs", ",", "ProtectNewSymbol", ",", "DefInfo"}],
           "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"ValidateSymbol", "[", "param", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"ValidateSymbolInSession", "[", "param", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"MakeDefInfo", "[", 
        RowBox[{"DefParameter", ",", "param", ",", "info"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"MakexTensions", "[", 
        RowBox[{
        "DefParameter", ",", "\"\<Beginning\>\"", ",", "param", ",", 
         "options"}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"AppendToUnevaluated", "[", 
        RowBox[{"$Parameters", ",", "param"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"ParameterQ", "[", "param", "]"}], "^=", "True"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"DefInfo", "[", "param", "]"}], "^=", "info"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"SetPrintAs", "[", 
        RowBox[{"param", ",", 
         RowBox[{"PrintAsString", "[", 
          RowBox[{"param", ",", "pa"}], "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"SymbolRelations", "[", 
        RowBox[{"param", ",", "master", ",", 
         RowBox[{"{", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"MakexTensions", "[", 
        RowBox[{
        "DefParameter", ",", "\"\<End\>\"", ",", "param", ",", "options"}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"pns", ",", 
         RowBox[{"Protect", "[", "param", "]"}]}], "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"DefParameter", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "Infinity"}], "}"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "[", "DefParameter", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"7fabe11a-3213-4153-83fe-c564613cf6c3"],

Cell["Undefinition:", \
"Text",ExpressionUUID->"d6d59588-7daf-4f0d-b47c-0194aadbdee0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "UndefParameter"}]], \
"Input",ExpressionUUID->"d74524ed-c29e-46f1-9b76-e7aec5ded65e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"UndefParameter[t] undefines the parameter t.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"xAct`xTensor`UndefParameter\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"UndefParameter[t] undefines the parameter t.\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "UndefParameter[t] undefines the parameter t.", "Documentation" -> None, 
    "OwnValues" -> None, "UpValues" -> None, "DownValues" -> None, 
    "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {}, "FullName" -> 
    "xAct`xTensor`UndefParameter"|>, 
   False]]], "Output",ExpressionUUID->"86d35f98-de00-47fb-ab95-fcdd1b064966"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"UndefParameter", "[", 
    RowBox[{"list", ":", 
     RowBox[{"{", 
      RowBox[{"___", "?", "ParameterQ"}], "}"}]}], "]"}], ":=", 
   RowBox[{"Scan", "[", 
    RowBox[{"UndefParameter", ",", "list"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UndefParameter", "[", "param_", "]"}], ":=", 
   RowBox[{"Catch", "@", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"servants", "=", 
        RowBox[{"ServantsOf", "[", "param", "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"!", 
          RowBox[{"ParameterQ", "[", "param", "]"}]}], ",", 
         RowBox[{"Throw", "[", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"UndefParameter", "::", "unknown"}], 
            ",", "\"\<parameter\>\"", ",", "param"}], "]"}], "]"}]}], "]"}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"CheckRemoveSymbol", "[", "param", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"MakexTensions", "[", 
        RowBox[{"UndefParameter", ",", "\"\<Beginning\>\"", ",", "param"}], 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"xUpSet", "[", 
        RowBox[{
         RowBox[{"ServantsOf", "[", "param", "]"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"DropFromHosts", "[", "param", "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Undef", "/@", 
        RowBox[{"Reverse", "[", "servants", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"$Parameters", "=", 
        RowBox[{"DeleteCases", "[", 
         RowBox[{"$Parameters", ",", "param"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"MakexTensions", "[", 
        RowBox[{"UndefParameter", ",", "\"\<End\>\"", ",", "param"}], "]"}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"MakeUndefInfo", "[", 
        RowBox[{"UndefParameter", ",", "param"}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"RemoveSymbol", "[", "param", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetNumberOfArguments", "[", 
   RowBox[{"UndefParameter", ",", "1"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "[", "UndefParameter", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"822bfbdc-5c7f-4d65-803d-15afeb30fc11"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.4.2. Formatting", \
"Subsubsection",ExpressionUUID->"1eab5d4b-2cc4-455d-8afd-867b54a746be"],

Cell["\<\
Held version of ConstantSymbolQ to avoid evaluation leaks during typesetting:\
\
\>", "Text",ExpressionUUID->"1a8675fd-047e-4e20-b22c-161b11cd2f69"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"HeldParameterQ", ",", "HoldAllComplete"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HeldParameterQ", "[", "expr_", "]"}], ":=", 
   RowBox[{"ParameterQ", "[", 
    RowBox[{"Unevaluated", "[", "expr", "]"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"5ddf17c5-1627-4e5c-88fb-e514dada26ec"],

Cell["StandardForm:", \
"Text",ExpressionUUID->"7bad3dc1-0c80-4bb5-8b31-f5ea53e8e7e3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorFormStart", "[", "Parameter", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"MakeBoxes", "[", 
      RowBox[{
       RowBox[{"param_Symbol", "?", "HeldParameterQ"}], ",", "StandardForm"}],
       "]"}], ":=", 
     RowBox[{"interpretbox", "[", 
      RowBox[{"param", ",", 
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{"PrintAs", "[", 
          RowBox[{"Unevaluated", "[", "param", "]"}], "]"}], "}"}], "]"}]}], 
      "]"}]}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"xTensorFormStop", "[", "Parameter", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"MakeBoxes", "[", 
      RowBox[{
       RowBox[{"param_Symbol", "?", "HeldParameterQ"}], ",", "StandardForm"}],
       "]"}], "=."}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"xTensorFormStart", "[", "Parameter", "]"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"6b744ba3-5815-4292-a60b-4ab6c1368e7c"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.4.3. Examples", \
"Subsubsection",ExpressionUUID->"2a013223-18ad-4729-8d01-d1238295ddc0"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"497fe4c3-28c3-4d37-9d66-a530745144b4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefParameter", "[", 
  RowBox[{"time", ",", 
   RowBox[{"PrintAs", "->", "\"\<t\>\""}]}], 
  "]"}]], "Input",ExpressionUUID->"b48e6ace-c819-47fd-ac04-dbe5710af15f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefParameter", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parameter \"\>", "\[InvisibleSpace]", "time", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefParameter, ": Defining ", 
   "parameter ", $CellContext`time, ". ", ""],
  Editable->
   False]], "Print",ExpressionUUID->"81c00846-9f86-4221-9187-31e97a63f53a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "time"}]], "Input",ExpressionUUID->"418772d0-b0e7-4bf4-9c3c-7b52c33418a5"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = True, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`time\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False, False, False, False, 
                False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    
                    StyleBox["\<\" UpValue Definitions\"\>", 
                    "InformationRowLabel",
                    StripOnInput->False],
                    "\"UpValues\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "UpValues", "Tooltip"]& ], GridBox[{
                    {
                    RowBox[{
                    RowBox[{"ParameterQ", "[", 
                    InterpretationBox[
                    StyleBox["t",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`time,
                    Editable->False], "]"}], "^=", "True"}]},
                    {
                    RowBox[{
                    RowBox[{"DefInfo", "[", 
                    InterpretationBox[
                    StyleBox["t",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`time,
                    Editable->False], "]"}], "^=", 
                    RowBox[{"{", 
                    RowBox[{"\<\"parameter\"\>", ",", "\<\"\"\>"}], "}"}]}]},
                    {
                    RowBox[{
                    RowBox[{"PrintAs", "[", 
                    InterpretationBox[
                    StyleBox["t",
                    ShowAutoStyles->False,
                    AutoSpacing->False],
                    $CellContext`time,
                    Editable->False], "]"}], "^=", "\<\"t\"\>"}]}
                    },
                    DefaultBaseStyle->"Column",
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"Global`time\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->6], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}], True->
              
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"],
               ImageSizeCache->{10., {1.143798828125, 8.856201171875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\" Symbol\"\>", "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            StyleBox["\<\"Global`time\"\>", "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          GrayLevel[0.8], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> "Global`time", "Documentation" -> 
    None, "OwnValues" -> None, "UpValues" -> 
    Information`InformationValueForm[
     UpValues, $CellContext`time, {
      xAct`xTensor`ParameterQ[$CellContext`time] -> True, 
       xAct`xTensor`DefInfo[$CellContext`time] -> {"parameter", ""}, 
       xAct`xTensor`PrintAs[$CellContext`time] -> "t"}], "DownValues" -> None,
     "SubValues" -> None, "DefaultValues" -> None, "NValues" -> None, 
    "FormatValues" -> None, "Options" -> None, "Attributes" -> {Protected}, 
    "FullName" -> "Global`time"|>, 
   False]]], "Output",ExpressionUUID->"5cd6ace5-09a6-4c9d-a077-efb44f96f671"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Parameters"], \
"Input",ExpressionUUID->"586bca4c-96cd-4a7b-8029-22ec17d98b57"],

Cell[BoxData[
 RowBox[{"{", 
  InterpretationBox[
   StyleBox["t",
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`time,
   Editable->False], 
  "}"}]], "Output",ExpressionUUID->"3de410a8-0dc4-4d0c-900f-a61b3df1a960"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["time"], \
"Input",ExpressionUUID->"6beb215e-9a74-4b54-8072-30f1b151daf8"],

Cell[BoxData[
 InterpretationBox[
  StyleBox["t",
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`time,
  Editable->
   False]], "Output",ExpressionUUID->"98318d2f-d08f-4e86-b14f-f7920073a0c1"]
}, Open  ]],

Cell["Cut and paste:", \
"Text",ExpressionUUID->"21d4b387-5db4-4372-8754-ec954d334ec6"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox["t",
  time,
  Editable->
   False]], "Input",ExpressionUUID->"861ec766-8a04-401c-966d-b5435e99b41f"],

Cell[BoxData[
 InterpretationBox[
  StyleBox["t",
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`time,
  Editable->
   False]], "Output",ExpressionUUID->"55bdac5a-38e0-40e3-9d4d-f5a0aa188eca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"ff76c9e7-e177-411a-a587-a0a4f7d1df1b"],

Cell["time", "Output",ExpressionUUID->"01f0040a-f75d-46fe-8ed1-0210ba69d069"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dagger", "[", "time", 
  "]"}]], "Input",ExpressionUUID->"61a1b567-eeb2-4b86-b6b3-e42769150caf"],

Cell[BoxData[
 InterpretationBox[
  StyleBox["t",
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`time,
  Editable->
   False]], "Output",ExpressionUUID->"92faded9-b127-463b-9199-f8d806419c85"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndefParameter", "[", "time", 
  "]"}]], "Input",ExpressionUUID->"a1d36cf9-34af-4c1a-9f81-ac73355c13cd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefParameter", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"parameter\"\>", "\[InvisibleSpace]", "\<\" \"\>",
    "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["t",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`time,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefParameter, ": Undefined ", "parameter", 
   " ", $CellContext`time],
  Editable->
   False]], "Print",ExpressionUUID->"1203baa0-5f2a-42fc-ad76-b23e81d3bea4"]
}, Open  ]],

Cell["Note that even at the end we got t instead of time.", \
"Text",ExpressionUUID->"da67bcb1-66d6-418c-bdc6-1443fb8a8f5f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "time"}]], "Input",ExpressionUUID->"79668440-da9d-4c78-b896-4e3edad3f5f5"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Information", "::", "notfound"}], "MessageName"], ":", 
  " ", "\<\"Symbol \[NoBreak]\\!\\(\\\"time\\\"\\)\[NoBreak] not found. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/notfound\\\", \
ButtonNote -> \\\"Information::notfound\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"a0279710-7e6a-44e7-8d3a-bef8a7e537b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Parameters"], \
"Input",ExpressionUUID->"7858c4dd-2bb9-4154-829e-e212c9be4299"],

Cell[BoxData[
 RowBox[{"{", 
  "}"}]], "Output",ExpressionUUID->"439610d3-0cc4-48b5-b720-80c5cdae58cd"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"EndExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"5472503b-f00b-4994-b1f8-d1524d44464c"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["4. The mathematical input",
 FontColor->RGBColor[0, 0, 1]]], "Section",
 FontSize->24,ExpressionUUID->"a4dcb0d7-0319-4413-8a9c-b9db136e2435"],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "(*", "*********************************************************************)"}\
], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", " ", "4."}], " ",
     "The", " ", "mathematical", " ", "input"}], " ", 
   "**********************)"}], "\[IndentingNewLine]", 
  RowBox[{
  "(*", "*********************************************************************)"}\
]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"56218382-a19f-4e8f-a41e-216dd3d68810"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TimeUsed", "[", "]"}], ",", 
   RowBox[{"SessionTime", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"TimeUsed", "[", "]"}], "/", 
    RowBox[{"SessionTime", "[", "]"}]}]}], 
  "}"}]], "Input",ExpressionUUID->"cc6410d2-4625-4a45-86b9-b6eec0ef6673"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "6.263811`", ",", "86.429238`8.388205677572598", ",", 
   "0.07247364735166552`"}], 
  "}"}]], "Output",ExpressionUUID->"c216fba2-cbb3-4dd2-981d-5f6ca9f09c24"]
}, Open  ]],

Cell[CellGroupData[{

Cell["4.0. Comments", \
"Subsection",ExpressionUUID->"703c6285-bdb0-4b89-91f7-351d6ae1ab24"],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"$ReadingVerbose", ",", 
   RowBox[{
   "Print", "[", "\"\<Reading section 4: Mathematical input.\>\"", "]"}], ",",
    "Null", ",", "Null"}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"8ab69f5d-1f7c-4f52-885c-39e7b2ed215e"],

Cell[TextData[{
 "Structure of input and output:\n\nThe\"mathematical\" input (called \
mathinput) will be an expression of arbitrary depth containing objects as \
elements (including the particular case of the input being an object itself). \
This structure is validated with Validate. Currently an object can be a/an\n\t\
- expression with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " head Plus. Its elements (mathinput) are called terms (see ListOfTerms)\n\t\
- expression with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " head Times. Its elements (mathinput) are called factors (see \
ListOfFactors). Times is always conmutative!\n\t- expression with a head \
which has been defined as an inert-head, containing mathinput as first \
element, and possibly additional arguments\n\t- expression with a head which \
has been defined as a scalar-function, containing mathinput as (possibly \
several) scalar elements. In particular, Power. All ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " builtins with attribute NumericFunction are considered scalar-functions \
(except Plus and Times).\n\t- tensor of the form Thead[indices]. Use \
ValidateTensor\n\t- covariant derivative of the form Chead[index][ mathinput \
]. Use ValidateCovD. Several indices are also accepted in some situations \
instead of one index. Now we have introduced (though only partially) the \
notations CovD[ mathinput, cd1[i1], cd2[i2], ...]. Note also the alternative \
notation based on TensorDerivative.\n\t- Lie derivative of the form LieD[ \
mathinput ][ mathinput ]. Use ValidateLieD\n\t- expression with head Scalar \
and a single element of scalar mathinput\n\t- symbol which has been defined \
as constant-symbol or parameter\n\t- numeric quantity\n\nWith mathinput we \
denote an arbitrary expression with the structure above. Thead and Chead are \
symbols identifying the tensor or covariant derivative, respectively. \n\n\
Comments:\n\t- During execution new heads, not mentioned here, could be \
generated, but those would always be removed before returning the output.\n\t\
- indices and mathinput never appear together in a list of elements. \
Mathinput and defined symbols can appear together as in LieD[ mathinput, \
Chead ][ mathinput ] or as in mathinput + const\n\t- There is also a more \
general type of mathinput: lists, equations, rules and delayed rules. They \
must be taken into account in the input/output routines because they contain \
objects."
}], "Text",ExpressionUUID->"3102cdd1-5dac-4e1a-b357-8b6a18a60d0a"],

Cell[TextData[{
 "More recent comments. Several ideas are under development to generalize the \
",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " language:\n\t- Index-free language, at least for differential forms.\n\t- \
Non-declarative handling of tensors.\n\t- Alternative notations for \
derivatives."
}], "Text",ExpressionUUID->"297998f7-0f04-4ab2-90d2-3a0208acb482"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.1. Sums and products. Type Product", \
"Subsection",ExpressionUUID->"7e17b214-19ba-4955-98a3-e9548b2c3b9b"],

Cell[CellGroupData[{

Cell["4.1.0. Comments", \
"Subsubsection",ExpressionUUID->"48007139-beb0-44f4-a4c2-851eada70346"],

Cell[TextData[{
 "We shall use the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " builtins Plus and Times, to be able to use Simplify, Expand, etc on our \
tensor expressions."
}], "Text",ExpressionUUID->"c9fe595e-1033-462d-abdb-a3a03d6af41e"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.1.1. MathInputExpand", \
"Subsubsection",ExpressionUUID->"3c77f91f-74b1-44e7-b1c2-c44758e099d6"],

Cell["Note that Expand is threaded over lists:", \
"Text",ExpressionUUID->"cad18027-a63b-4ee4-8f16-51f369a0b0f1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"List", "[", 
   RowBox[{
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{"a1", "+", "a2"}], ")"}]}], ",", "b"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"e26c7e40-47fc-4cdf-bbd5-16d07fafc433"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "a1"}], "+", 
    RowBox[{"a", " ", "a2"}]}], ",", "b"}], 
  "}"}]], "Output",ExpressionUUID->"afc47086-6b23-4e23-b88d-b054a6882e9c"]
}, Open  ]],

Cell["and now also over rules and equations", \
"Text",ExpressionUUID->"736277ba-c9c9-4a00-92d2-b4390ef3250c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"Rule", "[", 
   RowBox[{
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{"a1", "+", "a2"}], ")"}]}], ",", "b"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"bcd67634-1ff0-4b8e-b78a-ce3616a5af5d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a", " ", "a1"}], "+", 
   RowBox[{"a", " ", "a2"}]}], "\[Rule]", 
  "b"}]], "Output",ExpressionUUID->"cfa88e37-8e23-462a-a378-5e32992e90f4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"Equal", "[", 
   RowBox[{
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{"a1", "+", "a2"}], ")"}]}], ",", "b"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"5154dc07-5020-48b7-820d-9fa3a4b5bc11"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a", " ", "a1"}], "+", 
   RowBox[{"a", " ", "a2"}]}], "\[Equal]", 
  "b"}]], "Output",ExpressionUUID->"d8af47f3-1559-4a20-898a-fb9a7aaacc55"]
}, Open  ]],

Cell["\<\
The function MathInputExpand evaluates its argument and then expands it, \
checking that no new expansion is needed again, because new definitions could \
have been used. It is a private function. It is used in ListOfTerms, \
ContractMetric, SymmetryOf and ToCanonical.\
\>", "Text",ExpressionUUID->"dd28f253-c7f2-4cbf-a962-7ec9196ab0e1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "MathInputExpand"}]], \
"Input",ExpressionUUID->"58db1238-5bd7-46c1-86a9-ce73a52a21c3"],

Cell[BoxData[
 StyleBox["\<\"xTensor`Private`MathInputExpand[expr] applies Expand to expr \
using FixedPoint.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3578672356-5338953",ExpressionUUID->"4f8fd4c4-f6a6-4ab8-bd27-\
e209b8ed2ff8"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"MathInputExpand", "[", 
    RowBox[{"Equal", "[", 
     RowBox[{"lhs_", ",", "rhs_"}], "]"}], "]"}], ":=", 
   RowBox[{"Equal", "[", 
    RowBox[{
     RowBox[{"MathInputExpand", "[", "lhs", "]"}], ",", 
     RowBox[{"MathInputExpand", "[", "rhs", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MathInputExpand", "[", 
    RowBox[{"Rule", "[", 
     RowBox[{"lhs_", ",", "rhs_"}], "]"}], "]"}], ":=", 
   RowBox[{"Rule", "[", 
    RowBox[{
     RowBox[{"MathInputExpand", "[", "lhs", "]"}], ",", 
     RowBox[{"MathInputExpand", "[", "rhs", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"MathInputExpand", "[", "expr_", "]"}], ":=", 
   RowBox[{"FixedPoint", "[", 
    RowBox[{"Expand", ",", "expr"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"57a40c49-70fd-4985-b912-12de34c666d4"],

Cell["\<\
I think we don't need parallel functions for Factor and similar. For very \
large expressions Expand is slow, and hence MathInputExpand is even slower. \
It is possible to change MathInputExpand by any other function using \
Block[{MathInputExpand=...}, ...].\
\>", "Text",ExpressionUUID->"f636fa80-4883-4570-9844-b37e1ca1c569"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.1.2. ListOfTerms", \
"Subsubsection",ExpressionUUID->"4a8be44c-19b1-4126-a906-08de3cbd0cfb"],

Cell["\<\
This function gives terms (summands). Note that mathinput is always evaluated \
and expanded before checking the head:\
\>", "Text",ExpressionUUID->"214e75f7-f4e3-48a4-9df1-f1082ea040a8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "ListOfTerms"}]], \
"Input",ExpressionUUID->"45efd7c3-91d0-4641-baa6-242b5b29b072"],

Cell[BoxData[
 StyleBox["\<\"xTensor`Private`ListOfTerms[expr] gives the list of elements \
of expr if its head is Plus and {expr} otherwise. The expression expr is \
evaluated and expanded (using Expand) before checking its head.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3578672358-5338953",ExpressionUUID->"13e214e0-7e35-421b-826e-\
a4294f3dafaa"]
}, Open  ]],

Cell["\<\
Detailed structure of a SeriesData expression (now not evaluatable):\
\>", "Text",ExpressionUUID->"966213d5-7c20-45a0-b397-6985d107b446"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ListOfTerms", "[", 
    RowBox[{"HoldPattern", "@", 
     RowBox[{"SeriesData", "[", 
      RowBox[{
      "var_", ",", "origin_", ",", "coeffs_", ",", "iord_", ",", "ford_", ",",
        "root_"}], "]"}]}], "]"}], ":=", 
   RowBox[{"Append", "[", 
    RowBox[{
     RowBox[{"coeffs", " ", 
      RowBox[{"Power", "[", 
       RowBox[{"var", ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"iord", "+", 
           RowBox[{"Range", "[", 
            RowBox[{"origin", ",", 
             RowBox[{
              RowBox[{"Length", "[", "coeffs", "]"}], "-", "1"}]}], "]"}]}], 
          ")"}], "/", "root"}]}], "]"}]}], ",", 
     RowBox[{"SeriesData", "[", 
      RowBox[{"var", ",", "origin", ",", 
       RowBox[{"0", " ", "coeffs"}], ",", "iord", ",", "ford", ",", "root"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 Evaluatable->False,ExpressionUUID->"06df8dcf-eafc-4947-8109-ff10ea0d90e3"],

Cell["\<\
With SeriesData expressions, we compute the terms of its normal form and \
append the \"series information\", so that apply Plus later will reconstruct \
the complete series.\
\>", "Text",ExpressionUUID->"32ed269c-f061-434a-a9e7-3c7dd3250d0a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ListOfTerms", "[", 
    RowBox[{"HoldPattern", "[", 
     RowBox[{"expr", ":", 
      RowBox[{"SeriesData", "[", 
       RowBox[{"var_", ",", "origin_", ",", "coeffs_", ",", "args__"}], 
       "]"}]}], "]"}], "]"}], ":=", 
   RowBox[{"Append", "[", 
    RowBox[{
     RowBox[{"ListOfTerms", "[", 
      RowBox[{"Normal", "[", "expr", "]"}], "]"}], ",", 
     RowBox[{"SeriesData", "[", 
      RowBox[{"var", ",", "origin", ",", 
       RowBox[{"0", " ", "coeffs"}], ",", "args"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ListOfTerms", "[", "expr_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Head", "[", "#", "]"}], "===", "Plus"}], ",", 
       RowBox[{"List", "@@", "#"}], ",", 
       RowBox[{"List", "@", "#"}]}], "]"}], "&"}], "@", 
    RowBox[{"MathInputExpand", "[", "expr", "]"}]}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"d972f80a-6281-4ea3-b53a-797060209b53"],

Cell["Examples:", \
"Text",ExpressionUUID->"e2b5a275-3ddb-4c8e-ab1d-7e9c2bd69ab7"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"5ed77d1f-bb7a-4011-a2e8-ddc9f26e4d0e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xATP`ListOfTerms", "[", 
  RowBox[{"T", "[", 
   RowBox[{"a", ",", "b"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"6b38fc59-4798-460d-bbb9-d765f069806a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"T", "[", 
   RowBox[{"a", ",", "b"}], "]"}], 
  "}"}]], "Output",ExpressionUUID->"cdcfb1ca-bd91-4712-8a43-90f44bcd47a4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xATP`ListOfTerms", "[", 
  RowBox[{"6", "+", 
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"c293a5ab-62ff-46f7-a1da-b7a9ec32e2bd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", 
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"96e01084-1f7a-41cf-93bc-e1b7966b2e8e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xATP`ListOfTerms", "[", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b"}], "]"}], 
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"0502b9d8-5dee-4c0c-9450-b784d7974951"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], " ", 
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"48a8a095-f91a-4b53-a0b9-647d911e15af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xATP`ListOfTerms", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}]}], "+", 
   RowBox[{"r", "[", "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"fae63374-ff12-4c04-b1ef-fa44afd86543"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"r", "[", "]"}], ",", 
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], " ", 
    RowBox[{"T", "[", 
     RowBox[{"a", ",", "b"}], "]"}]}]}], 
  "}"}]], "Output",ExpressionUUID->"985038a7-2623-47cb-b7d3-6a60fc65f60a"]
}, Open  ]],

Cell["\<\
Evaluation of the next line generates a large number of System`SeriesDump` \
symbols:\
\>", "Text",ExpressionUUID->"e9aed36c-4eb5-4c3c-a49c-a45a7d3a39ec"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xATP`ListOfTerms", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"9fec7396-1679-4fd0-ba63-332b2a68188c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "0", "]"}], ",", 
   RowBox[{"x", " ", 
    RowBox[{
     SuperscriptBox["f", "\[Prime]",
      MultilineFunction->None], "[", "0", "]"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox["x", "2"], " ", 
    RowBox[{
     SuperscriptBox["f", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "0", "]"}]}], ",", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox["x", "3"], " ", 
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", "3", ")"}],
       Derivative],
      MultilineFunction->None], "[", "0", "]"}]}], ",", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 4, 4, 1],
    Editable->False]}], 
  "}"}]], "Output",ExpressionUUID->"3cfdaacc-5a8c-4b2c-ba58-443361fb3814"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", "@@", 
  "%"}]], "Input",ExpressionUUID->"8b46fd78-63af-4cb4-b1e0-d1b04939aed3"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"f", "[", "0", "]"}], "+", 
   RowBox[{
    RowBox[{
     SuperscriptBox["f", "\[Prime]",
      MultilineFunction->None], "[", "0", "]"}], " ", "x"}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{
     SuperscriptBox["f", "\[Prime]\[Prime]",
      MultilineFunction->None], "[", "0", "]"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{
     SuperscriptBox["f", 
      TagBox[
       RowBox[{"(", "3", ")"}],
       Derivative],
      MultilineFunction->None], "[", "0", "]"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    $CellContext`f[0], 
    Derivative[1][$CellContext`f][0], Rational[1, 2] 
    Derivative[2][$CellContext`f][0], Rational[1, 6] 
    Derivative[3][$CellContext`f][0]}, 0, 4, 1],
  Editable->
   False]], "Output",ExpressionUUID->"e397c4c4-57bd-4d1a-8408-67ba722f2494"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"7d9e55b5-fe01-4a6e-85f8-8667d6099686"],

Cell["\<\
SeriesData[x, 0, {f[0], Derivative[1][f][0], Derivative[2][f][0]/2, \
Derivative[3][f][0]/6}, 0, 4, 1]\
\>", "Output",ExpressionUUID->"d3342b17-065a-4654-805e-1653ae2d5f00"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"Remove", "[", 
  RowBox[{"T", ",", "a", ",", "b", ",", "r", ",", "f", ",", "x"}], "]"}], "\n", 
 RowBox[{"EndExamples", "[", 
  "]"}]}], "Input",ExpressionUUID->"d388bc16-eae0-42ad-aea3-7ac0c183f859"]
}, Closed]],

Cell[CellGroupData[{

Cell["4.1.3. ListOfFactors", \
"Subsubsection",ExpressionUUID->"6bbb961f-1a9f-43fb-bb06-a862b747c2c1"],

Cell["\<\
This function is currently used only in InducedDecomposition and \
MonomialsOfTerm.\
\>", "Text",ExpressionUUID->"aba4d611-c75c-4b99-84fa-499de04149d9"],

Cell["\<\
An intermediate function to give factors. Note that expr is always evaluated \
and factorized before checking the head:\
\>", "Text",ExpressionUUID->"8696c182-20d6-4075-bbce-97cd351c11aa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "ListOfFactors"}]], \
"Input",ExpressionUUID->"92f45d02-6f53-47e3-b580-dfd192634cbf"],

Cell[BoxData[
 StyleBox["\<\"xTensor`Private`ListOfFactors[expr] gives the list of elements \
of expr if its head is Times and {expr} otherwise. The expression expr is \
evaluated and factored (usign Factor) before checking its head.\"\>", 
  "MSG"]], "Print", "PrintUsage",
 CellTags->
  "Info3578672360-5338953",ExpressionUUID->"c8f3ee18-9322-4252-95a4-\
1ef31019c9e4"]
}, Open  ]],

Cell["\<\
We do not factor terms in a series, because it is not clear how to handle the \
O terms.\
\>", "Text",ExpressionUUID->"da3b644f-f29b-48af-924f-7e3e5fbae6a1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ListOfFactors", "[", "expr_", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Head", "[", "#", "]"}], "===", "Times"}], ",", 
       RowBox[{"List", "@@", "#"}], ",", 
       RowBox[{"List", "@", "#"}]}], "]"}], "&"}], "@", 
    RowBox[{"Factor", "[", "expr", "]"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"dff2237e-1d00-4d3e-908c-400635f24002"],

Cell["Examples:", \
"Text",ExpressionUUID->"aad8e22d-c110-4bdd-b417-48f7ba3e4fb8"],

Cell[BoxData[
 RowBox[{"BeginExamples", "[", 
  "]"}]], "Input",ExpressionUUID->"6d1e57c2-07f0-4bad-94c5-35a0c7ddc78f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xATP`ListOfFactors", "[", 
  RowBox[{"T", "[", 
   RowBox[{"a", ",", "b"}], "]"}], 
  "]"}]], "Input",ExpressionUUID->"3a0a410d-651d-43be-8b8c-7c0ceeee7763"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"T", "[", 
   RowBox[{"a", ",", "b"}], "]"}], 
  "}"}]], "Output",ExpressionUUID->"bc6e50a7-a132-4d32-b020-04f68d14a11a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xATP`ListOfFactors", "[", 
  RowBox[{"6", 
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}], 
  "]"}]], "Input",ExpressionUUID->"40157e92-bc0e-44f2-9df4-a98f3c14ef26"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", 
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"4238af0c-5286-4f44-add0-53064f72a6ba"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xATP`ListOfFactors", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"F", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}]}]}], 
  "]"}]], "Input",ExpressionUUID->"831326d1-d76c-4b36-9a72-7f307ccb09b2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"F", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], "+", 
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}]}], ",", 
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"e3ad2b04-215b-4d2e-b6f0-153c0499240e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xATP`ListOfFactors", "[", 
  RowBox[{"6", "+", 
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"a