Notebook[{
Cell[BoxData["Exit"], "Input"],

Cell[CellGroupData[{

Cell["xTensorTests", "Title"],

Cell["\<\
Execute this notebook once, starting with a fresh kernel. Some cells will \
open automatically, and some of them will even print error messages. That\
\[CloseCurlyQuote]s all for testing purposes, and is expected. At the end, \
check the last result of the last section.\
\>", "Text"],

Cell[CellGroupData[{

Cell[TextData[{
 "1. Load ",
 StyleBox["xTensor",
  FontSlant->"Italic"]
}], "Section"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "xAct`xTensor`"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.1\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2013", ",", "7", ",", "1"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.1", ", ", {2013, 7, 1}],
  Editable->False]], "Print"],

Cell[BoxData["\<\"CopyRight (C) 2003-2013, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], "Print"],

Cell[BoxData["\<\"Connection established.\"\>"], "Print"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.1.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2013", ",", "9", ",", "1"}], "}"}]}],
  SequenceForm["Package xAct`xTensor`  version ", "1.1.0", ", ", {2013, 9, 1}],
  Editable->False]], "Print"],

Cell[BoxData["\<\"CopyRight (C) 2002-2013, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], "Print"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], "Print"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. Tests from xTensorDoc.nb", "Section"],

Cell[CellGroupData[{

Cell["0. Basics", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefManifold", ",", "\[IndentingNewLine]", 
   RowBox[{"DefManifold", "[", 
    RowBox[{"M3", ",", "3", ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], "]"}], 
   ",", "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M3, ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM3, ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefManifold",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"v", "[", "a", "]"}], ",", "M3"}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v[$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"F", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], ",", "M3", ",", 
     RowBox[{"Antisymmetric", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}]}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"F", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`F[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Times", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], 
    RowBox[{"v", "[", "b", "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], 
    RowBox[{"v", "[", "b", "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Times",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Times", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], 
    RowBox[{"v", "[", "b", "]"}], 
    RowBox[{"v", "[", "a", "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], 
    RowBox[{"v", "[", "a", "]"}], 
    RowBox[{"v", "[", "b", "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Times",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Simplification", ",", "\[IndentingNewLine]", 
   RowBox[{"Simplification", "[", 
    RowBox[{
     RowBox[{"F", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], 
     RowBox[{"v", "[", "a", "]"}], 
     RowBox[{"v", "[", "b", "]"}]}], "]"}], ",", "\[IndentingNewLine]", "0", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Simplification",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Times", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"F", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], 
     RowBox[{"v", "[", "d", "]"}], 
     RowBox[{"v", "[", "b", "]"}], 
     RowBox[{"v", "[", 
      RowBox[{"-", "b"}], "]"}]}], "+", 
    RowBox[{"3", 
     RowBox[{"v", "[", "b", "]"}], 
     RowBox[{"v", "[", "c", "]"}], 
     RowBox[{"v", "[", 
      RowBox[{"-", "c"}], "]"}], 
     RowBox[{"F", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", "d"}], "]"}], 
     RowBox[{"F", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"3", "*", 
     RowBox[{"F", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", "d"}], "]"}], "*", 
     RowBox[{"F", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"v", "[", "b", "]"}], "*", 
     RowBox[{"v", "[", 
      RowBox[{"-", "c"}], "]"}], "*", 
     RowBox[{"v", "[", "c", "]"}]}], "+", 
    RowBox[{
     RowBox[{"F", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"v", "[", 
      RowBox[{"-", "b"}], "]"}], "*", 
     RowBox[{"v", "[", "b", "]"}], "*", 
     RowBox[{"v", "[", "d", "]"}]}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Times",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Simplification", ",", "\[IndentingNewLine]", 
   RowBox[{"Simplification", "[", 
    RowBox[{
     RowBox[{"3", "*", 
      RowBox[{"F", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", "d"}], "]"}], "*", 
      RowBox[{"F", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "a"}]}], "]"}], "*", 
      RowBox[{"v", "[", "b", "]"}], "*", 
      RowBox[{"v", "[", 
       RowBox[{"-", "c"}], "]"}], "*", 
      RowBox[{"v", "[", "c", "]"}]}], "+", 
     RowBox[{
      RowBox[{"F", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "*", 
      RowBox[{"v", "[", 
       RowBox[{"-", "b"}], "]"}], "*", 
      RowBox[{"v", "[", "b", "]"}], "*", 
      RowBox[{"v", "[", "d", "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"F", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "3"}], ")"}], "*", 
       RowBox[{"F", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "*", 
       RowBox[{"F", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", "d"}], "]"}]}]}], ")"}], "*", 
    RowBox[{"v", "[", 
     RowBox[{"-", "b"}], "]"}], "*", 
    RowBox[{"v", "[", "b", "]"}], "*", 
    RowBox[{"v", "[", "c", "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Simplification",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Validate", ",", "\[IndentingNewLine]", 
   RowBox[{"Validate", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"F", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "c"}]}], "]"}], "-", 
       RowBox[{"3", "*", 
        RowBox[{"F", "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "*", 
        RowBox[{"F", "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", "d"}], "]"}]}]}], ")"}], "*", 
     RowBox[{"v", "[", 
      RowBox[{"-", "b"}], "]"}], "*", 
     RowBox[{"v", "[", "b", "]"}], "*", 
     RowBox[{"v", "[", "c", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ERROR", "[", 
     RowBox[{"v", "[", 
      RowBox[{"-", "b"}], "]"}], "]"}], "*", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"F", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "3"}], ")"}], "*", 
       RowBox[{"ERROR", "[", 
        RowBox[{"F", "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", "d"}], "]"}], "]"}], "*", 
       RowBox[{"F", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "d"}]}], "]"}]}]}], ")"}], "*", 
    RowBox[{"v", "[", "b", "]"}], "*", 
    RowBox[{"v", "[", "c", "]"}]}], ",", "\[IndentingNewLine]", "True"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Validate", "::", "error"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(\\\"Invalid character of index in tensor F\
\\\"\\)\[NoBreak]\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Validate", "::", "error"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(\\\"Invalid character of index in tensor v\
\\\"\\)\[NoBreak]\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Validate",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefCovD", ",", "\[IndentingNewLine]", 
   RowBox[{"Options", "[", "DefCovD", "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"SymbolOfCovD", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<;\>\"", ",", "\"\<\[EmptyDownTriangle]\>\""}], "}"}]}], 
     ",", 
     RowBox[{"Torsion", "\[Rule]", "False"}], ",", 
     RowBox[{"Curvature", "\[Rule]", "True"}], ",", 
     RowBox[{"FromMetric", "\[Rule]", "Null"}], ",", 
     RowBox[{"CurvatureRelations", "\[Rule]", "True"}], ",", 
     RowBox[{"ExtendedFrom", "\[Rule]", "Null"}], ",", 
     RowBox[{"OtherDependencies", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"OrthogonalTo", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"ProjectedWith", "\[Rule]", 
      RowBox[{"{", "}"}]}], ",", 
     RowBox[{"WeightedWithBasis", "\[Rule]", "Null"}], ",", 
     RowBox[{"ProtectNewSymbol", "\[RuleDelayed]", "$ProtectNewSymbols"}], 
     ",", 
     RowBox[{"Master", "\[Rule]", "Null"}], ",", 
     RowBox[{"DefInfo", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<covariant derivative\>\"", ",", "\"\<\>\""}], "}"}]}]}], 
    "}"}], ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefCovD",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefCovD", ",", "\[IndentingNewLine]", 
   RowBox[{"DefCovD", "[", 
    RowBox[{"Cd", "[", 
     RowBox[{"-", "a"}], "]"}], "]"}], ",", "\[IndentingNewLine]", "Null", 
   ",", "\[IndentingNewLine]", "False"}], "\[IndentingNewLine]", 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"Cd", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`Cd[-$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCd", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCd[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCd", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCd", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCd[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
$CellContext`d], ". ", "Antisymmetric only in the first pair."],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCd", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "non-symmetric Ricci tensor ", 
   $CellContext`RicciCd[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefCovD",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"CovD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Cd", "[", 
     RowBox[{"-", "a"}], "]"}], "[", " ", 
    RowBox[{
     RowBox[{"F", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], 
     RowBox[{"v", "[", "c", "]"}]}], " ", "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"v", "[", "c", "]"}], "*", 
     RowBox[{
      RowBox[{"Cd", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"F", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"F", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"Cd", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"v", "[", "c", "]"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["CovD",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Simplification", ",", "\[IndentingNewLine]", 
   RowBox[{"Simplification", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"v", "[", "c", "]"}], "*", 
        RowBox[{
         RowBox[{"Cd", "[", 
          RowBox[{"-", "a"}], "]"}], "[", 
         RowBox[{"F", "[", 
          RowBox[{
           RowBox[{"-", "b"}], ",", 
           RowBox[{"-", "c"}]}], "]"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"F", "[", 
         RowBox[{
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "c"}]}], "]"}], "*", 
        RowBox[{
         RowBox[{"Cd", "[", 
          RowBox[{"-", "a"}], "]"}], "[", 
         RowBox[{"v", "[", "c", "]"}], "]"}]}]}], ")"}], " ", 
     RowBox[{"v", "[", "b", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"F", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}]}], "]"}], "*", 
    RowBox[{"v", "[", "b", "]"}], "*", 
    RowBox[{
     RowBox[{"Cd", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"v", "[", "c", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "False"}], "\[IndentingNewLine]", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Simplification",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Simplification", ",", "\[IndentingNewLine]", 
   RowBox[{"Simplification", "[", 
    RowBox[{
     RowBox[{"RiemannCd", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}], ",", "d"}], "]"}], "+", 
     RowBox[{"RiemannCd", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}], ",", "d"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Simplification",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Simplification", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}], ",", "d"}], "]"}], "+", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}], ",", "d"}], "]"}]}], "//", 
     "RiemannToChristoffel"}], "//", "Simplification"}], ",", 
   "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Simplification",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Simplification", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}], ",", "d"}], "]"}], "+", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "a"}], ",", "d"}], "]"}], "+", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}], ",", "d"}], "]"}]}], "//", 
     "RiemannToChristoffel"}], "//", "Simplification"}], ",", 
   "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Simplification",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Antisymmetrize", ",", "\[IndentingNewLine]", 
   RowBox[{"Antisymmetrize", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Cd", "[", 
       RowBox[{"-", "e"}], "]"}], "[", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "e"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Cd", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"RiemannCd", "[", 
         RowBox[{
          RowBox[{"-", "d"}], ",", 
          RowBox[{"-", "e"}], ",", 
          RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"Cd", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"RiemannCd", "[", 
         RowBox[{
          RowBox[{"-", "e"}], ",", 
          RowBox[{"-", "d"}], ",", 
          RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"Cd", "[", 
         RowBox[{"-", "d"}], "]"}], "[", 
        RowBox[{"RiemannCd", "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "e"}], ",", 
          RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Cd", "[", 
         RowBox[{"-", "d"}], "]"}], "[", 
        RowBox[{"RiemannCd", "[", 
         RowBox[{
          RowBox[{"-", "e"}], ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"Cd", "[", 
         RowBox[{"-", "e"}], "]"}], "[", 
        RowBox[{"RiemannCd", "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}], ",", 
          RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"Cd", "[", 
         RowBox[{"-", "e"}], "]"}], "[", 
        RowBox[{"RiemannCd", "[", 
         RowBox[{
          RowBox[{"-", "d"}], ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}]}], ")"}], "/", "6"}], "//",
     "Evaluate"}], ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Antisymmetrize",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Simplification", ",", 
   RowBox[{
    RowBox[{"3", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"Cd", "[", 
          RowBox[{"-", "c"}], "]"}], "[", 
         RowBox[{"RiemannCd", "[", 
          RowBox[{
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"Cd", "[", 
          RowBox[{"-", "c"}], "]"}], "[", 
         RowBox[{"RiemannCd", "[", 
          RowBox[{
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"Cd", "[", 
          RowBox[{"-", "d"}], "]"}], "[", 
         RowBox[{"RiemannCd", "[", 
          RowBox[{
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"Cd", "[", 
          RowBox[{"-", "d"}], "]"}], "[", 
         RowBox[{"RiemannCd", "[", 
          RowBox[{
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"Cd", "[", 
          RowBox[{"-", "e"}], "]"}], "[", 
         RowBox[{"RiemannCd", "[", 
          RowBox[{
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"Cd", "[", 
          RowBox[{"-", "e"}], "]"}], "[", 
         RowBox[{"RiemannCd", "[", 
          RowBox[{
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}]}], ")"}], "/", 
      "6"}]}], "//", "Simplification"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Cd", "[", 
      RowBox[{"-", "c"}], "]"}], "[", 
     RowBox[{"RiemannCd", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "-", 
    RowBox[{
     RowBox[{"Cd", "[", 
      RowBox[{"-", "d"}], "]"}], "[", 
     RowBox[{"RiemannCd", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "+", 
    RowBox[{
     RowBox[{"Cd", "[", 
      RowBox[{"-", "e"}], "]"}], "[", 
     RowBox[{"RiemannCd", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}]}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Simplification",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"CovDToChristoffel", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Cd", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"RiemannCd", "[", 
        RowBox[{
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "-", 
      RowBox[{
       RowBox[{"Cd", "[", 
        RowBox[{"-", "d"}], "]"}], "[", 
       RowBox[{"RiemannCd", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "+", 
      RowBox[{
       RowBox[{"Cd", "[", 
        RowBox[{"-", "e"}], "]"}], "[", 
       RowBox[{"RiemannCd", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}]}], "//", 
     "CovDToChristoffel"}], "//", "ScreenDollarIndices"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "b"}], ",", "e1"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e1"}], ",", "a"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "b"}], ",", "e1"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "e1"}], ",", "a"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], "*", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "e1"}], ",", 
        RowBox[{"-", "b"}], ",", "a"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "*", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "e1"}], ",", 
        RowBox[{"-", "b"}], ",", "a"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "b"}], ",", "e1"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "e1"}], ",", "a"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], "*", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e1"}], ",", 
        RowBox[{"-", "b"}], ",", "a"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "*", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "e1"}], ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "b"}], ",", "a"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "*", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "e1"}], ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "b"}], ",", "a"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "*", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "e1"}], ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "b"}], ",", "a"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "-", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "d"}], "]"}], "[", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "+", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "e"}], "]"}], "[", 
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}]}], "//", "Evaluate"}], 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["CovDToChristoffel",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"RiemannToChristoffel", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "e1"}]}], "]"}], "*", 
       RowBox[{"RiemannCd", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "b"}], ",", "e1"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "*", 
       RowBox[{"RiemannCd", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "e1"}], ",", "a"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "e1"}]}], "]"}], "*", 
       RowBox[{"RiemannCd", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}], ",", "e1"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "*", 
       RowBox[{"RiemannCd", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "e1"}], ",", "a"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "*", 
       RowBox[{"RiemannCd", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "e1"}], ",", 
         RowBox[{"-", "b"}], ",", "a"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "*", 
       RowBox[{"RiemannCd", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "e1"}], ",", 
         RowBox[{"-", "b"}], ",", "a"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "e1"}]}], "]"}], "*", 
       RowBox[{"RiemannCd", "[", 
        RowBox[{
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}], ",", "e1"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "*", 
       RowBox[{"RiemannCd", "[", 
        RowBox[{
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "e1"}], ",", "a"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "*", 
       RowBox[{"RiemannCd", "[", 
        RowBox[{
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "e1"}], ",", 
         RowBox[{"-", "b"}], ",", "a"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "c"}]}], "]"}], "*", 
       RowBox[{"RiemannCd", "[", 
        RowBox[{
         RowBox[{"-", "e1"}], ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "b"}], ",", "a"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "*", 
       RowBox[{"RiemannCd", "[", 
        RowBox[{
         RowBox[{"-", "e1"}], ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}], ",", "a"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "c"}]}], "]"}], "*", 
       RowBox[{"RiemannCd", "[", 
        RowBox[{
         RowBox[{"-", "e1"}], ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}], ",", "a"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"RiemannCd", "[", 
        RowBox[{
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "-", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "d"}], "]"}], "[", 
       RowBox[{"RiemannCd", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}], "+", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "e"}], "]"}], "[", 
       RowBox[{"RiemannCd", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "b"}], ",", "a"}], "]"}], "]"}]}], "//", 
     "RiemannToChristoffel"}], "//", "ScreenDollarIndices"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ChristoffelCd", "[", 
         RowBox[{"e1", ",", 
          RowBox[{"-", "e"}], ",", 
          RowBox[{"-", "b"}]}], "]"}], "*", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "c"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}], "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "e1"}]}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "d"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}], "]"}], "+", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "e"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}], "]"}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "d"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "e1"}]}], "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "c"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "d"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}], "]"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "d"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "e1"}]}], "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "d"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "c"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "d"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "d"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "d"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}], "]"}], "-", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "d"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "e"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}], "]"}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "e"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "e1"}]}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "c"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}], "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "e"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "e1"}]}], "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "d"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}], "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "e"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "c"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "e"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "d"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "e"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}], "]"}], "+", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "e"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "d"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}], "]"}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "c"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e1"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "c"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e1"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ChristoffelCd", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "e1"}], ",", 
             RowBox[{"-", "e2"}]}], "]"}], "*", 
           RowBox[{"ChristoffelCd", "[", 
            RowBox[{"e2", ",", 
             RowBox[{"-", "d"}], ",", 
             RowBox[{"-", "b"}]}], "]"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "d"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e1"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "d"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e1"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ChristoffelCd", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "e1"}], ",", 
             RowBox[{"-", "e2"}]}], "]"}], "*", 
           RowBox[{"ChristoffelCd", "[", 
            RowBox[{"e2", ",", 
             RowBox[{"-", "e"}], ",", 
             RowBox[{"-", "b"}]}], "]"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e1"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ChristoffelCd", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "e1"}], ",", 
             RowBox[{"-", "e2"}]}], "]"}], "*", 
           RowBox[{"ChristoffelCd", "[", 
            RowBox[{"e2", ",", 
             RowBox[{"-", "e"}], ",", 
             RowBox[{"-", "b"}]}], "]"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e1"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}]}], "//", 
    "Evaluate"}], ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["RiemannToChristoffel",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Simplification", ",", "\[IndentingNewLine]", 
   RowBox[{"Simplification", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ChristoffelCd", "[", 
         RowBox[{"e1", ",", 
          RowBox[{"-", "e"}], ",", 
          RowBox[{"-", "b"}]}], "]"}], "*", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "c"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}], "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "e1"}]}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "d"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}], "]"}], "+", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "e"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}], "]"}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "d"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "e1"}]}], "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "c"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "d"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}], "]"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "d"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "e1"}]}], "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "d"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "c"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "d"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "d"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "d"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}], "]"}], "-", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "d"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "e"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}], "]"}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "e"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "e1"}]}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "c"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}], "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "e"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "e1"}]}], "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "d"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e1"}]}], "]"}], "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "e"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "c"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "e"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "e1"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "d"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e1", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "e"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}], "]"}], "+", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "e"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "d"}], "]"}], "[", 
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}], "]"}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "c"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e1"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "c"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e1"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ChristoffelCd", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "e1"}], ",", 
             RowBox[{"-", "e2"}]}], "]"}], "*", 
           RowBox[{"ChristoffelCd", "[", 
            RowBox[{"e2", ",", 
             RowBox[{"-", "d"}], ",", 
             RowBox[{"-", "b"}]}], "]"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "d"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e1"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "d"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e1"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "d"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ChristoffelCd", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "e1"}], ",", 
             RowBox[{"-", "e2"}]}], "]"}], "*", 
           RowBox[{"ChristoffelCd", "[", 
            RowBox[{"e2", ",", 
             RowBox[{"-", "e"}], ",", 
             RowBox[{"-", "b"}]}], "]"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e1"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCd", "[", 
       RowBox[{"e1", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"ChristoffelCd", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "e1"}], ",", 
             RowBox[{"-", "e2"}]}], "]"}], "*", 
           RowBox[{"ChristoffelCd", "[", 
            RowBox[{"e2", ",", 
             RowBox[{"-", "e"}], ",", 
             RowBox[{"-", "b"}]}], "]"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "e2"}]}], "]"}], "*", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"e2", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e1"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}], "-", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "e1"}], "]"}], "[", 
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"a", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Simplification",
    HoldForm], ",", "8", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"CovD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Cd", "[", 
     RowBox[{"-", "a"}], "]"}], "@", 
    RowBox[{
     RowBox[{"Cd", "[", 
      RowBox[{"-", "b"}], "]"}], "@", 
     RowBox[{"v", "[", "c", "]"}]}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Cd", "[", 
     RowBox[{"-", "a"}], "]"}], "@", 
    RowBox[{
     RowBox[{"Cd", "[", 
      RowBox[{"-", "b"}], "]"}], "@", 
     RowBox[{"v", "[", "c", "]"}]}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["CovD",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"CommuteCovDs", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CommuteCovDs", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Cd", "[", 
        RowBox[{"-", "a"}], "]"}], "@", 
       RowBox[{
        RowBox[{"Cd", "[", 
         RowBox[{"-", "b"}], "]"}], "@", 
        RowBox[{"v", "[", "c", "]"}]}]}], ",", "Cd", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "a"}]}], "}"}]}], "]"}], "//", "ScreenDollarIndices"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannCd", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}], ",", "c"}], "]"}], "*", 
     RowBox[{"v", "[", "d", "]"}]}], "+", 
    RowBox[{
     RowBox[{"Cd", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{
      RowBox[{"Cd", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"v", "[", "c", "]"}], "]"}], "]"}]}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["CommuteCovDs",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SortCovDs", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SortCovDs", "[", 
     RowBox[{
      RowBox[{"Cd", "[", 
       RowBox[{"-", "a"}], "]"}], "@", 
      RowBox[{
       RowBox[{"Cd", "[", 
        RowBox[{"-", "b"}], "]"}], "@", 
       RowBox[{"v", "[", "c", "]"}]}]}], "]"}], "//", "ScreenDollarIndices"}],
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannCd", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}], ",", "c"}], "]"}], "*", 
     RowBox[{"v", "[", "d", "]"}]}], "+", 
    RowBox[{
     RowBox[{"Cd", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{
      RowBox[{"Cd", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"v", "[", "c", "]"}], "]"}], "]"}]}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SortCovDs",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefMetric", ",", "\[IndentingNewLine]", 
   RowBox[{"DefMetric", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], ",", "CD", ",", 
     RowBox[{"SymbolOfCovD", "->", 
      RowBox[{"{", 
       RowBox[{"\"\<|\>\"", ",", "\"\<D\>\""}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`g[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilong", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilong[-$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 3],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 3],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 3],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detg[], ". ", "Determinant."],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefMetric",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"CovD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}]}], "]"}], "]"}], ",", "\[IndentingNewLine]", "0", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["CovD",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"CovD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"EinsteinCD", "[", 
     RowBox[{"a", ",", "b"}], "]"}], "]"}], ",", "\[IndentingNewLine]", "0", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["CovD",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Metric", ",", "\[IndentingNewLine]", 
   RowBox[{"g", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "a"}]}], "]"}], ",", "\[IndentingNewLine]", "3", ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Metric",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Metric", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"delta", "[", 
    RowBox[{
     RowBox[{"-", "c"}], ",", "a"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Metric",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Plus", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], "+", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "c"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], "+", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "c"}]}], "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Plus",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ChangeCurvature", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"RiemannCD", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "+", 
       RowBox[{"RiemannCD", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "c"}]}], "]"}]}], "//", "RiemannToChristoffel"}], "//", 
     "Simplification"}], "//", "ScreenDollarIndices"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "b"}], ",", "e"}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}], ",", "e"}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "a"}], ",", "e"}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}], ",", "e"}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e1", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e1"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e1", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e1"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e1", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "e1"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e1", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "e1"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "]"}], "+", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "True"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ToCanonical", "::", "cmods"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Detected metric-incompatible derivatives \
\[NoBreak]\\!\\({PD}\\)\[NoBreak].\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ToCanonical", "::", "cmods"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Detected metric-incompatible derivatives \
\[NoBreak]\\!\\({PD}\\)\[NoBreak].\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ToCanonical", "::", "cmods"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Detected metric-incompatible derivatives \
\[NoBreak]\\!\\({PD}\\)\[NoBreak].\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(ToCanonical :: cmods\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChangeCurvature",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ContractMetric", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "b"}], ",", "e"}], "]"}], "*", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "c"}]}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}], ",", "e"}], "]"}], "*", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "d"}]}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "a"}], ",", "e"}], "]"}], "*", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "c"}]}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "a"}], ",", "e"}], "]"}], "*", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "d"}]}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "*", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "*", 
       RowBox[{"g", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "e1"}]}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "*", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "*", 
       RowBox[{"g", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "e1"}]}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "c"}]}], "]"}], "*", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "*", 
       RowBox[{"g", "[", 
        RowBox[{
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "e1"}]}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "c"}]}], "]"}], "*", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e1", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "*", 
       RowBox[{"g", "[", 
        RowBox[{
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "e1"}]}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "c"}]}], "]"}], "]"}], "+", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "c"}]}], "]"}], "]"}]}], "//", "ContractMetric"}], "//",
     "Simplification"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "]"}], "+", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ContractMetric",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "b"}], ",", "e"}], "]"}], "*", 
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{
      RowBox[{"-", "e"}], ",", 
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "c"}]}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "b"}], ",", "e"}], "]"}], "*", 
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{
      RowBox[{"-", "e"}], ",", 
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "d"}]}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "a"}], ",", "e"}], "]"}], "*", 
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{
      RowBox[{"-", "e"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}]}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "a"}], ",", "e"}], "]"}], "*", 
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{
      RowBox[{"-", "e"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "d"}]}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{"e", ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], "*", 
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{"e1", ",", 
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "e"}]}], "]"}], "*", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "e1"}]}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{"e", ",", 
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], "*", 
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{"e1", ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "e"}]}], "]"}], "*", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "e1"}]}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{"e", ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}]}], "]"}], "*", 
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{"e1", ",", 
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "e"}]}], "]"}], "*", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "e1"}]}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{"e", ",", 
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "c"}]}], "]"}], "*", 
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{"e1", ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "e"}]}], "]"}], "*", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "e1"}]}], "]"}]}], "-", 
   RowBox[{
    RowBox[{"PD", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
   RowBox[{
    RowBox[{"PD", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}]}], "]"}], "]"}], "+", 
   RowBox[{
    RowBox[{"PD", "[", 
     RowBox[{"-", "b"}], "]"}], "[", 
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
   RowBox[{
    RowBox[{"PD", "[", 
     RowBox[{"-", "b"}], "]"}], "[", 
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "c"}]}], "]"}], "]"}]}], "//", 
  "ContractMetric"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", "e"},
           {"d", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`d, -$CellContext`b, \
$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"e", "a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`e, -$CellContext`a, \
-$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", "e"},
           {"c", "b", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`c, -$CellContext`b, \
$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"e", "a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`e, -$CellContext`a, \
-$CellContext`d],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", "e"},
           {"d", "a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`d, -$CellContext`a, \
$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"e", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`e, -$CellContext`b, \
-$CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", "e"},
           {"c", "a", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`c, -$CellContext`a, \
$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"e", "b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`e, -$CellContext`b, \
-$CellContext`d],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"d", "b", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`d, -$CellContext`b, \
-$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"e", " ", " "},
           {" ", "a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[$CellContext`e, -$CellContext`a, \
-$CellContext`c],
    Editable->False]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"c", "b", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`c, -$CellContext`b, \
-$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"e", " ", " "},
           {" ", "a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[$CellContext`e, -$CellContext`a, \
-$CellContext`d],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"d", "a", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`d, -$CellContext`a, \
-$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"e", " ", " "},
           {" ", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[$CellContext`e, -$CellContext`b, \
-$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"c", "a", "e"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[-$CellContext`c, -$CellContext`a, \
-$CellContext`e],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {"e", " ", " "},
           {" ", "b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`ChristoffelCD[$CellContext`e, -$CellContext`b, \
-$CellContext`d],
    Editable->False]}], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "a"], GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"c", "b", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`a][
    $CellContext`ChristoffelCD[-$CellContext`c, -$CellContext`b, \
-$CellContext`d]],
   Editable->False], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "a"], GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"d", "b", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`a][
    $CellContext`ChristoffelCD[-$CellContext`d, -$CellContext`b, \
-$CellContext`c]],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "b"], GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"c", "a", "d"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`b][
    $CellContext`ChristoffelCD[-$CellContext`c, -$CellContext`a, \
-$CellContext`d]],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[PartialD]", "b"], GridBox[{
       {
        RowBox[{"\[CapitalGamma]", "[", "D", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " "},
           {"d", "a", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`PD[-$CellContext`b][
    $CellContext`ChristoffelCD[-$CellContext`d, -$CellContext`a, \
-$CellContext`c]],
   Editable->False]}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ChristoffelToGradMetric", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "c"}]}], "]"}], "]"}], "+", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "c"}]}], "]"}], "]"}]}], "//", 
     "ChristoffelToGradMetric"}], "//", "Expand"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "b"}], "]"}], "[", 
         RowBox[{"g", "[", 
          RowBox[{
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "/", "2"}], "-", 
     RowBox[{
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"g", "[", 
         RowBox[{
          RowBox[{"-", "d"}], ",", 
          RowBox[{"-", "c"}]}], "]"}], "]"}], "]"}], "/", "2"}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"g", "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}], "/", "2"}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"g", "[", 
         RowBox[{
          RowBox[{"-", "d"}], ",", 
          RowBox[{"-", "c"}]}], "]"}], "]"}], "]"}], "/", "2"}]}], "//", 
    "Evaluate"}], ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChristoffelToGradMetric",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Simplification", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "b"}], "]"}], "[", 
         RowBox[{"g", "[", 
          RowBox[{
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "/", "2"}], "-", 
     RowBox[{
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"g", "[", 
         RowBox[{
          RowBox[{"-", "d"}], ",", 
          RowBox[{"-", "c"}]}], "]"}], "]"}], "]"}], "/", "2"}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"g", "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}], "/", "2"}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"g", "[", 
         RowBox[{
          RowBox[{"-", "d"}], ",", 
          RowBox[{"-", "c"}]}], "]"}], "]"}], "]"}], "/", "2"}]}], "//", 
    "Simplification"}], ",", "\[IndentingNewLine]", "0", ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Simplification",
    HoldForm], ",", "9", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SortCovDs", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "b"}], "]"}], "[", 
         RowBox[{"g", "[", 
          RowBox[{
           RowBox[{"-", "c"}], ",", 
           RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "/", "2"}], "-", 
     RowBox[{
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"g", "[", 
         RowBox[{
          RowBox[{"-", "d"}], ",", 
          RowBox[{"-", "c"}]}], "]"}], "]"}], "]"}], "/", "2"}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"g", "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}], "/", "2"}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"g", "[", 
         RowBox[{
          RowBox[{"-", "d"}], ",", 
          RowBox[{"-", "c"}]}], "]"}], "]"}], "]"}], "/", "2"}]}], "//", 
    "SortCovDs"}], ",", "\[IndentingNewLine]", "0", ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SortCovDs",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"LieD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LieD", "[", 
     RowBox[{"3", 
      RowBox[{"v", "[", "a", "]"}]}], "]"}], "[", 
    RowBox[{
     RowBox[{"F", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], 
     RowBox[{"v", "[", "b", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"3", "*", 
    RowBox[{"v", "[", "b", "]"}], "*", 
    RowBox[{
     RowBox[{"LieD", "[", 
      RowBox[{"v", "[", "a", "]"}], "]"}], "[", 
     RowBox[{"F", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["LieD",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Bracket", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Bracket", "[", 
     RowBox[{
      RowBox[{"v", "[", "a", "]"}], ",", 
      RowBox[{
       RowBox[{"F", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "b"}]}], "]"}], 
       RowBox[{"v", "[", "b", "]"}]}]}], "]"}], "[", "a", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Bracket", "[", 
     RowBox[{
      RowBox[{"v", "[", "a", "]"}], ",", 
      RowBox[{
       RowBox[{"F", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "b"}]}], "]"}], "*", 
       RowBox[{"v", "[", "b", "]"}]}]}], "]"}], "[", "a", "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Bracket",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefMetric", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefMetric", "[", "g", "]"}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Detg"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "weight +2 density", 
   " ", $CellContext`Detg],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "ChristoffelCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Christoffel tensor", " ", $CellContext`ChristoffelCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "EinsteinCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Einstein tensor", " ", $CellContext`EinsteinCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "KretschmannCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Kretschmann scalar", 
   " ", $CellContext`KretschmannCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric Ricci tensor", 
   " ", $CellContext`RicciCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciScalarCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci scalar", 
   " ", $CellContext`RicciScalarCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TFRicciCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric TFRicci tensor",
    " ", $CellContext`TFRicciCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "WeylCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Weyl tensor", 
   " ", $CellContext`WeylCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "CD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "covariant derivative", 
   " ", $CellContext`CD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "epsilong"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric tensor", 
   " ", $CellContext`epsilong],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "g"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric metric tensor", 
   " ", $CellContext`g],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefMetric",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "/@", 
    RowBox[{"{", 
     RowBox[{"v", ",", "F"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"Null", ",", "Null"}], "}"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "v"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`v],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "F"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`F],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefCovD", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefCovD", "[", "Cd", "]"}], ",", "\[IndentingNewLine]", "Null", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "ChristoffelCd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Christoffel tensor", " ", $CellContext`ChristoffelCd],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciCd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Ricci tensor", " ", $CellContext`RicciCd],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannCd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannCd],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionCd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionCd],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Cd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "covariant derivative", 
   " ", $CellContext`Cd],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefCovD",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefManifold", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefManifold", "[", "M3", "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["\[DoubleStruckCapitalT]M3",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TangentM3,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`TangentM3],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefManifold", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"manifold\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "M3"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefManifold, ": Undefined ", "manifold", 
   " ", $CellContext`M3],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefManifold",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Names", ",", "\[IndentingNewLine]", 
   RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Names",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["1. Manifolds, vector bundles and parameters", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefManifold", ",", "\[IndentingNewLine]", 
   RowBox[{"DefManifold", "[", 
    RowBox[{"M3", ",", "3", ",", 
     RowBox[{"{", 
      RowBox[{
      "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
       "h"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", "Null", ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M3, ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM3, ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefManifold",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DimOfManifold", ",", "\[IndentingNewLine]", 
   RowBox[{"DimOfManifold", "[", "M3", "]"}], ",", "\[IndentingNewLine]", "3",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DimOfManifold",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Tangent", ",", "\[IndentingNewLine]", 
   RowBox[{"Tangent", "[", "M3", "]"}], ",", "\[IndentingNewLine]", 
   "TangentM3", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Tangent",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefManifold", ",", "\[IndentingNewLine]", 
   RowBox[{"DefManifold", "[", 
    RowBox[{"S2", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{
      "A", ",", "B", ",", "C", ",", "D", ",", "F", ",", "G", ",", "H"}], 
      "}"}]}], "]"}], ",", "\[IndentingNewLine]", "Null", ",", 
   "\[IndentingNewLine]", "True"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "S2", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`S2, ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentS2", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentS2, ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "capital"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"System name \[NoBreak]\\!\\(\\\"C\\\"\\)\[NoBreak] is \
overloaded as an abstract index.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "capital"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"System name \[NoBreak]\\!\\(\\\"D\\\"\\)\[NoBreak] is \
overloaded as an abstract index.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefManifold",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{
  "$Manifolds", ",", "\[IndentingNewLine]", "$Manifolds", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"M3", ",", "S2"}], "}"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["$Manifolds",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{
  "$VBundles", ",", "\[IndentingNewLine]", "$VBundles", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"TangentM3", ",", "TangentS2"}], "}"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["$VBundles",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefManifold", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefManifold", "[", "M3", "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["\[DoubleStruckCapitalT]M3",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TangentM3,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`TangentM3],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefManifold", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"manifold\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "M3"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefManifold, ": Undefined ", "manifold", 
   " ", $CellContext`M3],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefManifold",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{
  "$Manifolds", ",", "\[IndentingNewLine]", "$Manifolds", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", "S2", "}"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["$Manifolds",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefManifold", ",", "\[IndentingNewLine]", 
   RowBox[{"DefManifold", "[", 
    RowBox[{"M3", ",", "3", ",", 
     RowBox[{"IndexRange", "[", 
      RowBox[{"a", ",", "h"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M3, ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM3, ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefManifold",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{
  "$Manifolds", ",", "\[IndentingNewLine]", "$Manifolds", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"S2", ",", "M3"}], "}"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["$Manifolds",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefManifold", ",", "\[IndentingNewLine]", 
   RowBox[{"DefManifold", "[", 
    RowBox[{"M5", ",", 
     RowBox[{"{", 
      RowBox[{"M3", ",", "S2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\[Mu]", ",", "\[Nu]", ",", "\[Lambda]", ",", "\[Sigma]", ",", "\[Eta]",
        ",", "\[Rho]"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", "Null", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M5", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M5, ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM5", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM5, ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefManifold",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{
  "$ProductManifolds", ",", "\[IndentingNewLine]", "$ProductManifolds", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", "M5", "}"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["$ProductManifolds",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"CartesianProduct", ",", "\[IndentingNewLine]", 
   RowBox[{"prod", "=", 
    RowBox[{"CartesianProduct", "[", 
     RowBox[{"M3", ",", "S2"}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"CartesianProduct", "[", 
    RowBox[{"M3", ",", "S2"}], "]"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["CartesianProduct",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ManifoldQ", ",", "\[IndentingNewLine]", 
   RowBox[{"ManifoldQ", "[", "prod", "]"}], ",", "\[IndentingNewLine]", 
   "True", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ManifoldQ",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DimOfManifold", ",", "\[IndentingNewLine]", 
   RowBox[{"DimOfManifold", "[", "prod", "]"}], ",", "\[IndentingNewLine]", 
   "5", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DimOfManifold",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Tangent", ",", "\[IndentingNewLine]", 
   RowBox[{"Tangent", "[", "prod", "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"CirclePlus", "[", 
    RowBox[{"TangentM3", ",", "TangentS2"}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Tangent",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefManifold", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefManifold", "[", "M5", "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["\[DoubleStruckCapitalT]M5",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TangentM5,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`TangentM5],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefManifold", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"manifold\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "M5"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefManifold, ": Undefined ", "manifold", 
   " ", $CellContext`M5],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefManifold",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Remove", ",", "\[IndentingNewLine]", 
   RowBox[{"Remove", "[", "prod", "]"}], ",", "\[IndentingNewLine]", "Null", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Remove",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefVBundle", ",", "\[IndentingNewLine]", 
   RowBox[{"DefVBundle", "[", 
    RowBox[{"InnerC", ",", "M3", ",", "4", ",", 
     RowBox[{"{", 
      RowBox[{
      "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", "\[GothicCapitalC]",
        ",", "\[GothicCapitalD]", ",", "\[GothicCapitalE]", ",", 
       "\[GothicCapitalF]", ",", "\[GothicCapitalG]", ",", 
       "\[GothicCapitalH]"}], "}"}], ",", 
     RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "InnerC", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`InnerC, ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"conjugated vbundle \"\>", "\[InvisibleSpace]", 
   "InnerC\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Assuming fixed anti-isomorphism between InnerC \
and InnerC\[Dagger]\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "conjugated vbundle ", $CellContext`InnerC\[Dagger], ". ", 
   "Assuming fixed anti-isomorphism between InnerC and InnerC\[Dagger]"],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefVBundle",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{
  "$VBundles", ",", "\[IndentingNewLine]", "$VBundles", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
    "TangentS2", ",", "TangentM3", ",", "InnerC", ",", "InnerC\[Dagger]"}], 
    "}"}], ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["$VBundles",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefParameter", ",", "\[IndentingNewLine]", 
   RowBox[{"DefParameter", "[", "time", "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefParameter", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parameter \"\>", "\[InvisibleSpace]", "time", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefParameter, ": Defining ", 
   "parameter ", $CellContext`time, ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefParameter",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. Indices", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"AIndexQ", ",", "\[IndentingNewLine]", 
   RowBox[{"AIndexQ", "[", "A", "]"}], ",", "\[IndentingNewLine]", "True", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["AIndexQ",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"AIndexQ", ",", "\[IndentingNewLine]", 
   RowBox[{"AIndexQ", "[", 
    RowBox[{"-", "b"}], "]"}], ",", "\[IndentingNewLine]", "True", ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["AIndexQ",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"AIndexQ", ",", "\[IndentingNewLine]", 
   RowBox[{"AIndexQ", "[", "q", "]"}], ",", "\[IndentingNewLine]", "False", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["AIndexQ",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Remove", ",", "\[IndentingNewLine]", 
   RowBox[{"Remove", "[", "q", "]"}], ",", "\[IndentingNewLine]", "Null", ",",
    "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Remove",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"AIndexQ", ",", "\[IndentingNewLine]", 
   RowBox[{"AIndexQ", "[", 
    RowBox[{"A", ",", "TangentS2"}], "]"}], ",", "\[IndentingNewLine]", 
   "True", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["AIndexQ",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"AIndexQ", ",", "\[IndentingNewLine]", 
   RowBox[{"AIndexQ", "[", 
    RowBox[{"\[GothicCapitalA]", ",", "TangentM3"}], "]"}], ",", 
   "\[IndentingNewLine]", "False", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["AIndexQ",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"AIndexQ", ",", "\[IndentingNewLine]", 
   RowBox[{"AIndexQ", "[", 
    RowBox[{"\[GothicCapitalA]", ",", "InnerC"}], "]"}], ",", 
   "\[IndentingNewLine]", "True", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["AIndexQ",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"AIndexQ", ",", "\[IndentingNewLine]", 
   RowBox[{"AIndexQ", "[", 
    RowBox[{"\[GothicCapitalA]\[Dagger]", ",", "InnerC"}], "]"}], ",", 
   "\[IndentingNewLine]", "False", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["AIndexQ",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"AIndexQ", ",", "\[IndentingNewLine]", 
   RowBox[{"AIndexQ", "[", 
    RowBox[{"\[GothicCapitalA]\[Dagger]", ",", "InnerC\[Dagger]"}], "]"}], 
   ",", "\[IndentingNewLine]", "True", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["AIndexQ",
    HoldForm], ",", "8", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Tangent", ",", "\[IndentingNewLine]", 
   RowBox[{"TangentM3`Q", "[", "a", "]"}], ",", "\[IndentingNewLine]", "True",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Tangent",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Tangent", ",", "\[IndentingNewLine]", 
   RowBox[{"TangentM3`Q", "[", 
    RowBox[{"-", "a"}], "]"}], ",", "\[IndentingNewLine]", "False", ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Tangent",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Tangent", ",", "\[IndentingNewLine]", 
   RowBox[{"TangentM3`Q", "[", "A", "]"}], ",", "\[IndentingNewLine]", 
   "False", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Tangent",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Tangent", ",", "\[IndentingNewLine]", 
   RowBox[{"TangentM3`pmQ", "[", "a", "]"}], ",", "\[IndentingNewLine]", 
   "True", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Tangent",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Tangent", ",", "\[IndentingNewLine]", 
   RowBox[{"TangentM3`pmQ", "[", 
    RowBox[{"-", "a"}], "]"}], ",", "\[IndentingNewLine]", "True", ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Tangent",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndicesOfVBundle", ",", "\[IndentingNewLine]", 
   RowBox[{"IndicesOfVBundle", "[", "TangentM3", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
       "h"}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndicesOfVBundle",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"AddIndices", ",", "\[IndentingNewLine]", 
   RowBox[{"AddIndices", "[", 
    RowBox[{"TangentM3", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "j", ",", "k", ",", "l"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["AddIndices",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndicesOfVBundle", ",", "\[IndentingNewLine]", 
   RowBox[{"IndicesOfVBundle", "[", "TangentM3", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
       "h", ",", "i", ",", "j", ",", "k", ",", "l"}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndicesOfVBundle",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"RemoveIndices", ",", "\[IndentingNewLine]", 
   RowBox[{"RemoveIndices", "[", 
    RowBox[{"TangentM3", ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "i", ",", "l", ",", "k"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["RemoveIndices",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndicesOfVBundle", ",", "\[IndentingNewLine]", 
   RowBox[{"IndicesOfVBundle", "[", "TangentM3", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
       "h"}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndicesOfVBundle",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"NewIndexIn", ",", "\[IndentingNewLine]", 
   RowBox[{"NewIndexIn", "[", "TangentM3", "]"}], ",", "\[IndentingNewLine]", 
   "h1", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["NewIndexIn",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndicesOfVBundle", ",", "\[IndentingNewLine]", 
   RowBox[{"IndicesOfVBundle", "[", "TangentM3", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
       "h"}], "}"}], ",", 
     RowBox[{"{", "h1", "}"}]}], "}"}], ",", "\[IndentingNewLine]", "False"}],
   "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndicesOfVBundle",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"GetIndicesOfVBundle", ",", "\[IndentingNewLine]", 
   RowBox[{"GetIndicesOfVBundle", "[", 
    RowBox[{"TangentM3", ",", "14", ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "h3"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "f", ",", "g", ",", "h", ",", "h1", ",", 
     "h2", ",", "h4", ",", "h5", ",", "h6", ",", "h7", ",", "h8", ",", "h9"}],
     "}"}], ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["GetIndicesOfVBundle",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndicesOfVBundle", ",", "\[IndentingNewLine]", 
   RowBox[{"IndicesOfVBundle", "[", "TangentM3", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
       "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "h1", ",", "h2", ",", "h3", ",", "h4", ",", "h5", ",", "h6", ",", "h7", 
       ",", "h8", ",", "h9"}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndicesOfVBundle",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"NewIndexIn", ",", "\[IndentingNewLine]", 
   RowBox[{"NewIndexIn", "[", "InnerC", "]"}], ",", "\[IndentingNewLine]", 
   "\[GothicCapitalH]1", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["NewIndexIn",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndicesOfVBundle", ",", "\[IndentingNewLine]", 
   RowBox[{"IndicesOfVBundle", "[", "InnerC", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", "\[GothicCapitalC]",
        ",", "\[GothicCapitalD]", ",", "\[GothicCapitalE]", ",", 
       "\[GothicCapitalF]", ",", "\[GothicCapitalG]", ",", 
       "\[GothicCapitalH]"}], "}"}], ",", 
     RowBox[{"{", "\[GothicCapitalH]1", "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndicesOfVBundle",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndicesOfVBundle", ",", "\[IndentingNewLine]", 
   RowBox[{"IndicesOfVBundle", "[", "InnerC\[Dagger]", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\[GothicCapitalA]\[Dagger]", ",", "\[GothicCapitalB]\[Dagger]", ",", 
       "\[GothicCapitalC]\[Dagger]", ",", "\[GothicCapitalD]\[Dagger]", ",", 
       "\[GothicCapitalE]\[Dagger]", ",", "\[GothicCapitalF]\[Dagger]", ",", 
       "\[GothicCapitalG]\[Dagger]", ",", "\[GothicCapitalH]\[Dagger]"}], 
      "}"}], ",", 
     RowBox[{"{", "\[GothicCapitalH]1\[Dagger]", "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndicesOfVBundle",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"GetIndicesOfVBundle", ",", "\[IndentingNewLine]", 
   RowBox[{"GetIndicesOfVBundle", "[", 
    RowBox[{"InnerC\[Dagger]", ",", "10"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
    "\[GothicCapitalA]\[Dagger]", ",", "\[GothicCapitalB]\[Dagger]", ",", 
     "\[GothicCapitalC]\[Dagger]", ",", "\[GothicCapitalD]\[Dagger]", ",", 
     "\[GothicCapitalE]\[Dagger]", ",", "\[GothicCapitalF]\[Dagger]", ",", 
     "\[GothicCapitalG]\[Dagger]", ",", "\[GothicCapitalH]1\[Dagger]", ",", 
     "\[GothicCapitalH]\[Dagger]", ",", "\[GothicCapitalH]2"}], "}"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["GetIndicesOfVBundle",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndicesOfVBundle", ",", "\[IndentingNewLine]", 
   RowBox[{"IndicesOfVBundle", "[", "InnerC", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", "\[GothicCapitalC]",
        ",", "\[GothicCapitalD]", ",", "\[GothicCapitalE]", ",", 
       "\[GothicCapitalF]", ",", "\[GothicCapitalG]", ",", 
       "\[GothicCapitalH]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[GothicCapitalH]1", ",", "\[GothicCapitalH]2"}], "}"}]}], 
    "}"}], ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndicesOfVBundle",
    HoldForm], ",", "8", ",", "True"}], "}"}]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["3. Tensors and tensor slots", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"a", ",", "b", ",", 
       RowBox[{"-", "c"}]}], "]"}], ",", "M3"}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`T[$CellContext`a, $CellContext`b, -$CellContext`c], ". ", ""],
  
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"a", ",", "b"}], "]"}], ",", "M3"}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`S[$CellContext`a, $CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"v", "[", "a", "]"}], ",", "M3"}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v[$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"r", "[", "]"}], ",", "M3"}], "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"r", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`r[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"U", "[", 
      RowBox[{"a", ",", "b", ",", 
       RowBox[{"-", "c"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"M3", ",", "S2", ",", "time"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"U", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`U[$CellContext`a, $CellContext`b, -$CellContext`c], ". ", ""],
  
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "[", "U", "]"}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "U"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`U],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"U", "[", 
      RowBox[{"a", ",", "A"}], "]"}], ",", "M3"}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"U", "[", 
    RowBox[{"a", ",", "A"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`U[$CellContext`a, $CellContext`A], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "8", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "[", "U", "]"}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "U"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`U],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"TT", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "b"}]}], "]"}], ",", "M3", ",", 
     RowBox[{"PrintAs", "\[Rule]", "\"\<\[Tau]\>\""}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TT", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`TT[$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "9", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FirstCharacter", "[", "symbol_", "]"}], ":=", 
     RowBox[{"First", "[", 
      RowBox[{"Characters", "[", 
       RowBox[{"ToString", "[", "symbol", "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"DefTensor", "[", 
     RowBox[{
      RowBox[{"Force", "[", "a", "]"}], ",", "M3", ",", 
      RowBox[{"PrintAs", "\[Rule]", "FirstCharacter"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Force", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Force[$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "10", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "[", "Force", "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "Force"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`Force],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "[", "TT", "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "TT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`TT],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Remove", ",", "\[IndentingNewLine]", 
   RowBox[{"Remove", "[", 
    RowBox[{"FirstCharacter", ",", "symbol"}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Remove",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Validate", ",", "\[IndentingNewLine]", 
   RowBox[{"Validate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{"a", ",", "b", ",", 
        RowBox[{"-", "c"}]}], "]"}], 
      RowBox[{"S", "[", 
       RowBox[{"c", ",", "d"}], "]"}], 
      RowBox[{"v", "[", 
       RowBox[{"-", "d"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"r", "[", "]"}], "^", "3"}], 
      RowBox[{"S", "[", 
       RowBox[{"a", ",", "b"}], "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"r", "[", "]"}], "^", "3"}], 
     RowBox[{"S", "[", 
      RowBox[{"a", ",", "b"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ERROR", "[", 
      RowBox[{"v", "[", 
       RowBox[{"-", "d"}], "]"}], "]"}], 
     RowBox[{"S", "[", 
      RowBox[{"c", ",", "d"}], "]"}], 
     RowBox[{"T", "[", 
      RowBox[{"a", ",", "b", ",", 
       RowBox[{"-", "c"}]}], "]"}]}]}], ",", "\[IndentingNewLine]", "True"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Validate", "::", "error"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(\\\"Invalid character of index in tensor v\
\\\"\\)\[NoBreak]\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Validate",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Validate", ",", "\[IndentingNewLine]", 
   RowBox[{"Validate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
      RowBox[{"S", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", "d"}], "]"}], 
      RowBox[{"v", "[", 
       RowBox[{"-", "d"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"r", "[", "]"}], "^", "3"}], 
      RowBox[{"S", "[", 
       RowBox[{"a", ",", "b"}], "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"ERROR", "[", 
      RowBox[{"S", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", "d"}], "]"}], "]"}], 
     RowBox[{"ERROR", "[", 
      RowBox[{"T", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}], 
     RowBox[{"ERROR", "[", 
      RowBox[{"v", "[", 
       RowBox[{"-", "d"}], "]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{
      RowBox[{"r", "[", "]"}], "^", "3"}], 
     RowBox[{"S", "[", 
      RowBox[{"a", ",", "b"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
   "True"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Validate", "::", "error"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(\\\"Invalid character of index in tensor T\
\\\"\\)\[NoBreak]\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Validate", "::", "error"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(\\\"Invalid character of index in tensor S\
\\\"\\)\[NoBreak]\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Validate", "::", "error"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(\\\"Invalid character of index in tensor v\
\\\"\\)\[NoBreak]\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(Validate \
:: error\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Validate",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Validate", ",", "\[IndentingNewLine]", 
   RowBox[{"Validate", "[", 
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"a", ",", "b", ",", 
       RowBox[{"-", "c"}]}], "]"}], 
     RowBox[{"v", "[", 
      RowBox[{"-", "c"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", "Null", 
   ",", "\[IndentingNewLine]", "True"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Validate", "::", "repeated"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Found indices with the same name \
\[NoBreak]\\!\\(\\\"-c\\\"\\)\[NoBreak].\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Validate",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Validate", ",", "\[IndentingNewLine]", 
   RowBox[{"Validate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"v", "[", 
       RowBox[{"-", "b"}], "]"}]}], "+", 
     RowBox[{"v", "[", 
      RowBox[{"-", "a"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", "Null", 
   ",", "\[IndentingNewLine]", "True"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Validate", "::", "inhom"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Found inhomogeneous \[NoBreak]\\!\\(\\\"indices\\\"\\)\
\[NoBreak]: \[NoBreak]\\!\\(\\\"{IndexList[-a], \
IndexList[a]}\\\"\\)\[NoBreak].\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Validate",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Validate", ",", "\[IndentingNewLine]", 
   RowBox[{"Validate", "[", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"a", ",", "b"}], "]"}], 
     RowBox[{"v", "[", "b", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "True"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Validate", "::", "repeated"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Found indices with the same name \[NoBreak]\\!\\(\\\"b\\\"\
\\)\[NoBreak].\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Validate",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Validate", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"expr", "=", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"v", "[", "b", "]"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"Validate", "[", "expr", "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"v", "[", "b", "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Validate",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Validate", ",", "\[IndentingNewLine]", 
   RowBox[{"Validate", "[", 
    RowBox[{"Evaluate", "[", "expr", "]"}], "]"}], ",", "\[IndentingNewLine]",
    "Null", ",", "\[IndentingNewLine]", "True"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Validate", "::", "repeated"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Found indices with the same name \[NoBreak]\\!\\(\\\"b\\\"\
\\)\[NoBreak].\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Validate",
    HoldForm], ",", "8", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Remove", ",", "\[IndentingNewLine]", 
   RowBox[{"Remove", "[", "expr", "]"}], ",", "\[IndentingNewLine]", "Null", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Remove",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "[", "S", "]"}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "S"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`S],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Symmetric", ",", "\[IndentingNewLine]", 
   RowBox[{"Symmetric", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "xAct`xPerm`Cycles"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{"xAct`xPerm`Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], "]"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Symmetric",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Antisymmetric", ",", "\[IndentingNewLine]", 
   RowBox[{"Antisymmetric", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "xAct`xPerm`Cycles"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{"-", 
       RowBox[{"xAct`xPerm`Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], "]"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Antisymmetric",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"a", ",", "b"}], "]"}], ",", "M3", ",", 
     RowBox[{"Symmetric", "[", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`S[$CellContext`a, $CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "11", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"U", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], ",", "M3", ",", 
     RowBox[{"Antisymmetric", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"U", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`U[-$CellContext`a, -$CellContext`b, -$CellContext`c], ". ", 
   ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "12", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"W", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "M3", ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"xAct`xPerm`Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
       RowBox[{"xAct`xPerm`Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], "]"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "True"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"DefTensor", "::", "zero"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Symmetry makes tensor zero. Use VanishingQ \
instead.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "13", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"Q", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "b"}]}], "]"}], ",", "M3", ",", 
     RowBox[{"Symmetric", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "True"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"DefTensor", "::", "wrongsym"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Symmetry properties are inconsistent with indices of \
tensor.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "14", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"Q", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "b"}]}], "]"}], ",", "M3", ",", 
     RowBox[{"Symmetric", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"ForceSymmetries", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Q", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Q[$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "15", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"supereta", "[", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "g"}], ",", 
       RowBox[{"-", "h"}], ",", 
       RowBox[{"-", "h1"}]}], "]"}], ",", "M3", ",", 
     RowBox[{"Antisymmetric", "[", 
      RowBox[{"Range", "[", "8", "]"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Order of group of symmetry: \"\>", "\[InvisibleSpace]", 
   "40320", "\[InvisibleSpace]", "\<\" > 10000. ForceSymmetry check not \
performed.\"\>"}],
  SequenceForm[
  "  Order of group of symmetry: ", 40320, 
   " > 10000. ForceSymmetry check not performed."],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"supereta", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", 
     RowBox[{"-", "f"}], ",", 
     RowBox[{"-", "g"}], ",", 
     RowBox[{"-", "h"}], ",", 
     RowBox[{"-", "h1"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`supereta[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d, $CellContext`e, -$CellContext`f, -$CellContext`g, \
-$CellContext`h, -$CellContext`h1], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "16", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "/@", 
    RowBox[{"{", 
     RowBox[{"Q", ",", "supereta", ",", "U"}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"Null", ",", "Null", ",", "Null"}], "}"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "Q"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`Q],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "supereta"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`supereta],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "U"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`U],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Remove", ",", "\[IndentingNewLine]", 
   RowBox[{"Remove", "[", "W", "]"}], ",", "\[IndentingNewLine]", "Null", ",",
    "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Remove",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"delta", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"delta", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", "b"}], "]"}], "//", "Validate"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"delta", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", "b"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["delta",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"delta", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"delta", "[", 
     RowBox[{"a", ",", 
      RowBox[{"-", "b"}]}], "]"}], "//", "Validate"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ERROR", "[", 
    RowBox[{"delta", "[", 
     RowBox[{"a", ",", 
      RowBox[{"-", "b"}]}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   "True"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Validate", "::", "error"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(\\\"Invalid character of index in tensor \
delta\\\"\\)\[NoBreak]\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["delta",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"delta", ",", "\[IndentingNewLine]", 
   RowBox[{"delta", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", "a"}], "]"}], ",", "\[IndentingNewLine]", "3", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["delta",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"delta", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"delta", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", "b"}], "]"}], 
    RowBox[{"delta", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", "c"}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"delta", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", "c"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["delta",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"delta", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"delta", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", "a"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "a"}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"v", "[", 
    RowBox[{"-", "b"}], "]"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["delta",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"delta", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"delta", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", "b"}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{"a", ",", 
      RowBox[{"-", "b"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"S", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "a"}]}], "]"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["delta",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"delta", ",", "\[IndentingNewLine]", 
   RowBox[{"delta", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "\[IndentingNewLine]", "Null", ",", 
   "\[IndentingNewLine]", "True"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"MetricsOfVBundle", "::", "missing"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"There is no \[NoBreak]\\!\\(\\\"metric\\\"\\)\[NoBreak] in \
\[NoBreak]\\!\\(\\*InterpretationBox[StyleBox[\\\"\[DoubleStruckCapitalT]M3\\\
\", Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], TangentM3, \
Rule[Editable, False]]\\)\[NoBreak].\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["delta",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Gdelta", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Gdelta", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", "c", ",", "d"}], "]"}], "//", "Validate"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{"Gdelta", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", "c", ",", "d"}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Gdelta",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Gdelta", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Gdelta", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "a"}], ",", "c", ",", "d"}], "]"}], ",", 
      RowBox[{"Gdelta", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}], ",", "d", ",", "c"}], "]"}], ",", 
      RowBox[{"Gdelta", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "c"}], ",", "b", ",", "a"}], "]"}]}], "}"}], "//", 
    "ToCanonical"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Gdelta", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}], ",", "c", ",", "d"}], "]"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Gdelta", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}], ",", "c", ",", "d"}], "]"}]}], ",", 
     RowBox[{"Gdelta", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}], ",", "a", ",", "b"}], "]"}]}], "}"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Gdelta",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Gdelta", ",", "\[IndentingNewLine]", 
   RowBox[{"Gdelta", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "a", ",", "b", ",", "c"}], "]"}], ",", 
   "\[IndentingNewLine]", "6", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Gdelta",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Gdelta", ",", "\[IndentingNewLine]", 
   RowBox[{"Gdelta", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", "a", ",", "c", ",", "d", ",", "e"}], "]"}], ",",
    "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Gdelta",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Gdelta", ",", "\[IndentingNewLine]", 
   RowBox[{"Gdelta", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d", ",", "e", ",", "c"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Gdelta", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", "d", ",", "e"}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Gdelta",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ExpandGdelta", ",", "\[IndentingNewLine]", 
   RowBox[{"ExpandGdelta", "[", 
    RowBox[{"Gdelta", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", "d", ",", "e"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"delta", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", "e"}], "]"}]}], 
      RowBox[{"delta", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", "d"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"delta", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "d"}], "]"}], 
      RowBox[{"delta", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", "e"}], "]"}]}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ExpandGdelta",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Gdelta", ",", "\[IndentingNewLine]", 
   RowBox[{"Gdelta", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", "b"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"delta", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", "b"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Gdelta",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Sdelta", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sdelta", "[", 
      RowBox[{"RiemannSymmetric", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], "]"}], "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}], ",", "e", ",", "f", ",", "g", ",", "h"}], "]"}], "//",
     "Validate"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Sdelta", "[", 
     RowBox[{"StrongGenSet", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
       RowBox[{"GenSet", "[", 
        RowBox[{
         RowBox[{"xAct`xPerm`Cycles", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"1", ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"2", ",", "4"}], "}"}]}], "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"xAct`xPerm`Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
         RowBox[{"-", 
          RowBox[{"xAct`xPerm`Cycles", "[", 
           RowBox[{"{", 
            RowBox[{"3", ",", "4"}], "}"}], "]"}]}]}], "]"}]}], "]"}], "]"}], 
    "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}], ",", "e", ",", "f", ",", "g", ",", "h"}], "]"}], ",",
    "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Sdelta",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Sdelta", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Sdelta", "[", 
      RowBox[{"RiemannSymmetric", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], "]"}], "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}], ",", "e", ",", "f", ",", "g", ",", "h"}], "]"}], "//",
     "ExpandSdelta"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", "h"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "b"}], ",", "g"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", "f"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "d"}], ",", "e"}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", "g"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "b"}], ",", "h"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", "f"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "d"}], ",", "e"}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", "h"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "b"}], ",", "g"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", "e"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "d"}], ",", "f"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", "g"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "b"}], ",", "h"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", "e"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "d"}], ",", "f"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", "f"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "b"}], ",", "e"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", "h"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "d"}], ",", "g"}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", "e"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "b"}], ",", "f"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", "h"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "d"}], ",", "g"}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", "f"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "b"}], ",", "e"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", "g"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "d"}], ",", "h"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", "e"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "b"}], ",", "f"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "c"}], ",", "g"}], "]"}], "*", 
        RowBox[{"delta", "[", 
         RowBox[{
          RowBox[{"-", "d"}], ",", "h"}], "]"}]}]}], ")"}], "/", "8"}], "//", 
    "Evaluate"}], ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Sdelta",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Dir", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{"a", ",", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", 
        RowBox[{"-", "c"}], "]"}], "]"}]}], "]"}], "//", "Validate"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"S", "[", 
    RowBox[{"a", ",", 
     RowBox[{"Dir", "[", 
      RowBox[{"v", "[", 
       RowBox[{"-", "c"}], "]"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   "True"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Validate", "::", "error"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(\\\"Invalid character of index in tensor v\
\\\"\\)\[NoBreak]\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Dir",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Dir", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{"a", ",", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", "c", "]"}], "]"}]}], "]"}], "//", "Validate"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ERROR", "[", 
    RowBox[{"S", "[", 
     RowBox[{"a", ",", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", "c", "]"}], "]"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "True"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Validate", "::", "error"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(\\\"Invalid character of index in tensor S\
\\\"\\)\[NoBreak]\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Dir",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"w", "[", "a", "]"}], ",", "M3"}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"w", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`w[$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "17", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Dir", ",", "\[IndentingNewLine]", 
   RowBox[{"S", "[", 
    RowBox[{"a", ",", 
     RowBox[{"Dir", "[", 
      RowBox[{
       RowBox[{"3", 
        RowBox[{"v", "[", 
         RowBox[{"-", "c"}], "]"}]}], "+", 
       RowBox[{"w", "[", 
        RowBox[{"-", "c"}], "]"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"3", 
     RowBox[{"S", "[", 
      RowBox[{"a", ",", 
       RowBox[{"Dir", "[", 
        RowBox[{"v", "[", 
         RowBox[{"-", "c"}], "]"}], "]"}]}], "]"}]}], "+", 
    RowBox[{"S", "[", 
     RowBox[{"a", ",", 
      RowBox[{"Dir", "[", 
       RowBox[{"w", "[", 
        RowBox[{"-", "c"}], "]"}], "]"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Dir",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "[", "w", "]"}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "w"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`w],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "8", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UpVectorQ", ",", "\[IndentingNewLine]", 
   RowBox[{"UpVectorQ", "[", 
    RowBox[{"S", "[", 
     RowBox[{"a", ",", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", 
        RowBox[{"-", "c"}], "]"}], "]"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "True", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UpVectorQ",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SeparateDir", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dirv", "=", 
     RowBox[{"Dir", "[", 
      RowBox[{"v", "[", "c", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SeparateDir", "[", 
      RowBox[{
       RowBox[{"S", "[", 
        RowBox[{"a", ",", "dirv"}], "]"}], ",", "v"}], "]"}], "//", 
     "ScreenDollarIndices"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{"a", ",", 
      RowBox[{"-", "b"}]}], "]"}], 
    RowBox[{"v", "[", "b", "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SeparateDir",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ContractDir", ",", "\[IndentingNewLine]", 
   RowBox[{"ContractDir", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "b"}]}], "]"}], 
      RowBox[{"v", "[", "b", "]"}]}], ",", "v"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"S", "[", 
    RowBox[{"a", ",", 
     RowBox[{"Dir", "[", 
      RowBox[{"v", "[", "b", "]"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ContractDir",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Remove", ",", "\[IndentingNewLine]", 
   RowBox[{"Remove", "[", "dirv", "]"}], ",", "\[IndentingNewLine]", "Null", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Remove",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"Y", "[", 
      RowBox[{
       RowBox[{"LI", "@", "l"}], ",", 
       RowBox[{"LI", "@", "m"}]}], "]"}], ",", "S2"}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Y", "[", 
    RowBox[{
     RowBox[{"LI", "[", "l", "]"}], ",", 
     RowBox[{"LI", "[", "m", "]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Y[
    xAct`xTensor`LI[$CellContext`l], 
    xAct`xTensor`LI[$CellContext`m]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "18", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "[", "Y", "]"}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "Y"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`Y],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "9", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Remove", ",", "\[IndentingNewLine]", 
   RowBox[{"Remove", "[", 
    RowBox[{"l", ",", "m"}], "]"}], ",", "\[IndentingNewLine]", "Null", ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Remove",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"V", "[", 
      RowBox[{"a", ",", "\[GothicCapitalB]"}], "]"}], ",", "TangentM3", ",", 
     RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V", "[", 
    RowBox[{"a", ",", "\[GothicCapitalB]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V[$CellContext`a, $CellContext`\[GothicCapitalB]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V\[Dagger]", "[", 
    RowBox[{"a", ",", "\[GothicCapitalB]\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V\[Dagger][$CellContext`a, $CellContext`\[GothicCapitalB]\
\[Dagger]], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "19", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Dagger", ",", "\[IndentingNewLine]", 
   RowBox[{"Dagger", "[", 
    RowBox[{"V", "[", 
     RowBox[{"a", ",", "\[GothicCapitalC]"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"V\[Dagger]", "[", 
    RowBox[{"a", ",", "\[GothicCapitalC]\[Dagger]"}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Dagger",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "[", "V", "]"}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V\[Dagger]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "10", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DaggerIndex", ",", "\[IndentingNewLine]", 
   RowBox[{"DaggerIndex", "/@", 
    RowBox[{"{", 
     RowBox[{"a", ",", 
      RowBox[{"-", "b"}], ",", "\[GothicCapitalA]", ",", 
      RowBox[{"-", "\[GothicCapitalB]\[Dagger]"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", "\[GothicCapitalA]\[Dagger]", ",", 
     RowBox[{"-", "\[GothicCapitalB]"}]}], "}"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DaggerIndex",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"V", "[", "a", "]"}], ",", "M3"}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V[$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "20", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Dagger", ",", "\[IndentingNewLine]", 
   RowBox[{"Dagger", "[", 
    RowBox[{"3", "I", " ", 
     RowBox[{"V", "[", "a", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "I"}], ")"}], " ", 
     RowBox[{"V", "[", "a", "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Dagger",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "[", "V", "]"}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "11", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"V", "[", "a", "]"}], ",", "M3", ",", 
     RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V[$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V\[Dagger]", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V\[Dagger][$CellContext`a], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "21", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Dagger", ",", "\[IndentingNewLine]", 
   RowBox[{"Dagger", "[", 
    RowBox[{"3", "I", " ", 
     RowBox[{"V", "[", "a", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], "I", " ", 
     RowBox[{"V\[Dagger]", "[", "a", "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Dagger",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "[", "V", "]"}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V\[Dagger]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "12", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"V", "[", "\[GothicCapitalA]", "]"}], ",", "M3"}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "True"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"DefTensor", "::", "invalid"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(Real\\)\[NoBreak] is not a valid \
\[NoBreak]\\!\\(\\\"value for Dagger: complex \
indices\\\"\\)\[NoBreak].\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "22", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"V", "[", "\[GothicCapitalA]", "]"}], ",", "M3", ",", 
     RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V", "[", "\[GothicCapitalA]", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V[$CellContext`\[GothicCapitalA]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V\[Dagger]", "[", "\[GothicCapitalA]\[Dagger]", "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V\[Dagger][$CellContext`\[GothicCapitalA]\[Dagger]], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "23", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Dagger", ",", "\[IndentingNewLine]", 
   RowBox[{"Dagger", "[", 
    RowBox[{"3", "I", " ", 
     RowBox[{"V", "[", "\[GothicCapitalA]", "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], "I", " ", 
     RowBox[{"V\[Dagger]", "[", "\[GothicCapitalA]\[Dagger]", "]"}]}], "//", 
    "Evaluate"}], ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Dagger",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "[", "V", "]"}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V\[Dagger]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "13", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"V", "[", 
      RowBox[{
      "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", 
       "\[GothicCapitalC]\[Dagger]", ",", "\[GothicCapitalD]\[Dagger]"}], 
      "]"}], ",", "M3", ",", 
     RowBox[{"Dagger", "\[Rule]", "Hermitian"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V", "[", 
    RowBox[{
    "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", 
     "\[GothicCapitalC]\[Dagger]", ",", "\[GothicCapitalD]\[Dagger]"}], "]"}],
    "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V[$CellContext`\[GothicCapitalA], $CellContext`\
\[GothicCapitalB], $CellContext`\[GothicCapitalC]\[Dagger], $CellContext`\
\[GothicCapitalD]\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V\[Dagger]", "[", 
    RowBox[{
    "\[GothicCapitalA]\[Dagger]", ",", "\[GothicCapitalB]\[Dagger]", ",", 
     "\[GothicCapitalC]", ",", "\[GothicCapitalD]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V\[Dagger][$CellContext`\[GothicCapitalA]\[Dagger], \
$CellContext`\[GothicCapitalB]\[Dagger], $CellContext`\[GothicCapitalC], \
$CellContext`\[GothicCapitalD]], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "24", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Dagger", ",", "\[IndentingNewLine]", 
   RowBox[{"Dagger", "[", 
    RowBox[{"V", "[", 
     RowBox[{
     "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", 
      "\[GothicCapitalC]\[Dagger]", ",", "\[GothicCapitalD]\[Dagger]"}], 
     "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"V", "[", 
    RowBox[{
    "\[GothicCapitalC]", ",", "\[GothicCapitalD]", ",", 
     "\[GothicCapitalA]\[Dagger]", ",", "\[GothicCapitalB]\[Dagger]"}], "]"}],
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Dagger",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Dagger", ",", "\[IndentingNewLine]", 
   RowBox[{"Dagger", "[", 
    RowBox[{"V\[Dagger]", "[", 
     RowBox[{
     "\[GothicCapitalA]\[Dagger]", ",", "\[GothicCapitalB]\[Dagger]", ",", 
      "\[GothicCapitalC]", ",", "\[GothicCapitalD]"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"V", "[", 
    RowBox[{
    "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", 
     "\[GothicCapitalC]\[Dagger]", ",", "\[GothicCapitalD]\[Dagger]"}], "]"}],
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Dagger",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"W", "[", 
      RowBox[{
      "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", 
       "\[GothicCapitalC]\[Dagger]"}], "]"}], ",", "M3", ",", 
     RowBox[{"Dagger", "\[Rule]", "Hermitian"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "True"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"TransposeDagger", "::", "error3"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(\\\"Different number of indices of\\\"\\)\
\[NoBreak] \[NoBreak]\\!\\(\\*InterpretationBox[StyleBox[\\\"InnerC\\\", \
Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], InnerC, \
Rule[Editable, False]]\\)\[NoBreak] \[NoBreak]\\!\\(\\\"and its conjugate\\\"\
\\)\[NoBreak] \[NoBreak]\\!\\(\\*InterpretationBox[StyleBox[\\\"InnerC\
\[Dagger]\\\", Rule[AutoSpacing, False], Rule[ShowAutoStyles, False]], InnerC\
\\\\[Dagger], Rule[Editable, False]]\\)\[NoBreak]\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "25", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "[", "V", "]"}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V\[Dagger]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "14", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"V", "[", 
      RowBox[{
      "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", 
       "\[GothicCapitalC]\[Dagger]", ",", "\[GothicCapitalD]\[Dagger]", ",", 
       "\[GothicCapitalE]", ",", "\[GothicCapitalF]\[Dagger]"}], "]"}], ",", 
     "M3", ",", 
     RowBox[{"Dagger", "\[Rule]", "Hermitian"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V", "[", 
    RowBox[{
    "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", 
     "\[GothicCapitalC]\[Dagger]", ",", "\[GothicCapitalD]\[Dagger]", ",", 
     "\[GothicCapitalE]", ",", "\[GothicCapitalF]\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V[$CellContext`\[GothicCapitalA], $CellContext`\
\[GothicCapitalB], $CellContext`\[GothicCapitalC]\[Dagger], $CellContext`\
\[GothicCapitalD]\[Dagger], $CellContext`\[GothicCapitalE], $CellContext`\
\[GothicCapitalF]\[Dagger]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"V\[Dagger]", "[", 
    RowBox[{
    "\[GothicCapitalA]\[Dagger]", ",", "\[GothicCapitalB]\[Dagger]", ",", 
     "\[GothicCapitalC]", ",", "\[GothicCapitalD]", ",", 
     "\[GothicCapitalE]\[Dagger]", ",", "\[GothicCapitalF]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`V\[Dagger][$CellContext`\[GothicCapitalA]\[Dagger], \
$CellContext`\[GothicCapitalB]\[Dagger], $CellContext`\[GothicCapitalC], \
$CellContext`\[GothicCapitalD], $CellContext`\[GothicCapitalE]\[Dagger], \
$CellContext`\[GothicCapitalF]], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "26", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Dagger", ",", "\[IndentingNewLine]", 
   RowBox[{"Dagger", "[", 
    RowBox[{"V", "[", 
     RowBox[{
     "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", 
      "\[GothicCapitalC]\[Dagger]", ",", "\[GothicCapitalD]\[Dagger]", ",", 
      "\[GothicCapitalE]", ",", "\[GothicCapitalF]\[Dagger]"}], "]"}], "]"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{"V", "[", 
    RowBox[{
    "\[GothicCapitalC]", ",", "\[GothicCapitalD]", ",", 
     "\[GothicCapitalA]\[Dagger]", ",", "\[GothicCapitalB]\[Dagger]", ",", 
     "\[GothicCapitalF]", ",", "\[GothicCapitalE]\[Dagger]"}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Dagger",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "[", "V", "]"}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V\[Dagger]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "V"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`V],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "15", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{
  "$DaggerCharacter", ",", "\[IndentingNewLine]", "$DaggerCharacter", ",", 
   "\[IndentingNewLine]", "\"\<\[Dagger]\>\"", ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["$DaggerCharacter",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Remove", ",", "\[IndentingNewLine]", 
   RowBox[{"Remove", "[", "W", "]"}], ",", "\[IndentingNewLine]", "Null", ",",
    "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Remove",
    HoldForm], ",", "8", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"Z", "[", 
      RowBox[{"AnyIndices", "@", "TangentM3"}], "]"}], ",", "M3"}], "]"}], 
   ",", "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Z", "[", 
    RowBox[{"AnyIndices", "[", 
     InterpretationBox[
      StyleBox["\[DoubleStruckCapitalT]M3",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`TangentM3,
      Editable->False], "]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Z[
    xAct`xTensor`AnyIndices[$CellContext`TangentM3]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "27", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SymmetryGroupOfTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"SymmetryGroupOfTensor", "[", "Z", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SymmetryGroupOfTensor",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SymmetryGroupOfTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"SymmetryGroupOfTensor", "[", 
    RowBox[{"Z", "[", "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SymmetryGroupOfTensor",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SymmetryGroupOfTensor", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SymmetryGroupOfTensor", "[", 
      RowBox[{"Z", "[", "inds___", "]"}], "]"}], "^:=", 
     RowBox[{"Symmetric", "[", 
      RowBox[{"Range", "[", 
       RowBox[{"Length", "[", 
        RowBox[{"{", "inds", "}"}], "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"SymmetryGroupOfTensor", "[", 
     RowBox[{"Z", "[", "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", "}"}], "]"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SymmetryGroupOfTensor",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SymmetryGroupOfTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"SymmetryGroupOfTensor", "[", 
    RowBox[{"Z", "[", 
     RowBox[{"a", ",", "b"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SymmetryGroupOfTensor",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SymmetryGroupOfTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"SymmetryGroupOfTensor", "[", 
    RowBox[{"Z", "[", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SymmetryGroupOfTensor",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "[", "Z", "]"}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "Z"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`Z],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "16", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Remove", ",", "\[IndentingNewLine]", 
   RowBox[{"Remove", "[", "inds", "]"}], ",", "\[IndentingNewLine]", "Null", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Remove",
    HoldForm], ",", "9", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{
  "$Tensors", ",", "\[IndentingNewLine]", "$Tensors", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"T", ",", "v", ",", "r", ",", "S"}], "}"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["$Tensors",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "/@", "$Tensors"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"Null", ",", "Null", ",", "Null", ",", "Null"}], "}"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "T"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`T],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "v"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`v],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "r"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`r],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "S"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`S],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "17", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefManifold", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefManifold", "[", "M3", "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "True"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "noundef"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(\\\"Symbol\\\"\\)\[NoBreak] \
\[NoBreak]\\!\\(M3\\)\[NoBreak] cannot be undefined because \
\[NoBreak]\\!\\(\\\"it has visitors\\\"\\)\[NoBreak].\"\>"}]], "Message", \
"MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefManifold",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefVBundle", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefVBundle", "[", "InnerC", "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"conjugated vbundle\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["InnerC\[Dagger]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`InnerC\[Dagger],
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "conjugated vbundle", 
   " ", $CellContext`InnerC\[Dagger]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["InnerC",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`InnerC,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`InnerC],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefVBundle",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefManifold", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefManifold", "[", "S2", "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["\[DoubleStruckCapitalT]S2",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TangentS2,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`TangentS2],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefManifold", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"manifold\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "S2"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefManifold, ": Undefined ", "manifold", 
   " ", $CellContext`S2],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefManifold",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefManifold", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefManifold", "[", "M3", "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["\[DoubleStruckCapitalT]M3",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TangentM3,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`TangentM3],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefManifold", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"manifold\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "M3"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefManifold, ": Undefined ", "manifold", 
   " ", $CellContext`M3],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefManifold",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefParameter", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefParameter", "[", "time", "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefParameter", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"parameter\"\>", "\[InvisibleSpace]", "\<\" \"\>",
    "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["time",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`time,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefParameter, ": Undefined ", "parameter", 
   " ", $CellContext`time],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefParameter",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Names", ",", "\[IndentingNewLine]", 
   RowBox[{"Names", "[", "\"\<Global`*\>\"", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Names",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4. Canonicalization", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefManifold", ",", "\[IndentingNewLine]", 
   RowBox[{"DefManifold", "[", 
    RowBox[{"M3", ",", "3", ",", 
     RowBox[{"{", 
      RowBox[{
      "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
       "h", ",", "i", ",", "j"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M3, ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM3", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM3, ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefManifold",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"U", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], ",", "M3", ",", 
     RowBox[{"Antisymmetric", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"U", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`U[-$CellContext`a, -$CellContext`b, -$CellContext`c], ". ", 
   ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "28", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"a", ",", "b"}], "]"}], ",", "M3"}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"S", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`S[$CellContext`a, $CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "29", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"v", "[", "a", "]"}], ",", "M3"}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v[$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "30", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{"U", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"U", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "d"}]}], "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{"U", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "+", 
     RowBox[{"U", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", "0", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"v", "[", 
       RowBox[{"-", "b"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"a", ",", "c"}], "]"}], 
      RowBox[{"v", "[", 
       RowBox[{"-", "c"}], "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"2", 
    RowBox[{"S", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "b"}], "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{"U", "[", 
      RowBox[{"b", ",", "c", ",", "a"}], "]"}], 
     RowBox[{"v", "[", 
      RowBox[{"-", "b"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"U", "[", 
       RowBox[{"a", ",", "c", ",", "b"}], "]"}]}], 
     RowBox[{"v", "[", 
      RowBox[{"-", "b"}], "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{
  "$xpermQ", ",", "\[IndentingNewLine]", "$xpermQ", ",", 
   "\[IndentingNewLine]", "True", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["$xpermQ",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"Anti", "[", 
      RowBox[{"a", ",", "b"}], "]"}], ",", "M3", ",", 
     RowBox[{"Antisymmetric", "[", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], "]"}], ",", 
     RowBox[{"PrintAs", "\[Rule]", "\"\<A\>\""}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Anti", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Anti[$CellContext`a, $CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "31", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefMetric", ",", "\[IndentingNewLine]", 
   RowBox[{"DefMetric", "[", 
    RowBox[{"1", ",", 
     RowBox[{"metricg", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], ",", "cd"}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"metricg", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`metricg[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilonmetricg", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilonmetricg[-$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"cd", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`cd[-$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"Torsioncd", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`Torsioncd[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"Christoffelcd", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`Christoffelcd[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Riemanncd", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`Riemanncd[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"Riccicd", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`Riccicd[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarcd", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarcd[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"Einsteincd", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`Einsteincd[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Weylcd", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Weyl tensor ", 
   $CellContext`Weylcd[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRiccicd", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRiccicd[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"Kretschmanncd", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`Kretschmanncd[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 3],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 3],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 3],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detmetricg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detmetricg[], ". ", "Determinant."],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefMetric",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "[", 
  RowBox[{"Anti", "[", 
   RowBox[{"a", ",", 
    RowBox[{"-", "a"}]}], "]"}], "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCanonical", "[", 
  RowBox[{
   RowBox[{"Anti", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "a"}]}], "]"}], ",", 
   RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}]], "Input"],

Cell[BoxData["0"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{"Anti", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "a"}]}], "]"}], ",", 
     RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Anti", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "a"}]}], "]"}]}], ",", 
     RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}]}], "]"}]}], 
     RowBox[{"Anti", "[", 
      RowBox[{"a", ",", "b"}], "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Anti", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"c", ",", 
        RowBox[{"-", "a"}]}], "]"}]}], ",", 
     RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Anti", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"c", ",", "d"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "a"}]}], "]"}]}], ",", 
     RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Anti", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", "c"}], "]"}], 
    RowBox[{"Anti", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"Anti", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", "d"}], "]"}], 
    RowBox[{"Anti", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "8", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Anti", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"c", ",", "d"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "a"}]}], "]"}]}], ",", 
     RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "9", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Anti", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"c", ",", "d"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"e", ",", "f"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "f"}], ",", 
        RowBox[{"-", "a"}]}], "]"}]}], ",", 
     RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "c"}], "]"}]}], 
     RowBox[{"Anti", "[", 
      RowBox[{"a", ",", "b"}], "]"}], 
     RowBox[{"Anti", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", "d"}], "]"}], 
     RowBox[{"Anti", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", "e"}], "]"}], 
     RowBox[{"Anti", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", "f"}], "]"}], 
     RowBox[{"Anti", "[", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "f"}]}], "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "10", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Anti", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"c", ",", "d"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"e", ",", "f"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "f"}], ",", 
        RowBox[{"-", "g"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"g", ",", 
        RowBox[{"-", "a"}]}], "]"}]}], ",", 
     RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "11", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{"Anti", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "a"}]}], "]"}], ",", 
     RowBox[{"MathLink", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "12", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Anti", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "a"}]}], "]"}]}], ",", 
     RowBox[{"MathLink", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}]}], "]"}]}], 
     RowBox[{"Anti", "[", 
      RowBox[{"a", ",", "b"}], "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "13", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Anti", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"c", ",", 
        RowBox[{"-", "a"}]}], "]"}]}], ",", 
     RowBox[{"MathLink", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "14", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Anti", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"c", ",", "d"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "a"}]}], "]"}]}], ",", 
     RowBox[{"MathLink", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Anti", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", "c"}], "]"}], 
    RowBox[{"Anti", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"Anti", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", "d"}], "]"}], 
    RowBox[{"Anti", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "15", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Anti", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"c", ",", "d"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "a"}]}], "]"}]}], ",", 
     RowBox[{"MathLink", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "16", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Anti", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"c", ",", "d"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"e", ",", "f"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "f"}], ",", 
        RowBox[{"-", "a"}]}], "]"}]}], ",", 
     RowBox[{"MathLink", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "c"}], "]"}]}], 
     RowBox[{"Anti", "[", 
      RowBox[{"a", ",", "b"}], "]"}], 
     RowBox[{"Anti", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", "d"}], "]"}], 
     RowBox[{"Anti", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", "e"}], "]"}], 
     RowBox[{"Anti", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", "f"}], "]"}], 
     RowBox[{"Anti", "[", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "f"}]}], "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "17", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Anti", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"c", ",", "d"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"e", ",", "f"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "f"}], ",", 
        RowBox[{"-", "g"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"g", ",", 
        RowBox[{"-", "a"}]}], "]"}]}], ",", 
     RowBox[{"MathLink", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "18", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndicesOfVBundle", ",", "\[IndentingNewLine]", 
   RowBox[{"IndicesOfVBundle", "[", "TangentM3", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
       "h", ",", "i", ",", "j"}], "}"}], ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndicesOfVBundle",
    HoldForm], ",", "9", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndexSort", ",", "\[IndentingNewLine]", 
   RowBox[{"IndexSort", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "i", ",", "j", ",", 
      RowBox[{"-", "e"}], ",", "d", ",", "c", ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "j"}], ",", "e", ",", "f"}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"IndexList", "[", 
    RowBox[{"a", ",", "b", ",", "d", ",", "f", ",", "i", ",", "c", ",", 
     RowBox[{"-", "c"}], ",", "e", ",", 
     RowBox[{"-", "e"}], ",", "j", ",", 
     RowBox[{"-", "j"}]}], "]"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndexSort",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SetIndexSortPriorities", ",", "\[IndentingNewLine]", 
   RowBox[{"SetIndexSortPriorities", "[", 
    RowBox[{
    "\"\<down\>\"", ",", "\"\<free\>\"", ",", "\"\<antilexicographic\>\""}], 
    "]"}], ",", "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SetIndexSortPriorities",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndexSort", ",", "\[IndentingNewLine]", 
   RowBox[{"IndexSort", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "i", ",", "j", ",", 
      RowBox[{"-", "e"}], ",", "d", ",", "c", ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "j"}], ",", "e", ",", "f"}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"IndexList", "[", 
    RowBox[{
     RowBox[{"-", "j"}], ",", 
     RowBox[{"-", "e"}], ",", 
     RowBox[{"-", "c"}], ",", "i", ",", "f", ",", "d", ",", "b", ",", "a", 
     ",", "j", ",", "e", ",", "c"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndexSort",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SetIndexSortPriorities", ",", "\[IndentingNewLine]", 
   RowBox[{"SetIndexSortPriorities", "[", 
    RowBox[{"\"\<positional\>\"", ",", "\"\<down\>\"", ",", "\"\<dummy\>\""}],
     "]"}], ",", "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SetIndexSortPriorities",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndexSort", ",", "\[IndentingNewLine]", 
   RowBox[{"IndexSort", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "i", ",", "j", ",", 
      RowBox[{"-", "e"}], ",", "d", ",", "c", ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "j"}], ",", "e", ",", "f"}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"IndexList", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"-", "c"}], ",", "c", ",", "d", ",", 
     RowBox[{"-", "e"}], ",", "e", ",", "f", ",", "i", ",", 
     RowBox[{"-", "j"}], ",", "j"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndexSort",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SetIndexSortPriorities", ",", "\[IndentingNewLine]", 
   RowBox[{"SetIndexSortPriorities", "[", 
    RowBox[{"\"\<up\>\"", ",", "\"\<free\>\"", ",", "\"\<lexicographic\>\""}],
     "]"}], ",", "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SetIndexSortPriorities",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Anti", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"c", ",", "d"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"e", ",", "f"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "f"}], ",", 
        RowBox[{"-", "a"}]}], "]"}]}], ",", 
     RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}]}], "]"}]}], 
     RowBox[{"Anti", "[", 
      RowBox[{"a", ",", "b"}], "]"}], 
     RowBox[{"Anti", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], 
     RowBox[{"Anti", "[", 
      RowBox[{"c", ",", "d"}], "]"}], 
     RowBox[{"Anti", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], 
     RowBox[{"Anti", "[", 
      RowBox[{"e", ",", "f"}], "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "19", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SetIndexSortPriorities", ",", "\[IndentingNewLine]", 
   RowBox[{"SetIndexSortPriorities", "[", 
    RowBox[{"\"\<free\>\"", ",", "\"\<lexicographic\>\"", ",", "\"\<up\>\""}],
     "]"}], ",", "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SetIndexSortPriorities",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Anti", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"c", ",", "d"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{"e", ",", "f"}], "]"}], 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "f"}], ",", 
        RowBox[{"-", "a"}]}], "]"}]}], ",", 
     RowBox[{"MathLink", "\[Rule]", "False"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Anti", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "c"}], "]"}]}], 
     RowBox[{"Anti", "[", 
      RowBox[{"a", ",", "b"}], "]"}], 
     RowBox[{"Anti", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", "d"}], "]"}], 
     RowBox[{"Anti", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", "e"}], "]"}], 
     RowBox[{"Anti", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", "f"}], "]"}], 
     RowBox[{"Anti", "[", 
      RowBox[{
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "f"}]}], "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "20", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "[", "Anti", "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "Anti"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`Anti],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "18", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefManifold", ",", "\[IndentingNewLine]", 
   RowBox[{"DefManifold", "[", 
    RowBox[{"M1", ",", "1", ",", 
     RowBox[{"{", 
      RowBox[{"a1", ",", "b1", ",", "c1", ",", "d1"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "M1", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`M1, ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentM1", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentM1, ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefManifold",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DefTensor", "[", 
     RowBox[{
      RowBox[{"W", "[", 
       RowBox[{"a1", ",", "b1"}], "]"}], ",", "M1"}], "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"DefTensor", "[", 
     RowBox[{
      RowBox[{"R", "[", 
       RowBox[{"a1", ",", "b1"}], "]"}], ",", "M1"}], "]"}]}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"W", "[", 
    RowBox[{"a1", ",", "b1"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`W[$CellContext`a1, $CellContext`b1], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"R", "[", 
    RowBox[{"a1", ",", "b1"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`R[$CellContext`a1, $CellContext`b1], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "32", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"W", "[", 
       RowBox[{"a1", ",", "b1"}], "]"}], 
      RowBox[{"R", "[", 
       RowBox[{"c1", ",", "d1"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"W", "[", 
       RowBox[{"d1", ",", "a1"}], "]"}], 
      RowBox[{"R", "[", 
       RowBox[{"c1", ",", "b1"}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "21", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "/@", 
    RowBox[{"{", 
     RowBox[{"W", ",", "R"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"Null", ",", "Null"}], "}"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "W"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`W],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "R"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`R],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "19", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefManifold", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefManifold", "[", "M1", "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefVBundle", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["\[DoubleStruckCapitalT]M1",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`TangentM1,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefVBundle, ": Undefined ", "vbundle", 
   " ", $CellContext`TangentM1],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefManifold", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"manifold\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "M1"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefManifold, ": Undefined ", "manifold", 
   " ", $CellContext`M1],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefManifold",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["5. Rules and patterns", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"w", "[", "a", "]"}], ",", "M3"}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"w", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`w[$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "33", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Set", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "[", "a_", "]"}], "=", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"a", ",", "b"}], "]"}], 
     RowBox[{"v", "[", 
      RowBox[{"-", "b"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "b"}], "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Set",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Set", ",", "\[IndentingNewLine]", 
   RowBox[{"w", "[", "b", "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{"b", ",", "b"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "b"}], "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Set",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Set", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "[", "a", "]"}], 
    RowBox[{"w", "[", 
     RowBox[{"-", "a"}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", "b"}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{
     RowBox[{"v", "[", 
      RowBox[{"-", "b"}], "]"}], "^", "2"}]}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Set",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Module", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "[", "a_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "b", "}"}], ",", 
      RowBox[{
       RowBox[{"S", "[", 
        RowBox[{"a", ",", "b"}], "]"}], 
       RowBox[{"v", "[", 
        RowBox[{"-", "b"}], "]"}]}]}], "]"}]}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Module",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Module", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "[", "b", "]"}], "//", "ScreenDollarIndices"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{"b", ",", "a"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "a"}], "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Module",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Module", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"w", "[", "a", "]"}], 
     RowBox[{"w", "[", 
      RowBox[{"-", "a"}], "]"}]}], "//", "ScreenDollarIndices"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", "c"}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "b"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "c"}], "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Module",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Module", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"w", "[", "a", "]"}], ",", 
      RowBox[{"w", "[", "b", "]"}], ",", 
      RowBox[{"w", "[", "c", "]"}], ",", 
      RowBox[{
       RowBox[{"w", "[", "a", "]"}], 
       RowBox[{"w", "[", 
        RowBox[{"-", "a"}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"w", "[", "a", "]"}], "-", 
       RowBox[{"w", "[", "a", "]"}]}]}], "}"}], "//", "ScreenDollarIndices"}],
    ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"v", "[", 
       RowBox[{"-", "b"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"b", ",", "a"}], "]"}], 
      RowBox[{"v", "[", 
       RowBox[{"-", "a"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"c", ",", "a"}], "]"}], 
      RowBox[{"v", "[", 
       RowBox[{"-", "a"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "c"}], "]"}], 
      RowBox[{"S", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"v", "[", 
       RowBox[{"-", "b"}], "]"}], 
      RowBox[{"v", "[", 
       RowBox[{"-", "c"}], "]"}]}], ",", "0"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Module",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndexSet", ",", "\[IndentingNewLine]", 
   RowBox[{"IndexSet", "[", 
    RowBox[{
     RowBox[{"w", "[", "a_", "]"}], ",", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"v", "[", 
       RowBox[{"-", "b"}], "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "b"}], "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndexSet",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndexSet", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "[", "b", "]"}], "//", "ScreenDollarIndices"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{"b", ",", "a"}], "]"}], 
    RowBox[{"v", "[", 
     RowBox[{"-", "a"}], "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndexSet",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "M3"}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"T", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`T[$CellContext`a, $CellContext`b, $CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "34", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndexSet", ",", "\[IndentingNewLine]", 
   RowBox[{"IndexSet", "[", 
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"a_", ",", "b_", ",", 
       RowBox[{"-", "b_"}]}], "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"a", ",", "b", ",", 
       RowBox[{"-", "b"}], ",", "c", ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"S", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"-", "b"}], ",", "c", ",", 
     RowBox[{"-", "c"}]}], "]"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndexSet",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndexSet", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"a", ",", "c", ",", 
      RowBox[{"-", "c"}]}], "]"}], "//", "ScreenDollarIndices"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"S", "[", 
    RowBox[{"a", ",", "c", ",", 
     RowBox[{"-", "c"}], ",", "b", ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndexSet",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndexSetDelayed", ",", "\[IndentingNewLine]", 
   RowBox[{"IndexSetDelayed", "[", 
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{
       RowBox[{"-", "a_"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], ",", 
     RowBox[{
      RowBox[{"w", "[", 
       RowBox[{"-", "a"}], "]"}], 
      RowBox[{"w", "[", 
       RowBox[{"-", "b"}], "]"}], 
      RowBox[{"w", "[", 
       RowBox[{"-", "c"}], "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndexSetDelayed",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndexSet", ",", "\[IndentingNewLine]", 
   RowBox[{"IndexSet", "[", 
    RowBox[{
     RowBox[{"w", "[", "a_", "]"}], ",", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"S", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], 
      RowBox[{"v", "[", "c", "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}]}], "]"}], 
    RowBox[{"v", "[", "c", "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndexSet",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndexSet", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}]}], "]"}], "//", "ScreenDollarIndices"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", "d"}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", "e"}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", "f"}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "g"}]}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "e"}], ",", 
      RowBox[{"-", "h"}]}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "f"}], ",", 
      RowBox[{"-", "i"}]}], "]"}], 
    RowBox[{"v", "[", "g", "]"}], 
    RowBox[{"v", "[", "h", "]"}], 
    RowBox[{"v", "[", "i", "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndexSet",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Unset", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{"a_", ",", "b_", ",", 
      RowBox[{"-", "b_"}]}], "]"}], "=."}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Unset",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Unset", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"T", "[", 
     RowBox[{
      RowBox[{"-", "a_"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}]}], "]"}], "=."}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Unset",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Unset", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "[", "a_", "]"}], "=."}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Unset",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SetDelayed", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dirvup", "=", 
     RowBox[{"Dir", "[", 
      RowBox[{"v", "[", "d", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"dirvdown", "=", 
     RowBox[{"Dir", "[", 
      RowBox[{"v", "[", 
       RowBox[{"-", "d"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"w", "[", "a_", "]"}], ":=", 
     RowBox[{"S", "[", "a", "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"w", "[", "a", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "a"}], "]"}], ",", 
      RowBox[{"w", "[", "dirvdown", "]"}], ",", 
      RowBox[{"w", "[", "dirvup", "]"}], ",", 
      RowBox[{"w", "[", "A", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "A"}], "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"S", "[", "a", "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"-", "a"}], "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", 
        RowBox[{"-", "d"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", "d", "]"}], "]"}], "]"}], ",", 
     RowBox[{"S", "[", "A", "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"-", "A"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", "False",
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "[", "a_", "]"}], "=."}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SetDelayed",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SetDelayed", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"w", "[", 
      RowBox[{"a_", "?", "UpIndexQ"}], "]"}], ":=", 
     RowBox[{"S", "[", "a", "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"w", "[", "a", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "a"}], "]"}], ",", 
      RowBox[{"w", "[", "dirvdown", "]"}], ",", 
      RowBox[{"w", "[", "dirvup", "]"}], ",", 
      RowBox[{"w", "[", "A", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "A"}], "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"S", "[", "a", "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"-", "a"}], "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", 
        RowBox[{"-", "d"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", "d", "]"}], "]"}], "]"}], ",", 
     RowBox[{"S", "[", "A", "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"-", "A"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", "False",
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "[", 
     RowBox[{"a_", "?", "UpIndexQ"}], "]"}], "=."}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SetDelayed",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SetDelayed", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"w", "[", 
      RowBox[{"a_", "?", "DownIndexQ"}], "]"}], ":=", 
     RowBox[{"S", "[", "a", "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"w", "[", "a", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "a"}], "]"}], ",", 
      RowBox[{"w", "[", "dirvdown", "]"}], ",", 
      RowBox[{"w", "[", "dirvup", "]"}], ",", 
      RowBox[{"w", "[", "A", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "A"}], "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"w", "[", "a", "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"-", "a"}], "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", 
        RowBox[{"-", "d"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", "d", "]"}], "]"}], "]"}], ",", 
     RowBox[{"w", "[", "A", "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"-", "A"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", "False",
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "[", 
     RowBox[{"a_", "?", "DownIndexQ"}], "]"}], "=."}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SetDelayed",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefManifold", ",", "\[IndentingNewLine]", 
   RowBox[{"DefManifold", "[", 
    RowBox[{"S2", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{"A", ",", "B", ",", "C", ",", "D", ",", "F", ",", "G"}], 
      "}"}]}], "]"}], ",", "\[IndentingNewLine]", "Null", ",", 
   "\[IndentingNewLine]", "True"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefManifold", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"manifold \"\>", "\[InvisibleSpace]", "S2", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefManifold, ": Defining ", 
   "manifold ", $CellContext`S2, ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "TangentS2", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`TangentS2, ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "capital"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"System name \[NoBreak]\\!\\(\\\"C\\\"\\)\[NoBreak] is \
overloaded as an abstract index.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"ValidateSymbol", "::", "capital"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"System name \[NoBreak]\\!\\(\\\"D\\\"\\)\[NoBreak] is \
overloaded as an abstract index.\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefManifold",
    HoldForm], ",", "8", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SetDelayed", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"w", "[", 
      RowBox[{"a_", "?", "AIndexQ"}], "]"}], ":=", 
     RowBox[{"S", "[", "a", "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"w", "[", "a", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "a"}], "]"}], ",", 
      RowBox[{"w", "[", "dirvdown", "]"}], ",", 
      RowBox[{"w", "[", "dirvup", "]"}], ",", 
      RowBox[{"w", "[", "A", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "A"}], "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"S", "[", "a", "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"-", "a"}], "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", 
        RowBox[{"-", "d"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", "d", "]"}], "]"}], "]"}], ",", 
     RowBox[{"S", "[", "A", "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"-", "A"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", "False",
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "[", 
     RowBox[{"a_", "?", "AIndexQ"}], "]"}], "=."}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SetDelayed",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SetDelayed", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"w", "[", "a_Symbol", "]"}], ":=", 
     RowBox[{"S", "[", "a", "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"w", "[", "a", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "a"}], "]"}], ",", 
      RowBox[{"w", "[", "dirvdown", "]"}], ",", 
      RowBox[{"w", "[", "dirvup", "]"}], ",", 
      RowBox[{"w", "[", "A", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "A"}], "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"S", "[", "a", "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"-", "a"}], "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", 
        RowBox[{"-", "d"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", "d", "]"}], "]"}], "]"}], ",", 
     RowBox[{"S", "[", "A", "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"-", "A"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", "False",
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "[", "a_Symbol", "]"}], "=."}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SetDelayed",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SetDelayed", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"w", "[", 
      RowBox[{"-", "a_Symbol"}], "]"}], ":=", 
     RowBox[{"S", "[", 
      RowBox[{"-", "a"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"w", "[", "a", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "a"}], "]"}], ",", 
      RowBox[{"w", "[", "dirvdown", "]"}], ",", 
      RowBox[{"w", "[", "dirvup", "]"}], ",", 
      RowBox[{"w", "[", "A", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "A"}], "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"w", "[", "a", "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"-", "a"}], "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", 
        RowBox[{"-", "d"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", "d", "]"}], "]"}], "]"}], ",", 
     RowBox[{"w", "[", "A", "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"-", "A"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", "False",
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "[", 
     RowBox[{"-", "a_Symbol"}], "]"}], "=."}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SetDelayed",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SetDelayed", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"w", "[", 
      RowBox[{"a_", "?", "DIndexQ"}], "]"}], ":=", 
     RowBox[{"S", "[", "a", "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"w", "[", "a", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "a"}], "]"}], ",", 
      RowBox[{"w", "[", "dirvdown", "]"}], ",", 
      RowBox[{"w", "[", "dirvup", "]"}], ",", 
      RowBox[{"w", "[", "A", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "A"}], "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"w", "[", "a", "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"-", "a"}], "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", 
        RowBox[{"-", "d"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", "d", "]"}], "]"}], "]"}], ",", 
     RowBox[{"w", "[", "A", "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"-", "A"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", "False",
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "[", 
     RowBox[{"a_", "?", "DIndexQ"}], "]"}], "=."}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SetDelayed",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SetDelayed", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"w", "[", "a_Dir", "]"}], ":=", 
     RowBox[{"S", "[", "a", "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"w", "[", "a", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "a"}], "]"}], ",", 
      RowBox[{"w", "[", "dirvdown", "]"}], ",", 
      RowBox[{"w", "[", "dirvup", "]"}], ",", 
      RowBox[{"w", "[", "A", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "A"}], "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"w", "[", "a", "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"-", "a"}], "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", 
        RowBox[{"-", "d"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", "d", "]"}], "]"}], "]"}], ",", 
     RowBox[{"w", "[", "A", "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"-", "A"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", "False",
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "[", "a_Dir", "]"}], "=."}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SetDelayed",
    HoldForm], ",", "8", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SetDelayed", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"w", "[", 
      RowBox[{"a_", "?", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"AIndexQ", "[", 
          RowBox[{"#", ",", "TangentM3"}], "]"}], "&"}], ")"}]}], "]"}], ":=", 
     RowBox[{"S", "[", "a", "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"w", "[", "a", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "a"}], "]"}], ",", 
      RowBox[{"w", "[", "dirvdown", "]"}], ",", 
      RowBox[{"w", "[", "dirvup", "]"}], ",", 
      RowBox[{"w", "[", "A", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "A"}], "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"S", "[", "a", "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"-", "a"}], "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", 
        RowBox[{"-", "d"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", "d", "]"}], "]"}], "]"}], ",", 
     RowBox[{"w", "[", "A", "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"-", "A"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", "False",
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "[", 
     RowBox[{"a_", "?", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"AIndexQ", "[", 
         RowBox[{"#", ",", "TangentM3"}], "]"}], "&"}], ")"}]}], "]"}], 
    "=."}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SetDelayed",
    HoldForm], ",", "9", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SetDelayed", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"w", "[", 
      RowBox[{"a_", "?", "TangentM3`Q"}], "]"}], ":=", 
     RowBox[{"S", "[", "a", "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"w", "[", "a", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "a"}], "]"}], ",", 
      RowBox[{"w", "[", "dirvdown", "]"}], ",", 
      RowBox[{"w", "[", "dirvup", "]"}], ",", 
      RowBox[{"w", "[", "A", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "A"}], "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"S", "[", "a", "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"-", "a"}], "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", 
        RowBox[{"-", "d"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", "d", "]"}], "]"}], "]"}], ",", 
     RowBox[{"w", "[", "A", "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"-", "A"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", "False",
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "[", 
     RowBox[{"a_", "?", "TangentM3`Q"}], "]"}], "=."}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SetDelayed",
    HoldForm], ",", "10", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SetDelayed", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"w", "[", 
      RowBox[{"-", 
       RowBox[{"a_", "?", "TangentM3`Q"}]}], "]"}], ":=", 
     RowBox[{"S", "[", 
      RowBox[{"-", "a"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"w", "[", "a", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "a"}], "]"}], ",", 
      RowBox[{"w", "[", "dirvdown", "]"}], ",", 
      RowBox[{"w", "[", "dirvup", "]"}], ",", 
      RowBox[{"w", "[", "A", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "A"}], "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"w", "[", "a", "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"-", "a"}], "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", 
        RowBox[{"-", "d"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", "d", "]"}], "]"}], "]"}], ",", 
     RowBox[{"w", "[", "A", "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"-", "A"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", "False",
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "[", 
     RowBox[{"-", 
      RowBox[{"a_", "?", "TangentM3`Q"}]}], "]"}], "=."}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SetDelayed",
    HoldForm], ",", "11", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SetDelayed", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"w", "[", 
      RowBox[{"a_", "?", "TangentM3`pmQ"}], "]"}], ":=", 
     RowBox[{"S", "[", "a", "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"w", "[", "a", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "a"}], "]"}], ",", 
      RowBox[{"w", "[", "dirvdown", "]"}], ",", 
      RowBox[{"w", "[", "dirvup", "]"}], ",", 
      RowBox[{"w", "[", "A", "]"}], ",", 
      RowBox[{"w", "[", 
       RowBox[{"-", "A"}], "]"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"S", "[", "a", "]"}], ",", 
     RowBox[{"S", "[", 
      RowBox[{"-", "a"}], "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", 
        RowBox[{"-", "d"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"v", "[", "d", "]"}], "]"}], "]"}], ",", 
     RowBox[{"w", "[", "A", "]"}], ",", 
     RowBox[{"w", "[", 
      RowBox[{"-", "A"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", "False",
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w", "[", 
     RowBox[{"a_", "?", "TangentM3`pmQ"}], "]"}], "=."}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SetDelayed",
    HoldForm], ",", "12", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"PatternIndex", ",", "\[IndentingNewLine]", 
   RowBox[{"PatternIndex", "[", 
    RowBox[{"a", ",", "AIndex"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"a_", "?", "AIndexQ"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["PatternIndex",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"PatternIndex", ",", "\[IndentingNewLine]", 
   RowBox[{"PatternIndex", "[", 
    RowBox[{"a", ",", "AIndex", ",", "xAct`xTensor`Up"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"a_Symbol", "?", "AIndexQ"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["PatternIndex",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"PatternIndex", ",", "\[IndentingNewLine]", 
   RowBox[{"PatternIndex", "[", 
    RowBox[{"a", ",", "AIndex", ",", "xAct`xTensor`Down", ",", "TangentM3"}], 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"a_Symbol", "?", "TangentM3`Q"}]}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["PatternIndex",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"PatternIndex", ",", "\[IndentingNewLine]", 
   RowBox[{"PatternIndex", "[", 
    RowBox[{"a", ",", "AIndex", ",", "Null", ",", "TangentM3"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"a_", "?", "TangentM3`pmQ"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["PatternIndex",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"PatternIndex", ",", "\[IndentingNewLine]", 
   RowBox[{"PatternIndex", "[", 
    RowBox[{"d", ",", "DIndex"}], "]"}], ",", "\[IndentingNewLine]", "d_Dir", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["PatternIndex",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"PatternIndex", ",", "\[IndentingNewLine]", 
   RowBox[{"PatternIndex", "[", 
    RowBox[{"d", ",", "DIndex", ",", "xAct`xTensor`Up"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"d_Dir", "?", "UpIndexQ"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["PatternIndex",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"PatternIndex", ",", "\[IndentingNewLine]", 
   RowBox[{"PatternIndex", "[", 
    RowBox[{"d", ",", "DIndex", ",", "xAct`xTensor`Down", ",", "TangentM3"}], 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"d_Dir", "?", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"DownIndexQ", "[", "#1", "]"}], "&&", 
       RowBox[{"DIndexQ", "[", 
        RowBox[{"#1", ",", "TangentM3"}], "]"}]}], "&"}], ")"}]}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["PatternIndex",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"PatternIndex", ",", "\[IndentingNewLine]", 
   RowBox[{"PatternIndex", "[", 
    RowBox[{"d", ",", "DIndex", ",", "Null", ",", "TangentM3"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"d_Dir", "?", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"DIndexQ", "[", 
       RowBox[{"#1", ",", "TangentM3"}], "]"}], "&"}], ")"}]}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["PatternIndex",
    HoldForm], ",", "8", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"IndexRule", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"w", "[", "a", "]"}], ",", 
       RowBox[{"w", "[", "b", "]"}]}], "}"}], "/.", 
     RowBox[{"IndexRule", "[", 
      RowBox[{
       RowBox[{"w", "[", "a_", "]"}], ",", 
       RowBox[{
        RowBox[{"S", "[", 
         RowBox[{"a", ",", "b"}], "]"}], 
        RowBox[{"v", "[", 
         RowBox[{"-", "b"}], "]"}]}]}], "]"}]}], "//", 
    "ScreenDollarIndices"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"v", "[", 
       RowBox[{"-", "b"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"b", ",", "a"}], "]"}], 
      RowBox[{"v", "[", 
       RowBox[{"-", "a"}], "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["IndexRule",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefMetric", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefMetric", "[", "metricg", "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Detmetricg"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "weight +2 density", 
   " ", $CellContext`Detmetricg],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Christoffelcd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Christoffel tensor", " ", $CellContext`Christoffelcd],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Einsteincd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Einstein tensor", " ", $CellContext`Einsteincd],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Kretschmanncd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Kretschmann scalar", 
   " ", $CellContext`Kretschmanncd],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Riccicd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric Ricci tensor", 
   " ", $CellContext`Riccicd],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciScalarcd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci scalar", 
   " ", $CellContext`RicciScalarcd],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Riemanncd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`Riemanncd],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TFRiccicd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric TFRicci tensor",
    " ", $CellContext`TFRiccicd],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Torsioncd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`Torsioncd],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Weylcd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Weyl tensor", 
   " ", $CellContext`Weylcd],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "cd"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "covariant derivative", 
   " ", $CellContext`cd],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "epsilonmetricg"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "antisymmetric tensor", 
   " ", $CellContext`epsilonmetricg],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "metricg"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric metric tensor", 
   " ", $CellContext`metricg],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefMetric",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["6. Derivatives", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefCovD", ",", "\[IndentingNewLine]", 
   RowBox[{"DefCovD", "[", 
    RowBox[{"Cd", "[", 
     RowBox[{"-", "a"}], "]"}], "]"}], ",", "\[IndentingNewLine]", "Null", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"Cd", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`Cd[-$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCd", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCd[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCd", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCd[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCd", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCd[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
$CellContext`d], ". ", "Antisymmetric only in the first pair."],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCd", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "non-symmetric Ricci tensor ", 
   $CellContext`RicciCd[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefCovD",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SymmetryGroupOfTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"SymmetryGroupOfTensor", "[", "RiemannCd", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{"-", 
       RowBox[{"xAct`xPerm`Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SymmetryGroupOfTensor",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SymmetryGroupOfTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"SymmetryGroupOfTensor", "[", "RicciCd", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SymmetryGroupOfTensor",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"GiveSymbol", ",", "\[IndentingNewLine]", 
   RowBox[{"GiveSymbol", "[", 
    RowBox[{"Riemann", ",", "Cd"}], "]"}], ",", "\[IndentingNewLine]", 
   "RiemannCd", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["GiveSymbol",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"GiveOutputString", ",", "\[IndentingNewLine]", 
   RowBox[{"GiveOutputString", "[", 
    RowBox[{"Riemann", ",", "Cd"}], "]"}], ",", "\[IndentingNewLine]", 
   TagBox[
    StyleBox["\"\<R[\\[EmptyDownTriangle]]\>\"",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["GiveOutputString",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{
  "$CovDFormat", ",", "\[IndentingNewLine]", "$CovDFormat", ",", 
   "\[IndentingNewLine]", "\"\<Prefix\>\"", ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["$CovDFormat",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"r", "[", "]"}], ",", "M3"}], "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"r", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`r[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "35", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"CovD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Cd", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{
     RowBox[{"7", 
      RowBox[{"r", "[", "]"}], 
      RowBox[{"v", "[", "a", "]"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{"v", "[", 
       RowBox[{"-", "b"}], "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"v", "[", 
      RowBox[{"-", "b"}], "]"}], 
     RowBox[{
      RowBox[{"Cd", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"S", "[", 
       RowBox[{"a", ",", "b"}], "]"}], "]"}]}], "+", 
    RowBox[{"7", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"v", "[", "a", "]"}], 
        RowBox[{
         RowBox[{"Cd", "[", 
          RowBox[{"-", "a"}], "]"}], "[", 
         RowBox[{"r", "[", "]"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"r", "[", "]"}], 
        RowBox[{
         RowBox[{"Cd", "[", 
          RowBox[{"-", "a"}], "]"}], "[", 
         RowBox[{"v", "[", "a", "]"}], "]"}]}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"S", "[", 
      RowBox[{"a", ",", "b"}], "]"}], 
     RowBox[{
      RowBox[{"Cd", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"v", "[", 
       RowBox[{"-", "b"}], "]"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["CovD",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Cd", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{"f", ",", "c", ",", 
        RowBox[{"-", "b"}]}], "]"}], 
      RowBox[{"U", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "d"}]}], "]"}]}], "]"}], "//", "ToCanonical"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"U", "[", 
        RowBox[{
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "c"}]}], "]"}]}], 
      RowBox[{
       RowBox[{"Cd", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"T", "[", 
        RowBox[{"f", ",", "c", ",", 
         RowBox[{"-", "b"}]}], "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"T", "[", 
       RowBox[{"f", ",", "c", ",", 
        RowBox[{"-", "b"}]}], "]"}], 
      RowBox[{
       RowBox[{"Cd", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"U", "[", 
        RowBox[{
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "c"}]}], "]"}], "]"}]}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "22", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"PD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PD", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{"T", "[", 
      RowBox[{"c", ",", "d", ",", 
       RowBox[{"-", "e"}]}], "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"PD", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{"T", "[", 
      RowBox[{"c", ",", "d", ",", 
       RowBox[{"-", "e"}]}], "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["PD",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SortCovDs", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{"T", "[", 
        RowBox[{"c", ",", "d", ",", 
         RowBox[{"-", "e"}]}], "]"}], "]"}], "]"}], "-", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"T", "[", 
        RowBox[{"c", ",", "d", ",", 
         RowBox[{"-", "e"}]}], "]"}], "]"}], "]"}]}], "//", "SortCovDs"}], 
   ",", "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SortCovDs",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SortCovDsStart", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SortCovDsStart", "[", "PD", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{"T", "[", 
        RowBox[{"c", ",", "d", ",", 
         RowBox[{"-", "e"}]}], "]"}], "]"}], "]"}], "-", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"T", "[", 
        RowBox[{"c", ",", "d", ",", 
         RowBox[{"-", "e"}]}], "]"}], "]"}], "]"}]}]}], ",", 
   "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"SortCovDsStop", "[", "PD", "]"}]}], "]"}]], "Input"],

Cell[BoxData["\<\"Note that $CommuteCovDsOnScalars is still True.\"\>"], \
"Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SortCovDsStart",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Implode", ",", "\[IndentingNewLine]", 
   RowBox[{"Implode", "[", 
    RowBox[{
     RowBox[{"Cd", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"v", "[", "b", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Cdv", "[", 
    RowBox[{"b", ",", 
     RowBox[{"-", "a"}]}], "]"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Implode",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Explode", ",", "\[IndentingNewLine]", 
   RowBox[{"Explode", "[", 
    RowBox[{"Cdv", "[", 
     RowBox[{"b", ",", 
      RowBox[{"-", "a"}]}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Cd", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"v", "[", "b", "]"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Explode",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SymmetryOf", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Implode", "[", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "@", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "@", 
       RowBox[{"v", "[", "c", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"SymmetryGroupOfTensor", "[", "PDPDv", "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{"xAct`xPerm`Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], "]"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SymmetryOf",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SymmetryOf", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Implode", "[", 
     RowBox[{
      RowBox[{"Cd", "[", 
       RowBox[{"-", "a"}], "]"}], "@", 
      RowBox[{
       RowBox[{"Cd", "[", 
        RowBox[{"-", "b"}], "]"}], "@", 
       RowBox[{"r", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"SymmetryGroupOfTensor", "[", "CdCdr", "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{"xAct`xPerm`Cycles", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SymmetryOf",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SymmetryOf", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Implode", "[", 
     RowBox[{
      RowBox[{"Cd", "[", 
       RowBox[{"-", "a"}], "]"}], "@", 
      RowBox[{
       RowBox[{"Cd", "[", 
        RowBox[{"-", "b"}], "]"}], "@", 
       RowBox[{"v", "[", "a", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"SymmetryGroupOfTensor", "[", "CdCdv", "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SymmetryOf",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToTensorDerivative", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Cd", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"v", "[", "b", "]"}], "]"}], "//", "ToTensorDerivative"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TensorDerivative", "[", 
     RowBox[{"v", ",", "Cd"}], "]"}], "[", 
    RowBox[{"b", ",", 
     RowBox[{"-", "a"}]}], "]"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToTensorDerivative",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"FromTensorDerivative", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TensorDerivative", "[", 
      RowBox[{"v", ",", "Cd"}], "]"}], "[", 
     RowBox[{"b", ",", 
      RowBox[{"-", "a"}]}], "]"}], "//", "FromTensorDerivative"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Cd", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"v", "[", "b", "]"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["FromTensorDerivative",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefCovD", ",", "\[IndentingNewLine]", 
   RowBox[{"DefCovD", "[", 
    RowBox[{"CD", "[", 
     RowBox[{"-", "a"}], "]"}], "]"}], ",", "\[IndentingNewLine]", "Null", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
$CellContext`d], ". ", "Antisymmetric only in the first pair."],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "non-symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefCovD",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Christoffel", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Christoffel", "[", 
     RowBox[{"CD", ",", "PD"}], "]"}], "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Christoffel",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Christoffel", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Christoffel", "[", 
     RowBox[{"PD", ",", "CD"}], "]"}], "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"ChristoffelCD", "[", 
     RowBox[{"a", ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}]}], "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Christoffel",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ChangeCovD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"expr", "=", 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "d"}], "]"}], "[", 
      RowBox[{"U", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "b", ",", 
        RowBox[{"-", "c"}]}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ChangeCovD", "[", "expr", "]"}], "//", 
     "ScreenDollarIndices"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "d"}], ",", 
         RowBox[{"-", "c"}]}], "]"}]}], 
      RowBox[{"U", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "b", ",", 
        RowBox[{"-", "e"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"b", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], 
      RowBox[{"U", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "e", ",", 
        RowBox[{"-", "c"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "a"}]}], "]"}], 
      RowBox[{"U", "[", 
       RowBox[{
        RowBox[{"-", "e"}], ",", "b", ",", 
        RowBox[{"-", "c"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "d"}], "]"}], "[", 
      RowBox[{"U", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "b", ",", 
        RowBox[{"-", "c"}]}], "]"}], "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChangeCovD",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ChangeCovD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChangeCovD", "[", "expr", "]"}], "==", 
     RowBox[{"ChangeCovD", "[", 
      RowBox[{"expr", ",", "CD"}], "]"}]}], "//", "ScreenDollarIndices"}], 
   ",", "\[IndentingNewLine]", "True", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChangeCovD",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ChangeCovD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ChangeCovD", "[", 
     RowBox[{
      RowBox[{"ChangeCovD", "[", 
       RowBox[{"expr", ",", "CD", ",", "Cd"}], "]"}], ",", "Cd", ",", "CD"}], 
     "]"}], "//", "ToCanonical"}], ",", "\[IndentingNewLine]", 
   RowBox[{"expr", "//", "Evaluate"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCdCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`ChristoffelCdCD[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChangeCovD",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"BreakChristoffel", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChangeCovD", "[", 
      RowBox[{"expr", ",", "CD", ",", "Cd"}], "]"}], "//", 
     "BreakChristoffel"}], "//", "ScreenDollarIndices"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ChristoffelCd", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "d"}], ",", 
          RowBox[{"-", "c"}]}], "]"}], "-", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "d"}], ",", 
          RowBox[{"-", "c"}]}], "]"}]}], ")"}], 
      RowBox[{"U", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "b", ",", 
        RowBox[{"-", "e"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ChristoffelCd", "[", 
         RowBox[{"b", ",", 
          RowBox[{"-", "d"}], ",", 
          RowBox[{"-", "e"}]}], "]"}], "-", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"b", ",", 
          RowBox[{"-", "d"}], ",", 
          RowBox[{"-", "e"}]}], "]"}]}], ")"}], 
      RowBox[{"U", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "e", ",", 
        RowBox[{"-", "c"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"ChristoffelCd", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "d"}], ",", 
          RowBox[{"-", "a"}]}], "]"}], "-", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "d"}], ",", 
          RowBox[{"-", "a"}]}], "]"}]}], ")"}], 
      RowBox[{"U", "[", 
       RowBox[{
        RowBox[{"-", "e"}], ",", "b", ",", 
        RowBox[{"-", "c"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"Cd", "[", 
       RowBox[{"-", "d"}], "]"}], "[", 
      RowBox[{"U", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "b", ",", 
        RowBox[{"-", "c"}]}], "]"}], "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["BreakChristoffel",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"xTest", "[", 
   RowBox[{"ChangeCovD", ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ChangeCovD", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Cd", "[", 
         RowBox[{"-", "e"}], "]"}], "@", 
        RowBox[{
         RowBox[{"Cd", "[", 
          RowBox[{"-", "a"}], "]"}], "@", 
         RowBox[{"T", "[", 
          RowBox[{"f", ",", "c", ",", 
           RowBox[{"-", "b"}]}], "]"}]}]}], ",", "Cd"}], "]"}], "//", 
     "ScreenDollarIndices"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ChristoffelCd", "[", 
          RowBox[{"i", ",", 
           RowBox[{"-", "e"}], ",", 
           RowBox[{"-", "b"}]}], "]"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"ChristoffelCd", "[", 
               RowBox[{"d", ",", 
                RowBox[{"-", "a"}], ",", 
                RowBox[{"-", "i"}]}], "]"}], "*", 
              RowBox[{"T", "[", 
               RowBox[{"f", ",", "c", ",", 
                RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"ChristoffelCd", "[", 
             RowBox[{"c", ",", 
              RowBox[{"-", "a"}], ",", 
              RowBox[{"-", "g"}]}], "]"}], "*", 
            RowBox[{"T", "[", 
             RowBox[{"f", ",", "g", ",", 
              RowBox[{"-", "i"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"ChristoffelCd", "[", 
             RowBox[{"f", ",", 
              RowBox[{"-", "a"}], ",", 
              RowBox[{"-", "h"}]}], "]"}], "*", 
            RowBox[{"T", "[", 
             RowBox[{"h", ",", "c", ",", 
              RowBox[{"-", "i"}]}], "]"}]}], "+", 
           RowBox[{
            RowBox[{"PD", "[", 
             RowBox[{"-", "a"}], "]"}], "[", 
            RowBox[{"T", "[", 
             RowBox[{"f", ",", "c", ",", 
              RowBox[{"-", "i"}]}], "]"}], "]"}]}], ")"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"c", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "i"}]}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"ChristoffelCd", "[", 
           RowBox[{"i", ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"T", "[", 
           RowBox[{"f", ",", "g", ",", 
            RowBox[{"-", "b"}]}], "]"}]}], "-", 
         RowBox[{
          RowBox[{"ChristoffelCd", "[", 
           RowBox[{"d", ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "b"}]}], "]"}], "*", 
          RowBox[{"T", "[", 
           RowBox[{"f", ",", "i", ",", 
            RowBox[{"-", "d"}]}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"ChristoffelCd", "[", 
           RowBox[{"f", ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "h"}]}], "]"}], "*", 
          RowBox[{"T", "[", 
           RowBox[{"h", ",", "i", ",", 
            RowBox[{"-", "b"}]}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"PD", "[", 
           RowBox[{"-", "a"}], "]"}], "[", 
          RowBox[{"T", "[", 
           RowBox[{"f", ",", "i", ",", 
            RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"f", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "i"}]}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"ChristoffelCd", "[", 
           RowBox[{"i", ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "h"}]}], "]"}], "*", 
          RowBox[{"T", "[", 
           RowBox[{"h", ",", "c", ",", 
            RowBox[{"-", "b"}]}], "]"}]}], "-", 
         RowBox[{
          RowBox[{"ChristoffelCd", "[", 
           RowBox[{"d", ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "b"}]}], "]"}], "*", 
          RowBox[{"T", "[", 
           RowBox[{"i", ",", "c", ",", 
            RowBox[{"-", "d"}]}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"ChristoffelCd", "[", 
           RowBox[{"c", ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"T", "[", 
           RowBox[{"i", ",", "g", ",", 
            RowBox[{"-", "b"}]}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"PD", "[", 
           RowBox[{"-", "a"}], "]"}], "[", 
          RowBox[{"T", "[", 
           RowBox[{"i", ",", "c", ",", 
            RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"T", "[", 
        RowBox[{"f", ",", "d", ",", 
         RowBox[{"-", "b"}]}], "]"}], "*", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "e"}], "]"}], "[", 
        RowBox[{"ChristoffelCd", "[", 
         RowBox[{"c", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"T", "[", 
        RowBox[{"f", ",", "c", ",", 
         RowBox[{"-", "d"}]}], "]"}], "*", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "e"}], "]"}], "[", 
        RowBox[{"ChristoffelCd", "[", 
         RowBox[{"d", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "b"}]}], "]"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"T", "[", 
        RowBox[{"d", ",", "c", ",", 
         RowBox[{"-", "b"}]}], "]"}], "*", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "e"}], "]"}], "[", 
        RowBox[{"ChristoffelCd", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"f", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "*", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "e"}], "]"}], "[", 
        RowBox[{"T", "[", 
         RowBox[{"d", ",", "c", ",", 
          RowBox[{"-", "b"}]}], "]"}], "]"}]}], "-", 
      RowBox[{
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "*", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "e"}], "]"}], "[", 
        RowBox[{"T", "[", 
         RowBox[{"f", ",", "c", ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"c", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "*", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "e"}], "]"}], "[", 
        RowBox[{"T", "[", 
         RowBox[{"f", ",", "d", ",", 
          RowBox[{"-", "b"}]}], "]"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "e"}], "]"}], "[", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"T", "[", 
         RowBox[{"f", ",", "c", ",", 
          RowBox[{"-", "b"}]}], "]"}], "]"}], "]"}], "-", 
      RowBox[{
       RowBox[{"ChristoffelCd", "[", 
        RowBox[{"i", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "a"}]}], "]"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"ChristoffelCd", "[", 
             RowBox[{"d", ",", 
              RowBox[{"-", "i"}], ",", 
              RowBox[{"-", "b"}]}], "]"}], "*", 
            RowBox[{"T", "[", 
             RowBox[{"f", ",", "c", ",", 
              RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"ChristoffelCd", "[", 
           RowBox[{"c", ",", 
            RowBox[{"-", "i"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"T", "[", 
           RowBox[{"f", ",", "g", ",", 
            RowBox[{"-", "b"}]}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"ChristoffelCd", "[", 
           RowBox[{"f", ",", 
            RowBox[{"-", "i"}], ",", 
            RowBox[{"-", "h"}]}], "]"}], "*", 
          RowBox[{"T", "[", 
           RowBox[{"h", ",", "c", ",", 
            RowBox[{"-", "b"}]}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"PD", "[", 
           RowBox[{"-", "i"}], "]"}], "[", 
          RowBox[{"T", "[", 
           RowBox[{"f", ",", "c", ",", 
            RowBox[{"-", "b"}]}], "]"}], "]"}]}], ")"}]}]}], "//", 
     "Evaluate"}], ",", "\[IndentingNewLine]", "False"}], "]"}], 
  "\[IndentingNewLine]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChangeCovD",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell["Continue at 540.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ChangeCurvature", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ChangeCurvature", "[", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}], ",", "d"}], "]"}], "]"}], "//", 
    "ScreenDollarIndices"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "]"}], "+", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChangeCurvature",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ChangeCurvature", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ChangeCurvature", "[", 
     RowBox[{
      RowBox[{"RiemannCD", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}], ",", "d"}], "]"}], ",", "CD", ",", "Cd"}], "]"}], 
    "//", "ScreenDollarIndices"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ChristoffelCdCD", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], 
      RowBox[{"ChristoffelCdCD", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCdCD", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], 
      RowBox[{"ChristoffelCdCD", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}]}], "+", 
     RowBox[{"RiemannCd", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}], ",", "d"}], "]"}], "+", 
     RowBox[{
      RowBox[{"Cd", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"ChristoffelCdCD", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "]"}], "-", 
     RowBox[{
      RowBox[{"Cd", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{"ChristoffelCdCD", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChangeCurvature",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ChangeCurvature", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ChangeCurvature", "[", 
     RowBox[{
      RowBox[{"RiemannCD", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}], ",", "a"}], "]"}], ",", "CD", ",", "Cd"}], "]"}], 
    "//", "ScreenDollarIndices"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ChristoffelCdCD", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], 
      RowBox[{"ChristoffelCdCD", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCdCD", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], 
      RowBox[{"ChristoffelCdCD", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}]}], "-", 
     RowBox[{"RicciCd", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "+", 
     RowBox[{
      RowBox[{"Cd", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"ChristoffelCdCD", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "]"}], "-", 
     RowBox[{
      RowBox[{"Cd", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{"ChristoffelCdCD", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChangeCurvature",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefCovD", ",", "\[IndentingNewLine]", 
   RowBox[{"DefCovD", "[", 
    RowBox[{
     RowBox[{"CDT", "[", 
      RowBox[{"-", "a"}], "]"}], ",", 
     RowBox[{"SymbolOfCovD", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<#\>\"", ",", "\"\<DT\>\""}], "}"}]}], ",", 
     RowBox[{"Torsion", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CDT", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CDT[-$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionCDT", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionCDT[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDT", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCDT[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCDT", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCDT[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
$CellContext`d], ". ", "Antisymmetric only in the first pair."],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCDT", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "non-symmetric Ricci tensor ", 
   $CellContext`RicciCDT[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefCovD",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ChangeCurvature", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ChangeCurvature", "[", 
     RowBox[{
      RowBox[{"RiemannCd", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}], ",", "a"}], "]"}], ",", "Cd", ",", "CDT"}], "]"}],
     "//", "ScreenDollarIndices"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ChristoffelCdCDT", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "*", 
      RowBox[{"ChristoffelCdCDT", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"ChristoffelCdCDT", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "*", 
      RowBox[{"ChristoffelCdCDT", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}]}], "-", 
     RowBox[{"RicciCDT", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "+", 
     RowBox[{
      RowBox[{"ChristoffelCdCDT", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "*", 
      RowBox[{"TorsionCDT", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "a"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"CDT", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"ChristoffelCdCDT", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "]"}], "+", 
     RowBox[{
      RowBox[{"CDT", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{"ChristoffelCdCDT", "[", 
       RowBox[{"a", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCdCDT", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`ChristoffelCdCDT[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChangeCurvature",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ChangeTorsion", ",", "\[IndentingNewLine]", 
   RowBox[{"ChangeTorsion", "[", 
    RowBox[{
     RowBox[{"TorsionCDT", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], ",", "CDT", ",", "Cd"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChristoffelCdCDT", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "-", 
     RowBox[{"ChristoffelCdCDT", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChangeTorsion",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefCovD", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefCovD", "/@", 
    RowBox[{"{", 
     RowBox[{"CD", ",", "CDT"}], "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"Null", ",", "Null"}], "}"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "ChristoffelCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Christoffel tensor", " ", $CellContext`ChristoffelCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "ChristoffelCdCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`ChristoffelCdCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Ricci tensor", " ", $CellContext`RicciCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "CD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "covariant derivative", 
   " ", $CellContext`CD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "ChristoffelCdCDT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`ChristoffelCdCDT],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "ChristoffelCDT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Christoffel tensor", " ", $CellContext`ChristoffelCDT],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciCDT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Ricci tensor", " ", $CellContext`RicciCDT],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannCDT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannCDT],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionCDT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionCDT],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "CDT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "covariant derivative", 
   " ", $CellContext`CDT],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefCovD",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefCovD", ",", "\[IndentingNewLine]", 
   RowBox[{"DefCovD", "[", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "a"}], "]"}], ",", 
     RowBox[{"Torsion", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
$CellContext`d], ". ", "Antisymmetric only in the first pair."],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "non-symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefCovD",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"bianchi1A", "=", 
   RowBox[{
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", "d"}], "]"}], "+", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "]"}], "-", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bianchi1B", "=", 
   RowBox[{
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", "d"}], "]"}], "-", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "b"}], ",", "d"}], "]"}], "-", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "c"}], ",", "d"}], "]"}], "+", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "a"}], ",", "d"}], "]"}], "+", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", "d"}], "]"}], "-", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "a"}], ",", "d"}], "]"}], "-", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "]"}], "-", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "]"}], "-", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "]"}], "+", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "]"}], "+", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "c"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "]"}], "-", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "c"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bianchi1C", "=", 
   RowBox[{
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", "d"}], "]"}], "-", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "b"}], ",", "d"}], "]"}], "-", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "c"}], ",", "d"}], "]"}], "+", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "a"}], ",", "d"}], "]"}], "+", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", "d"}], "]"}], "-", 
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "a"}], ",", "d"}], "]"}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "]"}], "-", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "]"}], "-", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "]"}], "+", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "]"}], "+", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "c"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "]"}], "-", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "c"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bianchi1D", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "e"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "]"}], "-", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "]"}], "+", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "a"}]}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "]"}], "+", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "]"}], "-", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"d", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "a"}]}], "]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "c"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "]"}], "-", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "c"}], "]"}], "[", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bianchi1E", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "c"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"d", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "e"}]}], "]"}]}], "+", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "c"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"d", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "e"}]}], "]"}]}], "+", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "a"}]}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "c"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "a"}]}], "]"}]}], ")"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "c"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"d", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "e"}]}], "]"}]}], "+", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "c"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "b"}]}], "]"}]}], "+", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "a"}]}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "c"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "b"}]}], "]"}]}], "+", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "a"}]}], "]"}]}], ")"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "a"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"d", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "e"}]}], "]"}]}], "+", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "a"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "c"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "a"}]}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "c"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "a"}]}], "]"}]}], ")"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"d", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "e"}]}], "]"}]}], "+", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "c"}]}], "]"}]}], "+", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "a"}]}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "b"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "c"}]}], "]"}]}], "+", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "a"}]}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "c"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}]}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "a"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "c"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}]}], "]"}]}], ")"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "a"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"d", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "e"}]}], "]"}]}], "+", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "a"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"d", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "c"}]}], "]"}]}], "+", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}]}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}], ",", 
         RowBox[{"-", "a"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "c"}]}], "]"}]}], "+", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}]}], "]"}]}], ")"}]}]}]}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Antisymmetrize", ",", "\[IndentingNewLine]", 
   RowBox[{"6", 
    RowBox[{"Antisymmetrize", "[", 
     RowBox[{"bianchi1A", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "}"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"bianchi1B", "//", "Evaluate"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Antisymmetrize",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ChangeCovD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bianchi1B", "//", "ChangeCovD"}], "//", "ScreenDollarIndices"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{"bianchi1C", "//", "Evaluate"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChangeCovD",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"RiemannToChristoffel", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bianchi1C", "//", "RiemannToChristoffel"}], "//", 
    "ScreenDollarIndices"}], ",", "\[IndentingNewLine]", 
   RowBox[{"bianchi1D", "//", "Evaluate"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["RiemannToChristoffel",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"TorsionToChristoffel", ",", "\[IndentingNewLine]", 
   RowBox[{"bianchi1D", "//", "TorsionToChristoffel"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"bianchi1E", "//", "Evaluate"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["TorsionToChristoffel",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Expand", ",", "\[IndentingNewLine]", 
   RowBox[{"bianchi1E", "//", "Expand"}], ",", "\[IndentingNewLine]", "0", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Expand",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"bianchi2A", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "a"}], "]"}], "[", " ", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], " ", "]"}], "-", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bianchi2B", "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"RiemannCD", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "f"}], ",", 
         RowBox[{"-", "d"}], ",", "e"}], "]"}], "*", 
       RowBox[{"TorsionCD", "[", 
        RowBox[{"f", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "b"}]}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "]"}], "-", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "]"}], "-", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "]"}], "+", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "]"}], "+", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "c"}], "]"}], "[", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "]"}], "-", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "c"}], "]"}], "[", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bianchi2C", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}], ",", "f"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}], ",", "e"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}], ",", "f"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}], ",", "e"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}], ",", "f"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}], ",", "e"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}], ",", "f"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}], ",", "e"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}], ",", "f"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}], ",", "e"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}], ",", "f"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}], ",", "e"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "*", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "]"}], "-", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "]"}], "-", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "]"}], "+", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "]"}], "+", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "c"}], "]"}], "[", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "]"}], "-", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "c"}], "]"}], "[", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}], ",", "e"}], "]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bianchi2D", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "f"}]}], "]"}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "f"}]}], "]"}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"f", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"f", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"e", ",", 
            RowBox[{"-", "b"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "f"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "f"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "f"}]}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "f"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "f"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "f"}]}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"f", ",", 
            RowBox[{"-", "b"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"f", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"f", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"e", ",", 
            RowBox[{"-", "c"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "f"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "f"}]}], "]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "f"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"e", ",", 
            RowBox[{"-", "c"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "b"}], ",", 
            RowBox[{"-", "f"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "f"}]}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "f"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"f", ",", 
            RowBox[{"-", "c"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"f", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"f", ",", 
            RowBox[{"-", "c"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "b"}], ",", 
            RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"f", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"e", ",", 
            RowBox[{"-", "f"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"e", ",", 
            RowBox[{"-", "f"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"e", ",", 
            RowBox[{"-", "f"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "b"}], ",", 
            RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"e", ",", 
            RowBox[{"-", "f"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "b"}], ",", 
            RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"e", ",", 
            RowBox[{"-", "f"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "c"}], ",", 
            RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"e", ",", 
            RowBox[{"-", "f"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "c"}], ",", 
            RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"TorsionCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bianchi2E", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "f"}]}], "]"}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "f"}]}], "]"}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"f", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"f", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"e", ",", 
            RowBox[{"-", "b"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "f"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "f"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "f"}]}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "f"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "f"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "f"}]}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"f", ",", 
            RowBox[{"-", "b"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"f", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"f", ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"e", ",", 
            RowBox[{"-", "c"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "f"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "f"}]}], "]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "f"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"e", ",", 
            RowBox[{"-", "c"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "b"}], ",", 
            RowBox[{"-", "f"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"e", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "f"}]}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "f"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "f"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"f", ",", 
            RowBox[{"-", "c"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"f", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"f", ",", 
            RowBox[{"-", "c"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "b"}], ",", 
            RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{"ChristoffelCD", "[", 
       RowBox[{"f", ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"e", ",", 
            RowBox[{"-", "f"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"e", ",", 
            RowBox[{"-", "f"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"f", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "c"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"f", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "c"}]}], "]"}]}], "+", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"f", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"e", ",", 
            RowBox[{"-", "f"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "b"}], ",", 
            RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"e", ",", 
            RowBox[{"-", "f"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "b"}], ",", 
            RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"f", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "c"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"f", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "a"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "c"}]}], "]"}]}], "+", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"f", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "a"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"e", ",", 
            RowBox[{"-", "f"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "c"}], ",", 
            RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"e", ",", 
            RowBox[{"-", "f"}], ",", 
            RowBox[{"-", "g"}]}], "]"}], "*", 
          RowBox[{"ChristoffelCD", "[", 
           RowBox[{"g", ",", 
            RowBox[{"-", "c"}], ",", 
            RowBox[{"-", "d"}]}], "]"}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"f", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], "-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"f", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "a"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "a"}]}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"f", ",", 
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "b"}]}], "]"}]}], "+", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"f", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "a"}]}], "]"}]}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "g"}]}], "]"}], "*", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"g", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "f"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "f"}], "]"}], "[", 
        RowBox[{"ChristoffelCD", "[", 
         RowBox[{"e", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "]"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bianchi2F", "=", 
   RowBox[{
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "g"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"g", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "g"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"g", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "g"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"g", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}]}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "g"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"g", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}]}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "g"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"g", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}]}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "g"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"g", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}]}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "g"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"g", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}]}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "g"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"g", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}]}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "g"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"g", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}]}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "f"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "g"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"g", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "d"}]}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "g"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"g", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}]}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"e", ",", 
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "g"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"f", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "d"}]}], "]"}], "*", 
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"g", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "f"}]}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "b"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "-", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "b"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "c"}], "]"}], "[", 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"e", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "d"}]}], "]"}], "]"}], "]"}]}]}]}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Antisymmetrize", ",", "\[IndentingNewLine]", 
   RowBox[{"6", 
    RowBox[{"Antisymmetrize", "[", 
     RowBox[{"bianchi2A", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "}"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"bianchi2B", "//", "Evaluate"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Antisymmetrize",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ChangeCovD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bianchi2B", "//", "ChangeCovD"}], "//", "ScreenDollarIndices"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{"bianchi2C", "//", "Evaluate"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChangeCovD",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"RiemannToChristoffel", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bianchi2C", "//", "RiemannToChristoffel"}], "//", 
    "ScreenDollarIndices"}], ",", "\[IndentingNewLine]", 
   RowBox[{"bianchi2D", "//", "Evaluate"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["RiemannToChristoffel",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"TorsionToChristoffel", ",", "\[IndentingNewLine]", 
   RowBox[{"bianchi2D", "//", "TorsionToChristoffel"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"bianchi2E", "//", "Evaluate"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["TorsionToChristoffel",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Expand", ",", "\[IndentingNewLine]", 
   RowBox[{"bianchi2E", "//", "Expand"}], ",", "\[IndentingNewLine]", 
   RowBox[{"bianchi2F", "//", "Evaluate"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Expand",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToCanonical", ",", "\[IndentingNewLine]", 
   RowBox[{"bianchi2F", "//", "ToCanonical"}], ",", "\[IndentingNewLine]", 
   "0", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToCanonical",
    HoldForm], ",", "23", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefCovD", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefCovD", "[", "CD", "]"}], ",", "\[IndentingNewLine]", "Null", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "ChristoffelCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Christoffel tensor", " ", $CellContext`ChristoffelCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Ricci tensor", " ", $CellContext`RicciCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "CD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "covariant derivative", 
   " ", $CellContext`CD],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefCovD",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"const", "[", "]"}], ",", 
     RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", "Null", ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"const", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`const[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "36", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"CheckZeroDerivative", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Cd", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"const", "[", "]"}], "]"}], "//", "CheckZeroDerivative"}], ",", 
   "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["CheckZeroDerivative",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"CheckZeroDerivativeStart", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CheckZeroDerivativeStart", "[", "PD", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"const", "[", "]"}], "]"}]}], ",", "\[IndentingNewLine]", "0", 
   ",", "\[IndentingNewLine]", "False", ",", "\[IndentingNewLine]", 
   RowBox[{"CheckZeroDerivativeStop", "[", "PD", "]"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["CheckZeroDerivativeStart",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefConstantSymbol", ",", "\[IndentingNewLine]", 
   RowBox[{"DefConstantSymbol", "[", "GNewton", "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol \"\>", "\[InvisibleSpace]", 
   "GNewton", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefConstantSymbol, ": Defining ", 
   "constant symbol ", $CellContext`GNewton, ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefConstantSymbol",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ConstantSymbol", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Cd", "[", 
     RowBox[{"-", "a"}], "]"}], "[", "GNewton", "]"}], ",", 
   "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ConstantSymbol",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefConstantSymbol", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefConstantSymbol", "[", "GNewton", "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["GNewton",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`GNewton,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefConstantSymbol, ": Undefined ", "constant symbol", 
   " ", $CellContext`GNewton],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefConstantSymbol",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"OverDot", ",", "\[IndentingNewLine]", 
   RowBox[{"OverDot", "[", 
    RowBox[{
     RowBox[{"r", "[", "]"}], "^", "2"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"2", 
    RowBox[{"OverDot", "[", 
     RowBox[{"r", "[", "]"}], "]"}], 
    RowBox[{"r", "[", "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["OverDot",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"OverDot", ",", "\[IndentingNewLine]", 
   RowBox[{"OverDot", "[", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"r", "[", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PD", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"OverDot", "[", 
     RowBox[{"r", "[", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["OverDot",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"OverDot", ",", "\[IndentingNewLine]", 
   RowBox[{"OverDot", "[", 
    RowBox[{
     RowBox[{"Cd", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"r", "[", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"OverDot", "[", 
    RowBox[{
     RowBox[{"Cd", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"r", "[", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["OverDot",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefParameter", ",", "\[IndentingNewLine]", 
   RowBox[{"DefParameter", "[", 
    RowBox[{"time", ",", 
     RowBox[{"PrintAs", "\[Rule]", "\"\<t\>\""}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefParameter", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parameter \"\>", "\[InvisibleSpace]", "time", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefParameter, ": Defining ", 
   "parameter ", $CellContext`time, ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefParameter",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ParamD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ParamD", "[", "time", "]"}], "[", 
    RowBox[{"r", "[", "]"}], "]"}], ",", "\[IndentingNewLine]", "0", ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ParamD",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"Q", "[", 
      RowBox[{"-", "a"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"M3", ",", "time"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]",
    "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Q", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`Q[-$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "37", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "[", "Q", "]"}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "Q"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`Q],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "20", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefParameter", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefParameter", "[", "time", "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefParameter", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"parameter\"\>", "\[InvisibleSpace]", "\<\" \"\>",
    "\[InvisibleSpace]", 
   InterpretationBox[
    StyleBox["t",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`time,
    Editable->False]}],
  SequenceForm[
  "** ", xAct`xTensor`UndefParameter, ": Undefined ", "parameter", 
   " ", $CellContext`time],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefParameter",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"LieDToCovD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LieDToCovD", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"LieD", "[", 
        RowBox[{"w", "[", "a", "]"}], "]"}], "[", 
       RowBox[{"S", "[", 
        RowBox[{
         RowBox[{"-", "b"}], ",", "c"}], "]"}], "]"}], ",", "PD"}], "]"}], "//",
     "ScreenDollarIndices"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"w", "[", "a", "]"}], 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"S", "[", 
        RowBox[{
         RowBox[{"-", "b"}], ",", "c"}], "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", "a"}], "]"}], 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"w", "[", "c", "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "c"}], "]"}], 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{"w", "[", "a", "]"}], "]"}]}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["LieDToCovD",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"LieDToCovD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LieDToCovD", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"LieD", "[", 
        RowBox[{"w", "[", "a", "]"}], "]"}], "[", 
       RowBox[{"S", "[", 
        RowBox[{
         RowBox[{"-", "b"}], ",", "c"}], "]"}], "]"}], ",", "Cd"}], "]"}], "//",
     "ScreenDollarIndices"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"w", "[", "a", "]"}], 
      RowBox[{
       RowBox[{"Cd", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"S", "[", 
        RowBox[{
         RowBox[{"-", "b"}], ",", "c"}], "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", "a"}], "]"}], 
      RowBox[{
       RowBox[{"Cd", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"w", "[", "c", "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "c"}], "]"}], 
      RowBox[{
       RowBox[{"Cd", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{"w", "[", "a", "]"}], "]"}]}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["LieDToCovD",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"LieD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"LieD", "[", 
      RowBox[{
       RowBox[{"w", "[", "a", "]"}], ",", "Cd"}], "]"}], "[", 
     RowBox[{"S", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", "c"}], "]"}], "]"}], "//", 
    "ScreenDollarIndices"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"w", "[", "a", "]"}], 
      RowBox[{
       RowBox[{"Cd", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"S", "[", 
        RowBox[{
         RowBox[{"-", "b"}], ",", "c"}], "]"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", "a"}], "]"}], 
      RowBox[{
       RowBox[{"Cd", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"w", "[", "c", "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"S", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "c"}], "]"}], 
      RowBox[{
       RowBox[{"Cd", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{"w", "[", "a", "]"}], "]"}]}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["LieD",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"LieD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LieD", "[", 
     RowBox[{"w", "[", "a", "]"}], "]"}], "[", 
    RowBox[{
     RowBox[{"S", "[", "a", "]"}], 
     RowBox[{"T", "[", 
      RowBox[{"-", "a"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"-", "a"}], "]"}], 
     RowBox[{
      RowBox[{"LieD", "[", 
       RowBox[{"w", "[", "a", "]"}], "]"}], "[", 
      RowBox[{"S", "[", "a", "]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"S", "[", "a", "]"}], 
     RowBox[{
      RowBox[{"LieD", "[", 
       RowBox[{"w", "[", "a", "]"}], "]"}], "[", 
      RowBox[{"T", "[", 
       RowBox[{"-", "a"}], "]"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["LieD",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"LieD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LieD", "[", 
     RowBox[{
      RowBox[{"7", 
       RowBox[{"r", "[", "]"}], 
       RowBox[{"w", "[", "a", "]"}]}], "+", 
      RowBox[{"v", "[", "a", "]"}]}], "]"}], "[", 
    RowBox[{"T", "[", "a", "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"LieD", "[", 
      RowBox[{"v", "[", "a", "]"}], "]"}], "[", 
     RowBox[{"T", "[", "a", "]"}], "]"}], "+", 
    RowBox[{"7", 
     RowBox[{
      RowBox[{"LieD", "[", 
       RowBox[{
        RowBox[{"r", "[", "]"}], 
        RowBox[{"w", "[", "a", "]"}]}], "]"}], "[", 
      RowBox[{"T", "[", "a", "]"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["LieD",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Dir", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PD", "[", 
     RowBox[{"Dir", "[", 
      RowBox[{
       RowBox[{"3", 
        RowBox[{"S", "[", 
         RowBox[{"a", ",", 
          RowBox[{"Dir", "[", 
           RowBox[{"v", "[", 
            RowBox[{"-", "b"}], "]"}], "]"}]}], "]"}]}], "+", 
       RowBox[{"w", "[", "a", "]"}]}], "]"}], "]"}], "[", 
    RowBox[{"1", "/", 
     RowBox[{
      RowBox[{"r", "[", "]"}], "^", "2"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", 
         RowBox[{
          RowBox[{"PD", "[", 
           RowBox[{"Dir", "[", 
            RowBox[{"S", "[", 
             RowBox[{"a", ",", 
              RowBox[{"Dir", "[", 
               RowBox[{"v", "[", 
                RowBox[{"-", "b"}], "]"}], "]"}]}], "]"}], "]"}], "]"}], "[", 
          
          RowBox[{"r", "[", "]"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"Dir", "[", 
           RowBox[{"w", "[", "a", "]"}], "]"}], "]"}], "[", 
         RowBox[{"r", "[", "]"}], "]"}]}], ")"}], "/", 
      RowBox[{
       RowBox[{"r", "[", "]"}], "^", "3"}]}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Dir",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Dir", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wder", "=", 
     RowBox[{"PD", "[", 
      RowBox[{"Dir", "[", 
       RowBox[{"w", "[", "a", "]"}], "]"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"wder", "@", 
      RowBox[{"r", "[", "]"}]}], "//", "ScalarQ"}]}], ",", 
   "\[IndentingNewLine]", "True", ",", "\[IndentingNewLine]", "False", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Remove", "[", "wder", "]"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Dir",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Bracket", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Bracket", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"v", "[", "b", "]"}], "+", 
       RowBox[{"w", "[", "b", "]"}]}], ",", 
      RowBox[{
       RowBox[{"3", 
        RowBox[{"w", "[", "b", "]"}]}], "+", 
       RowBox[{
        RowBox[{"r", "[", "]"}], 
        RowBox[{"v", "[", "b", "]"}]}]}]}], "]"}], "[", "a", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"3", 
      RowBox[{
       RowBox[{"Bracket", "[", 
        RowBox[{
         RowBox[{"v", "[", "b", "]"}], ",", 
         RowBox[{"w", "[", "b", "]"}]}], "]"}], "[", "a", "]"}]}], "-", 
     RowBox[{
      RowBox[{"r", "[", "]"}], 
      RowBox[{
       RowBox[{"Bracket", "[", 
        RowBox[{
         RowBox[{"v", "[", "b", "]"}], ",", 
         RowBox[{"w", "[", "b", "]"}]}], "]"}], "[", "a", "]"}]}], "+", 
     RowBox[{
      RowBox[{"v", "[", "a", "]"}], 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"Dir", "[", 
         RowBox[{"v", "[", "b", "]"}], "]"}], "]"}], "[", 
       RowBox[{"r", "[", "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"v", "[", "a", "]"}], 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"Dir", "[", 
         RowBox[{"w", "[", "b", "]"}], "]"}], "]"}], "[", 
       RowBox[{"r", "[", "]"}], "]"}]}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Bracket",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefVBundle", ",", "\[IndentingNewLine]", 
   RowBox[{"DefVBundle", "[", 
    RowBox[{"InnerC", ",", "M3", ",", "4", ",", 
     RowBox[{"{", 
      RowBox[{
      "\[GothicCapitalA]", ",", "\[GothicCapitalB]", ",", "\[GothicCapitalC]",
        ",", "\[GothicCapitalD]", ",", "\[GothicCapitalE]", ",", 
       "\[GothicCapitalF]", ",", "\[GothicCapitalG]", ",", 
       "\[GothicCapitalH]"}], "}"}], ",", 
     RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vbundle \"\>", "\[InvisibleSpace]", "InnerC", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "vbundle ", $CellContext`InnerC, ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefVBundle", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"conjugated vbundle \"\>", "\[InvisibleSpace]", 
   "InnerC\[Dagger]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Assuming fixed anti-isomorphism between InnerC \
and InnerC\[Dagger]\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefVBundle, ": Defining ", 
   "conjugated vbundle ", $CellContext`InnerC\[Dagger], ". ", 
   "Assuming fixed anti-isomorphism between InnerC and InnerC\[Dagger]"],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefVBundle",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefCovD", ",", "\[IndentingNewLine]", 
   RowBox[{"DefCovD", "[", 
    RowBox[{
     RowBox[{"ICD", "[", 
      RowBox[{"-", "a"}], "]"}], ",", "InnerC", ",", 
     RowBox[{"SymbolOfCovD", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<*\>\"", ",", "\"\<D\>\""}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"ICD", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`ICD[-$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionICD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionICD[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelICD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelICD[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannICD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannICD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
$CellContext`d], ". ", "Antisymmetric only in the first pair."],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciICD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "non-symmetric Ricci tensor ", 
   $CellContext`RicciICD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelICD", "[", 
    RowBox[{"\[GothicCapitalA]", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "\[GothicCapitalC]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelICD[$CellContext`\[GothicCapitalA], \
-$CellContext`b, -$CellContext`\[GothicCapitalC]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelICD\[Dagger]", "[", 
    RowBox[{"\[GothicCapitalA]\[Dagger]", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "\[GothicCapitalC]\[Dagger]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelICD\[Dagger][$CellContext`\[GothicCapitalA]\
\[Dagger], -$CellContext`b, -$CellContext`\[GothicCapitalC]\[Dagger]], ". ", 
   ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemannICD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "\[GothicCapitalC]"}], ",", "\[GothicCapitalD]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "FRiemann tensor ", 
   $CellContext`FRiemannICD[-$CellContext`a, -$CellContext`b, -$CellContext`\
\[GothicCapitalC], $CellContext`\[GothicCapitalD]], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemannICD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "\[GothicCapitalC]\[Dagger]"}], ",", 
     "\[GothicCapitalD]\[Dagger]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "FRiemann tensor ", 
   $CellContext`FRiemannICD\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`\[GothicCapitalC]\[Dagger], $CellContext`\[GothicCapitalD]\
\[Dagger]], ". ", "Antisymmetric only in the first pair."],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefCovD",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"X", "[", 
      RowBox[{"a", ",", "\[GothicCapitalB]"}], "]"}], ",", "M3", ",", 
     RowBox[{"Dagger", "\[Rule]", "Complex"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"X", "[", 
    RowBox[{"a", ",", "\[GothicCapitalB]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`X[$CellContext`a, $CellContext`\[GothicCapitalB]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"X\[Dagger]", "[", 
    RowBox[{"a", ",", "\[GothicCapitalB]\[Dagger]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`X\[Dagger][$CellContext`a, $CellContext`\[GothicCapitalB]\
\[Dagger]], ". ", ""],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "38", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ChangeCovD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ChangeCovD", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ICD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"X", "[", 
        RowBox[{"a", ",", "\[GothicCapitalB]"}], "]"}], "]"}], ",", "ICD"}], 
     "]"}], "//", "ScreenDollarIndices"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AChristoffelICD", "[", 
      RowBox[{"\[GothicCapitalB]", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "\[GothicCapitalA]"}]}], "]"}], 
     RowBox[{"X", "[", 
      RowBox[{"a", ",", "\[GothicCapitalA]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelICD", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], 
     RowBox[{"X", "[", 
      RowBox[{"b", ",", "\[GothicCapitalB]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "c"}], "]"}], "[", 
     RowBox[{"X", "[", 
      RowBox[{"a", ",", "\[GothicCapitalB]"}], "]"}], "]"}]}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChangeCovD",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ChangeCovD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ChangeCovD", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"AChristoffelICD", "[", 
         RowBox[{"\[GothicCapitalB]", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "\[GothicCapitalA]"}]}], "]"}], 
        RowBox[{"X", "[", 
         RowBox[{"a", ",", "\[GothicCapitalA]"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"ChristoffelICD", "[", 
         RowBox[{"a", ",", 
          RowBox[{"-", "c"}], ",", 
          RowBox[{"-", "b"}]}], "]"}], 
        RowBox[{"X", "[", 
         RowBox[{"b", ",", "\[GothicCapitalB]"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "c"}], "]"}], "[", 
        RowBox[{"X", "[", 
         RowBox[{"a", ",", "\[GothicCapitalB]"}], "]"}], "]"}]}], ",", "PD", 
      ",", "ICD"}], "]"}], "//", "ToCanonical"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"ICD", "[", 
     RowBox[{"-", "c"}], "]"}], "[", 
    RowBox[{"X", "[", 
     RowBox[{"a", ",", "\[GothicCapitalB]"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChangeCovD",
    HoldForm], ",", "8", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SortCovDs", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"ICD", "[", 
       RowBox[{"-", "c"}], "]"}], "@", 
      RowBox[{
       RowBox[{"ICD", "[", 
        RowBox[{"-", "d"}], "]"}], "@", 
       RowBox[{"X", "[", 
        RowBox[{"a", ",", "\[GothicCapitalB]"}], "]"}]}]}], "//", 
     "SortCovDs"}], "//", "ScreenDollarIndices"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FRiemannICD", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "\[GothicCapitalA]"}], ",", "\[GothicCapitalB]"}], "]"}], 
     
     RowBox[{"X", "[", 
      RowBox[{"a", ",", "\[GothicCapitalA]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"RiemannICD", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}], ",", "a"}], "]"}], 
     RowBox[{"X", "[", 
      RowBox[{"b", ",", "\[GothicCapitalB]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ICD", "[", 
      RowBox[{"-", "d"}], "]"}], "@", 
     RowBox[{
      RowBox[{"ICD", "[", 
       RowBox[{"-", "c"}], "]"}], "@", 
      RowBox[{"X", "[", 
       RowBox[{"a", ",", "\[GothicCapitalB]"}], "]"}]}]}]}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SortCovDs",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Dagger", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ICD", "[", 
      RowBox[{"-", "c"}], "]"}], "[", 
     RowBox[{"X", "[", 
      RowBox[{"a", ",", "\[GothicCapitalB]"}], "]"}], "]"}], "//", "Dagger"}],
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ICD", "[", 
     RowBox[{"-", "c"}], "]"}], "[", 
    RowBox[{"X\[Dagger]", "[", 
     RowBox[{"a", ",", "\[GothicCapitalB]\[Dagger]"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Dagger",
    HoldForm], ",", "8", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ChangeCovD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ChangeCovD", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ICD", "[", 
        RowBox[{"-", "c"}], "]"}], "[", 
       RowBox[{"X\[Dagger]", "[", 
        RowBox[{"a", ",", "\[GothicCapitalB]\[Dagger]"}], "]"}], "]"}], ",", 
      "ICD"}], "]"}], "//", "ScreenDollarIndices"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"AChristoffelICD\[Dagger]", "[", 
      RowBox[{"\[GothicCapitalB]\[Dagger]", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "\[GothicCapitalA]\[Dagger]"}]}], "]"}], 
     RowBox[{"X\[Dagger]", "[", 
      RowBox[{"a", ",", "\[GothicCapitalA]\[Dagger]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ChristoffelICD", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], 
     RowBox[{"X\[Dagger]", "[", 
      RowBox[{"b", ",", "\[GothicCapitalB]\[Dagger]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "c"}], "]"}], "[", 
     RowBox[{"X\[Dagger]", "[", 
      RowBox[{"a", ",", "\[GothicCapitalB]\[Dagger]"}], "]"}], "]"}]}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChangeCovD",
    HoldForm], ",", "9", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Dagger", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ICD", "[", 
      RowBox[{"-", "c"}], "]"}], "@", 
     RowBox[{
      RowBox[{"ICD", "[", 
       RowBox[{"-", "d"}], "]"}], "@", 
      RowBox[{"X", "[", 
       RowBox[{"a", ",", "\[GothicCapitalB]"}], "]"}]}]}], "//", "Dagger"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ICD", "[", 
     RowBox[{"-", "c"}], "]"}], "@", 
    RowBox[{
     RowBox[{"ICD", "[", 
      RowBox[{"-", "d"}], "]"}], "@", 
     RowBox[{"X\[Dagger]", "[", 
      RowBox[{"a", ",", "\[GothicCapitalB]\[Dagger]"}], "]"}]}]}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Dagger",
    HoldForm], ",", "9", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SortCovDs", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SortCovDs", "[", 
     RowBox[{
      RowBox[{"ICD", "[", 
       RowBox[{"-", "c"}], "]"}], "@", 
      RowBox[{
       RowBox[{"ICD", "[", 
        RowBox[{"-", "d"}], "]"}], "@", 
       RowBox[{"X\[Dagger]", "[", 
        RowBox[{"a", ",", "\[GothicCapitalB]\[Dagger]"}], "]"}]}]}], "]"}], "//",
     "ScreenDollarIndices"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FRiemannICD\[Dagger]", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "\[GothicCapitalA]\[Dagger]"}], ",", 
       "\[GothicCapitalB]\[Dagger]"}], "]"}], 
     RowBox[{"X\[Dagger]", "[", 
      RowBox[{"a", ",", "\[GothicCapitalA]\[Dagger]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"RiemannICD", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "b"}], ",", "a"}], "]"}], 
     RowBox[{"X\[Dagger]", "[", 
      RowBox[{"b", ",", "\[GothicCapitalB]\[Dagger]"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"ICD", "[", 
      RowBox[{"-", "d"}], "]"}], "@", 
     RowBox[{
      RowBox[{"ICD", "[", 
       RowBox[{"-", "c"}], "]"}], "@", 
      RowBox[{"X\[Dagger]", "[", 
       RowBox[{"a", ",", "\[GothicCapitalB]\[Dagger]"}], "]"}]}]}]}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SortCovDs",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "[", "X", "]"}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "X\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`X\[Dagger]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "X"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`X],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "21", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefCovD", ",", "\[IndentingNewLine]", 
   RowBox[{"DefCovD", "[", 
    RowBox[{
     RowBox[{"CD", "[", 
      RowBox[{"-", "a"}], "]"}], ",", "InnerC", ",", 
     RowBox[{"SymbolOfCovD", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<#\>\"", ",", "\"\<D\>\""}], "}"}]}], ",", 
     RowBox[{"ExtendedFrom", "\[Rule]", "Cd"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCdCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing tensor ", 
   $CellContext`ChristoffelCdCD[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelCD", "[", 
    RowBox[{"\[GothicCapitalA]", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "\[GothicCapitalC]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelCD[$CellContext`\[GothicCapitalA], \
-$CellContext`b, -$CellContext`\[GothicCapitalC]], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"AChristoffelCD\[Dagger]", "[", 
    RowBox[{"\[GothicCapitalA]\[Dagger]", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "\[GothicCapitalC]\[Dagger]"}]}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "nonsymmetric AChristoffel tensor ", 
   $CellContext`AChristoffelCD\[Dagger][$CellContext`\[GothicCapitalA]\
\[Dagger], -$CellContext`b, -$CellContext`\[GothicCapitalC]\[Dagger]], ". ", 
   ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "\[GothicCapitalC]"}], ",", "\[GothicCapitalD]"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "FRiemann tensor ", 
   $CellContext`FRiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`\
\[GothicCapitalC], $CellContext`\[GothicCapitalD]], ". ", 
   "Antisymmetric only in the first pair."],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"FRiemannCD\[Dagger]", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "\[GothicCapitalC]\[Dagger]"}], ",", 
     "\[GothicCapitalD]\[Dagger]"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "FRiemann tensor ", 
   $CellContext`FRiemannCD\[Dagger][-$CellContext`a, -$CellContext`b, \
-$CellContext`\[GothicCapitalC]\[Dagger], $CellContext`\[GothicCapitalD]\
\[Dagger]], ". ", "Antisymmetric only in the first pair."],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefCovD",
    HoldForm], ",", "8", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ExtendedFrom", ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ChristoffelCD", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], ",", 
     RowBox[{"RiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}], ",", "d"}], "]"}], ",", 
     RowBox[{"TorsionCD", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ChristoffelCd", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], ",", 
     RowBox[{"RiemannCd", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}], ",", "d"}], "]"}], ",", "0"}], "}"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ExtendedFrom",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ExtendedFrom", ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AChristoffelCD", "[", 
      RowBox[{"\[GothicCapitalA]", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "\[GothicCapitalC]"}]}], "]"}], ",", 
     RowBox[{"FRiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "\[GothicCapitalC]"}], ",", "\[GothicCapitalD]"}], 
      "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AChristoffelCD", "[", 
      RowBox[{"\[GothicCapitalA]", ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "\[GothicCapitalC]"}]}], "]"}], ",", 
     RowBox[{"FRiemannCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "\[GothicCapitalC]"}], ",", "\[GothicCapitalD]"}], 
      "]"}]}], "}"}], ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ExtendedFrom",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefCovD", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefCovD", "[", "CD", "]"}], ",", "\[IndentingNewLine]", "Null", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "AChristoffelCD\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "nonsymmetric AChristoffel tensor", 
   " ", $CellContext`AChristoffelCD\[Dagger]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"nonsymmetric AChristoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "AChristoffelCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "nonsymmetric AChristoffel tensor", " ", $CellContext`AChristoffelCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "ChristoffelCdCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`ChristoffelCdCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
   "FRiemannCD\[Dagger]"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "FRiemann tensor", 
   " ", $CellContext`FRiemannCD\[Dagger]],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"FRiemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "FRiemannCD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "FRiemann tensor", 
   " ", $CellContext`FRiemannCD],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "CD"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "covariant derivative", 
   " ", $CellContext`CD],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefCovD",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["7. Metrics", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefMetric", ",", "\[IndentingNewLine]", 
   RowBox[{"DefMetric", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"metricg", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], ",", "CD", ",", 
     RowBox[{"PrintAs", "\[Rule]", "\"\<g\>\""}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"metricg", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`metricg[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric tensor \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"epsilonmetricg", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric tensor ", 
   $CellContext`epsilonmetricg[-$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD[-$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Weyl tensor ", 
   $CellContext`WeylCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 3],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 3],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 3],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detmetricg", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detmetricg[], ". ", "Determinant."],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefMetric",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Riemann", ",", "\[IndentingNewLine]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", "b", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"RicciCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "c"}]}], "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Riemann",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Riemann", ",", "\[IndentingNewLine]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", "b", ",", "a"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"RicciScalarCD", "[", "]"}]}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Riemann",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Metric", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "c"}], "]"}], "[", 
    RowBox[{"metricg", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], "]"}], ",", "\[IndentingNewLine]", "0", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Metric",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Metric", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Cd", "[", 
     RowBox[{"-", "c"}], "]"}], "[", 
    RowBox[{"metricg", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Cd", "[", 
     RowBox[{"-", "c"}], "]"}], "[", 
    RowBox[{"metricg", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Metric",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Metric", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "c"}], "]"}], "[", 
    RowBox[{"epsilonmetricg", "[", 
     RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", "0", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Metric",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Metric", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"EinsteinCD", "[", 
     RowBox[{"b", ",", "c"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"EinsteinCD", "[", 
     RowBox[{"b", ",", "c"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Metric",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Metric", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"EinsteinCD", "[", 
     RowBox[{"a", ",", "b"}], "]"}], "]"}], ",", "\[IndentingNewLine]", "0", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Metric",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Weyl", ",", "\[IndentingNewLine]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", "\[IndentingNewLine]", "0", ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Weyl",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"TFRicci", ",", "\[IndentingNewLine]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["TFRicci",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"TFRicci", ",", "\[IndentingNewLine]", 
   RowBox[{"TFRicciCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "a"}]}], "]"}], ",", "\[IndentingNewLine]", "0", ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["TFRicci",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SlotsOfTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"SlotsOfTensor", "[", "U", "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "TangentM3"}], ",", 
     RowBox[{"-", "TangentM3"}], ",", 
     RowBox[{"-", "TangentM3"}]}], "}"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SlotsOfTensor",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Validate", ",", "\[IndentingNewLine]", 
   RowBox[{"Validate", "[", 
    RowBox[{"U", "[", 
     RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"U", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Validate",
    HoldForm], ",", "9", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"DefTensor", "[", 
    RowBox[{
     RowBox[{"X", "[", 
      RowBox[{"a", ",", "b", ",", "A"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"M3", ",", "S2"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"X", "[", 
    RowBox[{"a", ",", "b", ",", "A"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`X[$CellContext`a, $CellContext`b, $CellContext`A], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefTensor",
    HoldForm], ",", "39", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SlotsOfTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"SlotsOfTensor", "[", "X", "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"TangentM3", ",", "TangentM3", ",", "TangentS2"}], "}"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SlotsOfTensor",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Validate", ",", "\[IndentingNewLine]", 
   RowBox[{"Validate", "[", 
    RowBox[{"X", "[", 
     RowBox[{"a", ",", "b", ",", 
      RowBox[{"-", "A"}]}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ERROR", "[", 
    RowBox[{"X", "[", 
     RowBox[{"a", ",", "b", ",", 
      RowBox[{"-", "A"}]}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   "True"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Validate", "::", "error"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(\\\"Invalid character of index in tensor X\
\\\"\\)\[NoBreak]\"\>"}]], "Message", "MSG"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Validate",
    HoldForm], ",", "10", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefTensor", "[", "X", "]"}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "X"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`X],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefTensor",
    HoldForm], ",", "22", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ChangeCovD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ChangeCovD", "[", 
     RowBox[{
      RowBox[{"CD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"v", "[", 
       RowBox[{"-", "b"}], "]"}], "]"}], "]"}], "//", "ScreenDollarIndices"}],
    ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"ChristoffelCD", "[", 
        RowBox[{"c", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "b"}]}], "]"}]}], 
      RowBox[{"v", "[", 
       RowBox[{"-", "c"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"v", "[", 
       RowBox[{"-", "b"}], "]"}], "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChangeCovD",
    HoldForm], ",", "10", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"delta", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"metricg", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"metricg", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"delta", "[", 
    RowBox[{
     RowBox[{"-", "c"}], ",", "a"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["delta",
    HoldForm], ",", "8", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"delta", ",", "\[IndentingNewLine]", 
   RowBox[{"metricg", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "a"}]}], "]"}], ",", "\[IndentingNewLine]", "3", ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["delta",
    HoldForm], ",", "9", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ContractMetric", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"metricg", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", "c"}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"metricg", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"S", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", "c"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ContractMetric",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ContractMetric", ",", "\[IndentingNewLine]", 
   RowBox[{"ContractMetric", "[", 
    RowBox[{
     RowBox[{"metricg", "[", 
      RowBox[{"a", ",", "b"}], "]"}], 
     RowBox[{"S", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", "c"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"S", "[", 
    RowBox[{"b", ",", "c"}], "]"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ContractMetric",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"PD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"metricg", "[", 
      RowBox[{"b", ",", "c"}], "]"}], "]"}], "//", "ScreenDollarIndices"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"metricg", "[", 
       RowBox[{"b", ",", "d"}], "]"}]}], 
     RowBox[{"metricg", "[", 
      RowBox[{"c", ",", "e"}], "]"}], 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "a"}], "]"}], "[", 
      RowBox[{"metricg", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e"}]}], "]"}], "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["PD",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"PD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PD", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"metricg", "[", 
     RowBox[{"b", ",", 
      RowBox[{"-", "c"}]}], "]"}], "]"}], ",", "\[IndentingNewLine]", "0", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["PD",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ContractMetric", ",", "\[IndentingNewLine]", 
   RowBox[{"ContractMetric", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"metricg", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{"S", "[", 
        RowBox[{"c", ",", "d"}], "]"}], "]"}]}], ",", "metricg"}], "]"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"metricg", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "b"}], "]"}], "[", 
     RowBox[{"S", "[", 
      RowBox[{"c", ",", "d"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ContractMetric",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ContractMetric", ",", "\[IndentingNewLine]", 
   RowBox[{"ContractMetric", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"metricg", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{"S", "[", 
        RowBox[{"c", ",", "d"}], "]"}], "]"}]}], ",", "metricg", ",", 
     RowBox[{"AllowUpperDerivatives", "\[Rule]", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PD", "[", "a", "]"}], "[", 
    RowBox[{"S", "[", 
     RowBox[{"c", ",", "d"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ContractMetric",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ContractMetric", ",", "\[IndentingNewLine]", 
   RowBox[{"ContractMetric", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"metricg", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{
       RowBox[{"CD", "[", 
        RowBox[{"-", "d"}], "]"}], "[", 
       RowBox[{"S", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", "c"}], "]"}], "]"}]}], ",", "metricg"}], 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "d"}], "]"}], "[", 
    RowBox[{"S", "[", 
     RowBox[{"b", ",", "c"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ContractMetric",
    HoldForm], ",", "6", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ContractMetric", ",", "\[IndentingNewLine]", 
   RowBox[{"ContractMetric", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"metricg", "[", 
       RowBox[{"a", ",", "b"}], "]"}], 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "d"}], "]"}], "[", 
       RowBox[{"S", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", "c"}], "]"}], "]"}]}], ",", "metricg"}], 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"metricg", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{
     RowBox[{"PD", "[", 
      RowBox[{"-", "d"}], "]"}], "[", 
     RowBox[{"S", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", "c"}], "]"}], "]"}]}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ContractMetric",
    HoldForm], ",", "7", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ContractMetric", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ContractMetric", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"metricg", "[", 
        RowBox[{"a", ",", "b"}], "]"}], 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "d"}], "]"}], "[", 
        RowBox[{"S", "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", "c"}], "]"}], "]"}]}], ",", "metricg", ",", 
      RowBox[{"OverDerivatives", "\[Rule]", "True"}]}], "]"}], "//", 
    "ScreenDollarIndices"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"metricg", "[", 
       RowBox[{"b", ",", "e"}], "]"}], 
      RowBox[{"S", "[", 
       RowBox[{"a", ",", "c"}], "]"}], 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "d"}], "]"}], "[", 
       RowBox[{"metricg", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "e"}]}], "]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"PD", "[", 
       RowBox[{"-", "d"}], "]"}], "[", 
      RowBox[{"S", "[", 
       RowBox[{"b", ",", "c"}], "]"}], "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ContractMetric",
    HoldForm], ",", "8", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Here we need the tests of \[OpenCurlyDoubleQuote]Canonicalization with a \
metric\[CloseCurlyDoubleQuote].\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToTensorDerivative", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "@", 
        RowBox[{
         RowBox[{"PD", "[", "a", "]"}], "@", 
         RowBox[{"v", "[", 
          RowBox[{"-", "a"}], "]"}]}]}], "-", 
       RowBox[{
        RowBox[{"PD", "[", "a", "]"}], "@", 
        RowBox[{
         RowBox[{"PD", "[", 
          RowBox[{"-", "b"}], "]"}], "@", 
         RowBox[{"v", "[", 
          RowBox[{"-", "a"}], "]"}]}]}]}], "//", "ToTensorDerivative"}], "//",
      "ToCanonical"}], "//", "ScreenDollarIndices"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"v", "[", "a", "]"}]}], 
      RowBox[{
       RowBox[{"TensorDerivative", "[", 
        RowBox[{"metricg", ",", "PD"}], "]"}], "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], 
      RowBox[{
       RowBox[{"TensorDerivative", "[", 
        RowBox[{"metricg", ",", "PD"}], "]"}], "[", 
       RowBox[{"c", ",", "d", ",", 
        RowBox[{"-", "b"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{
       RowBox[{"TensorDerivative", "[", 
        RowBox[{"metricg", ",", "PD"}], "]"}], "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], 
      RowBox[{
       RowBox[{"TensorDerivative", "[", 
        RowBox[{"v", ",", "PD"}], "]"}], "[", 
       RowBox[{"a", ",", "c"}], "]"}]}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToTensorDerivative",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToTensorDerivative", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"U", "[", 
       RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "a"}], "]"}], "[", 
       RowBox[{"v", "[", "d", "]"}], "]"}], 
      RowBox[{
       RowBox[{"PD", "[", 
        RowBox[{"-", "b"}], "]"}], "[", 
       RowBox[{"v", "[", "e", "]"}], "]"}], 
      RowBox[{"metricg", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", 
        RowBox[{"-", "e"}]}], "]"}]}], "//", "ToTensorDerivative"}], "//", 
    "ToCanonical"}], ",", "\[IndentingNewLine]", "0", ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToTensorDerivative",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToTensorDerivative", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"U", "[", 
        RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"v", "[", 
         RowBox[{"-", "d"}], "]"}], "]"}], 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "b"}], "]"}], "[", 
        RowBox[{"v", "[", "e", "]"}], "]"}], 
       RowBox[{"metricg", "[", 
        RowBox[{"d", ",", 
         RowBox[{"-", "e"}]}], "]"}]}], "//", "ToTensorDerivative"}], "//", 
     "ToCanonical"}], "//", "ScreenDollarIndices"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"U", "[", 
       RowBox[{"c", ",", 
        RowBox[{"-", "e"}], ",", 
        RowBox[{"-", "d"}]}], "]"}]}], 
     RowBox[{"v", "[", "a", "]"}], 
     RowBox[{
      RowBox[{"TensorDerivative", "[", 
       RowBox[{"metricg", ",", "PD"}], "]"}], "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", "d"}], "]"}], 
     RowBox[{
      RowBox[{"TensorDerivative", "[", 
       RowBox[{"v", ",", "PD"}], "]"}], "[", 
      RowBox[{"b", ",", "e"}], "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToTensorDerivative",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ToTensorDerivative", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"T", "[", 
        RowBox[{"a", ",", 
         RowBox[{"-", "b"}], ",", "c"}], "]"}], 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "d"}], "]"}], "[", 
        RowBox[{"v", "[", 
         RowBox[{"-", "a"}], "]"}], "]"}], 
       RowBox[{
        RowBox[{"PD", "[", 
         RowBox[{"-", "e"}], "]"}], "[", 
        RowBox[{"v", "[", "b", "]"}], "]"}], 
       RowBox[{"metricg", "[", 
        RowBox[{"d", ",", "e"}], "]"}]}], "//", "ToTensorDerivative"}], "//", 
     "ToCanonical"}], "//", "ScreenDollarIndices"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"T", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
     RowBox[{"v", "[", "d", "]"}], 
     RowBox[{
      RowBox[{"TensorDerivative", "[", 
       RowBox[{"metricg", ",", "PD"}], "]"}], "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], 
     RowBox[{
      RowBox[{"TensorDerivative", "[", 
       RowBox[{"v", ",", "PD"}], "]"}], "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", "e"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"metricg", "[", 
      RowBox[{
       RowBox[{"-", "d"}], ",", 
       RowBox[{"-", "e"}]}], "]"}], 
     RowBox[{"T", "[", 
      RowBox[{"a", ",", "b", ",", "c"}], "]"}], 
     RowBox[{
      RowBox[{"TensorDerivative", "[", 
       RowBox[{"v", ",", "PD"}], "]"}], "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", "d"}], "]"}], 
     RowBox[{
      RowBox[{"TensorDerivative", "[", 
       RowBox[{"v", ",", "PD"}], "]"}], "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", "e"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ToTensorDerivative",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"MetricsOfVBundle", ",", "\[IndentingNewLine]", 
   RowBox[{"MetricsOfVBundle", "[", "TangentM3", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", "metricg", "}"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["MetricsOfVBundle",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefMetric", ",", "\[IndentingNewLine]", 
   RowBox[{"DefMetric", "[", 
    RowBox[{"1", ",", 
     RowBox[{"frozen", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], ",", "CD2", ",", 
     RowBox[{"SymbolOfCovD", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<|\>\"", ",", "\"\<D\>\""}], "}"}]}], ",", 
     RowBox[{"PrintAs", "\[Rule]", "\"\<f\>\""}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "True"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"DefMetric", "::", "old"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"There are already metrics \[NoBreak]\\!\\({metricg}\\)\
\[NoBreak] in vbundle \[NoBreak]\\!\\(\\*InterpretationBox[StyleBox[\\\"\
\[DoubleStruckCapitalT]M3\\\", Rule[AutoSpacing, False], Rule[ShowAutoStyles, \
False]], TangentM3, Rule[Editable, False]]\\)\[NoBreak].\"\>"}]], "Message", \
"MSG"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"frozen", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric metric tensor ", 
   $CellContext`frozen[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"inverse metric tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"Invfrozen", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Metric is frozen!\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "inverse metric tensor ", 
   $CellContext`Invfrozen[$CellContext`a, $CellContext`b], ". ", 
   "Metric is frozen!"],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefMetric: Don't know yet how to define epsilon for a \
frozen metric.\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CD2", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CD2[-$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionCD2", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionCD2[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCD2", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCD2[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannDownCD2", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannDownCD2[-$CellContext`a, -$CellContext`b, \
-$CellContext`c, -$CellContext`d], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCD2", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"Antisymmetric only in the first pair.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCD2[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
$CellContext`d], ". ", "Antisymmetric only in the first pair."],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCD2", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric Ricci tensor ", 
   $CellContext`RicciCD2[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCD2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCD2[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCD2", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Einstein tensor ", 
   $CellContext`EinsteinCD2[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCD2", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Weyl tensor ", 
   $CellContext`WeylCD2[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCD2", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "symmetric TFRicci tensor ", 
   $CellContext`TFRicciCD2[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCD2", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCD2[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 3],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 3],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"Detfrozen", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`Detfrozen[], ". ", "Determinant."],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefMetric",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"MetricsOfVBundle", ",", "\[IndentingNewLine]", 
   RowBox[{"MetricsOfVBundle", "[", "TangentM3", "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"metricg", ",", "frozen"}], "}"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["MetricsOfVBundle",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"delta", ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"metricg", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "b"}]}], "]"}], ",", 
     RowBox[{"frozen", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"delta", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", "a"}], "]"}], ",", 
     RowBox[{"frozen", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "b"}]}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["delta",
    HoldForm], ",", "10", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"delta", ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"frozen", "[", 
       RowBox[{"a", ",", "c"}], "]"}], 
      RowBox[{"frozen", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "b"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"metricg", "[", 
       RowBox[{"a", ",", "c"}], "]"}], 
      RowBox[{"frozen", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "b"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"metricg", "[", 
       RowBox[{"a", ",", "c"}], "]"}], 
      RowBox[{"metricg", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "b"}]}], "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"frozen", "[", 
       RowBox[{"a", ",", "c"}], "]"}], 
      RowBox[{"frozen", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "b"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"frozen", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], 
      RowBox[{"metricg", "[", 
       RowBox[{"a", ",", "c"}], "]"}]}], ",", 
     RowBox[{"delta", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", "a"}], "]"}]}], "}"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["delta",
    HoldForm], ",", "11", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ContractMetric", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"frozen", "[", 
        RowBox[{"a", ",", "c"}], "]"}], 
       RowBox[{"frozen", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}]}], "]"}]}], ",", 
      RowBox[{
       RowBox[{"frozen", "[", 
        RowBox[{
         RowBox[{"-", "c"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], 
       RowBox[{"metricg", "[", 
        RowBox[{"a", ",", "c"}], "]"}]}], ",", 
      RowBox[{"delta", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", "a"}], "]"}]}], "}"}], "//", 
    "ContractMetric"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"frozen", "[", 
       RowBox[{"a", ",", "c"}], "]"}], 
      RowBox[{"frozen", "[", 
       RowBox[{
        RowBox[{"-", "c"}], ",", 
        RowBox[{"-", "b"}]}], "]"}]}], ",", 
     RowBox[{"frozen", "[", 
      RowBox[{"a", ",", 
       RowBox[{"-", "b"}]}], "]"}], ",", 
     RowBox[{"delta", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", "a"}], "]"}]}], "}"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ContractMetric",
    HoldForm], ",", "9", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"delta", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Invfrozen", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{"frozen", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"delta", "[", 
    RowBox[{
     RowBox[{"-", "c"}], ",", "a"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["delta",
    HoldForm], ",", "12", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Einstein", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CD2", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"EinsteinCD2", "[", 
     RowBox[{"a", ",", "b"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"CD2", "[", 
     RowBox[{"-", "a"}], "]"}], "[", 
    RowBox[{"EinsteinCD2", "[", 
     RowBox[{"a", ",", "b"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Einstein",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Einstein", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Invfrozen", "[", 
     RowBox[{"a", ",", "b"}], "]"}], 
    RowBox[{
     RowBox[{"CD2", "[", 
      RowBox[{"-", "a"}], "]"}], "[", 
     RowBox[{"EinsteinCD2", "[", 
      RowBox[{
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}]}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", "0", 
   ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Einstein",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SymmetryGroupOfTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"SymmetryGroupOfTensor", "[", 
    RowBox[{"RiemannCD2", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", "d"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{"-", 
       RowBox[{"xAct`xPerm`Cycles", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "]"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SymmetryGroupOfTensor",
    HoldForm], ",", "8", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"SymmetryGroupOfTensor", ",", "\[IndentingNewLine]", 
   RowBox[{"SymmetryGroupOfTensor", "[", 
    RowBox[{"RiemannDownCD2", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"GenSet", "[", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"xAct`xPerm`Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], "]"}]}], ",", 
       RowBox[{"-", 
        RowBox[{"xAct`xPerm`Cycles", "[", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4"}], "}"}], "]"}]}], ",", 
       RowBox[{"xAct`xPerm`Cycles", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["SymmetryGroupOfTensor",
    HoldForm], ",", "9", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Riemann", ",", "\[IndentingNewLine]", 
   RowBox[{"RiemannCD2", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"RiemannCD2", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Riemann",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"RiemannToRiemannDown", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannCD2", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}], ",", "d"}], "]"}], "//", "RiemannToRiemannDown"}], 
    "//", "ScreenDollarIndices"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Invfrozen", "[", 
     RowBox[{"e", ",", "d"}], "]"}], 
    RowBox[{"RiemannDownCD2", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "e"}]}], "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["RiemannToRiemannDown",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"RiemannDownToRiemann", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Invfrozen", "[", 
      RowBox[{"e", ",", "d"}], "]"}], 
     RowBox[{"RiemannDownCD2", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}], ",", 
       RowBox[{"-", "c"}], ",", 
       RowBox[{"-", "e"}]}], "]"}]}], "//", "RiemannDownToRiemann"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"RiemannCD2", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], ",", "\[IndentingNewLine]", 
   "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["RiemannDownToRiemann",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefMetric", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefMetric", "[", "frozen", "]"}], ",", "\[IndentingNewLine]", 
   "Null", ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Detfrozen"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "weight +2 density", 
   " ", $CellContext`Detfrozen],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "ChristoffelCD2"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Christoffel tensor", " ", $CellContext`ChristoffelCD2],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Einstein tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "EinsteinCD2"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "symmetric Einstein tensor", " ", $CellContext`EinsteinCD2],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "KretschmannCD2"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Kretschmann scalar", 
   " ", $CellContext`KretschmannCD2],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciCD2"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric Ricci tensor", 
   " ", $CellContext`RicciCD2],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciScalarCD2"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci scalar", 
   " ", $CellContext`RicciScalarCD2],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannCD2"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannCD2],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannDownCD2"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannDownCD2],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric TFRicci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TFRicciCD2"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric TFRicci tensor",
    " ", $CellContext`TFRicciCD2],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionCD2"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionCD2],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "WeylCD2"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Weyl tensor", 
   " ", $CellContext`WeylCD2],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "CD2"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "covariant derivative", 
   " ", $CellContext`CD2],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"inverse metric tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "Invfrozen"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "inverse metric tensor", 
   " ", $CellContext`Invfrozen],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric metric tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "frozen"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "symmetric metric tensor", 
   " ", $CellContext`frozen],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefMetric",
    HoldForm], ",", "3", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Riemann", ",", "\[IndentingNewLine]", 
   RowBox[{"RiemannCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "a"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"-", 
    RowBox[{"RicciCD", "[", 
     RowBox[{
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}]}], "]"}]}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Riemann",
    HoldForm], ",", "4", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Ricci", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"metricg", "[", 
     RowBox[{"c", ",", "d"}], "]"}], 
    RowBox[{"RicciCD", "[", 
     RowBox[{
      RowBox[{"-", "d"}], ",", 
      RowBox[{"-", "c"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"RicciScalarCD", "[", "]"}], ",", "\[IndentingNewLine]", "False"}],
   "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Ricci",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Ricci", ",", "\[IndentingNewLine]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "a"}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"RicciScalarCD", "[", "]"}], ",", "\[IndentingNewLine]", "False"}],
   "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Ricci",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"EinsteinToRicci", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"EinsteinCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], "//", "EinsteinToRicci"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RicciCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "-", 
     RowBox[{
      RowBox[{"1", "/", "2"}], 
      RowBox[{"metricg", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "a"}]}], "]"}], 
      RowBox[{"RicciScalarCD", "[", "]"}]}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["EinsteinToRicci",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"RicciToEinstein", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RicciCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "-", 
     RowBox[{
      RowBox[{"1", "/", "2"}], 
      RowBox[{"metricg", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "a"}]}], "]"}], 
      RowBox[{"RicciScalarCD", "[", "]"}]}]}], "//", "RicciToEinstein"}], ",",
    "\[IndentingNewLine]", 
   RowBox[{"EinsteinCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["RicciToEinstein",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"Weyl", ",", "\[IndentingNewLine]", 
   RowBox[{"WeylCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], ",", "\[IndentingNewLine]", "0", ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["Weyl",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"RiemannToWeyl", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"RiemannCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}], ",", 
      RowBox[{"-", "c"}], ",", 
      RowBox[{"-", "d"}]}], "]"}], "//", "RiemannToWeyl"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"metricg", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "*", 
      RowBox[{"RicciCD", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"metricg", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "*", 
      RowBox[{"RicciCD", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "d"}]}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"metricg", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "d"}]}], "]"}], "*", 
      RowBox[{"RicciCD", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "c"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"metricg", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}]}], "]"}], "*", 
      RowBox[{"RicciCD", "[", 
       RowBox[{
        RowBox[{"-", "b"}], ",", 
        RowBox[{"-", "d"}]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"metricg", "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "*", 
        RowBox[{"metricg", "[", 
         RowBox[{
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "c"}]}], "]"}], "*", 
        RowBox[{"RicciScalarCD", "[", "]"}]}], ")"}], "/", "2"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"metricg", "[", 
         RowBox[{
          RowBox[{"-", "a"}], ",", 
          RowBox[{"-", "c"}]}], "]"}], "*", 
        RowBox[{"metricg", "[", 
         RowBox[{
          RowBox[{"-", "b"}], ",", 
          RowBox[{"-", "d"}]}], "]"}], "*", 
        RowBox[{"RicciScalarCD", "[", "]"}]}], ")"}], "/", "2"}]}], "//", 
    "Evaluate"}], ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["RiemannToWeyl",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"RicciToTFRicci", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"RicciCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}], "//", "RicciToTFRicci"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TFRicciCD", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], "+", 
     RowBox[{
      RowBox[{"metricg", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], 
      RowBox[{
       RowBox[{"RicciScalarCD", "[", "]"}], "/", "3"}]}]}], "//", 
    "Evaluate"}], ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["RicciToTFRicci",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"TFRicciToRicci", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"TFRicciCD", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], "+", 
      RowBox[{
       RowBox[{"metricg", "[", 
        RowBox[{
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "b"}]}], "]"}], 
       RowBox[{
        RowBox[{"RicciScalarCD", "[", "]"}], "/", "3"}]}]}], "//", 
     "TFRicciToRicci"}], "//", "ToCanonical"}], ",", "\[IndentingNewLine]", 
   RowBox[{"RicciCD", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["TFRicciToRicci",
    HoldForm], ",", "1", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"DefCovD", ",", "\[IndentingNewLine]", 
   RowBox[{"DefCovD", "[", 
    RowBox[{
     RowBox[{"CDT", "[", 
      RowBox[{"-", "a"}], "]"}], ",", 
     RowBox[{"SymbolOfCovD", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<#\>\"", ",", "\"\<D\>\""}], "}"}]}], ",", 
     RowBox[{"Torsion", "\[Rule]", "True"}], ",", 
     RowBox[{"FromMetric", "\[Rule]", "metricg"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "Null", ",", "\[IndentingNewLine]", "False"}], 
  "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative \"\>", "\[InvisibleSpace]", 
   
   RowBox[{"CDT", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "covariant derivative ", 
   $CellContext`CDT[-$CellContext`a], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"TorsionCDT", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "torsion tensor ", 
   $CellContext`TorsionCDT[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDT", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Christoffel tensor ", 
   $CellContext`ChristoffelCDT[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"RiemannCDT", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric pairs cannot be exchanged.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Riemann tensor ", 
   $CellContext`RiemannCDT[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", "Antisymmetric pairs cannot be exchanged."],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciCDT", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "non-symmetric Ricci tensor ", 
   $CellContext`RicciCDT[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Riemann automatically replaced \
by Ricci.\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"RicciScalarCDT", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Ricci scalar ", 
   $CellContext`RicciScalarCDT[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData["\<\"** DefCovD:  Contractions of Ricci automatically replaced \
by RicciScalar.\"\>"], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Einstein tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"EinsteinCDT", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric Einstein tensor ", 
   $CellContext`EinsteinCDT[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Weyl tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"WeylCDT", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Antisymmetric pairs cannot be exchanged.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Weyl tensor ", 
   $CellContext`WeylCDT[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", "Antisymmetric pairs cannot be exchanged."],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric TFRicci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TFRicciCDT", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "non-symmetric TFRicci tensor ", 
   $CellContext`TFRicciCDT[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar \"\>", "\[InvisibleSpace]", 
   RowBox[{"KretschmannCDT", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "Kretschmann scalar ", 
   $CellContext`KretschmannCDT[], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RiemannToWeylRules for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RiemannToWeylRules for dim ", 3],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToTFRicci for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RicciToTFRicci for dim ", 3],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** DefCovD:  Computing RicciToEinsteinRules for dim \"\>", 
   "\[InvisibleSpace]", "3"}],
  SequenceForm["** DefCovD:  Computing RicciToEinsteinRules for dim ", 3],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["DefCovD",
    HoldForm], ",", "9", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ChangeCovD", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ChangeCovD", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"CDT", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"v", "[", "b", "]"}], "]"}], "-", 
       RowBox[{
        RowBox[{"CD", "[", 
         RowBox[{"-", "a"}], "]"}], "[", 
        RowBox[{"v", "[", "b", "]"}], "]"}]}], ",", "CDT", ",", "CD"}], "]"}],
     "//", "ScreenDollarIndices"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"ChristoffelCDCDT", "[", 
       RowBox[{"b", ",", 
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "c"}]}], "]"}]}], 
     RowBox[{"v", "[", "c", "]"}]}], "//", "Evaluate"}], ",", 
   "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDCDT", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`ChristoffelCDCDT[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChangeCovD",
    HoldForm], ",", "11", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"ChristoffelToGradMetric", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"ChristoffelCDCDT", "[", 
        RowBox[{"b", ",", 
         RowBox[{"-", "a"}], ",", 
         RowBox[{"-", "c"}]}], "]"}]}], 
      RowBox[{"v", "[", "c", "]"}]}], "//", "ChristoffelToGradMetric"}], "//",
     "ScreenDollarIndices"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"metricg", "[", 
         RowBox[{"b", ",", "d"}], "]"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"TorsionCDT", "[", 
           RowBox[{
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "c"}], ",", 
            RowBox[{"-", "d"}]}], "]"}], "+", 
          RowBox[{"TorsionCDT", "[", 
           RowBox[{
            RowBox[{"-", "c"}], ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "d"}]}], "]"}], "-", 
          RowBox[{"TorsionCDT", "[", 
           RowBox[{
            RowBox[{"-", "d"}], ",", 
            RowBox[{"-", "a"}], ",", 
            RowBox[{"-", "c"}]}], "]"}]}], ")"}], "*", 
        RowBox[{"v", "[", "c", "]"}]}], ")"}]}], "/", "2"}], "//", 
    "Evaluate"}], ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["ChristoffelToGradMetric",
    HoldForm], ",", "2", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xTest", "[", 
  RowBox[{"UndefCovD", ",", "\[IndentingNewLine]", 
   RowBox[{"UndefCovD", "[", "CDT", "]"}], ",", "\[IndentingNewLine]", "Null",
    ",", "\[IndentingNewLine]", "False"}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"tensor\"\>", "\[InvisibleSpace]", "\<\" \"\>", 
   "\[InvisibleSpace]", "ChristoffelCDCDT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "tensor", 
   " ", $CellContext`ChristoffelCDCDT],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Christoffel tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "ChristoffelCDT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Christoffel tensor", " ", $CellContext`ChristoffelCDT],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Einstein tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "EinsteinCDT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Einstein tensor", " ", $CellContext`EinsteinCDT],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Kretschmann scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "KretschmannCDT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Kretschmann scalar", 
   " ", $CellContext`KretschmannCDT],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric Ricci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciCDT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric Ricci tensor", " ", $CellContext`RicciCDT],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Ricci scalar\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RicciScalarCDT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Ricci scalar", 
   " ", $CellContext`RicciScalarCDT],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Riemann tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "RiemannCDT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Riemann tensor", 
   " ", $CellContext`RiemannCDT],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"non-symmetric TFRicci tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TFRicciCDT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", 
   "non-symmetric TFRicci tensor", " ", $CellContext`TFRicciCDT],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"torsion tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "TorsionCDT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "torsion tensor", 
   " ", $CellContext`TorsionCDT],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefTensor", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"Weyl tensor\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "WeylCDT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefTensor, ": Undefined ", "Weyl tensor", 
   " ", $CellContext`WeylCDT],
  Editable->False]], "Print"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "UndefCovD", 
   "\[InvisibleSpace]", "\<\": Undefined \"\>", 
   "\[InvisibleSpace]", "\<\"covariant derivative\"\>", 
   "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", "CDT"}],
  SequenceForm[
  "** ", xAct`xTensor`UndefCovD, ": Undefined ", "covariant derivative", 
   " ", $CellContext`CDT],
  Editable->False]], "Print"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox["UndefCovD",
    HoldForm], ",", "5", ",", "True"}], "}"}]], "Output"]
}, Open  ]],

Cell["\<\
Continue with \[OpenCurlyDoubleQuote]Product metrics\[CloseCurlyDoubleQuote].\
\
\>", "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3. Collect results", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TimeUsed", "[", "]"}], ",", 
   RowBox[{"SessionTime", "[", "]"}]}], "}"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"16.782262`", ",", "42.580931`8.080760146223982"}], "}"}]], "Output"]
}, Open  ]],

Cell["Execute this cell to check whether all tests were passed:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CheckTests", "[", "]"}]], "Input"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"All \"\>", "\[InvisibleSpace]", "419", 
   "\[InvisibleSpace]", "\<\" tests passed\"\>"}],
  SequenceForm["All ", 419, " tests passed"],
  Editable->False]], "Print"]
}, Open  ]],

Cell["\<\
If everything went right, the sentence \[OpenCurlyDoubleQuote]All <n> tests \
passed\[CloseCurlyDoubleQuote] should have been printed. Otherwise, please \
save this notebook now, compress it, and send it to jose@xact.es.\
\>", "Text"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{685, 749},
WindowMargins->{{244, Automatic}, {Automatic, 0}},
ShowSelection->True,
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Default.nb"
]

