Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["xTerior",
 FontSlant->"Italic",
 FontColor->RGBColor[
  1, 0, 0]]], "Title",ExpressionUUID->"a36dc454-36c4-4650-bc22-93da6b66112b"],

Cell[TextData[{
 StyleBox["Exterior Calculus for ",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["xAct",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]]
}], "Subtitle",ExpressionUUID->"307f2423-c79e-440f-bec6-01a1629448ea"],

Cell[TextData[{
 StyleBox["Alfonso Garc\[IAcute]a-Parrado\n",
  FontSize->18],
 StyleBox["agparrado@uco.es",
  FontSize->14],
 StyleBox["\n",
  FontSize->18],
 StyleBox["Universidad de C\[OAcute]rdoba, Spain",
  FontSize->14],
 StyleBox["\n",
  FontSize->18],
 "\n",
 StyleBox["Leo C. Stein\n",
  FontSize->18],
 StyleBox["leo.stein@gmail.com\nU of MS, MS, United States\n",
  FontSize->14],
 "\n",
 StyleBox["(c) 2013-2026, under GPL\n\nhttp://www.xAct.es/\n\
http://groups.google.com/group/xAct\nhttps://github.com/xAct-contrib",
  FontSize->14]
}], "Subsubtitle",ExpressionUUID->"9c7a3a74-9e80-47f1-89e9-5ebb4a6bb285"],

Cell[TextData[{
 StyleBox["xTerior",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 0]],
 " is a package for exterior calculus in xAct.\n\n",
 StyleBox["xTerior",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0, 0]],
 " is distributed under the GNU General Public License, and runs on top of ",
 StyleBox["xTensor ",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 "and ",
 StyleBox["xCoba",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 " which are free packages for fast manipulation of abstract and component \
tensor expressions. All packages can be downloaded from ",
 ButtonBox["http://www.xact.es/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.xact.es"], None},
  ButtonNote->"http://www.xact.es"]
}], "Text",ExpressionUUID->"ee26d083-d139-430f-a4a7-5156cf860483"],

Cell[CellGroupData[{

Cell[BoxData["Today"], \
"Input",ExpressionUUID->"e931310c-7d6b-45be-be30-650063a9f39c"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"\"Mon 29 Dec 2025\""}], 
   RowBox[{"DateObject", "[", 
     RowBox[{
       RowBox[{"{", 
         RowBox[{"2025", ",", "12", ",", "29"}], "}"}], ",", "\"Day\""}], 
     "]"}]},
  "DateObject",
  Editable->
   False]], "Output",ExpressionUUID->"80dd87af-055d-42bf-bf0a-af69a5f6ce4a"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"xAct`xTerior`$xTensorVersionExpected", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<1.1.2\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2015", ",", "8", ",", "23"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`xTerior`$Version", "=", 
   RowBox[{"{", 
    RowBox[{"\"\<0.9.1\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2019", ",", "5", ",", "17"}], "}"}]}], "}"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"fd4f8e32-7a22-432e-99ea-e2920153911f"],

Cell[CellGroupData[{

Cell[TextData[{
 "1. ",
 StyleBox["Initialization",
  FontColor->RGBColor[0, 0, 1]]
}], "Subsection",
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"178c878b-c3f6-4680-b46d-e210d4fc9683"],

Cell[CellGroupData[{

Cell["1.0. TODO list", \
"Subsubsection",ExpressionUUID->"4a601cde-fa84-4b6c-a86e-121a71e33e96"],

Cell[TextData[{
 StyleBox["TODO : ",
  FontWeight->"Bold"],
 "\n-Add some option to DefDiffForm which allows the user to include the \
degree in the printing output.\n-In the definition of the connection forms \
there are no checks about the manifolds in which the covariant derivatives \
are defined and they may well be defined in different tangent bundles.\n\
-ContractBasis and ToBasis commute with the exterior derivative. Implement \
it. This is partially done."
}], "Text",ExpressionUUID->"b3bb8f0e-7beb-4aa1-ab1e-be7a922794ae"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Diff", "[", 
  RowBox[{
   RowBox[{"FBasis", "[", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", "B"}], "]"}], ",", "cd"}], 
  "]"}]], "Input",ExpressionUUID->"63584cce-4f74-447b-8d20-375dd2e31da4"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SuperscriptBox["d", "\[EmptyDownTriangle]"], "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Theta]", 
         StyleBox[GridBox[{
            {
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Coframe[$CellContext`M][{1, $CellContext`B}],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTerior`Diff[
   xAct`xTerior`Coframe[$CellContext`M][{1, $CellContext`B}], $CellContext`cd],
  Editable->
   False]], "Output",ExpressionUUID->"040c061c-e78e-47be-8a36-8a4672a87baa"]
}, Open  ]],

Cell[TextData[StyleBox["There\[CloseCurlyQuote]s a bug here, this should have \
expressed the exterior covariant derivative in terms of the usual exterior \
derivative.",
 FontWeight->
  "Bold"]], "Text",ExpressionUUID->"a9561c9b-0ad6-41ee-803d-0b144a4700ab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChangeExtD", "[", 
  RowBox[{"%", ",", "cd", ",", "PD"}], 
  "]"}]], "Input",ExpressionUUID->"b507d8cf-4767-4338-a938-91e749bc16f3"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{"d", "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[Theta]", 
         StyleBox[GridBox[{
            {
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]]},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->Rational[39, 4]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     xAct`xTerior`Coframe[$CellContext`M][{1, $CellContext`B}],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTerior`Diff[
   xAct`xTerior`Coframe[$CellContext`M][{1, $CellContext`B}], xAct`xTensor`PD],
  Editable->
   False]], "Output",ExpressionUUID->"d6af2916-af00-4f4e-bfaf-ee82a2e7df30"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1. GPL", \
"Subsubsection",ExpressionUUID->"dd0d1043-6e5c-4916-b3db-91ff3a097074"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"xTerior", ":", " ", 
    RowBox[{
    "exterior", " ", "calculus", " ", "in", " ", "Differential", " ", 
     "Geometry"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Copyright", " ", 
     RowBox[{"(", "C", ")"}], " ", "2013"}], "-", 
    RowBox[{"2026", " ", "Alfonso", " ", "Garcia"}], "-", 
    RowBox[{"Parrado", " ", "Gomez"}], "-", 
    RowBox[{"Lobo", " ", "and", " ", "Leo", " ", 
     RowBox[{"C", ".", " ", "Stein"}]}]}], " ", "*)"}], "\[IndentingNewLine]",
   "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "This", " ", "program", " ", "is", " ", "free", " ", "software"}], ";", 
     " ", 
     RowBox[{"you", " ", "can", " ", "redistribute", " ", "it", " ", 
      RowBox[{"and", "/", "or"}], " ", "modify", " ", "it", " ", "under", " ",
       "the", " ", "terms", " ", "of", " ", "the", " ", "GNU", " ", "General",
       " ", "Public", " ", "License", " ", "as", " ", "published", " ", "by", 
      " ", "the", " ", "Free", " ", "Software", " ", "Foundation"}], ";", " ", 
     RowBox[{
     "either", " ", "version", " ", "2", " ", "of", " ", "the", " ", 
      "License"}]}], ",", 
    RowBox[{"or", " ", 
     RowBox[{"(", 
      RowBox[{"at", " ", "your", " ", "option"}], ")"}], " ", "any", " ", 
     "later", " ", 
     RowBox[{
     "version", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "This"}], " ",
      "program", " ", "is", " ", "distributed", " ", "in", " ", "the", " ", 
     "hope", " ", "that", " ", "it", " ", "will", " ", "be", " ", "useful"}], 
    ",", " ", 
    RowBox[{
     RowBox[{"but", " ", "WITHOUT", " ", "ANY", " ", "WARRANTY"}], ";", " ", 
     RowBox[{
     "without", " ", "even", " ", "the", " ", "implied", " ", "warranty", " ",
       "of", "\[IndentingNewLine]", "MERCHANTABILITY", " ", "or", " ", 
      "FITNESS", " ", "FOR", " ", "A", " ", "PARTICULAR", " ", 
      RowBox[{"PURPOSE", ".", " ", "See"}], " ", "the", " ", "GNU", " ", 
      "General", " ", "Public", " ", "License", " ", "for", " ", "more", " ", 
      
      RowBox[{
      "details", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "You"}], " ",
       "should", " ", "have", " ", "received", " ", "a", " ", "copy", " ", 
      "of", " ", "the", " ", "GNU", " ", "General", " ", "Public", " ", 
      "License", " ", "along", " ", "with", " ", "this", " ", "program"}], ";",
      " ", 
     RowBox[{"if", " ", "not"}]}], ",", " ", 
    RowBox[{
    "write", " ", "to", " ", "the", " ", "Free", " ", "Software", " ", 
     "Foundation"}], ",", " ", 
    RowBox[{"Inc", "."}], ",", " ", 
    RowBox[{
     RowBox[{"59", " ", "Temple", " ", "Place"}], "-", 
     RowBox[{"Suite", " ", "330"}]}], ",", " ", "Boston", ",", " ", 
    RowBox[{
     RowBox[{"MA", " ", "02111"}], "-", "1307"}], ",", " ", 
    RowBox[{"USA", "."}]}], " ", "\[IndentingNewLine]", "*)"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d34f0400-7fda-40c6-9481-0ac1ff56850d"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2. Info package", \
"Subsubsection",ExpressionUUID->"816a139d-bfc9-4731-9a28-58513c920869"],

Cell["\<\
(* :Title: xTerior *)

(* :Author: Alfonso Garcia-Parrado Gomez-Lobo and Leo C. Stein *)

(* :Summary: exterior calculus in Differential Geometry *)

(* :Brief Discussion:
   - xTerior extends xAct to work with differentiable forms in general \
manifolds.
   - Introduces the exterior algebra, the exterior derivative, the Hodge \
dual, the connection and curvature forms for an arbitrary connection, the \
exterior covariant derivative.
   
*)
  
(* :Context: xAct`xTerior` *)

(* :Package Version: 0.9.1 *)

(* :Copyright: Alfonso Garcia-Parrado Gomez-Lobo and Leo C. Stein (2013-2026) \
*)

(* :History: See xTerior.History *)

(* :Keywords: *)

(* :Source: xTerior.nb *)

(* :Warning: *)

(* :Mathematica Version: 9.0 and later *)

(* :Limitations:
\t- ?? *)\
\>", "Input",
 PageWidth:>PaperWidth,
 CellMargins->{{60, -272}, {Inherited, Inherited}},
 InitializationCell->
  True,ExpressionUUID->"8684c31b-ec15-4a4c-bbaa-c6cece9ba83f"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3. BeginPackage", \
"Subsubsection",ExpressionUUID->"aa8c0e80-2e9c-4661-b7c2-80ecc710210d"],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"xAct`xTerior`Private`xTeriorSymbols", "=", 
     RowBox[{"DeleteCases", "[", 
      RowBox[{
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Names", "[", "\"\<xAct`xTerior`*\>\"", "]"}], ",", 
         RowBox[{"Names", "[", "\"\<xAct`xTerior`Private`*\>\"", "]"}]}], 
        "]"}], ",", 
       RowBox[{"\"\<$Version\>\"", "|", "\"\<xAct`xTerior`$Version\>\"", 
        "|", "\"\<$xTensorVersionExpected\>\"", 
        "|", "\"\<xAct`xTerior`$xTensorVersionExpected\>\""}]}], "]"}]}], 
    "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unprotect", "/@", "xAct`xTerior`Private`xTeriorSymbols"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Clear", "/@", "xAct`xTerior`Private`xTeriorSymbols"}], ";"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"a8f4ffff-23b0-4ce6-990f-2e8584a21756"],

Cell[BoxData[
 RowBox[{
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Unevaluated", "[", "xAct`xCore`Private`$LastPackage", "]"}], "===",
      "xAct`xCore`Private`$LastPackage"}], ",", 
    RowBox[{
    "xAct`xCore`Private`$LastPackage", "=", "\"\<xAct`xTerior`\>\""}]}], 
   "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"5d66007f-935f-4d8e-8050-0d4326de669c"],

Cell[CellGroupData[{

Cell[BoxData["xAct`xCore`Private`$LastPackage"], \
"Input",ExpressionUUID->"144b918b-f9e6-407b-9ca0-dc611b780869"],

Cell[BoxData["\<\"xAct`xTerior`\"\>"], \
"Output",ExpressionUUID->"6647129e-5dca-4238-89bb-8fd386b9aa2a"]
}, Open  ]],

Cell[TextData[{
 "Explicit (not hidden) import of ",
 StyleBox["xTensor",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ", ",
 StyleBox["xPerm",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 " and ",
 StyleBox["xCore",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]],
 ": ",
 StyleBox["Alfonso: do we need xCoba ?",
  FontWeight->"Bold"]
}], "Text",ExpressionUUID->"e1f85c58-ceb1-4285-963a-90187e1b0ffb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BeginPackage", "[", 
  RowBox[{"\"\<xAct`xTerior`\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<xAct`xCoba`\>\"", ",", "\"\<xAct`xTensor`\>\"", 
     ",", "\"\<xAct`xPerm`\>\"", ",", "\"\<xAct`xCore`\>\""}], "}"}]}], 
  "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"920c528f-15e3-4de3-b2b4-192c03119393"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",ExpressionUUID->"cf7a70d9-46d1-4be6-8f73-17a186e9796b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xPerm`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.2.4\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}],
  SequenceForm["Package xAct`xPerm`  version ", "1.2.4", ", ", {2025, 12, 29}],
  Editable->
   False]], "Print",ExpressionUUID->"73741fb1-3007-44ba-843d-1072026dd009"],

Cell[BoxData["\<\"CopyRight (C) 2003-2026, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], \
"Print",ExpressionUUID->"b2908382-cd4e-4159-a470-e03a36f60b16"],

Cell[BoxData["\<\"Connecting to external mac executable...\"\>"], \
"Print",ExpressionUUID->"65b6add4-ce92-4e1b-9523-a533dff8ca1e"],

Cell[BoxData["\<\"Connection established.\"\>"], \
"Print",ExpressionUUID->"55d43e6c-36b3-47e0-b85b-fb54c7542086"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",ExpressionUUID->"6e80ea19-fdf0-495e-b41e-948754fd6951"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTensor`  version \"\>", 
   "\[InvisibleSpace]", "\<\"1.3.0\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2025", ",", "12", ",", "29"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTensor`  version ", "1.3.0", ", ", {2025, 12, 29}],
  Editable->
   False]], "Print",ExpressionUUID->"0f509f28-58ce-4a65-a3e8-205b8435abfa"],

Cell[BoxData["\<\"CopyRight (C) 2002-2026, Jose M. Martin-Garcia, under the \
General Public License.\"\>"], \
"Print",ExpressionUUID->"1d3fa3ef-d53e-4841-9696-c146677fc1c9"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",ExpressionUUID->"1bb3c734-1f52-4c13-93c2-84a8f788c095"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xCoba`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.8.6\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2021", ",", "2", ",", "28"}], "}"}]}],
  SequenceForm["Package xAct`xCoba`  version ", "0.8.6", ", ", {2021, 2, 28}],
  
  Editable->
   False]], "Print",ExpressionUUID->"0c4f0e2a-4d61-4005-b53e-13d38a363c96"],

Cell[BoxData["\<\"CopyRight (C) 2005-2026, David Yllanes and Jose M. \
Martin-Garcia, under the General Public License.\"\>"], \
"Print",ExpressionUUID->"25c93baa-c850-436b-9c5f-7488509f4e7e"]
}, Open  ]],

Cell[BoxData["\<\"xAct`xTerior`\"\>"], \
"Output",ExpressionUUID->"7a403322-2c1f-44ff-898c-176cc1d5e13e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{"Not", "@", 
    RowBox[{"OrderedQ", "@", 
     RowBox[{"Map", "[", 
      RowBox[{"Last", ",", 
       RowBox[{"{", 
        RowBox[{
        "xAct`xTerior`$xTensorVersionExpected", ",", 
         "xAct`xTensor`$Version"}], "}"}]}], "]"}]}]}], ",", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"General", "::", "versions"}], ",", "\"\<xTensor\>\"", ",", 
      "xAct`xTensor`$Version", ",", "xAct`xTerior`$xTensorVersionExpected"}], 
     "]"}]}]}], "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b5bbb677-c5df-4366-99a3-853e8e6f9440"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Package xAct`xTerior`  version \>\"", ",", 
    RowBox[{"xAct`xTerior`$Version", "[", 
     RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<, \>\"", ",", 
    RowBox[{"xAct`xTerior`$Version", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
  "Print", "[", "\"\<Copyright (C) 2013-2026, Alfonso Garcia-Parrado \
Gomez-Lobo and Leo C. Stein, under the General Public License.\>\"", "]"}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"69bc3ddb-f484-4105-800c-b8068d34f778"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",ExpressionUUID->"25df6b6b-0c40-44b4-a3d3-665ee2312b0f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Package xAct`xTerior`  version \"\>", 
   "\[InvisibleSpace]", "\<\"0.9.1\"\>", "\[InvisibleSpace]", "\<\", \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2019", ",", "5", ",", "17"}], "}"}]}],
  SequenceForm[
  "Package xAct`xTerior`  version ", "0.9.1", ", ", {2019, 5, 17}],
  Editable->
   False]], "Print",ExpressionUUID->"2bd91650-a9f4-4822-93e4-82a5a3a96c4f"],

Cell[BoxData["\<\"Copyright (C) 2013-2026, Alfonso Garcia-Parrado Gomez-Lobo \
and Leo C. Stein, under the General Public License.\"\>"], \
"Print",ExpressionUUID->"5230c7e8-1be4-4379-839c-cd2af7105272"]
}, Open  ]]
}, Open  ]],

Cell["\<\
We specify the context xAct`xTerior` to avoid overriding the Disclaimer of \
the other packages. However we need to turn off the message General:shdw \
temporarily:\
\>", "Text",ExpressionUUID->"2ddfd0ef-175a-4fc5-9187-2a1ca68ebdeb"],

Cell[BoxData[{
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"xAct`xTerior`Disclaimer", "[", "]"}], ":=", 
  RowBox[{
  "Print", "[", "\"\<These are points 11 and 12 of the General Public \
License:\\n\\nBECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO \
WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT \
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES \
PROVIDE THE PROGRAM `AS IS\.b4 WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED \
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF \
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO \
THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM \
PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR \
CORRECTION.\\n\\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO \
IN WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY \
AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR \
DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES \
ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT \
LIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED \
BY YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER \
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE \
POSSIBILITY OF SUCH DAMAGES.\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "shdw"}], "]"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"cab07881-9cca-4adf-b284-807ff8453bf5"],

Cell[TextData[{
 "If ",
 StyleBox["xTerior",
  FontSlant->"Italic"],
 " is not being called from other package then write this GPL short \
disclaimer:"
}], "Text",ExpressionUUID->"65f62862-2579-44d7-a77f-1d281083dcb8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
   "xAct`xCore`Private`$LastPackage", "===", "\"\<xAct`xTerior`\>\""}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unset", "[", "xAct`xCore`Private`$LastPackage", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{
    "Print", "[", "\"\<These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\>\"", "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", "xAct`xCore`Private`bars", "]"}]}]}], 
  "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2926a248-2e77-4662-b3d7-2427370450ad"],

Cell[CellGroupData[{

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",ExpressionUUID->"bbcf3479-27db-4836-a9c3-6800d4d45328"],

Cell[BoxData["\<\"These packages come with ABSOLUTELY NO WARRANTY; for \
details type Disclaimer[]. This is free software, and you are welcome to \
redistribute it under certain conditions. See the General Public License for \
details.\"\>"], \
"Print",ExpressionUUID->"cdfe0500-3f93-4051-9a4e-5d91db7e7780"],

Cell[BoxData["\<\"------------------------------------------------------------\
\"\>"], "Print",ExpressionUUID->"8bb64f4e-8ab5-4335-a627-552d81f55f65"]
}, Open  ]]
}, Open  ]],

Cell["\<\
Note that symbols in the Global` context cannot be accessed right now.\
\>", "Text",ExpressionUUID->"d5b3dea2-9afa-4130-b44b-cb602c8ac09c"],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], \
"Input",ExpressionUUID->"9ef3ba43-4536-42af-92f2-842e3845744e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`xTerior`\"\>", ",", "\<\"xAct`xCoba`\"\>", 
   ",", "\<\"xAct`xTensor`\"\>", ",", "\<\"xAct`xPerm`\"\>", 
   ",", "\<\"xAct`xCore`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"87e3a280-8b7d-4e88-88ef-38dd5a0fc580"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], \
"Input",ExpressionUUID->"1aab3032-d95a-4568-b0a2-40f5d64fa8f6"],

Cell[BoxData["\<\"xAct`xTerior`\"\>"], \
"Output",ExpressionUUID->"50df905c-61e1-4a70-92fe-b6f15526b03c"]
}, Open  ]],

Cell["Established connection to external executable?", \
"Text",ExpressionUUID->"612edfa1-4792-4936-9b2a-c46bc386ba42"],

Cell[CellGroupData[{

Cell[BoxData["$xpermQ"], \
"Input",ExpressionUUID->"62f4c944-da71-4c6d-9432-f35fa36b0080"],

Cell[BoxData["True"], \
"Output",ExpressionUUID->"3b490c81-fea5-4009-b1f3-b7f8d67c6f55"]
}, Open  ]],

Cell[TextData[{
 "Private functions of ",
 StyleBox["xTensor",
  FontSlant->"Italic"],
 " used here :\n      ??"
}], "Text",ExpressionUUID->"3021dfa8-7c06-47c7-8092-1bc6d99601da"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.4. Non-standard setup", \
"Subsubsection",ExpressionUUID->"1e4a4b17-519f-42d0-b6ce-ebedeaf644b2"],

Cell["Screen all dollar indices:", \
"Text",ExpressionUUID->"4328cbc9-1c31-42d3-a5f5-5cf4a444cd36"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$PrePrint", "=", "ScreenDollarIndices"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b0e614c7-28c3-48ed-b318-bdc24482f586"],

Cell["Switch off messages issued by ManifoldOfCovD acting on PD.", \
"Text",ExpressionUUID->"354f06c5-4714-4253-9d84-8d7d713d7c8c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "@", "PD"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"PD", "/:", 
  RowBox[{
   RowBox[{"ManifoldOfCovD", "@", "PD"}], "=."}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "@", "PD"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"ffcee1f3-0be2-4c1c-ade9-503c9ad20b7c"],

Cell["\<\
Timings will be shown if they are above 1 Second (Only for this notebook; \
this is not included in the package):\
\>", "Text",ExpressionUUID->"d258209f-dade-4fd2-9575-3f4cf35bb1df"],

Cell[BoxData[
 RowBox[{"<<", 
  "xAct/ShowTime1.m"}]], \
"Input",ExpressionUUID->"c51ef544-3bde-47ca-94da-1aa568dcdc42"],

Cell[CellGroupData[{

Cell[BoxData["$ShowTimeThreshold"], \
"Input",ExpressionUUID->"ae8c8e1f-d7bd-486e-95eb-1c5c3f9ca96a"],

Cell[BoxData["1"], \
"Output",ExpressionUUID->"8739180e-c4ee-4976-b4d4-1d8e34498eca"]
}, Open  ]],

Cell[TextData[{
 "We also read the package (this is not automatic in ",
 StyleBox["xCore",
  FontSlant->"Italic"],
 " anymore since its version 0.6.2). This is not included in the package."
}], "Text",ExpressionUUID->"c0d314bb-3dfd-4b14-baca-fd3151bf528a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", 
  "xAct/ExpressionManipulation.m"}]], \
"Input",ExpressionUUID->"2056e4d0-8a68-42b8-8385-e95a22024942"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Set", "::", "write"}], "MessageName"], ":", 
  " ", "\<\"Tag \[NoBreak]\\!\\(ColorPositions\\)\[NoBreak] in \
\[NoBreak]\\!\\(Options[ColorPositions]\\)\[NoBreak] is Protected. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/write\\\", \
ButtonNote -> \\\"Set::write\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"4916f61e-1eaa-4f94-a28a-98271fe89a63"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"SetDelayed", "::", "write"}], "MessageName"], ":", 
  " ", "\<\"Tag \[NoBreak]\\!\\(ColorPositions\\)\[NoBreak] in \
\[NoBreak]\\!\\(\\(\\(ColorPositions[\\(\\(positionlist_, \\(\\(opts___ ? \
OptionQ\\)\\)\\)\\)]\\)\\)[expr_]\\)\[NoBreak] is Protected. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/write\\\", \
ButtonNote -> \\\"SetDelayed::write\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"6df669b8-52f5-4107-8e49-7620b5e91c97"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"SetDelayed", "::", "write"}], "MessageName"], ":", 
  " ", "\<\"Tag \[NoBreak]\\!\\(CompleteTheSquare\\)\[NoBreak] in \
\[NoBreak]\\!\\(CompleteTheSquare[\\(\\(expr_, \\(\\(var_ : x\\)\\)\\)\\)]\\)\
\[NoBreak] is Protected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/write\\\", ButtonNote -> \
\\\"SetDelayed::write\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"fab14b31-039d-4693-98cc-3a9d0870dd73"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"SetDelayed", "::", "wrsym"}], "MessageName"], ":", 
  " ", "\<\"Symbol \[NoBreak]\\!\\(ErsekComplexity\\)\[NoBreak] is Protected. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/wrsym\\\", \
ButtonNote -> \\\"SetDelayed::wrsym\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"aeaee2d4-5177-44b0-b894-71592877ee58"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Set", "::", "wrsym"}], "MessageName"], ":", 
  " ", "\<\"Symbol \[NoBreak]\\!\\(ErsekComplexity\\)\[NoBreak] is Protected. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/wrsym\\\", \
ButtonNote -> \\\"Set::wrsym\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"55c4da9b-6f71-4a57-be0e-5945dfef80b2"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"SetDelayed", "::", "write"}], "MessageName"], ":", 
  " ", "\<\"Tag \[NoBreak]\\!\\(EvaluateAt\\)\[NoBreak] in \
\[NoBreak]\\!\\(\\(\\(EvaluateAt[\\(\\(\\(\\(posn : \\(\\(_Integer | \
\\(\\({__Integer}\\)\\)\\)\\)\\)\\), \\(\\(f_ : \
Identity\\)\\)\\)\\)]\\)\\)[expr_]\\)\[NoBreak] is Protected. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/write\\\", \
ButtonNote -> \\\"SetDelayed::write\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"7e5d40b7-eb54-4787-9587-9d749cb0cea8"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], ":", 
  " ", "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(SetDelayed :: \
write\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", \
"MSG",ExpressionUUID->"7f1c1534-dd90-45fa-af15-3212e1ca017d"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.5. Usage messages ", \
"Subsubsection",ExpressionUUID->"80ca7bec-e3f8-47cf-860b-a49c683e9437"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Definition", " ", "and", " ", "undefinition", " ", "of", " ", "a", " ", 
    "differential", " ", "form", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
      "just", " ", "a", " ", "wrapper", " ", "for", " ", "DefTensor", " ", 
       "with", " ", "the", " ", "option", " ", "GradeOfTensor"}], "\[Rule]", 
      RowBox[{"{", "Wedge", "}"}]}], ")"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"DefDiffForm", "::", "usage"}], 
     "=", "\"\<DefDiffForm[form[inds], mani, Deg] defines a tensor valued \
differential form of degree deg on the manifold mani\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefDiffForm", "::", "usage"}], 
     "=", "\"\<UndefDiffForm[form] undefines the differential form \
form\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Grade", " ", "of", " ", "a", " ", "differential", " ", "form"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Deg", "::", "usage"}], 
     "=", "\"\<Deg[form] returns the grade of a differential form\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DiffFormQ", "::", "usage"}], 
     "=", "\"\<DiffFormQ is an option for LieToCovD which specifies whether \
the expression which is acted upon should be regarded as a differential form \
or not. This is an option added by xTerior and it is not present any other \
package using LieToCovD.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Exterior", " ", "derivative", " ", "and", " ", "exterior", " ", 
     "covariant", " ", "derivative"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Diff", "::", "usage"}], 
     "=", "\"\<Diff[form] computes the exterior derivative of form. \
Diff[form,covd] computes the exterior covariant derivative of form with \
respect to the covariant derivative covd.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FindPotential", "::", "usage"}], 
     "=", "\"\<FindPotential[form, point, chart] uses the Poincar\[EAcute] \
lemma to compute a potential for a closed form form (no checks are carried \
out to ensure that the form is actually closed). The form must be written in \
some explicit coordinates belonging to chart and the argument point is the \
point, assumed to be in the same coordinate chart as form, which defines a \
star-shaped region where the potential is differentiable. A change in the \
point will give in general a different potential\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Computation", " ", "of", " ", "the", " ", "exterior", " ", "covariant", " ",
      "derivative"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChangeExtD", "::", "usage"}], 
     "=", "\"\<ChangeExtD[expr,cd1,cd2] expresses the exterior covariant \
derivative taken with respect to the connection defined by the covariant \
derivative cd1 in terms of the exterior covariant derivative taken with \
respect to the connection defined by the covariant derivative cd2\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Computation", " ", "of", " ", "the", " ", "generalized", " ", 
     RowBox[{"(", 
      RowBox[{"index", "-", "free"}], ")"}], " ", "covariant", " ", 
     "derivative"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChangeGenCovD", "::", "usage"}], 
     "=", "\"\<ChangeGenCovD[expr,cd1,cd2] expresses the generalized \
covariant derivative taken with respect to the connection defined by the \
covariant derivative cd1 in terms of the generalized covariant derivative \
taken with respect to the connection defined by the covariant derivative \
cd2\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Hodge", " ", "dual"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Hodge", "::", "usage"}], 
     "=", "\"\<Hodge[metric][expr] is the Hodge dual of expr defined with \
respect to metric\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ExpandHodgeDual", "::", "usage"}], 
     "=", "\"\<ExpandHodgeDual[expr,Coframe[mani],g] expands out all the \
Hodge duals of the exterior powers of Coframe[mani], defined with respect to \
the metric g. If the manifold tag mani is dropped, then all the instances of \
Coframe are expanded. The Coframe label can be replaced by dx if we are using \
the holonomic coframe.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Co", "-", "differential"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Codiff", "::", "usage"}], 
     "=", "\"\<Codiff[metric][form] is the co-differential of form computed \
with respect to metric\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Expansion", " ", "of", " ", "the", " ", "co"}], "-", 
     "differential"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CodiffToDiff", "::", "usage"}], 
     "=", "\"\<CodiffToDiff[expr] replaces all the instances of the \
co-differential in expr by their expansion in terms of the exterior \
derivative.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Interior", " ", "contraction"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Int", "::", "usage"}], 
     "=", "\"\<Int[v][form] is the interior contraction of form with the \
vector (rank 1-tensor) v\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Lie", " ", "derivative", " ", "on", " ", "forms"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CartanD", "::", "usage"}], 
     "=", "\"\<CartanD[v][form] is the Cartan derivative of form with respect \
to the vector (rank 1-tensor) v. CartanD[v][form,covd] is the Cartan \
derivative with respect to the covariant derivative covd.\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Cartan", " ", "formula", " ", "for", " ", "Lie", " ", "derivatives"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CartanDToDiff", "::", "usage"}], 
     "=", "\"\<CartanDToDiff[expr] replaces the Cartan derivative of all the \
differential forms in expr by their expansion obtained by means of the Cartan \
formula\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Put", " ", "derivations", " ", "into", " ", "canonical", " ", "order"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SortDerivations", "::", "usage"}], 
     "=", "\"\<SortDerivations[expr] brings expr into a new expression where \
all the derivations (exterior derivative, Lie derivative and interior \
contraction) are written in a canonical order. The default left-to-right \
order is defined by the variable $DerivationSortOrder\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"$DerivationSortOrder", "::", "usage"}], 
     "=", "\"\<$DerivationSortOrder is a global variable which encodes the \
default ordering of the three derivatives Int, LieD and Diff. The default is \
{LieD,Int,Diff}\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Variational", " ", "derivative", " ", "on", " ", "forms"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FormVarD", "::", "usage"}], 
     "=", "\"\<FormVarD[form,metric][expr] computes the variational \
derivative of expr, which must be a n-form with n the manifold dimension, \
with respect to form. In the computation, exterior derivatives are \
transformed into co-differentials taken with respect of metric.\>\""}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Canonical", " ", "forms", " ", "on", " ", "the", " ", "frame", " ", 
     "bundle"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Coframe", "::", "usage"}], 
     "=", "\"\<Coframe[mani] is the set of canonical 1-forms defined in the \
frame bundle arising from the manifold mani\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"dx", "::", "usage"}], 
     "=", "\"\<dx[mani] represents a holonomic co-frame in the manifold mani.\
\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Holonomic", " ", "&"}], " ", "anholonomic", " ", "frames"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"PDFrame", "::", "usage"}], 
     "=", "\"\<PDFrame[mani] represents a holonomic frame in the manifold \
mani.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"eFrame", "::", "usage"}], 
     "=", "\"\<eFrame[mani] represents a frame in the manifold mani.\>\""}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Koszul", " ", "connection"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Koszul", "::", "usage"}], 
     "=", "\"\<Koszul is the head used to introduce the Koszul operator. The \
latter is constructed by appending this head to the xTensor symbol used to \
represent a covariant derivative\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ExpandKoszul", "::", "usage"}], 
     "=", "\"\<ExpandKoszul[expr,cd1,cd2] expands Koszul derivations of frame \
or co-frame elements with respect to cd1 into Christoffel tensors relating \
the covariant derivatives cd1 and cd2\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ExpandCovD", "::", "usage"}], 
     "=", "\"\<ExpandCovD[expr,cd,chart] expands all the generalized \
covariant derivatives of rank 1 tensors in terms of the Koszul derivatives \
with respect to elements of a holonomic frame associated to a coordinate \
chart\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"The", " ", "connection", " ", "1"}], "-", "form"}], " ", "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ConnectionForm", "::", "usage"}], 
     "=", "\"\<ConnectionForm[cd,vbundle] represents the connection 1-form \
associated to the covariant derivatives cd defined in the bundle vbundle. If \
vbundle is the tangent bundle of a differentiable manifold then \
ConnectionForm is automatically replaced by ChristoffelForm (see the on-line \
help of ChristoffelForm for further details).\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"The", " ", "curvature", " ", "2"}], "-", "form"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CurvatureForm", "::", "usage"}], 
     "=", "\"\<CurvatureForm[cd,vbundle] represents the curvature 2-form \
associated to the covariant derivative cd. If vbundle is the tangent bundle \
of a differentiable manifold then CurvatureForm is replaced by \
RiemannForm\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Connection", " ", "2"}], "-", 
     RowBox[{
     "form", " ", "for", " ", "a", " ", "connection", " ", "in", " ", "a", " ",
       "frame", " ", "bundle"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChristoffelForm", "::", "usage"}], 
     "=", "\"\<ChristoffelForm[cd] is the connection 1-form associated to the \
covariant derivative cd which is a covariant derivative in the tangent bundle \
of a manifold\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Curvature", " ", "2"}], "-", 
     RowBox[{
     "form", " ", "for", " ", "a", " ", "connection", " ", "in", " ", "a", " ",
       "frame", " ", "bundle"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannForm", "::", "usage"}], 
     "=", "\"\<RiemannForm[cd] is the curvature 2-form associated to the \
covariant derivative cd which is a covariant derivative in the frame bundle \
of a manifold\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Transformation", " ", "of", " ", "the", " ", "connection", " ", "form", " ",
      "to", " ", "the", " ", "connection", " ", "tensor"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ConnectionFormToTensor", "::", "usage"}], 
     "=", "\"\<ConnectionFormToTensor[expr,covd,frame] transforms all \
instances of the connection form into the (A)Christoffel tensor which relates \
the covariant derivative defining the connection form and covd. The variable \
frame can take the value of either Coframe or dx. If the (A)Christoffel \
tensor does not exist it is created automatically.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CurvatureFormToTensor", "::", "usage"}], 
     "=", "\"\<CurvatureFormToTensor[expr,frame] transforms all the instances \
of the curvature form into the related Riemann or FRiemann tensor, inserting \
the corresponding frame (either Coframe or dx).\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChangeCurvatureForm", "::", "usage"}], 
     "=", "\"\<ChangeCurvatureForm[curvature,cd1,cd2] writes the curvature \
2-form curvature[cd1,vbundle] in terms of the curvature 2-form \
curvature[cd2,vbundle]\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"The", " ", "torsion", " ", "2"}], "-", "form"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TorsionForm", "::", "usage"}], 
     "=", "\"\<TorsionForm[cd] represents the torsion 2-form arising from the \
covariant derivative cd (cd must be defined on the tangent bundle of a \
manifold)\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Cartan", " ", "structure", " ", "equations"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UseCartan", "::", "usage"}], 
     "=", "\"\<UseCartan[expr,covd] expands all the instances of the Diff \
using the Cartan structure equations for the connection arising from covd. In \
this way it is possible to expand the exterior derivative of a co-frame, a \
torsion 2-form and the curvature 2-form. If covd is the Levi-Civita \
connection of a metric, then the exterior derivatives of that metric and its \
volume element are expanded too. UseCartan[expr,PD] expands all instances of \
the exterior derivative in terms of partial derivatives defined in the list \
of manifolds returned by ManifoldsOf[expr]. It is possible to specify a \
custom list of manifolds as a third argument in the form \
UseCartan[expr,PD,{M1,M2,..}]\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Zero", " ", "forms"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ZeroDegQ", "::", "usage"}], 
     "=", "\"\<ZeroDegQ[expr] returns True if the degree of expr is \
zero\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UseDimensionStart", "::", "usage"}], 
     "=", "\"\<UseDimensionStart[] is an instruction that, when issued, makes \
any expression with degree greater than the manifold dimension equal to zero.\
\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UseDimensionStop", "::", "usage"}], 
     "=", "\"\<UseDimensionStop[] cancels the action of UseDimensionStart[]\>\
\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Integration", " ", "of", " ", "differential", " ", "forms", " ", "over", 
     " ", "manifolds", " ", "with", " ", "boundary"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FormIntegrate", "::", "usage"}], 
     "=", "\"\<FormIntegrate[form, M] represents the integration of the given \
differential form, of degree n, over the n-dimensional manifold M with \
boundary.\>\""}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UseStokes", "::", "usage"}], 
     "=", "\"\<UseStokes[expr, M] converts subexpressions \
FormIntegrate[Diff[form], M] in expr into FormIntegrate[form, \
ManifoldBoundary[M]], reducing n-dimensional integration to \
(n-1)-integration. UseStokes[expr, form] converts subexpressions \
FormIntegrate[form, ManifoldBoundary[M]] in expr into \
FormIntegrate[Diff[form], M]. UseStokes[expr] performs UseStokes[expr, M] \
wherever possible in expr, to reduce dimensionality of integration.\>\""}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"bf7bae54-1acc-4069-acda-45f4bc66a67a"]
}, Closed]],

Cell[CellGroupData[{

Cell["1.6. Begin private", \
"Subsubsection",ExpressionUUID->"12cbcc7e-4220-4880-9caf-09fde41bf70a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Begin", "[", "\"\<`Private`\>\"", "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3d7239ed-42a0-4924-be0d-3118950bfcb9"],

Cell[BoxData["\<\"xAct`xTerior`Private`\"\>"], \
"Output",ExpressionUUID->"9833f02f-3310-4982-b632-83efee275bf4"]
}, Open  ]],

Cell["There are ?? reserved words in version 0.9.1 :", \
"Text",ExpressionUUID->"773e09b7-adab-4968-acb0-e90601644e05"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<xAct`xTerior`*\>\"", 
  "]"}]], "Input",ExpressionUUID->"a482186d-f235-47d0-9d37-f83bbb530fb6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"CartanD\"\>", ",", "\<\"CartanDToDiff\"\>", 
   ",", "\<\"ChangeCurvatureForm\"\>", ",", "\<\"ChangeExtD\"\>", 
   ",", "\<\"ChangeGenCovD\"\>", ",", "\<\"ChristoffelForm\"\>", 
   ",", "\<\"Codiff\"\>", ",", "\<\"CodiffToDiff\"\>", ",", "\<\"Coframe\"\>",
    ",", "\<\"ConnectionForm\"\>", ",", "\<\"ConnectionFormToTensor\"\>", 
   ",", "\<\"CurvatureForm\"\>", ",", "\<\"CurvatureFormToTensor\"\>", 
   ",", "\<\"DefDiffForm\"\>", ",", "\<\"Deg\"\>", ",", "\<\"Diff\"\>", 
   ",", "\<\"DiffFormQ\"\>", ",", "\<\"Disclaimer\"\>", ",", "\<\"dx\"\>", 
   ",", "\<\"eFrame\"\>", ",", "\<\"ExpandCovD\"\>", 
   ",", "\<\"ExpandHodgeDual\"\>", ",", "\<\"ExpandKoszul\"\>", 
   ",", "\<\"FindPotential\"\>", ",", "\<\"FormIntegrate\"\>", 
   ",", "\<\"FormVarD\"\>", ",", "\<\"Hodge\"\>", ",", "\<\"Int\"\>", 
   ",", "\<\"Koszul\"\>", ",", "\<\"PDFrame\"\>", ",", "\<\"RiemannForm\"\>", 
   ",", "\<\"SortDerivations\"\>", ",", "\<\"TorsionForm\"\>", 
   ",", "\<\"UndefDiffForm\"\>", ",", "\<\"UseCartan\"\>", 
   ",", "\<\"UseDimensionStart\"\>", ",", "\<\"UseDimensionStop\"\>", 
   ",", "\<\"UseStokes\"\>", ",", "\<\"ZeroDegQ\"\>", 
   ",", "\<\"$DerivationSortOrder\"\>", ",", "\<\"$Version\"\>", 
   ",", "\<\"$xTensorVersionExpected\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"3b187734-884e-43fd-bb5b-f4a7ce597bd3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "Length"}]], "Input",ExpressionUUID->"fe1cd881-9e89-47b9-9808-9aee82ad58a5"],

Cell[BoxData["42"], \
"Output",ExpressionUUID->"6a84e1d1-9ef2-4d7e-9cb1-a7e3b8722629"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 InitializationCell->
  True,ExpressionUUID->"2757684e-279e-4235-aaa8-4f22ec95f12f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"xAct`xTerior`\"\>", ",", "\<\"xAct`xCoba`\"\>", 
   ",", "\<\"xAct`xTensor`\"\>", ",", "\<\"xAct`xPerm`\"\>", 
   ",", "\<\"xAct`xCore`\"\>", ",", "\<\"System`\"\>"}], 
  "}"}]], "Output",ExpressionUUID->"0e0d474a-cac9-463c-b214-818567ffb048"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["$Context"], \
"Input",ExpressionUUID->"ba4e196e-78e8-45c5-8777-510e7ea5ad63"],

Cell[BoxData["\<\"xAct`xTerior`Private`\"\>"], \
"Output",ExpressionUUID->"44c74996-4f69-4f4f-9ec7-f14043524e7b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["%"], \
"Input",ExpressionUUID->"ad00a4e0-9727-4b69-a961-d5b2824678fd"],

Cell[BoxData["\<\"xAct`xTerior`Private`\"\>"], \
"Output",ExpressionUUID->"19760a29-24df-4646-8676-b58bed0906d8"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["2. Basic structures", "Subsection",
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"5b3a1fa0-bf9a-46ff-bb81-7c6f34d16009"],

Cell[CellGroupData[{

Cell["2.1 Definition of the wedge product", \
"Subsubsection",ExpressionUUID->"4ff23595-c172-4823-8a3d-7e09f46cb7a3"],

Cell["\<\
The wedge product is an associative, anticommutative (actually \
supercommutative) graded product with identity 1. The scalars are those \
objects of grade 0, including the identity 1, so that the scalars are \
actually in this case true elements of the algebra. The product by scalar and \
the product of scalars are both Times, so we do not need to specify them.\
\>", "Text",ExpressionUUID->"e2243605-1efb-452d-b4de-eccc38ce4369"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefProduct", "[", 
   RowBox[{"Wedge", ",", "\[IndentingNewLine]", 
    RowBox[{"AssociativeProductQ", "\[Rule]", "True"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"CommutativityOfProduct", "\[Rule]", "\"\<SuperCommutative\>\""}],
     ",", "\[IndentingNewLine]", 
    RowBox[{"GradedProductQ", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"IdentityElementOfProduct", "\[Rule]", "1"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ScalarsOfProduct", "\[Rule]", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"SameQ", "[", 
        RowBox[{
         RowBox[{"Grade", "[", 
          RowBox[{"#", ",", "Wedge"}], "]"}], ",", "0"}], "]"}], "&"}], 
      ")"}]}], ",", "\[IndentingNewLine]", 
    RowBox[{"DefInfo", "\[Rule]", "Null"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"cb999c05-8ada-41f4-8cee-49bad2f4d745"],

Cell["Relation between Wedge and Times.", \
"Text",ExpressionUUID->"2032616d-39a4-4032-bd60-ce670628833e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Wedge", "/:", 
   RowBox[{"GradeOfProduct", "[", 
    RowBox[{"Times", ",", "Wedge"}], "]"}], "=", "0"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"41ba95f2-d349-4ec2-823a-bdcfef5badd2"],

Cell[TextData[{
 "When working with the exterior algebra the grade is typically called ",
 StyleBox["degree",
  FontSlant->"Italic"],
 ":"
}], "Text",ExpressionUUID->"2d5e75ca-2578-4608-99b0-1cc0715bd74a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Deg", "[", "expr_", "]"}], ":=", 
   RowBox[{"Grade", "[", 
    RowBox[{"expr", ",", "Wedge"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7c26045d-56ef-4bde-8ca6-94e9c4ac2a56"],

Cell["Scalars have zero degree:", \
"Text",ExpressionUUID->"0c2ace92-6b45-4421-b7ca-b1b4e92dca7a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Deg", "[", "2", 
  "]"}]], "Input",ExpressionUUID->"d27c0542-b740-4184-a0b3-089c02525b86"],

Cell[BoxData["0"], \
"Output",ExpressionUUID->"23671722-1184-4085-bef1-39ced98cc783"]
}, Open  ]],

Cell["\<\
A product of scalars is automatically converted into a scalar:\
\>", "Text",ExpressionUUID->"d8b383fb-ece3-45f4-adb6-8cc8b19e518e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "\[Wedge]", "2", "\[Wedge]", 
  "3"}]], "Input",ExpressionUUID->"99921c1d-c228-4304-8aaa-47294ff87b45"],

Cell[BoxData["6"], \
"Output",ExpressionUUID->"dee8d4e1-48c4-43e9-b129-b2035f7e8e03"]
}, Open  ]],

Cell["\<\
The wedge product is eliminated when found with only one argument:\
\>", "Text",ExpressionUUID->"74a39fcf-fa85-4b1b-96af-01b9486aa0e7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Wedge", "[", "a", "]"}], "//", 
  "FullForm"}]], \
"Input",ExpressionUUID->"c895d612-93a6-4827-97f7-3d9406bbb7f9"],

Cell[BoxData[
 TagBox[
  StyleBox["a",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], \
"Output",ExpressionUUID->"fd9ae094-f7ab-445d-b4e2-1de5a0696b86"]
}, Open  ]],

Cell["Note that parentheses are needed sometimes. Compare", \
"Text",ExpressionUUID->"d4431266-22a8-4b50-9c61-501ee2f172f3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "\[Wedge]", "3"}], ")"}], "b"}], "]"}], ",", 
   RowBox[{"Hold", "[", 
    RowBox[{"a", "\[Wedge]", 
     RowBox[{"(", 
      RowBox[{"3", "b"}], ")"}]}], "]"}]}], 
  "}"}]], "Input",ExpressionUUID->"71d1305b-becd-43b9-a22b-c2315fb30e1f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Hold", "[", 
    RowBox[{
     RowBox[{"a", "\[Wedge]", "3"}], " ", "b"}], "]"}], ",", 
   RowBox[{"Hold", "[", 
    RowBox[{"a", "\[Wedge]", 
     RowBox[{"(", 
      RowBox[{"3", " ", "b"}], ")"}]}], "]"}]}], 
  "}"}]], "Output",ExpressionUUID->"222b2018-533e-4b62-a698-0d917ba4f4d2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", 
  "FullForm"}]], \
"Input",ExpressionUUID->"e368929a-2ab0-4dc9-9c44-57ae4e4cd27f"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"List", "[", 
    RowBox[{
     RowBox[{"Hold", "[", 
      RowBox[{"Times", "[", 
       RowBox[{
        RowBox[{"Wedge", "[", 
         RowBox[{"a", ",", "3"}], "]"}], ",", "b"}], "]"}], "]"}], ",", 
     RowBox[{"Hold", "[", 
      RowBox[{"Wedge", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Times", "[", 
         RowBox[{"3", ",", "b"}], "]"}]}], "]"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], \
"Output",ExpressionUUID->"0fe46d72-70ab-4416-9529-2b1edd13041d"]
}, Open  ]],

Cell["Behavior of the wedge product with respect to Dagger", \
"Text",ExpressionUUID->"c6295147-3a36-480d-9b18-e33a782744e0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "@", "Dagger"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Dagger", "@", "expr_Wedge"}], ":=", 
   RowBox[{"Dagger", "/@", "expr"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "@", "Dagger"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"22e8b1d5-78b9-42bc-8a0b-91ff21c40078"],

Cell["\<\
Behavior of the wedge product with respect to CTensor (perhaps this should be \
in xCoba). \
\>", "Text",ExpressionUUID->"85ed0bde-e20b-4aa8-847b-0d0ef7002ce4"],

Cell["\<\
Vanishing of forms whose degree is higher than the manifold(s) dimension.\
\>", "Text",ExpressionUUID->"ff49f0a7-f88b-4605-bce6-5d0170df4b75"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Code", " ", "added", " ", "by", " ", "Jos\[EAcute]"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"$UseDimensionsQ", "=", "False"}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"$DimensionsZeroForms", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"SetZeroForm", "[", "form_", "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"GradeOfTensor", "[", 
         RowBox[{"form", ",", "Wedge"}], "]"}], ">", 
        RowBox[{"Plus", "@@", 
         RowBox[{"(", 
          RowBox[{"DimOfManifold", "/@", 
           RowBox[{"DependenciesOfTensor", "[", "form", "]"}]}], ")"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"form", "[", "___", "]"}], "=", "0"}], ";", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"$DimensionsZeroForms", ",", "form"}], "]"}]}]}], "]"}]}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"UnsetZeroForm", "[", "form_", "]"}], ":=", 
     RowBox[{"Unset", "[", 
      RowBox[{"form", "[", "___", "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"UseDimensionStart", "[", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{"$UseDimensionsQ", ",", 
         RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"$UseDimensionsQ", "=", "True"}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
        "Forms", " ", "whose", " ", "degree", " ", "is", " ", "greater", " ", 
         "than", " ", "the", " ", "dimension"}], "*)"}], 
       RowBox[{"SetZeroForm", "/@", "$Tensors"}], ";", "\[IndentingNewLine]", 
       
       RowBox[{"(*", 
        RowBox[{
        "Expressions", " ", "which", " ", "are", " ", "wedge", " ", 
         "products"}], "*)"}], 
       RowBox[{
        RowBox[{"HoldPattern", "@", 
         RowBox[{"Wedge", "[", "expr__", "]"}]}], ":=", 
        RowBox[{"0", "/;", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Plus", "@@", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"Grade", "[", 
                RowBox[{"#", ",", "Wedge"}], "]"}], "&"}], "/@", 
              RowBox[{"{", "expr", "}"}]}], ")"}]}], ">", 
           RowBox[{"(", 
            RowBox[{"Plus", "@@", 
             RowBox[{"(", 
              RowBox[{"DimOfManifold", "/@", 
               RowBox[{"Union", "@", 
                RowBox[{"Flatten", "[", 
                 RowBox[{"DependenciesOf", "/@", 
                  RowBox[{"{", "expr", "}"}]}], "]"}]}]}], ")"}]}], ")"}]}], 
          ")"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
        "Expressions", " ", "which", " ", "are", " ", "exterior", " ", 
         "derivatives"}], "*)"}], 
       RowBox[{
        RowBox[{"HoldPattern", "@", 
         RowBox[{"Diff", "[", 
          RowBox[{"expr_", ",", "PD"}], "]"}]}], ":=", 
        RowBox[{"0", "/;", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"1", "+", 
            RowBox[{"Plus", "@@", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"Grade", "[", 
                 RowBox[{"#", ",", "Wedge"}], "]"}], "&"}], "/@", 
               RowBox[{"{", "expr", "}"}]}], ")"}]}]}], ">", 
           RowBox[{"(", 
            RowBox[{"Plus", "@@", 
             RowBox[{"(", 
              RowBox[{"DimOfManifold", "/@", 
               RowBox[{"DependenciesOf", "[", "expr", "]"}]}], ")"}]}], 
            ")"}]}], ")"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"HoldPattern", "@", 
         RowBox[{"Diff", "[", 
          RowBox[{"expr_", ",", "covd_"}], "]"}]}], ":=", 
        RowBox[{"0", "/;", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"1", "+", 
            RowBox[{"Plus", "@@", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"Grade", "[", 
                 RowBox[{"#", ",", "Wedge"}], "]"}], "&"}], "/@", 
               RowBox[{"{", "expr", "}"}]}], ")"}]}]}], ">", 
           RowBox[{"(", 
            RowBox[{"Plus", "@@", 
             RowBox[{"(", 
              RowBox[{"DimOfManifold", "/@", 
               RowBox[{"DependenciesOf", "[", "expr", "]"}]}], ")"}]}], 
            ")"}]}], ")"}]}]}], ";"}]}], "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"UseDimensionStop", "[", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"!", "$UseDimensionsQ"}], ",", 
         RowBox[{"Return", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"$UseDimensionsQ", "=", "False"}], ";", "\[IndentingNewLine]", 
       
       RowBox[{"UnsetZeroForm", "/@", 
        RowBox[{"Union", "@", "$DimensionsZeroForms"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"HoldPattern", "@", 
         RowBox[{"Wedge", "[", "expr__", "]"}]}], "=."}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"HoldPattern", "@", 
         RowBox[{"Diff", "[", 
          RowBox[{"expr_", ",", "PD"}], "]"}]}], "=."}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"HoldPattern", "@", 
         RowBox[{"Diff", "[", 
          RowBox[{"expr_", ",", "covd_"}], "]"}]}], "=."}], ";"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "xTensions", " ", "*)"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xTension", "[", 
      RowBox[{"\"\<xTerior`\>\"", ",", "DefTensor", ",", "\"\<End\>\""}], 
      "]"}], ":=", "DefTensorUseDimensions"}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"DefTensorUseDimensions", "[", 
      RowBox[{
       RowBox[{"tensor_", "[", "inds___", "]"}], ",", "__"}], "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{"$UseDimensionsQ", ",", 
       RowBox[{"SetZeroForm", "[", "tensor", "]"}]}], "]"}]}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xTension", "[", 
      RowBox[{"\"\<xTerior`\>\"", ",", "UndefTensor", 
       ",", "\"\<Beginning\>\""}], "]"}], ":=", "UndefTensorUseDimensions"}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"UndefTensorUseDimensions", "[", "tensor_", "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{"$UseDimensionsQ", ",", 
       RowBox[{"UnsetZeroForm", "[", "tensor", "]"}]}], "]"}]}], ";"}], 
   "\n"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"6b0610bd-d6b9-4e5f-a6b2-07b802774a3f"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.2 Integration of CTensor in Wedge", \
"Subsubsection",ExpressionUUID->"54e5f194-d782-41d8-b724-f7a254d12582"],

Cell["\<\
In this section we implement the Wedge product of CTensor objects. This code \
has been supplied by Jos\[EAcute] Mart\[IAcute]n-Garc\[IAcute]a.\
\>", "Text",ExpressionUUID->"3fb01063-826f-46ea-8546-d04437a1d185"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Grade", " ", "of", " ", "a", " ", "CTensor", " ", "with", " ", "respect", 
    " ", "to", " ", "Wedge"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"CTensor", "/:", 
    RowBox[{"Grade", "[", 
     RowBox[{"expr_CTensor", ",", "Wedge"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"list", ",", "grades", ",", 
        RowBox[{"comps", "=", 
         RowBox[{"First", "@", "expr"}]}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"list", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", "comps", "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"grades", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Grade", "[", 
           RowBox[{"#", ",", "Wedge"}], "]"}], "&"}], "/@", "list"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "@", 
           RowBox[{"Tally", "[", "grades", "]"}]}], "\[Equal]", "1"}], ",", 
         RowBox[{"grades", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "$Failed"}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"138715d2-83b1-4196-abf1-063c903072a1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Contracted", " ", "wedge", " ", "product", " ", "of", " ", "CTensor", " ",
     "objects"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Wedge", "[", 
      RowBox[{
       RowBox[{"ctensor1_CTensor", "[", 
        RowBox[{"left1___", ",", "a_", ",", "right1___"}], "]"}], ",", 
       RowBox[{"ctensor2_CTensor", "[", 
        RowBox[{"left2___", ",", 
         RowBox[{"-", "a_"}], ",", "right2___"}], "]"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n1", "=", 
          RowBox[{"Length", "[", 
           RowBox[{"{", 
            RowBox[{"left1", ",", "a"}], "}"}], "]"}]}], ",", 
         RowBox[{"n2", "=", 
          RowBox[{"Length", "[", 
           RowBox[{"{", 
            RowBox[{"left2", ",", 
             RowBox[{"-", "a"}]}], "}"}], "]"}]}], ",", "res"}], "}"}], ",", 
       RowBox[{
        RowBox[{"res", "=", 
         RowBox[{"xAct`xCoba`Private`CTensorContract", "[", 
          RowBox[{"ctensor1", ",", "ctensor2", ",", 
           RowBox[{"{", 
            RowBox[{"n1", ",", "n2"}], "}"}], ",", "Wedge"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"res", "[", 
          RowBox[{"left1", ",", "right1", ",", "left2", ",", "right2"}], 
          "]"}], "/;", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"res", ",", "$Failed"}], "]"}]}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Wedge", "[", 
      RowBox[{
       RowBox[{"ctensor1_CTensor", "[", 
        RowBox[{"left1___", ",", 
         RowBox[{"-", "a_"}], ",", "right1___"}], "]"}], ",", 
       RowBox[{"ctensor2_CTensor", "[", 
        RowBox[{"left2___", ",", "a_", ",", "right2___"}], "]"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n1", "=", 
          RowBox[{"Length", "[", 
           RowBox[{"{", 
            RowBox[{"left1", ",", "a"}], "}"}], "]"}]}], ",", 
         RowBox[{"n2", "=", 
          RowBox[{"Length", "[", 
           RowBox[{"{", 
            RowBox[{"left2", ",", 
             RowBox[{"-", "a"}]}], "}"}], "]"}]}], ",", "res"}], "}"}], ",", 
       RowBox[{
        RowBox[{"res", "=", 
         RowBox[{"xAct`xCoba`Private`CTensorContract", "[", 
          RowBox[{"ctensor1", ",", "ctensor2", ",", 
           RowBox[{"{", 
            RowBox[{"n1", ",", "n2"}], "}"}], ",", "Wedge"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"res", "[", 
          RowBox[{"left1", ",", "right1", ",", "left2", ",", "right2"}], 
          "]"}], "/;", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"res", ",", "$Failed"}], "]"}]}]}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"1d7dd057-4e25-4b51-b1ad-daa2c57d8129"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Wedge", " ", "product", " ", "of", " ", 
   RowBox[{"(", 
    RowBox[{"Frame", " ", "or", " ", "Coframe"}], ")"}], " ", "General", " ", 
   "CTensor", " ", "objects"}], "  ", 
  "*)"}]], "Input",ExpressionUUID->"b937bab7-d2b8-4a66-a64f-57f8512fa624"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"signatureOrZero", "[", "indices_", "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"DuplicateFreeQ", "[", "indices", "]"}], ",", 
       RowBox[{"Signature", "[", 
        RowBox[{"Ordering", "[", "indices", "]"}], "]"}], ",", "0"}], "]"}]}],
     ";"}], "*)"}], "\n", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"simplifyBasisWedge", "[", "expr_", "]"}], ":=", 
     RowBox[{"expr", "/.", 
      RowBox[{"wed_Wedge", "\[RuleDelayed]", 
       RowBox[{"simplifyBasisWedge1", "[", "wed", "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{"simplifyBasisWedge1", "[", 
       RowBox[{"HoldPattern", "[", 
        RowBox[{"Wedge", "[", 
         RowBox[{"factors", ":", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"head", ":", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"xAct`xTerior`Coframe", "|", "xAct`xTerior`dx"}], 
                  ")"}], "[", "_", "]"}], ")"}]}], ")"}], "[", "_", "]"}], 
            ".."}], ")"}]}], "]"}], "]"}], "]"}], ":=", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"indices", "=", 
          RowBox[{"First", "/@", 
           RowBox[{"{", "factors", "}"}]}]}], "}"}], ",", 
        RowBox[{
         RowBox[{"signatureOrZero", "[", "indices", "]"}], " ", 
         RowBox[{"Wedge", "@@", 
          RowBox[{"(", 
           RowBox[{"head", "/@", 
            RowBox[{"Sort", "[", "indices", "]"}]}], ")"}]}]}]}], "]"}]}], 
     ";"}], "*)"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"simplifyBasisWedge1", "[", 
      RowBox[{"HoldPattern", "[", 
       RowBox[{"expr", ":", 
        RowBox[{"Wedge", "[", 
         RowBox[{"factors", ":", 
          RowBox[{
           RowBox[{"Blank", "[", "]"}], " ", ".."}]}], "]"}]}], "]"}], "]"}], 
     ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"indices", "=", 
         RowBox[{"FindFreeIndices", "[", "expr", "]"}]}], "}"}], ",", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"indices", "===", 
          RowBox[{"IndexList", "[", "]"}]}], ",", "expr", ",", "$Failed"}], 
        "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Wedge", " ", "product", " ", "of", " ", "general", " ", "CTensor", " ", 
     "objects"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CTensorWedge", "[", "]"}], ":=", "1"}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CTensorWedge", "[", "ctensors__CTensor", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"CTensor", "[", 
        RowBox[{
         RowBox[{"simplifyBasisWedge", "[", 
          RowBox[{
           RowBox[{"xAct`xCoba`Private`tensorproduct", "[", "Wedge", "]"}], "@@",
            "#1"}], "]"}], ",", 
         RowBox[{"Join", "@@", "#2"}], ",", 
         RowBox[{"Plus", "@@", "#3"}]}], "]"}], "&"}], "@@", 
      RowBox[{"Transpose", "[", 
       RowBox[{"List", "@@@", 
        RowBox[{"{", "ctensors", "}"}]}], "]"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"CTensorWedge", "[", 
      RowBox[{"___", ",", "Zero", ",", "___"}], "]"}], ":=", "Zero"}], ";"}], 
   "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Wedge", "[", 
     RowBox[{
      RowBox[{"ctensor1_CTensor", "[", "inds1___", "]"}], ",", 
      RowBox[{"ctensor2_CTensor", "[", "inds2___", "]"}]}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"CTensorWedge", "[", 
       RowBox[{"ctensor1", ",", "ctensor2"}], "]"}], "[", 
      RowBox[{"inds1", ",", "inds2"}], "]"}], "/;", 
     RowBox[{
      RowBox[{"xAct`xTensor`Private`TakePairs", "[", 
       RowBox[{"{", 
        RowBox[{"inds1", ",", "inds2"}], "}"}], "]"}], "===", 
      RowBox[{"{", "}"}]}]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{"Wedge", "[", 
     RowBox[{"ctensor1_CTensor", ",", "ctensor2_CTensor"}], "]"}], ":=", 
    RowBox[{"CTensorWedge", "[", 
     RowBox[{"ctensor1", ",", "ctensor2"}], "]"}]}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"0b924453-32aa-49a6-96da-dc103f81480a"],

Cell["\<\
Wedge product of frame and co-frame with CTensor objects. We first have a \
definition for Coframe with c - indices, avoiding the use of ToCTensor :\
\>", "Text",ExpressionUUID->"185dedca-19bf-49de-a25b-3d9718fb84b7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Wedge", "[", 
    RowBox[{
     RowBox[{"basis", ":", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Coframe", "|", "dx"}], ")"}], "[", "_", "]"}], "[", 
       RowBox[{"_", "?", "CIndexQ"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"CTensor", "[", 
       RowBox[{"array_", ",", "bases_List", ",", "addweight_"}], "]"}], "[", 
      "b__", "]"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"CTensor", "[", 
     RowBox[{
      RowBox[{"Wedge", "[", 
       RowBox[{"basis", ",", "array"}], "]"}], ",", "bases", ",", 
      "addweight"}], "]"}], "[", "b", "]"}]}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Wedge", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"CTensor", "[", 
      RowBox[{"array_", ",", "bases_List", ",", "addweight_"}], "]"}], "[", 
     "b__", "]"}], ",", 
    RowBox[{"basis", ":", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Coframe", "|", "dx"}], ")"}], "[", "_", "]"}], "[", 
      RowBox[{"_", "?", "CIndexQ"}], "]"}]}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"CTensor", "[", 
    RowBox[{
     RowBox[{"Wedge", "[", 
      RowBox[{"array", ",", "basis"}], "]"}], ",", "bases", ",", 
     "addweight"}], "]"}], "[", "b", "]"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"c3f57566-bb94-42db-9f06-d99b5bb47126"],

Cell["\<\
Then we have another definition for the general case of Wedge, in which the \
Coframes inside the CTensor uniquely identify the frame to use in ToCTensor :\
\
\>", "Text",ExpressionUUID->"6058db61-eb46-4709-8d22-39c8c008c8df"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FormBases", "[", 
    RowBox[{"CTensor", "[", 
     RowBox[{"array_", ",", "__"}], "]"}], "]"}], ":=", 
   RowBox[{"DeleteDuplicates", "[", 
    RowBox[{"xAct`xPerm`Private`nosign", "/@", 
     RowBox[{"Cases", "[", 
      RowBox[{"array", ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Coframe", "|", "dx"}], ")"}], "[", "_", "]"}], "[", 
         RowBox[{"{", 
          RowBox[{"_", ",", "frame_"}], "}"}], "]"}], "\[RuleDelayed]", 
        "frame"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Wedge", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"basis", ":", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"Coframe", "|", "dx"}], ")"}], "[", "_", "]"}]}], ")"}], "[",
       "ind_", "]"}], ",", 
     RowBox[{"ctensor_CTensor", "[", "inds___", "]"}]}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"frames", "=", 
       RowBox[{"FormBases", "[", "ctensor", "]"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"Wedge", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"ToCTensor", "[", 
          RowBox[{"basis", ",", "frames"}], "]"}], "[", "ind", "]"}], ",", 
        RowBox[{"ctensor", "[", "inds", "]"}]}], "]"}], "/;", 
      RowBox[{
       RowBox[{"Length", "[", "frames", "]"}], "===", "1"}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Wedge", "[", 
   RowBox[{
    RowBox[{"ctensor_CTensor", "[", "inds___", "]"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"basis", ":", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Coframe", "|", "dx"}], ")"}], "[", "_", "]"}]}], ")"}], "[",
      "ind_", "]"}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"frames", "=", 
      RowBox[{"FormBases", "[", "ctensor", "]"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"Wedge", "[", 
      RowBox[{
       RowBox[{"ctensor", "[", "inds", "]"}], ",", 
       RowBox[{
        RowBox[{"ToCTensor", "[", 
         RowBox[{"basis", ",", "frames"}], "]"}], "[", "ind", "]"}]}], "]"}], 
     "/;", 
     RowBox[{
      RowBox[{"Length", "[", "frames", "]"}], "===", "1"}]}]}], 
   "]"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"cbd66722-2d02-4592-a9f0-a7efb5a60da9"],

Cell["\<\
Finally we need another definition for the case in which the CTensor is a 0 - \
form :\
\>", "Text",ExpressionUUID->"c1682d25-d57c-4c3f-ab73-60e811762fef"],

Cell[BoxData[
 RowBox[{"CTensor", "/:", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"basis", ":", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Coframe", "|", "dx"}], ")"}], "[", "_", "]"}]}], ")"}], "[", 
    "a_", "]"}], " ", 
   RowBox[{"(", 
    RowBox[{"ctensor", ":", 
     RowBox[{
      RowBox[{"CTensor", "[", 
       RowBox[{"_", ",", "bases_List", ",", "_"}], "]"}], "[", 
      RowBox[{"l___", ",", 
       RowBox[{"-", "a_"}], ",", "___"}], "]"}]}], ")"}]}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"ToCTensor", "[", 
     RowBox[{"basis", ",", 
      RowBox[{"{", 
       RowBox[{"-", 
        RowBox[{"bases", "[", 
         RowBox[{"[", 
          RowBox[{"Length", "[", 
           RowBox[{"{", 
            RowBox[{"l", ",", 
             RowBox[{"-", "a"}]}], "}"}], "]"}], "]"}], "]"}]}], "}"}]}], 
     "]"}], "[", "a", "]"}], " ", "ctensor"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b19e7644-f0e3-422e-a93b-71bd07573291"],

Cell[BoxData[
 RowBox[{"CTensor", "/:", 
  RowBox[{"HoldPattern", "[", 
   RowBox[{
    RowBox[{"Wedge", "[", 
     RowBox[{"lw___", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"basis", ":", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"Coframe", "|", "dx"}], ")"}], "[", "_", "]"}]}], ")"}], "[",
        "a_", "]"}], " ", ",", "rw___"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{"ctensor", ":", 
      RowBox[{
       RowBox[{"CTensor", "[", 
        RowBox[{"_", ",", "bases_List", ",", "_"}], "]"}], "[", 
       RowBox[{"l___", ",", 
        RowBox[{"-", "a_"}], ",", "___"}], "]"}]}], ")"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Wedge", "[", 
    RowBox[{"lw", ",", 
     RowBox[{
      RowBox[{"ToCTensor", "[", 
       RowBox[{"basis", ",", 
        RowBox[{"{", 
         RowBox[{"-", 
          RowBox[{"bases", "[", 
           RowBox[{"[", 
            RowBox[{"Length", "[", 
             RowBox[{"{", 
              RowBox[{"l", ",", 
               RowBox[{"-", "a"}]}], "}"}], "]"}], "]"}], "]"}]}], "}"}]}], 
       "]"}], "[", "a", "]"}], ",", "rw"}], "]"}], " ", 
   "ctensor"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"1ffb5974-cec2-43bb-81ba-dd6d26b1aac9"],

Cell["Wedge product of index free quantities with CTensor objects:", \
"Text",ExpressionUUID->"1d30690a-a5c7-4303-9a27-e718b44381ff"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Wedge", "[", 
    RowBox[{"ten_", ",", 
     RowBox[{
      RowBox[{"CTensor", "[", 
       RowBox[{"array_", ",", "bases_List", ",", "addweight_"}], "]"}], "[", 
      "b__", "]"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"CTensor", "[", 
      RowBox[{
       RowBox[{"Wedge", "[", 
        RowBox[{"ten", ",", "array"}], "]"}], ",", "bases", ",", 
       "addweight"}], "]"}], "[", "b", "]"}], "/;", 
    RowBox[{
     RowBox[{"FindFreeIndices", "@", "ten"}], "===", 
     RowBox[{"IndexList", "[", "]"}]}]}]}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Wedge", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"CTensor", "[", 
      RowBox[{"array_", ",", "bases_List", ",", "addweight_"}], "]"}], "[", 
     "b__", "]"}], ",", "ten_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"CTensor", "[", 
     RowBox[{
      RowBox[{"Wedge", "[", 
       RowBox[{"array", ",", "ten"}], "]"}], ",", "bases", ",", "addweight"}],
      "]"}], "[", "b", "]"}], "/;", 
   RowBox[{
    RowBox[{"FindFreeIndices", "@", "ten"}], "===", 
    RowBox[{"IndexList", "[", "]"}]}]}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"c77fdd35-5073-444c-8ff4-2d5dfffb8c9e"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.3 Definition of the CircleTimes product", \
"Subsubsection",ExpressionUUID->"1b330bc7-1f83-413e-b82e-0761d025d55b"],

Cell["By default we define the CircleTimes \[OpenCurlyDoubleQuote]\
\[CircleTimes]\[CloseCurlyDoubleQuote] product.", \
"Text",ExpressionUUID->"495c2eaf-1cfa-43d6-9f18-3b9c327e4f42"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "False"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"cb9052bb-ec5e-413d-be9a-acd028c91df0"],

Cell[BoxData[
 RowBox[{"DefProduct", "[", 
  RowBox[{"CircleTimes", ",", "\[IndentingNewLine]", 
   RowBox[{"AssociativeProductQ", "\[Rule]", "True"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"IdentityElementOfProduct", "\[Rule]", "1"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"GradedProductQ", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
   
   RowBox[{"ScalarsOfProduct", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"SameQ", "[", 
       RowBox[{
        RowBox[{"Grade", "[", 
         RowBox[{"#", ",", "CircleTimes"}], "]"}], ",", "0"}], "]"}], "&"}], 
     ")"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"PrintAs", "\[Rule]", "\"\<\[CircleTimes]\>\""}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"75be0d32-8494-432f-a6c8-cfe838609468"],

Cell[BoxData[
 RowBox[{
  RowBox[{"$DefInfoQ", "=", "True"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"9c1e4f3e-524c-4ded-be28-7f72d2c13d39"],

Cell["Grade of CircleTimes with respect to Times", \
"Text",ExpressionUUID->"56dae4b3-e6c3-460d-93fc-fdeba296b130"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CircleTimes", "/:", 
   RowBox[{"GradeOfProduct", "[", 
    RowBox[{"Times", ",", "CircleTimes"}], "]"}], "=", "0"}], ";"}]], "Input",
 
 InitializationCell->
  True,ExpressionUUID->"646ffbbf-d70d-46f0-bf50-9349abb8e638"],

Cell["\<\
Exterior algebra grade and tensor grade should coincide on elementary objects:\
\>", "Text",ExpressionUUID->"774a20c2-a089-40c1-8607-fe4f734a1ea5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CircleTimes", "/:", 
   RowBox[{"GradeOfTensor", "[", 
    RowBox[{"head_", ",", "CircleTimes"}], "]"}], ":=", 
   RowBox[{"GradeOfTensor", "[", 
    RowBox[{"head", ",", "Wedge"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"18d00569-0766-40ae-bdba-8b4c55ea7f48"],

Cell["\<\
We also need to specify the Grade of the inert - head expressions :\
\>", "Text",ExpressionUUID->"fe10671e-1378-4615-8d66-4c9df52f5629"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CircleTimes", "/:", 
   RowBox[{"Grade", "[", 
    RowBox[{
     RowBox[{"Diff", "[", 
      RowBox[{"expr_", ",", "_"}], "]"}], ",", "CircleTimes"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Grade", "[", 
     RowBox[{"expr", ",", "CircleTimes"}], "]"}], "+", "1"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"aea627c5-69d5-469d-9b5b-c0d001e9d048"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CircleTimes", "/:", 
   RowBox[{"Grade", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Hodge", "[", "metricg_", "]"}], "[", "expr_", "]"}], ",", 
     "CircleTimes"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"DimOfVBundle", "[", 
     RowBox[{"VBundleOfMetric", "[", "metricg", "]"}], "]"}], "-", 
    RowBox[{"Grade", "[", 
     RowBox[{"expr", ",", "CircleTimes"}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"0b448309-d54f-471d-8525-04b2997565aa"],

Cell["Behavior with respect to Dagger", \
"Text",ExpressionUUID->"05f88682-8be0-4603-bb2a-f13b5fabf334"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "@", "Dagger"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Dagger", "@", "expr_CircleTimes"}], ":=", 
   RowBox[{"Dagger", "/@", "expr"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Protect", "@", "Dagger"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"6f522a2e-3900-450e-9899-412c0af29a56"],

Cell["\<\
The CircleTimes - grade of a form coincides with the Wedge - grade of that \
form. However, the Wedge - grade is not well defined for generic expressions \
having positive CircleTimes - grade unless they are forms.That is why we have \
given CircleTimes - grade in terms of Wedge - grade and not viceversa.There \
is no general way in which we can know the relations between the grades of a \
given expression in several products.The user must define carefully the \
relations. Usually it is safer to declare independently the grades in each \
product. Recall that objects for which a grade has not been given are taken \
to have degree 0.\
\>", "Text",ExpressionUUID->"bb4a30a0-d5dc-4b03-a6e1-1625c9eada84"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4 Integration of CTensor in CircleTimes", \
"Subsubsection",ExpressionUUID->"cd5e99e5-0dba-4d2d-ae4a-c1e9f450c7bf"],

Cell["\<\
In this section we implement the CircleTimes product of CTensor objects. This \
code has been supplied by Jos\[EAcute] Mart\[IAcute]n-Garc\[IAcute]a.\
\>", "Text",ExpressionUUID->"12805a40-f6c4-4042-860d-3c8b02407f07"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Grade", " ", "of", " ", "a", " ", "CTensor", " ", "with", " ", "respect", 
    " ", "to", " ", "CircleTimes"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"CTensor", "/:", 
    RowBox[{"Grade", "[", 
     RowBox[{"expr_CTensor", ",", "CircleTimes"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"list", ",", "grades", ",", 
        RowBox[{"comps", "=", 
         RowBox[{"First", "@", "expr"}]}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"list", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", "comps", "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"grades", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Grade", "[", 
           RowBox[{"#", ",", "CircleTimes"}], "]"}], "&"}], "/@", "list"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "@", 
           RowBox[{"Tally", "[", "grades", "]"}]}], "\[Equal]", "1"}], ",", 
         RowBox[{"grades", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", "$Failed"}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"1855d8f5-efab-42fe-804a-cbec2531b0fe"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Algebra", " ", "with", " ", "unit", " ", "element"}], " ", "*)"}],
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"xAct`xCoba`Private`tensorproduct", "[", "CircleTimes", "]"}], "[",
      "]"}], "=", "1"}], ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"1dbc24dd-243e-4efd-b984-1f60cb7c4219"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Contracted", " ", "CircleTimes", " ", "product", " ", "of", " ", 
    "CTensor", " ", "objects"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"CircleTimes", "[", 
      RowBox[{
       RowBox[{"ctensor1_CTensor", "[", 
        RowBox[{"left1___", ",", "a_", ",", "right1___"}], "]"}], ",", 
       RowBox[{"ctensor2_CTensor", "[", 
        RowBox[{"left2___", ",", 
         RowBox[{"-", "a_"}], ",", "right2___"}], "]"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n1", "=", 
          RowBox[{"Length", "[", 
           RowBox[{"{", 
            RowBox[{"left1", ",", "a"}], "}"}], "]"}]}], ",", 
         RowBox[{"n2", "=", 
          RowBox[{"Length", "[", 
           RowBox[{"{", 
            RowBox[{"left2", ",", 
             RowBox[{"-", "a"}]}], "}"}], "]"}]}], ",", "res"}], "}"}], ",", 
       RowBox[{
        RowBox[{"res", "=", 
         RowBox[{"xAct`xCoba`Private`CTensorContract", "[", 
          RowBox[{"ctensor1", ",", "ctensor2", ",", 
           RowBox[{"{", 
            RowBox[{"n1", ",", "n2"}], "}"}], ",", "CircleTimes"}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"res", "[", 
          RowBox[{"left1", ",", "right1", ",", "left2", ",", "right2"}], 
          "]"}], "/;", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"res", ",", "$Failed"}], "]"}]}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"CircleTimes", "[", 
      RowBox[{
       RowBox[{"ctensor1_CTensor", "[", 
        RowBox[{"left1___", ",", 
         RowBox[{"-", "a_"}], ",", "right1___"}], "]"}], ",", 
       RowBox[{"ctensor2_CTensor", "[", 
        RowBox[{"left2___", ",", "a_", ",", "right2___"}], "]"}]}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"n1", "=", 
          RowBox[{"Length", "[", 
           RowBox[{"{", 
            RowBox[{"left1", ",", "a"}], "}"}], "]"}]}], ",", 
         RowBox[{"n2", "=", 
          RowBox[{"Length", "[", 
           RowBox[{"{", 
            RowBox[{"left2", ",", 
             RowBox[{"-", "a"}]}], "}"}], "]"}]}], ",", "res"}], "}"}], ",", 
       RowBox[{
        RowBox[{"res", "=", 
         RowBox[{"xAct`xCoba`Private`CTensorContract", "[", 
          RowBox[{"ctensor1", ",", "ctensor2", ",", 
           RowBox[{"{", 
            RowBox[{"n1", ",", "n2"}], "}"}], ",", "CircleTimes"}], "]"}]}], ";",
         "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"res", "[", 
          RowBox[{"left1", ",", "right1", ",", "left2", ",", "right2"}], 
          "]"}], "/;", 
         RowBox[{"FreeQ", "[", 
          RowBox[{"res", ",", "$Failed"}], "]"}]}]}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"8a8c638c-722e-4b57-b611-cca58eca6634"],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "CircleTimes", " ", "product", " ", "of", " ", "General", " ", "CTensor", " ",
    "objects"}], "  ", 
  "*)"}]], "Input",ExpressionUUID->"ecb0f5cc-38d1-4f81-a430-970659c905fd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"simplifyBasisCircleTimes", "[", "expr_", "]"}], ":=", 
    RowBox[{"expr", "/.", 
     RowBox[{"wed_CircleTimes", "\[RuleDelayed]", 
      RowBox[{"simplifyBasisCircleTimes1", "[", "wed", "]"}]}]}]}], ";"}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"simplifyBasisCircleTimes1", "[", 
     RowBox[{"HoldPattern", "[", 
      RowBox[{"expr", ":", 
       RowBox[{"CircleTimes", "[", 
        RowBox[{"factors", ":", 
         RowBox[{
          RowBox[{"Blank", "[", "]"}], " ", ".."}]}], "]"}]}], "]"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"indices", "=", 
        RowBox[{"FindFreeIndices", "[", "expr", "]"}]}], "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"indices", "===", 
         RowBox[{"IndexList", "[", "]"}]}], ",", "expr", ",", "$Failed"}], 
       "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  
  RowBox[{"(*", " ", 
   RowBox[{
   "CircelTimes", " ", "product", " ", "of", " ", "general", " ", "CTensor", " ",
     "objects"}], " ", "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CTensorCircleTimes", "[", "]"}], ":=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"CTensorCircleTimes", "[", "ctensors__CTensor", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"CTensor", "[", 
      RowBox[{
       RowBox[{"simplifyBasisCircleTimes", "[", 
        RowBox[{
         RowBox[{
         "xAct`xCoba`Private`tensorproduct", "[", "CircleTimes", "]"}], "@@", 
         "#1"}], "]"}], ",", 
       RowBox[{"Join", "@@", "#2"}], ",", 
       RowBox[{"Plus", "@@", "#3"}]}], "]"}], "&"}], "@@", 
    RowBox[{"Transpose", "[", 
     RowBox[{"List", "@@@", 
      RowBox[{"{", "ctensors", "}"}]}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CTensorCircleTimes", "[", 
     RowBox[{"___", ",", "Zero", ",", "___"}], "]"}], ":=", "Zero"}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CircleTimes", "[", 
    RowBox[{
     RowBox[{"ctensor1_CTensor", "[", "inds1___", "]"}], ",", 
     RowBox[{"ctensor2_CTensor", "[", "inds2___", "]"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"CTensorCircleTimes", "[", 
      RowBox[{"ctensor1", ",", "ctensor2"}], "]"}], "[", 
     RowBox[{"inds1", ",", "inds2"}], "]"}], "/;", 
    RowBox[{
     RowBox[{"xAct`xTensor`Private`TakePairs", "[", 
      RowBox[{"{", 
       RowBox[{"inds1", ",", "inds2"}], "}"}], "]"}], "===", 
     RowBox[{"{", "}"}]}]}]}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CircleTimes", "[", 
   RowBox[{"ctensor1_CTensor", ",", "ctensor2_CTensor"}], "]"}], ":=", 
  RowBox[{"CTensorCircleTimes", "[", 
   RowBox[{"ctensor1", ",", "ctensor2"}], "]"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"3dc20fa6-f0f5-4558-9c41-035bcd88868a"],

Cell["\<\
CircleTimes product of index free quantities with CTensor objects:\
\>", "Text",ExpressionUUID->"c3270432-68b4-4825-b5f1-9ef050f74439"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CircleTimes", "[", 
    RowBox[{"ten_", ",", 
     RowBox[{
      RowBox[{"CTensor", "[", 
       RowBox[{"array_", ",", "bases_List", ",", "addweight_"}], "]"}], "[", 
      "b__", "]"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"CTensor", "[", 
      RowBox[{
       RowBox[{"CircleTimes", "[", 
        RowBox[{"ten", ",", "array"}], "]"}], ",", "bases", ",", 
       "addweight"}], "]"}], "[", "b", "]"}], "/;", 
    RowBox[{
     RowBox[{"FindFreeIndices", "@", "ten"}], "===", 
     RowBox[{"IndexList", "[", "]"}]}]}]}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"CircleTimes", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"CTensor", "[", 
      RowBox[{"array_", ",", "bases_List", ",", "addweight_"}], "]"}], "[", 
     "b__", "]"}], ",", "ten_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"CTensor", "[", 
     RowBox[{
      RowBox[{"CircleTimes", "[", 
       RowBox[{"array", ",", "ten"}], "]"}], ",", "bases", ",", "addweight"}],
      "]"}], "[", "b", "]"}], "/;", 
   RowBox[{
    RowBox[{"FindFreeIndices", "@", "ten"}], "===", 
    RowBox[{"IndexList", "[", "]"}]}]}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"2fb83fcf-c312-4176-b87e-2cab7308acd5"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.4 Definition and undefinition of differential forms", \
"Subsubsection",ExpressionUUID->"6146436f-ba66-47be-8f67-8b4cd9bb7955"],

Cell["\<\
Definition and undefinition of differential forms. This is simply DefTensor \
with the appropriate options\
\>", "Text",ExpressionUUID->"006f0105-2869-4b8e-a5ac-bdf9535d861f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "DefDiffForm"}]], \
"Input",ExpressionUUID->"325d9781-0292-4c7d-bda8-a094348976b3"],

Cell[BoxData[
 StyleBox["\<\"DefDiffForm[form[inds], mani, Deg] defines a tensor valued \
differential form of degree deg on the manifold mani\"\>", 
  "MSG"]], "Print", \
"PrintUsage",ExpressionUUID->"2de542a2-e388-476d-b3bd-5787631055e4"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefDiffForm", "[", 
   RowBox[{"form_", ",", "mani_", ",", "deg_", ",", 
    RowBox[{"options___", "?", "OptionQ"}]}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"DefTensor", "[", 
     RowBox[{"form", ",", "mani", ",", 
      RowBox[{"GradeOfTensor", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Wedge", "\[Rule]", "deg"}], "}"}]}], ",", "options"}], "]"}],
     ";"}], "\[IndentingNewLine]", ")"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"581686e5-d26a-4bd9-bb44-bd0493b4c745"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefDiffForm", "[", 
   RowBox[{"form_", ",", "mani_", ",", "deg_", ",", "sym_", ",", 
    RowBox[{"options___", "?", "OptionQ"}]}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"DefTensor", "[", 
     RowBox[{"form", ",", "mani", ",", "sym", ",", 
      RowBox[{"GradeOfTensor", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Wedge", "\[Rule]", "deg"}], "}"}]}], ",", "options"}], "]"}],
     ";"}], "\[IndentingNewLine]", ")"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"fede86d4-ec73-4edb-88f1-3e13d13de18c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "@", "DefDiffForm"}], ":=", 
   RowBox[{"Options", "@", "DefTensor"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"424fcb70-4fec-4768-b1b4-147e8fcf3c19"],

Cell[BoxData[
 RowBox[{
  RowBox[{"UndefDiffForm", ":=", "UndefTensor"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d536a894-9d67-44df-a7e0-5ef4b000b2d3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Protect", "[", 
   RowBox[{"DefDiffForm", ",", "UndefDiffForm"}], "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c6c5ae1d-341a-495c-ba1f-bbb6763f9737"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.5 Graded derivations", \
"Subsubsection",ExpressionUUID->"5c1e918d-84a5-4e0f-be6f-403e3622f682"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "@", 
  "DefInertHead"}]], \
"Input",ExpressionUUID->"229c6e02-8f93-4afd-aa4f-fba679795096"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LinearQ", "\[Rule]", "False"}], ",", 
   RowBox[{"ContractThrough", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"Master", "\[Rule]", "Null"}], ",", 
   RowBox[{"PrintAs", "\[Rule]", "Identity"}], ",", 
   RowBox[{"ProtectNewSymbol", "\[RuleDelayed]", "$ProtectNewSymbols"}], ",", 
   
   RowBox[{"DefInfo", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"inert head\"\>", ",", "\<\"\"\>"}], "}"}]}]}], 
  "}"}]], "Output",ExpressionUUID->"c1bbbce5-94fa-4adb-a772-24b5128d66d6"]
}, Open  ]],

Cell["\<\
This function will be used to declare the three derivations we need, namely \
diff, Int[v] and lie[v]. \
\>", "Text",ExpressionUUID->"49a7d822-a13c-422e-b086-28e3d3f542ee"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "DefGradedDerivation", "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"PrintAs", "\[Rule]", "Identity"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Master", "\[Rule]", "Null"}]}], "\[IndentingNewLine]", "}"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"45505ce0-046b-4060-b4cd-a6bb54f12d19"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GradeOfDerivation", "[", 
    RowBox[{
     RowBox[{"head_", "[", 
      RowBox[{"v_", ",", "rest___"}], "]"}], ",", "prod_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"GradeOfDerivation", "[", 
     RowBox[{"head", ",", "prod"}], "]"}], "+", 
    RowBox[{"Grade", "[", 
     RowBox[{"v", ",", "prod"}], "]"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"aab0332a-4f94-421e-963b-79a069dd6247"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DefGradedDerivation", "[", 
    RowBox[{"der_", ",", 
     RowBox[{"prod_", "?", "ProductQ"}], ",", 
     RowBox[{"dergrade_", ":", "0"}], ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "]"}]}]}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"head", "=", 
       RowBox[{"SubHead", "[", "der", "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "pa", "}"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"{", "pa", "}"}], "=", 
         RowBox[{"OptionValue", "[", 
          RowBox[{"{", "PrintAs", "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
          RowBox[{
          "DefInertHead", " ", "will", " ", "take", " ", "care", " ", "of", " ",
            "scalar"}], "-", 
          RowBox[{"homogeneity", " ", "and", " ", "linearity"}]}], " ", 
         "*)"}], "\[IndentingNewLine]", 
        RowBox[{"DefInertHead", "[", 
         RowBox[{"der", ",", "\[IndentingNewLine]", 
          RowBox[{"LinearQ", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
          
          RowBox[{"ContractThrough", "\[Rule]", 
           RowBox[{"{", "delta", "}"}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"PrintAs", "\[Rule]", "pa"}], ",", 
          RowBox[{"DefInfo", "\[Rule]", "Null"}]}], "]"}], ";", 
        "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Other", " ", "properties", " ", "of", " ", "a", " ", "derivation"}],
          " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"MakeDerivation", "[", 
         RowBox[{"head", ",", "der", ",", 
          RowBox[{"NoPattern", "[", "der", "]"}], ",", "prod", ",", 
          "dergrade"}], "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{"Nonatomic", " ", "derivation"}], " ", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"der", "=!=", "head"}], ",", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "additivity", " ", "in", " ", "the", " ", "vector", " ", "slot", " ", 
            RowBox[{"(", 
             RowBox[{"but", " ", "not", " ", 
              RowBox[{"homogeneity", "!"}]}], ")"}]}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"head", "[", "0", "]"}], "[", "__", "]"}], ":=", "0"}], ";",
            "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"head", "[", "v_Plus", "]"}], "[", "args__", "]"}], ":=", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"head", "[", "#", "]"}], "[", "args", "]"}], "&"}], "/@",
              "v"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
           RowBox[{"(*", " ", 
            RowBox[{
            "Subscript", " ", "vector", " ", "argument", " ", "for", " ", 
             "formatting"}], " ", "*)"}], "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"pa", "===", "Identity"}], ",", 
             RowBox[{"pa", "=", 
              RowBox[{"PrintAs", "[", "head", "]"}]}]}], "]"}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"head", "/:", 
            RowBox[{"MakeBoxes", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"head", "[", "v_", "]"}], "[", "form_", "]"}], ",", 
              "StandardForm"}], "]"}], ":=", 
            RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"head", "[", "v", "]"}], "[", "form", "]"}], ",", 
              RowBox[{"RowBox", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"SubscriptBox", "[", 
                  RowBox[{"pa", ",", 
                   RowBox[{"MakeBoxes", "[", 
                    RowBox[{"v", ",", "StandardForm"}], "]"}]}], "]"}], 
                 ",", "\"\<[\>\"", ",", 
                 RowBox[{"MakeBoxes", "[", 
                  RowBox[{"form", ",", "StandardForm"}], "]"}], 
                 ",", "\"\<]\>\""}], "}"}], "]"}]}], "]"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"06d631fb-1c3e-430f-b4e3-0c1321b4a686"],

Cell["\<\
This part is separated in order to avoid renaming confusion between derL and \
derR:\
\>", "Text",ExpressionUUID->"3819bf00-4752-4395-a498-829d96434616"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MakeDerivation", "[", 
    RowBox[{
    "head_", ",", "derL_", ",", "derR_", ",", "prod_", ",", "dergrade_"}], 
    "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"grade", "=", 
       RowBox[{"GradeOfDerivation", "[", 
        RowBox[{"derR", ",", "prod"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Addition", " ", "of", " ", "grades", " ", "in", " ", "algebra"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"head", "/:", 
       RowBox[{"GradeOfDerivation", "[", 
        RowBox[{"head", ",", "prod"}], "]"}], ":=", "dergrade"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"head", "/:", 
       RowBox[{"Grade", "[", 
        RowBox[{
         RowBox[{"derL", "[", 
          RowBox[{"expr_", ",", "___"}], "]"}], ",", "prod"}], "]"}], ":=", 
       RowBox[{
        RowBox[{"Grade", "[", 
         RowBox[{"expr", ",", "prod"}], "]"}], "+", "grade"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"The", " ", 
        RowBox[{"(", "graded", ")"}], " ", "Leibniz", " ", "rule"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"derL", "[", 
        RowBox[{"expr_prod", ",", "rest___"}], "]"}], ":=", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"sumgrades", "=", 
           RowBox[{"FoldList", "[", 
            RowBox[{"Plus", ",", "0", ",", 
             RowBox[{
              RowBox[{
               RowBox[{"Grade", "[", 
                RowBox[{"#", ",", "Wedge"}], "]"}], "&"}], "/@", 
              RowBox[{"List", "@@", "expr"}]}]}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Sum", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{"grade", " ", "*", " ", 
               RowBox[{"sumgrades", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], " ", ")"}]}], "\[IndentingNewLine]", 
            RowBox[{"MapAt", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"derR", "[", 
                RowBox[{"#", ",", "rest"}], "]"}], "&"}], ",", "expr", ",", 
              "i"}], "]"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", 
             RowBox[{"Length", "[", "expr", "]"}]}], "}"}]}], 
          "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], ";",
       "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"QUESTION", ":", " ", 
        RowBox[{
        "Agreement", " ", "with", " ", "a", " ", "regular", " ", "derivative",
          " ", "when", " ", "acting", " ", "on", " ", "scalar", " ", 
         "functions", "??"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"derL", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"func_", "?", "ScalarFunctionQ"}], "[", "args__", "]"}], ",",
          "rest___"}], "]"}], ":=", 
       RowBox[{"xAct`xTensor`Private`multiD", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"derR", "[", 
           RowBox[{"#", ",", "rest"}], "]"}], "&"}], ",", 
         RowBox[{"func", "[", "args", "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", "Dependencies", " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"!", 
         RowBox[{"AtomQ", "[", "derR", "]"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"head", "/:", 
         RowBox[{"DependenciesOfInertHead", "[", "derL", "]"}], ":=", 
         RowBox[{"DependenciesOf", "[", 
          RowBox[{"First", "[", "derR", "]"}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"43bccf9b-d5e8-40e4-8299-6c74c7ab82f9"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.6 Exterior differentiation", \
"Subsubsection",ExpressionUUID->"e5c2f4ea-338a-4ee8-bda1-3b7b9b92d0a7"],

Cell["\<\
The second key ingredient for exterior algebra is the differential operator. \
This a concept defined per manifold, or equivalently per tangent-bundle, \
though in this notebook we create only one differential operator.\
\>", "Text",ExpressionUUID->"2a4eb533-9a84-48d2-aeea-8ccf0084c41d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Diff"}]], "Input",ExpressionUUID->"23e6c681-7821-41fd-be32-67284cbe8294"],

Cell[BoxData[
 StyleBox["\<\"Diff[form] computes the exterior derivative of form. \
Diff[form,covd] computes the exterior covariant derivative of form with \
respect to the covariant derivative covd.\"\>", 
  "MSG"]], "Print", \
"PrintUsage",ExpressionUUID->"4c571e15-00d1-4770-b6f7-ae3573cdbfa1"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefGradedDerivation", "[", 
   RowBox[{"Diff", ",", "Wedge", ",", 
    RowBox[{"+", "1"}], ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<d\>\""}]}], "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d8be30dc-8be7-4210-8b15-5a8756c2659a"],

Cell["We always have PD as the covariant derivative.", \
"Text",ExpressionUUID->"be94bd52-329c-45a3-837f-ec53633d44b5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Diff", "[", "expr_", "]"}], ":=", 
  RowBox[{"Diff", "[", 
   RowBox[{"expr", ",", "PD"}], "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3bf19d1c-46e4-4ac0-8da4-d7e1d7e52139"],

Cell["Superscript formatting for covariant exterior derivatives", \
"Text",ExpressionUUID->"829c983f-097c-4ca4-9860-2d001e82c9dc"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Diff", "/:", 
   RowBox[{"MakeBoxes", "[", 
    RowBox[{
     RowBox[{"Diff", "[", 
      RowBox[{"form_", ",", 
       RowBox[{"PD", "?", "CovDQ"}]}], "]"}], ",", "StandardForm"}], "]"}], ":=", 
   RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
    RowBox[{
     RowBox[{"Diff", "[", 
      RowBox[{"form", ",", "PD"}], "]"}], ",", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PrintAs", "[", "Diff", "]"}], ",", "\"\<[\>\"", ",", 
        RowBox[{"MakeBoxes", "[", 
         RowBox[{"form", ",", "StandardForm"}], "]"}], ",", "\"\<]\>\""}], 
       "}"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Diff", "/:", 
   RowBox[{"MakeBoxes", "[", 
    RowBox[{
     RowBox[{"Diff", "[", 
      RowBox[{"form_", ",", 
       RowBox[{"cd_", "?", "CovDQ"}]}], "]"}], ",", "StandardForm"}], "]"}], ":=", 
   RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
    RowBox[{
     RowBox[{"Diff", "[", 
      RowBox[{"form", ",", "cd"}], "]"}], ",", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"SuperscriptBox", "[", 
         RowBox[{
          RowBox[{"PrintAs", "[", "Diff", "]"}], ",", 
          RowBox[{"Last", "@", 
           RowBox[{"SymbolOfCovD", "[", "cd", "]"}]}]}], "]"}], 
        ",", "\"\<[\>\"", ",", 
        RowBox[{"MakeBoxes", "[", 
         RowBox[{"form", ",", "StandardForm"}], "]"}], ",", "\"\<]\>\""}], 
       "}"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"aeb6d964-1d4b-49f8-baa8-4aea6090c2f9"],

Cell["Thread over lists and equal", \
"Text",ExpressionUUID->"94ef7fcf-d680-4962-b71c-800228a3074e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Diff", "[", 
    RowBox[{
     RowBox[{"expr_", "?", "ArrayQ"}], ",", "cd_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"Diff", "[", 
      RowBox[{"#", ",", "cd"}], "]"}], "&"}], "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Diff", "[", 
    RowBox[{"expr_Equal", ",", "cd_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"Diff", "[", 
      RowBox[{"#", ",", "cd"}], "]"}], "&"}], "/@", "expr"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"d9265dbf-8afb-41f0-aac5-87bcfd0a2eb3"],

Cell["The exterior derivative applied twice is zero:", \
"Text",ExpressionUUID->"893f42eb-f723-451b-b004-f3d81f75105c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Diff", "[", 
   RowBox[{"expr_Diff", ",", "PD"}], "]"}], ":=", "0"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"bcf26608-46c3-4aba-a814-0bc002fc432d"],

Cell["\<\
Exterior derivative of basis objects is zero. TODO: This is not correct.\
\>", "Text",ExpressionUUID->"7aa397ae-b42c-4158-888c-2eb6a7e36788"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Diff", "[", 
    RowBox[{"_Basis", ",", "PD"}], "]"}], ":=", "0"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"ef931e30-ba73-41cb-ab89-184304355317"],

Cell["We still need definition when acting on Times", \
"Text",ExpressionUUID->"993c6050-a9e3-45a6-8fd2-8b59601e2578"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "produces", " ", "expanded", " ", "expressions", " ", "and", " ",
     "is", " ", "much", " ", "faster", " ", "when", " ", "there", " ", "are", 
    " ", "many", " ", "scalars"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"notZero", "=", 
    RowBox[{
     RowBox[{"0", "=!=", "#"}], "&"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Diff", "[", 
      RowBox[{"expr_Times", ",", "cd_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"grades", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"Grade", "[", 
             RowBox[{"#", ",", "Wedge"}], "]"}], "&"}], "/@", 
           RowBox[{"List", "@@", "expr"}]}]}], ",", "pos", ",", "scalar", ",",
          "form"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"pos", "=", 
         RowBox[{"Position", "[", 
          RowBox[{"grades", ",", 
           RowBox[{"_", "?", "notZero"}], ",", "1", ",", 
           RowBox[{"Heads", "\[Rule]", "False"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Which", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "pos", "]"}], ">", "1"}], ",", 
          "\[IndentingNewLine]", "\t", 
          RowBox[{"Throw", "[", 
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"Diff", "::", "error1"}], 
             ",", "\"\<Found Times product of nonscalar forms: \>\"", ",", 
             "expr"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Length", "[", "pos", "]"}], "===", "1"}], ",", 
          "\[IndentingNewLine]", "\t", 
          RowBox[{
           RowBox[{"pos", "=", 
            RowBox[{"pos", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
           "\[IndentingNewLine]", "\t", 
           RowBox[{"scalar", "=", 
            RowBox[{"Delete", "[", 
             RowBox[{"expr", ",", 
              RowBox[{"{", "pos", "}"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", "\t", 
           RowBox[{"form", "=", 
            RowBox[{"expr", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           "\t", 
           RowBox[{
            RowBox[{"scalar", " ", 
             RowBox[{"Diff", "[", 
              RowBox[{"form", ",", "cd"}], "]"}]}], "+", 
            RowBox[{"diff0", "[", 
             RowBox[{"scalar", ",", "cd", ",", "form"}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Length", "[", "pos", "]"}], "===", "0"}], ",", 
          "\[IndentingNewLine]", "\t", 
          RowBox[{"diff0", "[", 
           RowBox[{"expr", ",", "cd"}], "]"}]}], "\[IndentingNewLine]", 
         "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Only", " ", "scalars"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"diff0", "[", 
      RowBox[{"scalar_Times", ",", "cd_"}], "]"}], ":=", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"MapAt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Diff", "[", 
           RowBox[{"#", ",", "cd"}], "]"}], "&"}], ",", "scalar", ",", "i"}], 
        "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "scalar", "]"}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"diff0", "[", 
      RowBox[{"scalar_", ",", "cd_"}], "]"}], ":=", 
     RowBox[{"Diff", "[", 
      RowBox[{"scalar", ",", "cd"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Scalars", " ", "and", " ", "a", " ", "form"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"diff0", "[", 
      RowBox[{"scalar_Times", ",", "cd_", ",", "form_"}], "]"}], ":=", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"MapAt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"diff0", "[", 
           RowBox[{"#", ",", "cd", ",", "form"}], "]"}], "&"}], ",", "scalar",
          ",", "i"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "scalar", "]"}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"diff0", "[", 
      RowBox[{"scalar_", ",", "cd_", ",", "form_"}], "]"}], ":=", 
     RowBox[{"Wedge", "[", 
      RowBox[{
       RowBox[{"Diff", "[", 
        RowBox[{"scalar", ",", "cd"}], "]"}], ",", "form"}], "]"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"81d1a6a7-d3cd-4364-880a-ed0104f35c9e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"0", "=!=", "#1"}], 
  "&"}]], "Output",ExpressionUUID->"38a330a4-eb82-4eee-92bf-725800e51bb0"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Diff", "[", 
    RowBox[{
     RowBox[{"x_", "?", "ConstantQ"}], ",", "cd_"}], "]"}], ":=", "0"}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"398590c0-f574-4d71-9f3d-3990e66f1a7e"],

Cell["Behavior with respect to Dagger.", \
"Text",ExpressionUUID->"227e275f-bd4d-4903-b267-4a1283b17d81"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Diff", "/:", 
   RowBox[{"HoldPattern", "[", 
    RowBox[{"Dagger", "[", 
     RowBox[{"Diff", "[", 
      RowBox[{"expr_", ",", "cd_"}], "]"}], "]"}], "]"}], ":=", 
   RowBox[{"Diff", "[", 
    RowBox[{
     RowBox[{"Dagger", "[", "expr", "]"}], ",", "cd"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"0e0e4c9c-58ae-44bd-b035-ba5e11d811a1"],

Cell["Behaviour with respect to CTensor", \
"Text",ExpressionUUID->"4d2d9284-662d-412e-a1b7-aa712410f710"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Diff", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"CTensor", "[", 
       RowBox[{"array_", ",", "bases_List", ",", "weight_"}], "]"}], "[", 
      "inds__", "]"}], ",", "cd_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"CTensor", "[", 
     RowBox[{
      RowBox[{"Diff", "[", 
       RowBox[{"array", ",", "cd"}], "]"}], ",", "bases", ",", "weight"}], 
     "]"}], "[", "inds", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2c40d747-26ca-4a8b-8ea5-651ef3775d1b"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.7 Introduction of co-frame, eFrame and PDFrame", \
"Subsubsection",ExpressionUUID->"5f5ab242-3e1e-404e-82ca-aa39b523d9b3"],

Cell[TextData[{
 "We create the non-atomic tensor ",
 StyleBox["\[Theta][M]", "InlineFormula"],
 " representing a co-frame. Note that the formatting does not contain the \
manifold as this information is already visible in the abstract index. The \
abstract index may belong to the tangent space of the manifold \
\[OpenCurlyDoubleQuote]M\[CloseCurlyDoubleQuote] or to any other vector \
bundle with base M. In the case of the abstract index belonging to TangentM \
we can think of \[Theta][M] as the set of \[OpenCurlyDoubleQuote]canonical \
1-forms\[CloseCurlyDoubleQuote]. "
}], "Text",ExpressionUUID->"ad1af58b-c864-4df5-8fa0-d72440435c67"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "@", 
    RowBox[{"Coframe", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}]}], "^=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"Coframe", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^:=", 
   RowBox[{"{", 
    RowBox[{"Tangent", "@", "mani"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Coframe", "/:", 
   RowBox[{"GradeOfTensor", "[", 
    RowBox[{
     RowBox[{"Coframe", "[", 
      RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], ",", "Wedge"}], "]"}], "=", 
   "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymmetryGroupOfTensor", "[", 
    RowBox[{"Coframe", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInfo", "[", 
    RowBox[{"Coframe", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{"\"\<General co-frame\>\"", ",", "\"\<\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfTensor", "[", 
    RowBox[{"Coframe", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^:=", 
   RowBox[{"{", "mani", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HostsOf", "[", 
    RowBox[{"Coframe", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorID", "[", 
    RowBox[{"Coframe", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"Coframe", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], 
   "^=", "\"\<\[Theta]\>\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"17fce2d2-41f0-4631-b74c-df2b618bad01"],

Cell["Holonomic Co-frame", \
"Text",ExpressionUUID->"180f8e4c-a8de-41d4-b328-10e01a787a6b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "@", 
    RowBox[{"dx", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}]}], "^=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"dx", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^:=", 
   RowBox[{"{", 
    RowBox[{"Tangent", "@", "mani"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dx", "/:", 
   RowBox[{"GradeOfTensor", "[", 
    RowBox[{
     RowBox[{"dx", "[", 
      RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], ",", "Wedge"}], "]"}], "=", 
   "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymmetryGroupOfTensor", "[", 
    RowBox[{"dx", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInfo", "[", 
    RowBox[{"dx", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{"\"\<General co-frame\>\"", ",", "\"\<\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfTensor", "[", 
    RowBox[{"dx", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^:=", 
   RowBox[{"{", "mani", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HostsOf", "[", 
    RowBox[{"dx", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorID", "[", 
    RowBox[{"dx", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"dx", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^=", "\"\<dx\>\""}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"20f079c4-5b5b-4e6f-aea1-ddb1da124ba0"],

Cell["Condition of the co-frame being holonomic.", \
"Text",ExpressionUUID->"c05fe89e-5107-448b-8007-df63eb49ee80"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Diff", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"dx", "[", 
       RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "[", "ind_", "]"}], ",", 
     "PD"}], "]"}], ":=", "0"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"aac0778d-154d-4492-b278-875715d4f043"],

Cell["General frame:", \
"Text",ExpressionUUID->"7f592d0d-eff9-49d5-9e0a-29704303c812"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "@", 
    RowBox[{"eFrame", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}]}], "^=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"eFrame", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^:=", 
   RowBox[{"{", 
    RowBox[{"-", 
     RowBox[{"Tangent", "@", "mani"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eFrame", "/:", 
   RowBox[{"GradeOfTensor", "[", 
    RowBox[{
     RowBox[{"eFrame", "[", 
      RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], ",", "CircleTimes"}], "]"}],
    "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymmetryGroupOfTensor", "[", 
    RowBox[{"eFrame", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInfo", "[", 
    RowBox[{"eFrame", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{"\"\<General frame\>\"", ",", "\"\<\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfTensor", "[", 
    RowBox[{"eFrame", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^:=", 
   RowBox[{"{", "mani", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HostsOf", "[", 
    RowBox[{"eFrame", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorID", "[", 
    RowBox[{"eFrame", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"eFrame", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^=", "\"\<e\>\""}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"8eda6b6d-085e-421d-8c66-168703b7439a"],

Cell["General holonomic frame:", \
"Text",ExpressionUUID->"d4416cba-8ebd-45bc-9c68-b519d53e4a88"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "@", 
    RowBox[{"PDFrame", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}]}], "^=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"PDFrame", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^:=", 
   RowBox[{"{", 
    RowBox[{"-", 
     RowBox[{"Tangent", "@", "mani"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PDFrame", "/:", 
   RowBox[{"GradeOfTensor", "[", 
    RowBox[{
     RowBox[{"PDFrame", "[", 
      RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], ",", "CircleTimes"}], "]"}],
    "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SymmetryGroupOfTensor", "[", 
    RowBox[{"PDFrame", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^=", 
   RowBox[{"StrongGenSet", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"GenSet", "[", "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInfo", "[", 
    RowBox[{"PDFrame", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{"\"\<General frame\>\"", ",", "\"\<\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfTensor", "[", 
    RowBox[{"PDFrame", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^:=", 
   RowBox[{"{", "mani", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HostsOf", "[", 
    RowBox[{"PDFrame", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorID", "[", 
    RowBox[{"PDFrame", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], "^=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"PDFrame", "[", 
     RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "]"}], 
   "^=", "\"\<\\!\\(\\*FractionBox[\\(\[PartialD]\\),\\(\[PartialD]x\\)]\\)\>\
\""}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"0f0259b6-b281-45bf-8ca7-2769f4e3db79"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "xTensions", " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"xTension", "[", 
      RowBox[{"\"\<xTerior`\>\"", ",", "DefChart", ",", "\"\<End\>\""}], 
      "]"}], ":=", "setdiffs"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"setdiffs", "[", 
      RowBox[{"chartname_", ",", "__"}], "]"}], ":=", 
     RowBox[{"Thread", "[", 
      RowBox[{"ComponentValue", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"dx", "[", 
            RowBox[{"ManifoldOfChart", "@", "chartname"}], "]"}], "[", 
           RowBox[{"{", 
            RowBox[{"#", ",", "chartname"}], "}"}], "]"}], "&"}], "/@", 
         RowBox[{"CNumbersOf", "@", "chartname"}]}], ",", 
        RowBox[{"Diff", "/@", 
         RowBox[{"ScalarsOfChart", "@", "chartname"}]}]}], "]"}], "]"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7368944f-1f01-422d-9d20-367c04f6759b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTension", "[", 
    RowBox[{"\"\<xTerior`\>\"", ",", "DefChart", ",", "\"\<End\>\""}], "]"}], 
   ":=", "defFreeAlgebraChart"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"defFreeAlgebraChart", "[", 
   RowBox[{"basis_", ",", "__"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"scalars", "=", 
       RowBox[{"ScalarsOfChart", "[", "basis", "]"}]}], ",", 
      RowBox[{"numbers", "=", 
       RowBox[{"CNumbersOf", "@", "basis"}]}], ",", 
      RowBox[{"mani", "=", 
       RowBox[{"ManifoldOfChart", "@", "basis"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "Define", " ", "the", " ", "algebra", " ", "elements", " ", "forming", " ",
       "the", " ", "basis", " ", "of", " ", "the", " ", "free", " ", 
      "algebra"}], " ", "*)"}], "\t\t\t\t ", 
    RowBox[{
     RowBox[{"MapThread", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"DefTensor", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"GiveSymbol", "[", 
            RowBox[{"basis", ",", 
             RowBox[{"Abs", "@", "#1"}]}], "]"}], "[", "]"}], ",", "mani", ",", 
          RowBox[{"PrintAs", "\[Rule]", 
           RowBox[{"ColorString", "[", 
            RowBox[{
             
             RowBox[{"\"\<\\!\\(\\*FractionBox[\\(\[PartialD]\\), \\(\
\[PartialD]\>\"", "<>", 
              RowBox[{"PrintAs", "[", 
               RowBox[{"Evaluate", "@", 
                RowBox[{"(", 
                 RowBox[{"Head", "@", "#2"}], ")"}]}], "]"}], 
              "<>", "\"\<\\)]\\)\>\""}], ",", 
             RowBox[{"BasisColor", "@", "basis"}]}], "]"}]}], ",", 
          RowBox[{"GradeOfTensor", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"CircleTimes", "\[Rule]", "1"}], "}"}]}], ",", 
          RowBox[{"Master", "\[Rule]", "basis"}]}], "]"}], "&"}], ",", 
       RowBox[{"{", 
        RowBox[{"numbers", ",", "scalars"}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Assign", " ", "values"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"Thread", "[", 
      RowBox[{"ComponentValue", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"dx", "[", 
            RowBox[{"ManifoldOfChart", "@", "basis"}], "]"}], "[", 
           RowBox[{"{", 
            RowBox[{"#", ",", "basis"}], "}"}], "]"}], "&"}], "/@", 
         RowBox[{"CNumbersOf", "@", "basis"}]}], ",", 
        RowBox[{"Diff", "/@", 
         RowBox[{"ScalarsOfChart", "@", "basis"}]}]}], "]"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Thread", "[", 
      RowBox[{"ComponentValue", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"PDFrame", "[", "mani", "]"}], "[", 
           RowBox[{"{", 
            RowBox[{"#", ",", 
             RowBox[{"-", "basis"}]}], "}"}], "]"}], "&"}], "/@", "numbers"}],
         ",", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"GiveSymbol", "[", 
            RowBox[{"basis", ",", "#"}], "]"}], "[", "]"}], "&"}], "/@", 
         "numbers"}]}], "]"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"c4cf9ffa-ac57-4a00-a8c9-b81df0ad2d18"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTension", "[", 
    RowBox[{"\"\<xTerior`\>\"", ",", "DefBasis", ",", "\"\<End\>\""}], "]"}], 
   ":=", "defFreeAlgebraBasis"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"defFreeAlgebraBasis", "[", 
   RowBox[{"basis_", ",", "__"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"numbers", "=", 
       RowBox[{"CNumbersOf", "@", "basis"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"mani", "=", 
       RowBox[{"BaseOfVBundle", "@", 
        RowBox[{"VBundleOfBasis", "@", "basis"}]}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"Not", "@", 
       RowBox[{"ChartQ", "@", "basis"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "Define", " ", "the", " ", "algebra", " ", "elements", " ", "forming", 
        " ", "the", " ", "basis", " ", "of", " ", "the", " ", "free", " ", 
        "algebra"}], " ", "*)"}], "\t\t\t\t ", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"DefTensor", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"GiveSymbol", "[", 
             RowBox[{"basis", ",", 
              RowBox[{"Abs", "@", "#"}]}], "]"}], "[", "]"}], ",", "mani", ",", 
           RowBox[{"GradeOfTensor", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"CircleTimes", "\[Rule]", "1"}], "}"}]}], ",", 
           RowBox[{"Master", "\[Rule]", "basis"}]}], "]"}], "&"}], "/@", 
        "numbers"}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"Assign", " ", "values"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Thread", "[", 
        RowBox[{"ComponentValue", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"eFrame", "[", "mani", "]"}], "[", 
             RowBox[{"{", 
              RowBox[{"#", ",", 
               RowBox[{"-", "basis"}]}], "}"}], "]"}], "&"}], "/@", 
           "numbers"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"GiveSymbol", "[", 
              RowBox[{"basis", ",", "#"}], "]"}], "[", "]"}], "&"}], "/@", 
           "numbers"}]}], "]"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", "]"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"60148376-06d7-48b3-9f3a-c5cab3837d29"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.8 The Hodge dual", \
"Subsubsection",ExpressionUUID->"f504352b-3cb0-4582-886c-4b73a06ceb22"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Hodge"}]], "Input",ExpressionUUID->"52993286-a51f-4463-b8f8-55cefccb7bf5"],

Cell[BoxData[
 StyleBox["\<\"Hodge[metric][expr] is the Hodge dual of expr defined with \
respect to metric\"\>", 
  "MSG"]], "Print", \
"PrintUsage",ExpressionUUID->"4231bce2-76cf-4261-a71a-bcd3ecfb4f2b"]
}, Open  ]],

Cell["\<\
The third basic ingredient of exterior algebra is Hodge duality, which \
requires the presence of a metric.\
\>", "Text",ExpressionUUID->"d2b5576f-dec6-4d7e-90f3-e91043d8d49d"],

Cell[BoxData[
 RowBox[{"DefInertHead", "[", 
  RowBox[{
   RowBox[{"Hodge", "[", "metric_", "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"LinearQ", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ContractThrough", "\[Rule]", 
    RowBox[{"{", "delta", "}"}]}], ",", "\[IndentingNewLine]", 
   RowBox[{"DefInfo", "\[Rule]", "Null"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"45c2071d-cd26-4e53-87de-313eeab65840"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Hodge", "/:", 
   RowBox[{"PrintAs", "@", 
    RowBox[{"Hodge", "[", "metric_", "]"}]}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Head", "[", "metric", "]"}], "===", "CTensor"}], 
     ",", "\"\<*\>\"", ",", 
     StyleBox[
      RowBox[{"\"\<\\!\\(\\*SubscriptBox[\\(*\\), \\(\>\"", "<>", 
       RowBox[{"PrintAs", "[", "metric", "]"}], "<>", "\"\<\\)]\\)\>\""}],
      ShowSpecialCharacters->False,
      ShowStringCharacters->True,
      NumberMarks->True]}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"90bfccbd-dafe-4392-83fb-e76fef8e5913"],

Cell["Thread over lists and equal", \
"Text",ExpressionUUID->"214c921b-f277-4dea-b808-3bdc898c8f96"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Hodge", "[", "metric_", "]"}], "[", "expr_List", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Hodge", "[", "metric", "]"}], "[", "#", "]"}], "&"}], "/@", 
    "expr"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Hodge", "[", "metric_", "]"}], "[", "expr_Equal", "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Hodge", "[", "metric", "]"}], "[", "#", "]"}], "&"}], "/@", 
    "expr"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"69bac24f-c2f3-4c7a-8961-2af6e4ab3da4"],

Cell["Hodge of a CTensor object", \
"Text",ExpressionUUID->"82995185-3daa-4567-98e7-1837ec6fa1c0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Hodge", "[", "metric_", "]"}], "[", 
    RowBox[{
     RowBox[{"CTensor", "[", 
      RowBox[{"array_", ",", "bases_List", ",", "weight_"}], "]"}], "[", 
     "inds__", "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"CTensor", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Hodge", "[", "metric", "]"}], "[", "array", "]"}], ",", 
      "bases", ",", "weight"}], "]"}], "[", "inds", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"5ba0e24d-664c-41c8-886b-47914a8675c2"],

Cell["Hodge of the product of two objects", \
"Text",ExpressionUUID->"8cdba774-5981-4710-a851-ee6e0c1e9252"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Hodge", "[", "metric_", "]"}], "[", 
   RowBox[{"x_", " ", "y_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{
     RowBox[{"Hodge", "[", "metric", "]"}], "[", "y", "]"}]}], "/;", 
   RowBox[{
    RowBox[{"Grade", "[", 
     RowBox[{"x", ",", "Wedge"}], "]"}], "===", "0"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"96422fd0-a99e-4544-aecb-97ab9ca4474a"],

Cell["\<\
[Jose: This previous definition overlaps with LinearQ->True, so we might want \
to rethink that option in relation with the products and ScalarsOfProduct.]\
\>", "Text",ExpressionUUID->"063cd331-ba55-4d44-825d-a3eb4be2442f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DimOfMetric", "[", "metric_", "]"}], ":=", 
  RowBox[{"DimOfVBundle", "[", 
   RowBox[{"VBundleOfMetric", "[", "metric", "]"}], "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2e226f64-bc4c-41e3-8666-7e6327afc846"],

Cell[BoxData[
 RowBox[{"Hodge", "/:", 
  RowBox[{"Grade", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Hodge", "[", "metric_", "]"}], "[", "expr_", "]"}], ",", 
    "Wedge"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"DimOfMetric", "[", "metric", "]"}], "-", 
   RowBox[{"Grade", "[", 
    RowBox[{"expr", ",", "Wedge"}], "]"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"332861bb-cd75-4365-a17f-a548036c16b6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Hodge", "[", "metric_", "]"}], "@", 
   RowBox[{
    RowBox[{"Hodge", "[", "metric_", "]"}], "[", "expr_", "]"}]}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Grade", "[", 
        RowBox[{"expr", ",", "Wedge"}], "]"}], 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"DimOfMetric", "[", "metric", "]"}], "-", "1"}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"SignatureOfMetric", "[", "metric", "]"}], "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "expr"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"e82ab0a7-38da-4069-83e8-dc4f831bb0da"],

Cell["\<\
This function converts Hodge duals of product of the coframe basis (either \
holonomic or non-holonomic):\
\>", "Text",ExpressionUUID->"e1147b3a-4441-45a9-9d0a-7b17813e8899"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "ExpandHodgeDual"}]], \
"Input",ExpressionUUID->"7e50a777-cee6-4f02-a01e-6d0618b1d3d7"],

Cell[BoxData[
 StyleBox["\<\"ExpandHodgeDual[expr,Coframe[mani],g] expands out all the \
Hodge duals of the exterior powers of Coframe[mani], defined with respect to \
the metric g. If the manifold tag mani is dropped, then all the instances of \
Coframe are expanded. The Coframe label can be replaced by dx if we are using \
the holonomic coframe.\"\>", 
  "MSG"]], "Print", \
"PrintUsage",ExpressionUUID->"a43535f9-2963-43c4-90f4-52f6f4dbd3b3"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Expand", " ", "dual", " ", "of", " ", "differentials", " ", "of", " ", 
    "coordinate", " ", "elements"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ExpandHodgeDual", "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"dx", "[", 
        RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], ",", "met_"}], "]"}], ":=", 
     RowBox[{"ExpandHodgeDual1", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"expr", "/.", 
         RowBox[{"Reverse", "/@", 
          RowBox[{"Flatten", "[", 
           RowBox[{"List", "@@", 
            RowBox[{"TensorValues", "@", 
             RowBox[{"dx", "[", "mani", "]"}]}]}], "]"}]}]}], ")"}], ",", 
       RowBox[{"dx", "[", "mani", "]"}], ",", "met"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Expand", " ", "of", " ", "the", " ", "wedge", " ", "product", " ", "of",
       " ", "canonical", " ", "1"}], "-", "forms"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ExpandHodgeDual", "[", 
      RowBox[{"expr_", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"coframe", ":", 
          RowBox[{"(", 
           RowBox[{"Coframe", "|", "dx"}], ")"}]}], ")"}], "[", 
        RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], ",", "met_"}], "]"}], ":=", 
     RowBox[{"ExpandHodgeDual1", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"coframe", "[", "mani", "]"}], ",", "met"}], "]"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"226c5a83-80a6-45f0-b853-04737de07eb2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ExpandHodgeDual1", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"coframe", ":", 
        RowBox[{"(", 
         RowBox[{"Coframe", "|", "dx"}], ")"}]}], ")"}], "[", 
      RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], ",", "met_"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"expr", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"HoldPattern", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Hodge", "[", "met", "]"}], "[", 
          RowBox[{"form", ":", 
           RowBox[{"Wedge", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"coframe", "[", "mani", "]"}], "[", "_", "]"}], ".."}], 
            "]"}]}], "]"}], "|", 
         RowBox[{"form", ":", 
          RowBox[{
           RowBox[{"Hodge", "[", "met", "]"}], "[", 
           RowBox[{
            RowBox[{"coframe", "[", "mani", "]"}], "[", "_", "]"}], "]"}]}]}],
         "]"}], "\[RuleDelayed]", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"dim", "=", 
            RowBox[{"DimOfMetric", "[", "met", "]"}]}], ",", 
           RowBox[{"n", "=", 
            RowBox[{"Length", "[", "form", "]"}]}], ",", 
           RowBox[{"inds", "=", 
            RowBox[{"Sequence", "@@@", 
             RowBox[{"List", "@@", "form"}]}]}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"dummies", "=", 
             RowBox[{"DummyIn", "/@", 
              RowBox[{"ConstantArray", "[", 
               RowBox[{
                RowBox[{"VBundleOfMetric", "[", "met", "]"}], ",", 
                RowBox[{"dim", "-", "n"}]}], "]"}]}]}], "}"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"1", "/", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"dim", "-", "n"}], ")"}], "!"}]}], 
            RowBox[{
             RowBox[{"epsilon", "[", "met", "]"}], "@@", 
             RowBox[{"Join", "[", 
              RowBox[{"inds", ",", 
               RowBox[{"ChangeIndex", "/@", "dummies"}]}], "]"}]}], 
            RowBox[{"Wedge", "@@", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"coframe", "[", "mani", "]"}], "/@", "dummies"}], 
              ")"}]}]}]}], "\[IndentingNewLine]", "]"}]}], 
        "\[IndentingNewLine]", "]"}]}], ",", 
      RowBox[{
       RowBox[{"HoldPattern", "[", 
        RowBox[{
         RowBox[{"Hodge", "[", "met", "]"}], "[", "form_", "]"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"With", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"dim", "=", 
            RowBox[{"DimOfMetric", "[", "met", "]"}]}], "}"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"dummies", "=", 
              RowBox[{"DummyIn", "/@", 
               RowBox[{"ConstantArray", "[", 
                RowBox[{
                 RowBox[{"VBundleOfMetric", "[", "met", "]"}], ",", "dim"}], 
                "]"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"form", "/", 
              RowBox[{
               RowBox[{"(", "dim", ")"}], "!"}]}], 
             RowBox[{
              RowBox[{"epsilon", "[", "met", "]"}], "@@", 
              RowBox[{"(", 
               RowBox[{"ChangeIndex", "/@", "dummies"}], ")"}]}], 
             RowBox[{"Wedge", "@@", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"coframe", "[", "mani", "]"}], "/@", "dummies"}], 
               ")"}]}]}]}], "\[IndentingNewLine]", "]"}]}], 
         "\[IndentingNewLine]", "]"}], "/;", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Deg", "[", "form", "]"}], "===", "0"}], ")"}]}]}]}], 
     "}"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c6179720-423e-42bf-9662-d03ef421ff1d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ExpandHodgeDual1", "[", 
    RowBox[{"expr_", ",", "Coframe", ",", "met_"}], "]"}], ":=", 
   RowBox[{"Fold", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ExpandHodgeDual1", "[", 
       RowBox[{"#1", ",", 
        RowBox[{"Coframe", "[", "#2", "]"}], ",", "met"}], "]"}], "&"}], ",", 
     "expr", ",", "$Manifolds"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"a0007833-3d37-44f2-997c-b3c54f06ea22"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ExpandHodgeDual1", "[", 
    RowBox[{"expr_", ",", "dx", ",", "met_"}], "]"}], ":=", 
   RowBox[{"Fold", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ExpandHodgeDual1", "[", 
       RowBox[{"#1", ",", 
        RowBox[{"dx", "[", "#2", "]"}], ",", "met"}], "]"}], "&"}], ",", 
     "expr", ",", "$Manifolds"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"152d6108-13ac-428f-8f61-a50959f90c46"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.9 The co-differential", \
"Subsubsection",ExpressionUUID->"dc9c4468-bf80-430d-8150-2a5da5beb604"],

Cell["We introduce the co-differential.", \
"Text",ExpressionUUID->"f9f430f2-28c1-41df-b654-38e157d616d8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefInertHead", "[", 
   RowBox[{
    RowBox[{"Codiff", "[", "metric_", "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"LinearQ", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
    RowBox[{"ContractThrough", "\[Rule]", "delta"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"DefInfo", "\[Rule]", "Null"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"1f6aad8b-e27f-4740-a88b-20e1ec9eb623"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Codiff", "/:", 
   RowBox[{"PrintAs", "@", 
    RowBox[{"Codiff", "[", "metric_", "]"}]}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Head", "@", "metric"}], "===", "CTensor"}], 
     ",", "\"\<\[Delta]\>\"", ",", 
     StyleBox[
      RowBox[{"\"\<\\!\\(\\*SubscriptBox[\\(\\[Delta]\\), \\(\>\"", "<>", 
       RowBox[{"PrintAs", "[", "metric", "]"}], "<>", "\"\<\\)]\\)\>\""}],
      ShowSpecialCharacters->False,
      ShowStringCharacters->True,
      NumberMarks->True]}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d4f671cd-e619-4fe0-b64e-f15026fe5776"],

Cell[BoxData[
 RowBox[{"Codiff", "/:", 
  RowBox[{"Grade", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Codiff", "[", "metric_", "]"}], "[", 
     RowBox[{"expr_", ",", "___"}], "]"}], ",", "Wedge"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"Grade", "[", 
    RowBox[{"expr", ",", "Wedge"}], "]"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"4df7b5de-ef07-4a35-9cf7-2436c8b321fa"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Codiff", "/:", 
   RowBox[{"MakeBoxes", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Codiff", "[", "metric_", "]"}], "[", 
      RowBox[{"form_", ",", 
       RowBox[{"PD", "?", "CovDQ"}]}], "]"}], ",", "StandardForm"}], "]"}], ":=", 
   RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Codiff", "[", "metric", "]"}], "[", 
      RowBox[{"form", ",", "PD"}], "]"}], ",", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PrintAs", "[", 
         RowBox[{"Codiff", "[", "metric", "]"}], "]"}], ",", "\"\<[\>\"", ",", 
        RowBox[{"MakeBoxes", "[", 
         RowBox[{"form", ",", "StandardForm"}], "]"}], ",", "\"\<]\>\""}], 
       "}"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Codiff", "/:", 
   RowBox[{"MakeBoxes", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Codiff", "[", "metric_", "]"}], "[", 
      RowBox[{"form_", ",", 
       RowBox[{"cd_", "?", "CovDQ"}]}], "]"}], ",", "StandardForm"}], "]"}], ":=", 
   RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Codiff", "[", "metric", "]"}], "[", 
      RowBox[{"form", ",", "cd"}], "]"}], ",", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"SuperscriptBox", "[", 
         RowBox[{
          RowBox[{"PrintAs", "[", 
           RowBox[{"Codiff", "[", "metric", "]"}], "]"}], ",", 
          RowBox[{"Last", "@", 
           RowBox[{"SymbolOfCovD", "[", "cd", "]"}]}]}], "]"}], 
        ",", "\"\<[\>\"", ",", 
        RowBox[{"MakeBoxes", "[", 
         RowBox[{"form", ",", "StandardForm"}], "]"}], ",", "\"\<]\>\""}], 
       "}"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"c1044850-034a-415e-86be-632a94ebb28d"],

Cell["We always have PD as the covariant derivative.", \
"Text",ExpressionUUID->"cd50f607-7a19-41b1-ad5a-1243397c1d29"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{
     RowBox[{"Codiff", "[", "met_", "]"}], "[", "expr_", "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Codiff", "[", "met", "]"}], "[", 
    RowBox[{"expr", ",", "PD"}], "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"8025a48f-6a9a-4517-9a46-153f9f3e8b0a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CodiffToDiff", "[", "expr_", "]"}], ":=", 
  RowBox[{"expr", "//.", 
   RowBox[{
    RowBox[{
     RowBox[{"Codiff", "[", "met_", "]"}], "[", 
     RowBox[{"expr1_", ",", 
      RowBox[{"covd_", "?", "CovDQ"}]}], "]"}], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"DimOfMetric", "[", "met", "]"}], 
         RowBox[{"Grade", "[", 
          RowBox[{"expr1", ",", "Wedge"}], "]"}]}], "+", 
        RowBox[{"DimOfMetric", "[", "met", "]"}], "+", 
        RowBox[{
         RowBox[{"SignatureOfMetric", "[", "met", "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], 
     RowBox[{
      RowBox[{"Hodge", "[", "met", "]"}], "@", 
      RowBox[{"Diff", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Hodge", "[", "met", "]"}], "@", "expr1"}], ",", "covd"}], 
       "]"}]}]}]}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"25c98144-e907-458e-b916-ff7a3d50a712"],

Cell["For convenience we program this identity:", \
"Text",ExpressionUUID->"93cceb11-5574-4c3a-858c-d7a77d96e0a9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Codiff", "[", "metric_", "]"}], "[", 
   RowBox[{
    RowBox[{"Codiff", "[", "metric_", "]"}], "[", 
    RowBox[{"expr_", ",", "PD"}], "]"}], "]"}], ":=", "0"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"de6efb6c-adec-45d3-8885-142820ec1d03"],

Cell["Co-differential of basis objects is zero.", \
"Text",ExpressionUUID->"9d571574-2bb8-4cfb-bfab-48bc18ca36eb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Codiff", "[", 
    RowBox[{"_Basis", ",", 
     RowBox[{"covd_", "?", "CovDQ"}]}], "]"}], ":=", "0"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"8ecccb08-cfc6-4d85-8fb9-c7ea5298b771"],

Cell["Thread over lists and equal", \
"Text",ExpressionUUID->"8895e05f-5b0b-4ec0-9ae6-3d4fcc7c46f1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Codiff", "@", "expr_List"}], ":=", 
   RowBox[{"Codiff", "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Codiff", "@", "expr_Equal"}], ":=", 
   RowBox[{"Codiff", "/@", "expr"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"8063eb83-0bbe-40ca-a330-310840771a67"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2.10 Poincar\[EAcute] lemma", \
"Subsubsection",ExpressionUUID->"f1333e4b-5483-4c21-b321-44746254e837"],

Cell["\<\
We implement the computation of the potential for an exact form (Poincar\
\[EAcute] lemma)\
\>", "Text",ExpressionUUID->"f84b91b1-156d-4e62-8f9a-4f5c56db49a7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FindPotential", "[", 
    RowBox[{"expr_Plus", ",", "point_List", ",", 
     RowBox[{"chart_", "?", "ChartQ"}], ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "Integrate", "]"}]}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"FindPotential", "[", 
      RowBox[{"#", ",", "point", ",", "chart", ",", "options"}], "]"}], "&"}],
     "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FindPotential", "[", 
    RowBox[{"expr_Times", ",", "point_List", ",", 
     RowBox[{"chart_", "?", "ChartQ"}], ",", 
     RowBox[{"options", ":", 
      RowBox[{"OptionsPattern", "[", "Integrate", "]"}]}]}], "]"}], ":=", 
   RowBox[{"FindPotential", "[", 
    RowBox[{
     RowBox[{"Expand", "@", "expr"}], ",", "point", ",", "chart", ",", 
     "options"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"2b83d7c6-a741-4c02-a2be-49f27c1ea4a9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Simplest", " ", "cases", " ", "for", " ", "grade", " ", "1", " ", 
    "forms"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"FindPotential", "[", 
      RowBox[{"expr_Diff", ",", "point_List", ",", 
       RowBox[{"chart_", "?", "ChartQ"}], ",", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", "Integrate", "]"}]}]}], "]"}], ":=", 
     RowBox[{"Part", "[", 
      RowBox[{"expr", ",", "1"}], "]"}]}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FindPotential", "[", 
      RowBox[{
       RowBox[{"factor_", " ", "expr_Diff"}], ",", "point_List", ",", 
       RowBox[{"chart_", "?", "ChartQ"}], ",", 
       RowBox[{"options", ":", 
        RowBox[{"OptionsPattern", "[", "Integrate", "]"}]}]}], "]"}], ":=", 
     RowBox[{"Integrate1", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"factor", "/.", 
          RowBox[{"Thread", "[", 
           RowBox[{"Rule", "[", 
            RowBox[{
             RowBox[{"ScalarsOfChart", "@", "chart"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Times", "[", 
                 RowBox[{"#", ",", "t"}], "]"}], "&"}], "/@", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"ScalarsOfChart", "@", "chart"}], "-", "point"}], 
                ")"}]}], "+", "point"}]}], "]"}], "]"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Part", "[", 
           RowBox[{"expr", ",", "1"}], "]"}], "-", 
          RowBox[{"Part", "[", 
           RowBox[{"point", ",", 
            RowBox[{"First", "@", 
             RowBox[{"Flatten", "@", 
              RowBox[{"Position", "[", 
               RowBox[{
                RowBox[{"ScalarsOfChart", "@", "chart"}], ",", 
                RowBox[{"Part", "[", 
                 RowBox[{"expr", ",", "1"}], "]"}]}], "]"}]}]}]}], "]"}]}], 
         ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", "options"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Do", " ", "the", " ", "actual", " ", "integration"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Integrate1", "/:", 
     RowBox[{"HoldPattern", "@", 
      RowBox[{"Plus", "[", "var__Integrate1", "]"}]}], ":=", 
     RowBox[{"Integrate", "[", 
      RowBox[{
       RowBox[{"Plus", "@@", 
        RowBox[{"First", "/@", 
         RowBox[{"{", "var", "}"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"834e3328-349b-4fa9-97f8-a033647b5dc2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Poincare", " ", "Lemma", " ", "for", " ", "higher", " ", "degree", " ", 
    "forms"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"FindPotential", "[", 
     RowBox[{
      RowBox[{"factor_.", "expr_Wedge"}], ",", "point_List", ",", 
      RowBox[{"chart_", "?", "ChartQ"}], ",", 
      RowBox[{"options", ":", 
       RowBox[{"OptionsPattern", "[", "Integrate", "]"}]}]}], "]"}], ":=", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"factor", "/.", 
         RowBox[{"Thread", "[", 
          RowBox[{"Rule", "[", 
           RowBox[{
            RowBox[{"ScalarsOfChart", "@", "chart"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"Times", "[", 
                RowBox[{"#", ",", "t"}], "]"}], "&"}], "/@", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"ScalarsOfChart", "@", "chart"}], "-", "point"}], 
               ")"}]}], "+", "point"}]}], "]"}], "]"}]}], ")"}], " ", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"i", "-", "1"}], ")"}]}], 
          RowBox[{"t", "^", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Deg", "@", "expr"}], "-", "1"}], ")"}]}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Part", "[", 
             RowBox[{"expr", ",", "i", ",", "1"}], "]"}], "-", 
            RowBox[{"Part", "[", 
             RowBox[{"point", ",", 
              RowBox[{"First", "@", 
               RowBox[{"Flatten", "@", 
                RowBox[{"Position", "[", 
                 RowBox[{
                  RowBox[{"ScalarsOfChart", "@", "chart"}], ",", 
                  RowBox[{"Part", "[", 
                   RowBox[{"expr", ",", "i", ",", "1"}], "]"}]}], "]"}]}]}]}],
              "]"}]}], ")"}], 
          RowBox[{"Delete", "[", 
           RowBox[{"expr", ",", 
            RowBox[{"{", "i", "}"}]}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "expr", "]"}]}], "}"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", "options"}], "]"}]}], 
   ";"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"6bf555f4-818e-4541-9879-0659a731dc42"]
}, Closed]],

Cell[CellGroupData[{

Cell["2.11. Integration of differential forms", \
"Subsubsection",ExpressionUUID->"e8b515d7-cf42-47a3-835c-e3e779d8ad60"],

Cell["Formatting of integration of differential forms:", \
"Text",ExpressionUUID->"3aa51bc8-2cdb-42df-a876-f78160bb6d07"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FormIntegrate", "::", "dim"}], 
   "=", "\"\<Degree of form `1` is incompatible with dimension of manifold \
`2`.\>\""}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f704d1e8-4360-49ae-828f-d74dbb4f2990"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"InertHeadQ", "[", "FormIntegrate", "]"}], "^:=", "True"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LinearQ", "[", "FormIntegrate", "]"}], "^:=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FormIntegrate", "[", 
    RowBox[{"expr_Plus", ",", 
     RowBox[{"man_", "?", "ManifoldQ"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"FormIntegrate", "[", 
      RowBox[{"#", ",", "man"}], "]"}], "&"}], "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FormIntegrate", "[", 
    RowBox[{"form_", ",", "EmptyManifold"}], "]"}], ":=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FormIntegrate", "[", 
    RowBox[{
     RowBox[{"c_", "?", "ConstantQ"}], ",", 
     RowBox[{"man_", "?", "ManifoldQ"}]}], "]"}], ":=", 
   RowBox[{"c", "/;", 
    RowBox[{
     RowBox[{"DimOfManifold", "[", "man", "]"}], "==", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"FormIntegrate", "[", 
    RowBox[{"form_", ",", 
     RowBox[{"man_", "?", "ManifoldQ"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"If", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"form", "===", "0"}], ",", "0", ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Throw", "[", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"FormIntegrate", "::", "dim"}], ",", "form", ",", "man"}], 
         "]"}], "]"}], ";", "$Failed"}]}], "\[IndentingNewLine]", "]"}], "/;", 
    RowBox[{
     RowBox[{"Deg", "[", "form", "]"}], "=!=", 
     RowBox[{"DimOfManifold", "[", "man", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ToCanonical", "[", 
    RowBox[{
     RowBox[{"FormIntegrate", "[", 
      RowBox[{"form_", ",", "man_"}], "]"}], ",", "opts___"}], "]"}], "^:=", 
   RowBox[{"FormIntegrate", "[", 
    RowBox[{
     RowBox[{"ToCanonical", "[", 
      RowBox[{"form", ",", "opts"}], "]"}], ",", "man"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FormIntegrate", "/:", 
   RowBox[{"Grade", "[", 
    RowBox[{
     RowBox[{"FormIntegrate", "[", 
      RowBox[{"form_", ",", "man_"}], "]"}], ",", "Wedge"}], "]"}], ":=", 
   RowBox[{"0", "/;", 
    RowBox[{
     RowBox[{"Deg", "[", "form", "]"}], "===", 
     RowBox[{"DimOfManifold", "[", "man", "]"}]}]}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"1ad5d392-0277-46fa-a2b7-47cb81e56b96"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Formatting", ".", " ", "Do"}], " ", "not", " ", "remove", " ", 
    "the", " ", 
    RowBox[{"ugly", " ", "?", "InertHeadQ"}], " ", "check", " ", 
    RowBox[{"here", ".", " ", "It"}], " ", "would", " ", "break", " ", 
    "typesetting"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"FormIntegrate", "/:", 
     RowBox[{"MakeBoxes", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"FormIntegrate", "?", "InertHeadQ"}], "[", 
        RowBox[{"form_", ",", "man_"}], "]"}], ",", "StandardForm"}], "]"}], ":=", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"SubscriptBox", "[", 
         RowBox[{"\"\<\[Integral]\>\"", ",", 
          RowBox[{"MakeBoxes", "[", 
           RowBox[{"man", ",", "StandardForm"}], "]"}]}], "]"}], ",", 
        RowBox[{"MakeBoxes", "[", 
         RowBox[{"form", ",", "StandardForm"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"This", " ", 
     RowBox[{"doesn", "'"}], "t", " ", "work"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MakeExpression", "[", 
      RowBox[{
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"SubscriptBox", "[", 
           RowBox[{"\"\<\[Integral]\>\"", ",", "man_"}], "]"}], ",", 
          "form_"}], "}"}], "]"}], ",", "StandardForm"}], "]"}], ":=", 
     RowBox[{"FormIntegrate", "[", 
      RowBox[{
       RowBox[{"MakeExpression", "[", 
        RowBox[{"form", ",", "StandardForm"}], "]"}], ",", 
       RowBox[{"MakeExpression", "[", 
        RowBox[{"man", ",", "StandardForm"}], "]"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"b3b7ffcd-8508-4573-a946-5d595268901e"],

Cell["\<\
Use the Stokes theorem. By default it converts n-dimensional integration into \
(n-1)-dimensional integration, but using the two-argument form, UseStokes can \
work in both directions:\
\>", "Text",ExpressionUUID->"76f471fe-337d-4b74-aa9b-903de5c6086d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"UseStokes", "[", "expr_", "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"FormIntegrate", "[", 
       RowBox[{
        RowBox[{"Diff", "[", 
         RowBox[{"form_", ",", "PD"}], "]"}], ",", "man_"}], "]"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"FormIntegrate", "[", 
      RowBox[{"form", ",", 
       RowBox[{"ManifoldBoundary", "[", "man", "]"}]}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UseStokes", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"man_", "?", "ManifoldQ"}]}], "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"FormIntegrate", "[", 
       RowBox[{
        RowBox[{"Diff", "[", 
         RowBox[{"form_", ",", "PD"}], "]"}], ",", "man"}], "]"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"FormIntegrate", "[", 
      RowBox[{"form", ",", 
       RowBox[{"ManifoldBoundary", "[", "man", "]"}]}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"UseStokes", "[", 
    RowBox[{"expr_", ",", "form_"}], "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"FormIntegrate", "[", 
       RowBox[{"form", ",", 
        RowBox[{"ManifoldBoundary", "[", "man_", "]"}]}], "]"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"FormIntegrate", "[", 
      RowBox[{
       RowBox[{"Diff", "[", "form", "]"}], ",", "man"}], "]"}]}]}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"78523c8f-56eb-40e3-834b-edc56b4b94c0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", "DefInertHead", 
  "]"}]], "Input",ExpressionUUID->"416338e2-b80c-4f5a-af56-f3ac190821ec"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LinearQ", "\[Rule]", "False"}], ",", 
   RowBox[{"ContractThrough", "\[Rule]", 
    RowBox[{"{", "}"}]}], ",", 
   RowBox[{"Master", "\[Rule]", "Null"}], ",", 
   RowBox[{"PrintAs", "\[Rule]", "Identity"}], ",", 
   RowBox[{"ProtectNewSymbol", "\[RuleDelayed]", "$ProtectNewSymbols"}], ",", 
   
   RowBox[{"DefInfo", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\<\"inert head\"\>", ",", "\<\"\"\>"}], "}"}]}]}], 
  "}"}]], "Output",ExpressionUUID->"a8fc20bb-6eb5-4975-8759-5a8c523412c5"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["2.12 Koszul operator and its properties", \
"Subsubsection",ExpressionUUID->"28b3f5bd-7a6d-41b9-bf97-f900bae58849"],

Cell[TextData[{
 "Koszul operator is a xTension of ",
 StyleBox["DefCovD",
  FontWeight->"Bold"],
 ":"
}], "Text",ExpressionUUID->"fa35281e-797c-41d1-8262-dba9548e620a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "xTensions", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Actual", " ", "definition", " ", "of", " ", "the", " ", "Koszul", " ", 
    "operator"}], " ", "*)"}], "\n", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"xTension", "[", 
      RowBox[{"\"\<xTerior`\>\"", ",", "DefCovD", ",", "\"\<End\>\""}], "]"}],
      ":=", "defKoszulCovD"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Properties", " ", "of", " ", "the", " ", "Koszul", " ", "operator", " ", 
     "when", " ", "acting", " ", "on", " ", "the", " ", "elements", " ", "of",
      " ", "a", " ", "chart"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"xTension", "[", 
      RowBox[{"\"\<xCoba`\>\"", ",", "DefChart", ",", "\"\<End\>\""}], "]"}], 
     ":=", "setKoszulValue"}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"4457a03f-ded7-4f38-ae76-1aa23feb0a85"],

Cell["\<\
Actual definition of the Koszul operator. In addition we also define the \
corresponding \[OpenCurlyDoubleQuote]index free covariant derivative\
\[CloseCurlyDoubleQuote]:\
\>", "Text",ExpressionUUID->"acb517ad-09b0-4a60-89e1-4f28d3d28b3a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"defKoszulCovD", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"covd_", "?", "CovDQ"}], "[", "_", "]"}], ",", "__"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"covdsymbol", "=", 
       RowBox[{"GiveSymbol", "[", 
        RowBox[{"Koszul", ",", "covd"}], "]"}]}], ",", 
      RowBox[{"covdsymbolf", "=", 
       RowBox[{"GiveSymbol", "[", 
        RowBox[{"CovD", ",", "covd"}], "]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"xAct`xTerior`Private`DefGradedDerivation", "[", 
      RowBox[{
       RowBox[{"covdsymbol", "[", "v_", "]"}], ",", "CircleTimes", ",", "0", ",", 
       RowBox[{"PrintAs", "\[Rule]", 
        RowBox[{"Last", "@", 
         RowBox[{"SymbolOfCovD", "[", "covd", "]"}]}]}], ",", 
       RowBox[{"Master", "\[Rule]", "covd"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"DefInertHead", "[", 
      RowBox[{"covdsymbolf", ",", 
       RowBox[{"PrintAs", "\[Rule]", 
        RowBox[{"Last", "@", 
         RowBox[{"SymbolOfCovD", "[", "covd", "]"}]}]}], ",", 
       RowBox[{"LinearQ", "\[Rule]", "True"}], ",", 
       RowBox[{"Master", "\[Rule]", "covd"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{
        RowBox[{"covdsymbol", "[", "v_", "]"}], "[", 
        RowBox[{"expr_", "?", "ConstantQ"}], "]"}], "]"}], ":=", "0"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{
        RowBox[{"covdsymbol", "[", 
         RowBox[{"factor_", " ", "v_"}], "]"}], "[", "expr_", "]"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"factor", " ", 
        RowBox[{
         RowBox[{"covdsymbol", "[", "v", "]"}], "[", "expr", "]"}]}], "/;", 
       RowBox[{
        RowBox[{"Grade", "[", 
         RowBox[{"factor", ",", "CircleTimes"}], "]"}], "===", "0"}]}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{
        RowBox[{"covdsymbol", "[", "v_", "]"}], "[", 
        RowBox[{"expr1_", " ", "expr2_"}], "]"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"expr2", " ", 
        RowBox[{
         RowBox[{"covdsymbol", "[", "v", "]"}], "[", "expr1", "]"}]}], "+", 
       RowBox[{"expr1", " ", 
        RowBox[{
         RowBox[{"covdsymbol", "[", "v", "]"}], "[", "expr2", "]"}]}]}]}], ";",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"covdsymbolf", "[", 
        RowBox[{"expr_", "?", "ConstantQ"}], "]"}], "]"}], ":=", "0"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"covdsymbolf", "[", "expr_", "]"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"Diff", "[", "expr", "]"}], "/;", 
       RowBox[{
        RowBox[{"Grade", "[", 
         RowBox[{"expr", ",", "CircleTimes"}], "]"}], "===", "0"}]}]}], ";", 
     "\[IndentingNewLine]", " ", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"covdsymbolf", "[", 
        RowBox[{"expr1_", " ", "expr2_"}], "]"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"CircleTimes", "[", 
        RowBox[{
         RowBox[{"covdsymbolf", "[", "expr1", "]"}], ",", "expr2"}], "]"}], "+", 
       RowBox[{"CircleTimes", "[", 
        RowBox[{
         RowBox[{"covdsymbolf", "[", "expr2", "]"}], ",", "expr1"}], 
        "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"CircleTimes", "/:", 
      RowBox[{"HoldPattern", "@", 
       RowBox[{"Grade", "[", 
        RowBox[{
         RowBox[{"covdsymbolf", "[", "expr_", "]"}], ",", "CircleTimes"}], 
        "]"}]}], ":=", 
      RowBox[{
       RowBox[{"Grade", "[", 
        RowBox[{"expr", ",", "CircleTimes"}], "]"}], "+", "1"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Wedge", "/:", 
      RowBox[{"HoldPattern", "[", 
       RowBox[{"Grade", "[", 
        RowBox[{
         RowBox[{"covdsymbolf", "[", "expr_", "]"}], ",", "Wedge"}], "]"}], 
       "]"}], ":=", 
      RowBox[{
       RowBox[{"Grade", "[", 
        RowBox[{"expr", ",", "Wedge"}], "]"}], "+", "1"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CircleTimes", "/:", 
      RowBox[{"HoldPattern", "[", 
       RowBox[{"Grade", "[", 
        RowBox[{
         RowBox[{"covdsymbolf", "[", "expr_", "]"}], ",", "CircleTimes"}], 
        "]"}], "]"}], ":=", 
      RowBox[{
       RowBox[{"Grade", "[", 
        RowBox[{"expr", ",", "CircleTimes"}], "]"}], "+", "1"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{
        RowBox[{"covd", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"a_", "?", "NumberQ"}], ",", "basis_"}], "}"}], "]"}], "@",
         "expr_"}], "]"}], ":=", "\[IndentingNewLine]", 
      RowBox[{"Which", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"ChartQ", "[", "basis", "]"}], "&&", 
         RowBox[{
          RowBox[{"Grade", "[", 
           RowBox[{"expr", ",", "CircleTimes"}], "]"}], "\[GreaterEqual]", 
          "1"}]}], ",", "\[IndentingNewLine]", "\t", 
        RowBox[{
         RowBox[{"covdsymbol", "[", 
          RowBox[{
           RowBox[{"PDFrame", "[", 
            RowBox[{"ManifoldOfCovD", "@", "covd"}], "]"}], "[", 
           RowBox[{"{", 
            RowBox[{"a", ",", "basis"}], "}"}], "]"}], "]"}], "[", "expr", 
         "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"BasisQ", "[", "basis", "]"}], "&&", 
         RowBox[{
          RowBox[{"Grade", "[", 
           RowBox[{"expr", ",", "CircleTimes"}], "]"}], "\[GreaterEqual]", 
          "1"}]}], ",", "\[IndentingNewLine]", "\t", 
        RowBox[{
         RowBox[{"covdsymbol", "[", 
          RowBox[{
           RowBox[{"eFrame", "[", 
            RowBox[{"ManifoldOfCovD", "@", "covd"}], "]"}], "[", 
           RowBox[{"{", 
            RowBox[{"a", ",", "basis"}], "}"}], "]"}], "]"}], "[", "expr", 
         "]"}], ",", "\[IndentingNewLine]", "True", ",", 
        "\[IndentingNewLine]", "\t", "$Failed"}], "\[IndentingNewLine]", 
       "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{
        RowBox[{"covd", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"a_", "?", "NumberQ"}], ",", 
           RowBox[{"-", "basis_"}]}], "}"}], "]"}], "@", "expr_"}], "]"}], ":=",
       "\[IndentingNewLine]", 
      RowBox[{"Which", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"ChartQ", "[", "basis", "]"}], "&&", 
         RowBox[{
          RowBox[{"Grade", "[", 
           RowBox[{"expr", ",", "CircleTimes"}], "]"}], "\[GreaterEqual]", 
          "1"}]}], ",", "\[IndentingNewLine]", "\t", 
        RowBox[{
         RowBox[{"covdsymbol", "[", 
          RowBox[{
           RowBox[{"PDFrame", "[", 
            RowBox[{"ManifoldOfCovD", "@", "covd"}], "]"}], "[", 
           RowBox[{"{", 
            RowBox[{"a", ",", 
             RowBox[{"-", "basis"}]}], "}"}], "]"}], "]"}], "[", "expr", 
         "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"BasisQ", "[", "basis", "]"}], "&&", 
         RowBox[{
          RowBox[{"Grade", "[", 
           RowBox[{"expr", ",", "CircleTimes"}], "]"}], "\[GreaterEqual]", 
          "1"}]}], ",", "\[IndentingNewLine]", "\t", 
        RowBox[{
         RowBox[{"covdsymbol", "[", 
          RowBox[{
           RowBox[{"eFrame", "[", 
            RowBox[{"ManifoldOfCovD", "@", "covd"}], "]"}], "[", 
           RowBox[{"{", 
            RowBox[{"a", ",", 
             RowBox[{"-", "basis"}]}], "}"}], "]"}], "]"}], "[", "expr", 
         "]"}], ",", "\[IndentingNewLine]", "True", ",", 
        "\[IndentingNewLine]", "\t", "$Failed"}], "\[IndentingNewLine]", 
       "]"}]}]}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"0cb5026d-3b26-493e-875d-573237f0a06c"],

Cell["\<\
Action of the Koszul operator on the holonomic elements of a coordinate \
chart: \
\>", "Text",ExpressionUUID->"91e6a907-c3fb-4ac5-aa7e-9601960ba769"],

Cell[BoxData[
 RowBox[{
  RowBox[{"setKoszulValue", "[", 
   RowBox[{
    RowBox[{"chart_", "?", "ChartQ"}], ",", "__"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"covd", "=", 
      RowBox[{"PDOfBasis", "[", "chart", "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"sym0", "=", 
         RowBox[{"GiveSymbol", "[", 
          RowBox[{"Koszul", ",", "covd"}], "]"}]}], ",", 
        RowBox[{"sym1", "=", 
         RowBox[{"GiveSymbol", "[", 
          RowBox[{"PD", ",", "chart"}], "]"}]}], ",", 
        RowBox[{"mani", "=", 
         RowBox[{"ManifoldOfChart", "[", "chart", "]"}]}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Outer", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Set", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"sym0", "[", 
              RowBox[{
               RowBox[{"PDFrame", "[", "mani", "]"}], "[", 
               RowBox[{"{", 
                RowBox[{"#1", ",", 
                 RowBox[{"-", "chart"}]}], "}"}], "]"}], "]"}], "@", 
             RowBox[{"Part", "[", 
              RowBox[{
               RowBox[{"ScalarsOfChart", "[", "chart", "]"}], ",", "#2"}], 
              "]"}]}], ",", 
            RowBox[{
             RowBox[{"sym1", "[", 
              RowBox[{"{", 
               RowBox[{"#1", ",", 
                RowBox[{"-", "chart"}]}], "}"}], "]"}], "[", 
             RowBox[{"Part", "[", 
              RowBox[{
               RowBox[{"ScalarsOfChart", "[", "chart", "]"}], ",", "#2"}], 
              "]"}], "]"}]}], "]"}], "&"}], ",", 
         RowBox[{"CNumbersOf", "@", "chart"}], ",", 
         RowBox[{"Range", "[", 
          RowBox[{"1", ",", 
           RowBox[{"Length", "@", 
            RowBox[{"ScalarsOfChart", "@", "chart"}]}]}], "]"}]}], "]"}], ";",
        "\[IndentingNewLine]", 
       RowBox[{"Outer", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Set", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"sym0", "[", 
              RowBox[{
               RowBox[{"GiveSymbol", "[", 
                RowBox[{"chart", ",", "#1"}], "]"}], "[", "]"}], "]"}], "@", 
             RowBox[{"Part", "[", 
              RowBox[{
               RowBox[{"ScalarsOfChart", "[", "chart", "]"}], ",", "#2"}], 
              "]"}]}], ",", 
            RowBox[{
             RowBox[{"sym1", "[", 
              RowBox[{"{", 
               RowBox[{"#1", ",", 
                RowBox[{"-", "chart"}]}], "}"}], "]"}], "[", 
             RowBox[{"Part", "[", 
              RowBox[{
               RowBox[{"ScalarsOfChart", "[", "chart", "]"}], ",", "#2"}], 
              "]"}], "]"}]}], "]"}], "&"}], ",", 
         RowBox[{"CNumbersOf", "@", "chart"}], ",", 
         RowBox[{"Range", "[", 
          RowBox[{"1", ",", 
           RowBox[{"Length", "@", 
            RowBox[{"ScalarsOfChart", "@", "chart"}]}]}], "]"}]}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 
 InitializationCell->
  True,ExpressionUUID->"4b05f8a2-49c5-42d7-a9fe-eb68c81f4cce"],

Cell["\<\
Expansion of the action of Koszul operator on frame elements:\
\>", "Text",ExpressionUUID->"48dba9cc-a9ff-4e5f-ae87-e378aedd3949"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ExpandKoszul", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"covd1_", "?", "CovDQ"}], ",", 
     RowBox[{"covd2_", "?", "CovDQ"}]}], "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"GiveSymbol", "[", 
          RowBox[{"Koszul", ",", "covd1"}], "]"}], "[", 
         RowBox[{
          RowBox[{"eFrame", "[", 
           RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "[", "a_", "]"}], 
         "]"}], "[", 
        RowBox[{
         RowBox[{"eFrame", "[", 
          RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "[", "b_", "]"}], "]"}],
        "\[RuleDelayed]", "\[IndentingNewLine]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"c", "=", 
           RowBox[{"DummyIn", "[", 
            RowBox[{"Tangent", "[", "mani", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Christoffel", "[", 
            RowBox[{"covd1", ",", "covd2"}], "]"}], "[", 
           RowBox[{"c", ",", "a", ",", "b"}], "]"}], 
          RowBox[{
           RowBox[{"eFrame", "[", "mani", "]"}], "[", 
           RowBox[{"-", "c"}], "]"}]}]}], "]"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"GiveSymbol", "[", 
          RowBox[{"Koszul", ",", "covd1"}], "]"}], "[", 
         RowBox[{
          RowBox[{"eFrame", "[", 
           RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "[", "a_", "]"}], 
         "]"}], "[", 
        RowBox[{
         RowBox[{"Coframe", "[", 
          RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "[", "b_", "]"}], "]"}],
        "\[RuleDelayed]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"c", "=", 
           RowBox[{"DummyIn", "[", 
            RowBox[{"Tangent", "[", "mani", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"Christoffel", "[", 
             RowBox[{"covd1", ",", "covd2"}], "]"}], "[", 
            RowBox[{"b", ",", "a", ",", 
             RowBox[{"-", "c"}]}], "]"}]}], 
          RowBox[{
           RowBox[{"Coframe", "[", "mani", "]"}], "[", "c", "]"}]}]}], 
        "]"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"GiveSymbol", "[", 
          RowBox[{"Koszul", ",", "covd1"}], "]"}], "[", 
         RowBox[{
          RowBox[{"PDFrame", "[", 
           RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "[", "a_", "]"}], 
         "]"}], "[", 
        RowBox[{
         RowBox[{"PDFrame", "[", 
          RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "[", "b_", "]"}], "]"}],
        "\[RuleDelayed]", "\[IndentingNewLine]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"c", "=", 
           RowBox[{"DummyIn", "[", 
            RowBox[{"Tangent", "[", "mani", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"Christoffel", "[", 
            RowBox[{"covd1", ",", "covd2"}], "]"}], "[", 
           RowBox[{"c", ",", "a", ",", "b"}], "]"}], 
          RowBox[{
           RowBox[{"PDFrame", "[", "mani", "]"}], "[", 
           RowBox[{"-", "c"}], "]"}]}]}], "]"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"GiveSymbol", "[", 
          RowBox[{"Koszul", ",", "covd1"}], "]"}], "[", 
         RowBox[{
          RowBox[{"PDFrame", "[", 
           RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "[", "a_", "]"}], 
         "]"}], "[", 
        RowBox[{
         RowBox[{"dx", "[", 
          RowBox[{"mani_", "?", "ManifoldQ"}], "]"}], "[", "b_", "]"}], "]"}],
        "\[RuleDelayed]", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"c", "=", 
           RowBox[{"DummyIn", "[", 
            RowBox[{"Tangent", "[", "mani", "]"}], "]"}]}], "}"}], ",", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{
            RowBox[{"Christoffel", "[", 
             RowBox[{"covd1", ",", "covd2"}], "]"}], "[", 
            RowBox[{"b", ",", "a", ",", 
             RowBox[{"-", "c"}]}], "]"}]}], 
          RowBox[{
           RowBox[{"dx", "[", "mani", "]"}], "[", "c", "]"}]}]}], "]"}]}]}], 
     "}"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"24cc3b36-957d-45d1-b9c1-2ca58836b2bf"],

Cell["\<\
Expansion with respect to a coordinate chart of the generalized covariant \
derivative of rank 1 tensors\
\>", "Text",ExpressionUUID->"eeacb8dc-1652-4ef9-93d1-1fcf27f72279"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandCovD", "[", 
   RowBox[{"expr_", ",", 
    RowBox[{"covd_", "?", "CovDQ"}], ",", 
    RowBox[{"chart_", "?", "ChartQ"}]}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"covdf", "=", 
       RowBox[{"GiveSymbol", "[", 
        RowBox[{"CovD", ",", "covd"}], "]"}]}], ",", 
      RowBox[{"M", "=", 
       RowBox[{"ManifoldOfChart", "[", "chart", "]"}]}], ",", 
      RowBox[{"covdk", "=", 
       RowBox[{"GiveSymbol", "[", 
        RowBox[{"Koszul", ",", "covd"}], "]"}]}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"(", 
     RowBox[{"expr", "/.", 
      RowBox[{
       RowBox[{"HoldPattern", "[", 
        RowBox[{"covdf", "[", "expr1_", "]"}], "]"}], ":>", 
       RowBox[{
        RowBox[{"Plus", "@@", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"dx", "[", "M", "]"}], "[", 
              RowBox[{"{", 
               RowBox[{"#", ",", "chart"}], "}"}], "]"}], "\[CircleTimes]", 
             RowBox[{
              RowBox[{"covdk", "[", 
               RowBox[{
                RowBox[{"PDFrame", "[", "M", "]"}], "[", 
                RowBox[{"{", 
                 RowBox[{"#", ",", 
                  RowBox[{"-", "chart"}]}], "}"}], "]"}], "]"}], "[", "expr1",
               "]"}]}], "&"}], "/@", 
           RowBox[{"CNumbersOf", "@", "chart"}]}], ")"}]}], "/;", 
        RowBox[{
         RowBox[{"Grade", "[", 
          RowBox[{"expr1", ",", "CircleTimes"}], "]"}], "===", "1"}]}]}]}], 
     ")"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"8a90413e-bb07-4b28-b00e-6ec0bea3bae9"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["3. Graded derivations", "Subsection",
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"1b1a4bb4-0913-4e38-ba69-487dc3015961"],

Cell[CellGroupData[{

Cell["3.1 Connection forms ", \
"Subsubsection",ExpressionUUID->"7afafecc-22c9-459d-9e68-a341b7ebe51c"],

Cell["\<\
There are two objects we need for covariant exterior derivatives. First, \
1-forms taking values in VB\[CircleTimes]-VB which represent the tensorial \
difference between two connections. Second, 2-forms taking values in VB\
\[CircleTimes]-VB which represent the curvature of an individual connection. \
We\[CloseCurlyQuote]ll use nonatomic heads for both of these. The notation \
will be
  ConnectionForm[CD1,CD2,VB][A,-B]
  CurvatureForm[CD,VB][A,-B]\
\>", "Text",ExpressionUUID->"367f5dd3-48e0-43a4-b01f-fd0713fbe700"],

Cell["\<\
From a mathematical point of view the connection form should not be regarded \
as the tensorial difference between two connections. The reason for this is \
that the connection form is defined as a 1-form in the frame bundle regarded \
as a differentiable manifold and in this sense it is truly tensorial. One \
loses the tensorial character when one does a splitting of the frame bundle \
into the base manifold and the fibres. For this reason we use the following \
notation for the connection form:

ConnectionForm[CD,VB][A,-B]

This notation has been implemented in this notebook.\
\>", "Text",ExpressionUUID->"74288117-bcee-443f-a78a-b37eb7d32409"],

Cell[TextData[{
 "First, making these nonatomic-head tensors. We start by the general \
connection form. ",
 StyleBox[" What happens with the MastersOf a non-atomic symbol ? Given that \
a non-atomic tensor cannot be undefined I guess that it makes no sense to ask \
about its Masters,  right ?  Also I guess that it cannot be Servant of \
anything either.",
  FontWeight->"Bold"]
}], "Text",ExpressionUUID->"36eb5e03-babe-4215-878c-d4701b541152"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "[", 
    RowBox[{"ConnectionForm", "[", 
     RowBox[{
      RowBox[{"cd_", "?", "CovDQ"}], ",", "_"}], "]"}], "]"}], "^=", "True"}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"ConnectionForm", "[", 
     RowBox[{"_", ",", 
      RowBox[{"vb_", "?", "VBundleQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"{", 
    RowBox[{"vb", ",", 
     RowBox[{"-", "vb"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ConnectionForm", "/:", 
   RowBox[{"GradeOfTensor", "[", 
    RowBox[{
     RowBox[{"ConnectionForm", "[", 
      RowBox[{"_", ",", "_"}], "]"}], ",", "Wedge"}], "]"}], "=", "1"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymmetryGroupOfTensor", "[", 
     RowBox[{"ConnectionForm", "[", 
      RowBox[{"_", ",", "_"}], "]"}], "]"}], "^=", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Dagger", "[", 
    RowBox[{"ConnectionForm", "[", 
     RowBox[{"cd1_", ",", "vb_"}], "]"}], "]"}], "^:=", 
   RowBox[{"ConnectionForm", "[", 
    RowBox[{"cd1", ",", 
     RowBox[{"Dagger", "@", "vb"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInfo", "[", 
    RowBox[{"ConnectionForm", "[", 
     RowBox[{"_", ",", "_"}], "]"}], "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{"\"\<nonsymmetric Connection 1-form\>\"", ",", "\"\<\>\""}], 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfTensor", "[", 
    RowBox[{"ConnectionForm", "[", 
     RowBox[{"cd1_", ",", "_"}], "]"}], "]"}], "^:=", 
   RowBox[{"Union", "@@", 
    RowBox[{"DependenciesOfCovD", "/@", 
     RowBox[{"{", "cd1", "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"HostsOf", "[", 
     RowBox[{"ConnectionForm", "[", 
      RowBox[{"cd1_", ",", "vb_"}], "]"}], "]"}], "^:=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "cd1", "}"}], ",", 
      RowBox[{"Union", "@@", 
       RowBox[{"HostsOf", "/@", 
        RowBox[{"{", 
         RowBox[{"cd1", ",", "vb"}], "}"}]}]}]}], "]"}]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"Should", " ", "we", " ", "put", " ", 
    RowBox[{"Union", "@@", 
     RowBox[{"HostsOf", "/@", 
      RowBox[{"{", 
       RowBox[{"cd1", ",", "vb"}], "}"}]}]}], " ", 
    RowBox[{"here", "?", " ", "Yes"}], " ", "but", " ", "we", " ", "need", " ",
     "to", " ", "add", " ", "cd1", " ", "itself"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TensorID", "[", 
     RowBox[{"ConnectionForm", "[", 
      RowBox[{"_", ",", "_"}], "]"}], "]"}], "^=", 
    RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "ConnectionForm", "]"}], "^=", "\"\<A\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"ConnectionForm", "[", 
     RowBox[{"cd1_", ",", "_"}], "]"}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"PrintAs", "[", "ConnectionForm", "]"}], "<>", "\"\<[\>\"", "<>", 
    
    RowBox[{"Last", "@", 
     RowBox[{"SymbolOfCovD", "[", "cd1", "]"}]}], "<>", "\"\<]\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"ConnectionForm", "[", 
     RowBox[{"PD", ",", "_"}], "]"}], "]"}], "^:=", 
   RowBox[{"PrintAs", "[", "ConnectionForm", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"c05270bc-f281-432f-99cc-b8c808e40ea8"],

Cell["\<\
We introduce now the ChristoffelForm (connection form for a connection in the \
frame bundle). \
\>", "Text",ExpressionUUID->"977c2d8f-3c80-493b-a946-84535fb33ec5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "[", 
    RowBox[{"ChristoffelForm", "[", 
     RowBox[{"cd1_", "?", "CovDQ"}], "]"}], "]"}], "^=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"ChristoffelForm", "[", 
     RowBox[{"cd1_", "?", "CovDQ"}], "]"}], "]"}], "^:=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Tangent", "@", 
      RowBox[{"ManifoldOfCovD", "@", "cd1"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Tangent", "@", 
       RowBox[{"ManifoldOfCovD", "@", "cd1"}]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ChristoffelForm", "/:", 
   RowBox[{"GradeOfTensor", "[", 
    RowBox[{
     RowBox[{"ChristoffelForm", "[", "_", "]"}], ",", "Wedge"}], "]"}], "=", 
   "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymmetryGroupOfTensor", "[", 
     RowBox[{"ChristoffelForm", "[", "_", "]"}], "]"}], "^=", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Dagger", "[", 
    RowBox[{"ChristoffelForm", "[", "cd1_", "]"}], "]"}], "^:=", 
   RowBox[{"ChristoffelForm", "[", "cd1", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInfo", "[", 
    RowBox[{"ChristoffelForm", "[", "_", "]"}], "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{"\"\<nonsymmetric frame bundle Connection 1-form\>\"", 
     ",", "\"\<\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfTensor", "[", 
    RowBox[{"ChristoffelForm", "[", "cd1_", "]"}], "]"}], "^:=", 
   RowBox[{"Union", "@@", 
    RowBox[{"DependenciesOfCovD", "/@", 
     RowBox[{"{", "cd1", "}"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"HostsOf", "[", 
     RowBox[{"ChristoffelForm", "[", "cd1_", "]"}], "]"}], "^:=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "cd1", "}"}], ",", 
      RowBox[{"Union", "@@", 
       RowBox[{"HostsOf", "/@", 
        RowBox[{"{", "cd1", "}"}]}]}]}], "]"}]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Should", " ", "we", " ", "put", " ", 
     RowBox[{"Union", "@@", 
      RowBox[{"HostsOf", "/@", 
       RowBox[{"{", 
        RowBox[{"cd1", ",", "cd2", ",", "vb"}], "}"}]}]}], " ", 
     RowBox[{"here", "?", " ", "Yes"}]}], ",", " ", 
    RowBox[{"but", " ", "addint", " ", "also", " ", "cd1"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TensorID", "[", 
     RowBox[{"ChristoffelForm", "[", "_", "]"}], "]"}], "^=", 
    RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "ChristoffelForm", "]"}], 
   "^=", "\"\<\[CapitalGamma]\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"PrintAs", "[", 
      RowBox[{"ChristoffelForm", "[", "cd1_", "]"}], "]"}], "/;", 
     RowBox[{
      RowBox[{"Head", "@", "cd1"}], "=!=", "CCovD"}]}], ")"}], "^:=", 
   RowBox[{
    RowBox[{"PrintAs", "[", "ChristoffelForm", "]"}], "<>", "\"\<[\>\"", "<>", 
    RowBox[{"Last", "@", 
     RowBox[{"SymbolOfCovD", "[", "cd1", "]"}]}], "<>", "\"\<]\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"ChristoffelForm", "[", "PD", "]"}], "]"}], "^:=", 
   RowBox[{"PrintAs", "[", "ChristoffelForm", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"fa3b793c-cf69-4a85-ac6d-51c906ba23d1"],

Cell["Connection form when the metric is given as a CTensor", \
"Text",ExpressionUUID->"d0df52c4-d013-4d2e-a385-53044122dcae"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ChristoffelForm", "[", "exr_CCovD", "]"}], ":=", 
   RowBox[{"Head", "@", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ind", "=", 
         RowBox[{"DummyIn", "@", 
          RowBox[{"VBundleOfBasis", "[", 
           RowBox[{"-", 
            RowBox[{"First", "@", 
             RowBox[{"Part", "[", 
              RowBox[{
               RowBox[{"Last", "@", "exr"}], ",", "2"}], "]"}]}]}], "]"}]}]}],
         ",", "a1", ",", "a2"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a1", ",", "a2"}], "}"}], "=", 
        RowBox[{"GetIndicesOfVBundle", "[", 
         RowBox[{
          RowBox[{"VBundleOfBasis", "[", 
           RowBox[{"-", 
            RowBox[{"First", "@", 
             RowBox[{"Part", "[", 
              RowBox[{
               RowBox[{"Last", "@", "exr"}], ",", "2"}], "]"}]}]}], "]"}], ",",
           "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"Part", "[", 
          RowBox[{"exr", ",", "2"}], "]"}], "[", 
         RowBox[{"a1", ",", 
          RowBox[{"-", "ind"}], ",", 
          RowBox[{"-", "a2"}]}], "]"}], " ", 
        RowBox[{
         RowBox[{"ToCTensor", "[", 
          RowBox[{
           RowBox[{"Coframe", "[", 
            RowBox[{"BaseOfVBundle", "@", 
             RowBox[{"VBundleOfBasis", "[", 
              RowBox[{"-", 
               RowBox[{"First", "@", 
                RowBox[{"Part", "[", 
                 RowBox[{
                  RowBox[{"Part", "[", 
                   RowBox[{"exr", ",", "3"}], "]"}], ",", "2"}], "]"}]}]}], 
              "]"}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"-", 
             RowBox[{"First", "@", 
              RowBox[{"Part", "[", 
               RowBox[{
                RowBox[{"Part", "[", 
                 RowBox[{"exr", ",", "3"}], "]"}], ",", "2"}], "]"}]}]}], 
            "}"}]}], "]"}], "[", "ind", "]"}]}]}]}], "\[IndentingNewLine]", 
     "]"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"dc95bc07-ea8b-475e-a1e2-6f6bcd761c81"],

Cell["\<\
Automatic replacement of the connection form by the Christoffel form when the \
connection corresponds to a connection in a frame bundle.\
\>", "Text",ExpressionUUID->"fbe26921-1ff4-422c-a2eb-906bad2ba4f9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ConnectionForm", "[", 
    RowBox[{"cd1_", ",", "vb_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"ChristoffelForm", "[", "cd1", "]"}], "/;", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Tangent", "@", 
       RowBox[{"ManifoldOfCovD", "@", "cd1"}]}], "===", "vb"}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ChristoffelForm", "[", 
    RowBox[{"cd_", ",", "tangentbundle_"}], "]"}], ":=", 
   RowBox[{"ChristoffelForm", "[", "cd", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"cbc351fc-dd66-4dac-bbed-af65419ff3cc"],

Cell["\<\
PD is regarded as a trivial connection in a principal bundle. Hence:\
\>", "Text",ExpressionUUID->"85d7b05b-8255-4d68-aad2-a413c0f78cb7"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ConnectionForm", "[", 
    RowBox[{"PD", ",", "vb_"}], "]"}], ":=", "Zero"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ChristoffelForm", "[", "PD", "]"}], ":=", "Zero"}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"3bc0252a-7e76-448a-9235-5995024fc1cd"],

Cell["\<\
Transformation of the connection form into the connection tensor plus \
co-frame.\
\>", "Text",ExpressionUUID->"ca07b492-848e-4a67-8549-1bcd4548a68c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ConnectionFormToTensor", "[", 
    RowBox[{"expr_", ",", "covd_", ",", 
     RowBox[{"frame", ":", 
      RowBox[{"(", 
       RowBox[{"Coframe", "|", "dx"}], ")"}]}]}], "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"ChristoffelForm", "[", "cd1_", "]"}], "[", 
        RowBox[{"ind1_", ",", "ind2_"}], "]"}], ":>", 
       RowBox[{
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"a", "=", 
             RowBox[{"DummyIn", "@", 
              RowBox[{"First", "@", 
               RowBox[{"VBundlesOfCovD", "@", "covd"}]}]}]}], ",", "i1", ",", 
            "i2"}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"i1", "=", 
            RowBox[{"NewIndexIn", "[", 
             RowBox[{"VBundleOfIndex", "[", "ind1", "]"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"i2", "=", 
            RowBox[{"NewIndexIn", "[", 
             RowBox[{"VBundleOfIndex", "[", "ind2", "]"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"xTensorQ", "@", 
               RowBox[{"GiveSymbol", "[", 
                RowBox[{"Christoffel", ",", "cd1", ",", "covd"}], "]"}]}], "===",
               "False"}], ",", 
             RowBox[{"DefTensor", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"GiveSymbol", "[", 
                 RowBox[{"Christoffel", ",", "cd1", ",", "covd"}], "]"}], "[", 
                RowBox[{"i1", ",", 
                 RowBox[{"-", "a"}], ",", "i2"}], "]"}], ",", 
               RowBox[{"ManifoldOfCovD", "@", "covd"}]}], "]"}]}], "]"}], ";",
            "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"GiveSymbol", "[", 
              RowBox[{"Christoffel", ",", "cd1", ",", "covd"}], "]"}], "[", 
             RowBox[{"ind1", ",", 
              RowBox[{"-", "a"}], ",", "ind2"}], "]"}], 
            RowBox[{
             RowBox[{"frame", "[", 
              RowBox[{"ManifoldOfCovD", "@", "covd"}], "]"}], "[", "a", 
             "]"}]}]}]}], "]"}], "/;", 
        RowBox[{"covd", "=!=", "PD"}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"ConnectionForm", "[", 
         RowBox[{"cd1_", ",", "vbundle_"}], "]"}], "[", 
        RowBox[{"ind1_", ",", "ind2_"}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"a", "=", 
             RowBox[{"DummyIn", "@", 
              RowBox[{"Tangent", "@", 
               RowBox[{"BaseOfVBundle", "@", "vbundle"}]}]}]}], ",", "i1", ",",
             "i2"}], "}"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"i1", "=", 
            RowBox[{"NewIndexIn", "[", 
             RowBox[{"VBundleOfIndex", "[", "ind1", "]"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"i2", "=", 
            RowBox[{"NewIndexIn", "[", 
             RowBox[{"VBundleOfIndex", "[", "ind2", "]"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"xTensorQ", "@", 
               RowBox[{"GiveSymbol", "[", 
                RowBox[{"AChristoffel", ",", "covd", ",", "cd1"}], "]"}]}], "===",
               "False"}], ",", 
             RowBox[{"DefTensor", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"GiveSymbol", "[", 
                 RowBox[{"AChristoffel", ",", "covd", ",", "cd1"}], "]"}], "[", 
                RowBox[{"i1", ",", 
                 RowBox[{"-", "a"}], ",", "i2"}], "]"}], ",", 
               RowBox[{"BaseOfVBundle", "@", "vbundle"}]}], "]"}]}], "]"}], ";",
            "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"GiveSymbol", "[", 
              RowBox[{"AChristoffel", ",", "covd", ",", "cd1"}], "]"}], "[", 
             RowBox[{"ind1", ",", 
              RowBox[{"-", "a"}], ",", "ind2"}], "]"}], 
            RowBox[{
             RowBox[{"frame", "[", 
              RowBox[{"BaseOfVBundle", "@", "vbundle"}], "]"}], "[", "a", 
             "]"}]}]}]}], "]"}], "/;", 
        RowBox[{"covd", "=!=", "PD"}]}]}]}], "}"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"df3d9247-303d-4e23-bbd0-fd057d068491"],

Cell["\<\
If the covariant derivative is PD then the code takes the following simpler \
form:\
\>", "Text",ExpressionUUID->"e62ef365-b204-4dd7-981a-07e24c6ffea6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConnectionFormToTensor", "[", 
   RowBox[{"expr_", ",", "PD", ",", 
    RowBox[{"frame", ":", 
     RowBox[{"(", 
      RowBox[{"Coframe", "|", "dx"}], ")"}]}]}], "]"}], ":=", 
  RowBox[{"expr", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"ChristoffelForm", "[", "cd1_", "]"}], "[", 
       RowBox[{"ind1_", ",", "ind2_"}], "]"}], ":>", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", "=", 
          RowBox[{"DummyIn", "@", 
           RowBox[{"First", "@", 
            RowBox[{"VBundlesOfCovD", "@", "cd1"}]}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"GiveSymbol", "[", 
           RowBox[{"Christoffel", ",", "cd1"}], "]"}], "[", 
          RowBox[{"ind1", ",", 
           RowBox[{"-", "a"}], ",", "ind2"}], "]"}], 
         RowBox[{
          RowBox[{"frame", "[", 
           RowBox[{"ManifoldOfCovD", "@", "cd1"}], "]"}], "[", "a", "]"}]}]}],
        "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"ConnectionForm", "[", 
        RowBox[{"cd1_", ",", "_"}], "]"}], "[", 
       RowBox[{"ind1_", ",", "ind2_"}], "]"}], ":>", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", "=", 
          RowBox[{"DummyIn", "@", 
           RowBox[{"First", "@", 
            RowBox[{"VBundlesOfCovD", "@", "cd1"}]}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"GiveSymbol", "[", 
           RowBox[{"AChristoffel", ",", "cd1"}], "]"}], "[", 
          RowBox[{"ind1", ",", 
           RowBox[{"-", "a"}], ",", "ind2"}], "]"}], 
         RowBox[{
          RowBox[{"frame", "[", 
           RowBox[{"ManifoldOfCovD", "@", "cd1"}], "]"}], "[", "a", "]"}]}]}],
        "]"}]}]}], "}"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"5c365bf2-703d-4637-bfd1-6396555873a5"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2 Curvature forms ", \
"Subsubsection",ExpressionUUID->"51c6b9c2-a648-430f-a383-20f84a1f720d"],

Cell["Now for the curvature form:", \
"Text",ExpressionUUID->"f08c0d87-2c7f-4956-8714-fb23de49ff07"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "[", 
    RowBox[{"CurvatureForm", "[", 
     RowBox[{"_", ",", "_"}], "]"}], "]"}], "^=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"CurvatureForm", "[", 
     RowBox[{"_", ",", 
      RowBox[{"vb_", "?", "VBundleQ"}]}], "]"}], "]"}], "^:=", 
   RowBox[{"{", 
    RowBox[{"vb", ",", 
     RowBox[{"-", "vb"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CurvatureForm", "/:", 
   RowBox[{"GradeOfTensor", "[", 
    RowBox[{
     RowBox[{"CurvatureForm", "[", 
      RowBox[{"_", ",", "_"}], "]"}], ",", "Wedge"}], "]"}], "=", "2"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymmetryGroupOfTensor", "[", 
     RowBox[{"CurvatureForm", "[", 
      RowBox[{"_", ",", "_"}], "]"}], "]"}], "^=", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Dagger", "[", 
    RowBox[{"CurvatureForm", "[", 
     RowBox[{"cd_", ",", "vb_"}], "]"}], "]"}], "^:=", 
   RowBox[{"CurvatureForm", "[", 
    RowBox[{"cd", ",", 
     RowBox[{"Dagger", "@", "vb"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInfo", "[", 
    RowBox[{"CurvatureForm", "[", 
     RowBox[{"_", ",", "_"}], "]"}], "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{"\"\<Curvature 2-form\>\"", ",", "\"\<\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfTensor", "[", 
    RowBox[{"CurvatureForm", "[", 
     RowBox[{"cd_", ",", "_"}], "]"}], "]"}], "^:=", 
   RowBox[{"DependenciesOfCovD", "[", "cd", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"HostsOf", "[", 
     RowBox[{"CurvatureForm", "[", 
      RowBox[{"cd_", ",", "vb_"}], "]"}], "]"}], "^:=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "cd", "}"}], ",", 
      RowBox[{"Union", "@@", 
       RowBox[{"HostsOf", "/@", 
        RowBox[{"{", 
         RowBox[{"cd", ",", "vb"}], "}"}]}]}]}], "]"}]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"Should", " ", "we", " ", "put", " ", 
    RowBox[{"Union", "@@", 
     RowBox[{"HostsOf", "/@", 
      RowBox[{"{", 
       RowBox[{"cd", ",", "vb"}], "}"}]}]}], " ", 
    RowBox[{"here", "?", " ", "Yes"}], " ", "but", " ", "we", " ", "need", " ",
     "to", " ", "add", " ", "cd", " ", "itself"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TensorID", "[", 
     RowBox[{"CurvatureForm", "[", 
      RowBox[{"_", ",", "_"}], "]"}], "]"}], "^=", 
    RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "CurvatureForm", "]"}], "^=", "\"\<F\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", 
    RowBox[{"CurvatureForm", "[", 
     RowBox[{"cd_", ",", "_"}], "]"}], "]"}], "^:=", 
   RowBox[{
    RowBox[{"PrintAs", "[", "CurvatureForm", "]"}], "<>", "\"\<[\>\"", "<>", 
    RowBox[{"Last", "@", 
     RowBox[{"SymbolOfCovD", "[", "cd", "]"}]}], "<>", "\"\<]\>\""}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"b51c8701-1722-401e-9213-2bf3125bf26f"],

Cell["Case of a connection in the frame bundle (RiemannForm)", \
"Text",ExpressionUUID->"72301204-b9d2-4a00-8423-efea3b0430bb"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "[", 
    RowBox[{"RiemannForm", "[", "_", "]"}], "]"}], "^=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"RiemannForm", "[", 
     RowBox[{"cd_", "?", "CovDQ"}], "]"}], "]"}], "^:=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Tangent", "@", 
      RowBox[{"ManifoldOfCovD", "@", "cd"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"Tangent", "@", 
       RowBox[{"ManifoldOfCovD", "@", "cd"}]}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RiemannForm", "/:", 
   RowBox[{"GradeOfTensor", "[", 
    RowBox[{
     RowBox[{"RiemannForm", "[", "_", "]"}], ",", "Wedge"}], "]"}], "=", 
   "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymmetryGroupOfTensor", "[", 
     RowBox[{"RiemannForm", "[", 
      RowBox[{"cd_", "?", "CovDQ"}], "]"}], "]"}], "^:=", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"MetricOfCovD", "@", "cd"}], "=!=", "Null"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Antisymmetric", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], ",", "Cycles"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"StrongGenSet", "[", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"GenSet", "[", "]"}]}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Dagger", "[", 
    RowBox[{"RiemannForm", "[", "cd_", "]"}], "]"}], "^:=", 
   RowBox[{"RiemannForm", "[", "cd", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInfo", "[", 
    RowBox[{"RiemannForm", "[", "_", "]"}], "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{"\"\<Curvature 2-form in the frame bundle\>\"", ",", "\"\<\>\""}],
     "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfTensor", "[", 
    RowBox[{"RiemannForm", "[", "cd_", "]"}], "]"}], "^:=", 
   RowBox[{"DependenciesOfCovD", "[", "cd", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"HostsOf", "[", 
     RowBox[{"RiemannForm", "[", "cd_", "]"}], "]"}], "^:=", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "cd", "}"}], ",", 
      RowBox[{"Union", "@@", 
       RowBox[{"HostsOf", "/@", 
        RowBox[{"{", "cd", "}"}]}]}]}], "]"}]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"Should", " ", "we", " ", "put", " ", 
    RowBox[{"Union", "@@", 
     RowBox[{"HostsOf", "/@", 
      RowBox[{"{", 
       RowBox[{"cd", ",", "vb"}], "}"}]}]}], " ", 
    RowBox[{"here", "?", " ", "Yes"}], " ", "but", " ", "we", " ", "need", " ",
     "to", " ", "add", " ", "cd", " ", "itself"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"TensorID", "[", 
     RowBox[{"RiemannForm", "[", "_", "]"}], "]"}], "^=", 
    RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "RiemannForm", "]"}], "^=", "\"\<R\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"PrintAs", "[", 
      RowBox[{"RiemannForm", "[", "cd_", "]"}], "]"}], "/;", 
     RowBox[{
      RowBox[{"Head", "@", "cd"}], "=!=", "CCovD"}]}], ")"}], "^:=", 
   RowBox[{
    RowBox[{"PrintAs", "[", "RiemannForm", "]"}], "<>", "\"\<[\>\"", "<>", 
    RowBox[{"Last", "@", 
     RowBox[{"SymbolOfCovD", "[", "cd", "]"}]}], "<>", "\"\<]\>\""}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"8b675470-a742-436e-9e37-c0fbc815e1ef"],

Cell["Riemann form of a CTensor expression", \
"Text",ExpressionUUID->"ea2383cf-9b4a-4c85-9db1-e20596d02b11"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RiemannForm", "[", "exr_CCovD", "]"}], ":=", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Riemann", "[", "exr", "]"}], "=!=", "Zero"}], ",", 
     RowBox[{"Head", "@", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"ind1", "=", 
           RowBox[{"DummyIn", "@", 
            RowBox[{"VBundleOfBasis", "[", 
             RowBox[{"-", 
              RowBox[{"First", "@", 
               RowBox[{"Part", "[", 
                RowBox[{
                 RowBox[{"Last", "@", "exr"}], ",", "2"}], "]"}]}]}], 
             "]"}]}]}], ",", 
          RowBox[{"ind2", "=", 
           RowBox[{"DummyIn", "@", 
            RowBox[{"VBundleOfBasis", "[", 
             RowBox[{"-", 
              RowBox[{"First", "@", 
               RowBox[{"Part", "[", 
                RowBox[{
                 RowBox[{"Last", "@", "exr"}], ",", "2"}], "]"}]}]}], 
             "]"}]}]}], ",", "a1", ",", "a2"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a1", ",", "a2"}], "}"}], "=", 
          RowBox[{"GetIndicesOfVBundle", "[", 
           RowBox[{
            RowBox[{"VBundleOfBasis", "[", 
             RowBox[{"-", 
              RowBox[{"First", "@", 
               RowBox[{"Part", "[", 
                RowBox[{
                 RowBox[{"Last", "@", "exr"}], ",", "2"}], "]"}]}]}], "]"}], ",",
             "2"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"Riemann", "[", "exr", "]"}], "[", 
           RowBox[{
            RowBox[{"-", "ind1"}], ",", 
            RowBox[{"-", "ind2"}], ",", 
            RowBox[{"-", "a1"}], ",", "a2"}], "]"}], " ", 
          RowBox[{"Wedge", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"ToCTensor", "[", 
              RowBox[{
               RowBox[{"Coframe", "[", 
                RowBox[{"BaseOfVBundle", "@", 
                 RowBox[{"VBundleOfBasis", "[", 
                  RowBox[{"-", 
                   RowBox[{"First", "@", 
                    RowBox[{"Part", "[", 
                    RowBox[{
                    RowBox[{"Part", "[", 
                    RowBox[{"exr", ",", "3"}], "]"}], ",", "2"}], "]"}]}]}], 
                  "]"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"-", 
                 RowBox[{"First", "@", 
                  RowBox[{"Part", "[", 
                   RowBox[{
                    RowBox[{"Part", "[", 
                    RowBox[{"exr", ",", "3"}], "]"}], ",", "2"}], "]"}]}]}], 
                "}"}]}], "]"}], "[", "ind1", "]"}], ",", 
            RowBox[{
             RowBox[{"ToCTensor", "[", 
              RowBox[{
               RowBox[{"Coframe", "[", 
                RowBox[{"BaseOfVBundle", "@", 
                 RowBox[{"VBundleOfBasis", "[", 
                  RowBox[{"-", 
                   RowBox[{"First", "@", 
                    RowBox[{"Part", "[", 
                    RowBox[{
                    RowBox[{"Part", "[", 
                    RowBox[{"exr", ",", "3"}], "]"}], ",", "2"}], "]"}]}]}], 
                  "]"}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"-", 
                 RowBox[{"First", "@", 
                  RowBox[{"Part", "[", 
                   RowBox[{
                    RowBox[{"Part", "[", 
                    RowBox[{"exr", ",", "3"}], "]"}], ",", "2"}], "]"}]}]}], 
                "}"}]}], "]"}], "[", "ind2", "]"}]}], "]"}]}]}]}], 
       "\[IndentingNewLine]", "]"}]}], ",", "Zero"}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"1d1abf13-b2d9-4099-9b0f-e3e558925ddd"],

Cell["\<\
Automatic replacement of the curvature form if the covariant derivative \
corresponds to a covariant derivative defined in the tangent bundle.\
\>", "Text",ExpressionUUID->"affef8de-3e52-4858-a818-f2632a8ed86d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CurvatureForm", "[", 
    RowBox[{
     RowBox[{"cd_", "?", "CovDQ"}], ",", "vbundle_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"RiemannForm", "[", "cd", "]"}], "/;", 
    RowBox[{"vbundle", "===", 
     RowBox[{"Tangent", "@", 
      RowBox[{"ManifoldOfCovD", "@", "cd"}]}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"RiemannForm", "[", 
    RowBox[{"cd_", ",", "vbundle_"}], "]"}], ":=", 
   RowBox[{"RiemannForm", "[", "cd", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"04494a9d-b508-449c-9dde-f7453cc42b9e"],

Cell["\<\
Transformation of the Curvature form into the curvature tensor plus co-frame.\
\
\>", "Text",ExpressionUUID->"08330db3-0590-44c0-ae3b-9f4949326095"],

Cell[BoxData[
 RowBox[{
  RowBox[{"CurvatureFormToTensor", "[", 
   RowBox[{"expr_", ",", 
    RowBox[{"frame", ":", 
     RowBox[{"(", 
      RowBox[{"Coframe", "|", "dx"}], ")"}]}]}], "]"}], ":=", 
  RowBox[{"expr", "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"HoldPattern", "@", 
       RowBox[{
        RowBox[{"CurvatureForm", "[", 
         RowBox[{"cd1_", ",", 
          RowBox[{"vbundle1_", "?", "VBundleQ"}]}], "]"}], "[", "inds__", 
        "]"}]}], ":>", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", "=", 
           RowBox[{"DummyIn", "@", 
            RowBox[{"First", "@", 
             RowBox[{"VBundlesOfCovD", "@", "cd1"}]}]}]}], ",", 
          RowBox[{"b", "=", 
           RowBox[{"DummyIn", "@", 
            RowBox[{"First", "@", 
             RowBox[{"VBundlesOfCovD", "@", "cd1"}]}]}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{
          RowBox[{"GiveSymbol", "[", 
           RowBox[{"FRiemann", ",", "cd1"}], "]"}], "[", 
          RowBox[{
           RowBox[{"-", "a"}], ",", 
           RowBox[{"-", "b"}], ",", 
           RowBox[{"Sequence", "@@", 
            RowBox[{"Reverse", "@", 
             RowBox[{"List", "@", "inds"}]}]}]}], "]"}], 
         RowBox[{"Wedge", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"frame", "[", 
             RowBox[{"ManifoldOfCovD", "@", "cd1"}], "]"}], "[", "a", "]"}], ",", 
           RowBox[{
            RowBox[{"frame", "[", 
             RowBox[{"ManifoldOfCovD", "@", "cd1"}], "]"}], "[", "b", "]"}]}],
           "]"}]}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"RiemannForm", "[", "cd1_", "]"}], "[", "inds__", "]"}], ":>", 
      
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", "=", 
           RowBox[{"DummyIn", "@", 
            RowBox[{"First", "@", 
             RowBox[{"VBundlesOfCovD", "@", "cd1"}]}]}]}], ",", 
          RowBox[{"b", "=", 
           RowBox[{"DummyIn", "@", 
            RowBox[{"First", "@", 
             RowBox[{"VBundlesOfCovD", "@", "cd1"}]}]}]}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"-", "$RiemannSign"}], " ", 
         RowBox[{"1", "/", "2"}], 
         RowBox[{
          RowBox[{"GiveSymbol", "[", 
           RowBox[{"Riemann", ",", "cd1"}], "]"}], "[", 
          RowBox[{
           RowBox[{"-", "a"}], ",", 
           RowBox[{"-", "b"}], ",", 
           RowBox[{"Sequence", "@@", 
            RowBox[{"Reverse", "@", 
             RowBox[{"List", "@", "inds"}]}]}]}], "]"}], 
         RowBox[{"Wedge", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"frame", "[", 
             RowBox[{"ManifoldOfCovD", "@", "cd1"}], "]"}], "[", "a", "]"}], ",", 
           RowBox[{
            RowBox[{"frame", "[", 
             RowBox[{"ManifoldOfCovD", "@", "cd1"}], "]"}], "[", "b", "]"}]}],
           "]"}]}]}], "]"}]}]}], "}"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"9d74e384-5295-4070-b2b4-b23723c4344a"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.3 The torsion 2-form", \
"Subsubsection",ExpressionUUID->"48c5bb52-7fc3-4012-b02b-79018a516edb"],

Cell["\<\
The torsion 2-form (only for covariant derivatives on the tangent bundle)\
\>", "Text",ExpressionUUID->"82e5959b-fd91-4f6b-aeed-dd02c73f871d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"xTensorQ", "[", 
    RowBox[{"TorsionForm", "[", "_", "]"}], "]"}], "^=", "True"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SlotsOfTensor", "[", 
    RowBox[{"TorsionForm", "[", "cd_", "]"}], "]"}], "^:=", 
   RowBox[{"{", 
    RowBox[{"Tangent", "@", 
     RowBox[{"ManifoldOfCovD", "@", "cd"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TorsionForm", "/:", 
   RowBox[{"GradeOfTensor", "[", 
    RowBox[{
     RowBox[{"TorsionForm", "[", "_", "]"}], ",", "Wedge"}], "]"}], "=", 
   "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SymmetryGroupOfTensor", "[", 
     RowBox[{"TorsionForm", "[", "_", "]"}], "]"}], "^=", 
    RowBox[{"StrongGenSet", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"GenSet", "[", "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Dagger", "[", 
   RowBox[{"TorsionForm", "[", "cd_", "]"}], "]"}], "^:=", 
  RowBox[{"TorsionForm", "[", "cd", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DefInfo", "[", 
    RowBox[{"TorsionForm", "[", "_", "]"}], "]"}], "^=", 
   RowBox[{"{", 
    RowBox[{"\"\<Torsion 2-form\>\"", ",", "\"\<\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"DependenciesOfTensor", "[", 
    RowBox[{"TorsionForm", "[", "cd_", "]"}], "]"}], "^:=", 
   RowBox[{"DependenciesOfCovD", "[", "cd", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"HostsOf", "[", 
     RowBox[{"TorsionForm", "[", "cd_", "]"}], "]"}], "^:=", 
    RowBox[{"HostsOf", "@", "cd"}]}], ";"}], 
  RowBox[{"(*", " ", 
   RowBox[{"Should", " ", "we", " ", "put", " ", 
    RowBox[{"HostsOf", "@", "cd"}], " ", 
    RowBox[{"here", "?", " ", "OK"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TensorID", "[", 
    RowBox[{"TorsionForm", "[", "_", "]"}], "]"}], "^=", 
   RowBox[{"{", "}"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"72571133-2c56-4127-925a-82b3be8417ce"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PrintAs", "[", "TorsionForm", "]"}], 
   "^=", "\"\<\[GothicCapitalT]\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"PrintAs", "[", 
      RowBox[{"TorsionForm", "[", "cd_", "]"}], "]"}], "/;", 
     RowBox[{
      RowBox[{"Head", "@", "cd"}], "=!=", "CCovD"}]}], ")"}], "^:=", 
   RowBox[{
    RowBox[{"PrintAs", "[", "TorsionForm", "]"}], "<>", "\"\<[\>\"", "<>", 
    RowBox[{"Last", "@", 
     RowBox[{"SymbolOfCovD", "[", "cd", "]"}]}], "<>", "\"\<]\>\""}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"b56ae101-7a3f-47e5-b812-deabf8fe30ad"],

Cell["\<\
Torsion form of a covariant derivative of a metric given as a CTensor\
\>", "Text",ExpressionUUID->"92a9b46f-b6cd-458a-b916-50b10660d12f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TorsionForm", "[", "exr_CCovD", "]"}], ":=", 
   RowBox[{"Head", "@", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ind1", "=", 
         RowBox[{"DummyIn", "@", 
          RowBox[{"VBundleOfBasis", "[", 
           RowBox[{"-", 
            RowBox[{"First", "@", 
             RowBox[{"Part", "[", 
              RowBox[{
               RowBox[{"Last", "@", "exr"}], ",", "2"}], "]"}]}]}], "]"}]}]}],
         ",", 
        RowBox[{"ind2", "=", 
         RowBox[{"DummyIn", "@", 
          RowBox[{"VBundleOfBasis", "[", 
           RowBox[{"-", 
            RowBox[{"First", "@", 
             RowBox[{"Part", "[", 
              RowBox[{
               RowBox[{"Last", "@", "exr"}], ",", "2"}], "]"}]}]}], "]"}]}]}],
         ",", "a1"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"{", "a1", "}"}], "=", 
        RowBox[{"GetIndicesOfVBundle", "[", 
         RowBox[{
          RowBox[{"VBundleOfBasis", "[", 
           RowBox[{"-", 
            RowBox[{"First", "@", 
             RowBox[{"Part", "[", 
              RowBox[{
               RowBox[{"Last", "@", "exr"}], ",", "2"}], "]"}]}]}], "]"}], ",",
           "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"Torsion", "[", "exr", "]"}], "[", 
         RowBox[{"a1", ",", 
          RowBox[{"-", "ind1"}], ",", 
          RowBox[{"-", "ind2"}]}], "]"}], " ", 
        RowBox[{
         RowBox[{
          RowBox[{"ToCTensor", "[", 
           RowBox[{
            RowBox[{"Coframe", "[", 
             RowBox[{"BaseOfVBundle", "@", 
              RowBox[{"VBundleOfBasis", "[", 
               RowBox[{"-", 
                RowBox[{"First", "@", 
                 RowBox[{"Part", "[", 
                  RowBox[{
                   RowBox[{"Part", "[", 
                    RowBox[{"exr", ",", "3"}], "]"}], ",", "2"}], "]"}]}]}], 
               "]"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"-", 
              RowBox[{"First", "@", 
               RowBox[{"Part", "[", 
                RowBox[{
                 RowBox[{"Part", "[", 
                  RowBox[{"exr", ",", "3"}], "]"}], ",", "2"}], "]"}]}]}], 
             "}"}]}], "]"}], "[", "ind1", "]"}], "\[Wedge]", 
         RowBox[{
          RowBox[{"ToCTensor", "[", 
           RowBox[{
            RowBox[{"Coframe", "[", 
             RowBox[{"BaseOfVBundle", "@", 
              RowBox[{"VBundleOfBasis", "[", 
               RowBox[{"-", 
                RowBox[{"First", "@", 
                 RowBox[{"Part", "[", 
                  RowBox[{
                   RowBox[{"Part", "[", 
                    RowBox[{"exr", ",", "3"}], "]"}], ",", "2"}], "]"}]}]}], 
               "]"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"-", 
              RowBox[{"First", "@", 
               RowBox[{"Part", "[", 
                RowBox[{
                 RowBox[{"Part", "[", 
                  RowBox[{"exr", ",", "3"}], "]"}], ",", "2"}], "]"}]}]}], 
             "}"}]}], "]"}], "[", "ind2", "]"}]}]}]}]}], 
     "\[IndentingNewLine]", "]"}]}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"62a64424-083d-4d9f-a255-22d508fa2811"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
3.4 Change of exterior covariant derivative and generalized covariant \
derivative\
\>", "Subsubsection",ExpressionUUID->"04539c52-0eca-443c-9125-bcd128f12ee7"],

Cell["\<\
We will use a convention that there should be a correspondence 
  AChr1[CD1,CD2,VB][A,-B] \[Rule] AChristoffel[CD1,CD2][A,-\[Mu],-B] \
\[Theta][\[Mu]]
  FRiem2[CD,VB][A,-B] \[Rule] 1/2 FRiemann[CD][-\[Mu],-\[Nu],-B,A] \[Theta][\
\[Mu]]\[Wedge]\[Theta][\[Nu]]          (notice different ordering of A,B on \
two sides)
  Torsion2[CD][\[Alpha]] \[Rule] 1/2 Torsion[CD][\[Alpha],-\[Beta],-\[Gamma]] \
\[Theta][\[Beta]]\[Wedge]\[Theta][\[Gamma]]
We\[CloseCurlyQuote]ll want to be able to
  1) Change from diff[form,CD1] to diff[form,CD2], introducing \
AChr1[CD1,CD2,...] as needed
  2) Compute diff[diff[form,CD],CD], introducing FRiem2[CD,...] as needed
  3) Change from FRiem2[CD1,VB] to FRiem2[CD2,VB], introducing \
diff[AChr1[CD...]] and Wedge[AChr1,AChr1]\
\>", "Text",ExpressionUUID->"961d44e9-ea51-47c8-a945-9066721fea49"],

Cell[TextData[{
 "1. Change from diff[form,CD1] to diff[form,CD2]. The formula is:\n  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["d", "CD1"], 
     SuperscriptBox["v", "A"]}], "-", 
    RowBox[{
     SuperscriptBox["d", "CD2"], 
     SuperscriptBox["v", "A"]}]}], TraditionalForm]],ExpressionUUID->
  "e7b516b9-1126-4605-a4a9-c652b1fd40d6"],
 "  = ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox[
     RowBox[{"A", "[", 
      RowBox[{"CD1", ",", "CD2", ",", "VB"}], "]"}], 
     RowBox[{"   ", "B"}], "A"], "\[Wedge]", 
    SuperscriptBox["v", "B"]}], TraditionalForm]],ExpressionUUID->
  "6e4312f0-7c83-4351-91b0-f67a36d38494"],
 "     (where VB is the VBundle of A; plus sign for +VB, minus sign for -VB)\n\
TODO: What about densities? Alfonso: I\[CloseCurlyQuote]m not sure whether \
the distinction \[OpenCurlyDoubleQuote]true tensor\[CloseCurlyDoubleQuote] / \
\[OpenCurlyDoubleQuote]tensor density\[CloseCurlyDoubleQuote] holds in this \
context."
}], "Text",ExpressionUUID->"25f029a5-e325-496c-8228-2fcb3ab2fff0"],

Cell["\<\
TODO: describe the action of the \[OpenCurlyDoubleQuote]Generalized Covariant \
derivative\[CloseCurlyDoubleQuote].\
\>", "Text",ExpressionUUID->"dd41aae4-d2d4-4b4b-b5f3-8e4fa77a7a94"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "ChangeExtD"}]], \
"Input",ExpressionUUID->"1de82f23-3d4a-4c0f-a95e-ef700fbbbebf"],

Cell[BoxData[
 StyleBox["\<\"ChangeExtD[expr,cd1,cd2] expresses the exterior covariant \
derivative taken with respect to the connection defined by the covariant \
derivative cd1 in terms of the exterior covariant derivative taken with \
respect to the connection defined by the covariant derivative cd2\"\>", 
  "MSG"]], "Print", \
"PrintUsage",ExpressionUUID->"7185b60b-53db-4550-a0fc-99352547a3a1"]
}, Open  ]],

Cell["\<\
ConnectionForm with two covariant derivatives as arguments represents the \
difference between two connection forms which carry only a covariant \
derivative in the argument.\
\>", "Text",ExpressionUUID->"a63f3c0d-4c8d-448d-9323-51348ec6f3f4"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ConnectionForm", "[", 
     RowBox[{"cd1_", ",", "cd2_", ",", "vbundle_"}], "]"}], "[", "inds__", 
    "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"ConnectionForm", "[", 
      RowBox[{"cd1", ",", "vbundle"}], "]"}], "[", "inds", "]"}], "-", 
    RowBox[{
     RowBox[{"ConnectionForm", "[", 
      RowBox[{"cd2", ",", "vbundle"}], "]"}], "[", "inds", "]"}]}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"ad531e45-b1f0-462c-ad9e-018da70f0741"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ChangeExtD", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"cd_", "?", "CovDQ"}], ",", "cd_"}], "]"}], ":=", "expr"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ChangeExtD", "[", 
     RowBox[{"expr_", ",", 
      RowBox[{"cd1_", "?", "CovDQ"}], ",", 
      RowBox[{"cd2_", ":", "PD"}]}], "]"}], ":=", 
    RowBox[{"expr", "/.", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"Diff", "[", 
        RowBox[{"expr1_", ",", "cd1"}], "]"}], "]"}], "\[RuleDelayed]", 
      "\[IndentingNewLine]", 
      RowBox[{"makeChangeExtD", "[", 
       RowBox[{
        RowBox[{"ChangeExtD", "[", 
         RowBox[{"expr1", ",", "cd1", ",", "cd2"}], "]"}], ",", "cd1", ",", 
        "cd2"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ChangeExtD", "[", 
    RowBox[{"expr_", ",", "list_List", ",", 
     RowBox[{"covd2_", ":", "PD"}]}], "]"}], ":=", 
   RowBox[{"Fold", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ChangeExtD", "[", 
       RowBox[{"#1", ",", "#2", ",", "covd2"}], "]"}], "&"}], ",", "expr", ",",
      "list"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ChangeExtD", "[", 
    RowBox[{"expr_", ",", "x_", ",", 
     RowBox[{"_", ":", "PD"}]}], "]"}], ":=", 
   RowBox[{"Throw", "@", 
    RowBox[{"Message", "[", 
     RowBox[{
      RowBox[{"ChangeExtD", "::", "unknown"}], 
      ",", "\"\<covariant derivative\>\"", ",", "x"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ChangeExtD", "[", "expr_", "]"}], ":=", 
   RowBox[{"ChangeExtD", "[", 
    RowBox[{"expr", ",", "$CovDs"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"dd0464ef-4c9c-4838-b11a-8ed6c91f8fe7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "This", " ", "only", " ", "gives", " ", "a", " ", "correct", " ", 
     "result", " ", "for", " ", "an", " ", "expression", " ", "which", " ", 
     "is", " ", "a", " ", "sum", " ", "of", " ", "simple", " ", "tensor", " ",
      "monomials"}], ",", " ", 
    RowBox[{
    "each", " ", "simple", " ", "term", " ", "being", " ", "the", " ", 
     "product", " ", "of", " ", "rank", " ", "1", " ", "basis", " ", 
     "elements"}]}], "   ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"ChangeGenCovD", "[", 
      RowBox[{"expr_", ",", 
       RowBox[{"cd_", "?", "CovDQ"}], ",", "cd_"}], "]"}], ":=", "expr"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ChangeGenCovD", "[", 
     RowBox[{"expr_", ",", 
      RowBox[{"cd1_", "?", "CovDQ"}], ",", 
      RowBox[{"cd2_", ":", "PD"}]}], "]"}], ":=", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"covdf", "=", 
        RowBox[{"GiveSymbol", "[", 
         RowBox[{"CovD", ",", "cd1"}], "]"}]}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", "epk", "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"epk", "=", 
          RowBox[{
           RowBox[{"SeparateBasis", "[", "AIndex", "]"}], "[", "expr", 
           "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"FindIndices", "[", "expr", "]"}], "\[Equal]", 
            RowBox[{"IndexList", "[", "]"}]}], ",", 
           RowBox[{"Return", "[", "expr", "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"epk", "/.", 
          RowBox[{
           RowBox[{"HoldPattern", "[", 
            RowBox[{"covdf", "[", "expr1_", "]"}], "]"}], "\[RuleDelayed]", 
           "\[IndentingNewLine]", 
           RowBox[{"makeChangeCovD", "[", 
            RowBox[{"expr1", ",", "cd1", ",", "cd2"}], "]"}]}]}]}]}], 
       "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChangeGenCovD", "[", 
      RowBox[{"expr_", ",", "list_List", ",", 
       RowBox[{"covd2_", ":", "PD"}]}], "]"}], ":=", 
     RowBox[{"Fold", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ChangeGenCovD", "[", 
         RowBox[{"#1", ",", "#2", ",", "covd2"}], "]"}], "&"}], ",", "expr", ",",
        "list"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChangeGenCovD", "[", 
      RowBox[{"expr_", ",", "x_", ",", 
       RowBox[{"_", ":", "PD"}]}], "]"}], ":=", 
     RowBox[{"Throw", "@", 
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"ChangeGenCovD", "::", "unknown"}], 
        ",", "\"\<covariant derivative\>\"", ",", "x"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ChangeGenCovD", "[", "expr_", "]"}], ":=", 
     RowBox[{"ChangeGenCovD", "[", 
      RowBox[{"expr", ",", "$CovDs"}], "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d6d11b65-4202-4ce4-a60c-b55a88267373"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeChangeExtD", "[", 
    RowBox[{"expr_", ",", "cd1_", ",", "cd2_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"vbs", "=", 
       RowBox[{"Apply", "[", 
        RowBox[{"Union", ",", 
         RowBox[{"VBundlesOfCovD", "/@", 
          RowBox[{"DeleteCases", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"cd1", ",", "cd2"}], "}"}], ",", "PD"}], "]"}]}]}], 
        "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Diff", "[", 
        RowBox[{"expr", ",", "cd2"}], "]"}], "+", 
       RowBox[{"Plus", "@@", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{"addAChr1", "[", 
           RowBox[{"expr", ",", "cd1", ",", "cd2"}], "]"}], ",", 
          RowBox[{"xAct`xTensor`Private`selecton", "[", 
           RowBox[{
            RowBox[{"Select", "[", 
             RowBox[{
              RowBox[{"FindFreeIndices", "@", "expr"}], ",", "GIndexQ"}], 
             "]"}], ",", "vbs"}], "]"}]}], "]"}]}]}], "//", "ReduceAChr1"}]}],
     "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c6648233-ac19-408e-b335-a335270e6708"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"makeChangeCovD", "[", 
    RowBox[{"expr_", ",", "cd1_", ",", "cd2_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"vbs", "=", 
        RowBox[{"Apply", "[", 
         RowBox[{"Union", ",", 
          RowBox[{"VBundlesOfCovD", "/@", 
           RowBox[{"DeleteCases", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"cd1", ",", "cd2"}], "}"}], ",", "PD"}], "]"}]}]}], 
         "]"}]}], ",", 
       RowBox[{"covd2", "=", 
        RowBox[{"GiveSymbol", "[", 
         RowBox[{"CovD", ",", "cd2"}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"covd2", "[", "expr", "]"}], "+", 
       RowBox[{"Plus", "@@", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{"addAChr2", "[", 
           RowBox[{"expr", ",", "cd1", ",", "cd2"}], "]"}], ",", 
          RowBox[{"xAct`xTensor`Private`selecton", "[", 
           RowBox[{
            RowBox[{"Select", "[", 
             RowBox[{
              RowBox[{"IndexList", "@@", 
               RowBox[{"DeleteCases", "[", 
                RowBox[{
                 RowBox[{"List", "@@", 
                  RowBox[{"FindIndices", "@", "expr"}]}], ",", 
                 RowBox[{"Alternatives", "@@", 
                  RowBox[{"List", "@", 
                   RowBox[{"FindDummyIndices", "@", "expr"}]}]}]}], "]"}]}], ",",
               "GIndexQ"}], "]"}], ",", "vbs"}], "]"}]}], "]"}]}]}], "//", 
      "ReduceAChr1"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"90944bdb-6fa3-49ee-9451-44d00927f28b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"addAChr1", "[", 
    RowBox[{"expr_", ",", "cd1_", ",", "cd2_"}], "]"}], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"oldind_", "?", "xAct`xTensor`Private`upQ"}], ",", "dummy_"}], 
    "}"}], "]"}], ":=", 
  RowBox[{"Wedge", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ConnectionForm", "[", 
      RowBox[{"cd1", ",", "cd2", ",", 
       RowBox[{"VBundleOfIndex", "@", "oldind"}]}], "]"}], "[", 
     RowBox[{"oldind", ",", 
      RowBox[{"-", "dummy"}]}], "]"}], ",", 
    RowBox[{"ReplaceIndex", "[", 
     RowBox[{"expr", ",", 
      RowBox[{"oldind", "\[Rule]", "dummy"}]}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"addAChr1", "[", 
    RowBox[{"expr_", ",", "cd1_", ",", "cd2_"}], "]"}], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"oldind_", "?", "xAct`xTensor`Private`downQ"}], ",", "dummy_"}], 
    "}"}], "]"}], ":=", 
  RowBox[{"-", 
   RowBox[{"Wedge", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ConnectionForm", "[", 
       RowBox[{"cd1", ",", "cd2", ",", 
        RowBox[{"VBundleOfIndex", "@", "oldind"}]}], "]"}], "[", 
      RowBox[{"dummy", ",", "oldind"}], "]"}], ",", 
     RowBox[{"ReplaceIndex", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"oldind", "\[Rule]", 
        RowBox[{"-", "dummy"}]}]}], "]"}]}], "]"}]}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"1a778d4c-bbdc-400a-91b2-f35b304c95cd"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"addAChr2", "[", 
    RowBox[{"expr_", ",", "cd1_", ",", "cd2_"}], "]"}], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"oldind_", "?", "xAct`xTensor`Private`upQ"}], ",", "dummy_"}], 
    "}"}], "]"}], ":=", 
  RowBox[{"-", 
   RowBox[{"CircleTimes", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ConnectionForm", "[", 
       RowBox[{"cd1", ",", "cd2", ",", 
        RowBox[{"VBundleOfIndex", "@", "oldind"}]}], "]"}], "[", 
      RowBox[{"oldind", ",", 
       RowBox[{"-", "dummy"}]}], "]"}], ",", 
     RowBox[{"ReplaceIndex", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"oldind", "\[Rule]", "dummy"}]}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"addAChr2", "[", 
    RowBox[{"expr_", ",", "cd1_", ",", "cd2_"}], "]"}], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"oldind_", "?", "xAct`xTensor`Private`downQ"}], ",", "dummy_"}], 
    "}"}], "]"}], ":=", 
  RowBox[{"CircleTimes", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"ConnectionForm", "[", 
      RowBox[{"cd1", ",", "cd2", ",", 
       RowBox[{"VBundleOfIndex", "@", "oldind"}]}], "]"}], "[", 
     RowBox[{"dummy", ",", "oldind"}], "]"}], ",", 
    RowBox[{"ReplaceIndex", "[", 
     RowBox[{"expr", ",", 
      RowBox[{"oldind", "\[Rule]", 
       RowBox[{"-", "dummy"}]}]}], "]"}]}], "]"}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"48d9420a-9cb1-40e0-9495-cd54d00e8632"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChangeGenCovD", "[", "%", 
  "]"}]], "Input",ExpressionUUID->"6a23bca9-036d-438f-b3be-61168f5c713e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"d", "[", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"T", 
           StyleBox[GridBox[{
              {" ", " "},
              {"a", "b"}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->Rational[39, 4]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`T[-$CellContext`a, -$CellContext`b],
       Editable->False], "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Diff[
     $CellContext`T[-$CellContext`a, -$CellContext`b], xAct`xTensor`PD],
    Editable->False], "\[CircleTimes]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"a"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
    Editable->False], "\[CircleTimes]", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[Theta]", 
        StyleBox[GridBox[{
           {"b"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"T", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->Rational[39, 4]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`T[-$CellContext`a, -$CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"xAct`xTerior`Private`addAChr2", "[", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Theta]", 
              StyleBox[GridBox[{
                 {"a"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->Rational[39, 4]]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
          Editable->False], "\[CircleTimes]", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Theta]", 
              StyleBox[GridBox[{
                 {"b"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->Rational[39, 4]]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
          Editable->False]}], ",", "CD", ",", "PD"}], "]"}], "[", 
      InterpretationBox[
       StyleBox[
        RowBox[{"\[PartialD]", "[", 
         RowBox[{
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[Theta]", 
               StyleBox[GridBox[{
                  {"a"},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->Rational[39, 4]]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
           Editable->False], "\[CircleTimes]", 
          InterpretationBox[
           StyleBox[GridBox[{
              {"\[Theta]", 
               StyleBox[GridBox[{
                  {"b"},
                  {" "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->Rational[39, 4]]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
           Editable->False]}], "]"}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CovDPD[
        CircleTimes[
         xAct`xTerior`Coframe[$CellContext`M][$CellContext`a], 
         xAct`xTerior`Coframe[$CellContext`M][$CellContext`b]], 
        xAct`xTensor`PD],
       Editable->False], "]"}], "+", 
     RowBox[{
      RowBox[{"xAct`xTerior`Private`addAChr2", "[", 
       RowBox[{
        RowBox[{
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Theta]", 
              StyleBox[GridBox[{
                 {"a"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->Rational[39, 4]]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`Coframe[$CellContext`M][$CellContext`a],
          Editable->False], "\[CircleTimes]", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"\[Theta]", 
              StyleBox[GridBox[{
                 {"b"},
                 {" "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->Rational[39, 4]]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          xAct`xTerior`Coframe[$CellContext`M][$CellContext`b],
          Editable->False]}], ",", "CD", ",", "PD"}], "]"}], "[", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         StyleBox["{",
          FontColor->RGBColor[0, 0, 1]], 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"a", ",", "p$2642"}], "}"}], ",", "\[ThinSpace]", 
          RowBox[{"{", 
           RowBox[{"b", ",", "p$2643"}], "}"}]}], 
         StyleBox["}",
          FontColor->RGBColor[0, 0, 1]]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`xTensor`IndexList[{$CellContext`a, $CellContext`p$2642}, \
{$CellContext`b, $CellContext`p$2643}],
       Editable->False], "]"}]}], 
    ")"}]}]}]], \
"Output",ExpressionUUID->"e80a56d6-c739-42e1-94da-3fafcef90fa9"]
}, Open  ]],

Cell[TextData[{
 "Note that\n  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["d", "CD1"], 
     SuperscriptBox["v", "A"]}], "-", 
    RowBox[{
     SuperscriptBox["d", "CD2"], 
     SuperscriptBox["v", "A"]}]}], TraditionalForm]],ExpressionUUID->
  "34c36511-9b0d-48bb-954e-74a0f09b7dc6"],
 "  = ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["d", "CD1"], 
      SuperscriptBox["v", "A"]}], "-", 
     RowBox[{"d", " ", 
      SuperscriptBox["v", "A"]}], "+", 
     RowBox[{"d", " ", 
      SuperscriptBox["v", "A"]}], "-", " ", 
     RowBox[{
      SuperscriptBox["d", "CD2"], 
      SuperscriptBox["v", "A"]}]}], "=", 
    RowBox[{
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        RowBox[{"A", "[", 
         RowBox[{"CD1", ",", "PD", ",", "VB"}], "]"}], 
        RowBox[{"   ", "B"}], "A"], "\[Wedge]", 
       SuperscriptBox["v", "B"]}],
      TraditionalForm], "+", 
     FormBox[
      RowBox[{
       SubsuperscriptBox[
        RowBox[{"A", "[", 
         RowBox[{"PD", ",", "CD2", ",", "VB"}], "]"}], 
        RowBox[{"   ", "B"}], "A"], "\[Wedge]", 
       SuperscriptBox["v", "B"]}],
      TraditionalForm]}]}], TraditionalForm]],ExpressionUUID->
  "2cfdf617-01a9-4e39-95ae-dd340f148bb9"],
 "\nand so\n  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox[
     RowBox[{"A", "[", 
      RowBox[{"CD1", ",", "CD2", ",", "VB"}], "]"}], 
     RowBox[{"   ", "B"}], "A"], "=", 
    RowBox[{
     SubsuperscriptBox[
      RowBox[{"A", "[", 
       RowBox[{"CD1", ",", "PD", ",", "VB"}], "]"}], 
      RowBox[{"   ", "B"}], "A"], "+", 
     SubsuperscriptBox[
      RowBox[{"A", "[", 
       RowBox[{"PD", ",", "CD2", ",", "VB"}], "]"}], 
      RowBox[{"   ", "B"}], "A"]}]}], TraditionalForm]],ExpressionUUID->
  "3a71ec5f-68ea-4e85-a255-e4f4b1a1b454"],
 ".\nNow ",
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox[
    RowBox[{"A", "[", 
     RowBox[{"CD", ",", "PD", ",", "VB"}], "]"}], 
    RowBox[{"   ", "B"}], "A"], TraditionalForm]],ExpressionUUID->
  "72d4ea50-ba78-43ad-a0ab-e579f38003e4"],
 "=0  iff FreeQ[VBundlesOfCovD[CD],VB]. This allows the simplification of \
A[CD1,CD2,VB] when only one of {CD1,CD2} has VB in VBundlesOfCovD."
}], "Text",ExpressionUUID->"a1405560-7c0b-43e1-b8d0-5a0e1a2b3dfa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReduceAChr1", "[", "expr_", "]"}], ":=", 
  RowBox[{"expr", "//.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"ConnectionForm", "[", 
        RowBox[{"cd1_", ",", "cd2_", ",", "vb_"}], "]"}], "[", 
       RowBox[{"a_", ",", "b_"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{
        RowBox[{"ConnectionForm", "[", 
         RowBox[{"cd1", ",", "PD", ",", "vb"}], "]"}], "[", 
        RowBox[{"a", ",", "b"}], "]"}], "/;", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"cd2", "=!=", "PD"}], "&&", 
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{"VBundlesOfCovD", "@", "cd2"}], ",", "vb"}], "]"}]}], 
        ")"}]}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"ConnectionForm", "[", 
        RowBox[{"cd1_", ",", "cd2_", ",", "vb_"}], "]"}], "[", 
       RowBox[{"a_", ",", "b_"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{
        RowBox[{"ConnectionForm", "[", 
         RowBox[{"PD", ",", "cd2", ",", "vb"}], "]"}], "[", 
        RowBox[{"a", ",", "b"}], "]"}], "/;", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"cd1", "=!=", "PD"}], "&&", 
         RowBox[{"FreeQ", "[", 
          RowBox[{
           RowBox[{"VBundlesOfCovD", "@", "cd1"}], ",", "vb"}], "]"}]}], 
        ")"}]}]}]}], "}"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"564d56c6-7cde-4348-9b98-de653a1a3881"],

Cell[TextData[{
 "2. Compute diff[diff[form,CD],CD], introducing FRiem2[CD,...] as needed. \
The formula:\n",
 "  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["d", "\[Del]"], 
     SuperscriptBox["d", "\[Del]"], 
     SuperscriptBox["v", "A"]}], " ", "=", " ", 
    RowBox[{
     SubsuperscriptBox[
      RowBox[{"F", "[", 
       RowBox[{"\[Del]", 
        RowBox[{",", "VB"}]}], "]"}], 
      RowBox[{"   ", "B"}], "A"], "\[Wedge]", 
     SuperscriptBox["v", "B"]}]}], TraditionalForm]],ExpressionUUID->
  "ff761cfc-1de0-4bcc-9fda-0538cbdc5d3a"],
 "             (where VB is the VBundle of A; plus sign for +VB, minus sign \
for -VB)"
}], "Text",ExpressionUUID->"17b0d125-f147-4b9d-a5be-deefaa14175c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Diff", "[", 
   RowBox[{
    RowBox[{"Diff", "[", 
     RowBox[{"expr_", ",", "PD"}], "]"}], ",", "PD"}], "]"}], ":=", 
  "0"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3b3ea436-06b3-4cf9-b9ec-dfc748aa3ac9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HoldPattern", "@", 
    RowBox[{"Diff", "[", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"Diff", "[", 
        RowBox[{"expr_", ",", "cd_"}], "]"}], "]"}], ",", "cd_"}], "]"}]}], ":=",
    "\[IndentingNewLine]", 
   RowBox[{"Plus", "@@", 
    RowBox[{"Map", "[", 
     RowBox[{
      RowBox[{"addFRiem2", "[", 
       RowBox[{"expr", ",", "cd"}], "]"}], ",", 
      RowBox[{"xAct`xTensor`Private`selecton", "[", 
       RowBox[{
        RowBox[{"Select", "[", 
         RowBox[{
          RowBox[{"FindFreeIndices", "@", "expr"}], ",", "AIndexQ"}], "]"}], ",", 
        RowBox[{"VBundlesOfCovD", "@", "cd"}]}], "]"}]}], "]"}]}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"7eca7d42-3f6c-4401-a129-9bd616ad6b7e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"addFRiem2", "[", 
      RowBox[{"expr_", ",", "cd_"}], "]"}], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"oldind_", "?", "xAct`xTensor`Private`upQ"}], ",", "dummy_"}], 
      "}"}], "]"}], ":=", 
    RowBox[{"Wedge", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"CurvatureForm", "[", 
        RowBox[{"cd", ",", 
         RowBox[{"VBundleOfIndex", "[", "oldind", "]"}]}], "]"}], "[", 
       RowBox[{"oldind", ",", 
        RowBox[{"-", "dummy"}]}], "]"}], ",", 
      RowBox[{"ReplaceIndex", "[", 
       RowBox[{"expr", ",", 
        RowBox[{"oldind", "\[Rule]", "dummy"}]}], "]"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"addFRiem2", "[", 
    RowBox[{"expr_", ",", "cd_"}], "]"}], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"oldind_", "?", "xAct`xTensor`Private`downQ"}], ",", "dummy_"}], 
    "}"}], "]"}], ":=", 
  RowBox[{"-", 
   RowBox[{"Wedge", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"CurvatureForm", "[", 
       RowBox[{"cd", ",", 
        RowBox[{"VBundleOfIndex", "[", "oldind", "]"}]}], "]"}], "[", 
      RowBox[{"dummy", ",", "oldind"}], "]"}], ",", 
     RowBox[{"ReplaceIndex", "[", 
      RowBox[{"expr", ",", 
       RowBox[{"oldind", "\[Rule]", 
        RowBox[{"-", "dummy"}]}]}], "]"}]}], "]"}]}]}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"894bc8e8-2bb3-4b69-b6c5-6a4e086cc34b"],

Cell["Just in case, add the following definitions:", \
"Text",ExpressionUUID->"559bbd97-c1ed-4779-8643-abc655031c46"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CurvatureForm", "[", 
    RowBox[{"PD", ",", "_"}], "]"}], ":=", "Zero"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"0f74eacf-9920-4b30-a681-af40669ff3a6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"RiemannForm", "[", "PD", "]"}], ":=", "Zero"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"f6d388b3-10fe-4aa1-b590-f02514767d4b"],

Cell[TextData[{
 "3. Change from FRiem2[CD1,VB] to FRiem2[CD2,VB],  introducing \
diff[AChr1[CD...]] and Wedge[AChr1,AChr1]. The formula:\n  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox[
     RowBox[{"F", "[", 
      RowBox[{"CD2", ",", "VB"}], "]"}], 
     RowBox[{"   ", "B"}], "A"], "=", 
    RowBox[{
     SubsuperscriptBox[
      RowBox[{"F", "[", 
       RowBox[{"CD1", ",", "VB"}], "]"}], 
      RowBox[{"   ", "B"}], "A"], " ", "+", " ", 
     RowBox[{
      SuperscriptBox["d", "CD1"], 
      SubsuperscriptBox[
       RowBox[{"A", "[", 
        RowBox[{"CD2", ",", "CD1", ",", "VB"}], "]"}], 
       RowBox[{"    ", "B"}], "A"]}], "+", 
     RowBox[{
      SubsuperscriptBox[
       RowBox[{"A", "[", 
        RowBox[{"CD2", ",", "CD1", ",", "VB"}], "]"}], 
       RowBox[{"    ", "C"}], "A"], "\[Wedge]", 
      SubsuperscriptBox[
       RowBox[{"A", "[", 
        RowBox[{"CD2", ",", "CD1", ",", "VB"}], "]"}], 
       RowBox[{"    ", "B"}], "C"]}]}]}], TraditionalForm]],ExpressionUUID->
  "31829c6a-3201-4fb1-9d11-de08d75a85e4"]
}], "Text",ExpressionUUID->"1ec6de7d-7637-46a2-9146-17063a4b28b8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ChangeCurvatureForm", "[", 
    RowBox[{"expr_", ",", "cd_", ",", "cd_"}], "]"}], ":=", "expr"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ChangeCurvatureForm", "[", 
    RowBox[{"expr_", ",", 
     RowBox[{"cd1_", "?", "CurvatureQ"}], ",", 
     RowBox[{"cd2_", ":", "PD"}]}], "]"}], ":=", 
   RowBox[{"ReduceAChr1", "[", 
    RowBox[{"expr", "/.", 
     RowBox[{"changeCurvatureFormRules", "[", 
      RowBox[{"cd1", ",", "cd2"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ChangeCurvatureForm", "[", 
    RowBox[{"expr_", ",", "list_List", ",", 
     RowBox[{"cd2_", ":", "PD"}]}], "]"}], ":=", 
   RowBox[{"Fold", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ChangeCurvatureForm", "[", 
       RowBox[{"#1", ",", "#2", ",", "cd2"}], "]"}], "&"}], ",", "expr", ",", 
     "list"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ChangeCurvatureForm", "[", 
    RowBox[{"expr_", ",", "_", ",", 
     RowBox[{"_", ":", "PD"}]}], "]"}], ":=", "expr"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ChangeCurvatureForm", "[", "expr_", "]"}], ":=", 
   RowBox[{"ChangeCurvatureForm", "[", 
    RowBox[{"expr", ",", "$CovDs"}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"7054b4d4-104a-4859-8e7b-88315762938b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"changeCurvatureFormRules", "[", 
    RowBox[{"cd2_", ",", "cd1_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"CurvatureForm", "[", 
        RowBox[{"cd2", ",", 
         RowBox[{"vb_", "?", "VBundleQ"}]}], "]"}], "[", 
       RowBox[{"a_", ",", "b_"}], "]"}], "\[RuleDelayed]", 
      "\[IndentingNewLine]", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"c", "=", 
           RowBox[{"DummyIn", "@", "vb"}]}], ",", 
          RowBox[{"A1", "=", 
           RowBox[{"ConnectionForm", "[", 
            RowBox[{"cd2", ",", "cd1", ",", "vb"}], "]"}]}]}], "}"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"CurvatureForm", "[", 
           RowBox[{"cd1", ",", "vb"}], "]"}], "[", 
          RowBox[{"a", ",", "b"}], "]"}], "+", 
         RowBox[{"Diff", "[", 
          RowBox[{
           RowBox[{"A1", "[", 
            RowBox[{"a", ",", "b"}], "]"}], ",", "cd1"}], "]"}], "+", 
         RowBox[{"Wedge", "[", 
          RowBox[{
           RowBox[{"A1", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "c"}]}], "]"}], ",", 
           RowBox[{"A1", "[", 
            RowBox[{"c", ",", "b"}], "]"}]}], "]"}]}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"RiemannForm", "[", "cd2", "]"}], "[", 
       RowBox[{"a_", ",", "b_"}], "]"}], "\[RuleDelayed]", 
      "\[IndentingNewLine]", 
      RowBox[{"With", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"c", "=", 
           RowBox[{"DummyIn", "@", 
            RowBox[{"Tangent", "@", 
             RowBox[{"ManifoldOfCovD", "@", "cd2"}]}]}]}], ",", 
          RowBox[{"A1", "=", 
           RowBox[{"ChristoffelForm", "[", 
            RowBox[{"cd2", ",", "cd1"}], "]"}]}]}], "}"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"RiemannForm", "[", "cd1", "]"}], "[", 
          RowBox[{"a", ",", "b"}], "]"}], "+", 
         RowBox[{"Diff", "[", 
          RowBox[{
           RowBox[{"A1", "[", 
            RowBox[{"a", ",", "b"}], "]"}], ",", "cd1"}], "]"}], "+", 
         RowBox[{"Wedge", "[", 
          RowBox[{
           RowBox[{"A1", "[", 
            RowBox[{"a", ",", 
             RowBox[{"-", "c"}]}], "]"}], ",", 
           RowBox[{"A1", "[", 
            RowBox[{"c", ",", "b"}], "]"}]}], "]"}]}]}], "]"}]}]}], "}"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"9dd01afa-171f-4551-a4be-05c7ae13f0d0"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.5 UseCartan", \
"Subsubsection",ExpressionUUID->"609b33fb-72c0-4106-9f34-dd3211fcd332"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "UseCartan"}]], \
"Input",ExpressionUUID->"d41767f1-9f3c-4c46-815f-e94414757c11"],

Cell[BoxData[
 StyleBox["\<\"UseCartan[expr,covd] expands all the instances of the Diff \
using the Cartan structure equations for the connection arising from covd. In \
this way it is possible to expand the exterior derivative of a co-frame, a \
torsion 2-form and the curvature 2-form. If covd is the Levi-Civita \
connection of a metric, then the exterior derivatives of that metric and its \
volume element are expanded too. UseCartan[expr,PD] expands all instances of \
the exterior derivative in terms of partial derivatives defined in the list \
of manifolds returned by ManifoldsOf[expr]. It is possible to specify a \
custom list of manifolds as a third argument in the form \
UseCartan[expr,PD,{M1,M2,..}]\"\>", 
  "MSG"]], "Print", \
"PrintUsage",ExpressionUUID->"428082de-b86e-4ac3-9688-9d11a38ef83b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Thread", " ", "over", " ", "equations", " ", "and", " ", "lists"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"UseCartan", "[", 
      RowBox[{"expr_List", ",", "covd_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"UseCartan", "[", 
        RowBox[{"#", ",", "covd"}], "]"}], "&"}], "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UseCartan", "[", 
      RowBox[{"expr_List", ",", "PD", ",", 
       RowBox[{"{", 
        RowBox[{"mani__", "?", "ManifoldQ"}], "}"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"UseCartan", "[", 
        RowBox[{"#", ",", "PD", ",", 
         RowBox[{"{", "mani", "}"}]}], "]"}], "&"}], "/@", "expr"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UseCartan", "[", 
      RowBox[{"expr_Equal", ",", "covd_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"UseCartan", "[", 
        RowBox[{"#", ",", "covd"}], "]"}], "&"}], "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UseCartan", "[", 
      RowBox[{"expr_Equal", ",", "PD", ",", 
       RowBox[{"{", 
        RowBox[{"mani__", "?", "ManifoldQ"}], "}"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"UseCartan", "[", 
        RowBox[{"#", ",", "PD", ",", 
         RowBox[{"{", "mani", "}"}]}], "]"}], "&"}], "/@", "expr"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"48dcb3af-218e-4c19-9fd3-1b82ffe2241f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Exterior", " ", "derivative", " ", "when", " ", "covd", " ", "is", " ", 
    "PD"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"UseCartan", "[", 
      RowBox[{"expr_", ",", "PD", ",", 
       RowBox[{"{", 
        RowBox[{"mani__", "?", "ManifoldQ"}], "}"}]}], "]"}], ":=", 
     RowBox[{"(", 
      RowBox[{"expr", "/.", 
       RowBox[{
        RowBox[{"Diff", "@", "expr1_"}], ":>", 
        RowBox[{
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"a", "=", 
             RowBox[{"DummyIn", "/@", 
              RowBox[{"(", 
               RowBox[{"Tangent", "/@", 
                RowBox[{"{", "mani", "}"}]}], ")"}]}]}], "}"}], ",", 
           RowBox[{"Inner", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"dx", "[", "#1", "]"}], "[", "#2", "]"}], 
               RowBox[{
                RowBox[{"PD", "[", 
                 RowBox[{"-", "#2"}], "]"}], "@", "expr1"}]}], "&"}], ",", 
             RowBox[{"{", "mani", "}"}], ",", "a", ",", "Plus"}], "]"}]}], 
          "]"}], "/;", 
         RowBox[{
          RowBox[{"Deg", "@", "expr1"}], "===", "0"}]}]}]}], ")"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"UseCartan", "[", 
      RowBox[{"expr_", ",", "PD"}], "]"}], ":=", 
     RowBox[{"(", 
      RowBox[{"expr", "/.", 
       RowBox[{
        RowBox[{"Diff", "@", "expr1_"}], ":>", 
        RowBox[{
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"a", "=", 
             RowBox[{"DummyIn", "/@", 
              RowBox[{"(", 
               RowBox[{"Tangent", "/@", 
                RowBox[{"ManifoldsOf", "@", "expr"}]}], ")"}]}]}], "}"}], ",", 
           RowBox[{"Inner", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"dx", "[", "#1", "]"}], "[", "#2", "]"}], 
               RowBox[{
                RowBox[{"PD", "[", 
                 RowBox[{"-", "#2"}], "]"}], "@", "expr1"}]}], "&"}], ",", 
             RowBox[{"ManifoldsOf", "@", "expr"}], ",", "a", ",", "Plus"}], 
            "]"}]}], "]"}], "/;", 
         RowBox[{
          RowBox[{"Deg", "@", "expr1"}], "===", "0"}]}]}]}], ")"}]}], 
    ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"ef415052-a06a-4b49-8f1d-4d9030873643"],

Cell["\<\
We encode the Cartan equations in a set of rules. We also encode the action \
of the exterior derivative on a function whose arguments are scalars of a \
coordinate chart.\
\>", "Text",ExpressionUUID->"96f1a254-5f41-4232-8bff-358a9892a583"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UseCartan", "[", 
    RowBox[{"expr_", ",", "covd_"}], "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"metric", "=", 
        RowBox[{"MetricOfCovD", "[", "covd", "]"}]}], ",", 
       RowBox[{"basis", "=", 
        RowBox[{"BasisOfCovD", "[", "covd", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"expr", "/.", 
      RowBox[{"Flatten", "@", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{
        "Exterior", " ", "derivative", " ", "of", " ", "the", " ", 
         "coframe"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"HoldPattern", "[", 
           RowBox[{"Diff", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Coframe", "[", "mani_", "]"}], "[", 
              RowBox[{"ind_", "?", "UpIndexQ"}], "]"}], ",", "PD"}], "]"}], 
           "]"}], "\[RuleDelayed]", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"a", "=", 
              RowBox[{"DummyIn", "@", 
               RowBox[{"VBundleOfIndex", "@", "ind"}]}]}], "}"}], ",", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"TorsionQ", "@", "covd"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 RowBox[{
                  RowBox[{"ConnectionForm", "[", 
                   RowBox[{"covd", ",", 
                    RowBox[{"VBundleOfIndex", "@", "ind"}]}], "]"}], "[", 
                  RowBox[{"ind", ",", 
                   RowBox[{"-", "a"}]}], "]"}]}], "\[Wedge]", 
                RowBox[{
                 RowBox[{"Coframe", "[", "mani", "]"}], "[", "a", "]"}]}], "+", 
               RowBox[{
                RowBox[{"TorsionForm", "[", "covd", "]"}], "[", "ind", 
                "]"}]}], ",", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{
                 RowBox[{"ConnectionForm", "[", 
                  RowBox[{"covd", ",", 
                   RowBox[{"VBundleOfIndex", "@", "ind"}]}], "]"}], "[", 
                 RowBox[{"ind", ",", 
                  RowBox[{"-", "a"}]}], "]"}]}], "\[Wedge]", 
               RowBox[{
                RowBox[{"Coframe", "[", "mani", "]"}], "[", "a", "]"}]}]}], 
             "]"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Exterior", " ", "derivative", " ", "of", " ", "the", " ", 
           "connection"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"HoldPattern", "[", 
           RowBox[{"Diff", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"connection", ":", 
                 RowBox[{"(", 
                  RowBox[{"ConnectionForm", "|", "ChristoffelForm"}], ")"}]}],
                 ")"}], "[", 
               RowBox[{"covd", ",", 
                RowBox[{"vbundle_", ":", 
                 RowBox[{"Tangent", "@", 
                  RowBox[{"ManifoldOfCovD", "@", "covd"}]}]}]}], "]"}], "[", 
              RowBox[{
               RowBox[{"a1_", "?", "UpIndexQ"}], ",", 
               RowBox[{"-", "a2_"}]}], "]"}], ",", "PD"}], "]"}], "]"}], "\[RuleDelayed]", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"a", "=", 
              RowBox[{"DummyIn", "@", 
               RowBox[{"VBundleOfIndex", "@", "a1"}]}]}], "}"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"CurvatureForm", "[", 
               RowBox[{"covd", ",", "vbundle"}], "]"}], "[", 
              RowBox[{"a1", ",", 
               RowBox[{"-", "a2"}]}], "]"}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"connection", "[", 
                RowBox[{"covd", ",", "vbundle"}], "]"}], "[", 
               RowBox[{"a1", ",", 
                RowBox[{"-", "a"}]}], "]"}], "\[Wedge]", 
              RowBox[{
               RowBox[{"connection", "[", 
                RowBox[{"covd", ",", "vbundle"}], "]"}], "[", 
               RowBox[{"a", ",", 
                RowBox[{"-", "a2"}]}], "]"}]}]}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Exterior", " ", "derivative", " ", "of", " ", "the", " ", 
           "torsion"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"HoldPattern", "[", 
           RowBox[{"Diff", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"TorsionForm", "[", "covd", "]"}], "[", 
              RowBox[{"ind_", "?", "UpIndexQ"}], "]"}], ",", "PD"}], "]"}], 
           "]"}], "\[RuleDelayed]", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"a", "=", 
              RowBox[{"DummyIn", "@", 
               RowBox[{"VBundleOfIndex", "@", "ind"}]}]}], "}"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"Coframe", "[", 
                RowBox[{"ManifoldOfCovD", "@", "covd"}], "]"}], "[", "a", 
               "]"}], "\[Wedge]", 
              RowBox[{
               RowBox[{"RiemannForm", "[", "covd", "]"}], "[", 
               RowBox[{"ind", ",", 
                RowBox[{"-", "a"}]}], "]"}]}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"ChristoffelForm", "[", "covd", "]"}], "[", 
               RowBox[{"ind", ",", 
                RowBox[{"-", "a"}]}], "]"}], "\[Wedge]", 
              RowBox[{
               RowBox[{"TorsionForm", "[", "covd", "]"}], "[", "a", 
               "]"}]}]}]}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Exterior", " ", "derivative", " ", "of", " ", "the", " ", 
           "curvature"}], " ", "*)"}], "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"HoldPattern", "[", 
           RowBox[{"Diff", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"curvature", ":", 
                 RowBox[{"(", 
                  RowBox[{"CurvatureForm", "|", "RiemannForm"}], ")"}]}], 
                ")"}], "[", 
               RowBox[{"covd", ",", 
                RowBox[{"vbundle_", ":", 
                 RowBox[{"Tangent", "@", 
                  RowBox[{"ManifoldOfCovD", "@", "covd"}]}]}]}], "]"}], "[", 
              RowBox[{
               RowBox[{"a1_", "?", "UpIndexQ"}], ",", 
               RowBox[{"-", "a2_"}]}], "]"}], ",", "PD"}], "]"}], "]"}], "\[RuleDelayed]", 
          RowBox[{"Module", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"a", "=", 
              RowBox[{"DummyIn", "@", 
               RowBox[{"VBundleOfIndex", "@", "a1"}]}]}], "}"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"ConnectionForm", "[", 
                RowBox[{"covd", ",", "vbundle"}], "]"}], "[", 
               RowBox[{"a", ",", 
                RowBox[{"-", "a2"}]}], "]"}], "\[Wedge]", 
              RowBox[{
               RowBox[{"curvature", "[", 
                RowBox[{"covd", ",", "vbundle"}], "]"}], "[", 
               RowBox[{"a1", ",", 
                RowBox[{"-", "a"}]}], "]"}]}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"curvature", "[", 
                RowBox[{"covd", ",", "vbundle"}], "]"}], "[", 
               RowBox[{"a", ",", 
                RowBox[{"-", "a2"}]}], "]"}], "\[Wedge]", 
              RowBox[{
               RowBox[{"ConnectionForm", "[", 
                RowBox[{"covd", ",", "vbundle"}], "]"}], "[", 
               RowBox[{"a1", ",", 
                RowBox[{"-", "a"}]}], "]"}]}]}]}], "]"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Exterior", " ", "derivative", " ", "of", " ", "the", " ", "metric",
            " ", 
           RowBox[{"(", 
            RowBox[{"indices", " ", "downstairs"}], ")"}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"HoldPattern", "[", 
           RowBox[{"Diff", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"metr_", "?", "MetricQ"}], "[", 
              RowBox[{
               RowBox[{"-", "a1_"}], ",", 
               RowBox[{"-", "a2_"}]}], "]"}], ",", "PD"}], "]"}], "]"}], "\[RuleDelayed]", 
          RowBox[{
           RowBox[{"Module", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"a", "=", 
               RowBox[{"DummyIn", "@", 
                RowBox[{"VBundleOfIndex", "@", "a1"}]}]}], "}"}], ",", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"ChristoffelForm", "[", "covd", "]"}], "[", 
                RowBox[{"a", ",", 
                 RowBox[{"-", "a1"}]}], "]"}], 
               RowBox[{"metric", "[", 
                RowBox[{
                 RowBox[{"-", "a"}], ",", 
                 RowBox[{"-", "a2"}]}], "]"}]}], "+", 
              RowBox[{
               RowBox[{
                RowBox[{"ChristoffelForm", "[", "covd", "]"}], "[", 
                RowBox[{"a", ",", 
                 RowBox[{"-", "a2"}]}], "]"}], 
               RowBox[{"metric", "[", 
                RowBox[{
                 RowBox[{"-", "a"}], ",", 
                 RowBox[{"-", "a1"}]}], "]"}]}]}]}], "]"}], "/;", 
           RowBox[{
            RowBox[{"MetricOfCovD", "[", "covd", "]"}], "===", "metr"}]}]}], ",",
          "\[IndentingNewLine]", 
         RowBox[{"(*", " ", 
          RowBox[{
          "Exterior", " ", "derivative", " ", "of", " ", "the", " ", "metric",
            " ", 
           RowBox[{"(", 
            RowBox[{"indices", " ", "upstairs"}], ")"}]}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"HoldPattern", "[", 
           RowBox[{"Diff", "[", 
            RowBox[{
             RowBox[{"metric", "[", 
              RowBox[{"a1_Symbol", ",", "a2_Symbol"}], "]"}], ",", "PD"}], 
            "]"}], "]"}], "\[RuleDelayed]", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{
             RowBox[{"ChristoffelForm", "[", "covd", "]"}], "[", 
             RowBox[{"a1", ",", "a2"}], "]"}]}], "-", 
           RowBox[{
            RowBox[{"ChristoffelForm", "[", "covd", "]"}], "[", 
            RowBox[{"a2", ",", "a1"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
         
         RowBox[{"(*", " ", 
          RowBox[{
          "Exterior", " ", "derivative", " ", "when", " ", "covd", " ", "is", 
           " ", "the", " ", "parallel", " ", "derivative", " ", "of", " ", 
           "a", " ", "coordinate", " ", "chart"}], " ", "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"HoldPattern", "@", 
           RowBox[{"Diff", "[", 
            RowBox[{
             RowBox[{"expr1_", "?", "ScalarQ"}], ",", "PD"}], "]"}]}], "\[RuleDelayed]", 
          RowBox[{
           RowBox[{"Inner", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"covd", "[", 
                 RowBox[{"{", 
                  RowBox[{"#1", ",", 
                   RowBox[{"-", 
                    RowBox[{"BasisOfCovD", "@", "covd"}]}]}], "}"}], "]"}], "@",
                 "expr1"}], " ", 
               RowBox[{"Diff", "@", "#2"}]}], "&"}], ",", 
             RowBox[{"CNumbersOf", "[", 
              RowBox[{"basis", ",", 
               RowBox[{"VBundleOfBasis", "[", "basis", "]"}]}], "]"}], ",", 
             RowBox[{"ScalarsOfChart", "[", "basis", "]"}], ",", "Plus"}], 
            "]"}], "/;", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"Deg", "@", "expr1"}], "===", "0"}], "&&", 
             RowBox[{"basis", "=!=", "Null"}]}], ")"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"metric", "=!=", "Null"}], ",", "\[IndentingNewLine]", 
           RowBox[{"With", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"eps", "=", 
               RowBox[{"epsilon", "[", "metric", "]"}]}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"HoldPattern", "[", 
               RowBox[{"Diff", "[", 
                RowBox[{
                 RowBox[{"eps", "[", 
                  RowBox[{"inds__", "?", "DownIndexQ"}], "]"}], ",", "PD"}], 
                "]"}], "]"}], "\[RuleDelayed]", 
              RowBox[{"Module", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"a", "=", 
                  RowBox[{"DummyIn", "[", 
                   RowBox[{"VBundleOfMetric", "[", "metric", "]"}], "]"}]}], 
                 "}"}], ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"ChristoffelForm", "[", "covd", "]"}], "[", 
                  RowBox[{"a", ",", 
                   RowBox[{"-", "a"}]}], "]"}], 
                 RowBox[{"eps", "[", "inds", "]"}]}]}], "]"}]}]}], 
            "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "]"}]}], 
        "\[IndentingNewLine]", "}"}]}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2c1851ed-e2b7-46f5-8910-17695aab594c"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.6 Interior product and Lie derivative", \
"Subsubsection",ExpressionUUID->"cfa895a1-6bf0-45eb-a859-02f6f1309bf9"],

Cell["\<\
We define the interior product of form with a vector as a derivation of \
degree -1.\
\>", "Text",ExpressionUUID->"a1d09017-e280-4f99-a8db-d8db8e0fc31d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "Int"}]], "Input",ExpressionUUID->"fa90b46a-dc84-40c0-9e85-5f5c382f9ff6"],

Cell[BoxData[
 StyleBox["\<\"Int[v][form] is the interior contraction of form with the \
vector (rank 1-tensor) v\"\>", 
  "MSG"]], "Print", \
"PrintUsage",ExpressionUUID->"25c32dab-0176-4190-9d36-a7b20226cf15"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefGradedDerivation", "[", 
   RowBox[{
    RowBox[{"Int", "[", "v_", "]"}], ",", "Wedge", ",", 
    RowBox[{"-", "1"}], ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<\[Iota]\>\""}]}], "]"}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"229b1416-fae9-46bd-b6d0-ae98dd53c8e8"],

Cell["Main properties of the interior product:", \
"Text",ExpressionUUID->"f887f7a9-b0d1-48c9-bb9a-67b92661f926"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", "v_", "]"}], "[", 
    RowBox[{"f_", " ", "form_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"f", " ", 
     RowBox[{
      RowBox[{"Int", "[", "v", "]"}], "[", "form", "]"}]}], "/;", 
    RowBox[{
     RowBox[{"Deg", "@", "f"}], "===", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", "v_", "]"}], "[", "f_", "]"}], ":=", 
   RowBox[{"0", "/;", 
    RowBox[{
     RowBox[{"Deg", "@", "f"}], "===", "0"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{
      RowBox[{"f_", "?", "ScalarQ"}], " ", "v_"}], "]"}], "[", "form_", "]"}],
    ":=", 
   RowBox[{"f", " ", 
    RowBox[{
     RowBox[{"Int", "[", "v", "]"}], "[", "form", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"v_", "[", "ind1_Symbol", "]"}], "]"}], "[", 
    RowBox[{
     RowBox[{"Coframe", "[", "mani_", "]"}], "[", "ind2_", "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"v", "[", "ind2", "]"}], "/;", 
    RowBox[{"v", "=!=", 
     RowBox[{"Coframe", "[", "mani", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"v_", "[", "ind1_Symbol", "]"}], "]"}], "[", 
    RowBox[{
     RowBox[{"dx", "[", "mani_", "]"}], "[", "ind2_", "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"v", "[", "ind2", "]"}], "/;", 
    RowBox[{"v", "=!=", 
     RowBox[{"dx", "[", "mani", "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"v_", "[", 
      RowBox[{"-", "ind1_Symbol"}], "]"}], "]"}], "[", 
    RowBox[{
     RowBox[{"Coframe", "[", "mani_", "]"}], "[", "ind2_", "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"v", "[", 
     RowBox[{"-", "ind1"}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"First", "@", 
       RowBox[{"MetricsOfVBundle", "@", 
        RowBox[{"Tangent", "@", "mani"}]}]}], ")"}], "[", 
     RowBox[{"ind1", ",", "ind2"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"v_", "[", 
      RowBox[{"-", "ind1_Symbol"}], "]"}], "]"}], "[", 
    RowBox[{
     RowBox[{"dx", "[", "mani_", "]"}], "[", "ind2_", "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"v", "[", 
     RowBox[{"-", "ind1"}], "]"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"First", "@", 
       RowBox[{"MetricsOfVBundle", "@", 
        RowBox[{"Tangent", "@", "mani"}]}]}], ")"}], "[", 
     RowBox[{"ind1", ",", "ind2"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"cnumber1_", "?", "IntegerQ"}], ",", 
         RowBox[{"-", 
          RowBox[{"basisname_", "?", "BasisQ"}]}]}], "}"}], ",", 
       "ind_Symbol"}], "]"}], "]"}], "[", 
    RowBox[{
     RowBox[{"dx", "[", "mani_", "]"}], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"cnumber2_", "?", "IntegerQ"}], ",", 
       RowBox[{"basisname_", "?", "BasisQ"}]}], "}"}], "]"}], "]"}], ":=", 
   RowBox[{"0", "/;", 
    RowBox[{"cnumber1", "=!=", "cnumber2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"cnumber1_", "?", "IntegerQ"}], ",", 
         RowBox[{"-", 
          RowBox[{"basisname_", "?", "BasisQ"}]}]}], "}"}], ",", 
       "ind_Symbol"}], "]"}], "]"}], "[", 
    RowBox[{
     RowBox[{"dx", "[", "mani_", "]"}], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"cnumber2_", "?", "IntegerQ"}], ",", 
       RowBox[{"basisname_", "?", "BasisQ"}]}], "}"}], "]"}], "]"}], ":=", 
   RowBox[{"1", "/;", 
    RowBox[{"cnumber1", "===", "cnumber2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"cnumber1_", "?", "IntegerQ"}], ",", 
         RowBox[{"-", 
          RowBox[{"basisname_", "?", "BasisQ"}]}]}], "}"}], ",", 
       "ind_Symbol"}], "]"}], "]"}], "[", 
    RowBox[{
     RowBox[{"Coframe", "[", "mani_", "]"}], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"cnumber2_", "?", "IntegerQ"}], ",", 
       RowBox[{"basisname_", "?", "BasisQ"}]}], "}"}], "]"}], "]"}], ":=", 
   RowBox[{"0", "/;", 
    RowBox[{"cnumber1", "=!=", "cnumber2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", 
     RowBox[{"Basis", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"cnumber1_", "?", "IntegerQ"}], ",", 
         RowBox[{"-", 
          RowBox[{"basisname_", "?", "BasisQ"}]}]}], "}"}], ",", 
       "ind_Symbol"}], "]"}], "]"}], "[", 
    RowBox[{
     RowBox[{"Coframe", "[", "mani_", "]"}], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"cnumber2_", "?", "IntegerQ"}], ",", 
       RowBox[{"basisname_", "?", "BasisQ"}]}], "}"}], "]"}], "]"}], ":=", 
   RowBox[{"1", "/;", 
    RowBox[{"cnumber1", "===", "cnumber2"}]}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"50e388b2-3b5d-43de-9042-a2720a020efe"],

Cell["Interior contraction of basis objects is zero.", \
"Text",ExpressionUUID->"baa8d381-379b-4cb1-9f99-ac8b01e007d0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Int", "[", "v_", "]"}], "[", "_Basis", "]"}], ":=", "0"}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d50b8ee7-74e2-4897-832e-ca01929675f8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "CartanD"}]], \
"Input",ExpressionUUID->"da9086a8-e74f-437e-aac2-97496c9af6e9"],

Cell[BoxData[
 StyleBox["\<\"CartanD[v][form] is the Cartan derivative of form with respect \
to the vector (rank 1-tensor) v. CartanD[v][form,covd] is the Cartan \
derivative with respect to the covariant derivative covd.\"\>", 
  "MSG"]], "Print", \
"PrintUsage",ExpressionUUID->"fda21cb9-3bb2-4c23-ba5b-4098f63e97a1"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"DefGradedDerivation", "[", 
   RowBox[{
    RowBox[{"CartanD", "[", "v_", "]"}], ",", "Wedge", ",", "0", ",", 
    RowBox[{"PrintAs", "\[Rule]", "\"\<L\>\""}]}], "]"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"ff0d0860-a338-48fa-8bdf-c836ddee979c"],

Cell["Lie acting on basis objects is zero.", \
"Text",ExpressionUUID->"ae5cc5b3-1bfa-4a80-be6a-863f8195dad0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CartanD", "[", "v_", "]"}], "[", "_Basis", "]"}], ":=", "0"}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"de8feffd-6153-4e9e-9f60-bf98d73a9bdc"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CartanD", "[", "v_", "]"}], "[", 
    RowBox[{"_Basis", ",", "_"}], "]"}], ":=", "0"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"c921cd9e-5d55-4ce1-89c8-8a750d9c53a0"],

Cell["\<\
Superscript formatting for Lie derivatives arising from the exterior \
derivatives\
\>", "Text",ExpressionUUID->"fda65cb9-38f3-4f9a-afdd-1fa6a14bd191"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"CartanD", "/:", 
   RowBox[{"MakeBoxes", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"CartanD", "[", "v_", "]"}], "[", 
      RowBox[{"form_", ",", 
       RowBox[{"PD", "?", "CovDQ"}]}], "]"}], ",", "StandardForm"}], "]"}], ":=", 
   RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"CartanD", "[", "v", "]"}], "[", 
      RowBox[{"form", ",", "PD"}], "]"}], ",", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"SubscriptBox", "[", 
         RowBox[{"\"\<L\>\"", ",", 
          RowBox[{"MakeBoxes", "[", 
           RowBox[{"v", ",", "StandardForm"}], "]"}]}], "]"}], 
        ",", "\"\<[\>\"", ",", 
        RowBox[{"MakeBoxes", "[", 
         RowBox[{"form", ",", "StandardForm"}], "]"}], ",", "\"\<]\>\""}], 
       "}"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CartanD", "/:", 
   RowBox[{"MakeBoxes", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"CartanD", "[", "v_", "]"}], "[", 
      RowBox[{"form_", ",", 
       RowBox[{"cd_", "?", "CovDQ"}]}], "]"}], ",", "StandardForm"}], "]"}], ":=", 
   RowBox[{"xAct`xTensor`Private`interpretbox", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"CartanD", "[", "v", "]"}], "[", 
      RowBox[{"form", ",", "cd"}], "]"}], ",", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"SubsuperscriptBox", "[", 
         RowBox[{"\"\<L\>\"", ",", 
          RowBox[{"MakeBoxes", "[", 
           RowBox[{"v", ",", "StandardForm"}], "]"}], ",", 
          RowBox[{"Last", "@", 
           RowBox[{"SymbolOfCovD", "[", "cd", "]"}]}]}], "]"}], 
        ",", "\"\<[\>\"", ",", 
        RowBox[{"MakeBoxes", "[", 
         RowBox[{"form", ",", "StandardForm"}], "]"}], ",", "\"\<]\>\""}], 
       "}"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"855b3c95-f0b3-4ea2-8f2d-34b25a04f7fa"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CartanD", "[", 
     RowBox[{
      RowBox[{"f_", "?", "ScalarQ"}], " ", "v_"}], "]"}], "[", "form_", "]"}],
    ":=", 
   RowBox[{
    RowBox[{"f", " ", 
     RowBox[{
      RowBox[{"CartanD", "[", "v", "]"}], "@", "form"}]}], "+", 
    RowBox[{"Wedge", "[", 
     RowBox[{
      RowBox[{"Diff", "@", "f"}], ",", 
      RowBox[{
       RowBox[{"Int", "[", "v", "]"}], "@", "form"}]}], "]"}]}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"ef005b11-088e-4fac-b8ab-23c42f0c5381"],

Cell["We still need definition when acting on Times", \
"Text",ExpressionUUID->"ab5193e3-566b-470b-a69a-adf5c999f03a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "produces", " ", "expanded", " ", "expressions", " ", "and", " ",
     "is", " ", "much", " ", "faster", " ", "when", " ", "there", " ", "are", 
    " ", "many", " ", "scalars"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"CartanD", "[", "v_", "]"}], "[", "expr_Times", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"grades", "=", 
          RowBox[{
           RowBox[{
            RowBox[{"Grade", "[", 
             RowBox[{"#", ",", "Wedge"}], "]"}], "&"}], "/@", 
           RowBox[{"List", "@@", "expr"}]}]}], ",", "pos", ",", "scalar", ",",
          "form"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"pos", "=", 
         RowBox[{"Position", "[", 
          RowBox[{"grades", ",", 
           RowBox[{"_", "?", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"#", "=!=", "0"}], "&"}], ")"}]}], ",", "1", ",", 
           RowBox[{"Heads", "\[Rule]", "False"}]}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Which", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "pos", "]"}], ">", "1"}], ",", 
          "\[IndentingNewLine]", "\t", 
          RowBox[{"Throw", "[", 
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"Diff", "::", "error1"}], 
             ",", "\"\<Found Times product of nonscalar forms: \>\"", ",", 
             "expr"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Length", "[", "pos", "]"}], "===", "1"}], ",", 
          "\[IndentingNewLine]", "\t", 
          RowBox[{
           RowBox[{"pos", "=", 
            RowBox[{"pos", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", 
           "\[IndentingNewLine]", "\t", 
           RowBox[{"scalar", "=", 
            RowBox[{"Delete", "[", 
             RowBox[{"expr", ",", 
              RowBox[{"{", "pos", "}"}]}], "]"}]}], ";", 
           "\[IndentingNewLine]", "\t", 
           RowBox[{"form", "=", 
            RowBox[{"expr", "[", 
             RowBox[{"[", "pos", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
           "\t", 
           RowBox[{
            RowBox[{"scalar", " ", 
             RowBox[{
              RowBox[{"CartanD", "[", "v", "]"}], "[", "form", "]"}]}], "+", 
            RowBox[{
             RowBox[{"lie0", "[", "v", "]"}], "[", 
             RowBox[{"scalar", ",", "form"}], "]"}]}]}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Length", "[", "pos", "]"}], "===", "0"}], ",", 
          "\[IndentingNewLine]", "\t", 
          RowBox[{
           RowBox[{"lie0", "[", "v", "]"}], "[", "expr", "]"}]}], 
         "\[IndentingNewLine]", "]"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]\
, "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Only", " ", "scalars"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"lie0", "[", "v_", "]"}], "[", "expr_Times", "]"}], ":=", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"MapAt", "[", 
        RowBox[{
         RowBox[{"CartanD", "[", "v", "]"}], ",", "expr", ",", "i"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "expr", "]"}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"lie0", "[", "v_", "]"}], "[", "expr_", "]"}], ":=", " ", 
     RowBox[{
      RowBox[{"CartanD", "[", "v", "]"}], "[", "expr", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Scalars", " ", "and", " ", "a", " ", "form"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"lie0", "[", "v_", "]"}], "[", 
      RowBox[{"expr_Times", ",", "form_"}], "]"}], ":=", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"MapAt", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"lie0", "[", "v", "]"}], "[", 
           RowBox[{"#", ",", "form"}], "]"}], "&"}], ",", "expr", ",", "i"}], 
        "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"Length", "[", "expr", "]"}]}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"lie0", "[", "v_", "]"}], "[", 
      RowBox[{"expr_", ",", "form_"}], "]"}], ":=", 
     RowBox[{"Wedge", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"CartanD", "[", "v", "]"}], "[", "expr", "]"}], ",", "form"}],
       "]"}]}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"664a9c02-9b00-4fcf-bdc6-0fded42e8d01"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CartanD", "[", "v_", "]"}], "[", 
    RowBox[{"expr_", "?", "ConstantQ"}], "]"}], ":=", "0"}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"abc8a535-e384-423d-aee6-1b3ed96cce3f"],

Cell["\<\
Leibinitz rule for xTensor LieD when acting on wedge product expressions:\
\>", "Text",ExpressionUUID->"0eb10557-d1d5-444d-874a-830736fe282b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "@", "LieD"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LieD", "[", "v_", "]"}], "@", "expr_Wedge"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"CartanD", "[", "v", "]"}], "@", "expr"}], "/.", 
     RowBox[{"CartanD", "\[Rule]", "LieD"}]}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "@", "LieD"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"943352ed-7cd5-434e-83c8-18ae2e1e0477"],

Cell["\<\
Lie and diff commute (probably not true for covariant exterior derivatives). \
We need to pick a canonical order. Should this be done by a SortDs type \
function?\
\>", "Text",ExpressionUUID->"1818f1ce-1730-41b1-8fa9-4bc13a17f6e0"],

Cell["Cartan identity:", \
"Text",ExpressionUUID->"b88c0f4b-86fa-4b06-bca0-786e5bdb4a4a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CartanDToDiff", "[", "expr_", "]"}], ":=", 
   RowBox[{"expr", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"CartanD", "[", "v_", "]"}], "[", "form_", "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"Diff", "@", 
         RowBox[{
          RowBox[{"Int", "[", "v", "]"}], "@", "form"}]}], "+", 
        RowBox[{
         RowBox[{"Int", "[", "v", "]"}], "@", 
         RowBox[{"Diff", "@", "form"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"CartanD", "[", "v_", "]"}], "[", 
        RowBox[{"form_", ",", 
         RowBox[{"covd_", "?", "CovDQ"}]}], "]"}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"Diff", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Int", "[", "v", "]"}], "@", "form"}], ",", "covd"}], 
         "]"}], "+", 
        RowBox[{
         RowBox[{"Int", "[", "v", "]"}], "@", 
         RowBox[{"Diff", "[", 
          RowBox[{"form", ",", "covd"}], "]"}]}]}]}]}], "}"}]}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"5f041d9b-1f2b-4570-a46b-a30cafe88d95"],

Cell["\<\
Lie derivative of a tensor valued differential form. We overload the xTensor \
command LieDToCovD. Note: xTensor LieD doesn\[CloseCurlyQuote]t know how to \
work with wedge products.\
\>", "Text",ExpressionUUID->"1a0bcb95-c066-4f10-a521-be692846f52f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "LieDToCovD"}]], \
"Input",ExpressionUUID->"237f27da-7de6-4176-93a5-619351f29a5d"],

Cell[BoxData[
 StyleBox["\<\"LieDToCovD[expr, covd] transforms LieD[v][expr1] into LieD[v, \
covd][expr1] so that the Lie derivative of expr1 along v is computed in terms \
of the covariant derivative covd.\"\>", 
  "MSG"]], "Print", \
"PrintUsage",ExpressionUUID->"01e89763-561e-437e-a0cd-a6d578ddf05f"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LieDForm", "[", 
     RowBox[{
      RowBox[{"v_", "[", "ind_", "]"}], ",", 
      RowBox[{"covd_", "?", "CovDQ"}]}], "]"}], "@", "ten_"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", "=", 
       RowBox[{"DummyIn", "@", 
        RowBox[{"VBundleOfIndex", "@", "ind"}]}]}], "}"}], ",", 
     RowBox[{"ToCanonical", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"LieD", "[", 
          RowBox[{
           RowBox[{"v", "[", "ind", "]"}], ",", "covd"}], "]"}], "@", "ten"}],
         "+", 
        RowBox[{
         RowBox[{"CartanD", "[", 
          RowBox[{"v", "[", "ind", "]"}], "]"}], "[", 
         RowBox[{"ten", ",", "covd"}], "]"}], "-", 
        RowBox[{
         RowBox[{"v", "[", "a", "]"}], 
         RowBox[{
          RowBox[{"covd", "[", 
           RowBox[{"-", "a"}], "]"}], "@", "ten"}]}]}], ",", 
       RowBox[{"UseMetricOnVBundle", "\[Rule]", "None"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LieDFormToCovD", "[", 
    RowBox[{"expr_", ",", "covd_"}], "]"}], ":=", 
   RowBox[{"expr", "//.", 
    RowBox[{
     RowBox[{"LieD", "[", "vector_", "]"}], "\[RuleDelayed]", 
     RowBox[{"LieDForm", "[", 
      RowBox[{"vector", ",", "covd"}], "]"}]}]}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"7dc11d2c-3a9a-432f-bb76-3fdca6ace74b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Unprotect", "@", "LieDToCovD"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LieDToCovD", "[", 
   RowBox[{"expr_", ",", 
    RowBox[{"arg_", ":", "PD"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"LieDFormToCovD", "[", 
    RowBox[{"expr", ",", "arg"}], "]"}], "/;", 
   RowBox[{
    RowBox[{"Deg", "@", "expr"}], "\[GreaterEqual]", "1"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Protect", "@", "LieDToCovD"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"c7af9c6a-93da-44fc-979f-8ccbc348109d"]
}, Closed]],

Cell[CellGroupData[{

Cell["3.7 Commuting and sorting of the derivations ", \
"Subsubsection",ExpressionUUID->"8ffdc843-eb21-4561-8074-be0ec9911ae1"],

Cell[TextData[{
 "There are 6 equations in all for the (super-)commutators of the three \
derivations (also the negations of these three equations). It is easy to \
write them down. The LHS\[CloseCurlyQuote]s are just super-commutators of two \
derivations, in whatever order you want. The sign is + just for [odd,odd] so \
that\[CloseCurlyQuote]s for [d,d], [\[Iota],\[Iota]], and [\[Iota],d]. Then \
the RHS is itself a single derivation, with the degree being the sum of \
degrees from the LHS. If there is only one vector argument, it\
\[CloseCurlyQuote]s clear what the RHS should be. When there are two vector \
arguments, then the vector on the RHS is the Lie bracket of the two from the \
LHS, in the order that they came on the LHS.\n \nThe equations are:\n1. ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["d", "2"], "=", "0"}], TraditionalForm]],ExpressionUUID->
  "bd0f6f8f-5eb1-4c79-b188-4a2893b9ca26"],
 "\n2. ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[Iota]", "v"], 
      SubscriptBox["\[Iota]", "w"]}], "+", 
     RowBox[{
      SubscriptBox["\[Iota]", "w"], 
      SubscriptBox["\[Iota]", "v"]}]}], "=", "0"}], TraditionalForm]],
  ExpressionUUID->"745021ab-3608-435f-b412-efc6c3c6eb7d"],
 "\n3. ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[ScriptCapitalL]", "v"], 
      SubscriptBox["\[ScriptCapitalL]", "w"]}], "-", 
     RowBox[{
      SubscriptBox["\[ScriptCapitalL]", "w"], 
      SubscriptBox["\[ScriptCapitalL]", "v"]}]}], "=", 
    SubscriptBox["\[ScriptCapitalL]", 
     RowBox[{"[", 
      RowBox[{"v", ",", "w"}], "]"}]]}], TraditionalForm]],ExpressionUUID->
  "cb6306f3-0cf4-4ed4-8cd4-4695a870f235"],
 "\n4. ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Iota]", "v"], 
     SubscriptBox["\[ScriptCapitalL]", "w"]}], "-", 
    RowBox[{
     SubscriptBox["\[ScriptCapitalL]", "w"], 
     SubscriptBox["\[Iota]", "v"]}]}], TraditionalForm]],ExpressionUUID->
  "b3f3ffa4-0072-487d-8f6d-ec9addadcf21"],
 " = ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Iota]", 
    RowBox[{"[", 
     RowBox[{"v", ",", "w"}], "]"}]], TraditionalForm]],ExpressionUUID->
  "fe229c94-9f07-4c0a-b3bc-8588c0b67d68"],
 "\n5. ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[Iota]", "v"], "d"}], "+", 
     RowBox[{"d", " ", 
      SubscriptBox["\[Iota]", "v"]}]}], "=", " ", 
    SubscriptBox["\[ScriptCapitalL]", "v"]}], TraditionalForm]],
  ExpressionUUID->"92469b3c-a58c-4585-8747-506bf9689de8"],
 "\n6. ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[ScriptCapitalL]", "v"], "d"}], "-", 
     RowBox[{"d", " ", 
      SubscriptBox["\[ScriptCapitalL]", "v"]}]}], "=", "0"}], 
   TraditionalForm]],ExpressionUUID->"79f93c97-4f63-4443-bd9f-2f62ae4edf12"],
 " (\[OpenCurlyDoubleQuote]Cartan\[CloseCurlyQuote]s magic formula\
\[CloseCurlyDoubleQuote])"
}], "Text",ExpressionUUID->"14a63f4c-76e5-4eef-8811-80e83892447c"],

Cell["\<\
1. requires no action (it will just be automatically killed).
2, 3. Maybe have this sorted automatically? Any canonical order for v,w \
imposes a canonical order on the derivations.
4, 5, 6\[LongDash]write rules to go in either direction.\
\>", "Text",ExpressionUUID->"c40015fa-7cd8-4f8c-9264-cdaba7e84813"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SortDerivationsRule", "[", 
    RowBox[{"Diff", ",", "Diff"}], "]"}], "=", 
   RowBox[{"{", "}"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"2873d5f2-5464-4607-8b12-f3743cd66d9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SortDerivationsRule", "[", 
    RowBox[{"Int", ",", "Int"}], "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{
       RowBox[{"Int", "[", "v_", "]"}], "@", 
       RowBox[{
        RowBox[{"Int", "[", "w_", "]"}], "@", "form_"}]}], "]"}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        RowBox[{"Int", "[", "w", "]"}], "@", 
        RowBox[{
         RowBox[{"Int", "[", "v", "]"}], "@", "form"}]}]}], "/;", 
      RowBox[{"!", 
       RowBox[{"OrderedQ", "[", 
        RowBox[{"{", 
         RowBox[{"v", ",", "w"}], "}"}], "]"}]}]}]}], "\[IndentingNewLine]", 
    "}"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d9445ffe-c36b-4fac-8d22-f52b68a97e85"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SortDerivationsRule", "[", 
    RowBox[{"CartanD", ",", "CartanD"}], "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{
        RowBox[{"CartanD", "[", "v_", "]"}], "@", 
        RowBox[{
         RowBox[{"CartanD", "[", "w_", "]"}], "@", "form_"}]}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a", "=", 
           RowBox[{"First", "@", 
            RowBox[{"FindFreeIndices", "[", "v", "]"}]}]}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"CartanD", "[", "w", "]"}], "@", 
           RowBox[{
            RowBox[{"CartanD", "[", "v", "]"}], "@", "form"}]}], "+", 
          RowBox[{
           RowBox[{"CartanD", "[", 
            RowBox[{
             RowBox[{"Bracket", "[", 
              RowBox[{"v", ",", "w"}], "]"}], "[", "a", "]"}], "]"}], "@", 
           "form"}]}]}], "]"}], "/;", 
       RowBox[{"!", 
        RowBox[{"OrderedQ", "[", 
         RowBox[{"{", 
          RowBox[{"v", ",", "w"}], "}"}], "]"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{
        RowBox[{"CartanD", "[", "v_", "]"}], "[", 
        RowBox[{
         RowBox[{
          RowBox[{"CartanD", "[", "w_", "]"}], "[", 
          RowBox[{"form_", ",", 
           RowBox[{"covd_", "?", "CovDQ"}]}], "]"}], ",", 
         RowBox[{"covd_", "?", "CovDQ"}]}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a", "=", 
           RowBox[{"First", "@", 
            RowBox[{"FindFreeIndices", "[", "v", "]"}]}]}], "}"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"CartanD", "[", "w", "]"}], "[", 
           RowBox[{
            RowBox[{
             RowBox[{"CartanD", "[", "v", "]"}], "[", 
             RowBox[{"form", ",", "covd"}], "]"}], ",", "covd"}], "]"}], "+", 
          
          RowBox[{
           RowBox[{"CartanD", "[", 
            RowBox[{
             RowBox[{"Bracket", "[", 
              RowBox[{"v", ",", "w"}], "]"}], "[", "a", "]"}], "]"}], "[", 
           RowBox[{"form", ",", "covd"}], "]"}]}]}], "]"}], "/;", 
       RowBox[{"!", 
        RowBox[{"OrderedQ", "[", 
         RowBox[{"{", 
          RowBox[{"v", ",", "w"}], "}"}], "]"}]}]}]}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"5011ced9-9b0a-422b-8222-fc1d26a66140"],

Cell["\<\
Below, SortDerivationsRule[d1,d2][expr] changes instances of d2\[CenterDot]d1 \
into d1\[CenterDot]d2. There is no need to check orderings.\
\>", "Text",ExpressionUUID->"026d7657-1bde-4232-89b3-ab628f013b23"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SortDerivationsRule", "[", 
    RowBox[{"Int", ",", "CartanD"}], "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{
        RowBox[{"CartanD", "[", "w_", "]"}], "@", 
        RowBox[{
         RowBox[{"Int", "[", "v_", "]"}], "@", "form_"}]}], "]"}], "\[RuleDelayed]", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", "=", 
          RowBox[{"First", "@", 
           RowBox[{"FindFreeIndices", "[", "w", "]"}]}]}], "}"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Int", "[", "v", "]"}], "@", 
          RowBox[{
           RowBox[{"CartanD", "[", "w", "]"}], "@", "form"}]}], "+", 
         RowBox[{
          RowBox[{"Int", "[", 
           RowBox[{
            RowBox[{"Bracket", "[", 
             RowBox[{"w", ",", "v"}], "]"}], "[", "a", "]"}], "]"}], "@", 
          "form"}]}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{
        RowBox[{"CartanD", "[", "w_", "]"}], "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Int", "[", "v_", "]"}], "@", "form_"}], ",", 
         RowBox[{"covd_", "?", "CovDQ"}]}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", "=", 
          RowBox[{"First", "@", 
           RowBox[{"FindFreeIndices", "[", "w", "]"}]}]}], "}"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"Int", "[", "v", "]"}], "@", 
          RowBox[{
           RowBox[{"CartanD", "[", "w", "]"}], "[", 
           RowBox[{"form", ",", "covd"}], "]"}]}], "+", 
         RowBox[{
          RowBox[{"Int", "[", 
           RowBox[{
            RowBox[{"Bracket", "[", 
             RowBox[{"w", ",", "v"}], "]"}], "[", "a", "]"}], "]"}], "@", 
          "form"}]}]}], "]"}]}]}], "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SortDerivationsRule", "[", 
    RowBox[{"CartanD", ",", "Int"}], "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{
        RowBox[{"Int", "[", "v_", "]"}], "@", 
        RowBox[{
         RowBox[{"CartanD", "[", "w_", "]"}], "@", "form_"}]}], "]"}], "\[RuleDelayed]", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", "=", 
          RowBox[{"First", "@", 
           RowBox[{"FindFreeIndices", "[", "w", "]"}]}]}], "}"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"CartanD", "[", "w", "]"}], "@", 
          RowBox[{
           RowBox[{"Int", "[", "v", "]"}], "@", "form"}]}], "+", 
         RowBox[{
          RowBox[{"Int", "[", 
           RowBox[{
            RowBox[{"Bracket", "[", 
             RowBox[{"v", ",", "w"}], "]"}], "[", "a", "]"}], "]"}], "@", 
          "form"}]}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{
        RowBox[{"Int", "[", "v_", "]"}], "@", 
        RowBox[{
         RowBox[{"CartanD", "[", "w_", "]"}], "[", 
         RowBox[{"form_", ",", 
          RowBox[{"covd_", "?", "CovDQ"}]}], "]"}]}], "]"}], "\[RuleDelayed]", 
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", "=", 
          RowBox[{"First", "@", 
           RowBox[{"FindFreeIndices", "[", "w", "]"}]}]}], "}"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"CartanD", "[", "w", "]"}], "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Int", "[", "v", "]"}], "@", "form"}], ",", "covd"}], 
          "]"}], "+", 
         RowBox[{
          RowBox[{"Int", "[", 
           RowBox[{
            RowBox[{"Bracket", "[", 
             RowBox[{"v", ",", "w"}], "]"}], "[", "a", "]"}], "]"}], "@", 
          "form"}]}]}], "]"}]}]}], "\[IndentingNewLine]", "}"}]}], 
  ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"f297782a-cbe4-401a-9397-41de9d09401d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SortDerivationsRule", "[", 
    RowBox[{"Int", ",", "Diff"}], "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"Diff", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Int", "[", "v_", "]"}], "@", "form_"}], ",", 
        RowBox[{"covd_", "?", "CovDQ"}]}], "]"}], "]"}], "\[RuleDelayed]", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{
        RowBox[{"Int", "[", "v", "]"}], "@", 
        RowBox[{"Diff", "[", 
         RowBox[{"form", ",", "covd"}], "]"}]}]}], "+", 
      RowBox[{
       RowBox[{"CartanD", "[", "v", "]"}], "[", 
       RowBox[{"form", ",", "covd"}], "]"}]}]}], "\[IndentingNewLine]", 
    "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SortDerivationsRule", "[", 
    RowBox[{"Diff", ",", "Int"}], "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{
       RowBox[{"Int", "[", "v_", "]"}], "@", 
       RowBox[{"Diff", "[", 
        RowBox[{"form_", ",", 
         RowBox[{"covd_", "?", "CovDQ"}]}], "]"}]}], "]"}], "\[RuleDelayed]", 
     
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Diff", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Int", "[", "v", "]"}], "@", "form"}], ",", "covd"}], 
        "]"}]}], "+", 
      RowBox[{
       RowBox[{"CartanD", "[", "v", "]"}], "[", 
       RowBox[{"form", ",", "covd"}], "]"}]}]}], "\[IndentingNewLine]", 
    "}"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"3bff55a2-4fba-41de-94f5-8565591c1cef"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SortDerivationsRule", "[", 
    RowBox[{"CartanD", ",", "Diff"}], "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"Diff", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"CartanD", "[", "v_", "]"}], "@", "form_"}], ",", "PD"}], 
        "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"CartanD", "[", "v", "]"}], "@", 
       RowBox[{"Diff", "@", "form"}]}]}], ",", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"Diff", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"CartanD", "[", "v_", "]"}], "[", 
          RowBox[{"form_", ",", 
           RowBox[{"covd_", "?", "CovDQ"}]}], "]"}], ",", 
         RowBox[{"covd_", "?", "CovDQ"}]}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{
       RowBox[{"CartanD", "[", "v", "]"}], "[", 
       RowBox[{
        RowBox[{"Diff", "[", 
         RowBox[{"form", ",", "covd"}], "]"}], ",", "covd"}], "]"}]}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SortDerivationsRule", "[", 
    RowBox[{"Diff", ",", "CartanD"}], "]"}], "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{
        RowBox[{"CartanD", "[", "v_", "]"}], "@", 
        RowBox[{"Diff", "[", 
         RowBox[{"form_", ",", "PD"}], "]"}]}], "]"}], "\[RuleDelayed]", 
      RowBox[{"Diff", "@", 
       RowBox[{
        RowBox[{"CartanD", "[", "v", "]"}], "@", "form"}]}]}], ",", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{
        RowBox[{"CartanD", "[", "v_", "]"}], "[", 
        RowBox[{
         RowBox[{"Diff", "[", 
          RowBox[{"form_", ",", 
           RowBox[{"covd_", "?", "CovDQ"}]}], "]"}], ",", 
         RowBox[{"covd_", "?", "CovDQ"}]}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{"Diff", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"CartanD", "[", "v", "]"}], "[", 
         RowBox[{"form", ",", "covd"}], "]"}], ",", "covd"}], "]"}]}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"a4f65917-aeda-429c-8ce4-c7ed738435e6"],

Cell["\<\
Now we choose a default left-to-right order that we want derivations to have. \
I don\[CloseCurlyQuote]t know if there is a best order (i.e. what encourages \
the largest number of terms to vanish).\
\>", "Text",ExpressionUUID->"496002c1-bca8-4456-84c7-d4bb260e3a2b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "$DerivationSortOrder"}]], \
"Input",ExpressionUUID->"0a2fe256-f7c1-402b-824e-50ae3518983a"],

Cell[BoxData[
 StyleBox["\<\"$DerivationSortOrder is a global variable which encodes the \
default ordering of the three derivatives Int, LieD and Diff. The default is \
{LieD,Int,Diff}\"\>", 
  "MSG"]], "Print", \
"PrintUsage",ExpressionUUID->"fdc8b117-be6f-4c92-8cc8-b62a0afb5775"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$Derivations", "=", 
   RowBox[{"{", 
    RowBox[{"CartanD", ",", "Int", ",", "Diff"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$DerivationSortOrder", "=", "$Derivations"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"65cc0dd6-5527-4278-a1e7-ecad2c075a75"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", 
  "SortDerivations"}]], \
"Input",ExpressionUUID->"2558ab5b-98cc-480c-b0fb-6e1dbe0934c2"],

Cell[BoxData[
 StyleBox["\<\"SortDerivations[expr] brings expr into a new expression where \
all the derivations (exterior derivative, Lie derivative and interior \
contraction) are written in a canonical order. The default left-to-right \
order is defined by the variable $DerivationSortOrder\"\>", 
  "MSG"]], "Print", \
"PrintUsage",ExpressionUUID->"23c3eee1-ef4d-4e85-a7cc-f7d876a965a0"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SortDerivations", "[", "expr_", "]"}], ":=", 
  RowBox[{"SortDerivations", "[", 
   RowBox[{"expr", ",", "$DerivationSortOrder"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SortDerivations", "[", 
    RowBox[{"expr_", ",", "order_List"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Make", " ", "sure", " ", "that", " ", "order", " ", "is", " ", "some", 
       " ", "permutation", " ", "of", " ", "$Derivations"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sort", "@", "order"}], "=!=", 
         RowBox[{"Sort", "@", "$Derivations"}]}], ",", 
        RowBox[{
         RowBox[{"Throw", "@", 
          RowBox[{"Message", "[", 
           RowBox[{
            RowBox[{"SortDerivations", "::", "invalid"}], ",", "\"\<order\>\"",
             ",", "order"}], "]"}]}], ";"}]}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"expr", "//.", 
        RowBox[{"Join", "@@", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"Join", "@@", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"SortDerivationsRule", "[", 
                RowBox[{
                 RowBox[{"order", "[", 
                  RowBox[{"[", "i", "]"}], "]"}], ",", "#"}], "]"}], "&"}], "/@", 
              RowBox[{"Drop", "[", 
               RowBox[{"order", ",", "i"}], "]"}]}], ")"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", 
             RowBox[{
              RowBox[{"Length", "@", "order"}], "-", "1"}]}], "}"}]}], 
          "]"}]}]}], "//.", 
       RowBox[{"Join", "@@", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"SortDerivationsRule", "[", 
            RowBox[{"#", ",", "#"}], "]"}], "&"}], "/@", "order"}], 
         ")"}]}]}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"d5be5cbb-a887-4926-889e-25bf1977e323"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4. Variational derivatives of top rank forms", "Subsection",
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"13121a5d-4147-4ad5-945e-563bc327beb2"],

Cell[CellGroupData[{

Cell["4.1 FormVarD", \
"Subsubsection",ExpressionUUID->"4f7c67b4-47b5-4276-90dd-4cf4c152c029"],

Cell["Check that a form has top rank", \
"Text",ExpressionUUID->"23e96eb7-cacd-4e54-9c2b-cd92557b688d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"TopRankQ", "[", "form_", "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"manifolds", "=", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"DependenciesOf", "@", "form"}], ",", "ManifoldQ"}], "]"}]}],
       "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Length", "@", "manifolds"}], " ", "\[NotEqual]", " ", "1"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"TopRankQ", "::", "error1"}], 
          ",", "\"\<Forms must have exactly 1 manifold in \
dependencies.\>\""}], "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"TopRankQ", "[", 
        RowBox[{"form", ",", 
         RowBox[{"First", "@", "manifolds"}]}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"TopRankQ", "[", 
    RowBox[{"form_", ",", 
     RowBox[{"mani_", "?", "ManifoldQ"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Grade", "[", 
     RowBox[{"form", ",", "Wedge"}], "]"}], "===", 
    RowBox[{"DimOfManifold", "@", "mani"}]}]}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"62ce7b81-021f-4ace-85f2-279b5c74e8ff"],

Cell[TextData[{
 "FormVarD is supposed to be like VarD, but for top-rank forms. A derivative \
is not specified, because the exterior derivative is natural. However, the \
adjoint to the exterior derivative, the codifferential, requires a Hodge \
dual, which we define via a (non-degenerate!) metric. Therefore FormVarD has \
the notation FormVarD[form, metric][expr, rest]. The convention is that expr \
and rest are combined as \[Delta](expr)\[Wedge]rest (here I write the \
variational derivative as \[Delta], and always subscript the codifferential \
as ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Delta]", "g"], TraditionalForm]],ExpressionUUID->
  "738c81cc-88f3-44b7-8c9d-43c95ed77dc5"],
 "). This means that when writing the Leibniz rule for the Wedge product, we \
must re-order the factors, i.e.\n  \[Delta](a\[Wedge]b\[Wedge]c) = \[Delta]a\
\[Wedge]b\[Wedge]c + a\[Wedge]\[Delta]b\[Wedge]c + \
a\[Wedge]b\[Wedge]\[Delta]c=\[Delta]a\[Wedge]b\[Wedge]c + ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"|", 
     RowBox[{"a", "||", "b"}], "|"}]], TraditionalForm]],ExpressionUUID->
  "53fac359-5f41-4ddf-8680-92abe0c1ef93"],
 "\[Delta]b\[Wedge]a\[Wedge]c + ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"|", "a", "|", 
       RowBox[{"+", 
        RowBox[{"|", "b", "|"}]}]}], ")"}], "|", "c", "|"}]], 
   TraditionalForm]],ExpressionUUID->"dd3825c9-4a53-418a-8619-bdc6069d983d"],
 "\[Delta]c\[Wedge]a\[Wedge]b       etc.\nThe other identities we need \
follow. For a Hodge star,\n  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[Wedge]", 
    RowBox[{"(", 
     SubscriptBox["\[Star]", "g"]}]}], TraditionalForm]],ExpressionUUID->
  "c59c4d5d-2d00-4229-b81c-3e71132ad6f6"],
 "b) = ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"a", ",", "b"}], "\[RightAngleBracket]"}], "g"], 
   TraditionalForm]],ExpressionUUID->"eb90009e-be28-4912-b1a3-1c93c0366fbc"],
 " ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["dVol", "g"], TraditionalForm]],ExpressionUUID->
  "8f07a007-9ec6-4afa-b12a-1b878f36ef3a"],
 "     \[LineSeparator]where |a|+|*b|=n, and where\n  ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"a", ",", "b"}], "\[RightAngleBracket]"}], "g"], 
   TraditionalForm]],ExpressionUUID->"cc699189-d4b0-4e0a-9854-8b700a0e9308"],
 " = ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["g", 
      RowBox[{
       SubscriptBox["i", "1"], 
       SubscriptBox["j", "1"]}]], "..."}], " ", 
    SuperscriptBox["g", 
     RowBox[{
      SubscriptBox["i", "k"], 
      SubscriptBox["j", "k"]}]], 
    SubscriptBox["a", 
     RowBox[{
      RowBox[{
       SubscriptBox["i", "1"], "..."}], 
      SubscriptBox["i", "k"]}]], 
    SubscriptBox["b", 
     RowBox[{
      RowBox[{
       SubscriptBox["j", "1"], "..."}], 
      SubscriptBox["j", "k"]}]]}], TraditionalForm]],ExpressionUUID->
  "73926b67-a213-4670-a803-31582362d99f"],
 "\nis the inner product on k-forms given by the metric g, and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["dVol", "g"], TraditionalForm]],ExpressionUUID->
  "85a66186-549c-49f5-82c2-b8a1a3ea6381"],
 "=\[Star]1 is the metric volume element, given in a coordinate basis by\n  \
",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["dVol", "g"], "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       SqrtBox[
        RowBox[{"|", 
         RowBox[{"det", " ", "g"}], "|"}]], 
       RowBox[{
        SuperscriptBox["dx", "1"], "\[Wedge]"}]}], "..."}], "\[Wedge]", 
     SuperscriptBox["dx", "n"]}]}], TraditionalForm]],ExpressionUUID->
  "79f7182f-439c-44dc-811e-bf7ae1c1c55d"],
 ".\nWith a real metric and real-valued forms, it is clear that \
\[LeftAngleBracket]a,b\[RightAngleBracket] = \[LeftAngleBracket]b,a\
\[RightAngleBracket] and so\n  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"a", "\[Wedge]", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[Star]", "g"], "b"}], ")"}]}], " ", "=", " ", 
    RowBox[{"b", "\[Wedge]", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[Star]", "g"], "a"}], ")"}]}]}], TraditionalForm]],
  ExpressionUUID->"bbd9441b-fedf-4c00-bf44-fafb21f17554"],
 "        (for |a|+|*b|=n) \nor in the way we\[CloseCurlyQuote]ll use it,\n  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Star]", "g"], "a"}], ")"}], TraditionalForm]],
  ExpressionUUID->"4fac6b8d-98d2-4106-859e-047061126765"],
 "\[Wedge]b = ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"|", "a", "|", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"n", "-"}], "|", "a", "|"}], ")"}]}]], TraditionalForm]],
  ExpressionUUID->"20bdd8ca-28e6-4e44-8250-06226f5046bc"],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "\[Wedge]", 
    RowBox[{"(", 
     RowBox[{
      SubscriptBox["\[Star]", "g"], "b"}]}]}], TraditionalForm]],
  ExpressionUUID->"781378ef-c6b5-4466-8d46-946f0a83c0e5"],
 ")      (for |a|+|*b|=n) \nQUESTION: What about \
\[DoubleStruckCapitalC]-valued forms?\nWe also have that diff and codiff (of \
any CovD) are adjoints of each other, in the sense that\n  \[Integral]  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"da", "\[Wedge]"}], 
    SubscriptBox["\[Star]", "g"]}], TraditionalForm]],ExpressionUUID->
  "a6f852f4-7bee-4089-b613-9daeb99f0f88"],
 "b = \[Integral]  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"b", "\[Wedge]"}], 
    SubscriptBox["\[Star]", "g"], "da"}], TraditionalForm]],ExpressionUUID->
  "5a502fac-3439-47ea-9265-67fb4590e86d"],
 " = \[Integral]  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"a", "\[Wedge]"}], 
    SubscriptBox["\[Star]", "g"], 
    RowBox[{
     SubscriptBox["\[Delta]", "g"], "b"}]}], TraditionalForm]],ExpressionUUID->
  "83d55c44-77d1-4e7d-80ae-6e463071af6b"],
 " = \[Integral]  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Delta]", "g"], 
     RowBox[{"b", "\[Wedge]"}]}], 
    SubscriptBox["\[Star]", "g"], "a"}], TraditionalForm]],ExpressionUUID->
  "18ad3269-18b0-49b7-8bdd-4e3121213de1"],
 "\nThe above rule is convenient with the inverse of Hodge, i.e. ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Star]", "g", 
      RowBox[{"-", "1"}]], 
     SubscriptBox["\[Star]", "g"]}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[Star]", "g"], 
      SubsuperscriptBox["\[Star]", "g", 
       RowBox[{"-", "1"}]]}], "=", "id"}]}], TraditionalForm]],ExpressionUUID->
  "a1734cb7-9520-4038-82e7-fe757cdf7705"],
 ". This inverse is\n  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Star]", "g", 
      RowBox[{"-", "1"}]], "a"}], "=", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"|", "a", "|", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"n", "-"}], "|", "a", "|"}], ")"}]}]], "s"}], " ", 
     SubscriptBox["\[Star]", "g"], "a"}]}], TraditionalForm]],ExpressionUUID->
  "da0251d9-bc09-4116-b75b-54447fc960da"],
 "\nwhere s=SignDetOfMetric[g]\nTODO:\n  1. Act on ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Star]", "g2"], TraditionalForm]],ExpressionUUID->
  "ad7054d4-4cc5-4b99-89f1-38bb5aa2698b"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Delta]", "g2"], TraditionalForm]],ExpressionUUID->
  "ef6bab62-4205-4fde-aa5f-6cfd75f08238"],
 " where g2 is a second metric on the same manifold, and is also \
non-degenerate. ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Star]", "g2"], TraditionalForm]],ExpressionUUID->
  "d46091d9-31a9-412b-8ee3-3a8624e451ec"],
 " can be converted to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Star]", "g"], TraditionalForm]],ExpressionUUID->
  "791ba6e4-0316-4407-aab1-5210472ae99b"],
 " by including a ratio of volume elements (the ratio is coordinate-free).\n  \
2. What to do with Lie, Int?\n  3. What about coframe, connection, torsion, \
curvature, etc.?"
}], "Text",ExpressionUUID->"02af2805-14a3-43fb-ac9c-d40caa3bfb19"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"InvHodge", "[", "metric_", "]"}], "[", "expr_", "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"k", "=", 
        RowBox[{"Grade", "[", 
         RowBox[{"expr", ",", "Wedge"}], "]"}]}], ",", 
       RowBox[{"n", "=", 
        RowBox[{"DimOfMetric", "@", "metric"}]}], ",", 
       RowBox[{"s", "=", 
        RowBox[{"SignDetOfMetric", "@", "metric"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"k", 
         RowBox[{"(", 
          RowBox[{"n", "-", "k"}], ")"}]}], ")"}]}], "s", " ", 
      RowBox[{
       RowBox[{"Hodge", "[", "metric", "]"}], "@", "expr"}]}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"3651d360-1e20-4b17-a6d3-851d4b43a4a4"],

Cell[TextData[{
 "We will use it as follows:\n  \[Integral] da \[Wedge] c = \[Integral] a \
\[Wedge] ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Star]", "g"], 
    SubscriptBox["\[Delta]", "g"], 
    SubsuperscriptBox["\[Star]", "g", 
     RowBox[{"-", "1"}]], "c"}], TraditionalForm]],ExpressionUUID->
  "bb9276c5-5ad2-48de-92de-59341c3b235f"],
 "\nand\n  \[Integral] ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["\[Delta]", "g"], 
     RowBox[{"b", " ", "\[Wedge]", " ", "c"}]}], " ", "=", " ", 
    RowBox[{"\[Integral]", " ", 
     RowBox[{
      RowBox[{"b", " ", "\[Wedge]"}], " ", 
      SubscriptBox["\[Star]", "g"], "d", 
      SubsuperscriptBox["\[Star]", "g", 
       RowBox[{"-", "1"}]], "c"}]}]}], TraditionalForm]],ExpressionUUID->
  "21552e2a-49cb-4fdf-90d3-123a109d2766"]
}], "Text",ExpressionUUID->"e377ce57-7606-4f2b-8bb2-5738aa1f7d6a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"TODO", ":", 
     RowBox[{
     "More", " ", "checks", " ", "that", " ", "form", " ", "is", " ", 
      "actually", " ", "on", " ", "same", " ", "manifold", " ", "as", " ", 
      "metric"}]}], ",", " ", 
    RowBox[{"etc", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Generate", " ", 
    RowBox[{"rest", ".", " ", "Replace"}], " ", "dummies", " ", "in", " ", 
    RowBox[{"expr", ".", " ", "This"}], " ", "does", " ", "not", " ", "act", " ",
     "on", " ", "scalar", " ", "arguments", " ", "of", " ", "functions"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FormVarD", "[", 
       RowBox[{"form_", ",", "met_"}], "]"}], "[", "expr_", "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"TopRankQ", "[", "expr", "]"}], "&&", 
        RowBox[{"ScalarQ", "[", "expr", "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"FormVarD", "[", 
         RowBox[{"form", ",", "met"}], "]"}], "[", 
        RowBox[{
         RowBox[{"ReplaceDummies", "@", "expr"}], ",", "1"}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Throw", "@", 
        RowBox[{"Message", "[", 
         RowBox[{
          RowBox[{"General", "::", "error1"}], 
          ",", "\"\<Can only take variational derivative of top-rank \
form.\>\""}], "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Thread", " ", "over", " ", "Plus"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FormVarD", "[", 
       RowBox[{"form_", ",", "met_"}], "]"}], "[", 
      RowBox[{"expr_Plus", ",", "rest_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"FormVarD", "[", 
         RowBox[{"form", ",", "met"}], "]"}], "[", 
        RowBox[{"#", ",", "rest"}], "]"}], "&"}], "/@", "expr"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FormVarD", "[", 
       RowBox[{"form_", ",", "met_"}], "]"}], "[", 
      RowBox[{"expr_SeriesData", ",", "rest_"}], "]"}], ":=", 
     RowBox[{"xAct`xTensor`Private`SeriesDataMap", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"FormVarD", "[", 
          RowBox[{"form", ",", "met"}], "]"}], "[", 
         RowBox[{"#", ",", "rest"}], "]"}], "&"}], ",", "expr"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"FormVarD", " ", "on", " ", 
     RowBox[{"products", ":", " ", 
      RowBox[{"sum", " ", "of", " ", 
       RowBox[{"VarDtake", "'"}], "s", " ", "of", " ", "elements"}]}]}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FormVarD", "[", 
       RowBox[{"form_", ",", "met_"}], "]"}], "[", 
      RowBox[{"expr_Times", ",", "rest_"}], "]"}], ":=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"grades", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Grade", "[", 
            RowBox[{"#", ",", "Wedge"}], "]"}], "&"}], "/@", 
          RowBox[{"List", "@@", "expr"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "@", 
            RowBox[{"Position", "[", 
             RowBox[{"grades", ",", 
              RowBox[{"_", "?", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"#", "=!=", "0"}], "&"}], ")"}]}], ",", "1", ",", 
              RowBox[{"Heads", "\[Rule]", "False"}]}], "]"}]}], ">", "1"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"Throw", "[", 
           RowBox[{"Message", "[", 
            RowBox[{
             RowBox[{"FormVarD", "::", "error1"}], 
             ",", "\"\<Found Times product of nonscalar forms: \>\"", ",", 
             "expr"}], "]"}], "]"}]}], "]"}], ";", "\t", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"FormVarDtake", "[", 
           RowBox[{"form", ",", "met", ",", "rest", ",", 
            RowBox[{"List", "@@", "expr"}], ",", "count"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"count", ",", 
            RowBox[{"Length", "@", "expr"}]}], "}"}]}], "]"}]}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"FormVarD", " ", "on", " ", 
      RowBox[{"wedges", ":", " ", 
       RowBox[{"sum", " ", "of", " ", 
        RowBox[{"FormVarDtake", "'"}], "s", " ", "of", " ", 
        RowBox[{"elements", ".", "\[IndentingNewLine]", "Note"}], " ", "the", 
        " ", "use", " ", "of", " ", "sumgrades", " ", "for", " ", 
        "reordering", " ", "the", " ", "Wedge"}]}]}], ",", " ", 
     RowBox[{"as", " ", "described", " ", 
      RowBox[{"above", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FormVarD", "[", 
       RowBox[{"form_", ",", "met_"}], "]"}], "[", 
      RowBox[{"expr_Wedge", ",", "rest_"}], "]"}], ":=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"grades", "=", 
         RowBox[{
          RowBox[{
           RowBox[{"Grade", "[", 
            RowBox[{"#", ",", "Wedge"}], "]"}], "&"}], "/@", 
          RowBox[{"List", "@@", "expr"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"sumgrades", "=", 
           RowBox[{"FoldList", "[", 
            RowBox[{"Plus", ",", "0", ",", "grades"}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "^", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"grades", "[", 
                RowBox[{"[", "count", "]"}], "]"}], "*", " ", 
               RowBox[{"sumgrades", "[", 
                RowBox[{"[", "count", "]"}], "]"}]}], ")"}]}], 
            RowBox[{"FormVarDtake", "[", 
             RowBox[{"form", ",", "met", ",", "rest", ",", 
              RowBox[{"List", "@@", "expr"}], ",", "count"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"count", ",", 
             RowBox[{"Length", "@", "expr"}]}], "}"}]}], "]"}]}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "FormVarD", " ", "element", " ", "n", " ", "of", " ", "a", " ", "list", " ",
      "of", " ", "Wedge", " ", "factors", " ", 
     RowBox[{"(", 
      RowBox[{"no", " ", 
       RowBox[{"sign", "--"}], "it", " ", "was", " ", "included", " ", 
       "above"}], ")"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FormVarDtake", "[", 
      RowBox[{
      "form_", ",", "met_", ",", "rest_", ",", "list_List", ",", 
       "n_Integer"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"FormVarD", "[", 
       RowBox[{"form", ",", "met"}], "]"}], "[", 
      RowBox[{
       RowBox[{"list", "[", 
        RowBox[{"[", "n", "]"}], "]"}], ",", 
       RowBox[{"Wedge", "[", 
        RowBox[{
         RowBox[{"Wedge", "@@", 
          RowBox[{"Drop", "[", 
           RowBox[{"list", ",", 
            RowBox[{"{", "n", "}"}]}], "]"}]}], ",", "rest"}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Scalar", " ", 
      RowBox[{"functions", ".", " ", "Multiargument"}], " ", "generalization",
       " ", "contributed", " ", "by", " ", 
      RowBox[{"Leo", ".", " ", "multiD"}], " ", "is", " ", "not", " ", 
      "enough", " ", 
      RowBox[{"here", ".", "\[IndentingNewLine]", " ", "Since"}], " ", 
      "operating", " ", "on", " ", "a", " ", "scalar", " ", "function"}], ",",
      " ", 
     RowBox[{
      RowBox[{"don", "'"}], "t", " ", "need", " ", "extra", " ", 
      RowBox[{"Wedge", "'"}], "s"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FormVarD", "[", 
       RowBox[{"form_", ",", "met_"}], "]"}], "[", 
      RowBox[{
       RowBox[{
        RowBox[{"func_", "?", "ScalarFunctionQ"}], "[", "args__", "]"}], ",", 
       "rest_"}], "]"}], ":=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"repargs", "=", 
         RowBox[{"ReplaceDummies", "/@", 
          RowBox[{"{", "args", "}"}]}]}], "}"}], ",", 
       RowBox[{"Plus", "@@", 
        RowBox[{"MapThread", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"FormVarD", "[", 
             RowBox[{"form", ",", "met"}], "]"}], "[", 
            RowBox[{"#1", ",", 
             RowBox[{"rest", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"Derivative", "@@", "#2"}], ")"}], "@", "func"}], "@@",
                "repargs"}]}]}], "]"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{"repargs", ",", 
            RowBox[{"IdentityMatrix", "@", 
             RowBox[{"Length", "@", "repargs"}]}]}], "}"}]}], "]"}]}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Remove", " ", "Scalar", " ", "head", " ", "because", " ", "in", " ", 
     "general", " ", "the", " ", "result", " ", "is", " ", "not", " ", "a", " ",
      "scalar"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FormVarD", "[", 
       RowBox[{"form_", ",", "met_"}], "]"}], "[", 
      RowBox[{
       RowBox[{"Scalar", "[", "expr_", "]"}], ",", "rest_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"FormVarD", "[", 
       RowBox[{"form", ",", "met"}], "]"}], "[", 
      RowBox[{
       RowBox[{"ReplaceDummies", "[", "expr", "]"}], ",", "rest"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Constants", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FormVarD", "[", 
       RowBox[{"_", ",", "_"}], "]"}], "[", 
      RowBox[{
       RowBox[{"x_", "?", "ConstantQ"}], ",", "_"}], "]"}], ":=", "0"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Same", " ", 
      RowBox[{"tensor", ":", " ", 
       RowBox[{
        RowBox[{"metric", ".", " ", "Do"}], " ", "not", " ", "use", " ", 
        "ContractMetric"}]}]}], ",", " ", 
     RowBox[{"which", " ", "hides", " ", "the", " ", 
      RowBox[{"metric", ".", "\[IndentingNewLine]", 
       RowBox[{"Note", ":", " ", 
        RowBox[{
        "This", " ", "part", " ", "is", " ", "identical", " ", "to", " ", 
         "the", " ", "code", " ", "in", " ", "VarD"}]}]}]}], ",", " ", 
     RowBox[{"since", " ", 
      RowBox[{"it", "'"}], "s", " ", "only", " ", "metric", " ", "being", " ",
       "Wedged", " ", "with", " ", 
      RowBox[{"rest", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FormVarD", "[", 
       RowBox[{
        RowBox[{"metric_", "[", 
         RowBox[{"a_", ",", "b_"}], "]"}], ",", "met_"}], "]"}], "[", 
      RowBox[{
       RowBox[{
        RowBox[{"metric_Symbol", "?", "MetricQ"}], "[", 
        RowBox[{"c_", ",", "d_"}], "]"}], ",", "rest_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"xAct`xTensor`Private`metricsign", "[", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], 
      RowBox[{"ToCanonical", "[", 
       RowBox[{
        RowBox[{"rest", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"metric", "[", 
              RowBox[{
               RowBox[{"ChangeIndex", "@", "a"}], ",", "c"}], "]"}], 
             RowBox[{"metric", "[", 
              RowBox[{
               RowBox[{"ChangeIndex", "@", "b"}], ",", "d"}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"metric", "[", 
              RowBox[{
               RowBox[{"ChangeIndex", "@", "a"}], ",", "d"}], "]"}], 
             RowBox[{"metric", "[", 
              RowBox[{
               RowBox[{"ChangeIndex", "@", "b"}], ",", "c"}], "]"}]}]}], 
           ")"}], "/", "2"}]}], ",", 
        RowBox[{"UseMetricOnVBundle", "\[Rule]", "None"}]}], "]"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Same", " ", 
      RowBox[{"tensor", ".", " ", "Place"}], " ", "indices", " ", "in", " ", 
      "proper", " ", "delta", " ", 
      RowBox[{"positions", ".", " ", 
       RowBox[{"QUESTION", ":", " ", 
        RowBox[{
        "could", " ", "this", " ", "be", " ", "problematic", " ", "for", " ", 
         
         RowBox[{"spinors", "?", "\[IndentingNewLine]", "Note"}]}], ":", " ", 
        
        RowBox[{
        "This", " ", "part", " ", "is", " ", "identical", " ", "to", " ", 
         "the", " ", "code", " ", "in", " ", "VarD"}]}]}]}], ",", " ", 
     RowBox[{"since", " ", 
      RowBox[{"it", "'"}], "s", " ", "only", " ", "deltas", " ", "being", " ",
       "Wedged", " ", "with", " ", 
      RowBox[{"rest", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FormVarD", "[", 
       RowBox[{
        RowBox[{"form_", "[", "inds1___", "]"}], ",", "met_"}], "]"}], "[", 
      RowBox[{
       RowBox[{
        RowBox[{"form_", "?", "xTensorQ"}], "[", "inds2___", "]"}], ",", 
       "rest_"}], "]"}], ":=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"clist", "=", 
         RowBox[{"ChangeIndex", "/@", 
          RowBox[{"IndexList", "[", "inds1", "]"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ToCanonical", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"ImposeSymmetry", "[", 
           RowBox[{
            RowBox[{"Inner", "[", 
             RowBox[{"xAct`xTensor`Private`varddelta", ",", "clist", ",", 
              RowBox[{"IndexList", "[", "inds2", "]"}], ",", "Times"}], "]"}],
             ",", "clist", ",", 
            RowBox[{"SymmetryGroupOfTensor", "[", 
             RowBox[{"form", "[", "inds1", "]"}], "]"}]}], "]"}], "rest"}], ",", 
         RowBox[{"UseMetricOnVBundle", "\[Rule]", "None"}]}], "]"}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"A", " ", "different", " ", "tensor"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FormVarD", "[", 
       RowBox[{
        RowBox[{"form1_", "[", "inds1___", "]"}], ",", "met_"}], "]"}], "[", 
      RowBox[{
       RowBox[{
        RowBox[{"form2_", "?", "xTensorQ"}], "[", "inds2___", "]"}], ",", 
       "rest_"}], "]"}], ":=", 
     RowBox[{"0", "/;", 
      RowBox[{"!", 
       RowBox[{"ImplicitTensorDepQ", "[", 
        RowBox[{"form2", ",", "form1"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Hodge", " ", "identity"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FormVarD", "[", 
       RowBox[{"form_", ",", "met_"}], "]"}], "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Hodge", "[", "met_", "]"}], "[", "expr_", "]"}], ",", 
       "rest_"}], "]"}], ":=", 
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"k", "=", 
          RowBox[{"Grade", "[", 
           RowBox[{"expr", ",", "Wedge"}], "]"}]}], ",", 
         RowBox[{"n", "=", 
          RowBox[{"DimOfMetric", "@", "met"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"k", 
           RowBox[{"(", 
            RowBox[{"n", "-", "k"}], ")"}]}], ")"}]}], 
        RowBox[{
         RowBox[{"FormVarD", "[", 
          RowBox[{"form", ",", "met"}], "]"}], "[", 
         RowBox[{"expr", ",", 
          RowBox[{
           RowBox[{"Hodge", "[", "met", "]"}], "@", "rest"}]}], "]"}]}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"diff", " ", "\[Rule]", " ", 
     RowBox[{
     "Replaced", " ", "by", " ", "Diff", " ", "to", " ", "adjust", " ", "to", 
      " ", "the", " ", "new", " ", 
      RowBox[{"notation", ".", " ", "Dropped"}], " ", 
      RowBox[{"cd", ".", " ", "Added"}], " ", "back", " ", 
      RowBox[{"PD", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FormVarD", "[", 
       RowBox[{"form_", ",", "met_"}], "]"}], "[", 
      RowBox[{
       RowBox[{"Diff", "[", 
        RowBox[{"expr_", ",", "PD"}], "]"}], ",", "rest_"}], "]"}], ":=", 
     RowBox[{"-", 
      RowBox[{
       RowBox[{"FormVarD", "[", 
        RowBox[{"form", ",", "met"}], "]"}], "[", 
       RowBox[{"expr", ",", 
        RowBox[{
         RowBox[{"Hodge", "[", "met", "]"}], "@", 
         RowBox[{
          RowBox[{"Codiff", "[", "met", "]"}], "[", 
          RowBox[{
           RowBox[{"InvHodge", "[", "met", "]"}], "@", "rest"}], "]"}]}]}], 
       "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"codiff", " ", "\[Rule]", " ", 
     RowBox[{
     "Replaced", " ", "by", " ", "Codiff", " ", "to", " ", "adjust", " ", 
      "to", " ", "the", " ", "new", " ", 
      RowBox[{"notation", ".", " ", "Dropped"}], " ", "cd", " ", "and", " ", 
      "replaced", " ", "ExtCovDiff", " ", "by", " ", 
      RowBox[{"Diff", " ", ".", " ", "Added"}], " ", "back", " ", "covd"}]}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"FormVarD", "[", 
       RowBox[{"form_", ",", "met_"}], "]"}], "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Codiff", "[", "met_", "]"}], "[", 
        RowBox[{"expr_", ",", 
         RowBox[{"covd_", "?", "CovDQ"}]}], "]"}], ",", "rest_"}], "]"}], ":=", 
     RowBox[{"-", 
      RowBox[{
       RowBox[{"FormVarD", "[", 
        RowBox[{"form", ",", "met"}], "]"}], "[", 
       RowBox[{"expr", ",", 
        RowBox[{
         RowBox[{"Hodge", "[", "met", "]"}], "@", 
         RowBox[{"Diff", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"InvHodge", "[", "met", "]"}], "@", "rest"}], ",", 
           "covd"}], "]"}]}]}], "]"}]}]}], ";"}]}]}]], "Input",
 InitializationCell->
  True,ExpressionUUID->"d5bdcb4f-c1e0-423b-8ffc-c33f6df51729"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["5. End private and package", "Subsection",
 FontColor->RGBColor[
  0, 0, 1],ExpressionUUID->"8c7d4183-c87b-41a2-89b7-431762047990"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"End", "[", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EndPackage", "[", "]"}], ";"}]}], "Input",
 InitializationCell->
  True,ExpressionUUID->"fced9d7b-c963-4579-ad7a-0ce94c7e8864"]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowSize->{1228, 611},
WindowMargins->{{3, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"FileOutlineCache"->False},
ShowSelection->True,
CellLabelAutoDelete->True,
Magnification:>1. Inherited,
FrontEndVersion->"15.0 for Mac OS X ARM (64-bit) (December 16, 2025)",
StyleDefinitions->"Default.nb",
$CellContext`TrackCellChangeTimes -> False,
ExpressionUUID->"b3e7b92d-b00d-4c53-ab06-9f90e40329f4"
]

