Notebook[{
Cell[BoxData[GridBox[{
   {Cell["XTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"MakeAnsatz\"\>":>Documentation`HelpLookup[
       "paclet:xTras/ref/MakeAnsatz"], "\<\"ConstantSymbolsOf\"\>":>
       Documentation`HelpLookup["paclet:xTras/ref/ConstantSymbolsOf"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"xTras/ref/DefNiceConstantSymbol\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["xTras/ref/DefNiceConstantSymbol"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/xTras/ref/\
DefNiceConstantSymbol.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "xTras/ref/DefNiceConstantSymbol", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell[CellGroupData[{

Cell["DefNiceConstantSymbol", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DefNiceConstantSymbol", "[", 
       RowBox[{
        StyleBox["c", "TI"], ",", " ", 
        StyleBox["i", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]defines the constant symbol ",
     Cell[BoxData["ci"], "InlineFormula"],
     " that prints as ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["c", "i"], TraditionalForm]], "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DefNiceConstantSymbol", "[", 
       RowBox[{
        StyleBox["c", "TI"], ",", " ", 
        StyleBox["i", "TI"], 
        StyleBox[",", "TI"], 
        StyleBox[" ", "TI"], 
        StyleBox["j", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]defines the constant symbol ",
     Cell[BoxData["cij"], "InlineFormula"],
     " that prints as ",
     Cell[BoxData[
      FormBox[
       SubsuperscriptBox["c", "i", "j"], TraditionalForm]], "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DefNiceConstantSymbol", "[", 
       RowBox[{
        StyleBox["c", "TI"], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["i", "TI"], "1"], 
          StyleBox[",", "TI"], 
          StyleBox[" ", "TI"], 
          SubscriptBox[
           StyleBox["i", "TI"], "2"], 
          StyleBox[",", "TI"], 
          StyleBox["...", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]defines the constant symbol ",
     Cell[BoxData["ci1i2"], "InlineFormula"],
     " that prints as ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["c", 
        RowBox[{
         SubscriptBox["i", "1"], 
         SubscriptBox["i", "2"]}]], TraditionalForm]], "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DefNiceConstantSymbol", "[", 
       RowBox[{
        StyleBox["c", "TI"], ",", "  ", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["i", "TI"], "1"], 
          StyleBox[",", "TI"], 
          StyleBox[" ", "TI"], 
          SubscriptBox[
           StyleBox["i", "TI"], "2"], 
          StyleBox[",", "TI"], 
          StyleBox["...", "TI"]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["j", "TI"], "1"], 
          StyleBox[",", "TI"], 
          StyleBox[" ", "TI"], 
          SubscriptBox[
           StyleBox["j", "TI"], "2"], 
          StyleBox[",", "TI"], 
          StyleBox["...", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]defines the constant symbol ",
     Cell[BoxData["ci1i2j1j2"], "InlineFormula"],
     " that prints as ",
     Cell[BoxData[
      FormBox[
       SubsuperscriptBox["c", 
        RowBox[{
         SubscriptBox["i", "1"], " ", 
         SubscriptBox["i", "2"]}], 
        RowBox[{
         SubscriptBox["j", "1"], " ", 
         SubscriptBox["j", "2"]}]], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(1)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->296331386],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->427027109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefNiceConstantSymbol", "[", 
  RowBox[{"c", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146929421],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   SubsuperscriptBox["c", "1", ""],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`c1,
  Editable->False]], "Output",
 CellLabel->"Out[1]=",
 CellID->1984068344]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefNiceConstantSymbol", "[", 
  RowBox[{"c", ",", "1", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->110586992],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   SubsuperscriptBox["c", "1", "2"],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`c12,
  Editable->False]], "Output",
 CellLabel->"Out[2]=",
 CellID->1062219889]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefNiceConstantSymbol", "[", 
  RowBox[{"c", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->698116912],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   SubsuperscriptBox["c", "123", ""],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`c123,
  Editable->False]], "Output",
 CellLabel->"Out[3]=",
 CellID->1547776423]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefNiceConstantSymbol", "[", 
  RowBox[{"c", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1008925250],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   SubsuperscriptBox["c", "123", "45"],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`c12345,
  Editable->False]], "Output",
 CellLabel->"Out[4]=",
 CellID->475800038]
}, Open  ]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MakeAnsatz",
    BaseStyle->"Link",
    ButtonData->"paclet:xTras/ref/MakeAnsatz"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConstantSymbolsOf",
    BaseStyle->"Link",
    ButtonData->"paclet:xTras/ref/ConstantSymbolsOf"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DefNiceConstantSymbol - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "xTras package", ButtonData -> "paclet:xTras/guide/xTras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 10, 30, 13, 12, 45.544176}", 
    "history" -> {"1.2.0", "", "", ""}, "context" -> "xTras`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "xTras Package Symbol", "language" -> "en", "paclet" -> "xTras Package", 
    "status" -> "None", "summary" -> 
    "DefNiceConstantSymbol[c, i] defines the constant symbol ci that prints \
as c_i.DefNiceConstantSymbol[c, i, j] defines the constant symbol cij that \
prints as c_i^j.DefNiceConstantSymbol[c, {i_1, i_2, ...}] defines the \
constant symbol ci1i2 that prints as c Subscript[i, 1] Subscript[i, \
2].DefNiceConstantSymbol[c, {i_1, i_2, ...}, {j_1, j_2, ...}] defines the \
constant symbol ci1i2j1j2 that prints as c_i_1\\ i_2^j_1\\ j_2.", 
    "synonyms" -> {}, "title" -> "DefNiceConstantSymbol", "titlemodifier" -> 
    "", "windowtitle" -> "DefNiceConstantSymbol", "type" -> "Symbol", "uri" -> 
    "xTras/ref/DefNiceConstantSymbol"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

