Notebook[{
Cell[BoxData[GridBox[{
   {Cell["XTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[BoxData[
     ActionMenuBox[
      FrameBox["\<\"URL \[RightGuillemet]\"\>",
       StripOnInput->False], {"\<\"xTras/ref/DerivativeOrder\"\>":>
      None, "\<\"Copy Mathematica url\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell["xTras/ref/DerivativeOrder"]}, Visible -> False]]; 
       SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; Null], 
      Delimiter, "\<\"Copy web url\"\>":>
      Module[{DocumentationSearch`Private`nb$}, 
       DocumentationSearch`Private`nb$ = NotebookPut[
          Notebook[{
            Cell[
             BoxData[
              MakeBoxes[
               Hyperlink[
               "http://reference.wolfram.com/mathematica/xTras/ref/\
DerivativeOrder.html"], StandardForm]], "Input", TextClipboardType -> 
             "PlainText"]}, Visible -> False]]; 
       SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
       FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
       NotebookClose[DocumentationSearch`Private`nb$]; 
       Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
        NotebookLocate[{
          URL[
           StringJoin[
           "http://reference.wolfram.com/mathematica/", 
            "xTras/ref/DerivativeOrder", ".html"]], None}]}]},
      Appearance->None,
      MenuAppearance->Automatic]],
     LineSpacing->{1.4, 0}]], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell[CellGroupData[{

Cell["DerivativeOrder", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DerivativeOrder", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the order of derivatives of ",
     StyleBox["expr", "TI"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DerivativeOrder", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["cd", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]only counts the covariant derivative ",
     StyleBox["cd", "TI"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "NotesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       Cell[
        BoxData[
         ButtonBox[
          FrameBox[
           StyleBox[
            RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"], 
           StripOnInput -> False], Appearance -> {Automatic, None}, BaseStyle -> 
          None, ButtonFunction :> (FrontEndExecute[{
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], All, ButtonCell], 
             FrontEndToken["OpenCloseGroup"], 
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], After, CellContents]}]& ), 
          Evaluator -> None, Method -> "Preemptive"]]]], "NotesSection", 
      CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Details"}], "NotesSection", 
        CellSize -> {5000, Inherited}], Appearance -> {Automatic, None}, 
       BaseStyle -> None, ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& ), Evaluator -> 
       None, Method -> "Preemptive"]]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->154272689],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell["\<\
The order of derivatives is the maximum number of derivatives appearing.\
\>", "Notes",
 CellID->1067943069],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(1)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->848322094],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->605501425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DerivativeOrder", "[", 
  RowBox[{"metric", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->889961219],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[1]=",
 CellID->354606378]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DerivativeOrder", "[", 
  RowBox[{
   RowBox[{"PD", "[", "c", "]"}], "@", 
   RowBox[{"metric", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->133442708],

Cell[BoxData["1"], "Output",
 CellLabel->"Out[2]=",
 CellID->798665888]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DerivativeOrder", "[", 
  RowBox[{"RicciCD", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->602274621],

Cell[BoxData["2"], "Output",
 CellLabel->"Out[3]=",
 CellID->1339126836]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DerivativeOrder", "[", 
  RowBox[{
   RowBox[{"CD", "[", "a", "]"}], "@", 
   RowBox[{"RicciCD", "[", 
    RowBox[{"b", ",", "c"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1076112092],

Cell[BoxData["3"], "Output",
 CellLabel->"Out[4]=",
 CellID->108655210]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DerivativeOrder", "[", 
  RowBox[{
   RowBox[{"RicciScalarCD", "[", "]"}], "^", "8"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->807014520],

Cell[BoxData["16"], "Output",
 CellLabel->"Out[5]=",
 CellID->2133806835]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DerivativeOrder", "[", 
  RowBox[{
   RowBox[{"metric", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "+", 
   RowBox[{"RicciCD", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->2062054592],

Cell[BoxData["2"], "Output",
 CellLabel->"Out[6]=",
 CellID->860432458]
}, Open  ]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DerivativeOrder - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "xTras package", ButtonData -> "paclet:xTras/guide/xTras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 10, 30, 13, 12, 49.026845}", 
    "history" -> {"1.0.0", "", "", ""}, "context" -> "xTras`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "xTras Package Symbol", "language" -> "en", "paclet" -> "xTras Package", 
    "status" -> "None", "summary" -> 
    "DerivativeOrder[expr] gives the order of derivatives of expr. \
DerivativeOrder[expr, cd] only counts the covariant derivative cd.", 
    "synonyms" -> {}, "title" -> "DerivativeOrder", "titlemodifier" -> "", 
    "windowtitle" -> "DerivativeOrder", "type" -> "Symbol", "uri" -> 
    "xTras/ref/DerivativeOrder"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

