Notebook[{
Cell[BoxData[GridBox[{
   {Cell["XTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"xTras package\"\>":>
       Documentation`HelpLookup["paclet:xTras/guide/xTras"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"xTras/ref/ImplodedTensorValues\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["xTras/ref/ImplodedTensorValues"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/xTras/ref/\
ImplodedTensorValues.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "xTras/ref/ImplodedTensorValues", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell[CellGroupData[{

Cell["ImplodedTensorValues", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ImplodedTensorValues", "[", 
       RowBox[{
        ButtonBox[
         StyleBox["cd", "TI"],
         BaseStyle->"Link"], ",", " ", 
        StyleBox[
         ButtonBox["T",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/T"], "TI"], ",", " ", 
        StyleBox["B", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]computes the values of the covariant derivative ",
     StyleBox["cd", "TI"],
     " of the tensor ",
     StyleBox["T", "TI"],
     " in the basis ",
     StyleBox["B.", "TI"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "NotesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       Cell[
        BoxData[
         ButtonBox[
          FrameBox[
           StyleBox[
            RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"], 
           StripOnInput -> False], Appearance -> {Automatic, None}, BaseStyle -> 
          None, ButtonFunction :> (FrontEndExecute[{
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], All, ButtonCell], 
             FrontEndToken["OpenCloseGroup"], 
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], After, CellContents]}]& ), 
          Evaluator -> None, Method -> "Preemptive"]]]], "NotesSection", 
      CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Details"}], "NotesSection", 
        CellSize -> {5000, Inherited}], Appearance -> {Automatic, None}, 
       BaseStyle -> None, ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& ), Evaluator -> 
       None, Method -> "Preemptive"]]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->561491116],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[{
 "ImplodedTensorValues stores the values in the imploded tensor ",
 Cell[BoxData["CDT"], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "In the input both ",
 StyleBox["cd", "TI"],
 " and ",
 StyleBox["T", "TI"],
 " do not take indices."
}], "Notes",
 CellID->891939175],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(1)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->938041694],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->989298431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"v", "[", 
    RowBox[{"-", "a"}], "]"}], ",", "M"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1385858165],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[92]:=",
 CellID->510543793]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dim", "=", "4"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1512359186],

Cell[BoxData["4"], "Output",
 CellLabel->"Out[2]=",
 CellID->604393210]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefChart", "[", 
  RowBox[{"B", ",", "M", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "[", "]"}], ",", 
     RowBox[{"r", "[", "]"}], ",", 
     RowBox[{"\[Theta]", "[", "]"}], ",", 
     RowBox[{"\[Phi]", "[", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->439030160],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"t", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`t[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[94]:=",
 CellID->26088028],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"r", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`r[], ". ", ""],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[94]:=",
 CellID->374822608],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Theta]", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Theta][], ". ", ""],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[94]:=",
 CellID->1074036005],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Phi]", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Phi][], ". ", ""],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[94]:=",
 CellID->1723083000],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefBasis", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"basis \"\>", "\[InvisibleSpace]", "B", 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xCoba`DefBasis, ": Defining ", "basis ", $CellContext`B, ". ", 
   ""],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[94]:=",
 CellID->1039001205],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefCovD", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"parallel derivative \"\>", "\[InvisibleSpace]", 
   RowBox[{"PDB", "[", 
    RowBox[{"-", "a"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefCovD, ": Defining ", "parallel derivative ", 
   $CellContext`PDB[-$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[94]:=",
 CellID->1303718678],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing torsion tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"TorsionPDB", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing torsion tensor ", 
   $CellContext`TorsionPDB[$CellContext`a, -$CellContext`b, -$CellContext`c], 
   ". ", ""],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[94]:=",
 CellID->824170805],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"symmetric Christoffel tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"ChristoffelPDB", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", 
   "symmetric Christoffel tensor ", 
   $CellContext`ChristoffelPDB[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[94]:=",
 CellID->569196485],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Riemann tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RiemannPDB", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", "d"}], "]"}], "\[InvisibleSpace]", "\<\". \"\>",
    "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Riemann tensor ", 
   $CellContext`RiemannPDB[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[94]:=",
 CellID->1593159657],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"vanishing Ricci tensor \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"RicciPDB", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "vanishing Ricci tensor ", 
   $CellContext`RicciPDB[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[94]:=",
 CellID->1408244403],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric +1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaUpB", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric +1 density ", 
   $CellContext`etaUpB[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[94]:=",
 CellID->946407634],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"antisymmetric -1 density \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"etaDownB", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}], ",", 
     RowBox[{"-", "d"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "antisymmetric -1 density ", 
   $CellContext`etaDownB[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
-$CellContext`d], ". ", ""],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[94]:=",
 CellID->2009214956]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImplodedTensorValues", "[", 
  RowBox[{"CD", ",", "v", ",", "B"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1842900064],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"weight +2 density \"\>", "\[InvisibleSpace]", 
   RowBox[{"DetmetricB", "[", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"Determinant.\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefTensor, ": Defining ", "weight +2 density ", 
   $CellContext`DetmetricB[], ". ", "Determinant."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[95]:=",
 CellID->464734967],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"ChristoffelCDPDB", "[", 
    RowBox[{"a", ",", 
     RowBox[{"-", "b"}], ",", 
     RowBox[{"-", "c"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`ChristoffelCDPDB[$CellContext`a, -$CellContext`b, \
-$CellContext`c], ". ", ""],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[95]:=",
 CellID->402566230],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[EmptyDownTriangle]v", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDv[{0, -$CellContext`B}, {0, -$CellContext`B}],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
         0, -$CellContext`B}, {0, -$CellContext`B}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{0, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
        0, -$CellContext`B}, {0, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{1, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
        0, -$CellContext`B}, {0, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{2, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
        0, -$CellContext`B}, {0, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{3, -$CellContext`B}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1., 0., 0.]], 
         StyleBox["0",
          FontColor->RGBColor[1., 0., 0.]]], GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDB[{0, -$CellContext`B}][
       $CellContext`v[{0, -$CellContext`B}]],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "CDv"}],
  SequenceForm[
  "Added independent rule ", $CellContext`CDv[{0, -$CellContext`B}, {
     0, -$CellContext`B}] -> -$CellContext`ChristoffelCDPDB[{
       0, $CellContext`B}, {0, -$CellContext`B}, {
       0, -$CellContext`B}] $CellContext`v[{
       0, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      1, $CellContext`B}, {0, -$CellContext`B}, {
      0, -$CellContext`B}] $CellContext`v[{
      1, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      2, $CellContext`B}, {0, -$CellContext`B}, {
      0, -$CellContext`B}] $CellContext`v[{
      2, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      3, $CellContext`B}, {0, -$CellContext`B}, {
      0, -$CellContext`B}] $CellContext`v[{
      3, -$CellContext`B}] + $CellContext`PDB[{0, -$CellContext`B}][
      $CellContext`v[{0, -$CellContext`B}]], " for tensor ", $CellContext`CDv],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[95]:=",
 CellID->1357139560],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[EmptyDownTriangle]v", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDv[{1, -$CellContext`B}, {0, -$CellContext`B}],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
         0, -$CellContext`B}, {1, -$CellContext`B}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{0, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
        0, -$CellContext`B}, {1, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{1, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
        0, -$CellContext`B}, {1, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{2, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
        0, -$CellContext`B}, {1, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{3, -$CellContext`B}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1., 0., 0.]], 
         StyleBox["0",
          FontColor->RGBColor[1., 0., 0.]]], GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDB[{0, -$CellContext`B}][
       $CellContext`v[{1, -$CellContext`B}]],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "CDv"}],
  SequenceForm[
  "Added independent rule ", $CellContext`CDv[{1, -$CellContext`B}, {
     0, -$CellContext`B}] -> -$CellContext`ChristoffelCDPDB[{
       0, $CellContext`B}, {0, -$CellContext`B}, {
       1, -$CellContext`B}] $CellContext`v[{
       0, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      1, $CellContext`B}, {0, -$CellContext`B}, {
      1, -$CellContext`B}] $CellContext`v[{
      1, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      2, $CellContext`B}, {0, -$CellContext`B}, {
      1, -$CellContext`B}] $CellContext`v[{
      2, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      3, $CellContext`B}, {0, -$CellContext`B}, {
      1, -$CellContext`B}] $CellContext`v[{
      3, -$CellContext`B}] + $CellContext`PDB[{0, -$CellContext`B}][
      $CellContext`v[{1, -$CellContext`B}]], " for tensor ", $CellContext`CDv],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[95]:=",
 CellID->1020770133],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[EmptyDownTriangle]v", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDv[{2, -$CellContext`B}, {0, -$CellContext`B}],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
         0, -$CellContext`B}, {2, -$CellContext`B}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{0, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
        0, -$CellContext`B}, {2, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{1, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
        0, -$CellContext`B}, {2, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{2, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
        0, -$CellContext`B}, {2, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{3, -$CellContext`B}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1., 0., 0.]], 
         StyleBox["0",
          FontColor->RGBColor[1., 0., 0.]]], GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDB[{0, -$CellContext`B}][
       $CellContext`v[{2, -$CellContext`B}]],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "CDv"}],
  SequenceForm[
  "Added independent rule ", $CellContext`CDv[{2, -$CellContext`B}, {
     0, -$CellContext`B}] -> -$CellContext`ChristoffelCDPDB[{
       0, $CellContext`B}, {0, -$CellContext`B}, {
       2, -$CellContext`B}] $CellContext`v[{
       0, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      1, $CellContext`B}, {0, -$CellContext`B}, {
      2, -$CellContext`B}] $CellContext`v[{
      1, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      2, $CellContext`B}, {0, -$CellContext`B}, {
      2, -$CellContext`B}] $CellContext`v[{
      2, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      3, $CellContext`B}, {0, -$CellContext`B}, {
      2, -$CellContext`B}] $CellContext`v[{
      3, -$CellContext`B}] + $CellContext`PDB[{0, -$CellContext`B}][
      $CellContext`v[{2, -$CellContext`B}]], " for tensor ", $CellContext`CDv],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[95]:=",
 CellID->1984253095],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[EmptyDownTriangle]v", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["3",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDv[{3, -$CellContext`B}, {0, -$CellContext`B}],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["3",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
         0, -$CellContext`B}, {3, -$CellContext`B}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{0, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
        0, -$CellContext`B}, {3, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{1, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
        0, -$CellContext`B}, {3, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{2, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
        0, -$CellContext`B}, {3, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{3, -$CellContext`B}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1., 0., 0.]], 
         StyleBox["0",
          FontColor->RGBColor[1., 0., 0.]]], GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDB[{0, -$CellContext`B}][
       $CellContext`v[{3, -$CellContext`B}]],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "CDv"}],
  SequenceForm[
  "Added independent rule ", $CellContext`CDv[{3, -$CellContext`B}, {
     0, -$CellContext`B}] -> -$CellContext`ChristoffelCDPDB[{
       0, $CellContext`B}, {0, -$CellContext`B}, {
       3, -$CellContext`B}] $CellContext`v[{
       0, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      1, $CellContext`B}, {0, -$CellContext`B}, {
      3, -$CellContext`B}] $CellContext`v[{
      1, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      2, $CellContext`B}, {0, -$CellContext`B}, {
      3, -$CellContext`B}] $CellContext`v[{
      2, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      3, $CellContext`B}, {0, -$CellContext`B}, {
      3, -$CellContext`B}] $CellContext`v[{
      3, -$CellContext`B}] + $CellContext`PDB[{0, -$CellContext`B}][
      $CellContext`v[{3, -$CellContext`B}]], " for tensor ", $CellContext`CDv],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[95]:=",
 CellID->1068213402],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[EmptyDownTriangle]v", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDv[{0, -$CellContext`B}, {1, -$CellContext`B}],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
         1, -$CellContext`B}, {0, -$CellContext`B}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{0, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
        1, -$CellContext`B}, {0, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{1, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
        1, -$CellContext`B}, {0, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{2, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
        1, -$CellContext`B}, {0, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{3, -$CellContext`B}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1., 0., 0.]], 
         StyleBox["1",
          FontColor->RGBColor[1., 0., 0.]]], GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDB[{1, -$CellContext`B}][
       $CellContext`v[{0, -$CellContext`B}]],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "CDv"}],
  SequenceForm[
  "Added independent rule ", $CellContext`CDv[{0, -$CellContext`B}, {
     1, -$CellContext`B}] -> -$CellContext`ChristoffelCDPDB[{
       0, $CellContext`B}, {1, -$CellContext`B}, {
       0, -$CellContext`B}] $CellContext`v[{
       0, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      1, $CellContext`B}, {1, -$CellContext`B}, {
      0, -$CellContext`B}] $CellContext`v[{
      1, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      2, $CellContext`B}, {1, -$CellContext`B}, {
      0, -$CellContext`B}] $CellContext`v[{
      2, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      3, $CellContext`B}, {1, -$CellContext`B}, {
      0, -$CellContext`B}] $CellContext`v[{
      3, -$CellContext`B}] + $CellContext`PDB[{1, -$CellContext`B}][
      $CellContext`v[{0, -$CellContext`B}]], " for tensor ", $CellContext`CDv],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[95]:=",
 CellID->499358494],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[EmptyDownTriangle]v", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDv[{1, -$CellContext`B}, {1, -$CellContext`B}],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
         1, -$CellContext`B}, {1, -$CellContext`B}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{0, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
        1, -$CellContext`B}, {1, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{1, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
        1, -$CellContext`B}, {1, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{2, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
        1, -$CellContext`B}, {1, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{3, -$CellContext`B}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1., 0., 0.]], 
         StyleBox["1",
          FontColor->RGBColor[1., 0., 0.]]], GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDB[{1, -$CellContext`B}][
       $CellContext`v[{1, -$CellContext`B}]],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "CDv"}],
  SequenceForm[
  "Added independent rule ", $CellContext`CDv[{1, -$CellContext`B}, {
     1, -$CellContext`B}] -> -$CellContext`ChristoffelCDPDB[{
       0, $CellContext`B}, {1, -$CellContext`B}, {
       1, -$CellContext`B}] $CellContext`v[{
       0, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      1, $CellContext`B}, {1, -$CellContext`B}, {
      1, -$CellContext`B}] $CellContext`v[{
      1, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      2, $CellContext`B}, {1, -$CellContext`B}, {
      1, -$CellContext`B}] $CellContext`v[{
      2, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      3, $CellContext`B}, {1, -$CellContext`B}, {
      1, -$CellContext`B}] $CellContext`v[{
      3, -$CellContext`B}] + $CellContext`PDB[{1, -$CellContext`B}][
      $CellContext`v[{1, -$CellContext`B}]], " for tensor ", $CellContext`CDv],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[95]:=",
 CellID->352116182],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[EmptyDownTriangle]v", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDv[{2, -$CellContext`B}, {1, -$CellContext`B}],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
         1, -$CellContext`B}, {2, -$CellContext`B}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{0, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
        1, -$CellContext`B}, {2, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{1, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
        1, -$CellContext`B}, {2, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{2, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
        1, -$CellContext`B}, {2, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{3, -$CellContext`B}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1., 0., 0.]], 
         StyleBox["1",
          FontColor->RGBColor[1., 0., 0.]]], GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDB[{1, -$CellContext`B}][
       $CellContext`v[{2, -$CellContext`B}]],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "CDv"}],
  SequenceForm[
  "Added independent rule ", $CellContext`CDv[{2, -$CellContext`B}, {
     1, -$CellContext`B}] -> -$CellContext`ChristoffelCDPDB[{
       0, $CellContext`B}, {1, -$CellContext`B}, {
       2, -$CellContext`B}] $CellContext`v[{
       0, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      1, $CellContext`B}, {1, -$CellContext`B}, {
      2, -$CellContext`B}] $CellContext`v[{
      1, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      2, $CellContext`B}, {1, -$CellContext`B}, {
      2, -$CellContext`B}] $CellContext`v[{
      2, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      3, $CellContext`B}, {1, -$CellContext`B}, {
      2, -$CellContext`B}] $CellContext`v[{
      3, -$CellContext`B}] + $CellContext`PDB[{1, -$CellContext`B}][
      $CellContext`v[{2, -$CellContext`B}]], " for tensor ", $CellContext`CDv],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[95]:=",
 CellID->1699223389],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[EmptyDownTriangle]v", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["3",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDv[{3, -$CellContext`B}, {1, -$CellContext`B}],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["3",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
         1, -$CellContext`B}, {3, -$CellContext`B}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{0, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
        1, -$CellContext`B}, {3, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{1, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
        1, -$CellContext`B}, {3, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{2, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
        1, -$CellContext`B}, {3, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{3, -$CellContext`B}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1., 0., 0.]], 
         StyleBox["1",
          FontColor->RGBColor[1., 0., 0.]]], GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDB[{1, -$CellContext`B}][
       $CellContext`v[{3, -$CellContext`B}]],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "CDv"}],
  SequenceForm[
  "Added independent rule ", $CellContext`CDv[{3, -$CellContext`B}, {
     1, -$CellContext`B}] -> -$CellContext`ChristoffelCDPDB[{
       0, $CellContext`B}, {1, -$CellContext`B}, {
       3, -$CellContext`B}] $CellContext`v[{
       0, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      1, $CellContext`B}, {1, -$CellContext`B}, {
      3, -$CellContext`B}] $CellContext`v[{
      1, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      2, $CellContext`B}, {1, -$CellContext`B}, {
      3, -$CellContext`B}] $CellContext`v[{
      2, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      3, $CellContext`B}, {1, -$CellContext`B}, {
      3, -$CellContext`B}] $CellContext`v[{
      3, -$CellContext`B}] + $CellContext`PDB[{1, -$CellContext`B}][
      $CellContext`v[{3, -$CellContext`B}]], " for tensor ", $CellContext`CDv],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[95]:=",
 CellID->1609961117],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[EmptyDownTriangle]v", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDv[{0, -$CellContext`B}, {2, -$CellContext`B}],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
         2, -$CellContext`B}, {0, -$CellContext`B}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{0, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
        2, -$CellContext`B}, {0, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{1, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
        2, -$CellContext`B}, {0, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{2, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
        2, -$CellContext`B}, {0, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{3, -$CellContext`B}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1., 0., 0.]], 
         StyleBox["2",
          FontColor->RGBColor[1., 0., 0.]]], GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDB[{2, -$CellContext`B}][
       $CellContext`v[{0, -$CellContext`B}]],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "CDv"}],
  SequenceForm[
  "Added independent rule ", $CellContext`CDv[{0, -$CellContext`B}, {
     2, -$CellContext`B}] -> -$CellContext`ChristoffelCDPDB[{
       0, $CellContext`B}, {2, -$CellContext`B}, {
       0, -$CellContext`B}] $CellContext`v[{
       0, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      1, $CellContext`B}, {2, -$CellContext`B}, {
      0, -$CellContext`B}] $CellContext`v[{
      1, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      2, $CellContext`B}, {2, -$CellContext`B}, {
      0, -$CellContext`B}] $CellContext`v[{
      2, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      3, $CellContext`B}, {2, -$CellContext`B}, {
      0, -$CellContext`B}] $CellContext`v[{
      3, -$CellContext`B}] + $CellContext`PDB[{2, -$CellContext`B}][
      $CellContext`v[{0, -$CellContext`B}]], " for tensor ", $CellContext`CDv],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[95]:=",
 CellID->322541219],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[EmptyDownTriangle]v", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDv[{1, -$CellContext`B}, {2, -$CellContext`B}],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
         2, -$CellContext`B}, {1, -$CellContext`B}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{0, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
        2, -$CellContext`B}, {1, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{1, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
        2, -$CellContext`B}, {1, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{2, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
        2, -$CellContext`B}, {1, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{3, -$CellContext`B}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1., 0., 0.]], 
         StyleBox["2",
          FontColor->RGBColor[1., 0., 0.]]], GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDB[{2, -$CellContext`B}][
       $CellContext`v[{1, -$CellContext`B}]],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "CDv"}],
  SequenceForm[
  "Added independent rule ", $CellContext`CDv[{1, -$CellContext`B}, {
     2, -$CellContext`B}] -> -$CellContext`ChristoffelCDPDB[{
       0, $CellContext`B}, {2, -$CellContext`B}, {
       1, -$CellContext`B}] $CellContext`v[{
       0, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      1, $CellContext`B}, {2, -$CellContext`B}, {
      1, -$CellContext`B}] $CellContext`v[{
      1, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      2, $CellContext`B}, {2, -$CellContext`B}, {
      1, -$CellContext`B}] $CellContext`v[{
      2, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      3, $CellContext`B}, {2, -$CellContext`B}, {
      1, -$CellContext`B}] $CellContext`v[{
      3, -$CellContext`B}] + $CellContext`PDB[{2, -$CellContext`B}][
      $CellContext`v[{1, -$CellContext`B}]], " for tensor ", $CellContext`CDv],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[95]:=",
 CellID->701542705],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[EmptyDownTriangle]v", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDv[{2, -$CellContext`B}, {2, -$CellContext`B}],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
         2, -$CellContext`B}, {2, -$CellContext`B}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{0, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
        2, -$CellContext`B}, {2, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{1, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
        2, -$CellContext`B}, {2, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{2, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
        2, -$CellContext`B}, {2, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{3, -$CellContext`B}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1., 0., 0.]], 
         StyleBox["2",
          FontColor->RGBColor[1., 0., 0.]]], GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDB[{2, -$CellContext`B}][
       $CellContext`v[{2, -$CellContext`B}]],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "CDv"}],
  SequenceForm[
  "Added independent rule ", $CellContext`CDv[{2, -$CellContext`B}, {
     2, -$CellContext`B}] -> -$CellContext`ChristoffelCDPDB[{
       0, $CellContext`B}, {2, -$CellContext`B}, {
       2, -$CellContext`B}] $CellContext`v[{
       0, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      1, $CellContext`B}, {2, -$CellContext`B}, {
      2, -$CellContext`B}] $CellContext`v[{
      1, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      2, $CellContext`B}, {2, -$CellContext`B}, {
      2, -$CellContext`B}] $CellContext`v[{
      2, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      3, $CellContext`B}, {2, -$CellContext`B}, {
      2, -$CellContext`B}] $CellContext`v[{
      3, -$CellContext`B}] + $CellContext`PDB[{2, -$CellContext`B}][
      $CellContext`v[{2, -$CellContext`B}]], " for tensor ", $CellContext`CDv],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[95]:=",
 CellID->1143020905],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[EmptyDownTriangle]v", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["3",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDv[{3, -$CellContext`B}, {2, -$CellContext`B}],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["3",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
         2, -$CellContext`B}, {3, -$CellContext`B}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{0, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
        2, -$CellContext`B}, {3, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{1, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
        2, -$CellContext`B}, {3, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{2, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
        2, -$CellContext`B}, {3, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{3, -$CellContext`B}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1., 0., 0.]], 
         StyleBox["2",
          FontColor->RGBColor[1., 0., 0.]]], GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDB[{2, -$CellContext`B}][
       $CellContext`v[{3, -$CellContext`B}]],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "CDv"}],
  SequenceForm[
  "Added independent rule ", $CellContext`CDv[{3, -$CellContext`B}, {
     2, -$CellContext`B}] -> -$CellContext`ChristoffelCDPDB[{
       0, $CellContext`B}, {2, -$CellContext`B}, {
       3, -$CellContext`B}] $CellContext`v[{
       0, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      1, $CellContext`B}, {2, -$CellContext`B}, {
      3, -$CellContext`B}] $CellContext`v[{
      1, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      2, $CellContext`B}, {2, -$CellContext`B}, {
      3, -$CellContext`B}] $CellContext`v[{
      2, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      3, $CellContext`B}, {2, -$CellContext`B}, {
      3, -$CellContext`B}] $CellContext`v[{
      3, -$CellContext`B}] + $CellContext`PDB[{2, -$CellContext`B}][
      $CellContext`v[{3, -$CellContext`B}]], " for tensor ", $CellContext`CDv],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[95]:=",
 CellID->1511127920],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[EmptyDownTriangle]v", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["0",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["3",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDv[{0, -$CellContext`B}, {3, -$CellContext`B}],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["3",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
         3, -$CellContext`B}, {0, -$CellContext`B}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{0, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
        3, -$CellContext`B}, {0, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{1, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
        3, -$CellContext`B}, {0, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{2, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
        3, -$CellContext`B}, {0, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{3, -$CellContext`B}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1., 0., 0.]], 
         StyleBox["3",
          FontColor->RGBColor[1., 0., 0.]]], GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDB[{3, -$CellContext`B}][
       $CellContext`v[{0, -$CellContext`B}]],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "CDv"}],
  SequenceForm[
  "Added independent rule ", $CellContext`CDv[{0, -$CellContext`B}, {
     3, -$CellContext`B}] -> -$CellContext`ChristoffelCDPDB[{
       0, $CellContext`B}, {3, -$CellContext`B}, {
       0, -$CellContext`B}] $CellContext`v[{
       0, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      1, $CellContext`B}, {3, -$CellContext`B}, {
      0, -$CellContext`B}] $CellContext`v[{
      1, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      2, $CellContext`B}, {3, -$CellContext`B}, {
      0, -$CellContext`B}] $CellContext`v[{
      2, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      3, $CellContext`B}, {3, -$CellContext`B}, {
      0, -$CellContext`B}] $CellContext`v[{
      3, -$CellContext`B}] + $CellContext`PDB[{3, -$CellContext`B}][
      $CellContext`v[{0, -$CellContext`B}]], " for tensor ", $CellContext`CDv],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[95]:=",
 CellID->1385342018],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[EmptyDownTriangle]v", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["1",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["3",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDv[{1, -$CellContext`B}, {3, -$CellContext`B}],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["3",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["1",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
         3, -$CellContext`B}, {1, -$CellContext`B}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{0, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
        3, -$CellContext`B}, {1, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{1, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
        3, -$CellContext`B}, {1, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{2, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
        3, -$CellContext`B}, {1, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{3, -$CellContext`B}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1., 0., 0.]], 
         StyleBox["3",
          FontColor->RGBColor[1., 0., 0.]]], GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDB[{3, -$CellContext`B}][
       $CellContext`v[{1, -$CellContext`B}]],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "CDv"}],
  SequenceForm[
  "Added independent rule ", $CellContext`CDv[{1, -$CellContext`B}, {
     3, -$CellContext`B}] -> -$CellContext`ChristoffelCDPDB[{
       0, $CellContext`B}, {3, -$CellContext`B}, {
       1, -$CellContext`B}] $CellContext`v[{
       0, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      1, $CellContext`B}, {3, -$CellContext`B}, {
      1, -$CellContext`B}] $CellContext`v[{
      1, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      2, $CellContext`B}, {3, -$CellContext`B}, {
      1, -$CellContext`B}] $CellContext`v[{
      2, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      3, $CellContext`B}, {3, -$CellContext`B}, {
      1, -$CellContext`B}] $CellContext`v[{
      3, -$CellContext`B}] + $CellContext`PDB[{3, -$CellContext`B}][
      $CellContext`v[{1, -$CellContext`B}]], " for tensor ", $CellContext`CDv],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[95]:=",
 CellID->425595752],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[EmptyDownTriangle]v", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["2",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["3",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDv[{2, -$CellContext`B}, {3, -$CellContext`B}],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["3",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["2",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
         3, -$CellContext`B}, {2, -$CellContext`B}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{0, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
        3, -$CellContext`B}, {2, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{1, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
        3, -$CellContext`B}, {2, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{2, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
        3, -$CellContext`B}, {2, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{3, -$CellContext`B}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1., 0., 0.]], 
         StyleBox["3",
          FontColor->RGBColor[1., 0., 0.]]], GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDB[{3, -$CellContext`B}][
       $CellContext`v[{2, -$CellContext`B}]],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "CDv"}],
  SequenceForm[
  "Added independent rule ", $CellContext`CDv[{2, -$CellContext`B}, {
     3, -$CellContext`B}] -> -$CellContext`ChristoffelCDPDB[{
       0, $CellContext`B}, {3, -$CellContext`B}, {
       2, -$CellContext`B}] $CellContext`v[{
       0, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      1, $CellContext`B}, {3, -$CellContext`B}, {
      2, -$CellContext`B}] $CellContext`v[{
      1, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      2, $CellContext`B}, {3, -$CellContext`B}, {
      2, -$CellContext`B}] $CellContext`v[{
      2, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      3, $CellContext`B}, {3, -$CellContext`B}, {
      2, -$CellContext`B}] $CellContext`v[{
      3, -$CellContext`B}] + $CellContext`PDB[{3, -$CellContext`B}][
      $CellContext`v[{2, -$CellContext`B}]], " for tensor ", $CellContext`CDv],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[95]:=",
 CellID->1867259354],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Added independent rule \"\>", "\[InvisibleSpace]", 
   RowBox[{
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[EmptyDownTriangle]v", 
         StyleBox[GridBox[{
            {" ", " "},
            {
             StyleBox["3",
              FontColor->RGBColor[1., 0., 0.]], 
             StyleBox["3",
              FontColor->RGBColor[1., 0., 0.]]}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CDv[{3, -$CellContext`B}, {3, -$CellContext`B}],
     Editable->False], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       InterpretationBox[
        StyleBox[GridBox[{
           {
            RowBox[{"\[CapitalGamma]", "[", 
             RowBox[{"\[EmptyDownTriangle]", ",", 
              StyleBox["\[ScriptCapitalD]",
               FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
            StyleBox[GridBox[{
               {
                StyleBox["0",
                 FontColor->RGBColor[1., 0., 0.]], " ", " "},
               {" ", 
                StyleBox["3",
                 FontColor->RGBColor[1., 0., 0.]], 
                StyleBox["3",
                 FontColor->RGBColor[1., 0., 0.]]}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
         3, -$CellContext`B}, {3, -$CellContext`B}],
        Editable->False]}], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{0, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
        3, -$CellContext`B}, {3, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{1, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
        3, -$CellContext`B}, {3, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{2, -$CellContext`B}],
       Editable->False]}], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {
           RowBox[{"\[CapitalGamma]", "[", 
            RowBox[{"\[EmptyDownTriangle]", ",", 
             StyleBox["\[ScriptCapitalD]",
              FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
           StyleBox[GridBox[{
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], " ", " "},
              {" ", 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
        3, -$CellContext`B}, {3, -$CellContext`B}],
       Editable->False], " ", 
      InterpretationBox[
       StyleBox[GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`v[{3, -$CellContext`B}],
       Editable->False]}], "+", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox[
         StyleBox["\[ScriptCapitalD]",
          FontColor->RGBColor[1., 0., 0.]], 
         StyleBox["3",
          FontColor->RGBColor[1., 0., 0.]]], GridBox[{
          {"v", 
           StyleBox[GridBox[{
              {" "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`PDB[{3, -$CellContext`B}][
       $CellContext`v[{3, -$CellContext`B}]],
      Editable->False]}]}], "\[InvisibleSpace]", "\<\" for tensor \"\>", 
   "\[InvisibleSpace]", "CDv"}],
  SequenceForm[
  "Added independent rule ", $CellContext`CDv[{3, -$CellContext`B}, {
     3, -$CellContext`B}] -> -$CellContext`ChristoffelCDPDB[{
       0, $CellContext`B}, {3, -$CellContext`B}, {
       3, -$CellContext`B}] $CellContext`v[{
       0, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      1, $CellContext`B}, {3, -$CellContext`B}, {
      3, -$CellContext`B}] $CellContext`v[{
      1, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      2, $CellContext`B}, {3, -$CellContext`B}, {
      3, -$CellContext`B}] $CellContext`v[{
      2, -$CellContext`B}] - $CellContext`ChristoffelCDPDB[{
      3, $CellContext`B}, {3, -$CellContext`B}, {
      3, -$CellContext`B}] $CellContext`v[{
      3, -$CellContext`B}] + $CellContext`PDB[{3, -$CellContext`B}][
      $CellContext`v[{3, -$CellContext`B}]], " for tensor ", $CellContext`CDv],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[95]:=",
 CellID->1849429067]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[EmptyDownTriangle]v", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDv[{0, -$CellContext`B}, {0, -$CellContext`B}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"\[EmptyDownTriangle]", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
              StyleBox[GridBox[{
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], " ", " "},
                 {" ", 
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
           0, -$CellContext`B}, {0, -$CellContext`B}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{0, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
          0, -$CellContext`B}, {0, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{1, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
          0, -$CellContext`B}, {0, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{2, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
          0, -$CellContext`B}, {0, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{3, -$CellContext`B}],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox[
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1., 0., 0.]], 
           StyleBox["0",
            FontColor->RGBColor[1., 0., 0.]]], GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PDB[{0, -$CellContext`B}][
         $CellContext`v[{0, -$CellContext`B}]],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[EmptyDownTriangle]v", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDv[{1, -$CellContext`B}, {0, -$CellContext`B}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"\[EmptyDownTriangle]", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
              StyleBox[GridBox[{
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], " ", " "},
                 {" ", 
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["1",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
           0, -$CellContext`B}, {1, -$CellContext`B}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{0, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
          0, -$CellContext`B}, {1, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{1, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
          0, -$CellContext`B}, {1, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{2, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
          0, -$CellContext`B}, {1, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{3, -$CellContext`B}],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox[
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1., 0., 0.]], 
           StyleBox["0",
            FontColor->RGBColor[1., 0., 0.]]], GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PDB[{0, -$CellContext`B}][
         $CellContext`v[{1, -$CellContext`B}]],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[EmptyDownTriangle]v", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDv[{2, -$CellContext`B}, {0, -$CellContext`B}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"\[EmptyDownTriangle]", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
              StyleBox[GridBox[{
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], " ", " "},
                 {" ", 
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["2",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
           0, -$CellContext`B}, {2, -$CellContext`B}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{0, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
          0, -$CellContext`B}, {2, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{1, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
          0, -$CellContext`B}, {2, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{2, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
          0, -$CellContext`B}, {2, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{3, -$CellContext`B}],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox[
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1., 0., 0.]], 
           StyleBox["0",
            FontColor->RGBColor[1., 0., 0.]]], GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PDB[{0, -$CellContext`B}][
         $CellContext`v[{2, -$CellContext`B}]],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[EmptyDownTriangle]v", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDv[{3, -$CellContext`B}, {0, -$CellContext`B}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"\[EmptyDownTriangle]", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
              StyleBox[GridBox[{
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], " ", " "},
                 {" ", 
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["3",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
           0, -$CellContext`B}, {3, -$CellContext`B}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{0, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
          0, -$CellContext`B}, {3, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{1, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
          0, -$CellContext`B}, {3, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{2, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
          0, -$CellContext`B}, {3, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{3, -$CellContext`B}],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox[
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1., 0., 0.]], 
           StyleBox["0",
            FontColor->RGBColor[1., 0., 0.]]], GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PDB[{0, -$CellContext`B}][
         $CellContext`v[{3, -$CellContext`B}]],
        Editable->False]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[EmptyDownTriangle]v", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDv[{0, -$CellContext`B}, {1, -$CellContext`B}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"\[EmptyDownTriangle]", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
              StyleBox[GridBox[{
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], " ", " "},
                 {" ", 
                  StyleBox["1",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
           1, -$CellContext`B}, {0, -$CellContext`B}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{0, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
          1, -$CellContext`B}, {0, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{1, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
          1, -$CellContext`B}, {0, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{2, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
          1, -$CellContext`B}, {0, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{3, -$CellContext`B}],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox[
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1., 0., 0.]], 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]], GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PDB[{1, -$CellContext`B}][
         $CellContext`v[{0, -$CellContext`B}]],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[EmptyDownTriangle]v", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDv[{1, -$CellContext`B}, {1, -$CellContext`B}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"\[EmptyDownTriangle]", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
              StyleBox[GridBox[{
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], " ", " "},
                 {" ", 
                  StyleBox["1",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["1",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
           1, -$CellContext`B}, {1, -$CellContext`B}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{0, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
          1, -$CellContext`B}, {1, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{1, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
          1, -$CellContext`B}, {1, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{2, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
          1, -$CellContext`B}, {1, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{3, -$CellContext`B}],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox[
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1., 0., 0.]], 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]], GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PDB[{1, -$CellContext`B}][
         $CellContext`v[{1, -$CellContext`B}]],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[EmptyDownTriangle]v", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDv[{2, -$CellContext`B}, {1, -$CellContext`B}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"\[EmptyDownTriangle]", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
              StyleBox[GridBox[{
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], " ", " "},
                 {" ", 
                  StyleBox["1",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["2",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
           1, -$CellContext`B}, {2, -$CellContext`B}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{0, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
          1, -$CellContext`B}, {2, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{1, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
          1, -$CellContext`B}, {2, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{2, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
          1, -$CellContext`B}, {2, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{3, -$CellContext`B}],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox[
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1., 0., 0.]], 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]], GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PDB[{1, -$CellContext`B}][
         $CellContext`v[{2, -$CellContext`B}]],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[EmptyDownTriangle]v", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDv[{3, -$CellContext`B}, {1, -$CellContext`B}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"\[EmptyDownTriangle]", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
              StyleBox[GridBox[{
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], " ", " "},
                 {" ", 
                  StyleBox["1",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["3",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
           1, -$CellContext`B}, {3, -$CellContext`B}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{0, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
          1, -$CellContext`B}, {3, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{1, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
          1, -$CellContext`B}, {3, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{2, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
          1, -$CellContext`B}, {3, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{3, -$CellContext`B}],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox[
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1., 0., 0.]], 
           StyleBox["1",
            FontColor->RGBColor[1., 0., 0.]]], GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PDB[{1, -$CellContext`B}][
         $CellContext`v[{3, -$CellContext`B}]],
        Editable->False]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[EmptyDownTriangle]v", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDv[{0, -$CellContext`B}, {2, -$CellContext`B}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"\[EmptyDownTriangle]", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
              StyleBox[GridBox[{
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], " ", " "},
                 {" ", 
                  StyleBox["2",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
           2, -$CellContext`B}, {0, -$CellContext`B}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{0, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
          2, -$CellContext`B}, {0, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{1, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
          2, -$CellContext`B}, {0, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{2, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
          2, -$CellContext`B}, {0, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{3, -$CellContext`B}],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox[
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1., 0., 0.]], 
           StyleBox["2",
            FontColor->RGBColor[1., 0., 0.]]], GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PDB[{2, -$CellContext`B}][
         $CellContext`v[{0, -$CellContext`B}]],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[EmptyDownTriangle]v", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDv[{1, -$CellContext`B}, {2, -$CellContext`B}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"\[EmptyDownTriangle]", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
              StyleBox[GridBox[{
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], " ", " "},
                 {" ", 
                  StyleBox["2",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["1",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
           2, -$CellContext`B}, {1, -$CellContext`B}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{0, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
          2, -$CellContext`B}, {1, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{1, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
          2, -$CellContext`B}, {1, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{2, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
          2, -$CellContext`B}, {1, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{3, -$CellContext`B}],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox[
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1., 0., 0.]], 
           StyleBox["2",
            FontColor->RGBColor[1., 0., 0.]]], GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PDB[{2, -$CellContext`B}][
         $CellContext`v[{1, -$CellContext`B}]],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[EmptyDownTriangle]v", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDv[{2, -$CellContext`B}, {2, -$CellContext`B}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"\[EmptyDownTriangle]", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
              StyleBox[GridBox[{
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], " ", " "},
                 {" ", 
                  StyleBox["2",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["2",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
           2, -$CellContext`B}, {2, -$CellContext`B}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{0, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
          2, -$CellContext`B}, {2, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{1, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
          2, -$CellContext`B}, {2, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{2, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
          2, -$CellContext`B}, {2, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{3, -$CellContext`B}],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox[
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1., 0., 0.]], 
           StyleBox["2",
            FontColor->RGBColor[1., 0., 0.]]], GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PDB[{2, -$CellContext`B}][
         $CellContext`v[{2, -$CellContext`B}]],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[EmptyDownTriangle]v", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDv[{3, -$CellContext`B}, {2, -$CellContext`B}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"\[EmptyDownTriangle]", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
              StyleBox[GridBox[{
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], " ", " "},
                 {" ", 
                  StyleBox["2",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["3",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
           2, -$CellContext`B}, {3, -$CellContext`B}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{0, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
          2, -$CellContext`B}, {3, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{1, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
          2, -$CellContext`B}, {3, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{2, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
          2, -$CellContext`B}, {3, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{3, -$CellContext`B}],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox[
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1., 0., 0.]], 
           StyleBox["2",
            FontColor->RGBColor[1., 0., 0.]]], GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PDB[{2, -$CellContext`B}][
         $CellContext`v[{3, -$CellContext`B}]],
        Editable->False]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[EmptyDownTriangle]v", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["0",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDv[{0, -$CellContext`B}, {3, -$CellContext`B}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"\[EmptyDownTriangle]", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
              StyleBox[GridBox[{
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], " ", " "},
                 {" ", 
                  StyleBox["3",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
           3, -$CellContext`B}, {0, -$CellContext`B}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{0, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
          3, -$CellContext`B}, {0, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{1, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
          3, -$CellContext`B}, {0, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{2, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
          3, -$CellContext`B}, {0, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{3, -$CellContext`B}],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox[
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1., 0., 0.]], 
           StyleBox["3",
            FontColor->RGBColor[1., 0., 0.]]], GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PDB[{3, -$CellContext`B}][
         $CellContext`v[{0, -$CellContext`B}]],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[EmptyDownTriangle]v", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["1",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDv[{1, -$CellContext`B}, {3, -$CellContext`B}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"\[EmptyDownTriangle]", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
              StyleBox[GridBox[{
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], " ", " "},
                 {" ", 
                  StyleBox["3",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["1",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
           3, -$CellContext`B}, {1, -$CellContext`B}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{0, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
          3, -$CellContext`B}, {1, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{1, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
          3, -$CellContext`B}, {1, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{2, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
          3, -$CellContext`B}, {1, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{3, -$CellContext`B}],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox[
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1., 0., 0.]], 
           StyleBox["3",
            FontColor->RGBColor[1., 0., 0.]]], GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PDB[{3, -$CellContext`B}][
         $CellContext`v[{1, -$CellContext`B}]],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[EmptyDownTriangle]v", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["2",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDv[{2, -$CellContext`B}, {3, -$CellContext`B}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"\[EmptyDownTriangle]", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
              StyleBox[GridBox[{
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], " ", " "},
                 {" ", 
                  StyleBox["3",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["2",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
           3, -$CellContext`B}, {2, -$CellContext`B}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{0, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
          3, -$CellContext`B}, {2, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{1, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
          3, -$CellContext`B}, {2, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{2, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
          3, -$CellContext`B}, {2, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{3, -$CellContext`B}],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox[
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1., 0., 0.]], 
           StyleBox["3",
            FontColor->RGBColor[1., 0., 0.]]], GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PDB[{3, -$CellContext`B}][
         $CellContext`v[{2, -$CellContext`B}]],
        Editable->False]}]}], ",", 
     RowBox[{
      InterpretationBox[
       StyleBox[GridBox[{
          {"\[EmptyDownTriangle]v", 
           StyleBox[GridBox[{
              {" ", " "},
              {
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]], 
               StyleBox["3",
                FontColor->RGBColor[1., 0., 0.]]}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CDv[{3, -$CellContext`B}, {3, -$CellContext`B}],
       Editable->False], "\[Rule]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"\[CapitalGamma]", "[", 
               RowBox[{"\[EmptyDownTriangle]", ",", 
                StyleBox["\[ScriptCapitalD]",
                 FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
              StyleBox[GridBox[{
                 {
                  StyleBox["0",
                   FontColor->RGBColor[1., 0., 0.]], " ", " "},
                 {" ", 
                  StyleBox["3",
                   FontColor->RGBColor[1., 0., 0.]], 
                  StyleBox["3",
                   FontColor->RGBColor[1., 0., 0.]]}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`ChristoffelCDPDB[{0, $CellContext`B}, {
           3, -$CellContext`B}, {3, -$CellContext`B}],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["0",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{0, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{1, $CellContext`B}, {
          3, -$CellContext`B}, {3, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["1",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{1, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{2, $CellContext`B}, {
          3, -$CellContext`B}, {3, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["2",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{2, -$CellContext`B}],
         Editable->False]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"\[CapitalGamma]", "[", 
              RowBox[{"\[EmptyDownTriangle]", ",", 
               StyleBox["\[ScriptCapitalD]",
                FontColor->RGBColor[1., 0., 0.]]}], "]"}], 
             StyleBox[GridBox[{
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], " ", " "},
                {" ", 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]], 
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`ChristoffelCDPDB[{3, $CellContext`B}, {
          3, -$CellContext`B}, {3, -$CellContext`B}],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`v[{3, -$CellContext`B}],
         Editable->False]}], "+", 
       InterpretationBox[
        StyleBox[
         RowBox[{
          SubscriptBox[
           StyleBox["\[ScriptCapitalD]",
            FontColor->RGBColor[1., 0., 0.]], 
           StyleBox["3",
            FontColor->RGBColor[1., 0., 0.]]], GridBox[{
            {"v", 
             StyleBox[GridBox[{
                {" "},
                {
                 StyleBox["3",
                  FontColor->RGBColor[1., 0., 0.]]}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}]}],
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`PDB[{3, -$CellContext`B}][
         $CellContext`v[{3, -$CellContext`B}]],
        Editable->False]}]}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->676022391]
}, Open  ]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "MoreAboutSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "MORE ABOUT", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "MoreAboutSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "More About"}], "MoreAboutSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->38303248],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["xTras package",
 BaseStyle->"Link",
 ButtonData->"paclet:xTras/guide/xTras"]], "MoreAbout",
 CellID->1320334743],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ImplodedTensorValues - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "xTras package", ButtonData -> "paclet:xTras/guide/xTras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 10, 30, 13, 13, 47.145263}", 
    "history" -> {"1.0.4", "", "", ""}, "context" -> "xTras`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "xTras Package Symbol", "language" -> "en", "paclet" -> "xTras Package", 
    "status" -> "None", "summary" -> 
    "ImplodedTensorValues[cd, T, B] computes the values of the covariant \
derivative cd of the tensor T in the basis B.", "synonyms" -> {}, "title" -> 
    "ImplodedTensorValues", "titlemodifier" -> "", "windowtitle" -> 
    "ImplodedTensorValues", "type" -> "Symbol", "uri" -> 
    "xTras/ref/ImplodedTensorValues"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

