Notebook[{
Cell[BoxData[GridBox[{
   {Cell["XTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RiemannSimplification\"\>":>
       Documentation`HelpLookup[
       "paclet:xTras/ref/RiemannSimplification"], "\<\"InvarLagrangian\"\>":>
       Documentation`HelpLookup["paclet:xTras/ref/InvarLagrangian"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"xTras/ref/InvarWrapper\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["xTras/ref/InvarWrapper"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/xTras/ref/\
InvarWrapper.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "xTras/ref/InvarWrapper", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell[CellGroupData[{

Cell["InvarWrapper", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"InvarWrapper", "[", 
        RowBox[{
         StyleBox["f", "TI"], ",", 
         StyleBox["g", "TI"]}], "]"}], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the result of ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox[
        RowBox[{"g", ",", "expr"}], "TI"], "]"}]], "InlineFormula"],
     " while temporarily configuring settings associated to the metric ",
     StyleBox["g", "TI"],
     " to ",
     StyleBox["Invar",
      FontSlant->"Italic"],
     " compatible values."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"InvarWrapper", "[", 
        RowBox[{
         StyleBox["f", "TI"], ",", 
         StyleBox["g", "TI"]}], "]"}], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["args", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       RowBox[{
        StyleBox["g", "TI"], 
        StyleBox[",", "TI"], 
        StyleBox["expr", "TI"], ",", 
        StyleBox["args", "TI"]}], "]"}]], "InlineFormula"],
     " while temporarily configuring settings associated to the metric ",
     StyleBox["g", "TI"],
     " to ",
     StyleBox["Invar",
      FontSlant->"Italic"],
     " compatible values."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "NotesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       Cell[
        BoxData[
         ButtonBox[
          FrameBox[
           StyleBox[
            RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"], 
           StripOnInput -> False], Appearance -> {Automatic, None}, BaseStyle -> 
          None, ButtonFunction :> (FrontEndExecute[{
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], All, ButtonCell], 
             FrontEndToken["OpenCloseGroup"], 
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], After, CellContents]}]& ), 
          Evaluator -> None, Method -> "Preemptive"]]]], "NotesSection", 
      CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Details and Options"}], "NotesSection", 
        CellSize -> {5000, Inherited}], Appearance -> {Automatic, None}, 
       BaseStyle -> None, ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& ), Evaluator -> 
       None, Method -> "Preemptive"]]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1505764404],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[{
 "InvarWrapper temporarily sets the option ",
 Cell[BoxData["UseMetricOnVBundle"], "InlineFormula"],
 " of ",
 Cell[BoxData["ToCanonical"], "InlineFormula"],
 " to ",
 Cell[BoxData["All"], "InlineFormula"],
 ", the option ",
 Cell[BoxData["AllowUpperDerivatives"], "InlineFormula"],
 " of ",
 Cell[BoxData["ContractMetric"], "InlineFormula"],
 " to ",
 Cell[BoxData["True"], "InlineFormula"],
 ", ",
 Cell[BoxData["$CommuteCovDsOnScalars"], "InlineFormula"],
 " to ",
 Cell[BoxData["True"], "InlineFormula"],
 ", and disables automatic curvature relations. It reverts these settings to \
their original value afterwards."
}], "Notes",
 CellID->1067943069],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(2)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->1435041780],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->358357003],

Cell["\<\
Using Invar functions directly usually fails or gives the wrong result, \
because some settings do not have compatible values:\
\>", "ExampleText",
 CellID->1529154825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", " ", "=", " ", 
  RowBox[{
   RowBox[{"CD", "[", "a", "]"}], "@", 
   RowBox[{
    RowBox[{"CD", "[", "b", "]"}], "@", 
    RowBox[{"RicciCD", "[", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1866744454],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SuperscriptBox["\[EmptyDownTriangle]", "a"], 
    SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
      {
       RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " "},
          {"a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CD[$CellContext`a][
   $CellContext`CD[$CellContext`b][
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`b]]],
  Editable->False]], "Output",
 CellLabel->"Out[1]=",
 CellID->580492892]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannSimplify", "[", 
  RowBox[{"expr", ",", " ", "4", ",", " ", "True", ",", " ", "metric"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1923863898],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    StyleBox["(",
     FontColor->RGBColor[1, 0, 0]], 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "a"], 
       SuperscriptBox["\[EmptyDownTriangle]", "a"], 
       RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`a][
      $CellContext`CD[$CellContext`a][
       $CellContext`RicciScalarCD[]]],
     Editable->False], 
    StyleBox[")",
     FontColor->RGBColor[1, 0, 0]]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xTensor`Scalar[
   $CellContext`CD[-$CellContext`a][
    $CellContext`CD[$CellContext`a][
     $CellContext`RicciScalarCD[]]]],
  Editable->False]], "Output",
 CellLabel->"Out[2]=",
 CellID->325827523]
}, Open  ]],

Cell[TextData[{
 "Wrapping ",
 Cell[BoxData["RiemannSimplify"], "InlineFormula"],
 " in ",
 Cell[BoxData["InvarWrapper"], "InlineFormula"],
 " does work:"
}], "ExampleText",
 CellID->1568340126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InvarWrapper", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"RiemannSimplify", "[", 
      RowBox[{"#2", ",", "4", ",", "True", ",", "#1"}], "]"}], "&"}], ",", 
    "metric"}], "]"}], "[", "expr", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->878214404],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     StyleBox["(",
      FontColor->RGBColor[1, 0, 0]], 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SubscriptBox["\[EmptyDownTriangle]", "a"], 
        SuperscriptBox["\[EmptyDownTriangle]", "a"], 
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[-$CellContext`a][
       $CellContext`CD[$CellContext`a][
        $CellContext`RicciScalarCD[]]],
      Editable->False], 
     StyleBox[")",
      FontColor->RGBColor[1, 0, 0]]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   xAct`xTensor`Scalar[
    $CellContext`CD[-$CellContext`a][
     $CellContext`CD[$CellContext`a][
      $CellContext`RicciScalarCD[]]]],
   Editable->False]}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1918916058]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->99879211],

Cell[TextData[{
 "Writing the ",
 StyleBox["Invar",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData["f"], "InlineFormula"],
 " as a ",
 ButtonBox["pure function",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Function"],
 " gives flexibility in the argument positions:"
}], "ExampleText",
 CellID->1657109302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InvarWrapper", "[", 
   RowBox[{"f", ",", "metric"}], "]"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1485170970],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"metric", ",", "x"}], "]"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->685857193]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InvarWrapper", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"#1", ",", "#2"}], "]"}], "&"}], ",", "metric"}], "]"}], "[", 
  "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1465551196],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"metric", ",", "x"}], "]"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->2029003729]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InvarWrapper", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"#2", ",", "#1"}], "]"}], "&"}], ",", "metric"}], "]"}], "[", 
  "x", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1572842590],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", "metric"}], "]"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1389199207]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InvarWrapper", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"#2", ",", "#1"}], "]"}], "[", "#3", "]"}], "&"}], ",", 
    "metric"}], "]"}], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->828861865],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "metric"}], "]"}], "[", "y", "]"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->2102430613]
}, Open  ]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RiemannSimplification",
    BaseStyle->"Link",
    ButtonData->"paclet:xTras/ref/RiemannSimplification"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InvarLagrangian",
    BaseStyle->"Link",
    ButtonData->"paclet:xTras/ref/InvarLagrangian"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InvarWrapper - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "xTras package", ButtonData -> "paclet:xTras/guide/xTras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 10, 30, 13, 14, 5.110873}", 
    "history" -> {"1.0.0", "", "", ""}, "context" -> "xTras`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "xTras Package Symbol", "language" -> "en", "paclet" -> "xTras Package", 
    "status" -> "None", "summary" -> 
    "InvarWrapper[f, g][expr] returns the result of f[g, expr] while \
temporarily configuring settings associated to the metric g to Invar \
compatible values.InvarWrapper[f, g][expr, args] returns f[g, expr, args] \
while temporarily configuring settings associated to the metric g to Invar \
compatible values.", "synonyms" -> {}, "title" -> "InvarWrapper", 
    "titlemodifier" -> "", "windowtitle" -> "InvarWrapper", "type" -> 
    "Symbol", "uri" -> "xTras/ref/InvarWrapper"}, "SearchTextTranslated" -> 
  ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

