Notebook[{
Cell[BoxData[GridBox[{
   {Cell["XTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"KillingVectorQ\"\>":>
       Documentation`HelpLookup[
       "paclet:xTras/ref/KillingVectorQ"], "\<\"MetricOfKillingVector\"\>":>
       Documentation`HelpLookup["paclet:xTras/ref/MetricOfKillingVector"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"xTras package\"\>":>
       Documentation`HelpLookup["paclet:xTras/guide/xTras"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"xTras/ref/KillingVectorOf\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["xTras/ref/KillingVectorOf"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/xTras/ref/\
KillingVectorOf.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "xTras/ref/KillingVectorOf", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["KillingVectorOf", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["KillingVectorOf"], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData["DefTensor"], "InlineFormula"],
     " that determines whether the defined tensor is a Killing vector of a \
metric."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "NotesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       Cell[
        BoxData[
         ButtonBox[
          FrameBox[
           StyleBox[
            RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"], 
           StripOnInput -> False], Appearance -> {Automatic, None}, BaseStyle -> 
          None, ButtonFunction :> (FrontEndExecute[{
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], All, ButtonCell], 
             FrontEndToken["OpenCloseGroup"], 
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], After, CellContents]}]& ), 
          Evaluator -> None, Method -> "Preemptive"]]]], "NotesSection", 
      CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Details"}], "NotesSection", 
        CellSize -> {5000, Inherited}], Appearance -> {Automatic, None}, 
       BaseStyle -> None, ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& ), Evaluator -> 
       None, Method -> "Preemptive"]]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1362003233],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[{
 Cell[BoxData["KillingVectorOf"], "InlineFormula"],
 " is used as ",
 Cell[BoxData[
  RowBox[{"DefTensor", "[", 
   RowBox[{
    StyleBox["tensor", "TI"], ",", 
    StyleBox["manifold", "TI"], ",", " ", 
    RowBox[{"KillingVectorOf", "\[Rule]", " ", 
     StyleBox["metric", "TI"]}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "A vector ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["v", "a"], TraditionalForm]], "InlineMath"],
 " is a Killing vector of the metric ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 " if ",
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[ScriptCapitalL]", "v"], 
      SubscriptBox["g", 
       StyleBox["ab",
        FontSlant->"Italic"]]}], "=", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubscriptBox["\[Del]", "a"], 
        SubscriptBox["v", "b"]}], "+", 
       RowBox[{
        SubscriptBox["\[Del]", "b"], 
        SubscriptBox["v", "a"]}]}], "=", "0"}]}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Notes",
 CellID->135956235],

Cell["\<\
Lie derivatives of the metric with respect to the Killing vector are \
automatically zero.\
\>", "Notes",
 CellID->93841237],

Cell["\<\
The covariant derivative of the Killing vector is automatically antisymmetric \
in the two free indices.\
\>", "Notes",
 CellID->936673361],

Cell["\<\
The second derivative of the Killing vector is automatically converted to a \
contraction of the Riemann tensor with the Killing vector.\
\>", "Notes",
 CellID->1614045817],

Cell["\<\
The Killing vector must be a vector (that is, have one tangent bundle index), \
but can have one or more label indices.\
\>", "Notes",
 CellID->254617415],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(2)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->1160143658],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1530428893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"v", "[", "a", "]"}], ",", "M", ",", 
   RowBox[{"KillingVectorOf", "\[Rule]", "metric"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->626904163],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"v", "[", "a", "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`v[$CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[78]:=",
 CellID->823495359],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Defining \"\>", "\[InvisibleSpace]", "\<\"v\"\>", 
   "\[InvisibleSpace]", "\<\" to be a Killing vector of the metric \"\>", 
   "\[InvisibleSpace]", "\<\"g\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "** Defining ", "v", " to be a Killing vector of the metric ", "g", "."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[78]:=",
 CellID->2101877445]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LieD", "[", 
   RowBox[{"v", "[", 
    RowBox[{"-", "a"}], "]"}], "]"}], "[", 
  RowBox[{"metric", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1567469081],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[2]=",
 CellID->1270946618]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"CD", "[", "a", "]"}], "@", 
  RowBox[{"v", "[", "b", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "ToCanonical"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1927455664],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"b"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CD[$CellContext`a][
   $CellContext`v[$CellContext`b]],
  Editable->False]], "Output",
 CellLabel->"Out[3]=",
 CellID->2104013500],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
        {"v", 
         StyleBox[GridBox[{
            {"a"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`b][
     $CellContext`v[$CellContext`a]],
    Editable->False], ")"}]}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1689162998]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"CD", "[", 
   RowBox[{"-", "a"}], "]"}], "@", 
  RowBox[{"v", "[", "a", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "ToCanonical"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->28694046],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {"a"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CD[-$CellContext`a][
   $CellContext`v[$CellContext`a]],
  Editable->False]], "Output",
 CellLabel->"Out[4]=",
 CellID->1224494194],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[4]=",
 CellID->738129357]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CD", "[", 
   RowBox[{"-", "c"}], "]"}], "@", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "b"}], "]"}], "@", 
   RowBox[{"v", "[", 
    RowBox[{"-", "a"}], "]"}]}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1874558027],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", "d"},
          {"a", "b", "c", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
$CellContext`d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"v", 
       StyleBox[GridBox[{
          {" "},
          {"d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`v[-$CellContext`d],
   Editable->False]}]], "Output",
 CellLabel->"Out[5]=",
 CellID->2111658299]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1020263627],

Cell["The Killing vector can have one or more label indices:", "ExampleText",
 CellID->2071507384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"\[Xi]", "[", 
    RowBox[{
     RowBox[{"LI", "[", "_", "]"}], ",", "a"}], "]"}], ",", "M", ",", 
   RowBox[{"KillingVectorOf", "\[Rule]", "metric"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1326280971],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"\[Xi]", "[", 
    RowBox[{
     RowBox[{"LI", "[", "_", "]"}], ",", "a"}], "]"}], 
   "\[InvisibleSpace]", "\<\". \"\>", "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`\[Xi][
    xAct`xTensor`LI[
     Blank[]], $CellContext`a], ". ", ""],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[85]:=",
 CellID->819717724],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** Defining \"\>", "\[InvisibleSpace]", "\<\"\[Xi]\"\>", 
   "\[InvisibleSpace]", "\<\" to be a Killing vector of the metric \"\>", 
   "\[InvisibleSpace]", "\<\"g\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "** Defining ", "\[Xi]", " to be a Killing vector of the metric ", "g", "."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[85]:=",
 CellID->888191763]
}, Open  ]]
}, Open  ]],

Cell["The Killing vector identities are then still implemented:", \
"ExampleText",
 CellID->680130444],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LieD", "[", 
   RowBox[{"\[Xi]", "[", 
    RowBox[{
     RowBox[{"LI", "@", "1"}], ",", 
     RowBox[{"-", "a"}]}], "]"}], "]"}], "[", 
  RowBox[{"metric", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"CD", "[", "a", "]"}], "@", 
   RowBox[{"\[Xi]", "[", 
    RowBox[{
     RowBox[{"LI", "@", "1"}], ",", "b"}], "]"}]}], " ", "//", 
  "ToCanonical"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CD", "[", 
   RowBox[{"-", "c"}], "]"}], "@", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "b"}], "]"}], "@", 
   RowBox[{"\[Xi]", "[", 
    RowBox[{
     RowBox[{"LI", "@", "1"}], ",", 
     RowBox[{"-", "a"}]}], "]"}]}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->2044402974],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[2]=",
 CellID->542432018],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
        {"\[Xi]", 
         StyleBox[GridBox[{
            {"1", "a"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[$CellContext`b][
     $CellContext`\[Xi][
      xAct`xTensor`LI[1], $CellContext`a]],
    Editable->False], ")"}]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->586845011],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", " ", "d"},
          {"a", "b", "c", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, -$CellContext`c, \
$CellContext`d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[Xi]", 
       StyleBox[GridBox[{
          {"1", " "},
          {" ", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`\[Xi][
    xAct`xTensor`LI[1], -$CellContext`d],
   Editable->False]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1859192853]
}, Open  ]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["KillingVectorQ",
    BaseStyle->"Link",
    ButtonData->"paclet:xTras/ref/KillingVectorQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MetricOfKillingVector",
    BaseStyle->"Link",
    ButtonData->"paclet:xTras/ref/MetricOfKillingVector"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "MoreAboutSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "MORE ABOUT", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "MoreAboutSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "More About"}], "MoreAboutSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->38303248],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["xTras package",
 BaseStyle->"Link",
 ButtonData->"paclet:xTras/guide/xTras"]], "MoreAbout",
 CellID->1506764532],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"KillingVectorOf - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "xTras package", ButtonData -> "paclet:xTras/guide/xTras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 10, 30, 13, 14, 8.930125}", 
    "history" -> {"1.1.1", "", "", ""}, "context" -> "xTras`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "xTras Package Symbol", "language" -> "en", "paclet" -> "xTras Package", 
    "status" -> "None", "summary" -> 
    "KillingVectorOf is an option for DefTensor that determines whether the \
defined tensor is a Killing vector of a metric.", "synonyms" -> {}, "title" -> 
    "KillingVectorOf", "titlemodifier" -> "", "windowtitle" -> 
    "KillingVectorOf", "type" -> "Symbol", "uri" -> 
    "xTras/ref/KillingVectorOf"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

