Notebook[{
Cell[BoxData[GridBox[{
   {Cell["XTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"RiemannYoungProject\"\>":>
       Documentation`HelpLookup[
       "paclet:xTras/ref/RiemannYoungProject"], "\<\"YoungProject\"\>":>
       Documentation`HelpLookup["paclet:xTras/ref/YoungProject"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"xTras/ref/RiemannYoungRule\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["xTras/ref/RiemannYoungRule"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/xTras/ref/\
RiemannYoungRule.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "xTras/ref/RiemannYoungRule", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell[CellGroupData[{

Cell["RiemannYoungRule", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RiemannYoungRule", "[", 
       StyleBox["cd", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the projection rules for the Riemann tensor, the \
Weyl tensor, the symmetrized Riemann tensor, and their first derivatives of \
the covariant derivative ",
     StyleBox["cd", "TI"],
     " onto their respective Young tableaux."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "NotesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       Cell[
        BoxData[
         ButtonBox[
          FrameBox[
           StyleBox[
            RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"], 
           StripOnInput -> False], Appearance -> {Automatic, None}, BaseStyle -> 
          None, ButtonFunction :> (FrontEndExecute[{
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], All, ButtonCell], 
             FrontEndToken["OpenCloseGroup"], 
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], After, CellContents]}]& ), 
          Evaluator -> None, Method -> "Preemptive"]]]], "NotesSection", 
      CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Details"}], "NotesSection", 
        CellSize -> {5000, Inherited}], Appearance -> {Automatic, None}, 
       BaseStyle -> None, ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& ), Evaluator -> 
       None, Method -> "Preemptive"]]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->2146013518],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell["\<\
RiemannYoungRule only returns rules for curvature tensors of metric covariant \
derivatives without torsion.\
\>", "Notes",
 CellID->1334852380],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(1)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->1061345661],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->1037352445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannYoungRule", "[", "CD", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1051606019],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["b", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["c", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["d", "_"], "_"]},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`b, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`c, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`d, 
         Blank[]], TangentM`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["2", "3"], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"a", "b", "c", "d"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
         Editable->False]}], "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"a", "c", "b", "d"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
$CellContext`b, $CellContext`d],
         Editable->False]}], "-", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"a", "d", "b", "c"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`a, $CellContext`d, \
$CellContext`b, $CellContext`c],
         Editable->False]}]}]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SuperscriptBox["\[EmptyDownTriangle]", 
         UnderscriptBox[
          UnderscriptBox["e", "_"], "_"]], GridBox[{
          {
           RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {
               UnderscriptBox[
                UnderscriptBox["a", "_"], "_"], 
               UnderscriptBox[
                UnderscriptBox["b", "_"], "_"], 
               UnderscriptBox[
                UnderscriptBox["c", "_"], "_"], 
               UnderscriptBox[
                UnderscriptBox["d", "_"], "_"]},
              {" ", " ", " ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[
       PatternTest[
        Pattern[$CellContext`e, 
         Blank[]], TangentM`pmQ]][
       $CellContext`RiemannCD[
        PatternTest[
         Pattern[$CellContext`a, 
          Blank[]], TangentM`pmQ], 
        PatternTest[
         Pattern[$CellContext`b, 
          Blank[]], TangentM`pmQ], 
        PatternTest[
         Pattern[$CellContext`c, 
          Blank[]], TangentM`pmQ], 
        PatternTest[
         Pattern[$CellContext`d, 
          Blank[]], TangentM`pmQ]]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"b", "c", "d", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`a][
           $CellContext`RiemannCD[$CellContext`b, $CellContext`c, \
$CellContext`d, $CellContext`e]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"b", "d", "c", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`a][
           $CellContext`RiemannCD[$CellContext`b, $CellContext`d, \
$CellContext`c, $CellContext`e]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"b", "e", "c", "d"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`a][
           $CellContext`RiemannCD[$CellContext`b, $CellContext`e, \
$CellContext`c, $CellContext`d]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "c", "d", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`b][
           $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
$CellContext`d, $CellContext`e]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "d", "c", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`b][
           $CellContext`RiemannCD[$CellContext`a, $CellContext`d, \
$CellContext`c, $CellContext`e]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "e", "c", "d"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`b][
           $CellContext`RiemannCD[$CellContext`a, $CellContext`e, \
$CellContext`c, $CellContext`d]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "b", "d", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`c][
           $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`d, $CellContext`e]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "d", "b", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`c][
           $CellContext`RiemannCD[$CellContext`a, $CellContext`d, \
$CellContext`b, $CellContext`e]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "e", "b", "d"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`c][
           $CellContext`RiemannCD[$CellContext`a, $CellContext`e, \
$CellContext`b, $CellContext`d]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "d"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "b", "c", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`d][
           $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`e]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "d"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "c", "b", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`d][
           $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
$CellContext`b, $CellContext`e]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "d"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "e", "b", "c"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`d][
           $CellContext`RiemannCD[$CellContext`a, $CellContext`e, \
$CellContext`b, $CellContext`c]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "e"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "b", "c", "d"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`e][
           $CellContext`RiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "e"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "c", "b", "d"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`e][
           $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
$CellContext`b, $CellContext`d]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "e"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "d", "b", "c"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`e][
           $CellContext`RiemannCD[$CellContext`a, $CellContext`d, \
$CellContext`b, $CellContext`c]],
          Editable->False], ")"}]}]}]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["b", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["c", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["d", "_"], "_"]},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`WeylCD[
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`b, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`c, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`d, 
         Blank[]], TangentM`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["2", "3"], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"a", "b", "c", "d"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`WeylCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`d],
         Editable->False]}], "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"a", "c", "b", "d"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`WeylCD[$CellContext`a, $CellContext`c, $CellContext`b, \
$CellContext`d],
         Editable->False]}], "-", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"a", "d", "b", "c"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`WeylCD[$CellContext`a, $CellContext`d, $CellContext`b, \
$CellContext`c],
         Editable->False]}]}]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SuperscriptBox["\[EmptyDownTriangle]", 
         UnderscriptBox[
          UnderscriptBox["e", "_"], "_"]], GridBox[{
          {
           RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {
               UnderscriptBox[
                UnderscriptBox["a", "_"], "_"], 
               UnderscriptBox[
                UnderscriptBox["b", "_"], "_"], 
               UnderscriptBox[
                UnderscriptBox["c", "_"], "_"], 
               UnderscriptBox[
                UnderscriptBox["d", "_"], "_"]},
              {" ", " ", " ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[
       PatternTest[
        Pattern[$CellContext`e, 
         Blank[]], TangentM`pmQ]][
       $CellContext`WeylCD[
        PatternTest[
         Pattern[$CellContext`a, 
          Blank[]], TangentM`pmQ], 
        PatternTest[
         Pattern[$CellContext`b, 
          Blank[]], TangentM`pmQ], 
        PatternTest[
         Pattern[$CellContext`c, 
          Blank[]], TangentM`pmQ], 
        PatternTest[
         Pattern[$CellContext`d, 
          Blank[]], TangentM`pmQ]]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
              {
               RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"b", "c", "d", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`a][
           $CellContext`WeylCD[$CellContext`b, $CellContext`c, \
$CellContext`d, $CellContext`e]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
              {
               RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"b", "d", "c", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`a][
           $CellContext`WeylCD[$CellContext`b, $CellContext`d, \
$CellContext`c, $CellContext`e]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
              {
               RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"b", "e", "c", "d"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`a][
           $CellContext`WeylCD[$CellContext`b, $CellContext`e, \
$CellContext`c, $CellContext`d]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
              {
               RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "c", "d", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`b][
           $CellContext`WeylCD[$CellContext`a, $CellContext`c, \
$CellContext`d, $CellContext`e]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
              {
               RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "d", "c", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`b][
           $CellContext`WeylCD[$CellContext`a, $CellContext`d, \
$CellContext`c, $CellContext`e]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
              {
               RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "e", "c", "d"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`b][
           $CellContext`WeylCD[$CellContext`a, $CellContext`e, \
$CellContext`c, $CellContext`d]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
              {
               RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "b", "d", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`c][
           $CellContext`WeylCD[$CellContext`a, $CellContext`b, \
$CellContext`d, $CellContext`e]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
              {
               RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "d", "b", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`c][
           $CellContext`WeylCD[$CellContext`a, $CellContext`d, \
$CellContext`b, $CellContext`e]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
              {
               RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "e", "b", "d"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`c][
           $CellContext`WeylCD[$CellContext`a, $CellContext`e, \
$CellContext`b, $CellContext`d]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "d"], GridBox[{
              {
               RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "b", "c", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`d][
           $CellContext`WeylCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`e]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "d"], GridBox[{
              {
               RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "c", "b", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`d][
           $CellContext`WeylCD[$CellContext`a, $CellContext`c, \
$CellContext`b, $CellContext`e]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "d"], GridBox[{
              {
               RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "e", "b", "c"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`d][
           $CellContext`WeylCD[$CellContext`a, $CellContext`e, \
$CellContext`b, $CellContext`c]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "e"], GridBox[{
              {
               RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "b", "c", "d"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`e][
           $CellContext`WeylCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "e"], GridBox[{
              {
               RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "c", "b", "d"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`e][
           $CellContext`WeylCD[$CellContext`a, $CellContext`c, \
$CellContext`b, $CellContext`d]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "e"], GridBox[{
              {
               RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "d", "b", "c"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`e][
           $CellContext`WeylCD[$CellContext`a, $CellContext`d, \
$CellContext`b, $CellContext`c]],
          Editable->False], ")"}]}]}]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["b", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["c", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["d", "_"], "_"]},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`SymRiemannCD[
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`b, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`c, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`d, 
         Blank[]], TangentM`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{
       RowBox[{
        FractionBox["2", "3"], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"a", "b", "c", "d"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`SymRiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d],
         Editable->False]}], "-", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"a", "c", "b", "d"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`SymRiemannCD[$CellContext`a, $CellContext`c, \
$CellContext`b, $CellContext`d],
         Editable->False]}], "-", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"a", "d", "b", "c"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`SymRiemannCD[$CellContext`a, $CellContext`d, \
$CellContext`b, $CellContext`c],
         Editable->False]}]}]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[
       RowBox[{
        SuperscriptBox["\[EmptyDownTriangle]", 
         UnderscriptBox[
          UnderscriptBox["e", "_"], "_"]], GridBox[{
          {
           RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
           StyleBox[GridBox[{
              {
               UnderscriptBox[
                UnderscriptBox["a", "_"], "_"], 
               UnderscriptBox[
                UnderscriptBox["b", "_"], "_"], 
               UnderscriptBox[
                UnderscriptBox["c", "_"], "_"], 
               UnderscriptBox[
                UnderscriptBox["d", "_"], "_"]},
              {" ", " ", " ", " "}
             },
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                  Offset[0.]}}, "RowsIndexed" -> {}}],
            FontSize->9]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Center}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.034999999999999996`]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}]}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`CD[
       PatternTest[
        Pattern[$CellContext`e, 
         Blank[]], TangentM`pmQ]][
       $CellContext`SymRiemannCD[
        PatternTest[
         Pattern[$CellContext`a, 
          Blank[]], TangentM`pmQ], 
        PatternTest[
         Pattern[$CellContext`b, 
          Blank[]], TangentM`pmQ], 
        PatternTest[
         Pattern[$CellContext`c, 
          Blank[]], TangentM`pmQ], 
        PatternTest[
         Pattern[$CellContext`d, 
          Blank[]], TangentM`pmQ]]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "12"]}], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
              {
               RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"b", "c", "d", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`a][
           $CellContext`SymRiemannCD[$CellContext`b, $CellContext`c, \
$CellContext`d, $CellContext`e]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
              {
               RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"b", "d", "c", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`a][
           $CellContext`SymRiemannCD[$CellContext`b, $CellContext`d, \
$CellContext`c, $CellContext`e]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
              {
               RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"b", "e", "c", "d"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`a][
           $CellContext`SymRiemannCD[$CellContext`b, $CellContext`e, \
$CellContext`c, $CellContext`d]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
              {
               RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "c", "d", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`b][
           $CellContext`SymRiemannCD[$CellContext`a, $CellContext`c, \
$CellContext`d, $CellContext`e]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
              {
               RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "d", "c", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`b][
           $CellContext`SymRiemannCD[$CellContext`a, $CellContext`d, \
$CellContext`c, $CellContext`e]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
              {
               RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "e", "c", "d"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`b][
           $CellContext`SymRiemannCD[$CellContext`a, $CellContext`e, \
$CellContext`c, $CellContext`d]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
              {
               RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "b", "d", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`c][
           $CellContext`SymRiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`d, $CellContext`e]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
              {
               RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "d", "b", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`c][
           $CellContext`SymRiemannCD[$CellContext`a, $CellContext`d, \
$CellContext`b, $CellContext`e]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
              {
               RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "e", "b", "d"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`c][
           $CellContext`SymRiemannCD[$CellContext`a, $CellContext`e, \
$CellContext`b, $CellContext`d]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "d"], GridBox[{
              {
               RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "b", "c", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`d][
           $CellContext`SymRiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`e]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "d"], GridBox[{
              {
               RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "c", "b", "e"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`d][
           $CellContext`SymRiemannCD[$CellContext`a, $CellContext`c, \
$CellContext`b, $CellContext`e]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "12"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "d"], GridBox[{
              {
               RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "e", "b", "c"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`d][
           $CellContext`SymRiemannCD[$CellContext`a, $CellContext`e, \
$CellContext`b, $CellContext`c]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "e"], GridBox[{
              {
               RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "b", "c", "d"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`e][
           $CellContext`SymRiemannCD[$CellContext`a, $CellContext`b, \
$CellContext`c, $CellContext`d]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "e"], GridBox[{
              {
               RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "c", "b", "d"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`e][
           $CellContext`SymRiemannCD[$CellContext`a, $CellContext`c, \
$CellContext`b, $CellContext`d]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        FractionBox["1", "6"], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "e"], GridBox[{
              {
               RowBox[{"P", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "d", "b", "c"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`e][
           $CellContext`SymRiemannCD[$CellContext`a, $CellContext`d, \
$CellContext`b, $CellContext`c]],
          Editable->False], ")"}]}]}]}], "]"}]}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->2013267336]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RiemannYoungRule", "[", "PD", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1334924678],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->325894539]
}, Open  ]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RiemannYoungProject",
    BaseStyle->"Link",
    ButtonData->"paclet:xTras/ref/RiemannYoungProject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["YoungProject",
    BaseStyle->"Link",
    ButtonData->"paclet:xTras/ref/YoungProject"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RiemannYoungRule - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "xTras package", ButtonData -> "paclet:xTras/guide/xTras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 10, 30, 13, 15, 46.767485}", 
    "history" -> {"1.0.0", "1.3.0", "", ""}, "context" -> "xTras`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "xTras Package Symbol", "language" -> "en", "paclet" -> "xTras Package", 
    "status" -> "None", "summary" -> 
    "RiemannYoungRule[cd] gives the projection rules for the Riemann tensor, \
the Weyl tensor, the symmetrized Riemann tensor, and their first derivatives \
of the covariant derivative cd onto their respective Young tableaux.", 
    "synonyms" -> {}, "title" -> "RiemannYoungRule", "titlemodifier" -> "", 
    "windowtitle" -> "RiemannYoungRule", "type" -> "Symbol", "uri" -> 
    "xTras/ref/RiemannYoungRule"}, "SearchTextTranslated" -> ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

