Notebook[{
Cell[BoxData[GridBox[{
   {Cell["XTRAS SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Symmetrized Covariant Derivatives\"\>":>
       Documentation`HelpLookup[
       "paclet:xTras/tutorial/SymmetrizedDerivatives"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"ExpandSymCovDs\"\>":>
       Documentation`HelpLookup[
       "paclet:xTras/ref/ExpandSymCovDs"], "\<\"SymCovDQ\"\>":>
       Documentation`HelpLookup[
       "paclet:xTras/ref/SymCovDQ"], "\<\"$AutoSymmetrizeCovDs\"\>":>
       Documentation`HelpLookup[
       "paclet:xTras/ref/$AutoSymmetrizeCovDs"], "\<\"ClearSymCovDCache\"\>":>
       Documentation`HelpLookup["paclet:xTras/ref/ClearSymCovDCache"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"More About \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"xTras package\"\>":>
       Documentation`HelpLookup["paclet:xTras/guide/xTras"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"xTras/ref/SymmetrizeCovDs\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["xTras/ref/SymmetrizeCovDs"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/xTras/ref/\
SymmetrizeCovDs.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "xTras/ref/SymmetrizeCovDs", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["SymmetrizeCovDs", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SymmetrizeCovDs", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]symmetrizes all symmetrizable covariant derivatives in \
",
     StyleBox["expr. ", "TI"]
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SymmetrizeCovDs", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", " ", 
        StyleBox["cd", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]only symmetrizes the covariant derivative ",
     StyleBox["cd.", "TI"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "NotesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       Cell[
        BoxData[
         ButtonBox[
          FrameBox[
           StyleBox[
            RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"], 
           StripOnInput -> False], Appearance -> {Automatic, None}, BaseStyle -> 
          None, ButtonFunction :> (FrontEndExecute[{
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], All, ButtonCell], 
             FrontEndToken["OpenCloseGroup"], 
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], After, CellContents]}]& ), 
          Evaluator -> None, Method -> "Preemptive"]]]], "NotesSection", 
      CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Details and Options"}], "NotesSection", 
        CellSize -> {5000, Inherited}], Appearance -> {Automatic, None}, 
       BaseStyle -> None, ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& ), Evaluator -> 
       None, Method -> "Preemptive"]]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->845624459],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[{
 Cell[BoxData["SymmetrizeCovDs"], "InlineFormula"],
 " only symmetrizes covariant derivatives that have been flagged as \
symmetrizable. This can be done by giving the option ",
 StyleBox["SymCovDQ -> True", "InlineCode"],
 " to ",
 Cell[BoxData["DefCovD"], "InlineFormula"],
 " (or  ",
 Cell[BoxData["DefMetric"], "InlineFormula"],
 ") when the covariant derivative is defined."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Symmetrized covariant derivatives can be entered as e.g. ",
 StyleBox["CD[a,b,c,...][expr]", "InlineCode"],
 ", and are symmetric in all indices on the derivative."
}], "Notes",
 CellID->1003407629],

Cell["The following options can be given:", "Notes",
 CellID->1463672238],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<UseCache\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether or not to cache results", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1095742009],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData["\"\<UseCache\>\""], "InlineFormula"],
 " include:"
}], "Notes",
 CellID->1904209340],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "True", Cell[
    "cache results to speed up subsequent computations", "TableText"]},
   {Cell["      ", "TableRowIcon"], "False", Cell[
    "don't cache results", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1884398803],

Cell["\<\
With caching turned on, the first result takes longer to compute because it \
has to be written to the cache. Subsequent symmetrizations will be faster \
however.\
\>", "Notes",
 CellID->961879565],

Cell[TextData[{
 "The cache can be cleared with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ClearSymCovDCache",
    BaseStyle->"Link",
    ButtonData->"paclet:xTras/ref/ClearSymCovDCache"], "[", "]"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->2020610833],

Cell[TextData[{
 Cell[BoxData["SymmetrizeCovDs"], "InlineFormula"],
 " can be called automatically by setting ",
 Cell[BoxData[
  ButtonBox["$AutoSymmetrizeCovDs",
   BaseStyle->"Link",
   ButtonData->"paclet:xTras/ref/$AutoSymmetrizeCovDs"]], "InlineFormula"],
 "  to True."
}], "Notes",
 CellID->1361305494],

Cell[TextData[{
 "The implementation of symmetrizing derivatives is exponentially complex in \
the number of derivatives. ",
 Cell[BoxData[
  ButtonBox["SymmetrizeCovDs",
   BaseStyle->"Link",
   ButtonData->"paclet:xTras/ref/SymmetrizeCovDs"]], "InlineFormula"],
 " has an optimized algorithm in the case when there is no torsion. Whenever \
there is torsion, a slower algorithm is used.\n",
 Cell[BoxData[
  GraphicsBox[{InsetBox[
     GraphicsBox[
      GraphicsComplexBox[{{2., -6.769733981084762}, {
       3., -5.469342963600139}, {4., -4.071957043344471}, {
       5., -2.535084776732281}, {6., -0.778914241123369}, {7., 
       1.3305866004560007`}, {2., -6.17972369656869}, {
       3., -4.983798640142696}, {4., -3.08633554823691}, {
       5., -0.5431818183970546}, {6., 3.3735361462347164`}}, {{{}, {}, 
         {Hue[0.67, 0.6, 0.6], LineBox[{1, 2, 3, 4, 5, 6}]}, 
         {Hue[0.9060679774997897, 0.6, 0.6], LineBox[{7, 8, 9, 10, 11}]}}, {
         {Hue[0.67, 0.6, 0.6], InsetBox[
           StyleBox["\<\"\[FilledCircle]\"\>",
            StripOnInput->False,
            FontSize->8.96], 1], InsetBox[
           StyleBox["\<\"\[FilledCircle]\"\>",
            StripOnInput->False,
            FontSize->8.96], 2], InsetBox[
           StyleBox["\<\"\[FilledCircle]\"\>",
            StripOnInput->False,
            FontSize->8.96], 3], InsetBox[
           StyleBox["\<\"\[FilledCircle]\"\>",
            StripOnInput->False,
            FontSize->8.96], 4], InsetBox[
           StyleBox["\<\"\[FilledCircle]\"\>",
            StripOnInput->False,
            FontSize->8.96], 5], InsetBox[
           StyleBox["\<\"\[FilledCircle]\"\>",
            StripOnInput->False,
            FontSize->8.96], 6]}, 
         {Hue[0.9060679774997897, 0.6, 0.6], InsetBox[
           StyleBox["\<\"\[FilledSquare]\"\>",
            StripOnInput->False,
            FontSize->8.96], 7], InsetBox[
           StyleBox["\<\"\[FilledSquare]\"\>",
            StripOnInput->False,
            FontSize->8.96], 8], InsetBox[
           StyleBox["\<\"\[FilledSquare]\"\>",
            StripOnInput->False,
            FontSize->8.96], 9], InsetBox[
           StyleBox["\<\"\[FilledSquare]\"\>",
            StripOnInput->False,
            FontSize->8.96], 10], InsetBox[
           StyleBox["\<\"\[FilledSquare]\"\>",
            StripOnInput->False,
            FontSize->8.96], 11]}, {}}}],
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->True,
      AxesLabel->{
        FormBox["\"number of derivatives\"", TraditionalForm], 
        FormBox["\"time in seconds\"", TraditionalForm]},
      AxesOrigin->{2., -6.769733981084762},
      CoordinatesToolOptions:>{"DisplayFunction" -> ({
          Part[#, 1], 
          Exp[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          Part[#, 1], 
          Exp[
           Part[#, 2]]}& )},
      DisplayFunction:>$DisplayFunction,
      FormatType->TraditionalForm,
      FrameTicks->{{{{-6.907755278982137, 
           FormBox["0.001`", TraditionalForm]}, {-4.605170185988091, 
           FormBox["0.01`", TraditionalForm]}, {-2.3025850929940455`, 
           FormBox["0.1`", TraditionalForm]}, {0., 
           FormBox["1", TraditionalForm]}, {2.302585092994046, 
           FormBox["10", TraditionalForm]}, {-6.214608098422191, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-5.809142990314028, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-5.521460917862246, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-5.298317366548036, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-5.115995809754082, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-4.961845129926823, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-4.8283137373023015`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-4.710530701645918, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-3.912023005428146, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-3.506557897319982, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-3.2188758248682006`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.995732273553991, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.8134107167600364`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.659260036932778, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.5257286443082556`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.407945608651872, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.6094379124341003`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.203972804325936, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.916290731874155, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.6931471805599453, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5108256237659905, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.35667494393873245`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2231435513142097, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.10536051565782616`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6931471805599453, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.0986122886681098`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3862943611198906`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6094379124341003`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.791759469228055, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9459101490553132`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.0794415416798357`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.1972245773362196`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}, {{-6.907755278982137, 
           FormBox["\"\"", TraditionalForm]}, {-4.605170185988091, 
           FormBox["\"\"", TraditionalForm]}, {-2.3025850929940455`, 
           FormBox["\"\"", TraditionalForm]}, {0., 
           FormBox["\"\"", TraditionalForm]}, {2.302585092994046, 
           FormBox["\"\"", TraditionalForm]}, {-6.214608098422191, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-5.809142990314028, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-5.521460917862246, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-5.298317366548036, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-5.115995809754082, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-4.961845129926823, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-4.8283137373023015`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-4.710530701645918, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-3.912023005428146, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-3.506557897319982, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-3.2188758248682006`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.995732273553991, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.8134107167600364`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.659260036932778, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.5257286443082556`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-2.407945608651872, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.6094379124341003`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-1.203972804325936, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.916290731874155, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.6931471805599453, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.5108256237659905, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.35667494393873245`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.2231435513142097, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {-0.10536051565782616`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {0.6931471805599453, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.0986122886681098`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.3862943611198906`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.6094379124341003`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.791759469228055, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {1.9459101490553132`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.0794415416798357`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}, {2.1972245773362196`, 
           FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
            Thickness[0.001]}}}}, {Automatic, Automatic}},
      GridLines->{None, None},
      Method->{},
      PlotRange->{{2., 7.}, {-6.769733981084762, 3.3735361462347164`}},
      PlotRangeClipping->True,
      PlotRangePadding->{
        Scaled[0.02], {
         Scaled[0.02], 
         Scaled[0.02]}},
      Ticks->{Automatic, {{-6.907755278982137, 
          FormBox["0.001`", TraditionalForm]}, {-4.605170185988091, 
          FormBox["0.01`", TraditionalForm]}, {-2.3025850929940455`, 
          FormBox["0.1`", TraditionalForm]}, {0., 
          FormBox["1", TraditionalForm]}, {2.302585092994046, 
          FormBox["10", TraditionalForm]}, {-6.214608098422191, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.809142990314028, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.521460917862246, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.298317366548036, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-5.115995809754082, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.961845129926823, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.8283137373023015`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-4.710530701645918, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-3.912023005428146, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-3.506557897319982, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-3.2188758248682006`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.995732273553991, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.8134107167600364`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.659260036932778, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.5257286443082556`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-2.407945608651872, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.6094379124341003`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-1.203972804325936, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.916290731874155, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.6931471805599453, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.5108256237659905, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.35667494393873245`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.2231435513142097, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {-0.10536051565782616`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {0.6931471805599453, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.0986122886681098`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.3862943611198906`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.6094379124341003`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.791759469228055, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {1.9459101490553132`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.0794415416798357`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}, {2.1972245773362196`, 
          FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
           Thickness[0.001]}}}}], {-1, -0.6180339887498948}, {
     Left, Bottom}, {2, 1.2360679774997896`}], GraphicsGroupBox[{
      {GrayLevel[0], 
       RectangleBox[{0.55, -0.3}, {1.35, 0.3000000000000001}]}, 
      {GrayLevel[1], EdgeForm[{GrayLevel[0], Thickness[0.001]}], 
       GraphicsGroupBox[{
         RectangleBox[{0.5, -0.25}, {1.3, 0.3500000000000001}], InsetBox[
          GraphicsBox[{{{InsetBox[
               GraphicsBox[{
                 {Hue[0.9060679774997897, 0.6, 0.6], 
                  LineBox[{{0, 0.5}, {1, 0.5}}]}, InsetBox[
                  StyleBox["\<\"\[FilledSquare]\"\>",
                   StripOnInput->False,
                   FrontFaceColor->Hue[0.9060679774997897, 0.6, 0.6],
                   BackFaceColor->Hue[0.9060679774997897, 0.6, 0.6],
                   GraphicsColor->Hue[0.9060679774997897, 0.6, 0.6],
                   LineColor -> Hue[0.9060679774997897, 0.6, 0.6],
                   FontSize->8.96,
                   FontColor->Hue[0.9060679774997897, 0.6, 0.6]], {0.5, 0.5}]},
                PlotRange->{{0, 1}, {0, 1}}], {0.08, 0.08}, {
               Left, Bottom}, {1, 1}], 
              InsetBox["\<\"with torsion\"\>", {1.2100000000000002`, 0.58}, {-1, 0},
                Automatic, {1, 0}]}, {InsetBox[
               GraphicsBox[{
                 {Hue[0.67, 0.6, 0.6], LineBox[{{0, 0.5}, {1, 0.5}}]}, 
                 InsetBox[
                  StyleBox["\<\"\[FilledCircle]\"\>",
                   StripOnInput->False,
                   FrontFaceColor->Hue[0.67, 0.6, 0.6],
                   BackFaceColor->Hue[0.67, 0.6, 0.6],
                   GraphicsColor->Hue[0.67, 0.6, 0.6],
                   LineColor -> Hue[0.67, 0.6, 0.6],
                   FontSize->8.96,
                   FontColor->Hue[0.67, 0.6, 0.6]], {0.5, 0.5}]},
                PlotRange->{{0, 1}, {0, 1}}], {0.08, 1.24}, {
               Left, Bottom}, {1, 1}], 
              InsetBox["\<\"without torsion\"\>", \
{1.2100000000000002`, 1.74}, {-1, 0}, Automatic, {1, 0}]}}, {}},
           AspectRatio->0.7500000000000001,
           FormatType->TraditionalForm,
           PlotRange->{{-0.1, 3.26}, {-0.1, 2.42}}], {0.5, -0.25}, {
          Left, Bottom}, {0.8, 0.6000000000000001}]}]}}]},
   AspectRatio->Automatic,
   Background->None,
   ColorOutput->Automatic,
   ImageSize->{469.5652173913044, Automatic},
   PlotRange->All]], "Text"]
}], "Notes",
 CellID->910050546],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(3)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->363506567],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->2011379501],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"CD", "[", 
   RowBox[{"-", "a"}], "]"}], "@", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "b"}], "]"}], "@", 
   RowBox[{"V", "[", "c", "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"%", "//", "SymmetrizeCovDs"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1961150543],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{
    SubscriptBox["\[EmptyDownTriangle]", "a"], 
    SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
      {"V", 
       StyleBox[GridBox[{
          {"c"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`CD[-$CellContext`a][
   $CellContext`CD[-$CellContext`b][
    $CellContext`V[$CellContext`c]]],
  Editable->False]], "Output",
 CellLabel->"Out[1]=",
 CellID->348262927],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " ", " ", "c"},
           {"b", "a", "d", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RiemannCD[-$CellContext`b, -$CellContext`a, -$CellContext`d, \
$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"V", 
        StyleBox[GridBox[{
           {"d"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`V[$CellContext`d],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubsuperscriptBox["\[EmptyDownTriangle]", 
      RowBox[{"(", "ba", ")"}], "    "], GridBox[{
       {"V", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CD[-$CellContext`b, -$CellContext`a][
    $CellContext`V[$CellContext`c]],
   Editable->False]}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1362076014]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "@", 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "b"}], "]"}], "@", 
    RowBox[{"V", "[", "c", "]"}]}]}], "+", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "b"}], "]"}], "@", 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "a"}], "]"}], "@", 
    RowBox[{"V", "[", "c", "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%", "//", "SymmetrizeCovDs"}], "//", "ToCanonical"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->235890278],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[EmptyDownTriangle]", "a"], 
     SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
       {"V", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CD[-$CellContext`a][
    $CellContext`CD[-$CellContext`b][
     $CellContext`V[$CellContext`c]]],
   Editable->False], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[EmptyDownTriangle]", "b"], 
     SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
       {"V", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CD[-$CellContext`b][
    $CellContext`CD[-$CellContext`a][
     $CellContext`V[$CellContext`c]]],
   Editable->False]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1079780814],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      SubsuperscriptBox["\[EmptyDownTriangle]", 
       RowBox[{"(", "ab", ")"}], "    "], GridBox[{
        {"V", 
         StyleBox[GridBox[{
            {"c"},
            {" "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}]}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`CD[-$CellContext`a, -$CellContext`b][
     $CellContext`V[$CellContext`c]],
    Editable->False], ")"}]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1639323748]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "a"}], "]"}], "@", 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "b"}], "]"}], "@", 
    RowBox[{"V", "[", "c", "]"}]}]}], "-", 
  RowBox[{
   RowBox[{"CD", "[", 
    RowBox[{"-", "b"}], "]"}], "@", 
   RowBox[{
    RowBox[{"CD", "[", 
     RowBox[{"-", "a"}], "]"}], "@", 
    RowBox[{"V", "[", "c", "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"%", "//", "SymmetrizeCovDs"}], "//", "ToCanonical"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->2046525273],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[EmptyDownTriangle]", "a"], 
     SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
       {"V", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CD[-$CellContext`a][
    $CellContext`CD[-$CellContext`b][
     $CellContext`V[$CellContext`c]]],
   Editable->False], "-", 
  InterpretationBox[
   StyleBox[
    RowBox[{
     SubscriptBox["\[EmptyDownTriangle]", "b"], 
     SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
       {"V", 
        StyleBox[GridBox[{
           {"c"},
           {" "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}]}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`CD[-$CellContext`b][
    $CellContext`CD[-$CellContext`a][
     $CellContext`V[$CellContext`c]]],
   Editable->False]}]], "Output",
 CellLabel->"Out[3]=",
 CellID->2126857985],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {" ", " ", "c", " "},
          {"a", "b", " ", "d"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RiemannCD[-$CellContext`a, -$CellContext`b, $CellContext`c, \
-$CellContext`d],
   Editable->False], " ", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"V", 
       StyleBox[GridBox[{
          {"d"},
          {" "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`V[$CellContext`d],
   Editable->False]}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1236849580]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->2061341341],

Cell[CellGroupData[{

Cell[TextData[{
 "\"UseCache\"",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSubsection", "ExampleSubsection",
 WholeCellGroupOpener->True,
 CellID->1757724783],

Cell["By default, symmetrizations are cached:", "ExampleText",
 CellID->59600139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetrizeCovDs", "[", " ", 
   RowBox[{
    RowBox[{"CD", "[", "a", "]"}], "@", 
    RowBox[{
     RowBox[{"CD", "[", "b", "]"}], "@", 
     RowBox[{
      RowBox[{"CD", "[", "c", "]"}], "@", 
      RowBox[{"RiemannCD", "[", 
       RowBox[{"d", ",", "e", ",", "f", ",", "g"}], "]"}]}]}]}], " ", "]"}], 
  " ", "//", " ", "AbsoluteTiming"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1679375968],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.709415`6.302445360530622", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "3"]}], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"e", "h", "f", "g"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`e, $CellContext`h, $CellContext`f, \
$CellContext`g],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"b", "c", "d", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`a][
        $CellContext`RiemannCD[$CellContext`b, $CellContext`c, \
$CellContext`d, -$CellContext`h]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"d", "h", "f", "g"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`d, $CellContext`h, $CellContext`f, \
$CellContext`g],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"b", "c", "e", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`a][
        $CellContext`RiemannCD[$CellContext`b, $CellContext`c, \
$CellContext`e, -$CellContext`h]],
       Editable->False], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"d", "e", "g", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`d, $CellContext`e, $CellContext`g, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"b", "c", "f", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`a][
        $CellContext`RiemannCD[$CellContext`b, $CellContext`c, \
$CellContext`f, -$CellContext`h]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"d", "e", "f", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`d, $CellContext`e, $CellContext`f, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"b", "c", "g", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`a][
        $CellContext`RiemannCD[$CellContext`b, $CellContext`c, \
$CellContext`g, -$CellContext`h]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"b", "c", "g", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`b, $CellContext`c, $CellContext`g, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", "e", "f", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`a][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, -$CellContext`h]],
       Editable->False], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"b", "c", "f", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`b, $CellContext`c, $CellContext`f, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", "e", "g", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`a][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`g, -$CellContext`h]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"b", "c", "e", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`b, $CellContext`c, $CellContext`e, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", " ", "f", "g"},
               {" ", "h", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`a][
        $CellContext`RiemannCD[$CellContext`d, -$CellContext`h, \
$CellContext`f, $CellContext`g]],
       Editable->False], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"b", "c", "d", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`b, $CellContext`c, $CellContext`d, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"e", " ", "f", "g"},
               {" ", "h", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`a][
        $CellContext`RiemannCD[$CellContext`e, -$CellContext`h, \
$CellContext`f, $CellContext`g]],
       Editable->False], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"e", "h", "f", "g"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`e, $CellContext`h, $CellContext`f, \
$CellContext`g],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"a", "c", "d", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`b][
        $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
$CellContext`d, -$CellContext`h]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"d", "h", "f", "g"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`d, $CellContext`h, $CellContext`f, \
$CellContext`g],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"a", "c", "e", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`b][
        $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
$CellContext`e, -$CellContext`h]],
       Editable->False], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"d", "e", "g", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`d, $CellContext`e, $CellContext`g, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"a", "c", "f", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`b][
        $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
$CellContext`f, -$CellContext`h]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"d", "e", "f", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`d, $CellContext`e, $CellContext`f, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"a", "c", "g", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`b][
        $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
$CellContext`g, -$CellContext`h]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "c", "g", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`c, $CellContext`g, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", "e", "f", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`b][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, -$CellContext`h]],
       Editable->False], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "c", "f", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`c, $CellContext`f, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", "e", "g", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`b][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`g, -$CellContext`h]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "c", "e", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`c, $CellContext`e, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", " ", "f", "g"},
               {" ", "h", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`b][
        $CellContext`RiemannCD[$CellContext`d, -$CellContext`h, \
$CellContext`f, $CellContext`g]],
       Editable->False], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "c", "d", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`c, $CellContext`d, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"e", " ", "f", "g"},
               {" ", "h", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`b][
        $CellContext`RiemannCD[$CellContext`e, -$CellContext`h, \
$CellContext`f, $CellContext`g]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "b", "g", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`g, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", "e", "f", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`c][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, -$CellContext`h]],
       Editable->False], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "b", "f", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`f, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", "e", "g", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`c][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`g, -$CellContext`h]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "b", "e", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`e, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", " ", "f", "g"},
               {" ", "h", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`c][
        $CellContext`RiemannCD[$CellContext`d, -$CellContext`h, \
$CellContext`f, $CellContext`g]],
       Editable->False], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "b", "d", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`d, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"e", " ", "f", "g"},
               {" ", "h", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`c][
        $CellContext`RiemannCD[$CellContext`e, -$CellContext`h, \
$CellContext`f, $CellContext`g]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "b", "c", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[EmptyDownTriangle]", "h"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", "e", "f", "g"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`h][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`g]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "c", "b", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`c, $CellContext`b, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[EmptyDownTriangle]", "h"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", "e", "f", "g"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`h][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`g]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "h", "b", "c"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`h, $CellContext`b, \
$CellContext`c],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[EmptyDownTriangle]", "h"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", "e", "f", "g"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`h][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`g]],
       Editable->False], ")"}]}], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", "     ", 
        RowBox[{"(", "abc", ")"}]], GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"d", "e", "f", "g"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`a, $CellContext`b, $CellContext`c][
      $CellContext`RiemannCD[$CellContext`d, $CellContext`e, $CellContext`f, \
$CellContext`g]],
     Editable->False]}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->510880607]
}, Open  ]],

Cell["Subsequent symmetrizations are then faster:", "ExampleText",
 CellID->730741143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetrizeCovDs", "[", " ", 
   RowBox[{
    RowBox[{"CD", "[", "a", "]"}], "@", 
    RowBox[{
     RowBox[{"CD", "[", "b", "]"}], "@", 
     RowBox[{
      RowBox[{"CD", "[", "c", "]"}], "@", 
      RowBox[{"RiemannCD", "[", 
       RowBox[{"d", ",", "e", ",", "f", ",", "g"}], "]"}]}]}]}], " ", "]"}], 
  " ", "//", " ", "AbsoluteTiming"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->107413208],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.003196`3.956151764137922", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "3"]}], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"e", "h", "f", "g"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`e, $CellContext`h, $CellContext`f, \
$CellContext`g],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"b", "c", "d", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`a][
        $CellContext`RiemannCD[$CellContext`b, $CellContext`c, \
$CellContext`d, -$CellContext`h]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"d", "h", "f", "g"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`d, $CellContext`h, $CellContext`f, \
$CellContext`g],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"b", "c", "e", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`a][
        $CellContext`RiemannCD[$CellContext`b, $CellContext`c, \
$CellContext`e, -$CellContext`h]],
       Editable->False], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"d", "e", "g", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`d, $CellContext`e, $CellContext`g, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"b", "c", "f", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`a][
        $CellContext`RiemannCD[$CellContext`b, $CellContext`c, \
$CellContext`f, -$CellContext`h]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"d", "e", "f", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`d, $CellContext`e, $CellContext`f, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"b", "c", "g", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`a][
        $CellContext`RiemannCD[$CellContext`b, $CellContext`c, \
$CellContext`g, -$CellContext`h]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"b", "c", "g", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`b, $CellContext`c, $CellContext`g, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", "e", "f", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`a][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, -$CellContext`h]],
       Editable->False], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"b", "c", "f", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`b, $CellContext`c, $CellContext`f, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", "e", "g", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`a][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`g, -$CellContext`h]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"b", "c", "e", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`b, $CellContext`c, $CellContext`e, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", " ", "f", "g"},
               {" ", "h", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`a][
        $CellContext`RiemannCD[$CellContext`d, -$CellContext`h, \
$CellContext`f, $CellContext`g]],
       Editable->False], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"b", "c", "d", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`b, $CellContext`c, $CellContext`d, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"e", " ", "f", "g"},
               {" ", "h", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`a][
        $CellContext`RiemannCD[$CellContext`e, -$CellContext`h, \
$CellContext`f, $CellContext`g]],
       Editable->False], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"e", "h", "f", "g"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`e, $CellContext`h, $CellContext`f, \
$CellContext`g],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"a", "c", "d", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`b][
        $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
$CellContext`d, -$CellContext`h]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"d", "h", "f", "g"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`d, $CellContext`h, $CellContext`f, \
$CellContext`g],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"a", "c", "e", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`b][
        $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
$CellContext`e, -$CellContext`h]],
       Editable->False], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"d", "e", "g", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`d, $CellContext`e, $CellContext`g, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"a", "c", "f", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`b][
        $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
$CellContext`f, -$CellContext`h]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"d", "e", "f", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`d, $CellContext`e, $CellContext`f, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"a", "c", "g", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`b][
        $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
$CellContext`g, -$CellContext`h]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "c", "g", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`c, $CellContext`g, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", "e", "f", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`b][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, -$CellContext`h]],
       Editable->False], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "c", "f", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`c, $CellContext`f, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", "e", "g", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`b][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`g, -$CellContext`h]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "c", "e", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`c, $CellContext`e, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", " ", "f", "g"},
               {" ", "h", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`b][
        $CellContext`RiemannCD[$CellContext`d, -$CellContext`h, \
$CellContext`f, $CellContext`g]],
       Editable->False], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "c", "d", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`c, $CellContext`d, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"e", " ", "f", "g"},
               {" ", "h", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`b][
        $CellContext`RiemannCD[$CellContext`e, -$CellContext`h, \
$CellContext`f, $CellContext`g]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "b", "g", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`g, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", "e", "f", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`c][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, -$CellContext`h]],
       Editable->False], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "b", "f", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`f, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", "e", "g", " "},
               {" ", " ", " ", "h"}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`c][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`g, -$CellContext`h]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "b", "e", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`e, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", " ", "f", "g"},
               {" ", "h", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`c][
        $CellContext`RiemannCD[$CellContext`d, -$CellContext`h, \
$CellContext`f, $CellContext`g]],
       Editable->False], ")"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "b", "d", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`d, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"e", " ", "f", "g"},
               {" ", "h", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[$CellContext`c][
        $CellContext`RiemannCD[$CellContext`e, -$CellContext`h, \
$CellContext`f, $CellContext`g]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "b", "c", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`b, $CellContext`c, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[EmptyDownTriangle]", "h"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", "e", "f", "g"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`h][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`g]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "c", "b", "h"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`c, $CellContext`b, \
$CellContext`h],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[EmptyDownTriangle]", "h"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", "e", "f", "g"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`h][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`g]],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"a", "h", "b", "c"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[$CellContext`a, $CellContext`h, $CellContext`b, \
$CellContext`c],
      Editable->False], " ", 
     RowBox[{"(", 
      InterpretationBox[
       StyleBox[
        RowBox[{
         SubscriptBox["\[EmptyDownTriangle]", "h"], GridBox[{
           {
            RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
            StyleBox[GridBox[{
               {"d", "e", "f", "g"},
               {" ", " ", " ", " "}
              },
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                   Offset[0.]}}, "RowsIndexed" -> {}}],
             FontSize->9]}
          },
          
          GridBoxAlignment->{
           "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
            "Rows" -> {{Center}}, "RowsIndexed" -> {}},
          GridBoxSpacings->{"Columns" -> {
              Offset[0.27999999999999997`], {
               Offset[0.034999999999999996`]}, 
              Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
              Offset[0.2], {
               Offset[0.4]}, 
              Offset[0.2]}, "RowsIndexed" -> {}}]}],
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`CD[-$CellContext`h][
        $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`g]],
       Editable->False], ")"}]}], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", "     ", 
        RowBox[{"(", "abc", ")"}]], GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"d", "e", "f", "g"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`a, $CellContext`b, $CellContext`c][
      $CellContext`RiemannCD[$CellContext`d, $CellContext`e, $CellContext`f, \
$CellContext`g]],
     Editable->False]}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->315093341]
}, Open  ]],

Cell["\<\
But the first symmetrization was slower compared to when no cache is used:\
\>", "ExampleText",
 CellID->79108685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SymmetrizeCovDs", "[", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"CD", "[", "a", "]"}], "@", 
     RowBox[{
      RowBox[{"CD", "[", "b", "]"}], "@", 
      RowBox[{
       RowBox[{"CD", "[", "c", "]"}], "@", 
       RowBox[{"RiemannCD", "[", 
        RowBox[{"d", ",", "e", ",", "f", ",", "g"}], "]"}]}]}]}], ",", " ", 
    RowBox[{"\"\<UseCache\>\"", "\[Rule]", "False"}]}], " ", "]"}], " ", "//",
   " ", "AbsoluteTiming"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->287291302],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.01782`4.702452693196827", ",", 
   RowBox[{
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
              StyleBox[GridBox[{
                 {"h", "e", "f", "g"},
                 {" ", " ", " ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`h, $CellContext`e, \
$CellContext`f, $CellContext`g],
          Editable->False]}], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"b", "c", " ", "d"},
                  {" ", " ", "h", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`a][
           $CellContext`RiemannCD[$CellContext`b, $CellContext`c, \
-$CellContext`h, $CellContext`d]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"d", "h", "f", "g"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`d, $CellContext`h, \
$CellContext`f, $CellContext`g],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"b", "c", " ", "e"},
                  {" ", " ", "h", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`a][
           $CellContext`RiemannCD[$CellContext`b, $CellContext`c, \
-$CellContext`h, $CellContext`e]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"d", "e", "h", "g"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`h, $CellContext`g],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"b", "c", " ", "f"},
                  {" ", " ", "h", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`a][
           $CellContext`RiemannCD[$CellContext`b, $CellContext`c, \
-$CellContext`h, $CellContext`f]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"d", "e", "f", "h"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`h],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"b", "c", " ", "g"},
                  {" ", " ", "h", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`a][
           $CellContext`RiemannCD[$CellContext`b, $CellContext`c, \
-$CellContext`h, $CellContext`g]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"h", "e", "f", "g"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`h, $CellContext`e, \
$CellContext`f, $CellContext`g],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "c", " ", "d"},
                  {" ", " ", "h", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`b][
           $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
-$CellContext`h, $CellContext`d]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"d", "h", "f", "g"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`d, $CellContext`h, \
$CellContext`f, $CellContext`g],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "c", " ", "e"},
                  {" ", " ", "h", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`b][
           $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
-$CellContext`h, $CellContext`e]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"d", "e", "h", "g"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`h, $CellContext`g],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "c", " ", "f"},
                  {" ", " ", "h", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`b][
           $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
-$CellContext`h, $CellContext`f]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"d", "e", "f", "h"},
                {" ", " ", " ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`h],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"a", "c", " ", "g"},
                  {" ", " ", "h", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`b][
           $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
-$CellContext`h, $CellContext`g]],
          Editable->False], ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
              StyleBox[GridBox[{
                 {"b", "c", " ", "g"},
                 {" ", " ", "h", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`b, $CellContext`c, \
-$CellContext`h, $CellContext`g],
          Editable->False]}], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"d", "e", "f", "h"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`a][
           $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`h]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"b", "c", " ", "f"},
                {" ", " ", "h", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`b, $CellContext`c, \
-$CellContext`h, $CellContext`f],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"d", "e", "h", "g"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`a][
           $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`h, $CellContext`g]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"b", "c", " ", "e"},
                {" ", " ", "h", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`b, $CellContext`c, \
-$CellContext`h, $CellContext`e],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"d", "h", "f", "g"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`a][
           $CellContext`RiemannCD[$CellContext`d, $CellContext`h, \
$CellContext`f, $CellContext`g]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"b", "c", " ", "d"},
                {" ", " ", "h", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`b, $CellContext`c, \
-$CellContext`h, $CellContext`d],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"h", "e", "f", "g"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`a][
           $CellContext`RiemannCD[$CellContext`h, $CellContext`e, \
$CellContext`f, $CellContext`g]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"a", "c", " ", "g"},
                {" ", " ", "h", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
-$CellContext`h, $CellContext`g],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"d", "e", "f", "h"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`b][
           $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`h]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"a", "c", " ", "f"},
                {" ", " ", "h", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
-$CellContext`h, $CellContext`f],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"d", "e", "h", "g"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`b][
           $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`h, $CellContext`g]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"a", "c", " ", "e"},
                {" ", " ", "h", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
-$CellContext`h, $CellContext`e],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"d", "h", "f", "g"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`b][
           $CellContext`RiemannCD[$CellContext`d, $CellContext`h, \
$CellContext`f, $CellContext`g]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"a", "c", " ", "d"},
                {" ", " ", "h", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
-$CellContext`h, $CellContext`d],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"h", "e", "f", "g"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`b][
           $CellContext`RiemannCD[$CellContext`h, $CellContext`e, \
$CellContext`f, $CellContext`g]],
          Editable->False], ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"b", "a", " ", "g"},
                {" ", " ", "h", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`b, $CellContext`a, \
-$CellContext`h, $CellContext`g],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"d", "e", "f", "h"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`c][
           $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`h]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"b", "a", " ", "f"},
                {" ", " ", "h", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`b, $CellContext`a, \
-$CellContext`h, $CellContext`f],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"d", "e", "h", "g"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`c][
           $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`h, $CellContext`g]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"b", "a", " ", "e"},
                {" ", " ", "h", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`b, $CellContext`a, \
-$CellContext`h, $CellContext`e],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"d", "h", "f", "g"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`c][
           $CellContext`RiemannCD[$CellContext`d, $CellContext`h, \
$CellContext`f, $CellContext`g]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"b", "a", " ", "d"},
                {" ", " ", "h", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`b, $CellContext`a, \
-$CellContext`h, $CellContext`d],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"h", "e", "f", "g"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`c][
           $CellContext`RiemannCD[$CellContext`h, $CellContext`e, \
$CellContext`f, $CellContext`g]],
          Editable->False], ")"}]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"b", "a", " ", "c"},
                {" ", " ", "h", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`b, $CellContext`a, \
-$CellContext`h, $CellContext`c],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "h"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"d", "e", "f", "g"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`h][
           $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`g]],
          Editable->False], ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {
              RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
              StyleBox[GridBox[{
                 {"a", "c", " ", "b"},
                 {" ", " ", "h", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`RiemannCD[$CellContext`a, $CellContext`c, \
-$CellContext`h, $CellContext`b],
          Editable->False]}], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "h"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"d", "e", "f", "g"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`h][
           $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`g]],
          Editable->False], ")"}]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {
             RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
             StyleBox[GridBox[{
                {"b", "c", " ", "a"},
                {" ", " ", "h", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`RiemannCD[$CellContext`b, $CellContext`c, \
-$CellContext`h, $CellContext`a],
         Editable->False], " ", 
        RowBox[{"(", 
         InterpretationBox[
          StyleBox[
           RowBox[{
            SuperscriptBox["\[EmptyDownTriangle]", "h"], GridBox[{
              {
               RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
               StyleBox[GridBox[{
                  {"d", "e", "f", "g"},
                  {" ", " ", " ", " "}
                 },
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                FontSize->9]}
             },
             
             GridBoxAlignment->{
              "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
               "Rows" -> {{Center}}, "RowsIndexed" -> {}},
             GridBoxSpacings->{"Columns" -> {
                 Offset[0.27999999999999997`], {
                  Offset[0.034999999999999996`]}, 
                 Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
               "Rows" -> {
                 Offset[0.2], {
                  Offset[0.4]}, 
                 Offset[0.2]}, "RowsIndexed" -> {}}]}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`CD[$CellContext`h][
           $CellContext`RiemannCD[$CellContext`d, $CellContext`e, \
$CellContext`f, $CellContext`g]],
          Editable->False], ")"}]}]}], ")"}]}], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubsuperscriptBox["\[EmptyDownTriangle]", "     ", 
        RowBox[{"(", "bac", ")"}]], GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"d", "e", "f", "g"},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`b, $CellContext`a, $CellContext`c][
      $CellContext`RiemannCD[$CellContext`d, $CellContext`e, $CellContext`f, \
$CellContext`g]],
     Editable->False]}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1586969960]
}, Open  ]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpandSymCovDs",
    BaseStyle->"Link",
    ButtonData->"paclet:xTras/ref/ExpandSymCovDs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymCovDQ",
    BaseStyle->"Link",
    ButtonData->"paclet:xTras/ref/SymCovDQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$AutoSymmetrizeCovDs",
    BaseStyle->"Link",
    ButtonData->"paclet:xTras/ref/$AutoSymmetrizeCovDs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClearSymCovDCache",
    BaseStyle->"Link",
    ButtonData->"paclet:xTras/ref/ClearSymCovDCache"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "TutorialsSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "TUTORIALS", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "TutorialsSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Tutorials"}], "TutorialsSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->250839057],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["Symmetrized Covariant Derivatives",
 BaseStyle->"Link",
 ButtonData->"paclet:xTras/tutorial/SymmetrizedDerivatives"]], "Tutorials",
 CellID->341631938],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "MoreAboutSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "MORE ABOUT", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "MoreAboutSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "More About"}], "MoreAboutSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->38303248],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["xTras package",
 BaseStyle->"Link",
 ButtonData->"paclet:xTras/guide/xTras"]], "MoreAbout",
 CellID->1715185880],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SymmetrizeCovDs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "xTras package", ButtonData -> "paclet:xTras/guide/xTras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 10, 30, 13, 16, 45.448444}", 
    "history" -> {"1.3.0", "1.3.1", "", ""}, "context" -> "xTras`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "xTras Symbol", "language" -> "en", "paclet" -> "xTras", "status" -> 
    "None", "summary" -> 
    "SymmetrizeCovDs[expr] symmetrizes all symmetrizable covariant \
derivatives in expr. SymmetrizeCovDs[expr, cd] only symmetrizes the covariant \
derivative cd.", "synonyms" -> {}, "title" -> "SymmetrizeCovDs", 
    "titlemodifier" -> "", "windowtitle" -> "SymmetrizeCovDs", "type" -> 
    "Symbol", "uri" -> "xTras/ref/SymmetrizeCovDs"}, "SearchTextTranslated" -> 
  ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

