Notebook[{
Cell[BoxData[GridBox[{
   {Cell["XTRAS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"See Also \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"YoungProject\"\>":>
       Documentation`HelpLookup[
       "paclet:xTras/ref/YoungProject"], "\<\"TableauSymmetric\"\>":>
       Documentation`HelpLookup["paclet:xTras/ref/TableauSymmetric"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"xTras/ref/YoungTableauQ\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["xTras/ref/YoungTableauQ"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/xTras/ref/\
YoungTableauQ.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "xTras/ref/YoungTableauQ", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.65], {
      Scaled[0.34]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->1],

Cell[CellGroupData[{

Cell["YoungTableauQ", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"YoungTableauQ", "[", 
       StyleBox["tab", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns True if ",
     Cell[BoxData[
      StyleBox["tab", "TI"]], "InlineFormula"],
     " is a proper Young tableau, and False otherwise."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "NotesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellGroupingRules->{"SectionGrouping", 50},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       Cell[
        BoxData[
         ButtonBox[
          FrameBox[
           StyleBox[
            RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"], 
           StripOnInput -> False], Appearance -> {Automatic, None}, BaseStyle -> 
          None, ButtonFunction :> (FrontEndExecute[{
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], All, ButtonCell], 
             FrontEndToken["OpenCloseGroup"], 
             FrontEnd`SelectionMove[
              FrontEnd`SelectedNotebook[], After, CellContents]}]& ), 
          Evaluator -> None, Method -> "Preemptive"]]]], "NotesSection", 
      CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Details"}], "NotesSection", 
        CellSize -> {5000, Inherited}], Appearance -> {Automatic, None}, 
       BaseStyle -> None, ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& ), Evaluator -> 
       None, Method -> "Preemptive"]]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->947728527],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell["\<\
A proper Young tableau is a list of lists of either integers or of symbols, \
whose entries only occur once. Furthermore the length of the lists has to \
decrease monotonically.\
\>", "Notes",
 CellID->1067943069],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Closed]],

Cell[CellGroupData[{

Cell["", "PrimaryExamplesSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "EXAMPLES", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "PrimaryExamplesSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "Examples", "  ", 
          Cell["(1)", "ExampleCount"]}], "PrimaryExamplesSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellTags->"PrimaryExamplesSection",
 CellID->587143490],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection", "ExampleSection",
 WholeCellGroupOpener->True,
 CellID->433278465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"YoungTableauQ", "[", 
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1435177368],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[1]=",
 CellID->489700872]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"YoungTableauQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", "c", "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1245220400],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[2]=",
 CellID->1191122785]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"YoungTableauQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", "a", "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->358090161],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[3]=",
 CellID->1575759700]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"YoungTableauQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "a", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "c"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1024943096],

Cell[BoxData["False"], "Output",
 CellLabel->"Out[4]=",
 CellID->1252281885]
}, Open  ]],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "SeeAlsoSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
      TextData[
       ButtonBox[
       "SEE ALSO", BaseStyle -> None, Appearance -> {Automatic, None}, 
        Evaluator -> None, Method -> "Preemptive", 
        ButtonFunction :> (FrontEndExecute[{
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], All, ButtonCell], 
           FrontEndToken["OpenCloseGroup"], 
           FrontEnd`SelectionMove[
            FrontEnd`SelectedNotebook[], After, CellContents]}]& )]], 
      "SeeAlsoSection", CellSize -> {5000, Inherited}], 
     TextData[
      ButtonBox[
       Cell[
        TextData[{
          Cell[
           BoxData[
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[24]]]], "See Also"}], "SeeAlsoSection", 
        CellSize -> {5000, Inherited}], BaseStyle -> None, 
       Appearance -> {Automatic, None}, Evaluator -> None, Method -> 
       "Preemptive", ButtonFunction :> (FrontEndExecute[{
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], All, ButtonCell], 
          FrontEndToken["OpenCloseGroup"], 
          FrontEnd`SelectionMove[
           FrontEnd`SelectedNotebook[], After, CellContents]}]& )]]], None}, {
   None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["YoungProject",
    BaseStyle->"Link",
    ButtonData->"paclet:xTras/ref/YoungProject"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[MediumSpace]\[FilledVerySmallSquare]\[MediumSpace]", 
  "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TableauSymmetric",
    BaseStyle->"Link",
    ButtonData->"paclet:xTras/ref/TableauSymmetric"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"YoungTableauQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "SymbolColor", "LinkTrails" -> 
  GridBox[{{
      RowBox[{
        ButtonBox[
        "xTras package", ButtonData -> "paclet:xTras/guide/xTras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 10, 30, 13, 18, 0.599293}", 
    "history" -> {"1.0.0", "", "", ""}, "context" -> "xTras`", 
    "keywords" -> {}, "specialkeywords" -> {}, 
    "tutorialcollectionlinks" -> {}, "index" -> True, "label" -> 
    "xTras Package Symbol", "language" -> "en", "paclet" -> "xTras Package", 
    "status" -> "None", "summary" -> 
    "YoungTableauQ[tab] returns True if tab is a proper Young tableau, and \
False otherwise.", "synonyms" -> {}, "title" -> "YoungTableauQ", 
    "titlemodifier" -> "", "windowtitle" -> "YoungTableauQ", "type" -> 
    "Symbol", "uri" -> "xTras/ref/YoungTableauQ"}, "SearchTextTranslated" -> 
  ""},
CellContext->"Global`",
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

