Notebook[{
Cell[BoxData[GridBox[{
   {Cell["XTRAS TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Related Tutorials \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"Metric Variations\"\>":>
       Documentation`HelpLookup["paclet:xTras/tutorial/MetricVariations"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"Functions \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"ExpandBackground\"\>":>
       Documentation`HelpLookup[
       "paclet:xTras/ref/ExpandBackground"], "\<\"SymmetricSpaceRules\"\>":>
       Documentation`HelpLookup[
       "paclet:xTras/ref/SymmetricSpaceRules"], "\<\"ToBackground\"\>":>
       Documentation`HelpLookup["paclet:xTras/ref/ToBackground"]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      ActionMenuBox[
       FrameBox["\<\"URL \[RightGuillemet]\"\>",
        StripOnInput->False], {"\<\"xTras/tutorial/AdSPerturbations\"\>":>
       None, "\<\"Copy Mathematica url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell["xTras/tutorial/AdSPerturbations"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; Null], 
       Delimiter, "\<\"Copy web url\"\>":>
       Module[{DocumentationSearch`Private`nb$}, 
        DocumentationSearch`Private`nb$ = NotebookPut[
           Notebook[{
             Cell[
              BoxData[
               MakeBoxes[
                Hyperlink[
                "http://reference.wolfram.com/mathematica/xTras/tutorial/\
AdSPerturbations.html"], StandardForm]], "Input", TextClipboardType -> 
              "PlainText"]}, Visible -> False]]; 
        SelectionMove[DocumentationSearch`Private`nb$, All, Notebook]; 
        FrontEndTokenExecute[DocumentationSearch`Private`nb$, "Copy"]; 
        NotebookClose[DocumentationSearch`Private`nb$]; 
        Null], "\<\"Go to web url\"\>":>FrontEndExecute[{
         NotebookLocate[{
           URL[
            StringJoin[
            "http://reference.wolfram.com/mathematica/", 
             "xTras/tutorial/AdSPerturbations", ".html"]], None}]}]},
       Appearance->None,
       MenuAppearance->Automatic]],
      LineSpacing->{1.4, 0}]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid",
 CellID->1],

Cell[CellGroupData[{

Cell["AdS Perturbations", "Title",
 CellID->509267359],

Cell[TextData[{
 StyleBox["xTras",
  FontSlant->"Italic"],
 " has a number of functions that allow for perturbations around (A)dS \
backgrounds. Before discussing them, we'll first have a look at the basic \
functionality provided in the native ",
 StyleBox["xAct",
  FontSlant->"Italic"],
 " package ",
 StyleBox["xPert",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->1534169418],

Cell[CellGroupData[{

Cell["xPert functions", "Section",
 CellID->38451827],

Cell[BoxData[GridBox[{
   {
    RowBox[{"Perturbation", "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], Cell[TextData[{
     "returns the ",
     StyleBox["n", "TI"],
     "th order perturbation of ",
     StyleBox["expr", "TI"]
    }], "TableText"]},
   {
    RowBox[{"ExpandPerturbation", "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "expand any unexpanded ",
     StyleBox["Perturbation[tensor]", "InlineCode"],
     " terms in ",
     StyleBox["expr", "TI"]
    }], "TableText"]},
   {
    RowBox[{"DefTensorPerturbation", "[", 
     RowBox[{
      StyleBox["pert", "TI"], ",", 
      StyleBox["tens", "TI"], ",", 
      StyleBox["M", "TI"]}], "]"}], Cell[TextData[{
     "defines the perturbation ",
     StyleBox["pert", "TI"],
     " for the tensor ",
     StyleBox["tens", "TI"],
     " on the manifold ",
     StyleBox["M", "TI"]
    }], "TableText"]},
   {
    RowBox[{"DeMetricPerturbation", "[", 
     RowBox[{
      StyleBox["g", "TI"], ",", 
      StyleBox["pert", "TI"], ",", 
      StyleBox["par", "TI"]}], "]"}], Cell[TextData[{
     "defines the perturbation ",
     StyleBox["pert", "TI"],
     " of the metric ",
     StyleBox["g", "TI"],
     " and the perturbations of the associated curvature tensors, with \
expansion parameter ",
     StyleBox["par", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->1710487748],

Cell["Main xPert functions.", "Caption",
 CellID->1951481894],

Cell[TextData[{
 "Expression can be perturbed with ",
 Cell[BoxData["Perturbation"], "InlineFormula"],
 ":"
}], "Text",
 CellID->2014762289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", 
  RowBox[{"metric", "[", 
   RowBox[{
    RowBox[{"-", "a"}], ",", 
    RowBox[{"-", "b"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->1144277440],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {"\[EmptyUpTriangle]g", 
      StyleBox[GridBox[{
         {"1", " ", " "},
         {" ", "a", "b"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.], {
             Offset[0.034999999999999996`]}, 
            Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
             Offset[0.]}}, "RowsIndexed" -> {}}],
       FontSize->9]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.034999999999999996`]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  $CellContext`Perturbationmetric[
   xAct`xTensor`LI[1], -$CellContext`a, -$CellContext`b],
  Editable->False]], "Output",
 CellLabel->"Out[11]=",
 CellID->1154875195]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", 
  RowBox[{"metric", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->1030200779],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{"\[EmptyUpTriangle]", "[", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"g", 
         StyleBox[GridBox[{
            {"a", "b"},
            {" ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`metric[$CellContext`a, $CellContext`b],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xPert`Perturbation[
   $CellContext`metric[$CellContext`a, $CellContext`b]],
  Editable->False]], "Output",
 CellLabel->"Out[12]=",
 CellID->1571330539]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Perturbation", "[", 
  RowBox[{"RicciScalarCD", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1616515084],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   RowBox[{"\[EmptyUpTriangle]", "[", 
    InterpretationBox[
     StyleBox[
      RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciScalarCD[],
     Editable->False], "]"}],
   ShowAutoStyles->False,
   AutoSpacing->False],
  xAct`xPert`Perturbation[
   $CellContext`RicciScalarCD[]],
  Editable->False]], "Output",
 CellLabel->"Out[10]=",
 CellID->953398591]
}, Open  ]],

Cell[TextData[{
 "This gives the unexpanded perturbations of the input expressions, unless \
the input is a tensor for which a perturbation is defined. ",
 StyleBox["xTras",
  FontSlant->"Italic"],
 " automatically defines a metric perturbation (see the tutorial ",
 ButtonBox["Metric Variations",
  BaseStyle->"Link",
  ButtonData->"paclet:xTras/tutorial/MetricVariations"],
 "), hence the perturbation of the metric returned the perturbation tensor ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[EmptyUpTriangle]g", 
       StyleBox[GridBox[{
          {"1", " ", " "},
          {" ", "a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Perturbationmetric[
    xAct`xTensor`LI[1], -$CellContext`a, -$CellContext`b],
   Editable->False]]],
 "."
}], "Text",
 CellID->1394628670],

Cell[TextData[{
 "The unexanded perturbations can be expanded with ",
 Cell[BoxData["ExpandPerturbation"], "InlineFormula"],
 ":"
}], "Text",
 CellID->329330842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandPerturbation", "@", 
  RowBox[{"Perturbation", "[", 
   RowBox[{"metric", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[13]:=",
 CellID->1163655290],

Cell[BoxData[
 RowBox[{"-", 
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[EmptyUpTriangle]g", 
       StyleBox[GridBox[{
          {"1", "a", "b"},
          {" ", " ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Perturbationmetric[
    xAct`xTensor`LI[1], $CellContext`a, $CellContext`b],
   Editable->False]}]], "Output",
 CellLabel->"Out[13]=",
 CellID->420885801]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandPerturbation", "@", 
  RowBox[{"Perturbation", "[", 
   RowBox[{"RicciScalarCD", "[", "]"}], "]"}]}]], "Input",
 CellLabel->"In[14]:=",
 CellID->16524189],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[GridBox[{
        {"\[EmptyUpTriangle]g", 
         StyleBox[GridBox[{
            {"1", "a", "b"},
            {" ", " ", " "}
           },
           GridBoxSpacings->{"Columns" -> {
               Offset[0.], {
                Offset[0.034999999999999996`]}, 
               Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                Offset[0.]}}, "RowsIndexed" -> {}}],
          FontSize->9]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.034999999999999996`]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Perturbationmetric[
      xAct`xTensor`LI[1], $CellContext`a, $CellContext`b],
     Editable->False]}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {
        RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciCD[-$CellContext`a, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metric[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          InterpretationBox[
           StyleBox[
            RowBox[{
             SubscriptBox["\[EmptyDownTriangle]", "a"], 
             SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
               {"\[EmptyUpTriangle]g", 
                StyleBox[GridBox[{
                   {"1", "c", " "},
                   {" ", " ", "c"}
                  },
                  GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
                 FontSize->9]}
              },
              
              GridBoxAlignment->{
               "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
                "Rows" -> {{Center}}, "RowsIndexed" -> {}},
              GridBoxSpacings->{"Columns" -> {
                  Offset[0.27999999999999997`], {
                   Offset[0.034999999999999996`]}, 
                  Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
                "Rows" -> {
                  Offset[0.2], {
                   Offset[0.4]}, 
                  Offset[0.2]}, "RowsIndexed" -> {}}]}],
            ShowAutoStyles->False,
            AutoSpacing->False],
           $CellContext`CD[-$CellContext`a][
            $CellContext`CD[-$CellContext`b][
             $CellContext`Perturbationmetric[
              xAct`xTensor`LI[1], $CellContext`c, -$CellContext`c]]],
           Editable->False], ")"}]}], "-", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[EmptyDownTriangle]", "a"], 
           SubscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
             {"\[EmptyUpTriangle]g", 
              StyleBox[GridBox[{
                 {"1", "c", " "},
                 {" ", " ", "b"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}]}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`a][
          $CellContext`CD[-$CellContext`c][
           $CellContext`Perturbationmetric[
            xAct`xTensor`LI[1], $CellContext`c, -$CellContext`b]]],
         Editable->False], "+", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[EmptyDownTriangle]", "a"], 
           SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
             {"\[EmptyUpTriangle]g", 
              StyleBox[GridBox[{
                 {"1", " ", " "},
                 {" ", "b", "c"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}]}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`a][
          $CellContext`CD[$CellContext`c][
           $CellContext`Perturbationmetric[
            xAct`xTensor`LI[1], -$CellContext`b, -$CellContext`c]]],
         Editable->False]}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[EmptyDownTriangle]", "c"], 
           SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
             {"\[EmptyUpTriangle]g", 
              StyleBox[GridBox[{
                 {"1", "c", " "},
                 {" ", " ", "b"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}]}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`c][
          $CellContext`CD[-$CellContext`a][
           $CellContext`Perturbationmetric[
            xAct`xTensor`LI[1], $CellContext`c, -$CellContext`b]]],
         Editable->False], "+", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[EmptyDownTriangle]", "c"], 
           SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
             {"\[EmptyUpTriangle]g", 
              StyleBox[GridBox[{
                 {"1", "c", " "},
                 {" ", " ", "a"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}]}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`c][
          $CellContext`CD[-$CellContext`b][
           $CellContext`Perturbationmetric[
            xAct`xTensor`LI[1], $CellContext`c, -$CellContext`a]]],
         Editable->False], "-", 
        InterpretationBox[
         StyleBox[
          RowBox[{
           SubscriptBox["\[EmptyDownTriangle]", "c"], 
           SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
             {"\[EmptyUpTriangle]g", 
              StyleBox[GridBox[{
                 {"1", " ", " "},
                 {" ", "b", "a"}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}]}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`CD[-$CellContext`c][
          $CellContext`CD[$CellContext`c][
           $CellContext`Perturbationmetric[
            xAct`xTensor`LI[1], -$CellContext`b, -$CellContext`a]]],
         Editable->False]}], ")"}]}]}], ")"}]}]}]], "Output",
 CellLabel->"Out[14]=",
 CellID->696654060]
}, Open  ]],

Cell[TextData[{
 "This expanded the expressions in terms of any defined tensor perturbations, \
in this case ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[GridBox[{
      {"\[EmptyUpTriangle]g", 
       StyleBox[GridBox[{
          {"1", " ", " "},
          {" ", "a", "b"}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`Perturbationmetric[
    xAct`xTensor`LI[1], -$CellContext`a, -$CellContext`b],
   Editable->False]]],
 ". The covariant derivatives and the curvature tensors are now those of the \
background. They can easily be replaced with particular background values \
with the help of ",
 StyleBox["xTras",
  FontSlant->"Italic"],
 " functions."
}], "Text",
 CellID->583942976]
}, Open  ]],

Cell[CellGroupData[{

Cell["xTras additions", "Section",
 CellID->194211840],

Cell["\<\
We'll now turn the xTras functions tailor-made for doing perturbations around \
(A)dS backgrounds.\
\>", "Text",
 CellID->2090735087],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SymmetricSpaceRules",
      BaseStyle->"Link",
      ButtonData->"paclet:xTras/ref/SymmetricSpaceRules"], "[", 
     RowBox[{
      StyleBox["cd", "TI"], ",", 
      StyleBox["K", "TI"]}], "]"}], Cell[TextData[{
     "produces replacement rules for the curvature tensors of the covariant \
derivative ",
     StyleBox["cd", "TI"],
     " on a symmetric space of constant curvature ",
     StyleBox["K", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ToBackground",
      BaseStyle->"Link",
      ButtonData->"paclet:xTras/ref/ToBackground"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[
    "sends unperturbed (curvature) tensors to background values", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["ExpandBackground",
      BaseStyle->"Link",
      ButtonData->"paclet:xTras/ref/ExpandBackground"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "returns the perbutation expansion of ",
     StyleBox["expr", "TI"],
     " on an arbitrary background"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->2096742444],

Cell["The main functions for doing AdS perturbations.", "Caption",
 CellID->1891092685],

Cell[CellGroupData[{

Cell["Setting up", "Subsection",
 CellID->867376873],

Cell["\<\
In this section we will set up things to do perturbations around AdS. First, \
begin with defining a constant symbol for the cosmological constant.\
\>", "Text",
 CellID->1857174995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefConstantSymbol", "[", "\[CapitalLambda]", "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->2058623809],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefConstantSymbol", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"constant symbol \"\>", "\[InvisibleSpace]", 
   "\[CapitalLambda]", "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm[
  "** ", xAct`xTensor`DefConstantSymbol, ": Defining ", 
   "constant symbol ", $CellContext`\[CapitalLambda], ". ", ""],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[25]:=",
 CellID->815695618]
}, Open  ]],

Cell[TextData[{
 "Next, compute the equations of motion for the Einstein-Hilbert term plus a \
cosmological constant with ",
 Cell[BoxData[
  ButtonBox["VarL",
   BaseStyle->"Link",
   ButtonData->"paclet:xTras/ref/VarL"]], "InlineFormula"],
 "."
}], "Text",
 CellID->2012815467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"L", "=", " ", 
  RowBox[{
   RowBox[{"RicciScalarCD", "[", "]"}], " ", "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"dim", "-", "2"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"dim", "-", "1"}], ")"}], " ", "\[CapitalLambda]"}]}]}]], "Input",
 CellLabel->"In[45]:=",
 CellID->860689556],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      InterpretationBox[
       StyleBox["d",
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`Invar`dim,
       Editable->False]}], ")"}]}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     InterpretationBox[
      StyleBox["d",
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`Invar`dim,
      Editable->False]}], ")"}], " ", 
   InterpretationBox[
    StyleBox["\[CapitalLambda]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalLambda],
    Editable->False]}], "+", 
  InterpretationBox[
   StyleBox[
    RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RicciScalarCD[],
   Editable->False]}]], "Output",
 CellLabel->"Out[45]=",
 CellID->159521500]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eom", " ", "=", " ", 
  RowBox[{"CollectTensors", "@", 
   RowBox[{
    RowBox[{"VarL", "[", 
     RowBox[{
      RowBox[{"metric", "[", 
       RowBox[{
        RowBox[{"-", "a"}], ",", 
        RowBox[{"-", "b"}]}], "]"}], ",", "CD"}], "]"}], "[", "L", 
    "]"}]}]}]], "Input",
 CellLabel->"In[46]:=",
 CellID->837074223],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "-", 
     RowBox[{"3", " ", 
      InterpretationBox[
       StyleBox["d",
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`Invar`dim,
       Editable->False]}], "+", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["d",
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`Invar`dim,
       Editable->False], "2"]}], ")"}], " ", 
   InterpretationBox[
    StyleBox["\[CapitalLambda]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalLambda],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metric[$CellContext`a, $CellContext`b],
    Editable->False]}], "-", 
  InterpretationBox[
   StyleBox[GridBox[{
      {
       RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
       StyleBox[GridBox[{
          {"a", "b"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`RicciCD[$CellContext`a, $CellContext`b],
   Editable->False], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metric[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[
     RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`RicciScalarCD[],
    Editable->False]}]}]], "Output",
 CellLabel->"Out[46]=",
 CellID->1018259044]
}, Open  ]],

Cell[TextData[{
 "Now make rules for the background solution of these equations of motion \
with ",
 Cell[BoxData[
  ButtonBox["SymmetricSpaceRules",
   BaseStyle->"Link",
   ButtonData->"paclet:xTras/ref/SymmetricSpaceRules"]], "InlineFormula"],
 ":"
}], "Text",
 CellID->79662678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AdSrules", " ", "=", " ", 
  RowBox[{"SymmetricSpaceRules", "[", 
   RowBox[{"CD", ",", "\[CapitalLambda]"}], "]"}]}]], "Input",
 CellLabel->"In[33]:=",
 CellID->1736603040],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["b", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["c", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["d", "_"], "_"]},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RiemannCD[
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`b, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`c, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`d, 
         Blank[]], TangentM`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{
     InterpretationBox[
      StyleBox["\[CapitalLambda]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalLambda],
      Editable->False], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         InterpretationBox[
          StyleBox[GridBox[{
             {"g", 
              StyleBox[GridBox[{
                 {"a", "d"},
                 {" ", " "}
                },
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                    Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
               FontSize->9]}
            },
            
            GridBoxAlignment->{
             "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {{Center}}, "RowsIndexed" -> {}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
                Offset[0.2], {
                 Offset[0.4]}, 
                Offset[0.2]}, "RowsIndexed" -> {}}],
           ShowAutoStyles->False,
           AutoSpacing->False],
          $CellContext`metric[$CellContext`a, $CellContext`d],
          Editable->False]}], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"b", "c"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`metric[$CellContext`b, $CellContext`c],
         Editable->False]}], "+", 
       RowBox[{
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"a", "c"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`metric[$CellContext`a, $CellContext`c],
         Editable->False], " ", 
        InterpretationBox[
         StyleBox[GridBox[{
            {"g", 
             StyleBox[GridBox[{
                {"b", "d"},
                {" ", " "}
               },
               GridBoxSpacings->{"Columns" -> {
                   Offset[0.], {
                    Offset[0.034999999999999996`]}, 
                   Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                    Offset[0.]}}, "RowsIndexed" -> {}}],
              FontSize->9]}
           },
           
           GridBoxAlignment->{
            "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
             "Rows" -> {{Center}}, "RowsIndexed" -> {}},
           GridBoxSpacings->{"Columns" -> {
               Offset[0.27999999999999997`], {
                Offset[0.034999999999999996`]}, 
               Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
               Offset[0.2], {
                Offset[0.4]}, 
               Offset[0.2]}, "RowsIndexed" -> {}}],
          ShowAutoStyles->False,
          AutoSpacing->False],
         $CellContext`metric[$CellContext`b, $CellContext`d],
         Editable->False]}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"W", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["b", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["c", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["d", "_"], "_"]},
             {" ", " ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`WeylCD[
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`b, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`c, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`d, 
         Blank[]], TangentM`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", "0"}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[
       RowBox[{"K", "[", "\[EmptyDownTriangle]", "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`KretschmannCD[],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       InterpretationBox[
        StyleBox["d",
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`Invar`dim,
        Editable->False]}], ")"}], " ", 
     InterpretationBox[
      StyleBox["d",
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`Invar`dim,
      Editable->False], " ", 
     SuperscriptBox[
      InterpretationBox[
       StyleBox["\[CapitalLambda]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CapitalLambda],
       Editable->False], "2"]}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["b", "_"], "_"]},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciCD[
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`b, 
         Blank[]], TangentM`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       InterpretationBox[
        StyleBox["d",
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`Invar`dim,
        Editable->False]}], ")"}], " ", 
     InterpretationBox[
      StyleBox["\[CapitalLambda]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalLambda],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"a", "b"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`metric[$CellContext`a, $CellContext`b],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"S", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["b", "_"], "_"]},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`TFRicciCD[
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`b, 
         Blank[]], TangentM`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", "0"}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[
       RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`RicciScalarCD[],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       InterpretationBox[
        StyleBox["d",
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`Invar`dim,
        Editable->False]}], ")"}], " ", 
     InterpretationBox[
      StyleBox["d",
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`Invar`dim,
      Editable->False], " ", 
     InterpretationBox[
      StyleBox["\[CapitalLambda]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalLambda],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"S", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["b", "_"], "_"]},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`SchoutenCD[
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`b, 
         Blank[]], TangentM`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     InterpretationBox[
      StyleBox["\[CapitalLambda]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalLambda],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"a", "b"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`metric[$CellContext`a, $CellContext`b],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"S", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"xTras`Private`L$8033_", 
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["b", "_"], "_"]},
             {" ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`SchoutenCCCD[
       xAct`xTensor`LI[
        Pattern[xTras`Private`L$8033, 
         Blank[]]], 
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`b, 
         Blank[]], TangentM`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "xTras`Private`L$8033"}], "+", 
       InterpretationBox[
        StyleBox["\[CapitalLambda]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalLambda],
        Editable->False]}], ")"}], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"a", "b"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`metric[$CellContext`a, $CellContext`b],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"G", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["b", "_"], "_"]},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`EinsteinCD[
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`b, 
         Blank[]], TangentM`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       FractionBox[
        InterpretationBox[
         StyleBox["d",
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`Invar`dim,
         Editable->False], "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       InterpretationBox[
        StyleBox["d",
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`Invar`dim,
        Editable->False]}], ")"}], " ", 
     InterpretationBox[
      StyleBox["\[CapitalLambda]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalLambda],
      Editable->False], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"a", "b"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`metric[$CellContext`a, $CellContext`b],
      Editable->False]}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     InterpretationBox[
      StyleBox[GridBox[{
         {
          RowBox[{"G", "[", "\[EmptyDownTriangle]", "]"}], 
          StyleBox[GridBox[{
             {"xTras`Private`L$8033_", 
              UnderscriptBox[
               UnderscriptBox["a", "_"], "_"], 
              UnderscriptBox[
               UnderscriptBox["b", "_"], "_"]},
             {" ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`EinsteinCCCD[
       xAct`xTensor`LI[
        Pattern[xTras`Private`L$8033, 
         Blank[]]], 
       PatternTest[
        Pattern[$CellContext`a, 
         Blank[]], TangentM`pmQ], 
       PatternTest[
        Pattern[$CellContext`b, 
         Blank[]], TangentM`pmQ]],
      Editable->False], "]"}], "\[RuleDelayed]", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       InterpretationBox[
        StyleBox["d",
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`Invar`dim,
        Editable->False]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       InterpretationBox[
        StyleBox["d",
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`Invar`dim,
        Editable->False]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"xTras`Private`L$8033", "-", 
       InterpretationBox[
        StyleBox["\[CapitalLambda]",
         ShowAutoStyles->False,
         AutoSpacing->False],
        $CellContext`\[CapitalLambda],
        Editable->False]}], ")"}], " ", 
     InterpretationBox[
      StyleBox[GridBox[{
         {"g", 
          StyleBox[GridBox[{
             {"a", "b"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`metric[$CellContext`a, $CellContext`b],
      Editable->False]}]}]}], "}"}]], "Output",
 CellLabel->"Out[33]=",
 CellID->133706563]
}, Open  ]],

Cell["\<\
Check that the background actually solves the equations of motion:\
\>", "Text",
 CellID->1008317065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"eom", "/.", "AdSrules"}], "//", "ToCanonical"}]], "Input",
 CellLabel->"In[44]:=",
 CellID->847532509],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[44]=",
 CellID->1879338976]
}, Open  ]],

Cell[TextData[{
 "We now set this background to the default background solution of ",
 Cell[BoxData[
  ButtonBox["ToBackground",
   BaseStyle->"Link",
   ButtonData->"paclet:xTras/ref/ToBackground"]], "InlineFormula"],
 ". It then also becomes the default background for ",
 Cell[BoxData[
  ButtonBox["PerturbBackground",
   BaseStyle->"Link",
   ButtonData->"paclet:xTras/ref/PerturbBackground"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExpandBackground",
   BaseStyle->"Link",
   ButtonData->"paclet:xTras/ref/ExpandBackground"]], "InlineFormula"],
 "."
}], "Text",
 CellID->991452978],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"ToBackground", ",", 
    RowBox[{"BackgroundSolution", "\[Rule]", "AdSrules"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[48]:=",
 CellID->868732282],

Cell[TextData[{
 "Checking that the background solves the equations of motion can now be done \
with ",
 Cell[BoxData[
  ButtonBox["ToBackground",
   BaseStyle->"Link",
   ButtonData->"paclet:xTras/ref/ToBackground"]], "InlineFormula"],
 ":"
}], "Text",
 CellID->1024584173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToBackground", "[", "eom", "]"}], "//", "ToCanonical"}]], "Input",
 CellLabel->"In[50]:=",
 CellID->2001260501],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[50]=",
 CellID->1717610536]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Linearizing the equations of motion", "Subsection",
 CellID->775147132],

Cell[TextData[{
 "We can now expand the equations of motion on this background with ",
 Cell[BoxData[
  ButtonBox["ExpandBackground",
   BaseStyle->"Link",
   ButtonData->"paclet:xTras/ref/ExpandBackground"]], "InlineFormula"],
 ", in order to obtain the linearized Einstein equations:"
}], "Text",
 CellID->1662313965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"linearEom", "=", 
  RowBox[{
   RowBox[{"ExpandBackground", "[", "eom", "]"}], "//", 
   "CollectTensors"}]}]], "Input",
 CellLabel->"In[54]:=",
 CellID->1711197034],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     InterpretationBox[
      StyleBox["d",
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`Invar`dim,
      Editable->False]}], ")"}], " ", 
   InterpretationBox[
    StyleBox["\[CapitalLambda]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalLambda],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[EmptyUpTriangle]g", 
        StyleBox[GridBox[{
           {"1", "a", "b"},
           {" ", " ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Perturbationmetric[
     xAct`xTensor`LI[1], $CellContext`a, $CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox["\[CapitalLambda]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalLambda],
      Editable->False], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox["d",
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`Invar`dim,
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[CapitalLambda]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CapitalLambda],
       Editable->False]}]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metric[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"\[EmptyUpTriangle]g", 
        StyleBox[GridBox[{
           {"1", "c", " "},
           {" ", " ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`Perturbationmetric[
     xAct`xTensor`LI[1], $CellContext`c, -$CellContext`c],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[EmptyDownTriangle]", "a"], 
       SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
         {"\[EmptyUpTriangle]g", 
          StyleBox[GridBox[{
             {"1", "c", " "},
             {" ", " ", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`a][
      $CellContext`CD[$CellContext`b][
       $CellContext`Perturbationmetric[
        xAct`xTensor`LI[1], $CellContext`c, -$CellContext`c]]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], 
       SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
         {"\[EmptyUpTriangle]g", 
          StyleBox[GridBox[{
             {"1", "b", "c"},
             {" ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`a][
       $CellContext`Perturbationmetric[
        xAct`xTensor`LI[1], $CellContext`b, $CellContext`c]]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], 
       SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
         {"\[EmptyUpTriangle]g", 
          StyleBox[GridBox[{
             {"1", "a", "c"},
             {" ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`b][
       $CellContext`Perturbationmetric[
        xAct`xTensor`LI[1], $CellContext`a, $CellContext`c]]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], 
       SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"\[EmptyUpTriangle]g", 
          StyleBox[GridBox[{
             {"1", "a", "b"},
             {" ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`c][
       $CellContext`Perturbationmetric[
        xAct`xTensor`LI[1], $CellContext`a, $CellContext`b]]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metric[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "d"], 
       SubscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"\[EmptyUpTriangle]g", 
          StyleBox[GridBox[{
             {"1", "c", "d"},
             {" ", " ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`d][
      $CellContext`CD[-$CellContext`c][
       $CellContext`Perturbationmetric[
        xAct`xTensor`LI[1], $CellContext`c, $CellContext`d]]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metric[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "d"], 
       SuperscriptBox["\[EmptyDownTriangle]", "d"], GridBox[{
         {"\[EmptyUpTriangle]g", 
          StyleBox[GridBox[{
             {"1", "c", " "},
             {" ", " ", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`d][
      $CellContext`CD[$CellContext`d][
       $CellContext`Perturbationmetric[
        xAct`xTensor`LI[1], $CellContext`c, -$CellContext`c]]],
     Editable->False], ")"}]}]}]], "Output",
 CellLabel->"Out[54]=",
 CellID->1013779368]
}, Open  ]],

Cell[TextData[{
 "The tensor ",
 Cell[BoxData[GridBox[{
    {"\[EmptyUpTriangle]g", 
     StyleBox[GridBox[{
        {"1", "a", "b"},
        {" ", " ", " "}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.], {
            Offset[0.034999999999999996`]}, 
           Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
            Offset[0.]}}, "RowsIndexed" -> {}}],
      FontSize->9]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.034999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]]],
 " has a first index that labels the perturbation order. Often, it is \
convenient to remove this label. To that end, we define a new tensor that we \
will use as the metric perturbation."
}], "Text",
 CellID->1896045932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefTensor", "[", 
  RowBox[{
   RowBox[{"H", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], ",", "M", ",", 
   RowBox[{"Symmetric", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "a"}], ",", 
      RowBox[{"-", "b"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[56]:=",
 CellID->454582678],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"** \"\>", "\[InvisibleSpace]", "DefTensor", 
   "\[InvisibleSpace]", "\<\": Defining \"\>", 
   "\[InvisibleSpace]", "\<\"tensor \"\>", "\[InvisibleSpace]", 
   RowBox[{"H", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", 
     RowBox[{"-", "b"}]}], "]"}], "\[InvisibleSpace]", "\<\". \"\>", 
   "\[InvisibleSpace]", "\<\"\"\>"}],
  SequenceForm["** ", xAct`xTensor`DefTensor, ": Defining ", "tensor ", 
   $CellContext`H[-$CellContext`a, -$CellContext`b], ". ", ""],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[56]:=",
 CellID->2130984869]
}, Open  ]],

Cell[TextData[{
 "We can now replace ",
 Cell[BoxData[GridBox[{
    {"\[EmptyUpTriangle]g", 
     StyleBox[GridBox[{
        {"1", "a", "b"},
        {" ", " ", " "}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.], {
            Offset[0.034999999999999996`]}, 
           Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
            Offset[0.]}}, "RowsIndexed" -> {}}],
      FontSize->9]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.034999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]]],
 "  with this new tensor:"
}], "Text",
 CellID->334141291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"linearEom", "/.", 
  RowBox[{
   RowBox[{"Perturbationmetric", "[", 
    RowBox[{
     RowBox[{"LI", "[", "1", "]"}], ",", "inds__"}], "]"}], "\[RuleDelayed]", 
   
   RowBox[{"H", "[", "inds", "]"}]}]}]], "Input",
 CellLabel->"In[57]:=",
 CellID->504261089],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     InterpretationBox[
      StyleBox["d",
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`Invar`dim,
      Editable->False]}], ")"}], " ", 
   InterpretationBox[
    StyleBox["\[CapitalLambda]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalLambda],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"H", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`H[$CellContext`a, $CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox["\[CapitalLambda]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalLambda],
      Editable->False], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox["d",
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`Invar`dim,
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[CapitalLambda]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CapitalLambda],
       Editable->False]}]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"H", 
        StyleBox[GridBox[{
           {"c", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`H[$CellContext`c, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metric[$CellContext`a, $CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[EmptyDownTriangle]", "a"], 
       SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"c", " "},
             {" ", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`a][
      $CellContext`CD[$CellContext`b][
       $CellContext`H[$CellContext`c, -$CellContext`c]]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], 
       SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"b", "c"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`a][
       $CellContext`H[$CellContext`b, $CellContext`c]]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], 
       SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"a", "c"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`b][
       $CellContext`H[$CellContext`a, $CellContext`c]]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], 
       SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"a", "b"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`c][
       $CellContext`H[$CellContext`a, $CellContext`b]]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metric[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "d"], 
       SubscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"c", "d"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`d][
      $CellContext`CD[-$CellContext`c][
       $CellContext`H[$CellContext`c, $CellContext`d]]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metric[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "d"], 
       SuperscriptBox["\[EmptyDownTriangle]", "d"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"c", " "},
             {" ", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`d][
      $CellContext`CD[$CellContext`d][
       $CellContext`H[$CellContext`c, -$CellContext`c]]],
     Editable->False], ")"}]}]}]], "Output",
 CellLabel->"Out[57]=",
 CellID->1145651761]
}, Open  ]],

Cell[TextData[{
 "This process of replacing ",
 Cell[BoxData[GridBox[{
    {"\[EmptyUpTriangle]g", 
     StyleBox[GridBox[{
        {"1", "a", "b"},
        {" ", " ", " "}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.], {
            Offset[0.034999999999999996`]}, 
           Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
            Offset[0.]}}, "RowsIndexed" -> {}}],
      FontSize->9]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.034999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]]],
 "  with ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[GridBox[{
      {"H", 
       StyleBox[GridBox[{
          {"a", "b"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`H[$CellContext`a, $CellContext`b],
   Editable->False]]],
 " can be automated by setting another option of ToBackground. The second \
rule below is for eliminating all higher order perturbations."
}], "Text",
 CellID->242940932],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"ToBackground", ",", 
    RowBox[{"ExtraRules", "\[Rule]", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Perturbationmetric", "[", 
         RowBox[{
          RowBox[{"LI", "[", "1", "]"}], ",", "inds__"}], "]"}], 
        "\[RuleDelayed]", 
        RowBox[{"H", "[", "inds", "]"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Perturbationmetric", "[", 
          RowBox[{
           RowBox[{"LI", "[", "x_", "]"}], ",", "__"}], "]"}], "/;", 
         RowBox[{"x", ">", "1"}]}], "\[Rule]", "0"}]}], "\[IndentingNewLine]",
       "}"}]}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[58]:=",
 CellID->1340595283],

Cell[TextData[{
 "Expanding on the background now automatically replaces  ",
 Cell[BoxData[GridBox[{
    {"\[EmptyUpTriangle]g", 
     StyleBox[GridBox[{
        {"1", "a", "b"},
        {" ", " ", " "}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.], {
            Offset[0.034999999999999996`]}, 
           Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
            Offset[0.]}}, "RowsIndexed" -> {}}],
      FontSize->9]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.034999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]]],
 "  with ",
 Cell[BoxData[
  InterpretationBox[
   StyleBox[GridBox[{
      {"H", 
       StyleBox[GridBox[{
          {"a", "b"},
          {" ", " "}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.], {
              Offset[0.034999999999999996`]}, 
             Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
              Offset[0.]}}, "RowsIndexed" -> {}}],
        FontSize->9]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.034999999999999996`]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    ShowAutoStyles->False,
    AutoSpacing->False],
   $CellContext`H[$CellContext`a, $CellContext`b],
   Editable->False]]],
 ":"
}], "Text",
 CellID->741831177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"linearEom", "=", 
  RowBox[{
   RowBox[{"ExpandBackground", "[", "eom", "]"}], "//", 
   "CollectTensors"}]}]], "Input",
 CellLabel->"In[59]:=",
 CellID->689303581],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     InterpretationBox[
      StyleBox["d",
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`Invar`dim,
      Editable->False]}], ")"}], " ", 
   InterpretationBox[
    StyleBox["\[CapitalLambda]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalLambda],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"H", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`H[$CellContext`a, $CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox["\[CapitalLambda]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalLambda],
      Editable->False], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox["d",
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`Invar`dim,
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[CapitalLambda]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CapitalLambda],
       Editable->False]}]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"H", 
        StyleBox[GridBox[{
           {"c", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`H[$CellContext`c, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metric[$CellContext`a, $CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[EmptyDownTriangle]", "a"], 
       SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"c", " "},
             {" ", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`a][
      $CellContext`CD[$CellContext`b][
       $CellContext`H[$CellContext`c, -$CellContext`c]]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], 
       SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"b", "c"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`a][
       $CellContext`H[$CellContext`b, $CellContext`c]]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], 
       SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"a", "c"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`b][
       $CellContext`H[$CellContext`a, $CellContext`c]]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], 
       SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"a", "b"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`c][
       $CellContext`H[$CellContext`a, $CellContext`b]]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metric[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "d"], 
       SubscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"c", "d"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`d][
      $CellContext`CD[-$CellContext`c][
       $CellContext`H[$CellContext`c, $CellContext`d]]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metric[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "d"], 
       SuperscriptBox["\[EmptyDownTriangle]", "d"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"c", " "},
             {" ", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`d][
      $CellContext`CD[$CellContext`d][
       $CellContext`H[$CellContext`c, -$CellContext`c]]],
     Editable->False], ")"}]}]}]], "Output",
 CellLabel->"Out[59]=",
 CellID->1598493949]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Linearizing the action", "Subsection",
 CellID->1262044822],

Cell["\<\
Instead of perturbing the equations of motion, we can also perturb the \
action. Of course, the first non-trivial order here is not the first, but the \
second.\
\>", "Text",
 CellID->1814021004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S", " ", "=", " ", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"-", 
     RowBox[{"Detmetric", "[", "]"}]}], "]"}], "L"}]}]], "Input",
 CellLabel->"In[61]:=",
 CellID->222492348],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{"-", 
    InterpretationBox[
     StyleBox[
      OverscriptBox["g", 
       OverscriptBox[
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]], 
        StyleBox["~",
         FontColor->RGBColor[0, 0, 0]]]],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`Detmetric[],
     Editable->False]}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        InterpretationBox[
         StyleBox["d",
          ShowAutoStyles->False,
          AutoSpacing->False],
         xAct`Invar`dim,
         Editable->False]}], ")"}]}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       InterpretationBox[
        StyleBox["d",
         ShowAutoStyles->False,
         AutoSpacing->False],
        xAct`Invar`dim,
        Editable->False]}], ")"}], " ", 
     InterpretationBox[
      StyleBox["\[CapitalLambda]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalLambda],
      Editable->False]}], "+", 
    InterpretationBox[
     StyleBox[
      RowBox[{"R", "[", "\[EmptyDownTriangle]", "]"}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`RicciScalarCD[],
     Editable->False]}], ")"}]}]], "Output",
 CellLabel->"Out[61]=",
 CellID->718761955]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"linearS", " ", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "2"}], " ", 
    RowBox[{
     RowBox[{"ExpandBackground", "[", 
      RowBox[{"S", ",", "2"}], "]"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"-", 
       RowBox[{"Detmetric", "[", "]"}]}], "]"}]}]}], "//", 
   "CollectTensors"}]}]], "Input",
 CellLabel->"In[66]:=",
 CellID->755663758],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     InterpretationBox[
      StyleBox["d",
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`Invar`dim,
      Editable->False]}], ")"}], " ", 
   InterpretationBox[
    StyleBox["\[CapitalLambda]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalLambda],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"H", 
        StyleBox[GridBox[{
           {" ", " "},
           {"a", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`H[-$CellContext`a, -$CellContext`b],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"H", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`H[$CellContext`a, $CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox["\[CapitalLambda]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalLambda],
      Editable->False], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox["d",
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`Invar`dim,
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[CapitalLambda]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CapitalLambda],
       Editable->False]}]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"H", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`H[$CellContext`a, -$CellContext`a],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"H", 
        StyleBox[GridBox[{
           {"b", " "},
           {" ", "b"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`H[$CellContext`b, -$CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"H", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`H[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "b"], 
       SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"c", " "},
             {" ", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`b][
      $CellContext`CD[-$CellContext`a][
       $CellContext`H[$CellContext`c, -$CellContext`c]]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"H", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`H[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "b"], 
       SubscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {" ", "c"},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`b][
      $CellContext`CD[-$CellContext`c][
       $CellContext`H[-$CellContext`a, $CellContext`c]]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"c", " "},
             {" ", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`b][
      $CellContext`H[$CellContext`c, -$CellContext`c]],
     Editable->False], ")"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"a", " "},
             {" ", "a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`b][
      $CellContext`H[$CellContext`a, -$CellContext`a]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"a", "b"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`a][
      $CellContext`H[$CellContext`a, $CellContext`b]],
     Editable->False], ")"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {" ", "c"},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`H[-$CellContext`b, $CellContext`c]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"a", " "},
             {" ", "a"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`b][
      $CellContext`H[$CellContext`a, -$CellContext`a]],
     Editable->False], ")"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {" ", "c"},
             {"b", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`H[-$CellContext`b, $CellContext`c]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"H", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`H[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], 
       SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {" ", "c"},
             {"a", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[-$CellContext`b][
       $CellContext`H[-$CellContext`a, $CellContext`c]]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"H", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`H[$CellContext`a, -$CellContext`a],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], 
       SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"b", "c"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[-$CellContext`b][
       $CellContext`H[$CellContext`b, $CellContext`c]]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {"H", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`H[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], 
       SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`c][
       $CellContext`H[-$CellContext`a, -$CellContext`b]]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"H", 
        StyleBox[GridBox[{
           {"a", " "},
           {" ", "a"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`H[$CellContext`a, -$CellContext`a],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], 
       SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"b", " "},
             {" ", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`c][
       $CellContext`H[$CellContext`b, -$CellContext`b]]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`b][
      $CellContext`H[-$CellContext`a, -$CellContext`c]],
     Editable->False], ")"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"a", "b"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`c][
      $CellContext`H[$CellContext`a, $CellContext`b]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   FractionBox["3", "4"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {" ", " "},
             {"a", "b"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`H[-$CellContext`a, -$CellContext`b]],
     Editable->False], ")"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"a", "b"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`c][
      $CellContext`H[$CellContext`a, $CellContext`b]],
     Editable->False], ")"}]}]}]], "Output",
 CellLabel->"Out[66]=",
 CellID->164914733]
}, Open  ]],

Cell[TextData[{
 "When we vary the linear action with respect to ",
 Cell[BoxData[GridBox[{
    {"H", 
     StyleBox[GridBox[{
        {" ", " "},
        {"a", "b"}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.], {
            Offset[0.034999999999999996`]}, 
           Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
            Offset[0.]}}, "RowsIndexed" -> {}}],
      FontSize->9]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.034999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]]],
 ", we should obtain the linearized equations of motion:"
}], "Text",
 CellID->425677769],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"VarD", "[", 
    RowBox[{
     RowBox[{"H", "[", 
      RowBox[{
       RowBox[{"-", "a"}], ",", 
       RowBox[{"-", "b"}]}], "]"}], ",", "CD"}], "]"}], "[", "linearS", "]"}],
   "//", "CollectTensors"}]], "Input",
 CellLabel->"In[67]:=",
 CellID->1035744935],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     InterpretationBox[
      StyleBox["d",
       ShowAutoStyles->False,
       AutoSpacing->False],
      xAct`Invar`dim,
      Editable->False]}], ")"}], " ", 
   InterpretationBox[
    StyleBox["\[CapitalLambda]",
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`\[CapitalLambda],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"H", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`H[$CellContext`a, $CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     InterpretationBox[
      StyleBox["\[CapitalLambda]",
       ShowAutoStyles->False,
       AutoSpacing->False],
      $CellContext`\[CapitalLambda],
      Editable->False], "-", 
     RowBox[{
      InterpretationBox[
       StyleBox["d",
        ShowAutoStyles->False,
        AutoSpacing->False],
       xAct`Invar`dim,
       Editable->False], " ", 
      InterpretationBox[
       StyleBox["\[CapitalLambda]",
        ShowAutoStyles->False,
        AutoSpacing->False],
       $CellContext`\[CapitalLambda],
       Editable->False]}]}], ")"}], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"H", 
        StyleBox[GridBox[{
           {"c", " "},
           {" ", "c"}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`H[$CellContext`c, -$CellContext`c],
    Editable->False], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metric[$CellContext`a, $CellContext`b],
    Editable->False]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[EmptyDownTriangle]", "a"], 
       SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"c", " "},
             {" ", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`a][
      $CellContext`CD[$CellContext`b][
       $CellContext`H[$CellContext`c, -$CellContext`c]]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[EmptyDownTriangle]", "b"], 
       SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"c", " "},
             {" ", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`b][
      $CellContext`CD[$CellContext`a][
       $CellContext`H[$CellContext`c, -$CellContext`c]]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], 
       SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"b", "c"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`a][
       $CellContext`H[$CellContext`b, $CellContext`c]]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], 
       SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"a", "c"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`b][
       $CellContext`H[$CellContext`a, $CellContext`c]]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "c"], 
       SuperscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"a", "b"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`c][
      $CellContext`CD[$CellContext`c][
       $CellContext`H[$CellContext`a, $CellContext`b]]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metric[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "d"], 
       SubscriptBox["\[EmptyDownTriangle]", "c"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"c", "d"},
             {" ", " "}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`d][
      $CellContext`CD[-$CellContext`c][
       $CellContext`H[$CellContext`c, $CellContext`d]]],
     Editable->False], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   InterpretationBox[
    StyleBox[GridBox[{
       {"g", 
        StyleBox[GridBox[{
           {"a", "b"},
           {" ", " "}
          },
          GridBoxSpacings->{"Columns" -> {
              Offset[0.], {
               Offset[0.034999999999999996`]}, 
              Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
               Offset[0.]}}, "RowsIndexed" -> {}}],
         FontSize->9]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Center}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.034999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     ShowAutoStyles->False,
     AutoSpacing->False],
    $CellContext`metric[$CellContext`a, $CellContext`b],
    Editable->False], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SubscriptBox["\[EmptyDownTriangle]", "d"], 
       SuperscriptBox["\[EmptyDownTriangle]", "d"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"c", " "},
             {" ", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[-$CellContext`d][
      $CellContext`CD[$CellContext`d][
       $CellContext`H[$CellContext`c, -$CellContext`c]]],
     Editable->False], ")"}]}]}]], "Output",
 CellLabel->"Out[67]=",
 CellID->1468012901]
}, Open  ]],

Cell["The difference between the two equations of motion is zero:", "Text",
 CellID->420858817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "-", "linearEom"}], "//", "CollectTensors"}]], "Input",
 CellLabel->"In[68]:=",
 CellID->692668160],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "4"]}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[EmptyDownTriangle]", "a"], 
       SuperscriptBox["\[EmptyDownTriangle]", "b"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"c", " "},
             {" ", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`a][
      $CellContext`CD[$CellContext`b][
       $CellContext`H[$CellContext`c, -$CellContext`c]]],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    InterpretationBox[
     StyleBox[
      RowBox[{
       SuperscriptBox["\[EmptyDownTriangle]", "b"], 
       SuperscriptBox["\[EmptyDownTriangle]", "a"], GridBox[{
         {"H", 
          StyleBox[GridBox[{
             {"c", " "},
             {" ", "c"}
            },
            GridBoxSpacings->{"Columns" -> {
                Offset[0.], {
                 Offset[0.034999999999999996`]}, 
                Offset[0.]}, "ColumnsIndexed" -> {}, "Rows" -> {{
                 Offset[0.]}}, "RowsIndexed" -> {}}],
           FontSize->9]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Center}}, "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.034999999999999996`]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}],
      ShowAutoStyles->False,
      AutoSpacing->False],
     $CellContext`CD[$CellContext`b][
      $CellContext`CD[$CellContext`a][
       $CellContext`H[$CellContext`c, -$CellContext`c]]],
     Editable->False], ")"}]}]}]], "Output",
 CellLabel->"Out[68]=",
 CellID->453206724]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "SortCovDs"}]], "Input",
 CellLabel->"In[69]:=",
 CellID->2068398006],

Cell[BoxData["0"], "Output",
 CellLabel->"Out[69]=",
 CellID->100009206]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellID->909278830]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "RelatedTutorialsSection",
 WholeCellGroupOpener->True,
 CellElementSpacings->{"CellMinHeight"->3},
 CellFrameLabels->{{
    FEPrivate`If[
     FEPrivate`Or[
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
      FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 
     Cell[
     "RELATED TUTORIALS", "RelatedTutorialsSection", 
      CellSize -> {5000, Inherited}], 
     Cell[
      TextData[{
        Cell[
         BoxData[
          InterpretationBox[
           StyleBox[
            
            GraphicsBox[{}, ImageSize -> {24, 0}, BaselinePosition -> 
             Baseline], "CacheGraphics" -> False], 
           Spacer[24]]]], "Related Tutorials"}], "RelatedTutorialsSection", 
      CellSize -> {5000, Inherited}]], None}, {None, None}},
 CellFrameLabelMargins->0,
 CellSize->{Inherited, 
   FEPrivate`If[
    FEPrivate`Or[
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
     FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 11, 14]},
 CellID->415694126],

Cell["", "SectionHeaderSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]],

Cell[TextData[ButtonBox["Metric Variations",
 BaseStyle->"Link",
 ButtonData->"paclet:xTras/tutorial/MetricVariations"]], "RelatedTutorials",
 CellID->806871991],

Cell["", "SectionFooterSpacer",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 ShowSelection->False,
 CellMargins->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 0, Inherited],
 CellElementSpacings->{"CellMinHeight"->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], 1, Inherited]},
 CellSize->FEPrivate`If[
   FEPrivate`Or[
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "6.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "7.0"], 
    FEPrivate`SameQ[FEPrivate`$ProductVersion, "8.0"]], {Inherited, 1}, 
   Inherited]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AdS Perturbations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "ColorType" -> "TutorialColor", 
  "LinkTrails" -> GridBox[{{
      RowBox[{
        ButtonBox[
        "xTras package", ButtonData -> "paclet:xTras/guide/xTras", 
         BaseStyle -> {"Link", "DockedLinkTrail"}], 
        Cell[">", "DockedLinkTrailSeparator"]}]}}, ColumnAlignments -> Left], 
  "Metadata" -> {
   "built" -> "{2014, 10, 30, 13, 18, 14.009395}", 
    "history" -> {"1.1", "", "", ""}, "context" -> "xTras`", "keywords" -> {},
     "specialkeywords" -> {}, "tutorialcollectionlinks" -> {}, "index" -> 
    True, "label" -> "xTras Tutorial", "language" -> "en", "paclet" -> 
    "xTras", "status" -> "None", "summary" -> 
    "xTras has a number of functions that allow for perturbations around \
(A)dS backgrounds. Before discussing them, we'll first have a look at the \
basic functionality provided in the native xAct package xPert. Main xPert \
functions. Expression can be perturbed with Perturbation:", "synonyms" -> {}, 
    "title" -> "AdS Perturbations", "titlemodifier" -> "", "windowtitle" -> 
    "AdS Perturbations", "type" -> "Tutorial", "uri" -> 
    "xTras/tutorial/AdSPerturbations"}, "SearchTextTranslated" -> ""},
FrontEndVersion -> "6.0",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> Notebook], 
   Cell[
    StyleData["Output"], CellContext -> Notebook], 
   Cell[
    StyleData["TutorialMoreAboutSection"], 
    CellGroupingRules -> {"SectionGrouping", 30}], 
   Cell[
    StyleData["RelatedTutorialsSection"], 
    CellGroupingRules -> {"SectionGrouping", 30}], 
   Cell[
    StyleData["TutorialRelatedLinksSection"], 
    CellGroupingRules -> {"SectionGrouping", 30}]}, Visible -> False, 
  FrontEndVersion -> "6.0", 
  StyleDefinitions -> "Default.nb"]
]

